/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "poplistdelegate.h"

PopListDelegate::PopListDelegate(QWidget* parent) : QStyledItemDelegate (parent)
{

}

// 委托类，主要绘制鼠标划过时候的状态
void PopListDelegate::paint(QPainter *painter, const QStyleOptionViewItem& option,const QModelIndex& index) const{
    painter->save();

    painter->setRenderHint(QPainter::Antialiasing);  // 反锯齿;
    painter->setPen(Qt::transparent);
    QRect rect(option.rect);
    rect.setWidth(rect.width() - 1);
    rect.setHeight(rect.height() - 1);

    if(option.state.testFlag(QStyle::State_MouseOver)) {
        QColor hoverColor(44, 167, 248);
        painter->setBrush(QBrush(hoverColor));
        painter->drawRoundedRect(rect, 4, 4);
    }

    QPalette pal;
    QBrush brush = pal.buttonText();
    QColor textColor = brush.color();
    if(option.state.testFlag(QStyle::State_MouseOver)) {
        textColor = Qt::white;
    }

    painter->setPen(QPen(textColor));
    QString text = index.model()->data(index, Qt::DisplayRole).toString();
    painter->drawText(QRect(rect.x() + 8,rect.y(),rect.width(),rect.height()), Qt::AlignLeft | Qt::AlignVCenter, text);
    painter->restore();
}
