/* BEGIN_COMMON_COPYRIGHT_HEADER
 * (c)LGPL2+
 *
 * LXQt - a lightweight, Qt based, desktop toolset
 * https://lxqt.org
 *
 * Copyright: 2015 LXQt team
 * Authors:
 *  Balázs Béla <balazsbela[at]gmail.com>
 *  Paulo Lieuthier <paulolieuthier@gmail.com>
 *
 * This program or library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * END_COMMON_COPYRIGHT_HEADER */

#ifndef STATUSNOTIFIERBUTTON_H
#define STATUSNOTIFIERBUTTON_H
#include "../panel/iukuipanelplugin.h"

#include <QDBusArgument>
#include <QDBusMessage>
#include <QDBusInterface>
#include <QMimeData>
#include <QMouseEvent>
#include <QToolButton>
#include <QWheelEvent>
#include <QEvent>
#include <QMenu>
#include <QString>
#include <QGSettings>
#include <dbusmenu-qt5/dbusmenuimporter.h>
#include "statusnotifierbuttonabstract.h"

#define ORG_UKUI_STYLE  "org.ukui.style"
#define ICON_THEME_NAME "iconThemeName"
#define STYLE_NAME "styleName"
#define STYLE_NAME_KEY_DARK       "ukui-dark"
#define STYLE_NAME_KEY_BLACK       "ukui-black"
#define STYLE_NAME_KEY_LIGHT       "ukui-light"
#define STYLE_NAME_KEY_WHITE       "ukui-white"
#define STYLE_NAME_KEY_DEFAULT    "ukui-default"


#if QT_VERSION < QT_VERSION_CHECK(5, 5, 0)
template <typename T> inline T qFromUnaligned(const uchar *src)
{
    T dest;
    const size_t size = sizeof(T);
    memcpy(&dest, src, size);
    return dest;
}
#endif

/*! \brief specialized DBusMenuImporter to correctly create actions' icons based
 * on name
 */
class MenuImporter : public DBusMenuImporter
{
public:
    using DBusMenuImporter::DBusMenuImporter;

protected:
    virtual QIcon iconForName(const QString & name) override
    {
        return QIcon::fromTheme(name);
    }
};


class IUKUIPanelPlugin;
class SniAsync;
class MenuImporter;

class StatusNotifierButton : public StatusNotifierButtonAbstract
{
    Q_OBJECT

public:
    StatusNotifierButton(QString service, QString objectPath, IUKUIPanelPlugin* plugin,  QWidget *parent = 0);
    ~StatusNotifierButton();
    QString getTypeName() override {return QString("Item");}

    enum Status{PASSIVE=0, ACTIVE, NEEDSATTENTION};
    enum ActionArea{UNDEFINED=0,STORAGE,SHOW,FIXED};
    QString hideAbleStatusNotifierButton();
    int getStatus();
    bool getFoldState();
    void setFoldState(bool status);
    int getActionArea();
    void setActionArea(int actionArea);
    static QString mimeDataFormat() { return QLatin1String("x-ukui/statusnotifier-button"); }

public slots:
    void newIcon();
    void newAttentionIcon();
    void newOverlayIcon();
    void newToolTip();
    void newStatus(QString status);

public:
    QString m_id;
    bool m_idStatus=false;
    bool m_iconStatus=false;
    QString m_toolTipTitle;

private:
    SniAsync *m_interface;
    MenuImporter *m_menuImporter;
    QMenu *m_menu;
    Status m_status;
    QString m_themePath;
    QIcon m_icon, m_overlayIcon, m_attentionIcon, m_fallbackIcon;
    QPixmap m_iconPixmap;

    bool m_foldState;
    int m_actionArea = UNDEFINED;

    QPoint m_dragStart;

    IUKUIPanelPlugin* m_plugin;

    uint m_count = 0; //使用静态变量，节省内存空间
    bool m_paramInit=false;
    QGSettings *m_themeSettings = nullptr;
    QPoint m_cursorLeftPos;
    const qreal m_blackHoverBtnAlphaF = 0.1;  //深色主题下按钮悬停和按下透明度
    const qreal m_blackPressBtnAlphaF = 0.05;
    const qreal m_lightHoverBtnAlphaF = 0.05;  //浅色主题下按钮悬停和按下透明度
    const qreal m_lightPressBtnAlphaF = 0.1;

signals:
    void switchButtons(StatusNotifierButtonAbstract *from, StatusNotifierButtonAbstract *to);
    void sendTitle(QString arg);
    void sendstatus(QString arg);
    void cleanSignal();
    void iconReady();
    void layoutReady();
    void layoutUpdate();
    void paramReady();

protected:
    void contextMenuEvent(QContextMenuEvent * event);
    void mouseReleaseEvent(QMouseEvent *event);
    void wheelEvent(QWheelEvent *event);
    void dragEnterEvent(QDragEnterEvent *e);
    void dragLeaveEvent(QDragLeaveEvent *e);
    void dragMoveEvent(QDragMoveEvent * e);
    void mouseMoveEvent(QMouseEvent *e);
    void mousePressEvent(QMouseEvent *e);
    bool event(QEvent *e);
    virtual QMimeData * mimeData();
    void resizeEvent(QResizeEvent *event);
    void enterEvent(QEvent *event);
    void leaveEvent(QEvent *event);
    void paintEvent(QPaintEvent *event);

    void refetchIcon(Status status);
    void resetIcon();

private:
    void systemThemeChanges();
    void updataItemMenu();
    void setHoverBtnProperty();
    void setPressBtnProperty();
    QImage getBlackThemeIcon(QImage image);

};

class StatusNotifierButtonMimeData: public QMimeData
{
    Q_OBJECT
public:
    StatusNotifierButtonMimeData():
        QMimeData(),
        m_button(0)
    {
    }

    StatusNotifierButton *button() const { return m_button; }
    void setButton(StatusNotifierButton *button) { m_button = button; }

private:
    StatusNotifierButton *m_button;
};

#endif // STATUSNOTIFIERBUTTON_H
