/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "globalconfig.h"

GlobalConfig::GlobalConfig(QObject *parent):
    QObject(parent)
{

}

GlobalConfig::~GlobalConfig()
{

}

//__import__('gi.repository.GLib', globals(), locals(), ['Variant']).Variant("s","aaa")
bool GlobalConfig::setGlobalConf(QString schema, QString key, QDBusVariant value)
{
    QDir dirCheck;
    QString usdDir = QString("/etc/ukui");
    QString configDir = QString("/etc/ukui/usd");
    QString configFile = QString("/etc/ukui/usd/globalconf.ini");
    if (!dirCheck.exists(usdDir)) {
        dirCheck.mkdir(usdDir);

        QFile file(usdDir);
        file.setPermissions(QFileDevice::Permission(0x6666));
        file.close();
    }

    if (!dirCheck.exists(configDir)) {
        dirCheck.mkdir(configDir);
    }

    QFile file(configDir);
    file.setPermissions(QFileDevice::Permission(0x6666));
    file.close();

    QSettings *usdSettings = new QSettings(configFile, QSettings::IniFormat);
    usdSettings->beginGroup(schema);
    usdSettings->setValue(key, value.variant());
    usdSettings->endGroup();
    usdSettings->sync();
    usdSettings->deleteLater();

    QFile::setPermissions(configFile,QFileDevice::Permission(0x6666));

    return true;
}

bool GlobalConfig::setGlobalConf1(QString schema, QString key, QString value)
{
    return false;
}

QDBusVariant GlobalConfig::getGlobalConf(QString schema, QString key)
{
    QVariant value;
    QString configFile = QString("/etc/ukui/usd/globalconf.ini");
    QFile conf(configFile);
    if(!conf.exists()) {
        return QDBusVariant(0);
    }
    QSettings *usdSettings = new QSettings(configFile, QSettings::IniFormat);
    usdSettings->beginGroup(schema);
    value = usdSettings->value(key);
    if (!value.isValid()) {
        return QDBusVariant(0);
    }
    usdSettings->endGroup();
    usdSettings->sync();
    usdSettings->deleteLater();
    return (QDBusVariant)value;
}
