/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
typedef struct _ValaTypeSymbolPrivate ValaTypeSymbolPrivate;
typedef struct _ValaObjectTypeSymbolPrivate ValaObjectTypeSymbolPrivate;
typedef struct _ValaClassPrivate ValaClassPrivate;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessor ValaPropertyAccessor;
typedef struct _ValaPropertyAccessorClass ValaPropertyAccessorClass;

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_PARAMETER (vala_parameter_get_type ())
#define VALA_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PARAMETER, ValaParameter))
#define VALA_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PARAMETER, ValaParameterClass))
#define VALA_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PARAMETER))
#define VALA_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PARAMETER))
#define VALA_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PARAMETER, ValaParameterClass))

typedef struct _ValaParameter ValaParameter;
typedef struct _ValaParameterClass ValaParameterClass;

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_OBJECT_TYPE (vala_object_type_get_type ())
#define VALA_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectType))
#define VALA_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))
#define VALA_IS_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE))
#define VALA_IS_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE))
#define VALA_OBJECT_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))

typedef struct _ValaObjectType ValaObjectType;
typedef struct _ValaObjectTypeClass ValaObjectTypeClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

#define VALA_TYPE_SOURCE_FILE_TYPE (vala_source_file_type_get_type ())

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaTypeSymbol {
	ValaSymbol parent_instance;
	ValaTypeSymbolPrivate * priv;
};

struct _ValaTypeSymbolClass {
	ValaSymbolClass parent_class;
	gboolean (*is_reference_type) (ValaTypeSymbol* self);
	gboolean (*is_subtype_of) (ValaTypeSymbol* self, ValaTypeSymbol* t);
	gint (*get_type_parameter_index) (ValaTypeSymbol* self, const gchar* name);
};

struct _ValaObjectTypeSymbol {
	ValaTypeSymbol parent_instance;
	ValaObjectTypeSymbolPrivate * priv;
};

struct _ValaObjectTypeSymbolClass {
	ValaTypeSymbolClass parent_class;
	ValaList* (*get_methods) (ValaObjectTypeSymbol* self);
	ValaList* (*get_signals) (ValaObjectTypeSymbol* self);
	ValaList* (*get_properties) (ValaObjectTypeSymbol* self);
};

struct _ValaClass {
	ValaObjectTypeSymbol parent_instance;
	ValaClassPrivate * priv;
};

struct _ValaClassClass {
	ValaObjectTypeSymbolClass parent_class;
};

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_immutable;
	ValaList* base_types;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* properties;
	ValaList* signals;
	ValaList* classes;
	ValaList* structs;
	ValaList* enums;
	ValaList* delegates;
	ValaMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _static_destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _destructor;
};

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;

typedef enum  {
	VALA_SOURCE_FILE_TYPE_NONE,
	VALA_SOURCE_FILE_TYPE_SOURCE,
	VALA_SOURCE_FILE_TYPE_PACKAGE,
	VALA_SOURCE_FILE_TYPE_FAST
} ValaSourceFileType;


static gpointer vala_class_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
#define VALA_CLASS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS, ValaClassPrivate))
enum  {
	VALA_CLASS_DUMMY_PROPERTY
};
ValaList* vala_class_get_classes (ValaClass* self);
ValaList* vala_class_get_structs (ValaClass* self);
ValaList* vala_class_get_enums (ValaClass* self);
ValaList* vala_class_get_delegates (ValaClass* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaClass* vala_class_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaClass* vala_class_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaObjectTypeSymbol* vala_object_type_symbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_class_add_base_type (ValaClass* self, ValaDataType* type);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
ValaList* vala_class_get_base_types (ValaClass* self);
static void vala_class_real_add_constant (ValaSymbol* base, ValaConstant* c);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const gchar* name, ValaSymbol* sym);
const gchar* vala_symbol_get_name (ValaSymbol* self);
static void vala_class_real_add_field (ValaSymbol* base, ValaField* f);
ValaCodeContext* vala_code_context_get (void);
GType vala_profile_get_type (void) G_GNUC_CONST;
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
GType vala_member_binding_get_type (void) G_GNUC_CONST;
ValaMemberBinding vala_field_get_binding (ValaField* self);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaComment* vala_symbol_get_comment (ValaSymbol* self);
GType vala_property_accessor_get_type (void) G_GNUC_CONST;
ValaProperty* vala_property_new (const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment);
ValaProperty* vala_property_construct (GType object_type, const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment);
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
ValaDataType* vala_property_get_property_type (ValaProperty* self);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
GType vala_block_get_type (void) G_GNUC_CONST;
ValaPropertyAccessor* vala_property_accessor_new (gboolean readable, gboolean writable, gboolean construction, ValaDataType* value_type, ValaBlock* body, ValaSourceReference* source_reference, ValaComment* comment);
ValaPropertyAccessor* vala_property_accessor_construct (GType object_type, gboolean readable, gboolean writable, gboolean construction, ValaDataType* value_type, ValaBlock* body, ValaSourceReference* source_reference, ValaComment* comment);
void vala_property_set_get_accessor (ValaProperty* self, ValaPropertyAccessor* value);
void vala_property_set_set_accessor (ValaProperty* self, ValaPropertyAccessor* value);
void vala_symbol_set_name (ValaSymbol* self, const gchar* value);
void vala_property_set_field (ValaProperty* self, ValaField* value);
void vala_symbol_add_property (ValaSymbol* self, ValaProperty* prop);
void vala_class_set_has_private_fields (ValaClass* self, gboolean value);
static void vala_class_set_has_class_private_fields (ValaClass* self, gboolean value);
ValaList* vala_class_get_fields (ValaClass* self);
ValaList* vala_class_get_constants (ValaClass* self);
static void vala_class_real_add_method (ValaSymbol* base, ValaMethod* m);
ValaMemberBinding vala_method_get_binding (ValaMethod* self);
GType vala_creation_method_get_type (void) G_GNUC_CONST;
GType vala_parameter_get_type (void) G_GNUC_CONST;
ValaParameter* vala_method_get_this_parameter (ValaMethod* self);
void vala_scope_remove (ValaScope* self, const gchar* name);
GType vala_reference_type_get_type (void) G_GNUC_CONST;
GType vala_object_type_get_type (void) G_GNUC_CONST;
ValaObjectType* vala_object_type_symbol_get_this_type (ValaObjectTypeSymbol* self);
ValaParameter* vala_parameter_new (const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
ValaParameter* vala_parameter_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
void vala_method_set_this_parameter (ValaMethod* self, ValaParameter* value);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
GType vala_void_type_get_type (void) G_GNUC_CONST;
ValaList* vala_method_get_postconditions (ValaMethod* self);
GType vala_local_variable_get_type (void) G_GNUC_CONST;
ValaLocalVariable* vala_subroutine_get_result_var (ValaSubroutine* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference);
void vala_subroutine_set_result_var (ValaSubroutine* self, ValaLocalVariable* value);
void vala_local_variable_set_is_result (ValaLocalVariable* self, gboolean value);
void vala_class_set_default_construction_method (ValaClass* self, ValaMethod* value);
const gchar* vala_creation_method_get_class_name (ValaCreationMethod* self);
void vala_report_error (ValaSourceReference* source, const gchar* message);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
static ValaList* vala_class_real_get_methods (ValaObjectTypeSymbol* base);
static void vala_class_real_add_property (ValaSymbol* base, ValaProperty* prop);
void vala_property_set_this_parameter (ValaProperty* self, ValaParameter* value);
ValaParameter* vala_property_get_this_parameter (ValaProperty* self);
ValaField* vala_property_get_field (ValaProperty* self);
void vala_symbol_add_field (ValaSymbol* self, ValaField* f);
static ValaList* vala_class_real_get_properties (ValaObjectTypeSymbol* base);
static void vala_class_real_add_signal (ValaSymbol* base, ValaSignal* sig);
static ValaList* vala_class_real_get_signals (ValaObjectTypeSymbol* base);
static void vala_class_real_add_class (ValaSymbol* base, ValaClass* cl);
static void vala_class_real_add_struct (ValaSymbol* base, ValaStruct* st);
static void vala_class_real_add_enum (ValaSymbol* base, ValaEnum* en);
static void vala_class_real_add_delegate (ValaSymbol* base, ValaDelegate* d);
static void vala_class_real_add_constructor (ValaSymbol* base, ValaConstructor* c);
ValaMemberBinding vala_constructor_get_binding (ValaConstructor* self);
ValaConstructor* vala_class_get_constructor (ValaClass* self);
void vala_class_set_constructor (ValaClass* self, ValaConstructor* value);
ValaConstructor* vala_class_get_class_constructor (ValaClass* self);
void vala_class_set_class_constructor (ValaClass* self, ValaConstructor* value);
ValaConstructor* vala_class_get_static_constructor (ValaClass* self);
void vala_class_set_static_constructor (ValaClass* self, ValaConstructor* value);
static void vala_class_real_add_destructor (ValaSymbol* base, ValaDestructor* d);
ValaMemberBinding vala_destructor_get_binding (ValaDestructor* self);
ValaDestructor* vala_class_get_destructor (ValaClass* self);
void vala_class_set_destructor (ValaClass* self, ValaDestructor* value);
ValaDestructor* vala_class_get_class_destructor (ValaClass* self);
void vala_class_set_class_destructor (ValaClass* self, ValaDestructor* value);
ValaDestructor* vala_class_get_static_destructor (ValaClass* self);
void vala_class_set_static_destructor (ValaClass* self, ValaDestructor* value);
static void vala_class_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_class (ValaCodeVisitor* self, ValaClass* cl);
static void vala_class_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
GType vala_typeparameter_get_type (void) G_GNUC_CONST;
ValaList* vala_object_type_symbol_get_type_parameters (ValaObjectTypeSymbol* self);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
gboolean vala_class_is_fundamental (ValaClass* self);
gboolean vala_class_get_is_compact (ValaClass* self);
ValaClass* vala_class_get_base_class (ValaClass* self);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
gboolean vala_typesymbol_is_subtype_of (ValaTypeSymbol* self, ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self, ValaInterface* iface, ValaList* list);
ValaList* vala_interface_get_prerequisites (ValaInterface* self);
static gboolean vala_class_class_is_a (ValaClass* self, ValaClass* cl, ValaTypeSymbol* t);
static gboolean vala_class_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
ValaSemanticAnalyzer* vala_code_context_get_analyzer (ValaCodeContext* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
gchar* vala_code_node_to_string (ValaCodeNode* self);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
ValaList* vala_data_type_get_type_arguments (ValaDataType* self);
gboolean vala_symbol_get_external (ValaSymbol* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
GType vala_source_file_type_get_type (void) G_GNUC_CONST;
ValaSourceFileType vala_symbol_get_source_type (ValaSymbol* self);
ValaList* vala_object_type_symbol_get_methods (ValaObjectTypeSymbol* self);
gboolean vala_method_get_is_abstract (ValaMethod* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const gchar* name);
gboolean vala_symbol_check_deprecated (ValaSymbol* self, ValaSourceReference* source_ref);
gboolean vala_symbol_check_experimental (ValaSymbol* self, ValaSourceReference* source_ref);
void vala_symbol_set_used (ValaSymbol* self, gboolean value);
ValaList* vala_object_type_symbol_get_properties (ValaObjectTypeSymbol* self);
gboolean vala_property_get_is_abstract (ValaProperty* self);
gboolean vala_class_get_is_abstract (ValaClass* self);
ValaSymbol* vala_semantic_analyzer_symbol_lookup_inherited (ValaSymbol* sym, const gchar* name);
gboolean vala_method_get_overrides (ValaMethod* self);
gboolean vala_property_get_overrides (ValaProperty* self);
void vala_class_set_base_class (ValaClass* self, ValaClass* value);
void vala_class_set_is_abstract (ValaClass* self, gboolean value);
static gboolean* _bool_dup (gboolean* self);
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const gchar* name);
void vala_class_set_is_compact (ValaClass* self, gboolean value);
void vala_code_node_set_attribute (ValaCodeNode* self, const gchar* name, gboolean value, ValaSourceReference* source_reference);
gboolean vala_class_get_is_immutable (ValaClass* self);
void vala_class_set_is_immutable (ValaClass* self, gboolean value);
gboolean vala_class_get_has_private_fields (ValaClass* self);
gboolean vala_class_get_has_class_private_fields (ValaClass* self);
ValaMethod* vala_class_get_default_construction_method (ValaClass* self);
ValaParameter* vala_destructor_get_this_parameter (ValaDestructor* self);
void vala_destructor_set_this_parameter (ValaDestructor* self, ValaParameter* value);
gboolean vala_class_get_is_error_base (ValaClass* self);
static void vala_class_finalize (ValaCodeNode* obj);


/**
 * Returns a copy of the list of classes.
 *
 * @return list of classes
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_class_get_classes (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->classes;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of structs.
 *
 * @return list of structs
 */
ValaList* vala_class_get_structs (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->structs;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of enums.
 *
 * @return list of enums
 */
ValaList* vala_class_get_enums (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->enums;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of delegates.
 *
 * @return list of delegates
 */
ValaList* vala_class_get_delegates (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->delegates;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Creates a new class.
 *
 * @param name   type name
 * @param source reference to source code
 * @param comment class documentation
 * @return       newly created class
 */
ValaClass* vala_class_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaClass* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaComment* _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	_tmp2_ = comment;
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	return self;
}


ValaClass* vala_class_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}


/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void vala_class_add_base_type (ValaClass* self, ValaDataType* type) {
	ValaList* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	_tmp1_ = type;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
ValaList* vala_class_get_base_types (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified constant as a member to this class.
 *
 * @param c a constant
 */
static void vala_class_real_add_constant (ValaSymbol* base, ValaConstant* c) {
	ValaClass * self;
	ValaList* _tmp0_;
	ValaConstant* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaConstant* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaConstant* _tmp7_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = c;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = c;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = c;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void vala_class_real_add_field (ValaSymbol* base, ValaField* f) {
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ValaCodeContext* _tmp3_ = NULL;
	ValaCodeContext* _tmp4_;
	ValaProfile _tmp5_;
	ValaProfile _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp11_;
	gboolean _tmp20_;
	gboolean _tmp23_;
	ValaList* _tmp76_;
	ValaField* _tmp77_;
	gboolean _tmp78_ = FALSE;
	ValaField* _tmp79_;
	ValaSymbolAccessibility _tmp80_;
	ValaSymbolAccessibility _tmp81_;
	gboolean _tmp85_;
	ValaScope* _tmp94_;
	ValaScope* _tmp95_;
	ValaField* _tmp96_;
	const gchar* _tmp97_;
	const gchar* _tmp98_;
	ValaField* _tmp99_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	_tmp3_ = vala_code_context_get ();
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_code_context_get_profile (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_ == VALA_PROFILE_DOVA;
	_vala_code_context_unref0 (_tmp4_);
	if (_tmp7_) {
		ValaField* _tmp8_;
		ValaMemberBinding _tmp9_;
		ValaMemberBinding _tmp10_;
		_tmp8_ = f;
		_tmp9_ = vala_field_get_binding (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp2_ = _tmp10_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp11_ = _tmp2_;
	if (_tmp11_) {
		gboolean _tmp12_ = FALSE;
		ValaField* _tmp13_;
		ValaSymbolAccessibility _tmp14_;
		ValaSymbolAccessibility _tmp15_;
		gboolean _tmp19_;
		_tmp13_ = f;
		_tmp14_ = vala_symbol_get_access ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
			_tmp12_ = TRUE;
		} else {
			ValaField* _tmp16_;
			ValaSymbolAccessibility _tmp17_;
			ValaSymbolAccessibility _tmp18_;
			_tmp16_ = f;
			_tmp17_ = vala_symbol_get_access ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp12_ = _tmp18_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
		}
		_tmp19_ = _tmp12_;
		_tmp1_ = _tmp19_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp20_ = _tmp1_;
	if (_tmp20_) {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		_tmp0_ = g_strcmp0 (_tmp22_, "any") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp23_ = _tmp0_;
	if (_tmp23_) {
		ValaField* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		ValaField* _tmp27_;
		ValaDataType* _tmp28_;
		ValaDataType* _tmp29_;
		ValaDataType* _tmp30_ = NULL;
		ValaDataType* _tmp31_;
		ValaField* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaSourceReference* _tmp34_;
		ValaComment* _tmp35_;
		ValaComment* _tmp36_;
		ValaProperty* _tmp37_;
		ValaProperty* _tmp38_;
		ValaProperty* prop;
		ValaProperty* _tmp39_;
		ValaSymbolAccessibility _tmp40_;
		ValaSymbolAccessibility _tmp41_;
		ValaProperty* _tmp42_;
		ValaDataType* _tmp43_;
		ValaDataType* _tmp44_;
		ValaDataType* _tmp45_ = NULL;
		ValaDataType* get_type;
		ValaDataType* _tmp46_;
		ValaProperty* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		ValaDataType* _tmp50_ = NULL;
		ValaDataType* set_type;
		ValaDataType* _tmp51_;
		ValaProperty* _tmp52_;
		ValaDataType* _tmp53_;
		ValaField* _tmp54_;
		ValaSourceReference* _tmp55_;
		ValaSourceReference* _tmp56_;
		ValaPropertyAccessor* _tmp57_;
		ValaPropertyAccessor* _tmp58_;
		ValaProperty* _tmp59_;
		ValaDataType* _tmp60_;
		ValaField* _tmp61_;
		ValaSourceReference* _tmp62_;
		ValaSourceReference* _tmp63_;
		ValaPropertyAccessor* _tmp64_;
		ValaPropertyAccessor* _tmp65_;
		ValaField* _tmp66_;
		ValaField* _tmp67_;
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		gchar* _tmp70_ = NULL;
		gchar* _tmp71_;
		ValaField* _tmp72_;
		ValaProperty* _tmp73_;
		ValaField* _tmp74_;
		ValaProperty* _tmp75_;
		_tmp24_ = f;
		_tmp25_ = vala_symbol_get_name ((ValaSymbol*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = f;
		_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_data_type_copy (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = f;
		_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_symbol_get_comment ((ValaSymbol*) self);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_property_new (_tmp26_, _tmp31_, NULL, NULL, _tmp34_, _tmp36_);
		_tmp38_ = _tmp37_;
		_vala_code_node_unref0 (_tmp31_);
		prop = _tmp38_;
		_tmp39_ = prop;
		_tmp40_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp41_ = _tmp40_;
		vala_symbol_set_access ((ValaSymbol*) _tmp39_, _tmp41_);
		_tmp42_ = prop;
		_tmp43_ = vala_property_get_property_type (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_data_type_copy (_tmp44_);
		get_type = _tmp45_;
		_tmp46_ = get_type;
		vala_data_type_set_value_owned (_tmp46_, TRUE);
		_tmp47_ = prop;
		_tmp48_ = vala_property_get_property_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_data_type_copy (_tmp49_);
		set_type = _tmp50_;
		_tmp51_ = set_type;
		vala_data_type_set_value_owned (_tmp51_, FALSE);
		_tmp52_ = prop;
		_tmp53_ = get_type;
		_tmp54_ = f;
		_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp53_, NULL, _tmp56_, NULL);
		_tmp58_ = _tmp57_;
		vala_property_set_get_accessor (_tmp52_, _tmp58_);
		_vala_code_node_unref0 (_tmp58_);
		_tmp59_ = prop;
		_tmp60_ = set_type;
		_tmp61_ = f;
		_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_property_accessor_new (FALSE, TRUE, FALSE, _tmp60_, NULL, _tmp63_, NULL);
		_tmp65_ = _tmp64_;
		vala_property_set_set_accessor (_tmp59_, _tmp65_);
		_vala_code_node_unref0 (_tmp65_);
		_tmp66_ = f;
		_tmp67_ = f;
		_tmp68_ = vala_symbol_get_name ((ValaSymbol*) _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = g_strdup_printf ("_%s", _tmp69_);
		_tmp71_ = _tmp70_;
		vala_symbol_set_name ((ValaSymbol*) _tmp66_, _tmp71_);
		_g_free0 (_tmp71_);
		_tmp72_ = f;
		vala_symbol_set_access ((ValaSymbol*) _tmp72_, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
		_tmp73_ = prop;
		_tmp74_ = f;
		vala_property_set_field (_tmp73_, _tmp74_);
		_tmp75_ = prop;
		vala_symbol_add_property ((ValaSymbol*) self, _tmp75_);
		_vala_code_node_unref0 (set_type);
		_vala_code_node_unref0 (get_type);
		_vala_code_node_unref0 (prop);
		return;
	}
	_tmp76_ = self->priv->fields;
	_tmp77_ = f;
	vala_collection_add ((ValaCollection*) _tmp76_, _tmp77_);
	_tmp79_ = f;
	_tmp80_ = vala_symbol_get_access ((ValaSymbol*) _tmp79_);
	_tmp81_ = _tmp80_;
	if (_tmp81_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaField* _tmp82_;
		ValaMemberBinding _tmp83_;
		ValaMemberBinding _tmp84_;
		_tmp82_ = f;
		_tmp83_ = vala_field_get_binding (_tmp82_);
		_tmp84_ = _tmp83_;
		_tmp78_ = _tmp84_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp78_ = FALSE;
	}
	_tmp85_ = _tmp78_;
	if (_tmp85_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp86_ = FALSE;
		ValaField* _tmp87_;
		ValaSymbolAccessibility _tmp88_;
		ValaSymbolAccessibility _tmp89_;
		gboolean _tmp93_;
		_tmp87_ = f;
		_tmp88_ = vala_symbol_get_access ((ValaSymbol*) _tmp87_);
		_tmp89_ = _tmp88_;
		if (_tmp89_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaField* _tmp90_;
			ValaMemberBinding _tmp91_;
			ValaMemberBinding _tmp92_;
			_tmp90_ = f;
			_tmp91_ = vala_field_get_binding (_tmp90_);
			_tmp92_ = _tmp91_;
			_tmp86_ = _tmp92_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp86_ = FALSE;
		}
		_tmp93_ = _tmp86_;
		if (_tmp93_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
	_tmp94_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp95_ = _tmp94_;
	_tmp96_ = f;
	_tmp97_ = vala_symbol_get_name ((ValaSymbol*) _tmp96_);
	_tmp98_ = _tmp97_;
	_tmp99_ = f;
	vala_scope_add (_tmp95_, _tmp98_, (ValaSymbol*) _tmp99_);
}


/**
 * Returns a copy of the list of fields.
 *
 * @return list of fields
 */
ValaList* vala_class_get_fields (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->fields;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of constants.
 *
 * @return list of constants
 */
ValaList* vala_class_get_constants (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void vala_class_real_add_method (ValaSymbol* base, ValaMethod* m) {
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMethod* _tmp1_;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp33_ = FALSE;
	ValaMethod* _tmp34_;
	ValaDataType* _tmp35_;
	ValaDataType* _tmp36_;
	gboolean _tmp49_;
	ValaMethod* _tmp74_;
	ValaList* _tmp103_;
	ValaMethod* _tmp104_;
	ValaScope* _tmp105_;
	ValaScope* _tmp106_;
	ValaMethod* _tmp107_;
	const gchar* _tmp108_;
	const gchar* _tmp109_;
	ValaMethod* _tmp110_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = m;
	_tmp2_ = vala_method_get_binding (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		ValaMethod* _tmp4_;
		_tmp4_ = m;
		_tmp0_ = VALA_IS_CREATION_METHOD (_tmp4_);
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		ValaMethod* _tmp6_;
		ValaParameter* _tmp7_;
		ValaParameter* _tmp8_;
		ValaMethod* _tmp17_;
		ValaObjectType* _tmp18_ = NULL;
		ValaObjectType* _tmp19_;
		ValaParameter* _tmp20_;
		ValaParameter* _tmp21_;
		ValaMethod* _tmp22_;
		ValaScope* _tmp23_;
		ValaScope* _tmp24_;
		ValaMethod* _tmp25_;
		ValaParameter* _tmp26_;
		ValaParameter* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		ValaMethod* _tmp30_;
		ValaParameter* _tmp31_;
		ValaParameter* _tmp32_;
		_tmp6_ = m;
		_tmp7_ = vala_method_get_this_parameter (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_ != NULL) {
			ValaMethod* _tmp9_;
			ValaScope* _tmp10_;
			ValaScope* _tmp11_;
			ValaMethod* _tmp12_;
			ValaParameter* _tmp13_;
			ValaParameter* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp9_ = m;
			_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = m;
			_tmp13_ = vala_method_get_this_parameter (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_symbol_get_name ((ValaSymbol*) _tmp14_);
			_tmp16_ = _tmp15_;
			vala_scope_remove (_tmp11_, _tmp16_);
		}
		_tmp17_ = m;
		_tmp18_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_parameter_new ("this", (ValaDataType*) _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		vala_method_set_this_parameter (_tmp17_, _tmp21_);
		_vala_code_node_unref0 (_tmp21_);
		_vala_code_node_unref0 (_tmp19_);
		_tmp22_ = m;
		_tmp23_ = vala_symbol_get_scope ((ValaSymbol*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = m;
		_tmp26_ = vala_method_get_this_parameter (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_symbol_get_name ((ValaSymbol*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = m;
		_tmp31_ = vala_method_get_this_parameter (_tmp30_);
		_tmp32_ = _tmp31_;
		vala_scope_add (_tmp24_, _tmp29_, (ValaSymbol*) _tmp32_);
	}
	_tmp34_ = m;
	_tmp35_ = vala_method_get_return_type (_tmp34_);
	_tmp36_ = _tmp35_;
	if (!VALA_IS_VOID_TYPE (_tmp36_)) {
		gboolean _tmp37_ = FALSE;
		ValaCodeContext* _tmp38_ = NULL;
		ValaCodeContext* _tmp39_;
		ValaProfile _tmp40_;
		ValaProfile _tmp41_;
		gboolean _tmp42_;
		gboolean _tmp48_;
		_tmp38_ = vala_code_context_get ();
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_context_get_profile (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = _tmp41_ == VALA_PROFILE_DOVA;
		_vala_code_context_unref0 (_tmp39_);
		if (_tmp42_) {
			_tmp37_ = TRUE;
		} else {
			ValaMethod* _tmp43_;
			ValaList* _tmp44_ = NULL;
			ValaList* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			_tmp43_ = m;
			_tmp44_ = vala_method_get_postconditions (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp37_ = _tmp47_ > 0;
			_vala_iterable_unref0 (_tmp45_);
		}
		_tmp48_ = _tmp37_;
		_tmp33_ = _tmp48_;
	} else {
		_tmp33_ = FALSE;
	}
	_tmp49_ = _tmp33_;
	if (_tmp49_) {
		ValaMethod* _tmp50_;
		ValaLocalVariable* _tmp51_;
		ValaLocalVariable* _tmp52_;
		ValaMethod* _tmp61_;
		ValaMethod* _tmp62_;
		ValaDataType* _tmp63_;
		ValaDataType* _tmp64_;
		ValaDataType* _tmp65_ = NULL;
		ValaDataType* _tmp66_;
		ValaSourceReference* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaLocalVariable* _tmp69_;
		ValaLocalVariable* _tmp70_;
		ValaMethod* _tmp71_;
		ValaLocalVariable* _tmp72_;
		ValaLocalVariable* _tmp73_;
		_tmp50_ = m;
		_tmp51_ = vala_subroutine_get_result_var ((ValaSubroutine*) _tmp50_);
		_tmp52_ = _tmp51_;
		if (_tmp52_ != NULL) {
			ValaMethod* _tmp53_;
			ValaScope* _tmp54_;
			ValaScope* _tmp55_;
			ValaMethod* _tmp56_;
			ValaLocalVariable* _tmp57_;
			ValaLocalVariable* _tmp58_;
			const gchar* _tmp59_;
			const gchar* _tmp60_;
			_tmp53_ = m;
			_tmp54_ = vala_symbol_get_scope ((ValaSymbol*) _tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = m;
			_tmp57_ = vala_subroutine_get_result_var ((ValaSubroutine*) _tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_symbol_get_name ((ValaSymbol*) _tmp58_);
			_tmp60_ = _tmp59_;
			vala_scope_remove (_tmp55_, _tmp60_);
		}
		_tmp61_ = m;
		_tmp62_ = m;
		_tmp63_ = vala_method_get_return_type (_tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_data_type_copy (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp68_ = _tmp67_;
		_tmp69_ = vala_local_variable_new (_tmp66_, "result", NULL, _tmp68_);
		_tmp70_ = _tmp69_;
		vala_subroutine_set_result_var ((ValaSubroutine*) _tmp61_, _tmp70_);
		_vala_code_node_unref0 (_tmp70_);
		_vala_code_node_unref0 (_tmp66_);
		_tmp71_ = m;
		_tmp72_ = vala_subroutine_get_result_var ((ValaSubroutine*) _tmp71_);
		_tmp73_ = _tmp72_;
		vala_local_variable_set_is_result (_tmp73_, TRUE);
	}
	_tmp74_ = m;
	if (VALA_IS_CREATION_METHOD (_tmp74_)) {
		ValaMethod* _tmp75_;
		const gchar* _tmp76_;
		const gchar* _tmp77_;
		ValaMethod* _tmp80_;
		ValaCreationMethod* _tmp81_;
		ValaCreationMethod* cm;
		gboolean _tmp82_ = FALSE;
		ValaCreationMethod* _tmp83_;
		const gchar* _tmp84_;
		const gchar* _tmp85_;
		gboolean _tmp91_;
		_tmp75_ = m;
		_tmp76_ = vala_symbol_get_name ((ValaSymbol*) _tmp75_);
		_tmp77_ = _tmp76_;
		if (_tmp77_ == NULL) {
			ValaMethod* _tmp78_;
			ValaMethod* _tmp79_;
			_tmp78_ = m;
			vala_class_set_default_construction_method (self, _tmp78_);
			_tmp79_ = m;
			vala_symbol_set_name ((ValaSymbol*) _tmp79_, ".new");
		}
		_tmp80_ = m;
		_tmp81_ = _vala_code_node_ref0 (VALA_CREATION_METHOD (_tmp80_));
		cm = _tmp81_;
		_tmp83_ = cm;
		_tmp84_ = vala_creation_method_get_class_name (_tmp83_);
		_tmp85_ = _tmp84_;
		if (_tmp85_ != NULL) {
			ValaCreationMethod* _tmp86_;
			const gchar* _tmp87_;
			const gchar* _tmp88_;
			const gchar* _tmp89_;
			const gchar* _tmp90_;
			_tmp86_ = cm;
			_tmp87_ = vala_creation_method_get_class_name (_tmp86_);
			_tmp88_ = _tmp87_;
			_tmp89_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp90_ = _tmp89_;
			_tmp82_ = g_strcmp0 (_tmp88_, _tmp90_) != 0;
		} else {
			_tmp82_ = FALSE;
		}
		_tmp91_ = _tmp82_;
		if (_tmp91_) {
			ValaMethod* _tmp92_;
			ValaSourceReference* _tmp93_;
			ValaSourceReference* _tmp94_;
			gchar* _tmp95_ = NULL;
			gchar* _tmp96_;
			ValaCreationMethod* _tmp97_;
			const gchar* _tmp98_;
			const gchar* _tmp99_;
			gchar* _tmp100_ = NULL;
			gchar* _tmp101_;
			ValaMethod* _tmp102_;
			_tmp92_ = m;
			_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp96_ = _tmp95_;
			_tmp97_ = cm;
			_tmp98_ = vala_creation_method_get_class_name (_tmp97_);
			_tmp99_ = _tmp98_;
			_tmp100_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp96_, _tmp99_);
			_tmp101_ = _tmp100_;
			vala_report_error (_tmp94_, _tmp101_);
			_g_free0 (_tmp101_);
			_g_free0 (_tmp96_);
			_tmp102_ = m;
			vala_code_node_set_error ((ValaCodeNode*) _tmp102_, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp103_ = self->priv->methods;
	_tmp104_ = m;
	vala_collection_add ((ValaCollection*) _tmp103_, _tmp104_);
	_tmp105_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp106_ = _tmp105_;
	_tmp107_ = m;
	_tmp108_ = vala_symbol_get_name ((ValaSymbol*) _tmp107_);
	_tmp109_ = _tmp108_;
	_tmp110_ = m;
	vala_scope_add (_tmp106_, _tmp109_, (ValaSymbol*) _tmp110_);
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
static ValaList* vala_class_real_get_methods (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaClass*) base;
	_tmp0_ = self->priv->methods;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void vala_class_real_add_property (ValaSymbol* base, ValaProperty* prop) {
	ValaClass * self;
	ValaList* _tmp0_;
	ValaProperty* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaProperty* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaProperty* _tmp7_;
	ValaProperty* _tmp8_;
	ValaObjectType* _tmp9_ = NULL;
	ValaObjectType* _tmp10_;
	ValaParameter* _tmp11_;
	ValaParameter* _tmp12_;
	ValaProperty* _tmp13_;
	ValaScope* _tmp14_;
	ValaScope* _tmp15_;
	ValaProperty* _tmp16_;
	ValaParameter* _tmp17_;
	ValaParameter* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	ValaProperty* _tmp21_;
	ValaParameter* _tmp22_;
	ValaParameter* _tmp23_;
	ValaProperty* _tmp24_;
	ValaField* _tmp25_;
	ValaField* _tmp26_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->properties;
	_tmp1_ = prop;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = prop;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = prop;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
	_tmp8_ = prop;
	_tmp9_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_parameter_new ("this", (ValaDataType*) _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	vala_property_set_this_parameter (_tmp8_, _tmp12_);
	_vala_code_node_unref0 (_tmp12_);
	_vala_code_node_unref0 (_tmp10_);
	_tmp13_ = prop;
	_tmp14_ = vala_symbol_get_scope ((ValaSymbol*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = prop;
	_tmp17_ = vala_property_get_this_parameter (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = prop;
	_tmp22_ = vala_property_get_this_parameter (_tmp21_);
	_tmp23_ = _tmp22_;
	vala_scope_add (_tmp15_, _tmp20_, (ValaSymbol*) _tmp23_);
	_tmp24_ = prop;
	_tmp25_ = vala_property_get_field (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != NULL) {
		ValaProperty* _tmp27_;
		ValaField* _tmp28_;
		ValaField* _tmp29_;
		_tmp27_ = prop;
		_tmp28_ = vala_property_get_field (_tmp27_);
		_tmp29_ = _tmp28_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp29_);
	}
}


/**
 * Returns a copy of the list of properties.
 *
 * @return list of properties
 */
static ValaList* vala_class_real_get_properties (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaClass*) base;
	_tmp0_ = self->priv->properties;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified signal as a member to this class.
 *
 * @param sig a signal
 */
static void vala_class_real_add_signal (ValaSymbol* base, ValaSignal* sig) {
	ValaClass * self;
	ValaList* _tmp0_;
	ValaSignal* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaSignal* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaSignal* _tmp7_;
	self = (ValaClass*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = self->priv->signals;
	_tmp1_ = sig;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = sig;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = sig;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Returns a copy of the list of signals.
 *
 * @return list of signals
 */
static ValaList* vala_class_real_get_signals (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaClass*) base;
	_tmp0_ = self->priv->signals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified class as an inner class.
 *
 * @param cl a class
 */
static void vala_class_real_add_class (ValaSymbol* base, ValaClass* cl) {
	ValaClass * self;
	ValaList* _tmp0_;
	ValaClass* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaClass* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaClass* _tmp7_;
	self = (ValaClass*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = self->priv->classes;
	_tmp1_ = cl;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = cl;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = cl;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified struct as an inner struct.
 *
 * @param st a struct
 */
static void vala_class_real_add_struct (ValaSymbol* base, ValaStruct* st) {
	ValaClass * self;
	ValaList* _tmp0_;
	ValaStruct* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaStruct* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaStruct* _tmp7_;
	self = (ValaClass*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = self->priv->structs;
	_tmp1_ = st;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = st;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = st;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified enum as an inner enum.
 *
 * @param en an enum
 */
static void vala_class_real_add_enum (ValaSymbol* base, ValaEnum* en) {
	ValaClass * self;
	ValaList* _tmp0_;
	ValaEnum* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaEnum* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaEnum* _tmp7_;
	self = (ValaClass*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = self->priv->enums;
	_tmp1_ = en;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = en;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = en;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified delegate as an inner delegate.
 *
 * @param d a delegate
 */
static void vala_class_real_add_delegate (ValaSymbol* base, ValaDelegate* d) {
	ValaClass * self;
	ValaList* _tmp0_;
	ValaDelegate* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaDelegate* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaDelegate* _tmp7_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = self->priv->delegates;
	_tmp1_ = d;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = d;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = d;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


static void vala_class_real_add_constructor (ValaSymbol* base, ValaConstructor* c) {
	ValaClass * self;
	ValaConstructor* _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	_tmp1_ = vala_constructor_get_binding (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaConstructor* _tmp3_;
		ValaConstructor* _tmp7_;
		_tmp3_ = self->priv->_constructor;
		if (_tmp3_ != NULL) {
			ValaConstructor* _tmp4_;
			ValaSourceReference* _tmp5_;
			ValaSourceReference* _tmp6_;
			_tmp4_ = c;
			_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp4_);
			_tmp6_ = _tmp5_;
			vala_report_error (_tmp6_, "class already contains a constructor");
		}
		_tmp7_ = c;
		vala_class_set_constructor (self, _tmp7_);
	} else {
		ValaConstructor* _tmp8_;
		ValaMemberBinding _tmp9_;
		ValaMemberBinding _tmp10_;
		_tmp8_ = c;
		_tmp9_ = vala_constructor_get_binding (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == VALA_MEMBER_BINDING_CLASS) {
			ValaConstructor* _tmp11_;
			ValaConstructor* _tmp15_;
			_tmp11_ = self->priv->_class_constructor;
			if (_tmp11_ != NULL) {
				ValaConstructor* _tmp12_;
				ValaSourceReference* _tmp13_;
				ValaSourceReference* _tmp14_;
				_tmp12_ = c;
				_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp12_);
				_tmp14_ = _tmp13_;
				vala_report_error (_tmp14_, "class already contains a class constructor");
			}
			_tmp15_ = c;
			vala_class_set_class_constructor (self, _tmp15_);
		} else {
			ValaConstructor* _tmp16_;
			ValaConstructor* _tmp20_;
			_tmp16_ = self->priv->_static_constructor;
			if (_tmp16_ != NULL) {
				ValaConstructor* _tmp17_;
				ValaSourceReference* _tmp18_;
				ValaSourceReference* _tmp19_;
				_tmp17_ = c;
				_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp17_);
				_tmp19_ = _tmp18_;
				vala_report_error (_tmp19_, "class already contains a static constructor");
			}
			_tmp20_ = c;
			vala_class_set_static_constructor (self, _tmp20_);
		}
	}
}


static void vala_class_real_add_destructor (ValaSymbol* base, ValaDestructor* d) {
	ValaClass * self;
	ValaDestructor* _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = d;
	_tmp1_ = vala_destructor_get_binding (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaDestructor* _tmp3_;
		ValaDestructor* _tmp4_;
		ValaDestructor* _tmp8_;
		_tmp3_ = vala_class_get_destructor (self);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaDestructor* _tmp5_;
			ValaSourceReference* _tmp6_;
			ValaSourceReference* _tmp7_;
			_tmp5_ = d;
			_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp5_);
			_tmp7_ = _tmp6_;
			vala_report_error (_tmp7_, "class already contains a destructor");
		}
		_tmp8_ = d;
		vala_class_set_destructor (self, _tmp8_);
	} else {
		ValaDestructor* _tmp9_;
		ValaMemberBinding _tmp10_;
		ValaMemberBinding _tmp11_;
		_tmp9_ = d;
		_tmp10_ = vala_destructor_get_binding (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == VALA_MEMBER_BINDING_CLASS) {
			ValaDestructor* _tmp12_;
			ValaDestructor* _tmp16_;
			_tmp12_ = self->priv->_class_destructor;
			if (_tmp12_ != NULL) {
				ValaDestructor* _tmp13_;
				ValaSourceReference* _tmp14_;
				ValaSourceReference* _tmp15_;
				_tmp13_ = d;
				_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp13_);
				_tmp15_ = _tmp14_;
				vala_report_error (_tmp15_, "class already contains a class destructor");
			}
			_tmp16_ = d;
			vala_class_set_class_destructor (self, _tmp16_);
		} else {
			ValaDestructor* _tmp17_;
			ValaDestructor* _tmp21_;
			_tmp17_ = self->priv->_static_destructor;
			if (_tmp17_ != NULL) {
				ValaDestructor* _tmp18_;
				ValaSourceReference* _tmp19_;
				ValaSourceReference* _tmp20_;
				_tmp18_ = d;
				_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
				_tmp20_ = _tmp19_;
				vala_report_error (_tmp20_, "class already contains a static destructor");
			}
			_tmp21_ = d;
			vala_class_set_static_destructor (self, _tmp21_);
		}
	}
}


static void vala_class_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaClass * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_class (_tmp0_, self);
}


static void vala_class_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaClass * self;
	ValaConstructor* _tmp103_;
	ValaConstructor* _tmp106_;
	ValaConstructor* _tmp109_;
	ValaDestructor* _tmp112_;
	ValaDestructor* _tmp113_;
	ValaDestructor* _tmp117_;
	ValaDestructor* _tmp120_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		ValaList* _type_list;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_size;
		gint _type_index;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ValaDataType* type;
			ValaDataType* _tmp11_;
			ValaCodeVisitor* _tmp12_;
			_tmp5_ = _type_index;
			_type_index = _tmp5_ + 1;
			_tmp6_ = _type_index;
			_tmp7_ = _type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _type_list;
			_tmp9_ = _type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			_tmp12_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _tmp13_ = NULL;
		ValaList* _p_list;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _p_size;
		gint _p_index;
		_tmp13_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp13_;
		_tmp14_ = _p_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_p_size = _tmp16_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_ = NULL;
			ValaTypeParameter* p;
			ValaTypeParameter* _tmp23_;
			ValaCodeVisitor* _tmp24_;
			_tmp17_ = _p_index;
			_p_index = _tmp17_ + 1;
			_tmp18_ = _p_index;
			_tmp19_ = _p_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _p_list;
			_tmp21_ = _p_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			p = (ValaTypeParameter*) _tmp22_;
			_tmp23_ = p;
			_tmp24_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp23_, _tmp24_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _tmp25_;
		ValaList* _tmp26_;
		ValaList* _en_list;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _en_size;
		gint _en_index;
		_tmp25_ = self->priv->enums;
		_tmp26_ = _vala_iterable_ref0 (_tmp25_);
		_en_list = _tmp26_;
		_tmp27_ = _en_list;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_en_size = _tmp29_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			ValaList* _tmp33_;
			gint _tmp34_;
			gpointer _tmp35_ = NULL;
			ValaEnum* en;
			ValaEnum* _tmp36_;
			ValaCodeVisitor* _tmp37_;
			_tmp30_ = _en_index;
			_en_index = _tmp30_ + 1;
			_tmp31_ = _en_index;
			_tmp32_ = _en_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _en_list;
			_tmp34_ = _en_index;
			_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
			en = (ValaEnum*) _tmp35_;
			_tmp36_ = en;
			_tmp37_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp36_, _tmp37_);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _tmp38_;
		ValaList* _tmp39_;
		ValaList* _f_list;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _f_size;
		gint _f_index;
		_tmp38_ = self->priv->fields;
		_tmp39_ = _vala_iterable_ref0 (_tmp38_);
		_f_list = _tmp39_;
		_tmp40_ = _f_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_f_size = _tmp42_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			ValaList* _tmp46_;
			gint _tmp47_;
			gpointer _tmp48_ = NULL;
			ValaField* f;
			ValaField* _tmp49_;
			ValaCodeVisitor* _tmp50_;
			_tmp43_ = _f_index;
			_f_index = _tmp43_ + 1;
			_tmp44_ = _f_index;
			_tmp45_ = _f_size;
			if (!(_tmp44_ < _tmp45_)) {
				break;
			}
			_tmp46_ = _f_list;
			_tmp47_ = _f_index;
			_tmp48_ = vala_list_get (_tmp46_, _tmp47_);
			f = (ValaField*) _tmp48_;
			_tmp49_ = f;
			_tmp50_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp49_, _tmp50_);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _tmp51_;
		ValaList* _tmp52_;
		ValaList* _c_list;
		ValaList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _c_size;
		gint _c_index;
		_tmp51_ = self->priv->constants;
		_tmp52_ = _vala_iterable_ref0 (_tmp51_);
		_c_list = _tmp52_;
		_tmp53_ = _c_list;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_c_size = _tmp55_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			ValaList* _tmp59_;
			gint _tmp60_;
			gpointer _tmp61_ = NULL;
			ValaConstant* c;
			ValaConstant* _tmp62_;
			ValaCodeVisitor* _tmp63_;
			_tmp56_ = _c_index;
			_c_index = _tmp56_ + 1;
			_tmp57_ = _c_index;
			_tmp58_ = _c_size;
			if (!(_tmp57_ < _tmp58_)) {
				break;
			}
			_tmp59_ = _c_list;
			_tmp60_ = _c_index;
			_tmp61_ = vala_list_get (_tmp59_, _tmp60_);
			c = (ValaConstant*) _tmp61_;
			_tmp62_ = c;
			_tmp63_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp62_, _tmp63_);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _tmp64_;
		ValaList* _tmp65_;
		ValaList* _m_list;
		ValaList* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		gint _m_size;
		gint _m_index;
		_tmp64_ = self->priv->methods;
		_tmp65_ = _vala_iterable_ref0 (_tmp64_);
		_m_list = _tmp65_;
		_tmp66_ = _m_list;
		_tmp67_ = vala_collection_get_size ((ValaCollection*) _tmp66_);
		_tmp68_ = _tmp67_;
		_m_size = _tmp68_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			ValaList* _tmp72_;
			gint _tmp73_;
			gpointer _tmp74_ = NULL;
			ValaMethod* m;
			ValaMethod* _tmp75_;
			ValaCodeVisitor* _tmp76_;
			_tmp69_ = _m_index;
			_m_index = _tmp69_ + 1;
			_tmp70_ = _m_index;
			_tmp71_ = _m_size;
			if (!(_tmp70_ < _tmp71_)) {
				break;
			}
			_tmp72_ = _m_list;
			_tmp73_ = _m_index;
			_tmp74_ = vala_list_get (_tmp72_, _tmp73_);
			m = (ValaMethod*) _tmp74_;
			_tmp75_ = m;
			_tmp76_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp75_, _tmp76_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _tmp77_;
		ValaList* _tmp78_;
		ValaList* _prop_list;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _prop_size;
		gint _prop_index;
		_tmp77_ = self->priv->properties;
		_tmp78_ = _vala_iterable_ref0 (_tmp77_);
		_prop_list = _tmp78_;
		_tmp79_ = _prop_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_prop_size = _tmp81_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			ValaList* _tmp85_;
			gint _tmp86_;
			gpointer _tmp87_ = NULL;
			ValaProperty* prop;
			ValaProperty* _tmp88_;
			ValaCodeVisitor* _tmp89_;
			_tmp82_ = _prop_index;
			_prop_index = _tmp82_ + 1;
			_tmp83_ = _prop_index;
			_tmp84_ = _prop_size;
			if (!(_tmp83_ < _tmp84_)) {
				break;
			}
			_tmp85_ = _prop_list;
			_tmp86_ = _prop_index;
			_tmp87_ = vala_list_get (_tmp85_, _tmp86_);
			prop = (ValaProperty*) _tmp87_;
			_tmp88_ = prop;
			_tmp89_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp88_, _tmp89_);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _tmp90_;
		ValaList* _tmp91_;
		ValaList* _sig_list;
		ValaList* _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		gint _sig_size;
		gint _sig_index;
		_tmp90_ = self->priv->signals;
		_tmp91_ = _vala_iterable_ref0 (_tmp90_);
		_sig_list = _tmp91_;
		_tmp92_ = _sig_list;
		_tmp93_ = vala_collection_get_size ((ValaCollection*) _tmp92_);
		_tmp94_ = _tmp93_;
		_sig_size = _tmp94_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp95_;
			gint _tmp96_;
			gint _tmp97_;
			ValaList* _tmp98_;
			gint _tmp99_;
			gpointer _tmp100_ = NULL;
			ValaSignal* sig;
			ValaSignal* _tmp101_;
			ValaCodeVisitor* _tmp102_;
			_tmp95_ = _sig_index;
			_sig_index = _tmp95_ + 1;
			_tmp96_ = _sig_index;
			_tmp97_ = _sig_size;
			if (!(_tmp96_ < _tmp97_)) {
				break;
			}
			_tmp98_ = _sig_list;
			_tmp99_ = _sig_index;
			_tmp100_ = vala_list_get (_tmp98_, _tmp99_);
			sig = (ValaSignal*) _tmp100_;
			_tmp101_ = sig;
			_tmp102_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp101_, _tmp102_);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp103_ = self->priv->_constructor;
	if (_tmp103_ != NULL) {
		ValaConstructor* _tmp104_;
		ValaCodeVisitor* _tmp105_;
		_tmp104_ = self->priv->_constructor;
		_tmp105_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp104_, _tmp105_);
	}
	_tmp106_ = self->priv->_class_constructor;
	if (_tmp106_ != NULL) {
		ValaConstructor* _tmp107_;
		ValaCodeVisitor* _tmp108_;
		_tmp107_ = self->priv->_class_constructor;
		_tmp108_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp107_, _tmp108_);
	}
	_tmp109_ = self->priv->_static_constructor;
	if (_tmp109_ != NULL) {
		ValaConstructor* _tmp110_;
		ValaCodeVisitor* _tmp111_;
		_tmp110_ = self->priv->_static_constructor;
		_tmp111_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp110_, _tmp111_);
	}
	_tmp112_ = vala_class_get_destructor (self);
	_tmp113_ = _tmp112_;
	if (_tmp113_ != NULL) {
		ValaDestructor* _tmp114_;
		ValaDestructor* _tmp115_;
		ValaCodeVisitor* _tmp116_;
		_tmp114_ = vala_class_get_destructor (self);
		_tmp115_ = _tmp114_;
		_tmp116_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp115_, _tmp116_);
	}
	_tmp117_ = self->priv->_static_destructor;
	if (_tmp117_ != NULL) {
		ValaDestructor* _tmp118_;
		ValaCodeVisitor* _tmp119_;
		_tmp118_ = self->priv->_static_destructor;
		_tmp119_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp118_, _tmp119_);
	}
	_tmp120_ = self->priv->_class_destructor;
	if (_tmp120_ != NULL) {
		ValaDestructor* _tmp121_;
		ValaCodeVisitor* _tmp122_;
		_tmp121_ = self->priv->_class_destructor;
		_tmp122_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp121_, _tmp122_);
	}
	{
		ValaList* _tmp123_;
		ValaList* _tmp124_;
		ValaList* _cl_list;
		ValaList* _tmp125_;
		gint _tmp126_;
		gint _tmp127_;
		gint _cl_size;
		gint _cl_index;
		_tmp123_ = self->priv->classes;
		_tmp124_ = _vala_iterable_ref0 (_tmp123_);
		_cl_list = _tmp124_;
		_tmp125_ = _cl_list;
		_tmp126_ = vala_collection_get_size ((ValaCollection*) _tmp125_);
		_tmp127_ = _tmp126_;
		_cl_size = _tmp127_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp128_;
			gint _tmp129_;
			gint _tmp130_;
			ValaList* _tmp131_;
			gint _tmp132_;
			gpointer _tmp133_ = NULL;
			ValaClass* cl;
			ValaClass* _tmp134_;
			ValaCodeVisitor* _tmp135_;
			_tmp128_ = _cl_index;
			_cl_index = _tmp128_ + 1;
			_tmp129_ = _cl_index;
			_tmp130_ = _cl_size;
			if (!(_tmp129_ < _tmp130_)) {
				break;
			}
			_tmp131_ = _cl_list;
			_tmp132_ = _cl_index;
			_tmp133_ = vala_list_get (_tmp131_, _tmp132_);
			cl = (ValaClass*) _tmp133_;
			_tmp134_ = cl;
			_tmp135_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp134_, _tmp135_);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _tmp136_;
		ValaList* _tmp137_;
		ValaList* _st_list;
		ValaList* _tmp138_;
		gint _tmp139_;
		gint _tmp140_;
		gint _st_size;
		gint _st_index;
		_tmp136_ = self->priv->structs;
		_tmp137_ = _vala_iterable_ref0 (_tmp136_);
		_st_list = _tmp137_;
		_tmp138_ = _st_list;
		_tmp139_ = vala_collection_get_size ((ValaCollection*) _tmp138_);
		_tmp140_ = _tmp139_;
		_st_size = _tmp140_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp141_;
			gint _tmp142_;
			gint _tmp143_;
			ValaList* _tmp144_;
			gint _tmp145_;
			gpointer _tmp146_ = NULL;
			ValaStruct* st;
			ValaStruct* _tmp147_;
			ValaCodeVisitor* _tmp148_;
			_tmp141_ = _st_index;
			_st_index = _tmp141_ + 1;
			_tmp142_ = _st_index;
			_tmp143_ = _st_size;
			if (!(_tmp142_ < _tmp143_)) {
				break;
			}
			_tmp144_ = _st_list;
			_tmp145_ = _st_index;
			_tmp146_ = vala_list_get (_tmp144_, _tmp145_);
			st = (ValaStruct*) _tmp146_;
			_tmp147_ = st;
			_tmp148_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp147_, _tmp148_);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _tmp149_;
		ValaList* _tmp150_;
		ValaList* _d_list;
		ValaList* _tmp151_;
		gint _tmp152_;
		gint _tmp153_;
		gint _d_size;
		gint _d_index;
		_tmp149_ = self->priv->delegates;
		_tmp150_ = _vala_iterable_ref0 (_tmp149_);
		_d_list = _tmp150_;
		_tmp151_ = _d_list;
		_tmp152_ = vala_collection_get_size ((ValaCollection*) _tmp151_);
		_tmp153_ = _tmp152_;
		_d_size = _tmp153_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp154_;
			gint _tmp155_;
			gint _tmp156_;
			ValaList* _tmp157_;
			gint _tmp158_;
			gpointer _tmp159_ = NULL;
			ValaDelegate* d;
			ValaDelegate* _tmp160_;
			ValaCodeVisitor* _tmp161_;
			_tmp154_ = _d_index;
			_d_index = _tmp154_ + 1;
			_tmp155_ = _d_index;
			_tmp156_ = _d_size;
			if (!(_tmp155_ < _tmp156_)) {
				break;
			}
			_tmp157_ = _d_list;
			_tmp158_ = _d_index;
			_tmp159_ = vala_list_get (_tmp157_, _tmp158_);
			d = (ValaDelegate*) _tmp159_;
			_tmp160_ = d;
			_tmp161_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp160_, _tmp161_);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base) {
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}


gboolean vala_class_is_fundamental (ValaClass* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		ValaCodeContext* _tmp6_ = NULL;
		ValaCodeContext* _tmp7_;
		ValaProfile _tmp8_;
		ValaProfile _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp13_;
		_tmp6_ = vala_code_context_get ();
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_context_get_profile (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_ == VALA_PROFILE_DOVA;
		_vala_code_context_unref0 (_tmp7_);
		if (_tmp10_) {
			ValaClass* _tmp11_;
			ValaClass* _tmp12_;
			_tmp11_ = self->priv->_base_class;
			_tmp12_ = _tmp11_->priv->_base_class;
			_tmp5_ = _tmp12_ == NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp13_ = _tmp5_;
		if (_tmp13_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t) {
	ValaClass * self;
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp0_;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	_tmp0_ = t;
	if (VALA_TYPESYMBOL (self) == _tmp0_) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		ValaList* _base_type_list;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _base_type_size;
		gint _base_type_index;
		_tmp1_ = self->priv->base_types;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_base_type_list = _tmp2_;
		_tmp3_ = _base_type_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_base_type_size = _tmp5_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			ValaDataType* base_type;
			gboolean _tmp12_ = FALSE;
			ValaDataType* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			gboolean _tmp21_;
			_tmp6_ = _base_type_index;
			_base_type_index = _tmp6_ + 1;
			_tmp7_ = _base_type_index;
			_tmp8_ = _base_type_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _base_type_list;
			_tmp10_ = _base_type_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			base_type = (ValaDataType*) _tmp11_;
			_tmp13_ = base_type;
			_tmp14_ = vala_data_type_get_data_type (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ != NULL) {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				ValaTypeSymbol* _tmp19_;
				gboolean _tmp20_ = FALSE;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_data_type (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = t;
				_tmp20_ = vala_typesymbol_is_subtype_of (_tmp18_, _tmp19_);
				_tmp12_ = _tmp20_;
			} else {
				_tmp12_ = FALSE;
			}
			_tmp21_ = _tmp12_;
			if (_tmp21_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static void vala_class_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				ValaList* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				ValaList* _tmp7_;
				gint _tmp8_;
				gpointer _tmp9_ = NULL;
				ValaDataType* _tmp10_;
				ValaDataType* _tmp11_;
				gboolean _tmp12_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->base_types;
				_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->base_types;
				_tmp8_ = i;
				_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
				_tmp10_ = (ValaDataType*) _tmp9_;
				_tmp11_ = old_type;
				_tmp12_ = _tmp10_ == _tmp11_;
				_vala_code_node_unref0 (_tmp10_);
				if (_tmp12_) {
					ValaList* _tmp13_;
					gint _tmp14_;
					ValaDataType* _tmp15_;
					_tmp13_ = self->priv->base_types;
					_tmp14_ = i;
					_tmp15_ = new_type;
					vala_list_set (_tmp13_, _tmp14_, _tmp15_);
					return;
				}
			}
		}
	}
}


static void vala_class_get_all_prerequisites (ValaClass* self, ValaInterface* iface, ValaList* list) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaInterface* _tmp0_;
		ValaList* _tmp1_ = NULL;
		ValaList* _prereq_list;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prereq_size;
		gint _prereq_index;
		_tmp0_ = iface;
		_tmp1_ = vala_interface_get_prerequisites (_tmp0_);
		_prereq_list = _tmp1_;
		_tmp2_ = _prereq_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prereq_size = _tmp4_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ValaDataType* prereq;
			ValaDataType* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* type;
			ValaTypeSymbol* _tmp15_;
			ValaList* _tmp16_;
			ValaTypeSymbol* _tmp17_;
			ValaTypeSymbol* _tmp18_;
			_tmp5_ = _prereq_index;
			_prereq_index = _tmp5_ + 1;
			_tmp6_ = _prereq_index;
			_tmp7_ = _prereq_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _prereq_list;
			_tmp9_ = _prereq_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			prereq = (ValaDataType*) _tmp10_;
			_tmp11_ = prereq;
			_tmp12_ = vala_data_type_get_data_type (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _vala_code_node_ref0 (_tmp13_);
			type = _tmp14_;
			_tmp15_ = type;
			if (_tmp15_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp16_ = list;
			_tmp17_ = type;
			vala_collection_add ((ValaCollection*) _tmp16_, _tmp17_);
			_tmp18_ = type;
			if (VALA_IS_INTERFACE (_tmp18_)) {
				ValaTypeSymbol* _tmp19_;
				ValaList* _tmp20_;
				_tmp19_ = type;
				_tmp20_ = list;
				vala_class_get_all_prerequisites (self, VALA_INTERFACE (_tmp19_), _tmp20_);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}


static gboolean vala_class_class_is_a (ValaClass* self, ValaClass* cl, ValaTypeSymbol* t) {
	gboolean result = FALSE;
	ValaClass* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	_tmp0_ = cl;
	_tmp1_ = t;
	if (VALA_TYPESYMBOL (_tmp0_) == _tmp1_) {
		result = TRUE;
		return result;
	}
	{
		ValaClass* _tmp2_;
		ValaList* _tmp3_ = NULL;
		ValaList* _base_type_list;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _base_type_size;
		gint _base_type_index;
		_tmp2_ = cl;
		_tmp3_ = vala_class_get_base_types (_tmp2_);
		_base_type_list = _tmp3_;
		_tmp4_ = _base_type_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_base_type_size = _tmp6_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_ = NULL;
			ValaDataType* base_type;
			ValaDataType* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			_tmp7_ = _base_type_index;
			_base_type_index = _tmp7_ + 1;
			_tmp8_ = _base_type_index;
			_tmp9_ = _base_type_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _base_type_list;
			_tmp11_ = _base_type_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			base_type = (ValaDataType*) _tmp12_;
			_tmp13_ = base_type;
			_tmp14_ = vala_data_type_get_data_type (_tmp13_);
			_tmp15_ = _tmp14_;
			if (VALA_IS_CLASS (_tmp15_)) {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				ValaTypeSymbol* _tmp19_;
				gboolean _tmp20_ = FALSE;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_data_type (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = t;
				_tmp20_ = vala_class_class_is_a (self, VALA_CLASS (_tmp18_), _tmp19_);
				if (_tmp20_) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaDataType* _tmp21_;
				ValaTypeSymbol* _tmp22_;
				ValaTypeSymbol* _tmp23_;
				ValaTypeSymbol* _tmp24_;
				_tmp21_ = base_type;
				_tmp22_ = vala_data_type_get_data_type (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = t;
				if (_tmp23_ == _tmp24_) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_class_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaClass * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSourceFile* old_source_file;
	ValaCodeContext* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSymbol* old_symbol;
	ValaSourceReference* _tmp16_;
	ValaSourceReference* _tmp17_;
	ValaCodeContext* _tmp25_;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaConstructor* _tmp192_;
	ValaConstructor* _tmp195_;
	ValaConstructor* _tmp198_;
	ValaDestructor* _tmp201_;
	ValaDestructor* _tmp202_;
	ValaDestructor* _tmp206_;
	ValaDestructor* _tmp209_;
	gboolean _tmp251_;
	gboolean _tmp252_;
	GEqualFunc _tmp297_;
	ValaArrayList* _tmp298_;
	ValaList* prerequisites;
	GEqualFunc _tmp316_;
	ValaArrayList* _tmp317_;
	ValaList* missing_prereqs;
	ValaList* _tmp335_;
	gint _tmp336_;
	gint _tmp337_;
	ValaSourceFileType _tmp365_;
	ValaSourceFileType _tmp366_;
	ValaCodeContext* _tmp565_;
	ValaSemanticAnalyzer* _tmp566_;
	ValaSemanticAnalyzer* _tmp567_;
	ValaSourceFile* _tmp568_;
	ValaCodeContext* _tmp569_;
	ValaSemanticAnalyzer* _tmp570_;
	ValaSemanticAnalyzer* _tmp571_;
	ValaSymbol* _tmp572_;
	gboolean _tmp573_;
	gboolean _tmp574_;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_source_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_source_file_ref0 (_tmp8_);
	old_source_file = _tmp9_;
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_analyzer (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_semantic_analyzer_get_current_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _vala_code_node_ref0 (_tmp14_);
	old_symbol = _tmp15_;
	_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaCodeContext* _tmp18_;
		ValaSemanticAnalyzer* _tmp19_;
		ValaSemanticAnalyzer* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaSourceFile* _tmp23_;
		ValaSourceFile* _tmp24_;
		_tmp18_ = context;
		_tmp19_ = vala_code_context_get_analyzer (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_source_reference_get_file (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_semantic_analyzer_set_current_source_file (_tmp20_, _tmp24_);
	}
	_tmp25_ = context;
	_tmp26_ = vala_code_context_get_analyzer (_tmp25_);
	_tmp27_ = _tmp26_;
	vala_semantic_analyzer_set_current_symbol (_tmp27_, (ValaSymbol*) self);
	{
		ValaList* _tmp28_ = NULL;
		ValaList* _base_type_reference_list;
		ValaList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _base_type_reference_size;
		gint _base_type_reference_index;
		_tmp28_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp28_;
		_tmp29_ = _base_type_reference_list;
		_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_base_type_reference_size = _tmp31_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			ValaList* _tmp35_;
			gint _tmp36_;
			gpointer _tmp37_ = NULL;
			ValaDataType* base_type_reference;
			ValaDataType* _tmp38_;
			ValaCodeContext* _tmp39_;
			gboolean _tmp40_ = FALSE;
			ValaDataType* _tmp41_;
			ValaCodeContext* _tmp51_;
			ValaSemanticAnalyzer* _tmp52_;
			ValaSemanticAnalyzer* _tmp53_;
			ValaDataType* _tmp54_;
			gboolean _tmp55_ = FALSE;
			ValaDataType* _tmp65_;
			ValaList* _tmp66_ = NULL;
			ValaList* _tmp67_;
			gint _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			gint n_type_args;
			ValaDataType* _tmp71_;
			ValaTypeSymbol* _tmp72_;
			ValaTypeSymbol* _tmp73_;
			ValaList* _tmp74_ = NULL;
			ValaList* _tmp75_;
			gint _tmp76_;
			gint _tmp77_;
			gint _tmp78_;
			gint n_type_params;
			gint _tmp79_;
			gint _tmp80_;
			_tmp32_ = _base_type_reference_index;
			_base_type_reference_index = _tmp32_ + 1;
			_tmp33_ = _base_type_reference_index;
			_tmp34_ = _base_type_reference_size;
			if (!(_tmp33_ < _tmp34_)) {
				break;
			}
			_tmp35_ = _base_type_reference_list;
			_tmp36_ = _base_type_reference_index;
			_tmp37_ = vala_list_get (_tmp35_, _tmp36_);
			base_type_reference = (ValaDataType*) _tmp37_;
			_tmp38_ = base_type_reference;
			_tmp39_ = context;
			_tmp40_ = vala_code_node_check ((ValaCodeNode*) _tmp38_, _tmp39_);
			if (!_tmp40_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp41_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp41_)) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				ValaDataType* _tmp44_;
				gchar* _tmp45_ = NULL;
				gchar* _tmp46_;
				gchar* _tmp47_ = NULL;
				gchar* _tmp48_;
				gchar* _tmp49_ = NULL;
				gchar* _tmp50_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp43_ = _tmp42_;
				_tmp44_ = base_type_reference;
				_tmp45_ = vala_code_node_to_string ((ValaCodeNode*) _tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp48_ = _tmp47_;
				_tmp49_ = g_strdup_printf ("base type `%s` of class `%s` is not an object type", _tmp46_, _tmp48_);
				_tmp50_ = _tmp49_;
				vala_report_error (_tmp43_, _tmp50_);
				_g_free0 (_tmp50_);
				_g_free0 (_tmp48_);
				_g_free0 (_tmp46_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp51_ = context;
			_tmp52_ = vala_code_context_get_analyzer (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = base_type_reference;
			_tmp55_ = vala_semantic_analyzer_is_type_accessible (_tmp53_, (ValaSymbol*) self, _tmp54_);
			if (!_tmp55_) {
				ValaSourceReference* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaDataType* _tmp58_;
				gchar* _tmp59_ = NULL;
				gchar* _tmp60_;
				gchar* _tmp61_ = NULL;
				gchar* _tmp62_;
				gchar* _tmp63_ = NULL;
				gchar* _tmp64_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp57_ = _tmp56_;
				_tmp58_ = base_type_reference;
				_tmp59_ = vala_code_node_to_string ((ValaCodeNode*) _tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp62_ = _tmp61_;
				_tmp63_ = g_strdup_printf ("base type `%s` is less accessible than class `%s`", _tmp60_, _tmp62_);
				_tmp64_ = _tmp63_;
				vala_report_error (_tmp57_, _tmp64_);
				_g_free0 (_tmp64_);
				_g_free0 (_tmp62_);
				_g_free0 (_tmp60_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp65_ = base_type_reference;
			_tmp66_ = vala_data_type_get_type_arguments (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_collection_get_size ((ValaCollection*) _tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = _tmp69_;
			_vala_iterable_unref0 (_tmp67_);
			n_type_args = _tmp70_;
			_tmp71_ = base_type_reference;
			_tmp72_ = vala_data_type_get_data_type (_tmp71_);
			_tmp73_ = _tmp72_;
			_tmp74_ = vala_object_type_symbol_get_type_parameters (VALA_OBJECT_TYPE_SYMBOL (_tmp73_));
			_tmp75_ = _tmp74_;
			_tmp76_ = vala_collection_get_size ((ValaCollection*) _tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = _tmp77_;
			_vala_iterable_unref0 (_tmp75_);
			n_type_params = _tmp78_;
			_tmp79_ = n_type_args;
			_tmp80_ = n_type_params;
			if (_tmp79_ < _tmp80_) {
				ValaDataType* _tmp81_;
				ValaSourceReference* _tmp82_;
				ValaSourceReference* _tmp83_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp81_ = base_type_reference;
				_tmp82_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp81_);
				_tmp83_ = _tmp82_;
				vala_report_error (_tmp83_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				gint _tmp84_;
				gint _tmp85_;
				_tmp84_ = n_type_args;
				_tmp85_ = n_type_params;
				if (_tmp84_ > _tmp85_) {
					ValaDataType* _tmp86_;
					ValaSourceReference* _tmp87_;
					ValaSourceReference* _tmp88_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp86_ = base_type_reference;
					_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp86_);
					_tmp88_ = _tmp87_;
					vala_report_error (_tmp88_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _tmp89_;
		ValaList* _tmp90_;
		ValaList* _type_list;
		ValaList* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		gint _type_size;
		gint _type_index;
		_tmp89_ = self->priv->base_types;
		_tmp90_ = _vala_iterable_ref0 (_tmp89_);
		_type_list = _tmp90_;
		_tmp91_ = _type_list;
		_tmp92_ = vala_collection_get_size ((ValaCollection*) _tmp91_);
		_tmp93_ = _tmp92_;
		_type_size = _tmp93_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp94_;
			gint _tmp95_;
			gint _tmp96_;
			ValaList* _tmp97_;
			gint _tmp98_;
			gpointer _tmp99_ = NULL;
			ValaDataType* type;
			ValaDataType* _tmp100_;
			ValaCodeContext* _tmp101_;
			_tmp94_ = _type_index;
			_type_index = _tmp94_ + 1;
			_tmp95_ = _type_index;
			_tmp96_ = _type_size;
			if (!(_tmp95_ < _tmp96_)) {
				break;
			}
			_tmp97_ = _type_list;
			_tmp98_ = _type_index;
			_tmp99_ = vala_list_get (_tmp97_, _tmp98_);
			type = (ValaDataType*) _tmp99_;
			_tmp100_ = type;
			_tmp101_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp100_, _tmp101_);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _tmp102_ = NULL;
		ValaList* _p_list;
		ValaList* _tmp103_;
		gint _tmp104_;
		gint _tmp105_;
		gint _p_size;
		gint _p_index;
		_tmp102_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp102_;
		_tmp103_ = _p_list;
		_tmp104_ = vala_collection_get_size ((ValaCollection*) _tmp103_);
		_tmp105_ = _tmp104_;
		_p_size = _tmp105_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp106_;
			gint _tmp107_;
			gint _tmp108_;
			ValaList* _tmp109_;
			gint _tmp110_;
			gpointer _tmp111_ = NULL;
			ValaTypeParameter* p;
			ValaTypeParameter* _tmp112_;
			ValaCodeContext* _tmp113_;
			_tmp106_ = _p_index;
			_p_index = _tmp106_ + 1;
			_tmp107_ = _p_index;
			_tmp108_ = _p_size;
			if (!(_tmp107_ < _tmp108_)) {
				break;
			}
			_tmp109_ = _p_list;
			_tmp110_ = _p_index;
			_tmp111_ = vala_list_get (_tmp109_, _tmp110_);
			p = (ValaTypeParameter*) _tmp111_;
			_tmp112_ = p;
			_tmp113_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp112_, _tmp113_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _tmp114_;
		ValaList* _tmp115_;
		ValaList* _en_list;
		ValaList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _en_size;
		gint _en_index;
		_tmp114_ = self->priv->enums;
		_tmp115_ = _vala_iterable_ref0 (_tmp114_);
		_en_list = _tmp115_;
		_tmp116_ = _en_list;
		_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		_en_size = _tmp118_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			ValaList* _tmp122_;
			gint _tmp123_;
			gpointer _tmp124_ = NULL;
			ValaEnum* en;
			ValaEnum* _tmp125_;
			ValaCodeContext* _tmp126_;
			_tmp119_ = _en_index;
			_en_index = _tmp119_ + 1;
			_tmp120_ = _en_index;
			_tmp121_ = _en_size;
			if (!(_tmp120_ < _tmp121_)) {
				break;
			}
			_tmp122_ = _en_list;
			_tmp123_ = _en_index;
			_tmp124_ = vala_list_get (_tmp122_, _tmp123_);
			en = (ValaEnum*) _tmp124_;
			_tmp125_ = en;
			_tmp126_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp125_, _tmp126_);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _tmp127_;
		ValaList* _tmp128_;
		ValaList* _f_list;
		ValaList* _tmp129_;
		gint _tmp130_;
		gint _tmp131_;
		gint _f_size;
		gint _f_index;
		_tmp127_ = self->priv->fields;
		_tmp128_ = _vala_iterable_ref0 (_tmp127_);
		_f_list = _tmp128_;
		_tmp129_ = _f_list;
		_tmp130_ = vala_collection_get_size ((ValaCollection*) _tmp129_);
		_tmp131_ = _tmp130_;
		_f_size = _tmp131_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp132_;
			gint _tmp133_;
			gint _tmp134_;
			ValaList* _tmp135_;
			gint _tmp136_;
			gpointer _tmp137_ = NULL;
			ValaField* f;
			ValaField* _tmp138_;
			ValaCodeContext* _tmp139_;
			_tmp132_ = _f_index;
			_f_index = _tmp132_ + 1;
			_tmp133_ = _f_index;
			_tmp134_ = _f_size;
			if (!(_tmp133_ < _tmp134_)) {
				break;
			}
			_tmp135_ = _f_list;
			_tmp136_ = _f_index;
			_tmp137_ = vala_list_get (_tmp135_, _tmp136_);
			f = (ValaField*) _tmp137_;
			_tmp138_ = f;
			_tmp139_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp138_, _tmp139_);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _tmp140_;
		ValaList* _tmp141_;
		ValaList* _c_list;
		ValaList* _tmp142_;
		gint _tmp143_;
		gint _tmp144_;
		gint _c_size;
		gint _c_index;
		_tmp140_ = self->priv->constants;
		_tmp141_ = _vala_iterable_ref0 (_tmp140_);
		_c_list = _tmp141_;
		_tmp142_ = _c_list;
		_tmp143_ = vala_collection_get_size ((ValaCollection*) _tmp142_);
		_tmp144_ = _tmp143_;
		_c_size = _tmp144_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp145_;
			gint _tmp146_;
			gint _tmp147_;
			ValaList* _tmp148_;
			gint _tmp149_;
			gpointer _tmp150_ = NULL;
			ValaConstant* c;
			ValaConstant* _tmp151_;
			ValaCodeContext* _tmp152_;
			_tmp145_ = _c_index;
			_c_index = _tmp145_ + 1;
			_tmp146_ = _c_index;
			_tmp147_ = _c_size;
			if (!(_tmp146_ < _tmp147_)) {
				break;
			}
			_tmp148_ = _c_list;
			_tmp149_ = _c_index;
			_tmp150_ = vala_list_get (_tmp148_, _tmp149_);
			c = (ValaConstant*) _tmp150_;
			_tmp151_ = c;
			_tmp152_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp151_, _tmp152_);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _tmp153_;
		ValaList* _tmp154_;
		ValaList* _m_list;
		ValaList* _tmp155_;
		gint _tmp156_;
		gint _tmp157_;
		gint _m_size;
		gint _m_index;
		_tmp153_ = self->priv->methods;
		_tmp154_ = _vala_iterable_ref0 (_tmp153_);
		_m_list = _tmp154_;
		_tmp155_ = _m_list;
		_tmp156_ = vala_collection_get_size ((ValaCollection*) _tmp155_);
		_tmp157_ = _tmp156_;
		_m_size = _tmp157_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp158_;
			gint _tmp159_;
			gint _tmp160_;
			ValaList* _tmp161_;
			gint _tmp162_;
			gpointer _tmp163_ = NULL;
			ValaMethod* m;
			ValaMethod* _tmp164_;
			ValaCodeContext* _tmp165_;
			_tmp158_ = _m_index;
			_m_index = _tmp158_ + 1;
			_tmp159_ = _m_index;
			_tmp160_ = _m_size;
			if (!(_tmp159_ < _tmp160_)) {
				break;
			}
			_tmp161_ = _m_list;
			_tmp162_ = _m_index;
			_tmp163_ = vala_list_get (_tmp161_, _tmp162_);
			m = (ValaMethod*) _tmp163_;
			_tmp164_ = m;
			_tmp165_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp164_, _tmp165_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _tmp166_;
		ValaList* _tmp167_;
		ValaList* _prop_list;
		ValaList* _tmp168_;
		gint _tmp169_;
		gint _tmp170_;
		gint _prop_size;
		gint _prop_index;
		_tmp166_ = self->priv->properties;
		_tmp167_ = _vala_iterable_ref0 (_tmp166_);
		_prop_list = _tmp167_;
		_tmp168_ = _prop_list;
		_tmp169_ = vala_collection_get_size ((ValaCollection*) _tmp168_);
		_tmp170_ = _tmp169_;
		_prop_size = _tmp170_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp171_;
			gint _tmp172_;
			gint _tmp173_;
			ValaList* _tmp174_;
			gint _tmp175_;
			gpointer _tmp176_ = NULL;
			ValaProperty* prop;
			ValaProperty* _tmp177_;
			ValaCodeContext* _tmp178_;
			_tmp171_ = _prop_index;
			_prop_index = _tmp171_ + 1;
			_tmp172_ = _prop_index;
			_tmp173_ = _prop_size;
			if (!(_tmp172_ < _tmp173_)) {
				break;
			}
			_tmp174_ = _prop_list;
			_tmp175_ = _prop_index;
			_tmp176_ = vala_list_get (_tmp174_, _tmp175_);
			prop = (ValaProperty*) _tmp176_;
			_tmp177_ = prop;
			_tmp178_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp177_, _tmp178_);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _tmp179_;
		ValaList* _tmp180_;
		ValaList* _sig_list;
		ValaList* _tmp181_;
		gint _tmp182_;
		gint _tmp183_;
		gint _sig_size;
		gint _sig_index;
		_tmp179_ = self->priv->signals;
		_tmp180_ = _vala_iterable_ref0 (_tmp179_);
		_sig_list = _tmp180_;
		_tmp181_ = _sig_list;
		_tmp182_ = vala_collection_get_size ((ValaCollection*) _tmp181_);
		_tmp183_ = _tmp182_;
		_sig_size = _tmp183_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp184_;
			gint _tmp185_;
			gint _tmp186_;
			ValaList* _tmp187_;
			gint _tmp188_;
			gpointer _tmp189_ = NULL;
			ValaSignal* sig;
			ValaSignal* _tmp190_;
			ValaCodeContext* _tmp191_;
			_tmp184_ = _sig_index;
			_sig_index = _tmp184_ + 1;
			_tmp185_ = _sig_index;
			_tmp186_ = _sig_size;
			if (!(_tmp185_ < _tmp186_)) {
				break;
			}
			_tmp187_ = _sig_list;
			_tmp188_ = _sig_index;
			_tmp189_ = vala_list_get (_tmp187_, _tmp188_);
			sig = (ValaSignal*) _tmp189_;
			_tmp190_ = sig;
			_tmp191_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp190_, _tmp191_);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp192_ = self->priv->_constructor;
	if (_tmp192_ != NULL) {
		ValaConstructor* _tmp193_;
		ValaCodeContext* _tmp194_;
		_tmp193_ = self->priv->_constructor;
		_tmp194_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp193_, _tmp194_);
	}
	_tmp195_ = self->priv->_class_constructor;
	if (_tmp195_ != NULL) {
		ValaConstructor* _tmp196_;
		ValaCodeContext* _tmp197_;
		_tmp196_ = self->priv->_class_constructor;
		_tmp197_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp196_, _tmp197_);
	}
	_tmp198_ = self->priv->_static_constructor;
	if (_tmp198_ != NULL) {
		ValaConstructor* _tmp199_;
		ValaCodeContext* _tmp200_;
		_tmp199_ = self->priv->_static_constructor;
		_tmp200_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp199_, _tmp200_);
	}
	_tmp201_ = vala_class_get_destructor (self);
	_tmp202_ = _tmp201_;
	if (_tmp202_ != NULL) {
		ValaDestructor* _tmp203_;
		ValaDestructor* _tmp204_;
		ValaCodeContext* _tmp205_;
		_tmp203_ = vala_class_get_destructor (self);
		_tmp204_ = _tmp203_;
		_tmp205_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp204_, _tmp205_);
	}
	_tmp206_ = self->priv->_static_destructor;
	if (_tmp206_ != NULL) {
		ValaDestructor* _tmp207_;
		ValaCodeContext* _tmp208_;
		_tmp207_ = self->priv->_static_destructor;
		_tmp208_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp207_, _tmp208_);
	}
	_tmp209_ = self->priv->_class_destructor;
	if (_tmp209_ != NULL) {
		ValaDestructor* _tmp210_;
		ValaCodeContext* _tmp211_;
		_tmp210_ = self->priv->_class_destructor;
		_tmp211_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp210_, _tmp211_);
	}
	{
		ValaList* _tmp212_;
		ValaList* _tmp213_;
		ValaList* _cl_list;
		ValaList* _tmp214_;
		gint _tmp215_;
		gint _tmp216_;
		gint _cl_size;
		gint _cl_index;
		_tmp212_ = self->priv->classes;
		_tmp213_ = _vala_iterable_ref0 (_tmp212_);
		_cl_list = _tmp213_;
		_tmp214_ = _cl_list;
		_tmp215_ = vala_collection_get_size ((ValaCollection*) _tmp214_);
		_tmp216_ = _tmp215_;
		_cl_size = _tmp216_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp217_;
			gint _tmp218_;
			gint _tmp219_;
			ValaList* _tmp220_;
			gint _tmp221_;
			gpointer _tmp222_ = NULL;
			ValaClass* cl;
			ValaClass* _tmp223_;
			ValaCodeContext* _tmp224_;
			_tmp217_ = _cl_index;
			_cl_index = _tmp217_ + 1;
			_tmp218_ = _cl_index;
			_tmp219_ = _cl_size;
			if (!(_tmp218_ < _tmp219_)) {
				break;
			}
			_tmp220_ = _cl_list;
			_tmp221_ = _cl_index;
			_tmp222_ = vala_list_get (_tmp220_, _tmp221_);
			cl = (ValaClass*) _tmp222_;
			_tmp223_ = cl;
			_tmp224_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp223_, _tmp224_);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _tmp225_;
		ValaList* _tmp226_;
		ValaList* _st_list;
		ValaList* _tmp227_;
		gint _tmp228_;
		gint _tmp229_;
		gint _st_size;
		gint _st_index;
		_tmp225_ = self->priv->structs;
		_tmp226_ = _vala_iterable_ref0 (_tmp225_);
		_st_list = _tmp226_;
		_tmp227_ = _st_list;
		_tmp228_ = vala_collection_get_size ((ValaCollection*) _tmp227_);
		_tmp229_ = _tmp228_;
		_st_size = _tmp229_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp230_;
			gint _tmp231_;
			gint _tmp232_;
			ValaList* _tmp233_;
			gint _tmp234_;
			gpointer _tmp235_ = NULL;
			ValaStruct* st;
			ValaStruct* _tmp236_;
			ValaCodeContext* _tmp237_;
			_tmp230_ = _st_index;
			_st_index = _tmp230_ + 1;
			_tmp231_ = _st_index;
			_tmp232_ = _st_size;
			if (!(_tmp231_ < _tmp232_)) {
				break;
			}
			_tmp233_ = _st_list;
			_tmp234_ = _st_index;
			_tmp235_ = vala_list_get (_tmp233_, _tmp234_);
			st = (ValaStruct*) _tmp235_;
			_tmp236_ = st;
			_tmp237_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp236_, _tmp237_);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _tmp238_;
		ValaList* _tmp239_;
		ValaList* _d_list;
		ValaList* _tmp240_;
		gint _tmp241_;
		gint _tmp242_;
		gint _d_size;
		gint _d_index;
		_tmp238_ = self->priv->delegates;
		_tmp239_ = _vala_iterable_ref0 (_tmp238_);
		_d_list = _tmp239_;
		_tmp240_ = _d_list;
		_tmp241_ = vala_collection_get_size ((ValaCollection*) _tmp240_);
		_tmp242_ = _tmp241_;
		_d_size = _tmp242_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp243_;
			gint _tmp244_;
			gint _tmp245_;
			ValaList* _tmp246_;
			gint _tmp247_;
			gpointer _tmp248_ = NULL;
			ValaDelegate* d;
			ValaDelegate* _tmp249_;
			ValaCodeContext* _tmp250_;
			_tmp243_ = _d_index;
			_d_index = _tmp243_ + 1;
			_tmp244_ = _d_index;
			_tmp245_ = _d_size;
			if (!(_tmp244_ < _tmp245_)) {
				break;
			}
			_tmp246_ = _d_list;
			_tmp247_ = _d_index;
			_tmp248_ = vala_list_get (_tmp246_, _tmp247_);
			d = (ValaDelegate*) _tmp248_;
			_tmp249_ = d;
			_tmp250_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp249_, _tmp250_);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp251_ = vala_class_get_is_compact (self);
	_tmp252_ = _tmp251_;
	if (_tmp252_) {
		gboolean _tmp272_ = FALSE;
		gboolean _tmp273_ = FALSE;
		gboolean _tmp274_;
		gboolean _tmp275_;
		gboolean _tmp278_;
		gboolean _tmp280_;
		{
			ValaList* _tmp253_ = NULL;
			ValaList* _base_type_list;
			ValaList* _tmp254_;
			gint _tmp255_;
			gint _tmp256_;
			gint _base_type_size;
			gint _base_type_index;
			_tmp253_ = vala_class_get_base_types (self);
			_base_type_list = _tmp253_;
			_tmp254_ = _base_type_list;
			_tmp255_ = vala_collection_get_size ((ValaCollection*) _tmp254_);
			_tmp256_ = _tmp255_;
			_base_type_size = _tmp256_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp257_;
				gint _tmp258_;
				gint _tmp259_;
				ValaList* _tmp260_;
				gint _tmp261_;
				gpointer _tmp262_ = NULL;
				ValaDataType* base_type;
				ValaDataType* _tmp263_;
				ValaTypeSymbol* _tmp264_;
				ValaTypeSymbol* _tmp265_;
				_tmp257_ = _base_type_index;
				_base_type_index = _tmp257_ + 1;
				_tmp258_ = _base_type_index;
				_tmp259_ = _base_type_size;
				if (!(_tmp258_ < _tmp259_)) {
					break;
				}
				_tmp260_ = _base_type_list;
				_tmp261_ = _base_type_index;
				_tmp262_ = vala_list_get (_tmp260_, _tmp261_);
				base_type = (ValaDataType*) _tmp262_;
				_tmp263_ = base_type;
				_tmp264_ = vala_data_type_get_data_type (_tmp263_);
				_tmp265_ = _tmp264_;
				if (VALA_IS_INTERFACE (_tmp265_)) {
					ValaSourceReference* _tmp266_;
					ValaSourceReference* _tmp267_;
					gchar* _tmp268_ = NULL;
					gchar* _tmp269_;
					gchar* _tmp270_ = NULL;
					gchar* _tmp271_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp266_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp267_ = _tmp266_;
					_tmp268_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp269_ = _tmp268_;
					_tmp270_ = g_strdup_printf ("compact classes `%s` may not implement interfaces", _tmp269_);
					_tmp271_ = _tmp270_;
					vala_report_error (_tmp267_, _tmp271_);
					_g_free0 (_tmp271_);
					_g_free0 (_tmp269_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp274_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp275_ = _tmp274_;
		if (!_tmp275_) {
			gboolean _tmp276_;
			gboolean _tmp277_;
			_tmp276_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp277_ = _tmp276_;
			_tmp273_ = !_tmp277_;
		} else {
			_tmp273_ = FALSE;
		}
		_tmp278_ = _tmp273_;
		if (_tmp278_) {
			ValaClass* _tmp279_;
			_tmp279_ = self->priv->_base_class;
			_tmp272_ = _tmp279_ != NULL;
		} else {
			_tmp272_ = FALSE;
		}
		_tmp280_ = _tmp272_;
		if (_tmp280_) {
			{
				ValaList* _tmp281_;
				ValaList* _tmp282_;
				ValaList* _f_list;
				ValaList* _tmp283_;
				gint _tmp284_;
				gint _tmp285_;
				gint _f_size;
				gint _f_index;
				_tmp281_ = self->priv->fields;
				_tmp282_ = _vala_iterable_ref0 (_tmp281_);
				_f_list = _tmp282_;
				_tmp283_ = _f_list;
				_tmp284_ = vala_collection_get_size ((ValaCollection*) _tmp283_);
				_tmp285_ = _tmp284_;
				_f_size = _tmp285_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp286_;
					gint _tmp287_;
					gint _tmp288_;
					ValaList* _tmp289_;
					gint _tmp290_;
					gpointer _tmp291_ = NULL;
					ValaField* f;
					ValaField* _tmp292_;
					ValaMemberBinding _tmp293_;
					ValaMemberBinding _tmp294_;
					_tmp286_ = _f_index;
					_f_index = _tmp286_ + 1;
					_tmp287_ = _f_index;
					_tmp288_ = _f_size;
					if (!(_tmp287_ < _tmp288_)) {
						break;
					}
					_tmp289_ = _f_list;
					_tmp290_ = _f_index;
					_tmp291_ = vala_list_get (_tmp289_, _tmp290_);
					f = (ValaField*) _tmp291_;
					_tmp292_ = f;
					_tmp293_ = vala_field_get_binding (_tmp292_);
					_tmp294_ = _tmp293_;
					if (_tmp294_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp295_;
						ValaSourceReference* _tmp296_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp295_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp296_ = _tmp295_;
						vala_report_error (_tmp296_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp297_ = g_direct_equal;
	_tmp298_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp297_);
	prerequisites = (ValaList*) _tmp298_;
	{
		ValaList* _tmp299_ = NULL;
		ValaList* _base_type_list;
		ValaList* _tmp300_;
		gint _tmp301_;
		gint _tmp302_;
		gint _base_type_size;
		gint _base_type_index;
		_tmp299_ = vala_class_get_base_types (self);
		_base_type_list = _tmp299_;
		_tmp300_ = _base_type_list;
		_tmp301_ = vala_collection_get_size ((ValaCollection*) _tmp300_);
		_tmp302_ = _tmp301_;
		_base_type_size = _tmp302_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp303_;
			gint _tmp304_;
			gint _tmp305_;
			ValaList* _tmp306_;
			gint _tmp307_;
			gpointer _tmp308_ = NULL;
			ValaDataType* base_type;
			ValaDataType* _tmp309_;
			ValaTypeSymbol* _tmp310_;
			ValaTypeSymbol* _tmp311_;
			_tmp303_ = _base_type_index;
			_base_type_index = _tmp303_ + 1;
			_tmp304_ = _base_type_index;
			_tmp305_ = _base_type_size;
			if (!(_tmp304_ < _tmp305_)) {
				break;
			}
			_tmp306_ = _base_type_list;
			_tmp307_ = _base_type_index;
			_tmp308_ = vala_list_get (_tmp306_, _tmp307_);
			base_type = (ValaDataType*) _tmp308_;
			_tmp309_ = base_type;
			_tmp310_ = vala_data_type_get_data_type (_tmp309_);
			_tmp311_ = _tmp310_;
			if (VALA_IS_INTERFACE (_tmp311_)) {
				ValaDataType* _tmp312_;
				ValaTypeSymbol* _tmp313_;
				ValaTypeSymbol* _tmp314_;
				ValaList* _tmp315_;
				_tmp312_ = base_type;
				_tmp313_ = vala_data_type_get_data_type (_tmp312_);
				_tmp314_ = _tmp313_;
				_tmp315_ = prerequisites;
				vala_class_get_all_prerequisites (self, VALA_INTERFACE (_tmp314_), _tmp315_);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp316_ = g_direct_equal;
	_tmp317_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp316_);
	missing_prereqs = (ValaList*) _tmp317_;
	{
		ValaList* _tmp318_;
		ValaList* _tmp319_;
		ValaList* _prereq_list;
		ValaList* _tmp320_;
		gint _tmp321_;
		gint _tmp322_;
		gint _prereq_size;
		gint _prereq_index;
		_tmp318_ = prerequisites;
		_tmp319_ = _vala_iterable_ref0 (_tmp318_);
		_prereq_list = _tmp319_;
		_tmp320_ = _prereq_list;
		_tmp321_ = vala_collection_get_size ((ValaCollection*) _tmp320_);
		_tmp322_ = _tmp321_;
		_prereq_size = _tmp322_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp323_;
			gint _tmp324_;
			gint _tmp325_;
			ValaList* _tmp326_;
			gint _tmp327_;
			gpointer _tmp328_ = NULL;
			ValaTypeSymbol* prereq;
			ValaTypeSymbol* _tmp329_;
			gboolean _tmp330_ = FALSE;
			_tmp323_ = _prereq_index;
			_prereq_index = _tmp323_ + 1;
			_tmp324_ = _prereq_index;
			_tmp325_ = _prereq_size;
			if (!(_tmp324_ < _tmp325_)) {
				break;
			}
			_tmp326_ = _prereq_list;
			_tmp327_ = _prereq_index;
			_tmp328_ = vala_list_get (_tmp326_, _tmp327_);
			prereq = (ValaTypeSymbol*) _tmp328_;
			_tmp329_ = prereq;
			_tmp330_ = vala_class_class_is_a (self, self, _tmp329_);
			if (!_tmp330_) {
				ValaList* _tmp331_;
				ValaTypeSymbol* _tmp332_;
				gchar* _tmp333_ = NULL;
				gchar* _tmp334_;
				_tmp331_ = missing_prereqs;
				_tmp332_ = prereq;
				_tmp333_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp332_);
				_tmp334_ = _tmp333_;
				vala_list_insert (_tmp331_, 0, _tmp334_);
				_g_free0 (_tmp334_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp335_ = missing_prereqs;
	_tmp336_ = vala_collection_get_size ((ValaCollection*) _tmp335_);
	_tmp337_ = _tmp336_;
	if (_tmp337_ > 0) {
		gchar* _tmp338_ = NULL;
		gchar* _tmp339_;
		gchar* _tmp340_ = NULL;
		gchar* _tmp341_;
		gchar* error_string;
		gboolean first;
		const gchar* _tmp360_;
		gchar* _tmp361_;
		ValaSourceReference* _tmp362_;
		ValaSourceReference* _tmp363_;
		const gchar* _tmp364_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp338_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp339_ = _tmp338_;
		_tmp340_ = g_strdup_printf ("%s: some prerequisites (", _tmp339_);
		_tmp341_ = _tmp340_;
		_g_free0 (_tmp339_);
		error_string = _tmp341_;
		first = TRUE;
		{
			ValaList* _tmp342_;
			ValaList* _tmp343_;
			ValaList* _s_list;
			ValaList* _tmp344_;
			gint _tmp345_;
			gint _tmp346_;
			gint _s_size;
			gint _s_index;
			_tmp342_ = missing_prereqs;
			_tmp343_ = _vala_iterable_ref0 (_tmp342_);
			_s_list = _tmp343_;
			_tmp344_ = _s_list;
			_tmp345_ = vala_collection_get_size ((ValaCollection*) _tmp344_);
			_tmp346_ = _tmp345_;
			_s_size = _tmp346_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp347_;
				gint _tmp348_;
				gint _tmp349_;
				ValaList* _tmp350_;
				gint _tmp351_;
				gpointer _tmp352_ = NULL;
				gchar* s;
				gboolean _tmp353_;
				_tmp347_ = _s_index;
				_s_index = _tmp347_ + 1;
				_tmp348_ = _s_index;
				_tmp349_ = _s_size;
				if (!(_tmp348_ < _tmp349_)) {
					break;
				}
				_tmp350_ = _s_list;
				_tmp351_ = _s_index;
				_tmp352_ = vala_list_get (_tmp350_, _tmp351_);
				s = (gchar*) _tmp352_;
				_tmp353_ = first;
				if (_tmp353_) {
					const gchar* _tmp354_;
					const gchar* _tmp355_;
					gchar* _tmp356_ = NULL;
					_tmp354_ = error_string;
					_tmp355_ = s;
					_tmp356_ = g_strdup_printf ("%s`%s'", _tmp354_, _tmp355_);
					_g_free0 (error_string);
					error_string = _tmp356_;
					first = FALSE;
				} else {
					const gchar* _tmp357_;
					const gchar* _tmp358_;
					gchar* _tmp359_ = NULL;
					_tmp357_ = error_string;
					_tmp358_ = s;
					_tmp359_ = g_strdup_printf ("%s, `%s'", _tmp357_, _tmp358_);
					_g_free0 (error_string);
					error_string = _tmp359_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp360_ = error_string;
		_tmp361_ = g_strconcat (_tmp360_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp361_;
		_tmp362_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp363_ = _tmp362_;
		_tmp364_ = error_string;
		vala_report_error (_tmp363_, _tmp364_);
		_g_free0 (error_string);
	}
	_tmp365_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp366_ = _tmp365_;
	if (_tmp366_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp482_;
		{
			ValaList* _tmp367_ = NULL;
			ValaList* _base_type_list;
			ValaList* _tmp368_;
			gint _tmp369_;
			gint _tmp370_;
			gint _base_type_size;
			gint _base_type_index;
			_tmp367_ = vala_class_get_base_types (self);
			_base_type_list = _tmp367_;
			_tmp368_ = _base_type_list;
			_tmp369_ = vala_collection_get_size ((ValaCollection*) _tmp368_);
			_tmp370_ = _tmp369_;
			_base_type_size = _tmp370_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp371_;
				gint _tmp372_;
				gint _tmp373_;
				ValaList* _tmp374_;
				gint _tmp375_;
				gpointer _tmp376_ = NULL;
				ValaDataType* base_type;
				ValaDataType* _tmp377_;
				ValaTypeSymbol* _tmp378_;
				ValaTypeSymbol* _tmp379_;
				_tmp371_ = _base_type_index;
				_base_type_index = _tmp371_ + 1;
				_tmp372_ = _base_type_index;
				_tmp373_ = _base_type_size;
				if (!(_tmp372_ < _tmp373_)) {
					break;
				}
				_tmp374_ = _base_type_list;
				_tmp375_ = _base_type_index;
				_tmp376_ = vala_list_get (_tmp374_, _tmp375_);
				base_type = (ValaDataType*) _tmp376_;
				_tmp377_ = base_type;
				_tmp378_ = vala_data_type_get_data_type (_tmp377_);
				_tmp379_ = _tmp378_;
				if (VALA_IS_INTERFACE (_tmp379_)) {
					ValaDataType* _tmp380_;
					ValaTypeSymbol* _tmp381_;
					ValaTypeSymbol* _tmp382_;
					ValaInterface* _tmp383_;
					ValaInterface* iface;
					gboolean _tmp384_ = FALSE;
					ValaClass* _tmp385_;
					gboolean _tmp389_;
					_tmp380_ = base_type;
					_tmp381_ = vala_data_type_get_data_type (_tmp380_);
					_tmp382_ = _tmp381_;
					_tmp383_ = _vala_code_node_ref0 (VALA_INTERFACE (_tmp382_));
					iface = _tmp383_;
					_tmp385_ = self->priv->_base_class;
					if (_tmp385_ != NULL) {
						ValaClass* _tmp386_;
						ValaInterface* _tmp387_;
						gboolean _tmp388_ = FALSE;
						_tmp386_ = self->priv->_base_class;
						_tmp387_ = iface;
						_tmp388_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp386_, (ValaTypeSymbol*) _tmp387_);
						_tmp384_ = _tmp388_;
					} else {
						_tmp384_ = FALSE;
					}
					_tmp389_ = _tmp384_;
					if (_tmp389_) {
						_vala_code_node_unref0 (iface);
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaInterface* _tmp390_;
						ValaList* _tmp391_ = NULL;
						ValaList* _m_list;
						ValaList* _tmp392_;
						gint _tmp393_;
						gint _tmp394_;
						gint _m_size;
						gint _m_index;
						_tmp390_ = iface;
						_tmp391_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp390_);
						_m_list = _tmp391_;
						_tmp392_ = _m_list;
						_tmp393_ = vala_collection_get_size ((ValaCollection*) _tmp392_);
						_tmp394_ = _tmp393_;
						_m_size = _tmp394_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp395_;
							gint _tmp396_;
							gint _tmp397_;
							ValaList* _tmp398_;
							gint _tmp399_;
							gpointer _tmp400_ = NULL;
							ValaMethod* m;
							ValaMethod* _tmp401_;
							gboolean _tmp402_;
							gboolean _tmp403_;
							_tmp395_ = _m_index;
							_m_index = _tmp395_ + 1;
							_tmp396_ = _m_index;
							_tmp397_ = _m_size;
							if (!(_tmp396_ < _tmp397_)) {
								break;
							}
							_tmp398_ = _m_list;
							_tmp399_ = _m_index;
							_tmp400_ = vala_list_get (_tmp398_, _tmp399_);
							m = (ValaMethod*) _tmp400_;
							_tmp401_ = m;
							_tmp402_ = vala_method_get_is_abstract (_tmp401_);
							_tmp403_ = _tmp402_;
							if (_tmp403_) {
								ValaSymbol* sym;
								ValaClass* _tmp404_;
								ValaClass* base_class;
								ValaSymbol* _tmp419_;
								sym = NULL;
								_tmp404_ = _vala_code_node_ref0 (self);
								base_class = _tmp404_;
								while (TRUE) {
									gboolean _tmp405_ = FALSE;
									ValaClass* _tmp406_;
									gboolean _tmp408_;
									ValaClass* _tmp409_;
									ValaScope* _tmp410_;
									ValaScope* _tmp411_;
									ValaMethod* _tmp412_;
									const gchar* _tmp413_;
									const gchar* _tmp414_;
									ValaSymbol* _tmp415_ = NULL;
									ValaClass* _tmp416_;
									ValaClass* _tmp417_;
									ValaClass* _tmp418_;
									_tmp406_ = base_class;
									if (_tmp406_ != NULL) {
										ValaSymbol* _tmp407_;
										_tmp407_ = sym;
										_tmp405_ = !VALA_IS_METHOD (_tmp407_);
									} else {
										_tmp405_ = FALSE;
									}
									_tmp408_ = _tmp405_;
									if (!_tmp408_) {
										break;
									}
									_tmp409_ = base_class;
									_tmp410_ = vala_symbol_get_scope ((ValaSymbol*) _tmp409_);
									_tmp411_ = _tmp410_;
									_tmp412_ = m;
									_tmp413_ = vala_symbol_get_name ((ValaSymbol*) _tmp412_);
									_tmp414_ = _tmp413_;
									_tmp415_ = vala_scope_lookup (_tmp411_, _tmp414_);
									_vala_code_node_unref0 (sym);
									sym = _tmp415_;
									_tmp416_ = base_class;
									_tmp417_ = _tmp416_->priv->_base_class;
									_tmp418_ = _vala_code_node_ref0 (_tmp417_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp418_;
								}
								_tmp419_ = sym;
								if (VALA_IS_METHOD (_tmp419_)) {
									ValaSymbol* _tmp420_;
									ValaSourceReference* _tmp421_;
									ValaSourceReference* _tmp422_;
									ValaSymbol* _tmp423_;
									ValaSourceReference* _tmp424_;
									ValaSourceReference* _tmp425_;
									ValaSymbol* _tmp426_;
									_tmp420_ = sym;
									_tmp421_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp422_ = _tmp421_;
									vala_symbol_check_deprecated (_tmp420_, _tmp422_);
									_tmp423_ = sym;
									_tmp424_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp425_ = _tmp424_;
									vala_symbol_check_experimental (_tmp423_, _tmp425_);
									_tmp426_ = sym;
									vala_symbol_set_used (_tmp426_, TRUE);
								} else {
									ValaSourceReference* _tmp427_;
									ValaSourceReference* _tmp428_;
									gchar* _tmp429_ = NULL;
									gchar* _tmp430_;
									ValaMethod* _tmp431_;
									gchar* _tmp432_ = NULL;
									gchar* _tmp433_;
									gchar* _tmp434_ = NULL;
									gchar* _tmp435_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp427_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp428_ = _tmp427_;
									_tmp429_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp430_ = _tmp429_;
									_tmp431_ = m;
									_tmp432_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp431_);
									_tmp433_ = _tmp432_;
									_tmp434_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp430_, _tmp433_);
									_tmp435_ = _tmp434_;
									vala_report_error (_tmp428_, _tmp435_);
									_g_free0 (_tmp435_);
									_g_free0 (_tmp433_);
									_g_free0 (_tmp430_);
								}
								_vala_code_node_unref0 (base_class);
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaInterface* _tmp436_;
						ValaList* _tmp437_ = NULL;
						ValaList* _prop_list;
						ValaList* _tmp438_;
						gint _tmp439_;
						gint _tmp440_;
						gint _prop_size;
						gint _prop_index;
						_tmp436_ = iface;
						_tmp437_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp436_);
						_prop_list = _tmp437_;
						_tmp438_ = _prop_list;
						_tmp439_ = vala_collection_get_size ((ValaCollection*) _tmp438_);
						_tmp440_ = _tmp439_;
						_prop_size = _tmp440_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp441_;
							gint _tmp442_;
							gint _tmp443_;
							ValaList* _tmp444_;
							gint _tmp445_;
							gpointer _tmp446_ = NULL;
							ValaProperty* prop;
							ValaProperty* _tmp447_;
							gboolean _tmp448_;
							gboolean _tmp449_;
							_tmp441_ = _prop_index;
							_prop_index = _tmp441_ + 1;
							_tmp442_ = _prop_index;
							_tmp443_ = _prop_size;
							if (!(_tmp442_ < _tmp443_)) {
								break;
							}
							_tmp444_ = _prop_list;
							_tmp445_ = _prop_index;
							_tmp446_ = vala_list_get (_tmp444_, _tmp445_);
							prop = (ValaProperty*) _tmp446_;
							_tmp447_ = prop;
							_tmp448_ = vala_property_get_is_abstract (_tmp447_);
							_tmp449_ = _tmp448_;
							if (_tmp449_) {
								ValaSymbol* sym;
								ValaClass* _tmp450_;
								ValaClass* base_class;
								ValaSymbol* _tmp465_;
								sym = NULL;
								_tmp450_ = _vala_code_node_ref0 (self);
								base_class = _tmp450_;
								while (TRUE) {
									gboolean _tmp451_ = FALSE;
									ValaClass* _tmp452_;
									gboolean _tmp454_;
									ValaClass* _tmp455_;
									ValaScope* _tmp456_;
									ValaScope* _tmp457_;
									ValaProperty* _tmp458_;
									const gchar* _tmp459_;
									const gchar* _tmp460_;
									ValaSymbol* _tmp461_ = NULL;
									ValaClass* _tmp462_;
									ValaClass* _tmp463_;
									ValaClass* _tmp464_;
									_tmp452_ = base_class;
									if (_tmp452_ != NULL) {
										ValaSymbol* _tmp453_;
										_tmp453_ = sym;
										_tmp451_ = !VALA_IS_PROPERTY (_tmp453_);
									} else {
										_tmp451_ = FALSE;
									}
									_tmp454_ = _tmp451_;
									if (!_tmp454_) {
										break;
									}
									_tmp455_ = base_class;
									_tmp456_ = vala_symbol_get_scope ((ValaSymbol*) _tmp455_);
									_tmp457_ = _tmp456_;
									_tmp458_ = prop;
									_tmp459_ = vala_symbol_get_name ((ValaSymbol*) _tmp458_);
									_tmp460_ = _tmp459_;
									_tmp461_ = vala_scope_lookup (_tmp457_, _tmp460_);
									_vala_code_node_unref0 (sym);
									sym = _tmp461_;
									_tmp462_ = base_class;
									_tmp463_ = _tmp462_->priv->_base_class;
									_tmp464_ = _vala_code_node_ref0 (_tmp463_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp464_;
								}
								_tmp465_ = sym;
								if (VALA_IS_PROPERTY (_tmp465_)) {
									ValaSymbol* _tmp466_;
									ValaSourceReference* _tmp467_;
									ValaSourceReference* _tmp468_;
									ValaSymbol* _tmp469_;
									ValaSourceReference* _tmp470_;
									ValaSourceReference* _tmp471_;
									ValaSymbol* _tmp472_;
									_tmp466_ = sym;
									_tmp467_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp468_ = _tmp467_;
									vala_symbol_check_deprecated (_tmp466_, _tmp468_);
									_tmp469_ = sym;
									_tmp470_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp471_ = _tmp470_;
									vala_symbol_check_experimental (_tmp469_, _tmp471_);
									_tmp472_ = sym;
									vala_symbol_set_used (_tmp472_, TRUE);
								} else {
									ValaSourceReference* _tmp473_;
									ValaSourceReference* _tmp474_;
									gchar* _tmp475_ = NULL;
									gchar* _tmp476_;
									ValaProperty* _tmp477_;
									gchar* _tmp478_ = NULL;
									gchar* _tmp479_;
									gchar* _tmp480_ = NULL;
									gchar* _tmp481_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp473_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp474_ = _tmp473_;
									_tmp475_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp476_ = _tmp475_;
									_tmp477_ = prop;
									_tmp478_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp477_);
									_tmp479_ = _tmp478_;
									_tmp480_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp476_, _tmp479_);
									_tmp481_ = _tmp480_;
									vala_report_error (_tmp474_, _tmp481_);
									_g_free0 (_tmp481_);
									_g_free0 (_tmp479_);
									_g_free0 (_tmp476_);
								}
								_vala_code_node_unref0 (base_class);
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
					_vala_code_node_unref0 (iface);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp482_ = self->priv->_is_abstract;
		if (!_tmp482_) {
			ValaClass* _tmp483_;
			ValaClass* _tmp484_;
			ValaClass* base_class;
			_tmp483_ = self->priv->_base_class;
			_tmp484_ = _vala_code_node_ref0 (_tmp483_);
			base_class = _tmp484_;
			while (TRUE) {
				gboolean _tmp485_ = FALSE;
				ValaClass* _tmp486_;
				gboolean _tmp489_;
				ValaClass* _tmp562_;
				ValaClass* _tmp563_;
				ValaClass* _tmp564_;
				_tmp486_ = base_class;
				if (_tmp486_ != NULL) {
					ValaClass* _tmp487_;
					gboolean _tmp488_;
					_tmp487_ = base_class;
					_tmp488_ = _tmp487_->priv->_is_abstract;
					_tmp485_ = _tmp488_;
				} else {
					_tmp485_ = FALSE;
				}
				_tmp489_ = _tmp485_;
				if (!_tmp489_) {
					break;
				}
				{
					ValaClass* _tmp490_;
					ValaList* _tmp491_ = NULL;
					ValaList* _base_method_list;
					ValaList* _tmp492_;
					gint _tmp493_;
					gint _tmp494_;
					gint _base_method_size;
					gint _base_method_index;
					_tmp490_ = base_class;
					_tmp491_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp490_);
					_base_method_list = _tmp491_;
					_tmp492_ = _base_method_list;
					_tmp493_ = vala_collection_get_size ((ValaCollection*) _tmp492_);
					_tmp494_ = _tmp493_;
					_base_method_size = _tmp494_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp495_;
						gint _tmp496_;
						gint _tmp497_;
						ValaList* _tmp498_;
						gint _tmp499_;
						gpointer _tmp500_ = NULL;
						ValaMethod* base_method;
						ValaMethod* _tmp501_;
						gboolean _tmp502_;
						gboolean _tmp503_;
						_tmp495_ = _base_method_index;
						_base_method_index = _tmp495_ + 1;
						_tmp496_ = _base_method_index;
						_tmp497_ = _base_method_size;
						if (!(_tmp496_ < _tmp497_)) {
							break;
						}
						_tmp498_ = _base_method_list;
						_tmp499_ = _base_method_index;
						_tmp500_ = vala_list_get (_tmp498_, _tmp499_);
						base_method = (ValaMethod*) _tmp500_;
						_tmp501_ = base_method;
						_tmp502_ = vala_method_get_is_abstract (_tmp501_);
						_tmp503_ = _tmp502_;
						if (_tmp503_) {
							ValaCodeContext* _tmp504_;
							ValaSemanticAnalyzer* _tmp505_;
							ValaSemanticAnalyzer* _tmp506_;
							ValaMethod* _tmp507_;
							const gchar* _tmp508_;
							const gchar* _tmp509_;
							ValaSymbol* _tmp510_ = NULL;
							ValaMethod* override_method;
							gboolean _tmp511_ = FALSE;
							ValaMethod* _tmp512_;
							gboolean _tmp516_;
							_tmp504_ = context;
							_tmp505_ = vala_code_context_get_analyzer (_tmp504_);
							_tmp506_ = _tmp505_;
							_tmp507_ = base_method;
							_tmp508_ = vala_symbol_get_name ((ValaSymbol*) _tmp507_);
							_tmp509_ = _tmp508_;
							_tmp510_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp509_);
							override_method = VALA_IS_METHOD (_tmp510_) ? ((ValaMethod*) _tmp510_) : NULL;
							_tmp512_ = override_method;
							if (_tmp512_ == NULL) {
								_tmp511_ = TRUE;
							} else {
								ValaMethod* _tmp513_;
								gboolean _tmp514_;
								gboolean _tmp515_;
								_tmp513_ = override_method;
								_tmp514_ = vala_method_get_overrides (_tmp513_);
								_tmp515_ = _tmp514_;
								_tmp511_ = !_tmp515_;
							}
							_tmp516_ = _tmp511_;
							if (_tmp516_) {
								ValaSourceReference* _tmp517_;
								ValaSourceReference* _tmp518_;
								gchar* _tmp519_ = NULL;
								gchar* _tmp520_;
								ValaMethod* _tmp521_;
								gchar* _tmp522_ = NULL;
								gchar* _tmp523_;
								gchar* _tmp524_ = NULL;
								gchar* _tmp525_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp517_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp518_ = _tmp517_;
								_tmp519_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp520_ = _tmp519_;
								_tmp521_ = base_method;
								_tmp522_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp521_);
								_tmp523_ = _tmp522_;
								_tmp524_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp520_, _tmp523_);
								_tmp525_ = _tmp524_;
								vala_report_error (_tmp518_, _tmp525_);
								_g_free0 (_tmp525_);
								_g_free0 (_tmp523_);
								_g_free0 (_tmp520_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaClass* _tmp526_;
					ValaList* _tmp527_ = NULL;
					ValaList* _base_property_list;
					ValaList* _tmp528_;
					gint _tmp529_;
					gint _tmp530_;
					gint _base_property_size;
					gint _base_property_index;
					_tmp526_ = base_class;
					_tmp527_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp526_);
					_base_property_list = _tmp527_;
					_tmp528_ = _base_property_list;
					_tmp529_ = vala_collection_get_size ((ValaCollection*) _tmp528_);
					_tmp530_ = _tmp529_;
					_base_property_size = _tmp530_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp531_;
						gint _tmp532_;
						gint _tmp533_;
						ValaList* _tmp534_;
						gint _tmp535_;
						gpointer _tmp536_ = NULL;
						ValaProperty* base_property;
						ValaProperty* _tmp537_;
						gboolean _tmp538_;
						gboolean _tmp539_;
						_tmp531_ = _base_property_index;
						_base_property_index = _tmp531_ + 1;
						_tmp532_ = _base_property_index;
						_tmp533_ = _base_property_size;
						if (!(_tmp532_ < _tmp533_)) {
							break;
						}
						_tmp534_ = _base_property_list;
						_tmp535_ = _base_property_index;
						_tmp536_ = vala_list_get (_tmp534_, _tmp535_);
						base_property = (ValaProperty*) _tmp536_;
						_tmp537_ = base_property;
						_tmp538_ = vala_property_get_is_abstract (_tmp537_);
						_tmp539_ = _tmp538_;
						if (_tmp539_) {
							ValaCodeContext* _tmp540_;
							ValaSemanticAnalyzer* _tmp541_;
							ValaSemanticAnalyzer* _tmp542_;
							ValaProperty* _tmp543_;
							const gchar* _tmp544_;
							const gchar* _tmp545_;
							ValaSymbol* _tmp546_ = NULL;
							ValaProperty* override_property;
							gboolean _tmp547_ = FALSE;
							ValaProperty* _tmp548_;
							gboolean _tmp552_;
							_tmp540_ = context;
							_tmp541_ = vala_code_context_get_analyzer (_tmp540_);
							_tmp542_ = _tmp541_;
							_tmp543_ = base_property;
							_tmp544_ = vala_symbol_get_name ((ValaSymbol*) _tmp543_);
							_tmp545_ = _tmp544_;
							_tmp546_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp545_);
							override_property = VALA_IS_PROPERTY (_tmp546_) ? ((ValaProperty*) _tmp546_) : NULL;
							_tmp548_ = override_property;
							if (_tmp548_ == NULL) {
								_tmp547_ = TRUE;
							} else {
								ValaProperty* _tmp549_;
								gboolean _tmp550_;
								gboolean _tmp551_;
								_tmp549_ = override_property;
								_tmp550_ = vala_property_get_overrides (_tmp549_);
								_tmp551_ = _tmp550_;
								_tmp547_ = !_tmp551_;
							}
							_tmp552_ = _tmp547_;
							if (_tmp552_) {
								ValaSourceReference* _tmp553_;
								ValaSourceReference* _tmp554_;
								gchar* _tmp555_ = NULL;
								gchar* _tmp556_;
								ValaProperty* _tmp557_;
								gchar* _tmp558_ = NULL;
								gchar* _tmp559_;
								gchar* _tmp560_ = NULL;
								gchar* _tmp561_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp553_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp554_ = _tmp553_;
								_tmp555_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp556_ = _tmp555_;
								_tmp557_ = base_property;
								_tmp558_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp557_);
								_tmp559_ = _tmp558_;
								_tmp560_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp556_, _tmp559_);
								_tmp561_ = _tmp560_;
								vala_report_error (_tmp554_, _tmp561_);
								_g_free0 (_tmp561_);
								_g_free0 (_tmp559_);
								_g_free0 (_tmp556_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp562_ = base_class;
				_tmp563_ = _tmp562_->priv->_base_class;
				_tmp564_ = _vala_code_node_ref0 (_tmp563_);
				_vala_code_node_unref0 (base_class);
				base_class = _tmp564_;
			}
			_vala_code_node_unref0 (base_class);
		}
	}
	_tmp565_ = context;
	_tmp566_ = vala_code_context_get_analyzer (_tmp565_);
	_tmp567_ = _tmp566_;
	_tmp568_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp567_, _tmp568_);
	_tmp569_ = context;
	_tmp570_ = vala_code_context_get_analyzer (_tmp569_);
	_tmp571_ = _tmp570_;
	_tmp572_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp571_, _tmp572_);
	_tmp573_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp574_ = _tmp573_;
	result = !_tmp574_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaClass* vala_class_get_base_class (ValaClass* self) {
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}


void vala_class_set_base_class (ValaClass* self, ValaClass* value) {
	ValaClass* _tmp0_;
	ValaClass* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp1_;
}


gboolean vala_class_get_is_abstract (ValaClass* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


void vala_class_set_is_abstract (ValaClass* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_abstract = _tmp0_;
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


gboolean vala_class_get_is_compact (ValaClass* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp10_;
	gboolean* _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_compact (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp5_;
		} else {
			ValaAttribute* _tmp6_ = NULL;
			ValaAttribute* _tmp7_;
			gboolean _tmp8_;
			gboolean* _tmp9_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_ != NULL;
			_tmp9_ = __bool_dup0 (&_tmp8_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp9_;
			_vala_code_node_unref0 (_tmp7_);
		}
	}
	_tmp10_ = self->priv->_is_compact;
	if (_tmp10_ == NULL) {
		ValaAttribute* _tmp11_ = NULL;
		ValaAttribute* _tmp12_;
		gboolean _tmp13_;
		gboolean* _tmp14_;
		_tmp11_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_ != NULL;
		_tmp14_ = __bool_dup0 (&_tmp13_);
		_g_free0 (self->priv->_is_compact);
		self->priv->_is_compact = _tmp14_;
		_vala_code_node_unref0 (_tmp12_);
	}
	_tmp15_ = self->priv->_is_compact;
	result = *_tmp15_;
	return result;
}


void vala_class_set_is_compact (ValaClass* self, gboolean value) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->_is_compact);
	self->priv->_is_compact = _tmp1_;
	_tmp2_ = value;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Compact", _tmp2_, NULL);
}


gboolean vala_class_get_is_immutable (ValaClass* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp10_;
	gboolean* _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_immutable (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp5_;
		} else {
			ValaAttribute* _tmp6_ = NULL;
			ValaAttribute* _tmp7_;
			gboolean _tmp8_;
			gboolean* _tmp9_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_ != NULL;
			_tmp9_ = __bool_dup0 (&_tmp8_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp9_;
			_vala_code_node_unref0 (_tmp7_);
		}
	}
	_tmp10_ = self->priv->_is_immutable;
	if (_tmp10_ == NULL) {
		ValaAttribute* _tmp11_ = NULL;
		ValaAttribute* _tmp12_;
		gboolean _tmp13_;
		gboolean* _tmp14_;
		_tmp11_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_ != NULL;
		_tmp14_ = __bool_dup0 (&_tmp13_);
		_g_free0 (self->priv->_is_immutable);
		self->priv->_is_immutable = _tmp14_;
		_vala_code_node_unref0 (_tmp12_);
	}
	_tmp15_ = self->priv->_is_immutable;
	result = *_tmp15_;
	return result;
}


void vala_class_set_is_immutable (ValaClass* self, gboolean value) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp1_;
	_tmp2_ = value;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", _tmp2_, NULL);
}


gboolean vala_class_get_has_private_fields (ValaClass* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_private_fields;
	result = _tmp0_;
	return result;
}


void vala_class_set_has_private_fields (ValaClass* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_has_private_fields = _tmp0_;
}


gboolean vala_class_get_has_class_private_fields (ValaClass* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_class_private_fields;
	result = _tmp0_;
	return result;
}


static void vala_class_set_has_class_private_fields (ValaClass* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_has_class_private_fields = _tmp0_;
}


ValaMethod* vala_class_get_default_construction_method (ValaClass* self) {
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}


void vala_class_set_default_construction_method (ValaClass* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp1_;
}


ValaConstructor* vala_class_get_constructor (ValaClass* self) {
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}


void vala_class_set_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp1_;
}


ValaConstructor* vala_class_get_class_constructor (ValaClass* self) {
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}


void vala_class_set_class_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp1_;
}


ValaConstructor* vala_class_get_static_constructor (ValaClass* self) {
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}


void vala_class_set_static_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp1_;
}


ValaDestructor* vala_class_get_destructor (ValaClass* self) {
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}


void vala_class_set_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	ValaDestructor* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp1_;
	_tmp2_ = self->priv->_destructor;
	if (_tmp2_ != NULL) {
		ValaDestructor* _tmp3_;
		ValaParameter* _tmp4_;
		ValaParameter* _tmp5_;
		ValaDestructor* _tmp14_;
		ValaObjectType* _tmp15_ = NULL;
		ValaObjectType* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		ValaDestructor* _tmp19_;
		ValaScope* _tmp20_;
		ValaScope* _tmp21_;
		ValaDestructor* _tmp22_;
		ValaParameter* _tmp23_;
		ValaParameter* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		ValaDestructor* _tmp27_;
		ValaParameter* _tmp28_;
		ValaParameter* _tmp29_;
		_tmp3_ = self->priv->_destructor;
		_tmp4_ = vala_destructor_get_this_parameter (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			ValaDestructor* _tmp6_;
			ValaScope* _tmp7_;
			ValaScope* _tmp8_;
			ValaDestructor* _tmp9_;
			ValaParameter* _tmp10_;
			ValaParameter* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp6_ = self->priv->_destructor;
			_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->priv->_destructor;
			_tmp10_ = vala_destructor_get_this_parameter (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			vala_scope_remove (_tmp8_, _tmp13_);
		}
		_tmp14_ = self->priv->_destructor;
		_tmp15_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_parameter_new ("this", (ValaDataType*) _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		vala_destructor_set_this_parameter (_tmp14_, _tmp18_);
		_vala_code_node_unref0 (_tmp18_);
		_vala_code_node_unref0 (_tmp16_);
		_tmp19_ = self->priv->_destructor;
		_tmp20_ = vala_symbol_get_scope ((ValaSymbol*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_destructor;
		_tmp23_ = vala_destructor_get_this_parameter (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_symbol_get_name ((ValaSymbol*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->_destructor;
		_tmp28_ = vala_destructor_get_this_parameter (_tmp27_);
		_tmp29_ = _tmp28_;
		vala_scope_add (_tmp21_, _tmp26_, (ValaSymbol*) _tmp29_);
	}
}


ValaDestructor* vala_class_get_static_destructor (ValaClass* self) {
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}


void vala_class_set_static_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp1_;
}


ValaDestructor* vala_class_get_class_destructor (ValaClass* self) {
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}


void vala_class_set_class_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp1_;
}


gboolean vala_class_get_is_error_base (ValaClass* self) {
	gboolean result;
	ValaAttribute* _tmp0_ = NULL;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


static void vala_class_class_init (ValaClassClass * klass) {
	vala_class_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_class_finalize;
	g_type_class_add_private (klass, sizeof (ValaClassPrivate));
	VALA_SYMBOL_CLASS (klass)->add_constant = vala_class_real_add_constant;
	VALA_SYMBOL_CLASS (klass)->add_field = vala_class_real_add_field;
	VALA_SYMBOL_CLASS (klass)->add_method = vala_class_real_add_method;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_methods = vala_class_real_get_methods;
	VALA_SYMBOL_CLASS (klass)->add_property = vala_class_real_add_property;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_properties = vala_class_real_get_properties;
	VALA_SYMBOL_CLASS (klass)->add_signal = vala_class_real_add_signal;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_signals = vala_class_real_get_signals;
	VALA_SYMBOL_CLASS (klass)->add_class = vala_class_real_add_class;
	VALA_SYMBOL_CLASS (klass)->add_struct = vala_class_real_add_struct;
	VALA_SYMBOL_CLASS (klass)->add_enum = vala_class_real_add_enum;
	VALA_SYMBOL_CLASS (klass)->add_delegate = vala_class_real_add_delegate;
	VALA_SYMBOL_CLASS (klass)->add_constructor = vala_class_real_add_constructor;
	VALA_SYMBOL_CLASS (klass)->add_destructor = vala_class_real_add_destructor;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_class_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_class_real_accept_children;
	VALA_TYPESYMBOL_CLASS (klass)->is_reference_type = vala_class_real_is_reference_type;
	VALA_TYPESYMBOL_CLASS (klass)->is_subtype_of = vala_class_real_is_subtype_of;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_class_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_class_real_check;
}


static void vala_class_instance_init (ValaClass * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	GEqualFunc _tmp10_;
	ValaArrayList* _tmp11_;
	GEqualFunc _tmp12_;
	ValaArrayList* _tmp13_;
	GEqualFunc _tmp14_;
	ValaArrayList* _tmp15_;
	GEqualFunc _tmp16_;
	ValaArrayList* _tmp17_;
	GEqualFunc _tmp18_;
	ValaArrayList* _tmp19_;
	self->priv = VALA_CLASS_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp2_);
	self->priv->constants = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp4_);
	self->priv->fields = (ValaList*) _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp6_);
	self->priv->methods = (ValaList*) _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp8_);
	self->priv->properties = (ValaList*) _tmp9_;
	_tmp10_ = g_direct_equal;
	_tmp11_ = vala_array_list_new (VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp10_);
	self->priv->signals = (ValaList*) _tmp11_;
	_tmp12_ = g_direct_equal;
	_tmp13_ = vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp12_);
	self->priv->classes = (ValaList*) _tmp13_;
	_tmp14_ = g_direct_equal;
	_tmp15_ = vala_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp14_);
	self->priv->structs = (ValaList*) _tmp15_;
	_tmp16_ = g_direct_equal;
	_tmp17_ = vala_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp16_);
	self->priv->enums = (ValaList*) _tmp17_;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp18_);
	self->priv->delegates = (ValaList*) _tmp19_;
}


static void vala_class_finalize (ValaCodeNode* obj) {
	ValaClass * self;
	self = VALA_CLASS (obj);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_immutable);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->properties);
	_vala_iterable_unref0 (self->priv->signals);
	_vala_iterable_unref0 (self->priv->classes);
	_vala_iterable_unref0 (self->priv->structs);
	_vala_iterable_unref0 (self->priv->enums);
	_vala_iterable_unref0 (self->priv->delegates);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType vala_class_get_type (void) {
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
		GType vala_class_type_id;
		vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}



