/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.InStream;
import rdr.OutStream;

public class PixelFormat {
    public int bpp;
    public int depth;
    public boolean bigEndian;
    public boolean trueColour;
    public int redMax;
    public int greenMax;
    public int blueMax;
    public int redShift;
    public int greenShift;
    public int blueShift;

    public PixelFormat(int b, int d, boolean e, boolean t) {
        this.bpp = b;
        this.depth = d;
        this.bigEndian = e;
        this.trueColour = t;
    }

    public PixelFormat(int b, int d, boolean e, boolean t, int rm, int gm, int bm, int rs, int gs, int bs) {
        this(b, d, e, t);
        this.redMax = rm;
        this.greenMax = gm;
        this.blueMax = bm;
        this.redShift = rs;
        this.greenShift = gs;
        this.blueShift = bs;
    }

    public PixelFormat() {
        this(8, 8, false, true, 7, 7, 3, 0, 3, 6);
    }

    public boolean equal(PixelFormat x) {
        return this.bpp == x.bpp && this.depth == x.depth && (this.bigEndian == x.bigEndian || this.bpp == 8) && this.trueColour == x.trueColour && (!this.trueColour || this.redMax == x.redMax && this.greenMax == x.greenMax && this.blueMax == x.blueMax && this.redShift == x.redShift && this.greenShift == x.greenShift && this.blueShift == x.blueShift);
    }

    public void read(InStream is) {
        this.bpp = is.readU8();
        this.depth = is.readU8();
        this.bigEndian = is.readU8() != 0;
        this.trueColour = is.readU8() != 0;
        this.redMax = is.readU16();
        this.greenMax = is.readU16();
        this.blueMax = is.readU16();
        this.redShift = is.readU8();
        this.greenShift = is.readU8();
        this.blueShift = is.readU8();
        is.skip(3);
    }

    public void write(OutStream os) {
        os.writeU8(this.bpp);
        os.writeU8(this.depth);
        os.writeU8(this.bigEndian ? 1 : 0);
        os.writeU8(this.trueColour ? 1 : 0);
        os.writeU16(this.redMax);
        os.writeU16(this.greenMax);
        os.writeU16(this.blueMax);
        os.writeU8(this.redShift);
        os.writeU8(this.greenShift);
        os.writeU8(this.blueShift);
        os.pad(3);
    }

    public String print() {
        StringBuffer s = new StringBuffer();
        s.append("depth " + this.depth + " (" + this.bpp + "bpp)");
        if (this.bpp != 8) {
            if (this.bigEndian) {
                s.append(" big-endian");
            } else {
                s.append(" little-endian");
            }
        }
        if (!this.trueColour) {
            s.append(" colour-map");
            return s.toString();
        }
        if (this.blueShift == 0 && this.greenShift > this.blueShift && this.redShift > this.greenShift && this.blueMax == (1 << this.greenShift) - 1 && this.greenMax == (1 << this.redShift - this.greenShift) - 1 && this.redMax == (1 << this.depth - this.redShift) - 1) {
            s.append(" rgb" + (this.depth - this.redShift) + (this.redShift - this.greenShift) + this.greenShift);
            return s.toString();
        }
        if (this.redShift == 0 && this.greenShift > this.redShift && this.blueShift > this.greenShift && this.redMax == (1 << this.greenShift) - 1 && this.greenMax == (1 << this.blueShift - this.greenShift) - 1 && this.blueMax == (1 << this.depth - this.blueShift) - 1) {
            s.append(" bgr" + (this.depth - this.blueShift) + (this.blueShift - this.greenShift) + this.greenShift);
            return s.toString();
        }
        s.append(" rgb max " + this.redMax + "," + this.greenMax + "," + this.blueMax + " shift " + this.redShift + "," + this.greenShift + "," + this.blueShift);
        return s.toString();
    }
}

