
std::map<uint64_t, uint32_t> GetOpcodeAndNumOperandsHist() {
  return std::map<uint64_t, uint32_t>({
    { CombineOpcodeAndNumOperands(SpvOpExtInst, 7), 158282 },
    { CombineOpcodeAndNumOperands(SpvOpDot, 4), 151035 },
    { CombineOpcodeAndNumOperands(SpvOpVectorShuffle, 6), 183292 },
    { CombineOpcodeAndNumOperands(SpvOpImageSampleImplicitLod, 4), 126492 },
    { CombineOpcodeAndNumOperands(SpvOpExecutionMode, 2), 13311 },
    { CombineOpcodeAndNumOperands(SpvOpFNegate, 3), 29952 },
    { CombineOpcodeAndNumOperands(SpvOpExtInst, 5), 106847 },
    { CombineOpcodeAndNumOperands(SpvOpImageSampleExplicitLod, 7), 26350 },
    { CombineOpcodeAndNumOperands(SpvOpImageSampleExplicitLod, 6), 28186 },
    { CombineOpcodeAndNumOperands(SpvOpFDiv, 4), 41635 },
    { CombineOpcodeAndNumOperands(SpvOpFMul, 4), 412786 },
    { CombineOpcodeAndNumOperands(SpvOpFunction, 4), 62905 },
    { CombineOpcodeAndNumOperands(SpvOpVectorShuffle, 8), 118614 },
    { CombineOpcodeAndNumOperands(SpvOpDecorate, 2), 100735 },
    { CombineOpcodeAndNumOperands(SpvOpReturnValue, 1), 40852 },
    { CombineOpcodeAndNumOperands(SpvOpVectorTimesScalar, 4), 157091 },
    { CombineOpcodeAndNumOperands(SpvOpExtInst, 6), 122100 },
    { CombineOpcodeAndNumOperands(SpvOpAccessChain, 5), 82930 },
    { CombineOpcodeAndNumOperands(SpvOpFSub, 4), 161019 },
    { CombineOpcodeAndNumOperands(SpvOpConstant, 3), 466014 },
    { CombineOpcodeAndNumOperands(SpvOpCompositeExtract, 5), 107126 },
    { CombineOpcodeAndNumOperands(SpvOpTypeImage, 8), 34775 },
    { CombineOpcodeAndNumOperands(SpvOpImageSampleDrefExplicitLod, 7), 26146 },
    { CombineOpcodeAndNumOperands(SpvOpMemoryModel, 2), 18879 },
    { CombineOpcodeAndNumOperands(SpvOpDecorate, 3), 485251 },
    { CombineOpcodeAndNumOperands(SpvOpCompositeConstruct, 4), 78011 },
    { CombineOpcodeAndNumOperands(SpvOpTypeFloat, 2), 18879 },
    { CombineOpcodeAndNumOperands(SpvOpVectorTimesMatrix, 4), 15848 },
    { CombineOpcodeAndNumOperands(SpvOpTypeVector, 3), 69404 },
    { CombineOpcodeAndNumOperands(SpvOpTypeFunction, 3), 19998 },
    { CombineOpcodeAndNumOperands(SpvOpConstantComposite, 6), 40228 },
    { CombineOpcodeAndNumOperands(SpvOpCapability, 1), 22510 },
    { CombineOpcodeAndNumOperands(SpvOpTypeArray, 3), 37585 },
    { CombineOpcodeAndNumOperands(SpvOpTypeInt, 3), 30454 },
    { CombineOpcodeAndNumOperands(SpvOpFunctionCall, 4), 29021 },
    { CombineOpcodeAndNumOperands(SpvOpFAdd, 4), 342237 },
    { CombineOpcodeAndNumOperands(SpvOpTypeMatrix, 3), 24449 },
    { CombineOpcodeAndNumOperands(SpvOpLabel, 1), 129408 },
    { CombineOpcodeAndNumOperands(SpvOpTypePointer, 3), 246535 },
    { CombineOpcodeAndNumOperands(SpvOpAccessChain, 4), 503456 },
    { CombineOpcodeAndNumOperands(SpvOpTypeFunction, 2), 19779 },
    { CombineOpcodeAndNumOperands(SpvOpBranchConditional, 3), 24139 },
    { CombineOpcodeAndNumOperands(SpvOpVariable, 3), 697946 },
    { CombineOpcodeAndNumOperands(SpvOpConstantComposite, 5), 55769 },
    { CombineOpcodeAndNumOperands(SpvOpTypeVoid, 1), 18879 },
    { CombineOpcodeAndNumOperands(SpvOpCompositeConstruct, 6), 145508 },
    { CombineOpcodeAndNumOperands(SpvOpFunctionParameter, 2), 85583 },
    { CombineOpcodeAndNumOperands(SpvOpTypeSampledImage, 2), 34775 },
    { CombineOpcodeAndNumOperands(SpvOpConstantComposite, 4), 66362 },
    { CombineOpcodeAndNumOperands(SpvOpLoad, 3), 1272902 },
    { CombineOpcodeAndNumOperands(SpvOpReturn, 0), 22122 },
    { CombineOpcodeAndNumOperands(SpvOpCompositeExtract, 4), 861008 },
    { CombineOpcodeAndNumOperands(SpvOpFunctionEnd, 0), 62905 },
    { CombineOpcodeAndNumOperands(SpvOpExtInstImport, 2), 18879 },
    { CombineOpcodeAndNumOperands(SpvOpSelectionMerge, 2), 22009 },
    { CombineOpcodeAndNumOperands(SpvOpBranch, 1), 38275 },
    { CombineOpcodeAndNumOperands(SpvOpTypeBool, 1), 12208 },
    { CombineOpcodeAndNumOperands(SpvOpSampledImage, 4), 95518 },
    { CombineOpcodeAndNumOperands(SpvOpMemberDecorate, 3), 94887 },
    { CombineOpcodeAndNumOperands(SpvOpMemberDecorate, 4), 1942215 },
    { CombineOpcodeAndNumOperands(SpvOpCompositeConstruct, 5), 205266 },
    { CombineOpcodeAndNumOperands(SpvOpUndef, 2), 22157 },
    { CombineOpcodeAndNumOperands(SpvOpCompositeInsert, 5), 142749 },
    { CombineOpcodeAndNumOperands(SpvOpCompositeInsert, 6), 24420 },
    { CombineOpcodeAndNumOperands(SpvOpCompositeExtract, 6), 16896 },
    { CombineOpcodeAndNumOperands(SpvOpStore, 2), 604982 },
    { CombineOpcodeAndNumOperands(SpvOpIAdd, 4), 14471 },
    { CombineOpcodeAndNumOperands(SpvOpVectorShuffle, 7), 269658 },
    { kMarkvNoneOfTheAbove, 399895 },
  });
}

std::map<uint32_t, std::unique_ptr<HuffmanCodec<uint64_t>>>
GetOpcodeAndNumOperandsMarkovHuffmanCodecs() {
  std::map<uint32_t, std::unique_ptr<HuffmanCodec<uint64_t>>> codecs;
  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(35, {
      {0, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {196669, 0, 0},
      {262209, 0, 0},
      {262221, 0, 0},
      {262225, 0, 0},
      {262230, 0, 0},
      {262273, 0, 0},
      {262277, 0, 0},
      {262286, 0, 0},
      {327745, 0, 0},
      {327761, 0, 0},
      {327762, 0, 0},
      {393295, 0, 0},
      {393304, 0, 0},
      {458831, 0, 0},
      {458840, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 11, 8},
      {0, 12, 19},
      {0, 18, 20},
      {0, 5, 21},
      {0, 15, 7},
      {0, 10, 1},
      {0, 23, 22},
      {0, 14, 24},
      {0, 6, 4},
      {0, 2, 17},
      {0, 13, 25},
      {0, 9, 26},
      {0, 28, 27},
      {0, 3, 29},
      {0, 30, 16},
      {0, 32, 31},
      {0, 34, 33},
    }));

    codecs.emplace(SpvOpImageSampleExplicitLod, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(55, {
      {0, 0, 0},
      {65785, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {196669, 0, 0},
      {196735, 0, 0},
      {262201, 0, 0},
      {262209, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262231, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262277, 0, 0},
      {262280, 0, 0},
      {262286, 0, 0},
      {327692, 0, 0},
      {327745, 0, 0},
      {327760, 0, 0},
      {327762, 0, 0},
      {393228, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {393303, 0, 0},
      {393304, 0, 0},
      {458764, 0, 0},
      {458831, 0, 0},
      {524367, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 14, 5},
      {0, 29, 17},
      {0, 1, 30},
      {0, 10, 20},
      {0, 32, 31},
      {0, 33, 2},
      {0, 34, 23},
      {0, 8, 35},
      {0, 6, 36},
      {0, 19, 22},
      {0, 28, 25},
      {0, 38, 37},
      {0, 13, 39},
      {0, 40, 24},
      {0, 27, 21},
      {0, 26, 41},
      {0, 42, 12},
      {0, 15, 43},
      {0, 44, 18},
      {0, 45, 3},
      {0, 11, 7},
      {0, 16, 46},
      {0, 47, 9},
      {0, 4, 48},
      {0, 50, 49},
      {0, 52, 51},
      {0, 54, 53},
    }));

    codecs.emplace(SpvOpFDiv, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(19, {
      {0, 0, 0},
      {196669, 0, 0},
      {262209, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262231, 0, 0},
      {262286, 0, 0},
      {393295, 0, 0},
      {393304, 0, 0},
      {458840, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 8, 10},
      {0, 11, 3},
      {0, 2, 9},
      {0, 4, 1},
      {0, 5, 6},
      {0, 13, 12},
      {0, 15, 14},
      {0, 16, 7},
      {0, 18, 17},
    }));

    codecs.emplace(SpvOpSampledImage, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(67, {
      {0, 0, 0},
      {65785, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {131319, 0, 0},
      {196669, 0, 0},
      {196735, 0, 0},
      {262209, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262231, 0, 0},
      {262272, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262277, 0, 0},
      {262280, 0, 0},
      {262285, 0, 0},
      {262286, 0, 0},
      {262292, 0, 0},
      {327692, 0, 0},
      {327745, 0, 0},
      {327760, 0, 0},
      {327761, 0, 0},
      {327762, 0, 0},
      {393228, 0, 0},
      {393281, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {393297, 0, 0},
      {393298, 0, 0},
      {393304, 0, 0},
      {458764, 0, 0},
      {458831, 0, 0},
      {524367, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 10},
      {0, 30, 35},
      {0, 1, 36},
      {0, 11, 37},
      {0, 38, 6},
      {0, 16, 39},
      {0, 15, 40},
      {0, 25, 2},
      {0, 41, 20},
      {0, 26, 19},
      {0, 42, 29},
      {0, 28, 22},
      {0, 23, 34},
      {0, 44, 43},
      {0, 17, 45},
      {0, 24, 27},
      {0, 18, 33},
      {0, 47, 46},
      {0, 8, 48},
      {0, 50, 49},
      {0, 32, 51},
      {0, 31, 52},
      {0, 53, 21},
      {0, 54, 13},
      {0, 3, 55},
      {0, 7, 14},
      {0, 57, 56},
      {0, 58, 5},
      {0, 59, 9},
      {0, 61, 60},
      {0, 63, 62},
      {0, 64, 12},
      {0, 66, 65},
    }));

    codecs.emplace(SpvOpFMul, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(79, {
      {0, 0, 0},
      {65785, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {196669, 0, 0},
      {196735, 0, 0},
      {262201, 0, 0},
      {262209, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262230, 0, 0},
      {262231, 0, 0},
      {262272, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262277, 0, 0},
      {262280, 0, 0},
      {262286, 0, 0},
      {262288, 0, 0},
      {262292, 0, 0},
      {262328, 0, 0},
      {262334, 0, 0},
      {327692, 0, 0},
      {327737, 0, 0},
      {327745, 0, 0},
      {327760, 0, 0},
      {327761, 0, 0},
      {327762, 0, 0},
      {393228, 0, 0},
      {393281, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {393297, 0, 0},
      {393303, 0, 0},
      {393304, 0, 0},
      {458764, 0, 0},
      {458831, 0, 0},
      {458840, 0, 0},
      {524345, 0, 0},
      {524367, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 38, 33},
      {0, 18, 41},
      {0, 42, 23},
      {0, 43, 6},
      {0, 34, 44},
      {0, 1, 45},
      {0, 31, 14},
      {0, 47, 46},
      {0, 48, 2},
      {0, 12, 21},
      {0, 49, 30},
      {0, 37, 50},
      {0, 51, 20},
      {0, 5, 24},
      {0, 40, 16},
      {0, 29, 13},
      {0, 26, 52},
      {0, 53, 17},
      {0, 36, 54},
      {0, 55, 28},
      {0, 57, 56},
      {0, 19, 25},
      {0, 39, 8},
      {0, 32, 58},
      {0, 59, 27},
      {0, 22, 10},
      {0, 35, 60},
      {0, 62, 61},
      {0, 63, 7},
      {0, 65, 64},
      {0, 4, 66},
      {0, 68, 67},
      {0, 11, 3},
      {0, 15, 69},
      {0, 9, 70},
      {0, 72, 71},
      {0, 74, 73},
      {0, 76, 75},
      {0, 78, 77},
    }));

    codecs.emplace(SpvOpFAdd, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(55, {
      {0, 0, 0},
      {65556, 0, 0},
      {65562, 0, 0},
      {131073, 0, 0},
      {131094, 0, 0},
      {131105, 0, 0},
      {196629, 0, 0},
      {196631, 0, 0},
      {196632, 0, 0},
      {196636, 0, 0},
      {196640, 0, 0},
      {196641, 0, 0},
      {196651, 0, 0},
      {196667, 0, 0},
      {262177, 0, 0},
      {262188, 0, 0},
      {262198, 0, 0},
      {327713, 0, 0},
      {327724, 0, 0},
      {393249, 0, 0},
      {393260, 0, 0},
      {458785, 0, 0},
      {524313, 0, 0},
      {524321, 0, 0},
      {589857, 0, 0},
      {655393, 0, 0},
      {720929, 0, 0},
      {852001, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 26, 24},
      {0, 29, 27},
      {0, 4, 30},
      {0, 21, 9},
      {0, 31, 20},
      {0, 33, 32},
      {0, 34, 3},
      {0, 8, 35},
      {0, 36, 5},
      {0, 23, 16},
      {0, 38, 37},
      {0, 25, 2},
      {0, 39, 1},
      {0, 17, 40},
      {0, 41, 15},
      {0, 18, 42},
      {0, 43, 6},
      {0, 44, 14},
      {0, 28, 19},
      {0, 7, 45},
      {0, 46, 22},
      {0, 48, 47},
      {0, 49, 11},
      {0, 51, 50},
      {0, 12, 10},
      {0, 53, 52},
      {0, 13, 54},
    }));

    codecs.emplace(SpvOpTypePointer, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(57, {
      {0, 0, 0},
      {65785, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {196669, 0, 0},
      {196735, 0, 0},
      {262209, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262272, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262277, 0, 0},
      {262280, 0, 0},
      {262286, 0, 0},
      {262292, 0, 0},
      {262328, 0, 0},
      {327692, 0, 0},
      {327745, 0, 0},
      {327760, 0, 0},
      {327761, 0, 0},
      {327762, 0, 0},
      {393228, 0, 0},
      {393273, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {458764, 0, 0},
      {458831, 0, 0},
      {524367, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 9, 23},
      {0, 1, 30},
      {0, 5, 31},
      {0, 32, 28},
      {0, 33, 25},
      {0, 34, 29},
      {0, 18, 24},
      {0, 27, 16},
      {0, 7, 13},
      {0, 14, 35},
      {0, 20, 10},
      {0, 36, 21},
      {0, 2, 37},
      {0, 38, 3},
      {0, 39, 22},
      {0, 40, 19},
      {0, 41, 11},
      {0, 6, 4},
      {0, 12, 42},
      {0, 43, 8},
      {0, 15, 26},
      {0, 45, 44},
      {0, 47, 46},
      {0, 48, 17},
      {0, 50, 49},
      {0, 52, 51},
      {0, 54, 53},
      {0, 56, 55},
    }));

    codecs.emplace(SpvOpFSub, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(13, {
      {0, 0, 0},
      {65785, 0, 0},
      {131134, 0, 0},
      {196719, 0, 0},
      {262209, 0, 0},
      {262276, 0, 0},
      {327745, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 7, 4},
      {0, 2, 8},
      {0, 1, 9},
      {0, 5, 10},
      {0, 3, 6},
      {0, 12, 11},
    }));

    codecs.emplace(SpvOpIAdd, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(83, {
      {0, 0, 0},
      {65785, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {131319, 0, 0},
      {196669, 0, 0},
      {196732, 0, 0},
      {196735, 0, 0},
      {262209, 0, 0},
      {262221, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262230, 0, 0},
      {262231, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262277, 0, 0},
      {262280, 0, 0},
      {262286, 0, 0},
      {262288, 0, 0},
      {262292, 0, 0},
      {262328, 0, 0},
      {262334, 0, 0},
      {262340, 0, 0},
      {327692, 0, 0},
      {327737, 0, 0},
      {327745, 0, 0},
      {327760, 0, 0},
      {327761, 0, 0},
      {327762, 0, 0},
      {393228, 0, 0},
      {393273, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {393297, 0, 0},
      {393298, 0, 0},
      {393304, 0, 0},
      {458764, 0, 0},
      {458831, 0, 0},
      {458840, 0, 0},
      {458842, 0, 0},
      {524367, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 25, 2},
      {0, 31, 43},
      {0, 4, 44},
      {0, 26, 45},
      {0, 39, 46},
      {0, 34, 36},
      {0, 19, 47},
      {0, 6, 48},
      {0, 35, 9},
      {0, 12, 29},
      {0, 21, 49},
      {0, 22, 13},
      {0, 17, 50},
      {0, 23, 51},
      {0, 52, 7},
      {0, 37, 1},
      {0, 53, 3},
      {0, 54, 24},
      {0, 56, 55},
      {0, 32, 57},
      {0, 59, 58},
      {0, 42, 10},
      {0, 60, 8},
      {0, 5, 41},
      {0, 61, 20},
      {0, 62, 38},
      {0, 64, 63},
      {0, 40, 65},
      {0, 66, 18},
      {0, 15, 28},
      {0, 14, 67},
      {0, 68, 30},
      {0, 70, 69},
      {0, 72, 71},
      {0, 73, 27},
      {0, 16, 74},
      {0, 75, 33},
      {0, 77, 76},
      {0, 79, 78},
      {0, 81, 80},
      {0, 82, 11},
    }));

    codecs.emplace(SpvOpCompositeExtract, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(29, {
      {0, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {196669, 0, 0},
      {262209, 0, 0},
      {262225, 0, 0},
      {262273, 0, 0},
      {262288, 0, 0},
      {262292, 0, 0},
      {327692, 0, 0},
      {327761, 0, 0},
      {327762, 0, 0},
      {393295, 0, 0},
      {458831, 0, 0},
      {524367, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 10, 6},
      {0, 16, 13},
      {0, 7, 17},
      {0, 15, 18},
      {0, 19, 12},
      {0, 20, 14},
      {0, 1, 4},
      {0, 22, 21},
      {0, 11, 8},
      {0, 2, 5},
      {0, 9, 23},
      {0, 3, 24},
      {0, 26, 25},
      {0, 28, 27},
    }));

    codecs.emplace(SpvOpVectorTimesMatrix, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {65784, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(SpvOpBranch, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {262198, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(SpvOpFunctionEnd, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {65784, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(SpvOpBranchConditional, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(53, {
      {0, 0, 0},
      {65785, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {131319, 0, 0},
      {196665, 0, 0},
      {196669, 0, 0},
      {196735, 0, 0},
      {262201, 0, 0},
      {262209, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262231, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262277, 0, 0},
      {262280, 0, 0},
      {262286, 0, 0},
      {262288, 0, 0},
      {262292, 0, 0},
      {327692, 0, 0},
      {327745, 0, 0},
      {327760, 0, 0},
      {393228, 0, 0},
      {393295, 0, 0},
      {458764, 0, 0},
      {458831, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 25, 16},
      {0, 21, 28},
      {0, 18, 23},
      {0, 4, 29},
      {0, 10, 5},
      {0, 1, 30},
      {0, 32, 31},
      {0, 22, 33},
      {0, 34, 8},
      {0, 35, 15},
      {0, 13, 36},
      {0, 26, 17},
      {0, 38, 37},
      {0, 39, 11},
      {0, 40, 14},
      {0, 12, 27},
      {0, 19, 41},
      {0, 24, 42},
      {0, 44, 43},
      {0, 45, 7},
      {0, 20, 46},
      {0, 9, 47},
      {0, 48, 2},
      {0, 50, 49},
      {0, 6, 3},
      {0, 52, 51},
    }));

    codecs.emplace(SpvOpFunctionCall, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(71, {
      {0, 0, 0},
      {65556, 0, 0},
      {65562, 0, 0},
      {131073, 0, 0},
      {131094, 0, 0},
      {131099, 0, 0},
      {131134, 0, 0},
      {196629, 0, 0},
      {196631, 0, 0},
      {196632, 0, 0},
      {196636, 0, 0},
      {196640, 0, 0},
      {196651, 0, 0},
      {196665, 0, 0},
      {196667, 0, 0},
      {196669, 0, 0},
      {262188, 0, 0},
      {262198, 0, 0},
      {262201, 0, 0},
      {262209, 0, 0},
      {262225, 0, 0},
      {262275, 0, 0},
      {262280, 0, 0},
      {262292, 0, 0},
      {327692, 0, 0},
      {327724, 0, 0},
      {327737, 0, 0},
      {327745, 0, 0},
      {393228, 0, 0},
      {393260, 0, 0},
      {393273, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {458831, 0, 0},
      {524313, 0, 0},
      {524367, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 22, 4},
      {0, 32, 23},
      {0, 37, 30},
      {0, 21, 38},
      {0, 39, 31},
      {0, 41, 40},
      {0, 13, 42},
      {0, 43, 26},
      {0, 10, 44},
      {0, 28, 45},
      {0, 35, 18},
      {0, 20, 46},
      {0, 33, 47},
      {0, 24, 48},
      {0, 6, 49},
      {0, 3, 50},
      {0, 16, 51},
      {0, 27, 52},
      {0, 53, 1},
      {0, 9, 17},
      {0, 29, 54},
      {0, 19, 2},
      {0, 8, 36},
      {0, 55, 34},
      {0, 25, 56},
      {0, 7, 57},
      {0, 5, 58},
      {0, 60, 59},
      {0, 61, 15},
      {0, 63, 62},
      {0, 65, 64},
      {0, 66, 11},
      {0, 12, 67},
      {0, 69, 68},
      {0, 14, 70},
    }));

    codecs.emplace(SpvOpVariable, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {131134, 0, 0},
      {196669, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 3},
      {0, 2, 4},
    }));

    codecs.emplace(SpvOpAccessChain, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(73, {
      {0, 0, 0},
      {252, 0, 0},
      {253, 0, 0},
      {65785, 0, 0},
      {65790, 0, 0},
      {131073, 0, 0},
      {131134, 0, 0},
      {131319, 0, 0},
      {196665, 0, 0},
      {196667, 0, 0},
      {196669, 0, 0},
      {196735, 0, 0},
      {196854, 0, 0},
      {262201, 0, 0},
      {262209, 0, 0},
      {262221, 0, 0},
      {262225, 0, 0},
      {262272, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262276, 0, 0},
      {262277, 0, 0},
      {262280, 0, 0},
      {262286, 0, 0},
      {262292, 0, 0},
      {262321, 0, 0},
      {327692, 0, 0},
      {327745, 0, 0},
      {327761, 0, 0},
      {327762, 0, 0},
      {393228, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {393298, 0, 0},
      {393461, 0, 0},
      {458831, 0, 0},
      {524367, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 28, 5},
      {0, 30, 8},
      {0, 13, 38},
      {0, 40, 39},
      {0, 41, 26},
      {0, 42, 19},
      {0, 43, 29},
      {0, 23, 44},
      {0, 36, 32},
      {0, 45, 22},
      {0, 2, 46},
      {0, 21, 20},
      {0, 48, 47},
      {0, 33, 49},
      {0, 4, 50},
      {0, 51, 24},
      {0, 18, 11},
      {0, 52, 12},
      {0, 25, 15},
      {0, 53, 17},
      {0, 37, 54},
      {0, 55, 35},
      {0, 7, 27},
      {0, 57, 56},
      {0, 58, 31},
      {0, 6, 59},
      {0, 1, 60},
      {0, 62, 61},
      {0, 63, 14},
      {0, 3, 16},
      {0, 34, 64},
      {0, 66, 65},
      {0, 68, 67},
      {0, 70, 69},
      {0, 10, 9},
      {0, 72, 71},
    }));

    codecs.emplace(SpvOpLabel, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {56, 0, 0},
      {65784, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 2},
      {0, 1, 4},
    }));

    codecs.emplace(SpvOpReturn, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {65784, 0, 0},
      {131127, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 3},
      {0, 2, 4},
    }));

    codecs.emplace(SpvOpFunction, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(31, {
      {0, 0, 0},
      {65556, 0, 0},
      {196629, 0, 0},
      {196631, 0, 0},
      {196632, 0, 0},
      {196636, 0, 0},
      {196640, 0, 0},
      {196641, 0, 0},
      {196651, 0, 0},
      {196667, 0, 0},
      {262177, 0, 0},
      {262188, 0, 0},
      {262198, 0, 0},
      {327713, 0, 0},
      {393260, 0, 0},
      {524313, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 12, 1},
      {0, 13, 5},
      {0, 18, 17},
      {0, 7, 19},
      {0, 9, 20},
      {0, 16, 21},
      {0, 15, 10},
      {0, 22, 4},
      {0, 24, 23},
      {0, 25, 14},
      {0, 8, 11},
      {0, 2, 26},
      {0, 28, 27},
      {0, 3, 6},
      {0, 30, 29},
    }));

    codecs.emplace(SpvOpTypeVector, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {65784, 0, 0},
      {131127, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 3},
      {0, 4, 1},
    }));

    codecs.emplace(SpvOpFunctionParameter, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {56, 0, 0},
      {65784, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 2},
      {0, 1, 4},
    }));

    codecs.emplace(SpvOpReturnValue, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {131105, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(SpvOpTypeVoid, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(89, {
      {0, 0, 0},
      {253, 0, 0},
      {65785, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {131319, 0, 0},
      {196665, 0, 0},
      {196669, 0, 0},
      {196735, 0, 0},
      {262201, 0, 0},
      {262209, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262272, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262277, 0, 0},
      {262280, 0, 0},
      {262286, 0, 0},
      {262288, 0, 0},
      {262292, 0, 0},
      {327692, 0, 0},
      {327737, 0, 0},
      {327745, 0, 0},
      {327760, 0, 0},
      {327761, 0, 0},
      {327762, 0, 0},
      {393228, 0, 0},
      {393273, 0, 0},
      {393281, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {458764, 0, 0},
      {458809, 0, 0},
      {458831, 0, 0},
      {524345, 0, 0},
      {524367, 0, 0},
      {589881, 0, 0},
      {655417, 0, 0},
      {720953, 0, 0},
      {786489, 0, 0},
      {852025, 0, 0},
      {917561, 0, 0},
      {983097, 0, 0},
      {1114169, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 40, 32},
      {0, 46, 29},
      {0, 38, 27},
      {0, 20, 47},
      {0, 49, 48},
      {0, 50, 44},
      {0, 51, 43},
      {0, 14, 5},
      {0, 42, 52},
      {0, 13, 19},
      {0, 3, 26},
      {0, 54, 53},
      {0, 56, 55},
      {0, 57, 6},
      {0, 39, 37},
      {0, 15, 58},
      {0, 18, 31},
      {0, 59, 21},
      {0, 60, 17},
      {0, 61, 41},
      {0, 62, 24},
      {0, 34, 63},
      {0, 35, 64},
      {0, 65, 8},
      {0, 66, 36},
      {0, 67, 30},
      {0, 16, 11},
      {0, 69, 68},
      {0, 70, 28},
      {0, 22, 71},
      {0, 33, 72},
      {0, 45, 73},
      {0, 75, 74},
      {0, 77, 76},
      {0, 78, 12},
      {0, 1, 2},
      {0, 9, 79},
      {0, 25, 80},
      {0, 23, 81},
      {0, 4, 82},
      {0, 84, 83},
      {0, 86, 85},
      {0, 7, 10},
      {0, 88, 87},
    }));

    codecs.emplace(SpvOpStore, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(13, {
      {0, 0, 0},
      {131075, 0, 0},
      {131088, 0, 0},
      {131143, 0, 0},
      {196624, 0, 0},
      {196679, 0, 0},
      {262216, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 4},
      {0, 1, 8},
      {0, 7, 9},
      {0, 6, 10},
      {0, 5, 11},
      {0, 2, 12},
    }));

    codecs.emplace(SpvOpEntryPoint, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(97, {
      {0, 0, 0},
      {65785, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {131319, 0, 0},
      {196665, 0, 0},
      {196669, 0, 0},
      {196732, 0, 0},
      {196735, 0, 0},
      {262201, 0, 0},
      {262209, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262230, 0, 0},
      {262231, 0, 0},
      {262272, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262276, 0, 0},
      {262277, 0, 0},
      {262280, 0, 0},
      {262286, 0, 0},
      {262288, 0, 0},
      {262292, 0, 0},
      {262326, 0, 0},
      {262328, 0, 0},
      {262330, 0, 0},
      {327692, 0, 0},
      {327737, 0, 0},
      {327745, 0, 0},
      {327760, 0, 0},
      {327761, 0, 0},
      {327762, 0, 0},
      {393228, 0, 0},
      {393273, 0, 0},
      {393281, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {393297, 0, 0},
      {393304, 0, 0},
      {458764, 0, 0},
      {458809, 0, 0},
      {458817, 0, 0},
      {458831, 0, 0},
      {458840, 0, 0},
      {524345, 0, 0},
      {524367, 0, 0},
      {589881, 0, 0},
      {720953, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 42, 47},
      {0, 48, 50},
      {0, 45, 51},
      {0, 34, 52},
      {0, 53, 41},
      {0, 1, 54},
      {0, 55, 5},
      {0, 15, 4},
      {0, 56, 35},
      {0, 26, 24},
      {0, 18, 28},
      {0, 57, 38},
      {0, 59, 58},
      {0, 60, 25},
      {0, 20, 9},
      {0, 7, 61},
      {0, 62, 22},
      {0, 11, 31},
      {0, 63, 8},
      {0, 64, 40},
      {0, 66, 65},
      {0, 27, 44},
      {0, 29, 67},
      {0, 68, 39},
      {0, 69, 2},
      {0, 37, 49},
      {0, 71, 70},
      {0, 30, 72},
      {0, 73, 17},
      {0, 33, 74},
      {0, 23, 14},
      {0, 32, 75},
      {0, 21, 76},
      {0, 77, 16},
      {0, 46, 78},
      {0, 13, 79},
      {0, 80, 12},
      {0, 19, 81},
      {0, 43, 36},
      {0, 83, 82},
      {0, 10, 84},
      {0, 85, 3},
      {0, 6, 86},
      {0, 88, 87},
      {0, 90, 89},
      {0, 92, 91},
      {0, 94, 93},
      {0, 96, 95},
    }));

    codecs.emplace(SpvOpLoad, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(47, {
      {0, 0, 0},
      {262159, 0, 0},
      {327695, 0, 0},
      {393231, 0, 0},
      {458767, 0, 0},
      {524303, 0, 0},
      {589839, 0, 0},
      {655375, 0, 0},
      {720911, 0, 0},
      {786447, 0, 0},
      {851983, 0, 0},
      {917519, 0, 0},
      {983055, 0, 0},
      {1048591, 0, 0},
      {1114127, 0, 0},
      {1179663, 0, 0},
      {1245199, 0, 0},
      {1310735, 0, 0},
      {1376271, 0, 0},
      {1441807, 0, 0},
      {1507343, 0, 0},
      {1572879, 0, 0},
      {1638415, 0, 0},
      {1703951, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 23},
      {0, 22, 25},
      {0, 21, 26},
      {0, 6, 20},
      {0, 19, 27},
      {0, 29, 28},
      {0, 24, 18},
      {0, 30, 13},
      {0, 31, 14},
      {0, 32, 7},
      {0, 17, 15},
      {0, 33, 2},
      {0, 34, 8},
      {0, 16, 12},
      {0, 35, 3},
      {0, 36, 5},
      {0, 9, 37},
      {0, 39, 38},
      {0, 11, 40},
      {0, 4, 10},
      {0, 42, 41},
      {0, 44, 43},
      {0, 46, 45},
    }));

    codecs.emplace(SpvOpMemoryModel, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {196631, 0, 0},
      {196640, 0, 0},
      {196641, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 3},
      {0, 4, 5},
      {0, 1, 6},
    }));

    codecs.emplace(SpvOpTypeFloat, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(69, {
      {0, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {196669, 0, 0},
      {196735, 0, 0},
      {262201, 0, 0},
      {262209, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262231, 0, 0},
      {262272, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262277, 0, 0},
      {262280, 0, 0},
      {262286, 0, 0},
      {262288, 0, 0},
      {262289, 0, 0},
      {262292, 0, 0},
      {327692, 0, 0},
      {327745, 0, 0},
      {327760, 0, 0},
      {327761, 0, 0},
      {327762, 0, 0},
      {327849, 0, 0},
      {393228, 0, 0},
      {393281, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {393304, 0, 0},
      {458764, 0, 0},
      {458809, 0, 0},
      {458831, 0, 0},
      {524345, 0, 0},
      {524367, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 33, 10},
      {0, 31, 36},
      {0, 26, 37},
      {0, 5, 38},
      {0, 20, 39},
      {0, 22, 40},
      {0, 24, 25},
      {0, 15, 41},
      {0, 9, 17},
      {0, 1, 42},
      {0, 4, 43},
      {0, 35, 44},
      {0, 34, 45},
      {0, 19, 46},
      {0, 7, 29},
      {0, 16, 47},
      {0, 48, 32},
      {0, 49, 27},
      {0, 11, 14},
      {0, 18, 28},
      {0, 23, 50},
      {0, 51, 12},
      {0, 52, 21},
      {0, 6, 53},
      {0, 55, 54},
      {0, 57, 56},
      {0, 3, 58},
      {0, 13, 59},
      {0, 60, 8},
      {0, 30, 61},
      {0, 62, 2},
      {0, 64, 63},
      {0, 66, 65},
      {0, 68, 67},
    }));

    codecs.emplace(SpvOpCompositeConstruct, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(39, {
      {0, 0, 0},
      {65556, 0, 0},
      {131094, 0, 0},
      {131105, 0, 0},
      {196629, 0, 0},
      {196631, 0, 0},
      {196632, 0, 0},
      {196640, 0, 0},
      {196641, 0, 0},
      {262177, 0, 0},
      {327713, 0, 0},
      {393249, 0, 0},
      {458785, 0, 0},
      {524313, 0, 0},
      {524321, 0, 0},
      {589857, 0, 0},
      {655393, 0, 0},
      {786465, 0, 0},
      {917537, 0, 0},
      {1048609, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 19, 18},
      {0, 21, 15},
      {0, 1, 22},
      {0, 16, 23},
      {0, 14, 24},
      {0, 20, 25},
      {0, 13, 17},
      {0, 3, 26},
      {0, 6, 11},
      {0, 27, 12},
      {0, 4, 28},
      {0, 29, 10},
      {0, 9, 30},
      {0, 7, 31},
      {0, 33, 32},
      {0, 34, 5},
      {0, 8, 35},
      {0, 2, 36},
      {0, 38, 37},
    }));

    codecs.emplace(SpvOpTypeFunction, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {131086, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(SpvOpExtInstImport, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {131099, 0, 0},
      {196640, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 3},
      {0, 1, 4},
    }));

    codecs.emplace(SpvOpTypeImage, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {131143, 0, 0},
      {196679, 0, 0},
      {196680, 0, 0},
      {262216, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 2},
      {0, 3, 6},
      {0, 7, 1},
      {0, 4, 8},
    }));

    codecs.emplace(SpvOpMemberDecorate, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {65553, 0, 0},
      {131083, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 3},
      {0, 2, 4},
    }));

    codecs.emplace(SpvOpCapability, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(17, {
      {0, 0, 0},
      {196629, 0, 0},
      {196631, 0, 0},
      {196632, 0, 0},
      {196640, 0, 0},
      {196651, 0, 0},
      {196667, 0, 0},
      {327713, 0, 0},
      {458785, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 7, 8},
      {0, 1, 10},
      {0, 6, 11},
      {0, 9, 12},
      {0, 4, 13},
      {0, 3, 14},
      {0, 15, 2},
      {0, 5, 16},
    }));

    codecs.emplace(SpvOpTypeInt, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(29, {
      {0, 0, 0},
      {65556, 0, 0},
      {131073, 0, 0},
      {196629, 0, 0},
      {196631, 0, 0},
      {196632, 0, 0},
      {196636, 0, 0},
      {196640, 0, 0},
      {196651, 0, 0},
      {196667, 0, 0},
      {262188, 0, 0},
      {262198, 0, 0},
      {327724, 0, 0},
      {393260, 0, 0},
      {524313, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 6},
      {0, 16, 3},
      {0, 11, 17},
      {0, 5, 18},
      {0, 15, 19},
      {0, 13, 20},
      {0, 1, 4},
      {0, 12, 21},
      {0, 7, 22},
      {0, 14, 23},
      {0, 24, 10},
      {0, 25, 9},
      {0, 27, 26},
      {0, 8, 28},
    }));

    codecs.emplace(SpvOpConstantComposite, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(15, {
      {0, 0, 0},
      {65556, 0, 0},
      {196631, 0, 0},
      {196640, 0, 0},
      {196651, 0, 0},
      {196667, 0, 0},
      {327724, 0, 0},
      {393260, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 6, 7},
      {0, 1, 9},
      {0, 10, 8},
      {0, 2, 11},
      {0, 5, 12},
      {0, 13, 4},
      {0, 3, 14},
    }));

    codecs.emplace(SpvOpTypeSampledImage, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(21, {
      {0, 0, 0},
      {131073, 0, 0},
      {196629, 0, 0},
      {196631, 0, 0},
      {196632, 0, 0},
      {196636, 0, 0},
      {196640, 0, 0},
      {196641, 0, 0},
      {196651, 0, 0},
      {196667, 0, 0},
      {262198, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 5},
      {0, 11, 12},
      {0, 8, 13},
      {0, 7, 14},
      {0, 4, 10},
      {0, 9, 2},
      {0, 16, 15},
      {0, 1, 17},
      {0, 19, 18},
      {0, 6, 20},
    }));

    codecs.emplace(SpvOpTypeStruct, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(49, {
      {0, 0, 0},
      {65785, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {196669, 0, 0},
      {196735, 0, 0},
      {262201, 0, 0},
      {262209, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262272, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262277, 0, 0},
      {262286, 0, 0},
      {262292, 0, 0},
      {327692, 0, 0},
      {327745, 0, 0},
      {327760, 0, 0},
      {327762, 0, 0},
      {393228, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {458764, 0, 0},
      {458831, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 20, 12},
      {0, 26, 24},
      {0, 21, 27},
      {0, 28, 16},
      {0, 10, 8},
      {0, 30, 29},
      {0, 31, 17},
      {0, 32, 13},
      {0, 25, 6},
      {0, 1, 33},
      {0, 14, 11},
      {0, 3, 34},
      {0, 18, 35},
      {0, 37, 36},
      {0, 23, 5},
      {0, 38, 2},
      {0, 39, 7},
      {0, 4, 9},
      {0, 40, 19},
      {0, 42, 41},
      {0, 43, 22},
      {0, 45, 44},
      {0, 46, 15},
      {0, 48, 47},
    }));

    codecs.emplace(SpvOpFNegate, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(11, {
      {0, 0, 0},
      {65555, 0, 0},
      {131143, 0, 0},
      {196679, 0, 0},
      {196680, 0, 0},
      {262216, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 6},
      {0, 1, 2},
      {0, 8, 7},
      {0, 5, 9},
      {0, 3, 10},
    }));

    codecs.emplace(SpvOpDecorate, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(25, {
      {0, 0, 0},
      {65562, 0, 0},
      {196629, 0, 0},
      {196631, 0, 0},
      {196632, 0, 0},
      {196636, 0, 0},
      {196640, 0, 0},
      {196641, 0, 0},
      {196651, 0, 0},
      {196667, 0, 0},
      {262177, 0, 0},
      {262198, 0, 0},
      {327713, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 12, 11},
      {0, 9, 14},
      {0, 10, 15},
      {0, 13, 16},
      {0, 4, 17},
      {0, 2, 1},
      {0, 18, 7},
      {0, 20, 19},
      {0, 21, 3},
      {0, 22, 6},
      {0, 5, 8},
      {0, 24, 23},
    }));

    codecs.emplace(SpvOpTypeMatrix, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(31, {
      {0, 0, 0},
      {65556, 0, 0},
      {131073, 0, 0},
      {131094, 0, 0},
      {196629, 0, 0},
      {196631, 0, 0},
      {196632, 0, 0},
      {196636, 0, 0},
      {196640, 0, 0},
      {196651, 0, 0},
      {196667, 0, 0},
      {262188, 0, 0},
      {262198, 0, 0},
      {327724, 0, 0},
      {393260, 0, 0},
      {524313, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 12, 2},
      {0, 17, 3},
      {0, 5, 18},
      {0, 1, 19},
      {0, 16, 4},
      {0, 21, 20},
      {0, 6, 15},
      {0, 7, 22},
      {0, 24, 23},
      {0, 13, 14},
      {0, 25, 8},
      {0, 26, 11},
      {0, 27, 10},
      {0, 29, 28},
      {0, 30, 9},
    }));

    codecs.emplace(SpvOpConstant, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(33, {
      {0, 0, 0},
      {131113, 0, 0},
      {196629, 0, 0},
      {196631, 0, 0},
      {196632, 0, 0},
      {196640, 0, 0},
      {196641, 0, 0},
      {196651, 0, 0},
      {196667, 0, 0},
      {262188, 0, 0},
      {262198, 0, 0},
      {327713, 0, 0},
      {327724, 0, 0},
      {393249, 0, 0},
      {393260, 0, 0},
      {524313, 0, 0},
      {524321, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 6, 4},
      {0, 13, 11},
      {0, 16, 15},
      {0, 18, 10},
      {0, 20, 19},
      {0, 21, 2},
      {0, 23, 22},
      {0, 8, 24},
      {0, 9, 25},
      {0, 17, 26},
      {0, 14, 27},
      {0, 12, 28},
      {0, 1, 3},
      {0, 5, 29},
      {0, 30, 7},
      {0, 32, 31},
    }));

    codecs.emplace(SpvOpTypeBool, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(11, {
      {0, 0, 0},
      {196636, 0, 0},
      {196640, 0, 0},
      {196651, 0, 0},
      {196667, 0, 0},
      {524313, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 5},
      {0, 3, 7},
      {0, 2, 8},
      {0, 6, 9},
      {0, 1, 10},
    }));

    codecs.emplace(SpvOpTypeArray, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(67, {
      {0, 0, 0},
      {65785, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {131319, 0, 0},
      {196669, 0, 0},
      {196735, 0, 0},
      {262201, 0, 0},
      {262209, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262231, 0, 0},
      {262272, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262277, 0, 0},
      {262280, 0, 0},
      {262286, 0, 0},
      {262292, 0, 0},
      {262334, 0, 0},
      {327692, 0, 0},
      {327737, 0, 0},
      {327745, 0, 0},
      {327760, 0, 0},
      {327761, 0, 0},
      {327762, 0, 0},
      {393228, 0, 0},
      {393273, 0, 0},
      {393281, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {458764, 0, 0},
      {458831, 0, 0},
      {524367, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 7, 27},
      {0, 11, 28},
      {0, 35, 21},
      {0, 36, 1},
      {0, 4, 37},
      {0, 39, 38},
      {0, 40, 30},
      {0, 41, 12},
      {0, 19, 42},
      {0, 13, 43},
      {0, 16, 44},
      {0, 45, 22},
      {0, 34, 18},
      {0, 29, 24},
      {0, 46, 25},
      {0, 6, 2},
      {0, 9, 31},
      {0, 17, 47},
      {0, 49, 48},
      {0, 50, 33},
      {0, 51, 26},
      {0, 20, 52},
      {0, 32, 53},
      {0, 3, 54},
      {0, 15, 14},
      {0, 23, 55},
      {0, 8, 56},
      {0, 58, 57},
      {0, 10, 59},
      {0, 5, 60},
      {0, 62, 61},
      {0, 64, 63},
      {0, 66, 65},
    }));

    codecs.emplace(SpvOpExtInst, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(57, {
      {0, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {196665, 0, 0},
      {196669, 0, 0},
      {196718, 0, 0},
      {262201, 0, 0},
      {262209, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262231, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262277, 0, 0},
      {262280, 0, 0},
      {262286, 0, 0},
      {262292, 0, 0},
      {327692, 0, 0},
      {327745, 0, 0},
      {327760, 0, 0},
      {327762, 0, 0},
      {393228, 0, 0},
      {393273, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {393303, 0, 0},
      {458764, 0, 0},
      {458831, 0, 0},
      {524367, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 18, 6},
      {0, 30, 22},
      {0, 31, 25},
      {0, 10, 32},
      {0, 21, 33},
      {0, 3, 34},
      {0, 35, 5},
      {0, 23, 36},
      {0, 14, 17},
      {0, 37, 26},
      {0, 1, 38},
      {0, 29, 39},
      {0, 13, 40},
      {0, 41, 19},
      {0, 28, 20},
      {0, 16, 42},
      {0, 27, 43},
      {0, 8, 24},
      {0, 7, 44},
      {0, 9, 45},
      {0, 15, 46},
      {0, 12, 47},
      {0, 48, 2},
      {0, 4, 49},
      {0, 51, 50},
      {0, 11, 52},
      {0, 54, 53},
      {0, 56, 55},
    }));

    codecs.emplace(SpvOpVectorTimesScalar, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(67, {
      {0, 0, 0},
      {65785, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {196669, 0, 0},
      {196735, 0, 0},
      {262201, 0, 0},
      {262209, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262230, 0, 0},
      {262231, 0, 0},
      {262272, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262277, 0, 0},
      {262280, 0, 0},
      {262286, 0, 0},
      {262292, 0, 0},
      {327692, 0, 0},
      {327737, 0, 0},
      {327745, 0, 0},
      {327760, 0, 0},
      {327761, 0, 0},
      {327762, 0, 0},
      {393228, 0, 0},
      {393273, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {393303, 0, 0},
      {393304, 0, 0},
      {458764, 0, 0},
      {458831, 0, 0},
      {524367, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 26, 29},
      {0, 20, 35},
      {0, 12, 36},
      {0, 6, 37},
      {0, 38, 28},
      {0, 30, 5},
      {0, 8, 39},
      {0, 2, 40},
      {0, 41, 21},
      {0, 1, 10},
      {0, 43, 42},
      {0, 23, 16},
      {0, 44, 33},
      {0, 34, 31},
      {0, 14, 45},
      {0, 19, 46},
      {0, 25, 47},
      {0, 49, 48},
      {0, 27, 22},
      {0, 7, 50},
      {0, 17, 32},
      {0, 18, 51},
      {0, 24, 52},
      {0, 54, 53},
      {0, 55, 9},
      {0, 56, 11},
      {0, 57, 4},
      {0, 15, 58},
      {0, 59, 13},
      {0, 60, 3},
      {0, 62, 61},
      {0, 64, 63},
      {0, 66, 65},
    }));

    codecs.emplace(SpvOpVectorShuffle, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(33, {
      {0, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {196669, 0, 0},
      {262201, 0, 0},
      {262209, 0, 0},
      {262225, 0, 0},
      {262231, 0, 0},
      {262273, 0, 0},
      {262277, 0, 0},
      {262286, 0, 0},
      {262292, 0, 0},
      {327745, 0, 0},
      {393281, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {458831, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 13, 12},
      {0, 1, 18},
      {0, 19, 11},
      {0, 9, 20},
      {0, 10, 21},
      {0, 22, 15},
      {0, 23, 8},
      {0, 4, 24},
      {0, 25, 7},
      {0, 17, 26},
      {0, 5, 27},
      {0, 14, 3},
      {0, 29, 28},
      {0, 30, 2},
      {0, 6, 31},
      {0, 32, 16},
    }));

    codecs.emplace(SpvOpImageSampleImplicitLod, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(55, {
      {0, 0, 0},
      {65785, 0, 0},
      {65790, 0, 0},
      {131134, 0, 0},
      {196669, 0, 0},
      {196735, 0, 0},
      {196817, 0, 0},
      {262209, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262277, 0, 0},
      {262280, 0, 0},
      {262286, 0, 0},
      {262292, 0, 0},
      {327692, 0, 0},
      {327745, 0, 0},
      {327760, 0, 0},
      {327761, 0, 0},
      {327762, 0, 0},
      {393228, 0, 0},
      {393281, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {393298, 0, 0},
      {458764, 0, 0},
      {458831, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 2},
      {0, 22, 29},
      {0, 30, 1},
      {0, 6, 31},
      {0, 9, 32},
      {0, 28, 3},
      {0, 27, 33},
      {0, 20, 16},
      {0, 34, 8},
      {0, 10, 35},
      {0, 4, 36},
      {0, 24, 23},
      {0, 21, 13},
      {0, 7, 37},
      {0, 38, 14},
      {0, 25, 39},
      {0, 17, 11},
      {0, 12, 19},
      {0, 41, 40},
      {0, 42, 18},
      {0, 15, 43},
      {0, 45, 44},
      {0, 47, 46},
      {0, 26, 48},
      {0, 50, 49},
      {0, 52, 51},
      {0, 54, 53},
    }));

    codecs.emplace(SpvOpDot, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(11, {
      {0, 0, 0},
      {131075, 0, 0},
      {131088, 0, 0},
      {196624, 0, 0},
      {196679, 0, 0},
      {262216, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 3},
      {0, 2, 7},
      {0, 1, 8},
      {0, 6, 9},
      {0, 4, 10},
    }));

    codecs.emplace(SpvOpExecutionMode, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {196858, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(SpvOpSelectionMerge, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(23, {
      {0, 0, 0},
      {131134, 0, 0},
      {196669, 0, 0},
      {262209, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262277, 0, 0},
      {327745, 0, 0},
      {327761, 0, 0},
      {327762, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 12},
      {0, 7, 13},
      {0, 5, 1},
      {0, 4, 10},
      {0, 14, 6},
      {0, 16, 15},
      {0, 17, 11},
      {0, 3, 8},
      {0, 19, 18},
      {0, 9, 20},
      {0, 22, 21},
    }));

    codecs.emplace(SpvOpImageSampleDrefExplicitLod, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {65790, 0, 0},
      {131073, 0, 0},
      {262198, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 1},
      {0, 3, 5},
      {0, 2, 6},
    }));

    codecs.emplace(SpvOpUndef, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(59, {
      {0, 0, 0},
      {65785, 0, 0},
      {131134, 0, 0},
      {131319, 0, 0},
      {196669, 0, 0},
      {196735, 0, 0},
      {262209, 0, 0},
      {262221, 0, 0},
      {262224, 0, 0},
      {262225, 0, 0},
      {262230, 0, 0},
      {262273, 0, 0},
      {262275, 0, 0},
      {262277, 0, 0},
      {262280, 0, 0},
      {262286, 0, 0},
      {262288, 0, 0},
      {262292, 0, 0},
      {262334, 0, 0},
      {327692, 0, 0},
      {327760, 0, 0},
      {327761, 0, 0},
      {327762, 0, 0},
      {393228, 0, 0},
      {393295, 0, 0},
      {393296, 0, 0},
      {393298, 0, 0},
      {458764, 0, 0},
      {458831, 0, 0},
      {524367, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 17, 3},
      {0, 5, 31},
      {0, 11, 32},
      {0, 33, 12},
      {0, 34, 20},
      {0, 16, 27},
      {0, 35, 23},
      {0, 37, 36},
      {0, 14, 18},
      {0, 39, 38},
      {0, 7, 30},
      {0, 8, 25},
      {0, 40, 15},
      {0, 13, 2},
      {0, 1, 29},
      {0, 19, 41},
      {0, 43, 42},
      {0, 28, 44},
      {0, 46, 45},
      {0, 22, 21},
      {0, 47, 24},
      {0, 48, 26},
      {0, 10, 6},
      {0, 50, 49},
      {0, 52, 51},
      {0, 54, 53},
      {0, 4, 9},
      {0, 56, 55},
      {0, 58, 57},
    }));

    codecs.emplace(SpvOpCompositeInsert, std::move(codec));
  }

  return codecs;
}

std::map<uint32_t, std::unique_ptr<HuffmanCodec<std::string>>>
GetLiteralStringHuffmanCodecs() {
  std::map<uint32_t, std::unique_ptr<HuffmanCodec<std::string>>> codecs;
  {
    std::unique_ptr<HuffmanCodec<std::string>> codec(new HuffmanCodec<std::string>(7, {
      {"", 0, 0},
      {"MainPs", 0, 0},
      {"MainVs", 0, 0},
      {"kMarkvNoneOfTheAbove", 0, 0},
      {"main", 0, 0},
      {"", 2, 3},
      {"", 1, 5},
      {"", 4, 6},
    }));

    codecs.emplace(SpvOpEntryPoint, std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<std::string>> codec(new HuffmanCodec<std::string>(3, {
      {"", 0, 0},
      {"GLSL.std.450", 0, 0},
      {"kMarkvNoneOfTheAbove", 0, 0},
      {"", 1, 2},
    }));

    codecs.emplace(SpvOpExtInstImport, std::move(codec));
  }

  return codecs;
}

std::map<std::pair<uint32_t, uint32_t>, std::unique_ptr<HuffmanCodec<uint64_t>>>
GetNonIdWordHuffmanCodecs() {
  std::map<std::pair<uint32_t, uint32_t>, std::unique_ptr<HuffmanCodec<uint64_t>>> codecs;
  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(33, {
      {0, 0, 0},
      {4, 0, 0},
      {8, 0, 0},
      {10, 0, 0},
      {26, 0, 0},
      {29, 0, 0},
      {31, 0, 0},
      {37, 0, 0},
      {40, 0, 0},
      {43, 0, 0},
      {46, 0, 0},
      {49, 0, 0},
      {66, 0, 0},
      {67, 0, 0},
      {68, 0, 0},
      {69, 0, 0},
      {71, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 12, 5},
      {0, 18, 13},
      {0, 3, 7},
      {0, 19, 11},
      {0, 20, 16},
      {0, 14, 17},
      {0, 21, 1},
      {0, 2, 6},
      {0, 23, 22},
      {0, 4, 24},
      {0, 26, 25},
      {0, 28, 27},
      {0, 10, 15},
      {0, 8, 9},
      {0, 30, 29},
      {0, 32, 31},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpExtInst, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {0, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpMemoryModel, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {1, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpMemoryModel, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {0, 0, 0},
      {4, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 3},
      {0, 2, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpEntryPoint, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {7, 0, 0},
      {8, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 2},
      {0, 1, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpExecutionMode, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(11, {
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {4, 0, 0},
      {18, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 2},
      {0, 6, 5},
      {0, 7, 1},
      {0, 3, 8},
      {0, 10, 9},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpExecutionMode, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {1, 0, 0},
      {32, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 3},
      {0, 1, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCapability, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {32, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeInt, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 3},
      {0, 1, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeInt, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {32, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFloat, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {4, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 4},
      {0, 1, 5},
      {0, 6, 3},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeVector, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {4, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 4},
      {0, 2, 5},
      {0, 3, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeMatrix, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 4},
      {0, 2, 5},
      {0, 1, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeImage, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 3},
      {0, 1, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeImage, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {0, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeImage, 4), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {0, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeImage, 5), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {1, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeImage, 6), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {0, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeImage, 7), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(13, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {6, 0, 0},
      {7, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 7},
      {0, 6, 8},
      {0, 1, 4},
      {0, 2, 9},
      {0, 10, 3},
      {0, 12, 11},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypePointer, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(173, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {4, 0, 0},
      {5, 0, 0},
      {6, 0, 0},
      {7, 0, 0},
      {8, 0, 0},
      {9, 0, 0},
      {10, 0, 0},
      {11, 0, 0},
      {12, 0, 0},
      {13, 0, 0},
      {14, 0, 0},
      {15, 0, 0},
      {16, 0, 0},
      {17, 0, 0},
      {18, 0, 0},
      {19, 0, 0},
      {20, 0, 0},
      {21, 0, 0},
      {22, 0, 0},
      {23, 0, 0},
      {24, 0, 0},
      {26, 0, 0},
      {27, 0, 0},
      {28, 0, 0},
      {29, 0, 0},
      {30, 0, 0},
      {31, 0, 0},
      {32, 0, 0},
      {256, 0, 0},
      {507307272, 0, 0},
      {864026611, 0, 0},
      {981668463, 0, 0},
      {997553156, 0, 0},
      {1014330372, 0, 0},
      {1020708227, 0, 0},
      {1028443341, 0, 0},
      {1032953056, 0, 0},
      {1033463938, 0, 0},
      {1033463943, 0, 0},
      {1039998884, 0, 0},
      {1039998950, 0, 0},
      {1040187392, 0, 0},
      {1042401985, 0, 0},
      {1044220635, 0, 0},
      {1045622707, 0, 0},
      {1045622740, 0, 0},
      {1048576000, 0, 0},
      {1053609165, 0, 0},
      {1053790359, 0, 0},
      {1054448026, 0, 0},
      {1055437881, 0, 0},
      {1056300230, 0, 0},
      {1056964608, 0, 0},
      {1058056805, 0, 0},
      {1059286575, 0, 0},
      {1061158912, 0, 0},
      {1061997773, 0, 0},
      {1064514355, 0, 0},
      {1064854933, 0, 0},
      {1065353216, 0, 0},
      {1069547520, 0, 0},
      {1073741824, 0, 0},
      {1077936128, 0, 0},
      {1082130432, 0, 0},
      {1091567616, 0, 0},
      {1115422720, 0, 0},
      {1124073472, 0, 0},
      {1132396544, 0, 0},
      {1140850688, 0, 0},
      {1199562752, 0, 0},
      {3179067684, 0, 0},
      {3180973575, 0, 0},
      {3182651297, 0, 0},
      {3196448879, 0, 0},
      {3204448256, 0, 0},
      {3204993516, 0, 0},
      {3205248529, 0, 0},
      {3207137644, 0, 0},
      {3208642560, 0, 0},
      {3211081967, 0, 0},
      {3212836864, 0, 0},
      {3332128768, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 38, 37},
      {0, 42, 39},
      {0, 49, 44},
      {0, 45, 43},
      {0, 26, 50},
      {0, 46, 73},
      {0, 35, 28},
      {0, 32, 65},
      {0, 83, 40},
      {0, 60, 62},
      {0, 27, 54},
      {0, 79, 67},
      {0, 31, 74},
      {0, 51, 12},
      {0, 70, 30},
      {0, 15, 16},
      {0, 88, 25},
      {0, 90, 89},
      {0, 34, 71},
      {0, 72, 29},
      {0, 92, 91},
      {0, 14, 33},
      {0, 94, 93},
      {0, 22, 23},
      {0, 21, 95},
      {0, 19, 24},
      {0, 96, 13},
      {0, 47, 41},
      {0, 53, 48},
      {0, 58, 56},
      {0, 63, 59},
      {0, 76, 75},
      {0, 78, 77},
      {0, 81, 80},
      {0, 84, 82},
      {0, 52, 20},
      {0, 97, 69},
      {0, 99, 98},
      {0, 18, 10},
      {0, 68, 61},
      {0, 17, 100},
      {0, 102, 101},
      {0, 11, 36},
      {0, 104, 103},
      {0, 86, 105},
      {0, 107, 106},
      {0, 109, 108},
      {0, 110, 9},
      {0, 8, 111},
      {0, 113, 112},
      {0, 115, 114},
      {0, 117, 116},
      {0, 119, 118},
      {0, 121, 120},
      {0, 123, 122},
      {0, 125, 124},
      {0, 126, 7},
      {0, 127, 85},
      {0, 6, 128},
      {0, 129, 55},
      {0, 130, 5},
      {0, 132, 131},
      {0, 134, 133},
      {0, 136, 135},
      {0, 137, 66},
      {0, 139, 138},
      {0, 141, 140},
      {0, 143, 142},
      {0, 145, 144},
      {0, 146, 57},
      {0, 147, 64},
      {0, 148, 4},
      {0, 149, 2},
      {0, 151, 150},
      {0, 152, 3},
      {0, 154, 153},
      {0, 156, 155},
      {0, 158, 157},
      {0, 159, 1},
      {0, 160, 87},
      {0, 162, 161},
      {0, 164, 163},
      {0, 166, 165},
      {0, 168, 167},
      {0, 170, 169},
      {0, 172, 171},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpConstant, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {0, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunction, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(13, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {6, 0, 0},
      {7, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 7},
      {0, 4, 8},
      {0, 9, 2},
      {0, 1, 5},
      {0, 10, 6},
      {0, 12, 11},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpVariable, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(15, {
      {0, 0, 0},
      {0, 0, 0},
      {2, 0, 0},
      {6, 0, 0},
      {11, 0, 0},
      {30, 0, 0},
      {33, 0, 0},
      {34, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 8},
      {0, 9, 1},
      {0, 3, 10},
      {0, 6, 11},
      {0, 12, 2},
      {0, 7, 5},
      {0, 14, 13},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpDecorate, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(37, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {4, 0, 0},
      {5, 0, 0},
      {6, 0, 0},
      {7, 0, 0},
      {8, 0, 0},
      {9, 0, 0},
      {10, 0, 0},
      {12, 0, 0},
      {13, 0, 0},
      {14, 0, 0},
      {15, 0, 0},
      {16, 0, 0},
      {18, 0, 0},
      {64, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 17, 11},
      {0, 10, 13},
      {0, 12, 14},
      {0, 21, 20},
      {0, 9, 22},
      {0, 19, 15},
      {0, 8, 23},
      {0, 18, 24},
      {0, 25, 7},
      {0, 5, 6},
      {0, 26, 16},
      {0, 27, 4},
      {0, 28, 3},
      {0, 30, 29},
      {0, 31, 2},
      {0, 33, 32},
      {0, 35, 34},
      {0, 1, 36},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpDecorate, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(79, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {4, 0, 0},
      {5, 0, 0},
      {6, 0, 0},
      {7, 0, 0},
      {8, 0, 0},
      {9, 0, 0},
      {10, 0, 0},
      {11, 0, 0},
      {12, 0, 0},
      {13, 0, 0},
      {14, 0, 0},
      {15, 0, 0},
      {16, 0, 0},
      {17, 0, 0},
      {18, 0, 0},
      {19, 0, 0},
      {20, 0, 0},
      {21, 0, 0},
      {22, 0, 0},
      {23, 0, 0},
      {24, 0, 0},
      {25, 0, 0},
      {26, 0, 0},
      {27, 0, 0},
      {28, 0, 0},
      {29, 0, 0},
      {30, 0, 0},
      {31, 0, 0},
      {32, 0, 0},
      {33, 0, 0},
      {34, 0, 0},
      {35, 0, 0},
      {36, 0, 0},
      {37, 0, 0},
      {38, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 39, 37},
      {0, 40, 36},
      {0, 34, 35},
      {0, 32, 33},
      {0, 30, 31},
      {0, 27, 29},
      {0, 26, 28},
      {0, 42, 41},
      {0, 23, 25},
      {0, 38, 22},
      {0, 44, 43},
      {0, 46, 45},
      {0, 21, 47},
      {0, 19, 20},
      {0, 17, 18},
      {0, 14, 15},
      {0, 12, 10},
      {0, 16, 13},
      {0, 9, 11},
      {0, 7, 8},
      {0, 6, 5},
      {0, 24, 48},
      {0, 50, 49},
      {0, 3, 4},
      {0, 51, 2},
      {0, 1, 52},
      {0, 54, 53},
      {0, 56, 55},
      {0, 58, 57},
      {0, 60, 59},
      {0, 62, 61},
      {0, 64, 63},
      {0, 66, 65},
      {0, 68, 67},
      {0, 70, 69},
      {0, 72, 71},
      {0, 74, 73},
      {0, 76, 75},
      {0, 78, 77},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpMemberDecorate, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {4, 0, 0},
      {7, 0, 0},
      {35, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 4},
      {0, 5, 2},
      {0, 3, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpMemberDecorate, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(149, {
      {0, 0, 0},
      {0, 0, 0},
      {16, 0, 0},
      {28, 0, 0},
      {32, 0, 0},
      {36, 0, 0},
      {40, 0, 0},
      {44, 0, 0},
      {48, 0, 0},
      {60, 0, 0},
      {64, 0, 0},
      {76, 0, 0},
      {80, 0, 0},
      {84, 0, 0},
      {88, 0, 0},
      {92, 0, 0},
      {96, 0, 0},
      {100, 0, 0},
      {108, 0, 0},
      {112, 0, 0},
      {120, 0, 0},
      {124, 0, 0},
      {128, 0, 0},
      {132, 0, 0},
      {136, 0, 0},
      {140, 0, 0},
      {144, 0, 0},
      {148, 0, 0},
      {152, 0, 0},
      {156, 0, 0},
      {160, 0, 0},
      {172, 0, 0},
      {176, 0, 0},
      {192, 0, 0},
      {204, 0, 0},
      {208, 0, 0},
      {224, 0, 0},
      {236, 0, 0},
      {240, 0, 0},
      {248, 0, 0},
      {256, 0, 0},
      {272, 0, 0},
      {288, 0, 0},
      {292, 0, 0},
      {296, 0, 0},
      {300, 0, 0},
      {304, 0, 0},
      {316, 0, 0},
      {320, 0, 0},
      {332, 0, 0},
      {336, 0, 0},
      {348, 0, 0},
      {352, 0, 0},
      {364, 0, 0},
      {368, 0, 0},
      {372, 0, 0},
      {376, 0, 0},
      {384, 0, 0},
      {392, 0, 0},
      {400, 0, 0},
      {416, 0, 0},
      {424, 0, 0},
      {432, 0, 0},
      {448, 0, 0},
      {460, 0, 0},
      {464, 0, 0},
      {468, 0, 0},
      {472, 0, 0},
      {476, 0, 0},
      {480, 0, 0},
      {488, 0, 0},
      {492, 0, 0},
      {496, 0, 0},
      {512, 0, 0},
      {640, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 14, 17},
      {0, 37, 31},
      {0, 21, 39},
      {0, 24, 23},
      {0, 5, 13},
      {0, 38, 76},
      {0, 51, 77},
      {0, 55, 53},
      {0, 58, 56},
      {0, 64, 61},
      {0, 67, 66},
      {0, 70, 68},
      {0, 54, 71},
      {0, 62, 60},
      {0, 65, 63},
      {0, 73, 72},
      {0, 59, 57},
      {0, 52, 74},
      {0, 50, 69},
      {0, 49, 47},
      {0, 48, 46},
      {0, 45, 43},
      {0, 42, 44},
      {0, 78, 41},
      {0, 20, 18},
      {0, 80, 79},
      {0, 15, 27},
      {0, 7, 34},
      {0, 81, 6},
      {0, 28, 3},
      {0, 35, 82},
      {0, 9, 36},
      {0, 84, 83},
      {0, 86, 85},
      {0, 88, 87},
      {0, 90, 89},
      {0, 92, 91},
      {0, 94, 93},
      {0, 96, 95},
      {0, 98, 97},
      {0, 11, 29},
      {0, 99, 25},
      {0, 100, 40},
      {0, 102, 101},
      {0, 26, 32},
      {0, 19, 30},
      {0, 16, 12},
      {0, 4, 8},
      {0, 104, 103},
      {0, 106, 105},
      {0, 33, 107},
      {0, 109, 108},
      {0, 111, 110},
      {0, 22, 112},
      {0, 113, 10},
      {0, 115, 114},
      {0, 75, 116},
      {0, 118, 117},
      {0, 119, 1},
      {0, 121, 120},
      {0, 123, 122},
      {0, 125, 124},
      {0, 127, 126},
      {0, 129, 128},
      {0, 131, 130},
      {0, 132, 2},
      {0, 134, 133},
      {0, 136, 135},
      {0, 138, 137},
      {0, 140, 139},
      {0, 142, 141},
      {0, 144, 143},
      {0, 146, 145},
      {0, 148, 147},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpMemberDecorate, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(11, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {4, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 6},
      {0, 4, 7},
      {0, 8, 3},
      {0, 9, 5},
      {0, 1, 10},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpVectorShuffle, 4), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(13, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {4, 0, 0},
      {5, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 7},
      {0, 8, 5},
      {0, 9, 1},
      {0, 4, 10},
      {0, 11, 6},
      {0, 2, 12},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpVectorShuffle, 5), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(15, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {4, 0, 0},
      {5, 0, 0},
      {6, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 6, 8},
      {0, 5, 2},
      {0, 10, 9},
      {0, 1, 4},
      {0, 12, 11},
      {0, 7, 13},
      {0, 3, 14},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpVectorShuffle, 6), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(15, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {4, 0, 0},
      {5, 0, 0},
      {6, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 8, 5},
      {0, 9, 7},
      {0, 10, 3},
      {0, 11, 2},
      {0, 6, 1},
      {0, 13, 12},
      {0, 4, 14},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpVectorShuffle, 7), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(61, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {4, 0, 0},
      {5, 0, 0},
      {6, 0, 0},
      {7, 0, 0},
      {8, 0, 0},
      {9, 0, 0},
      {10, 0, 0},
      {11, 0, 0},
      {12, 0, 0},
      {13, 0, 0},
      {14, 0, 0},
      {15, 0, 0},
      {16, 0, 0},
      {17, 0, 0},
      {18, 0, 0},
      {19, 0, 0},
      {20, 0, 0},
      {21, 0, 0},
      {22, 0, 0},
      {23, 0, 0},
      {24, 0, 0},
      {27, 0, 0},
      {28, 0, 0},
      {29, 0, 0},
      {30, 0, 0},
      {31, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 30, 16},
      {0, 26, 27},
      {0, 29, 28},
      {0, 18, 22},
      {0, 12, 19},
      {0, 15, 20},
      {0, 14, 23},
      {0, 32, 7},
      {0, 8, 21},
      {0, 11, 33},
      {0, 17, 34},
      {0, 25, 13},
      {0, 36, 35},
      {0, 9, 10},
      {0, 38, 37},
      {0, 39, 31},
      {0, 5, 40},
      {0, 42, 41},
      {0, 44, 43},
      {0, 6, 45},
      {0, 46, 24},
      {0, 48, 47},
      {0, 50, 49},
      {0, 52, 51},
      {0, 54, 53},
      {0, 55, 4},
      {0, 56, 3},
      {0, 57, 2},
      {0, 58, 1},
      {0, 60, 59},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeExtract, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(63, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {4, 0, 0},
      {5, 0, 0},
      {6, 0, 0},
      {7, 0, 0},
      {8, 0, 0},
      {9, 0, 0},
      {10, 0, 0},
      {11, 0, 0},
      {12, 0, 0},
      {13, 0, 0},
      {29, 0, 0},
      {30, 0, 0},
      {31, 0, 0},
      {32, 0, 0},
      {33, 0, 0},
      {34, 0, 0},
      {35, 0, 0},
      {36, 0, 0},
      {37, 0, 0},
      {38, 0, 0},
      {39, 0, 0},
      {40, 0, 0},
      {41, 0, 0},
      {42, 0, 0},
      {43, 0, 0},
      {44, 0, 0},
      {45, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 13, 14},
      {0, 12, 9},
      {0, 11, 25},
      {0, 27, 26},
      {0, 29, 28},
      {0, 31, 30},
      {0, 23, 22},
      {0, 10, 24},
      {0, 8, 21},
      {0, 17, 7},
      {0, 19, 18},
      {0, 15, 20},
      {0, 6, 16},
      {0, 5, 33},
      {0, 35, 34},
      {0, 37, 36},
      {0, 39, 38},
      {0, 41, 40},
      {0, 43, 42},
      {0, 45, 44},
      {0, 47, 46},
      {0, 49, 48},
      {0, 51, 50},
      {0, 32, 52},
      {0, 54, 53},
      {0, 56, 55},
      {0, 58, 57},
      {0, 3, 2},
      {0, 59, 4},
      {0, 60, 1},
      {0, 62, 61},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeExtract, 4), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 5},
      {0, 3, 2},
      {0, 6, 4},
      {0, 8, 7},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeExtract, 5), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(23, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {4, 0, 0},
      {5, 0, 0},
      {6, 0, 0},
      {7, 0, 0},
      {8, 0, 0},
      {9, 0, 0},
      {10, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 12, 11},
      {0, 10, 13},
      {0, 9, 14},
      {0, 7, 5},
      {0, 8, 6},
      {0, 4, 15},
      {0, 17, 16},
      {0, 18, 3},
      {0, 19, 2},
      {0, 20, 1},
      {0, 22, 21},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeInsert, 4), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {0, 0, 0},
      {1, 0, 0},
      {2, 0, 0},
      {3, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 5},
      {0, 2, 6},
      {0, 7, 1},
      {0, 4, 8},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeInsert, 5), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {1, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpImageSampleImplicitLod, 4), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {2, 0, 0},
      {10, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 3},
      {0, 1, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpImageSampleExplicitLod, 4), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {2, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpImageSampleDrefExplicitLod, 5), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {0, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpSelectionMerge, 1), std::move(codec));
  }

  return codecs;
}

std::map<std::pair<uint32_t, uint32_t>, std::unique_ptr<HuffmanCodec<uint64_t>>>
GetIdDescriptorHuffmanCodecs() {
  std::map<std::pair<uint32_t, uint32_t>, std::unique_ptr<HuffmanCodec<uint64_t>>> codecs;
  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 5},
      {0, 4, 6},
      {0, 1, 7},
      {0, 2, 8},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpExtInst, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(63, {
      {0, 0, 0},
      {34183582, 0, 0},
      {223800276, 0, 0},
      {295018543, 0, 0},
      {439764402, 0, 0},
      {443558693, 0, 0},
      {583624926, 0, 0},
      {599185303, 0, 0},
      {779021139, 0, 0},
      {1015552308, 0, 0},
      {1027242654, 0, 0},
      {1077859090, 0, 0},
      {1104362365, 0, 0},
      {1132589448, 0, 0},
      {1236389532, 0, 0},
      {1739837626, 0, 0},
      {1955104493, 0, 0},
      {2161102232, 0, 0},
      {2197874825, 0, 0},
      {2217833278, 0, 0},
      {2244470522, 0, 0},
      {2532518896, 0, 0},
      {2789375411, 0, 0},
      {3061690214, 0, 0},
      {3287039847, 0, 0},
      {3357301402, 0, 0},
      {3365041621, 0, 0},
      {3510257966, 0, 0},
      {3534235309, 0, 0},
      {4018237905, 0, 0},
      {4145966869, 0, 0},
      {4272200782, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 10, 19},
      {0, 6, 1},
      {0, 26, 13},
      {0, 2, 11},
      {0, 15, 22},
      {0, 23, 18},
      {0, 4, 27},
      {0, 28, 12},
      {0, 3, 30},
      {0, 9, 7},
      {0, 20, 14},
      {0, 29, 16},
      {0, 21, 8},
      {0, 34, 33},
      {0, 36, 35},
      {0, 31, 25},
      {0, 37, 24},
      {0, 39, 38},
      {0, 41, 40},
      {0, 43, 42},
      {0, 45, 44},
      {0, 17, 5},
      {0, 47, 46},
      {0, 49, 48},
      {0, 51, 50},
      {0, 53, 52},
      {0, 55, 54},
      {0, 57, 56},
      {0, 59, 58},
      {0, 61, 60},
      {0, 32, 62},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpExtInst, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {4228502127, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpExtInst, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(113, {
      {0, 0, 0},
      {50998433, 0, 0},
      {139011596, 0, 0},
      {181902171, 0, 0},
      {296981500, 0, 0},
      {321630747, 0, 0},
      {416853049, 0, 0},
      {464259778, 0, 0},
      {615982737, 0, 0},
      {669982125, 0, 0},
      {759277550, 0, 0},
      {810488476, 0, 0},
      {870594305, 0, 0},
      {922996215, 0, 0},
      {969500141, 0, 0},
      {1015552308, 0, 0},
      {1139547465, 0, 0},
      {1203545131, 0, 0},
      {1220643281, 0, 0},
      {1220749418, 0, 0},
      {1367301635, 0, 0},
      {1395923345, 0, 0},
      {1554194368, 0, 0},
      {1742737136, 0, 0},
      {1755648697, 0, 0},
      {1962162282, 0, 0},
      {1964254745, 0, 0},
      {2055836767, 0, 0},
      {2096388952, 0, 0},
      {2124837447, 0, 0},
      {2161102232, 0, 0},
      {2321729979, 0, 0},
      {2346547796, 0, 0},
      {2399809085, 0, 0},
      {2432827426, 0, 0},
      {2455417440, 0, 0},
      {2572638469, 0, 0},
      {2614879967, 0, 0},
      {2855506940, 0, 0},
      {2919796598, 0, 0},
      {2970183398, 0, 0},
      {2976066508, 0, 0},
      {3044188332, 0, 0},
      {3061690214, 0, 0},
      {3091876332, 0, 0},
      {3104643263, 0, 0},
      {3107165180, 0, 0},
      {3187066832, 0, 0},
      {3413713311, 0, 0},
      {3487022798, 0, 0},
      {3602693817, 0, 0},
      {3678875745, 0, 0},
      {3701632935, 0, 0},
      {3829325073, 0, 0},
      {4040340620, 0, 0},
      {4174489262, 0, 0},
      {4272200782, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 33, 7},
      {0, 13, 34},
      {0, 21, 18},
      {0, 53, 22},
      {0, 39, 1},
      {0, 14, 9},
      {0, 43, 26},
      {0, 51, 35},
      {0, 19, 6},
      {0, 15, 25},
      {0, 55, 29},
      {0, 32, 3},
      {0, 27, 44},
      {0, 10, 46},
      {0, 45, 24},
      {0, 36, 40},
      {0, 47, 8},
      {0, 48, 54},
      {0, 58, 5},
      {0, 60, 59},
      {0, 30, 61},
      {0, 62, 56},
      {0, 64, 63},
      {0, 41, 50},
      {0, 66, 65},
      {0, 68, 67},
      {0, 70, 69},
      {0, 37, 31},
      {0, 4, 17},
      {0, 16, 20},
      {0, 72, 71},
      {0, 73, 52},
      {0, 49, 12},
      {0, 75, 74},
      {0, 76, 11},
      {0, 23, 42},
      {0, 78, 77},
      {0, 80, 79},
      {0, 82, 81},
      {0, 84, 83},
      {0, 85, 28},
      {0, 87, 86},
      {0, 89, 88},
      {0, 91, 90},
      {0, 93, 92},
      {0, 94, 2},
      {0, 96, 95},
      {0, 98, 97},
      {0, 100, 99},
      {0, 102, 101},
      {0, 38, 103},
      {0, 105, 104},
      {0, 107, 106},
      {0, 109, 108},
      {0, 111, 110},
      {0, 57, 112},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpExtInst, 4), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(127, {
      {0, 0, 0},
      {72782198, 0, 0},
      {139011596, 0, 0},
      {296981500, 0, 0},
      {300939750, 0, 0},
      {401211099, 0, 0},
      {429277936, 0, 0},
      {505940164, 0, 0},
      {538168945, 0, 0},
      {603915804, 0, 0},
      {688216667, 0, 0},
      {706016261, 0, 0},
      {790502615, 0, 0},
      {810488476, 0, 0},
      {993150979, 0, 0},
      {1203545131, 0, 0},
      {1206726575, 0, 0},
      {1265796414, 0, 0},
      {1314843976, 0, 0},
      {1367301635, 0, 0},
      {1378082995, 0, 0},
      {1410311776, 0, 0},
      {1443829854, 0, 0},
      {1448448666, 0, 0},
      {1468919488, 0, 0},
      {1496351055, 0, 0},
      {1619778288, 0, 0},
      {1684282922, 0, 0},
      {1848784182, 0, 0},
      {1901166356, 0, 0},
      {2095546797, 0, 0},
      {2096388952, 0, 0},
      {2162986400, 0, 0},
      {2197874825, 0, 0},
      {2246405597, 0, 0},
      {2250225826, 0, 0},
      {2282454607, 0, 0},
      {2328748202, 0, 0},
      {2348201466, 0, 0},
      {2597020383, 0, 0},
      {2633682514, 0, 0},
      {2817335337, 0, 0},
      {2855506940, 0, 0},
      {2936040203, 0, 0},
      {2955375511, 0, 0},
      {3122368657, 0, 0},
      {3154597438, 0, 0},
      {3184381405, 0, 0},
      {3187066832, 0, 0},
      {3233393284, 0, 0},
      {3251128023, 0, 0},
      {3260309823, 0, 0},
      {3441531391, 0, 0},
      {3496407048, 0, 0},
      {3582002820, 0, 0},
      {3647586740, 0, 0},
      {3653838348, 0, 0},
      {3730093054, 0, 0},
      {3759072440, 0, 0},
      {3928764629, 0, 0},
      {3969279737, 0, 0},
      {3994511488, 0, 0},
      {4026740269, 0, 0},
      {4274214049, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 43, 23},
      {0, 5, 24},
      {0, 9, 8},
      {0, 36, 21},
      {0, 13, 46},
      {0, 7, 12},
      {0, 35, 20},
      {0, 61, 59},
      {0, 22, 29},
      {0, 38, 62},
      {0, 56, 45},
      {0, 6, 48},
      {0, 33, 30},
      {0, 14, 58},
      {0, 34, 28},
      {0, 51, 40},
      {0, 63, 55},
      {0, 25, 16},
      {0, 17, 11},
      {0, 53, 52},
      {0, 65, 27},
      {0, 39, 41},
      {0, 67, 66},
      {0, 69, 68},
      {0, 10, 4},
      {0, 37, 18},
      {0, 60, 47},
      {0, 1, 32},
      {0, 71, 70},
      {0, 73, 72},
      {0, 57, 26},
      {0, 74, 31},
      {0, 76, 75},
      {0, 77, 44},
      {0, 78, 15},
      {0, 79, 54},
      {0, 81, 80},
      {0, 82, 49},
      {0, 84, 83},
      {0, 86, 85},
      {0, 88, 87},
      {0, 89, 19},
      {0, 91, 90},
      {0, 93, 92},
      {0, 95, 94},
      {0, 2, 96},
      {0, 98, 97},
      {0, 100, 99},
      {0, 102, 101},
      {0, 104, 103},
      {0, 106, 105},
      {0, 3, 107},
      {0, 109, 108},
      {0, 111, 110},
      {0, 113, 112},
      {0, 114, 50},
      {0, 116, 115},
      {0, 118, 117},
      {0, 120, 119},
      {0, 122, 121},
      {0, 124, 123},
      {0, 64, 42},
      {0, 126, 125},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpExtInst, 5), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(93, {
      {0, 0, 0},
      {99347751, 0, 0},
      {102542696, 0, 0},
      {107497541, 0, 0},
      {112452386, 0, 0},
      {139011596, 0, 0},
      {296981500, 0, 0},
      {429277936, 0, 0},
      {451957774, 0, 0},
      {508217552, 0, 0},
      {573901046, 0, 0},
      {774727851, 0, 0},
      {801484894, 0, 0},
      {920604853, 0, 0},
      {925559698, 0, 0},
      {1022915255, 0, 0},
      {1209418480, 0, 0},
      {1287937401, 0, 0},
      {1319785741, 0, 0},
      {1392080469, 0, 0},
      {1538342947, 0, 0},
      {1541020250, 0, 0},
      {1587209598, 0, 0},
      {1594733696, 0, 0},
      {1631434666, 0, 0},
      {1636389511, 0, 0},
      {1684282922, 0, 0},
      {1859128680, 0, 0},
      {1901166356, 0, 0},
      {2004567202, 0, 0},
      {2119793999, 0, 0},
      {2280400314, 0, 0},
      {2538917932, 0, 0},
      {2677264274, 0, 0},
      {2683080096, 0, 0},
      {2854085372, 0, 0},
      {2879917501, 0, 0},
      {3059119137, 0, 0},
      {3174324790, 0, 0},
      {3194725903, 0, 0},
      {3358097187, 0, 0},
      {3547456240, 0, 0},
      {3614752756, 0, 0},
      {3753486980, 0, 0},
      {3811268385, 0, 0},
      {3953733490, 0, 0},
      {3990925720, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 23, 22},
      {0, 36, 31},
      {0, 17, 40},
      {0, 27, 19},
      {0, 35, 33},
      {0, 30, 38},
      {0, 42, 39},
      {0, 46, 32},
      {0, 13, 12},
      {0, 44, 14},
      {0, 29, 11},
      {0, 10, 18},
      {0, 15, 37},
      {0, 1, 4},
      {0, 45, 2},
      {0, 21, 28},
      {0, 8, 5},
      {0, 49, 48},
      {0, 51, 50},
      {0, 53, 52},
      {0, 54, 16},
      {0, 55, 25},
      {0, 56, 3},
      {0, 58, 57},
      {0, 59, 26},
      {0, 20, 7},
      {0, 61, 60},
      {0, 62, 24},
      {0, 41, 63},
      {0, 65, 64},
      {0, 9, 34},
      {0, 67, 66},
      {0, 69, 68},
      {0, 71, 70},
      {0, 73, 72},
      {0, 75, 74},
      {0, 76, 43},
      {0, 78, 77},
      {0, 80, 79},
      {0, 82, 81},
      {0, 84, 83},
      {0, 86, 85},
      {0, 88, 87},
      {0, 90, 89},
      {0, 47, 91},
      {0, 92, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpExtInst, 6), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(15, {
      {0, 0, 0},
      {166253838, 0, 0},
      {679771963, 0, 0},
      {1247793383, 0, 0},
      {2261697609, 0, 0},
      {2263349224, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 8},
      {0, 9, 1},
      {0, 3, 5},
      {0, 11, 10},
      {0, 2, 12},
      {0, 7, 6},
      {0, 14, 13},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeVector, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {789872778, 0, 0},
      {1415510495, 0, 0},
      {1951208733, 0, 0},
      {2430404313, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 5},
      {0, 4, 6},
      {0, 7, 1},
      {0, 3, 8},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeVector, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(15, {
      {0, 0, 0},
      {1389644742, 0, 0},
      {3232633974, 0, 0},
      {3278176820, 0, 0},
      {3648138580, 0, 0},
      {3687777340, 0, 0},
      {3694383800, 0, 0},
      {3697687030, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 4},
      {0, 9, 6},
      {0, 10, 8},
      {0, 2, 11},
      {0, 12, 3},
      {0, 1, 13},
      {0, 14, 7},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeArray, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {1951208733, 0, 0},
      {2160380860, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 4},
      {0, 2, 5},
      {0, 3, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeArray, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(13, {
      {0, 0, 0},
      {144116905, 0, 0},
      {827246872, 0, 0},
      {1545298048, 0, 0},
      {2715370488, 0, 0},
      {2798552666, 0, 0},
      {3812456892, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 3},
      {0, 8, 6},
      {0, 9, 7},
      {0, 1, 10},
      {0, 11, 4},
      {0, 5, 12},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeArray, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(67, {
      {0, 0, 0},
      {40653745, 0, 0},
      {119981689, 0, 0},
      {153085016, 0, 0},
      {451382997, 0, 0},
      {545678922, 0, 0},
      {899570100, 0, 0},
      {929101967, 0, 0},
      {1070791291, 0, 0},
      {1100599986, 0, 0},
      {1103903216, 0, 0},
      {1154919607, 0, 0},
      {1199157863, 0, 0},
      {1258105452, 0, 0},
      {1369578001, 0, 0},
      {1372881231, 0, 0},
      {1674803691, 0, 0},
      {1677700667, 0, 0},
      {1989520052, 0, 0},
      {2593884753, 0, 0},
      {2664825925, 0, 0},
      {2924146124, 0, 0},
      {2926633629, 0, 0},
      {3249265647, 0, 0},
      {3345288309, 0, 0},
      {3410158390, 0, 0},
      {3489360962, 0, 0},
      {3495967422, 0, 0},
      {3504981554, 0, 0},
      {3705139860, 0, 0},
      {3822983876, 0, 0},
      {4141567741, 0, 0},
      {4234287173, 0, 0},
      {4240893633, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 15, 23},
      {0, 20, 17},
      {0, 32, 22},
      {0, 19, 12},
      {0, 13, 3},
      {0, 30, 27},
      {0, 4, 35},
      {0, 24, 36},
      {0, 31, 37},
      {0, 33, 38},
      {0, 39, 7},
      {0, 6, 40},
      {0, 41, 29},
      {0, 14, 42},
      {0, 43, 28},
      {0, 10, 44},
      {0, 45, 18},
      {0, 26, 46},
      {0, 5, 47},
      {0, 48, 2},
      {0, 49, 9},
      {0, 50, 16},
      {0, 34, 25},
      {0, 52, 51},
      {0, 54, 53},
      {0, 56, 55},
      {0, 58, 57},
      {0, 60, 59},
      {0, 8, 21},
      {0, 1, 11},
      {0, 62, 61},
      {0, 64, 63},
      {0, 66, 65},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(11, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2160380860, 0, 0},
      {3278176820, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 6},
      {0, 2, 7},
      {0, 3, 8},
      {0, 9, 1},
      {0, 5, 10},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(13, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2160380860, 0, 0},
      {2320303498, 0, 0},
      {3232633974, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 7},
      {0, 2, 8},
      {0, 4, 9},
      {0, 10, 3},
      {0, 1, 6},
      {0, 12, 11},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(11, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2160380860, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 6},
      {0, 1, 7},
      {0, 3, 4},
      {0, 8, 2},
      {0, 10, 9},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(11, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2160380860, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 6},
      {0, 3, 7},
      {0, 5, 4},
      {0, 8, 1},
      {0, 10, 9},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 4), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2263349224, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 5},
      {0, 1, 6},
      {0, 2, 7},
      {0, 8, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 5), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 5},
      {0, 1, 6},
      {0, 2, 7},
      {0, 8, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 6), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 5},
      {0, 4, 6},
      {0, 7, 1},
      {0, 2, 8},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 7), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 5},
      {0, 1, 6},
      {0, 7, 4},
      {0, 2, 8},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 8), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 4},
      {0, 3, 5},
      {0, 1, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 9), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 3},
      {0, 1, 6},
      {0, 4, 7},
      {0, 8, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 10), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 5},
      {0, 1, 6},
      {0, 7, 4},
      {0, 8, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 11), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 3},
      {0, 4, 1},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 12), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 4},
      {0, 1, 5},
      {0, 2, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 13), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 5},
      {0, 3, 6},
      {0, 7, 1},
      {0, 8, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 14), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 4},
      {0, 5, 3},
      {0, 6, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 15), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 4},
      {0, 2, 5},
      {0, 1, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 16), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 5},
      {0, 4, 6},
      {0, 7, 1},
      {0, 8, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 17), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 4},
      {0, 1, 5},
      {0, 2, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 18), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 4},
      {0, 3, 5},
      {0, 2, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 19), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 4},
      {0, 1, 5},
      {0, 2, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 20), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 4},
      {0, 2, 5},
      {0, 3, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 21), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 1},
      {0, 2, 6},
      {0, 3, 7},
      {0, 8, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 22), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 5},
      {0, 2, 6},
      {0, 4, 7},
      {0, 8, 3},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 23), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(11, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2160380860, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 6, 4},
      {0, 1, 7},
      {0, 2, 8},
      {0, 3, 9},
      {0, 10, 5},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 24), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 5},
      {0, 2, 6},
      {0, 4, 7},
      {0, 8, 3},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 25), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 4},
      {0, 2, 5},
      {0, 3, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 26), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 4},
      {0, 2, 5},
      {0, 3, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 27), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 3},
      {0, 1, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 28), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 3},
      {0, 2, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 29), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 3},
      {0, 2, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 30), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 3},
      {0, 1, 5},
      {0, 2, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 31), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 4},
      {0, 1, 5},
      {0, 2, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 32), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 3},
      {0, 1, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 33), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 3},
      {0, 2, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 34), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 3},
      {0, 1, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 35), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 3},
      {0, 1, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 36), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 37), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {1389644742, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 38), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {3697687030, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 39), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 40), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 41), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 42), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 43), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 44), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 45), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 46), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 47), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 48), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 49), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 50), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeStruct, 51), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(101, {
      {0, 0, 0},
      {85880059, 0, 0},
      {135486769, 0, 0},
      {304448521, 0, 0},
      {436416061, 0, 0},
      {440421571, 0, 0},
      {450406196, 0, 0},
      {503094540, 0, 0},
      {543621065, 0, 0},
      {626892406, 0, 0},
      {628544021, 0, 0},
      {827698488, 0, 0},
      {869050696, 0, 0},
      {907126242, 0, 0},
      {908777857, 0, 0},
      {910429472, 0, 0},
      {1113409935, 0, 0},
      {1294403159, 0, 0},
      {1296054774, 0, 0},
      {1297706389, 0, 0},
      {1322549027, 0, 0},
      {1784441183, 0, 0},
      {2080953106, 0, 0},
      {2194691858, 0, 0},
      {2448331885, 0, 0},
      {2466255445, 0, 0},
      {2468230023, 0, 0},
      {2547657777, 0, 0},
      {2549309392, 0, 0},
      {2550961007, 0, 0},
      {2894051250, 0, 0},
      {2929019254, 0, 0},
      {2934934694, 0, 0},
      {2936586309, 0, 0},
      {2938237924, 0, 0},
      {3077271274, 0, 0},
      {3092528578, 0, 0},
      {3094180193, 0, 0},
      {3094857332, 0, 0},
      {3095831808, 0, 0},
      {3183924418, 0, 0},
      {3207966516, 0, 0},
      {3282979782, 0, 0},
      {3433956341, 0, 0},
      {3561562003, 0, 0},
      {3563213618, 0, 0},
      {3564865233, 0, 0},
      {3585511591, 0, 0},
      {4028622909, 0, 0},
      {4039938779, 0, 0},
      {4050155669, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 16, 25},
      {0, 50, 1},
      {0, 42, 35},
      {0, 31, 41},
      {0, 4, 43},
      {0, 9, 10},
      {0, 3, 30},
      {0, 52, 47},
      {0, 12, 53},
      {0, 55, 54},
      {0, 36, 56},
      {0, 49, 57},
      {0, 6, 58},
      {0, 34, 33},
      {0, 59, 26},
      {0, 21, 32},
      {0, 60, 15},
      {0, 24, 61},
      {0, 62, 38},
      {0, 22, 2},
      {0, 37, 7},
      {0, 63, 46},
      {0, 14, 13},
      {0, 64, 5},
      {0, 65, 45},
      {0, 66, 19},
      {0, 18, 67},
      {0, 17, 20},
      {0, 68, 11},
      {0, 8, 69},
      {0, 70, 39},
      {0, 72, 71},
      {0, 74, 73},
      {0, 40, 75},
      {0, 76, 23},
      {0, 78, 77},
      {0, 29, 79},
      {0, 28, 80},
      {0, 27, 48},
      {0, 82, 81},
      {0, 51, 83},
      {0, 84, 44},
      {0, 86, 85},
      {0, 88, 87},
      {0, 90, 89},
      {0, 92, 91},
      {0, 94, 93},
      {0, 96, 95},
      {0, 98, 97},
      {0, 100, 99},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypePointer, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(65, {
      {0, 0, 0},
      {119981689, 0, 0},
      {162255877, 0, 0},
      {451382997, 0, 0},
      {545678922, 0, 0},
      {679771963, 0, 0},
      {789872778, 0, 0},
      {1100599986, 0, 0},
      {1103903216, 0, 0},
      {1154919607, 0, 0},
      {1343794461, 0, 0},
      {1415510495, 0, 0},
      {1674803691, 0, 0},
      {1951208733, 0, 0},
      {1989520052, 0, 0},
      {2160380860, 0, 0},
      {2263349224, 0, 0},
      {2320303498, 0, 0},
      {2924146124, 0, 0},
      {2984325996, 0, 0},
      {3334207724, 0, 0},
      {3345288309, 0, 0},
      {3410158390, 0, 0},
      {3489360962, 0, 0},
      {3495967422, 0, 0},
      {3504981554, 0, 0},
      {3800912395, 0, 0},
      {3802564010, 0, 0},
      {3866587616, 0, 0},
      {3868239231, 0, 0},
      {3869890846, 0, 0},
      {3998230222, 0, 0},
      {4240893633, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 3},
      {0, 6, 24},
      {0, 11, 7},
      {0, 32, 21},
      {0, 27, 34},
      {0, 35, 25},
      {0, 36, 8},
      {0, 26, 31},
      {0, 14, 15},
      {0, 28, 37},
      {0, 1, 23},
      {0, 39, 38},
      {0, 12, 40},
      {0, 22, 41},
      {0, 10, 16},
      {0, 43, 42},
      {0, 29, 44},
      {0, 2, 45},
      {0, 46, 19},
      {0, 48, 47},
      {0, 18, 49},
      {0, 50, 30},
      {0, 9, 33},
      {0, 52, 51},
      {0, 54, 53},
      {0, 13, 55},
      {0, 17, 56},
      {0, 5, 57},
      {0, 59, 58},
      {0, 60, 20},
      {0, 62, 61},
      {0, 64, 63},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypePointer, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(99, {
      {0, 0, 0},
      {75986790, 0, 0},
      {95470391, 0, 0},
      {170378107, 0, 0},
      {172029722, 0, 0},
      {204234270, 0, 0},
      {205885885, 0, 0},
      {244668133, 0, 0},
      {265778447, 0, 0},
      {616435646, 0, 0},
      {618087261, 0, 0},
      {753954113, 0, 0},
      {1000070091, 0, 0},
      {1308462133, 0, 0},
      {1671139745, 0, 0},
      {1774874546, 0, 0},
      {1776526161, 0, 0},
      {1887808856, 0, 0},
      {1889460471, 0, 0},
      {1917966999, 0, 0},
      {2044728014, 0, 0},
      {2192810893, 0, 0},
      {2293247016, 0, 0},
      {2503194620, 0, 0},
      {2605012269, 0, 0},
      {2608484640, 0, 0},
      {2615111110, 0, 0},
      {2668769415, 0, 0},
      {2759951687, 0, 0},
      {2761603302, 0, 0},
      {2856623532, 0, 0},
      {2945369269, 0, 0},
      {2956189845, 0, 0},
      {3085119011, 0, 0},
      {3367313400, 0, 0},
      {3447882276, 0, 0},
      {3633746133, 0, 0},
      {3635397748, 0, 0},
      {3710645347, 0, 0},
      {3712296962, 0, 0},
      {3715846592, 0, 0},
      {3727494858, 0, 0},
      {3747079365, 0, 0},
      {3748965853, 0, 0},
      {3750617468, 0, 0},
      {4018820793, 0, 0},
      {4022124023, 0, 0},
      {4024173916, 0, 0},
      {4215670524, 0, 0},
      {4217322139, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 10, 9},
      {0, 31, 24},
      {0, 40, 13},
      {0, 45, 33},
      {0, 34, 46},
      {0, 43, 38},
      {0, 44, 15},
      {0, 11, 30},
      {0, 21, 6},
      {0, 47, 3},
      {0, 51, 16},
      {0, 14, 52},
      {0, 8, 53},
      {0, 35, 5},
      {0, 55, 54},
      {0, 56, 26},
      {0, 20, 57},
      {0, 39, 19},
      {0, 59, 58},
      {0, 61, 60},
      {0, 4, 62},
      {0, 2, 63},
      {0, 25, 7},
      {0, 64, 27},
      {0, 12, 22},
      {0, 65, 48},
      {0, 41, 42},
      {0, 17, 23},
      {0, 49, 66},
      {0, 68, 67},
      {0, 70, 69},
      {0, 72, 71},
      {0, 74, 73},
      {0, 18, 75},
      {0, 37, 32},
      {0, 76, 36},
      {0, 78, 77},
      {0, 79, 28},
      {0, 81, 80},
      {0, 82, 29},
      {0, 84, 83},
      {0, 86, 85},
      {0, 88, 87},
      {0, 90, 89},
      {0, 91, 50},
      {0, 93, 92},
      {0, 95, 94},
      {0, 1, 96},
      {0, 98, 97},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(27, {
      {0, 0, 0},
      {545678922, 0, 0},
      {679771963, 0, 0},
      {899570100, 0, 0},
      {929101967, 0, 0},
      {1100599986, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3056042030, 0, 0},
      {3334207724, 0, 0},
      {3357250579, 0, 0},
      {3705139860, 0, 0},
      {3800912395, 0, 0},
      {3802564010, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 3},
      {0, 10, 13},
      {0, 4, 15},
      {0, 16, 11},
      {0, 17, 1},
      {0, 14, 12},
      {0, 19, 18},
      {0, 21, 20},
      {0, 7, 6},
      {0, 9, 22},
      {0, 24, 23},
      {0, 25, 2},
      {0, 26, 8},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(57, {
      {0, 0, 0},
      {283209196, 0, 0},
      {436416061, 0, 0},
      {679771963, 0, 0},
      {789872778, 0, 0},
      {815757910, 0, 0},
      {827698488, 0, 0},
      {1164221089, 0, 0},
      {1294403159, 0, 0},
      {1296054774, 0, 0},
      {1297706389, 0, 0},
      {1525861001, 0, 0},
      {1579585816, 0, 0},
      {1675764636, 0, 0},
      {1824016656, 0, 0},
      {1951208733, 0, 0},
      {1991787192, 0, 0},
      {2180701723, 0, 0},
      {2194691858, 0, 0},
      {2320303498, 0, 0},
      {2881886868, 0, 0},
      {2926633629, 0, 0},
      {3249265647, 0, 0},
      {3334207724, 0, 0},
      {3472123498, 0, 0},
      {3674863070, 0, 0},
      {4050155669, 0, 0},
      {4141567741, 0, 0},
      {4155122613, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 24, 7},
      {0, 17, 1},
      {0, 4, 15},
      {0, 11, 16},
      {0, 28, 30},
      {0, 25, 20},
      {0, 14, 31},
      {0, 32, 26},
      {0, 12, 5},
      {0, 2, 22},
      {0, 33, 13},
      {0, 35, 34},
      {0, 37, 36},
      {0, 39, 38},
      {0, 40, 21},
      {0, 29, 18},
      {0, 27, 41},
      {0, 43, 42},
      {0, 19, 44},
      {0, 45, 23},
      {0, 6, 3},
      {0, 47, 46},
      {0, 49, 48},
      {0, 51, 50},
      {0, 10, 8},
      {0, 53, 52},
      {0, 9, 54},
      {0, 56, 55},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(17, {
      {0, 0, 0},
      {679771963, 0, 0},
      {827698488, 0, 0},
      {1294403159, 0, 0},
      {1296054774, 0, 0},
      {1297706389, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 8, 9},
      {0, 10, 6},
      {0, 1, 5},
      {0, 11, 3},
      {0, 12, 7},
      {0, 13, 2},
      {0, 15, 14},
      {0, 16, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(17, {
      {0, 0, 0},
      {679771963, 0, 0},
      {827698488, 0, 0},
      {1294403159, 0, 0},
      {1296054774, 0, 0},
      {1951208733, 0, 0},
      {2194691858, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 8, 5},
      {0, 10, 9},
      {0, 11, 6},
      {0, 7, 12},
      {0, 1, 3},
      {0, 2, 13},
      {0, 15, 14},
      {0, 4, 16},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 4), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(11, {
      {0, 0, 0},
      {827698488, 0, 0},
      {1294403159, 0, 0},
      {1296054774, 0, 0},
      {1297706389, 0, 0},
      {1951208733, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 6},
      {0, 5, 7},
      {0, 2, 8},
      {0, 1, 9},
      {0, 10, 3},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 5), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(11, {
      {0, 0, 0},
      {827698488, 0, 0},
      {1294403159, 0, 0},
      {1296054774, 0, 0},
      {1951208733, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 6},
      {0, 4, 7},
      {0, 8, 5},
      {0, 3, 9},
      {0, 1, 10},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 6), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {789872778, 0, 0},
      {827698488, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 1},
      {0, 4, 6},
      {0, 3, 7},
      {0, 2, 8},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 7), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {543621065, 0, 0},
      {827698488, 0, 0},
      {1951208733, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 4},
      {0, 1, 5},
      {0, 2, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 8), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {827698488, 0, 0},
      {1951208733, 0, 0},
      {3095831808, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 4},
      {0, 3, 5},
      {0, 1, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 9), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {1296054774, 0, 0},
      {1951208733, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 2},
      {0, 1, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 10), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {1296054774, 0, 0},
      {2320303498, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 2},
      {0, 1, 4},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 11), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {789872778, 0, 0},
      {1951208733, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 2},
      {0, 4, 1},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 12), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {789872778, 0, 0},
      {1951208733, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 1},
      {0, 4, 3},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 13), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {1951208733, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 1},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 14), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {1951208733, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 1},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpTypeFunction, 15), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {789872778, 0, 0},
      {1951208733, 0, 0},
      {2430404313, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 4},
      {0, 1, 5},
      {0, 2, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpConstant, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(183, {
      {0, 0, 0},
      {51041423, 0, 0},
      {52882140, 0, 0},
      {72782198, 0, 0},
      {142465290, 0, 0},
      {144116905, 0, 0},
      {158160339, 0, 0},
      {169135842, 0, 0},
      {210116709, 0, 0},
      {290391815, 0, 0},
      {296981500, 0, 0},
      {385229009, 0, 0},
      {438318340, 0, 0},
      {529742207, 0, 0},
      {628331516, 0, 0},
      {677668732, 0, 0},
      {778500192, 0, 0},
      {825595257, 0, 0},
      {910398460, 0, 0},
      {917019124, 0, 0},
      {959681532, 0, 0},
      {1031290113, 0, 0},
      {1039111164, 0, 0},
      {1064945649, 0, 0},
      {1087394637, 0, 0},
      {1092948665, 0, 0},
      {1156369516, 0, 0},
      {1158021131, 0, 0},
      {1172110445, 0, 0},
      {1304296041, 0, 0},
      {1400019344, 0, 0},
      {1450415100, 0, 0},
      {1452222566, 0, 0},
      {1543646433, 0, 0},
      {1543672828, 0, 0},
      {1612361408, 0, 0},
      {1622381564, 0, 0},
      {1691572958, 0, 0},
      {1755648697, 0, 0},
      {1782996825, 0, 0},
      {1784648440, 0, 0},
      {1930923350, 0, 0},
      {1939359710, 0, 0},
      {1971252067, 0, 0},
      {1979847999, 0, 0},
      {2078849875, 0, 0},
      {2113115132, 0, 0},
      {2135340676, 0, 0},
      {2170273742, 0, 0},
      {2268204687, 0, 0},
      {2285081596, 0, 0},
      {2318200267, 0, 0},
      {2321729979, 0, 0},
      {2326636627, 0, 0},
      {2444465148, 0, 0},
      {2466126792, 0, 0},
      {2490492987, 0, 0},
      {2524697596, 0, 0},
      {2557550659, 0, 0},
      {2678954464, 0, 0},
      {2705477184, 0, 0},
      {2715370488, 0, 0},
      {2732195517, 0, 0},
      {2775815164, 0, 0},
      {2796901051, 0, 0},
      {2798552666, 0, 0},
      {2855506940, 0, 0},
      {2860348412, 0, 0},
      {2922615804, 0, 0},
      {2937761472, 0, 0},
      {2944827576, 0, 0},
      {3092754101, 0, 0},
      {3107165180, 0, 0},
      {3168953855, 0, 0},
      {3184177968, 0, 0},
      {3202349435, 0, 0},
      {3266548732, 0, 0},
      {3332104493, 0, 0},
      {3362723943, 0, 0},
      {3571454885, 0, 0},
      {3712763835, 0, 0},
      {3743748793, 0, 0},
      {3810805277, 0, 0},
      {3912967080, 0, 0},
      {3929248764, 0, 0},
      {3958731802, 0, 0},
      {3997952447, 0, 0},
      {4016096296, 0, 0},
      {4106658327, 0, 0},
      {4172568578, 0, 0},
      {4198082194, 0, 0},
      {4248015868, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 35, 16},
      {0, 49, 42},
      {0, 86, 69},
      {0, 53, 30},
      {0, 45, 89},
      {0, 50, 68},
      {0, 73, 71},
      {0, 17, 46},
      {0, 14, 81},
      {0, 63, 44},
      {0, 12, 3},
      {0, 72, 31},
      {0, 55, 67},
      {0, 36, 19},
      {0, 22, 88},
      {0, 9, 70},
      {0, 93, 23},
      {0, 95, 94},
      {0, 47, 91},
      {0, 34, 32},
      {0, 97, 96},
      {0, 41, 61},
      {0, 99, 98},
      {0, 37, 1},
      {0, 77, 100},
      {0, 51, 60},
      {0, 101, 79},
      {0, 6, 2},
      {0, 11, 7},
      {0, 24, 21},
      {0, 43, 28},
      {0, 59, 56},
      {0, 75, 62},
      {0, 80, 78},
      {0, 87, 83},
      {0, 18, 15},
      {0, 102, 38},
      {0, 104, 103},
      {0, 85, 90},
      {0, 76, 25},
      {0, 29, 105},
      {0, 107, 106},
      {0, 58, 52},
      {0, 109, 108},
      {0, 57, 110},
      {0, 112, 111},
      {0, 114, 113},
      {0, 115, 33},
      {0, 74, 116},
      {0, 118, 117},
      {0, 120, 119},
      {0, 122, 121},
      {0, 124, 123},
      {0, 126, 125},
      {0, 128, 127},
      {0, 130, 129},
      {0, 131, 13},
      {0, 54, 27},
      {0, 133, 132},
      {0, 48, 40},
      {0, 5, 8},
      {0, 82, 134},
      {0, 26, 135},
      {0, 39, 4},
      {0, 136, 64},
      {0, 138, 137},
      {0, 140, 139},
      {0, 84, 141},
      {0, 143, 142},
      {0, 145, 144},
      {0, 147, 146},
      {0, 149, 148},
      {0, 20, 150},
      {0, 65, 151},
      {0, 66, 152},
      {0, 153, 10},
      {0, 155, 154},
      {0, 157, 156},
      {0, 159, 158},
      {0, 161, 160},
      {0, 163, 162},
      {0, 165, 164},
      {0, 167, 166},
      {0, 169, 168},
      {0, 170, 92},
      {0, 172, 171},
      {0, 174, 173},
      {0, 176, 175},
      {0, 178, 177},
      {0, 180, 179},
      {0, 182, 181},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpConstant, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1247793383, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 5},
      {0, 4, 6},
      {0, 1, 3},
      {0, 8, 7},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpConstantComposite, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(83, {
      {0, 0, 0},
      {15502752, 0, 0},
      {46736908, 0, 0},
      {139011596, 0, 0},
      {149720480, 0, 0},
      {249378857, 0, 0},
      {251209228, 0, 0},
      {503145996, 0, 0},
      {836581417, 0, 0},
      {882718761, 0, 0},
      {1289566249, 0, 0},
      {1325348861, 0, 0},
      {1558001705, 0, 0},
      {1646147798, 0, 0},
      {1679946323, 0, 0},
      {1766401548, 0, 0},
      {1992893964, 0, 0},
      {2123388694, 0, 0},
      {2162986400, 0, 0},
      {2580096524, 0, 0},
      {2598189097, 0, 0},
      {2683080096, 0, 0},
      {2698156268, 0, 0},
      {2763960513, 0, 0},
      {3015046341, 0, 0},
      {3133016299, 0, 0},
      {3251128023, 0, 0},
      {3504158761, 0, 0},
      {3535289452, 0, 0},
      {3536941067, 0, 0},
      {3538592682, 0, 0},
      {3540244297, 0, 0},
      {3541895912, 0, 0},
      {3570219049, 0, 0},
      {3653838348, 0, 0},
      {3764205609, 0, 0},
      {3882634684, 0, 0},
      {3913885196, 0, 0},
      {3982047273, 0, 0},
      {4024252457, 0, 0},
      {4243119782, 0, 0},
      {4255182614, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 8, 4},
      {0, 39, 2},
      {0, 38, 10},
      {0, 29, 41},
      {0, 23, 28},
      {0, 9, 24},
      {0, 44, 43},
      {0, 45, 6},
      {0, 20, 12},
      {0, 18, 33},
      {0, 19, 16},
      {0, 7, 46},
      {0, 48, 47},
      {0, 5, 49},
      {0, 13, 11},
      {0, 17, 14},
      {0, 25, 22},
      {0, 40, 36},
      {0, 1, 50},
      {0, 31, 30},
      {0, 51, 32},
      {0, 42, 52},
      {0, 54, 53},
      {0, 55, 15},
      {0, 37, 56},
      {0, 57, 34},
      {0, 59, 58},
      {0, 61, 60},
      {0, 35, 21},
      {0, 62, 26},
      {0, 64, 63},
      {0, 65, 27},
      {0, 3, 66},
      {0, 68, 67},
      {0, 70, 69},
      {0, 72, 71},
      {0, 74, 73},
      {0, 76, 75},
      {0, 78, 77},
      {0, 80, 79},
      {0, 82, 81},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpConstantComposite, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(65, {
      {0, 0, 0},
      {142465290, 0, 0},
      {158160339, 0, 0},
      {169135842, 0, 0},
      {210116709, 0, 0},
      {296981500, 0, 0},
      {615748604, 0, 0},
      {910398460, 0, 0},
      {959681532, 0, 0},
      {1039111164, 0, 0},
      {1087394637, 0, 0},
      {1156369516, 0, 0},
      {1450415100, 0, 0},
      {1543672828, 0, 0},
      {2100532220, 0, 0},
      {2170273742, 0, 0},
      {2285081596, 0, 0},
      {2326636627, 0, 0},
      {2444465148, 0, 0},
      {2732195517, 0, 0},
      {2763232252, 0, 0},
      {2796901051, 0, 0},
      {2855506940, 0, 0},
      {2922615804, 0, 0},
      {2937761472, 0, 0},
      {3202349435, 0, 0},
      {3362723943, 0, 0},
      {3712763835, 0, 0},
      {3810805277, 0, 0},
      {3929248764, 0, 0},
      {4016096296, 0, 0},
      {4172568578, 0, 0},
      {4248015868, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 12, 23},
      {0, 13, 6},
      {0, 20, 14},
      {0, 15, 24},
      {0, 17, 28},
      {0, 16, 31},
      {0, 7, 34},
      {0, 9, 32},
      {0, 36, 35},
      {0, 38, 37},
      {0, 40, 39},
      {0, 2, 8},
      {0, 10, 3},
      {0, 25, 19},
      {0, 27, 26},
      {0, 33, 30},
      {0, 11, 41},
      {0, 1, 21},
      {0, 18, 42},
      {0, 44, 43},
      {0, 46, 45},
      {0, 48, 47},
      {0, 29, 49},
      {0, 4, 50},
      {0, 52, 51},
      {0, 54, 53},
      {0, 56, 55},
      {0, 58, 57},
      {0, 59, 5},
      {0, 61, 60},
      {0, 62, 22},
      {0, 64, 63},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpConstantComposite, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(57, {
      {0, 0, 0},
      {52882140, 0, 0},
      {210116709, 0, 0},
      {296981500, 0, 0},
      {385229009, 0, 0},
      {615748604, 0, 0},
      {910398460, 0, 0},
      {959681532, 0, 0},
      {1031290113, 0, 0},
      {1039111164, 0, 0},
      {1172110445, 0, 0},
      {1450415100, 0, 0},
      {1543672828, 0, 0},
      {1622381564, 0, 0},
      {1782996825, 0, 0},
      {1971252067, 0, 0},
      {2100532220, 0, 0},
      {2268204687, 0, 0},
      {2326636627, 0, 0},
      {2444465148, 0, 0},
      {2490492987, 0, 0},
      {2678954464, 0, 0},
      {2763232252, 0, 0},
      {2855506940, 0, 0},
      {2922615804, 0, 0},
      {3912967080, 0, 0},
      {3929248764, 0, 0},
      {4172568578, 0, 0},
      {4248015868, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 11, 24},
      {0, 12, 5},
      {0, 22, 16},
      {0, 18, 17},
      {0, 30, 27},
      {0, 6, 13},
      {0, 9, 28},
      {0, 32, 31},
      {0, 34, 33},
      {0, 7, 35},
      {0, 4, 1},
      {0, 10, 8},
      {0, 20, 15},
      {0, 25, 21},
      {0, 36, 29},
      {0, 19, 37},
      {0, 39, 38},
      {0, 41, 40},
      {0, 43, 42},
      {0, 26, 44},
      {0, 45, 2},
      {0, 47, 46},
      {0, 49, 48},
      {0, 50, 14},
      {0, 51, 3},
      {0, 53, 52},
      {0, 54, 23},
      {0, 56, 55},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpConstantComposite, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(39, {
      {0, 0, 0},
      {210116709, 0, 0},
      {296981500, 0, 0},
      {615748604, 0, 0},
      {910398460, 0, 0},
      {959681532, 0, 0},
      {1039111164, 0, 0},
      {1092948665, 0, 0},
      {1450415100, 0, 0},
      {1543672828, 0, 0},
      {1612361408, 0, 0},
      {2100532220, 0, 0},
      {2326636627, 0, 0},
      {2444465148, 0, 0},
      {2524697596, 0, 0},
      {2763232252, 0, 0},
      {2855506940, 0, 0},
      {3929248764, 0, 0},
      {4172568578, 0, 0},
      {4248015868, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 8, 7},
      {0, 9, 3},
      {0, 15, 11},
      {0, 10, 21},
      {0, 18, 12},
      {0, 4, 20},
      {0, 22, 19},
      {0, 23, 6},
      {0, 14, 24},
      {0, 5, 25},
      {0, 27, 26},
      {0, 28, 17},
      {0, 30, 29},
      {0, 31, 13},
      {0, 1, 32},
      {0, 34, 33},
      {0, 16, 35},
      {0, 2, 36},
      {0, 38, 37},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpConstantComposite, 4), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(35, {
      {0, 0, 0},
      {296981500, 0, 0},
      {615748604, 0, 0},
      {673708384, 0, 0},
      {959681532, 0, 0},
      {1039111164, 0, 0},
      {1450415100, 0, 0},
      {1543672828, 0, 0},
      {1939359710, 0, 0},
      {2100532220, 0, 0},
      {2113115132, 0, 0},
      {2326636627, 0, 0},
      {2444465148, 0, 0},
      {2763232252, 0, 0},
      {2855506940, 0, 0},
      {3929248764, 0, 0},
      {4172568578, 0, 0},
      {4248015868, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 18, 3},
      {0, 6, 19},
      {0, 12, 4},
      {0, 17, 2},
      {0, 9, 7},
      {0, 20, 13},
      {0, 11, 8},
      {0, 10, 16},
      {0, 21, 15},
      {0, 5, 22},
      {0, 24, 23},
      {0, 26, 25},
      {0, 28, 27},
      {0, 29, 1},
      {0, 31, 30},
      {0, 33, 32},
      {0, 34, 14},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpConstantComposite, 5), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(23, {
      {0, 0, 0},
      {545678922, 0, 0},
      {679771963, 0, 0},
      {929101967, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3056042030, 0, 0},
      {3334207724, 0, 0},
      {3357250579, 0, 0},
      {3705139860, 0, 0},
      {3800912395, 0, 0},
      {3802564010, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 8, 11},
      {0, 9, 3},
      {0, 1, 13},
      {0, 14, 10},
      {0, 12, 15},
      {0, 17, 16},
      {0, 18, 4},
      {0, 7, 5},
      {0, 20, 19},
      {0, 2, 21},
      {0, 22, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunction, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(89, {
      {0, 0, 0},
      {35240468, 0, 0},
      {123060826, 0, 0},
      {184634770, 0, 0},
      {359054425, 0, 0},
      {459968607, 0, 0},
      {619875033, 0, 0},
      {904486530, 0, 0},
      {945128292, 0, 0},
      {950731750, 0, 0},
      {1058429216, 0, 0},
      {1182296898, 0, 0},
      {1238120570, 0, 0},
      {1429389803, 0, 0},
      {1652168174, 0, 0},
      {1717510093, 0, 0},
      {1766422419, 0, 0},
      {1775308984, 0, 0},
      {1776629361, 0, 0},
      {1824526196, 0, 0},
      {1957265068, 0, 0},
      {1998433745, 0, 0},
      {2055664760, 0, 0},
      {2303184249, 0, 0},
      {2451531615, 0, 0},
      {2507457870, 0, 0},
      {2550501832, 0, 0},
      {2590402790, 0, 0},
      {2649103430, 0, 0},
      {2780190687, 0, 0},
      {2831059514, 0, 0},
      {3167253437, 0, 0},
      {3269075805, 0, 0},
      {3323202731, 0, 0},
      {3361419439, 0, 0},
      {3464197236, 0, 0},
      {3472029049, 0, 0},
      {3518630848, 0, 0},
      {3604842236, 0, 0},
      {3653985133, 0, 0},
      {4091916710, 0, 0},
      {4121643374, 0, 0},
      {4185590212, 0, 0},
      {4233562270, 0, 0},
      {4235213885, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 6, 40},
      {0, 14, 31},
      {0, 7, 9},
      {0, 29, 27},
      {0, 18, 44},
      {0, 8, 5},
      {0, 10, 3},
      {0, 41, 37},
      {0, 42, 35},
      {0, 2, 1},
      {0, 47, 46},
      {0, 48, 4},
      {0, 11, 49},
      {0, 50, 36},
      {0, 19, 51},
      {0, 53, 52},
      {0, 55, 54},
      {0, 15, 12},
      {0, 26, 16},
      {0, 56, 21},
      {0, 25, 33},
      {0, 43, 24},
      {0, 57, 39},
      {0, 59, 58},
      {0, 61, 60},
      {0, 62, 34},
      {0, 64, 63},
      {0, 17, 30},
      {0, 66, 65},
      {0, 20, 67},
      {0, 13, 68},
      {0, 28, 69},
      {0, 70, 32},
      {0, 72, 71},
      {0, 73, 22},
      {0, 75, 74},
      {0, 77, 76},
      {0, 79, 78},
      {0, 80, 23},
      {0, 45, 81},
      {0, 83, 82},
      {0, 85, 84},
      {0, 38, 86},
      {0, 88, 87},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunction, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(87, {
      {0, 0, 0},
      {75986790, 0, 0},
      {95470391, 0, 0},
      {170378107, 0, 0},
      {172029722, 0, 0},
      {204234270, 0, 0},
      {205885885, 0, 0},
      {244668133, 0, 0},
      {265778447, 0, 0},
      {753954113, 0, 0},
      {1000070091, 0, 0},
      {1671139745, 0, 0},
      {1774874546, 0, 0},
      {1776526161, 0, 0},
      {1887808856, 0, 0},
      {1889460471, 0, 0},
      {1917966999, 0, 0},
      {2044728014, 0, 0},
      {2192810893, 0, 0},
      {2293247016, 0, 0},
      {2503194620, 0, 0},
      {2608484640, 0, 0},
      {2615111110, 0, 0},
      {2668769415, 0, 0},
      {2759951687, 0, 0},
      {2761603302, 0, 0},
      {2856623532, 0, 0},
      {2956189845, 0, 0},
      {3085119011, 0, 0},
      {3367313400, 0, 0},
      {3447882276, 0, 0},
      {3633746133, 0, 0},
      {3635397748, 0, 0},
      {3710645347, 0, 0},
      {3712296962, 0, 0},
      {3727494858, 0, 0},
      {3747079365, 0, 0},
      {3748965853, 0, 0},
      {3750617468, 0, 0},
      {4018820793, 0, 0},
      {4022124023, 0, 0},
      {4024173916, 0, 0},
      {4215670524, 0, 0},
      {4217322139, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 39, 28},
      {0, 29, 40},
      {0, 37, 33},
      {0, 38, 12},
      {0, 9, 26},
      {0, 18, 6},
      {0, 41, 3},
      {0, 11, 13},
      {0, 5, 8},
      {0, 45, 30},
      {0, 22, 46},
      {0, 48, 47},
      {0, 16, 17},
      {0, 34, 49},
      {0, 51, 50},
      {0, 53, 52},
      {0, 7, 2},
      {0, 23, 21},
      {0, 54, 10},
      {0, 20, 36},
      {0, 55, 35},
      {0, 56, 4},
      {0, 43, 57},
      {0, 59, 58},
      {0, 60, 42},
      {0, 62, 61},
      {0, 63, 15},
      {0, 64, 31},
      {0, 14, 65},
      {0, 66, 24},
      {0, 67, 32},
      {0, 68, 19},
      {0, 70, 69},
      {0, 71, 27},
      {0, 73, 72},
      {0, 75, 74},
      {0, 77, 76},
      {0, 78, 25},
      {0, 44, 79},
      {0, 81, 80},
      {0, 83, 82},
      {0, 1, 84},
      {0, 86, 85},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunction, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(41, {
      {0, 0, 0},
      {436416061, 0, 0},
      {543621065, 0, 0},
      {679771963, 0, 0},
      {815757910, 0, 0},
      {827698488, 0, 0},
      {1294403159, 0, 0},
      {1296054774, 0, 0},
      {1297706389, 0, 0},
      {1579585816, 0, 0},
      {1675764636, 0, 0},
      {1824016656, 0, 0},
      {1951208733, 0, 0},
      {2194691858, 0, 0},
      {2320303498, 0, 0},
      {2926633629, 0, 0},
      {3095831808, 0, 0},
      {3249265647, 0, 0},
      {3334207724, 0, 0},
      {4050155669, 0, 0},
      {4141567741, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 11},
      {0, 19, 16},
      {0, 9, 4},
      {0, 1, 17},
      {0, 22, 10},
      {0, 24, 23},
      {0, 15, 25},
      {0, 13, 26},
      {0, 27, 20},
      {0, 12, 28},
      {0, 30, 29},
      {0, 31, 18},
      {0, 3, 21},
      {0, 32, 14},
      {0, 34, 33},
      {0, 35, 8},
      {0, 5, 6},
      {0, 37, 36},
      {0, 39, 38},
      {0, 40, 7},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionParameter, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(41, {
      {0, 0, 0},
      {522971108, 0, 0},
      {615341051, 0, 0},
      {718301639, 0, 0},
      {985750227, 0, 0},
      {1395113939, 0, 0},
      {1510333659, 0, 0},
      {1642805350, 0, 0},
      {1846856260, 0, 0},
      {1957218950, 0, 0},
      {1977038330, 0, 0},
      {1978689945, 0, 0},
      {1980341560, 0, 0},
      {2262220987, 0, 0},
      {2674422363, 0, 0},
      {3197739982, 0, 0},
      {3465954368, 0, 0},
      {3941049054, 0, 0},
      {3945795573, 0, 0},
      {4080527786, 0, 0},
      {4154758669, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 17},
      {0, 4, 15},
      {0, 8, 7},
      {0, 2, 20},
      {0, 22, 19},
      {0, 24, 23},
      {0, 14, 25},
      {0, 16, 26},
      {0, 27, 13},
      {0, 6, 28},
      {0, 30, 29},
      {0, 31, 10},
      {0, 11, 21},
      {0, 32, 12},
      {0, 34, 33},
      {0, 35, 5},
      {0, 9, 18},
      {0, 37, 36},
      {0, 39, 38},
      {0, 40, 1},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionParameter, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(27, {
      {0, 0, 0},
      {545678922, 0, 0},
      {679771963, 0, 0},
      {899570100, 0, 0},
      {929101967, 0, 0},
      {1100599986, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3056042030, 0, 0},
      {3334207724, 0, 0},
      {3357250579, 0, 0},
      {3705139860, 0, 0},
      {3800912395, 0, 0},
      {3802564010, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 3},
      {0, 10, 13},
      {0, 4, 15},
      {0, 16, 11},
      {0, 17, 1},
      {0, 14, 12},
      {0, 19, 18},
      {0, 21, 20},
      {0, 22, 8},
      {0, 7, 6},
      {0, 23, 9},
      {0, 25, 24},
      {0, 26, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(115, {
      {0, 0, 0},
      {57149555, 0, 0},
      {86116519, 0, 0},
      {168339452, 0, 0},
      {181902171, 0, 0},
      {284226441, 0, 0},
      {314809953, 0, 0},
      {330249537, 0, 0},
      {527665290, 0, 0},
      {545363837, 0, 0},
      {707478563, 0, 0},
      {740921498, 0, 0},
      {807276090, 0, 0},
      {824323032, 0, 0},
      {835458563, 0, 0},
      {1162127370, 0, 0},
      {1245448751, 0, 0},
      {1277245109, 0, 0},
      {1375043498, 0, 0},
      {1380991098, 0, 0},
      {1603937321, 0, 0},
      {1708264968, 0, 0},
      {1717555224, 0, 0},
      {1765126703, 0, 0},
      {1838993983, 0, 0},
      {1949856502, 0, 0},
      {2108571893, 0, 0},
      {2110223508, 0, 0},
      {2293637521, 0, 0},
      {2377112119, 0, 0},
      {2378763734, 0, 0},
      {2512398201, 0, 0},
      {2516325050, 0, 0},
      {2645135839, 0, 0},
      {2708915136, 0, 0},
      {2894979602, 0, 0},
      {2903897222, 0, 0},
      {2976581453, 0, 0},
      {3054834317, 0, 0},
      {3075866530, 0, 0},
      {3085157904, 0, 0},
      {3242843022, 0, 0},
      {3266028549, 0, 0},
      {3296691317, 0, 0},
      {3299488628, 0, 0},
      {3322500634, 0, 0},
      {3345707173, 0, 0},
      {3536390697, 0, 0},
      {3584683259, 0, 0},
      {3647606635, 0, 0},
      {3760372982, 0, 0},
      {3823959661, 0, 0},
      {3839389658, 0, 0},
      {4124281183, 0, 0},
      {4130950286, 0, 0},
      {4169878842, 0, 0},
      {4174489262, 0, 0},
      {4237497041, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 17, 23},
      {0, 37, 8},
      {0, 45, 39},
      {0, 41, 14},
      {0, 48, 43},
      {0, 40, 31},
      {0, 19, 29},
      {0, 53, 26},
      {0, 10, 5},
      {0, 50, 24},
      {0, 27, 3},
      {0, 59, 32},
      {0, 51, 18},
      {0, 52, 55},
      {0, 60, 57},
      {0, 62, 61},
      {0, 36, 33},
      {0, 64, 63},
      {0, 65, 22},
      {0, 66, 46},
      {0, 6, 67},
      {0, 68, 13},
      {0, 21, 44},
      {0, 1, 69},
      {0, 30, 11},
      {0, 71, 70},
      {0, 12, 72},
      {0, 74, 73},
      {0, 76, 75},
      {0, 16, 2},
      {0, 49, 35},
      {0, 77, 9},
      {0, 42, 28},
      {0, 15, 78},
      {0, 80, 79},
      {0, 82, 81},
      {0, 47, 83},
      {0, 85, 84},
      {0, 87, 86},
      {0, 89, 88},
      {0, 20, 38},
      {0, 54, 90},
      {0, 34, 91},
      {0, 93, 92},
      {0, 25, 94},
      {0, 95, 7},
      {0, 97, 96},
      {0, 56, 98},
      {0, 100, 99},
      {0, 102, 101},
      {0, 104, 103},
      {0, 4, 105},
      {0, 107, 106},
      {0, 58, 108},
      {0, 110, 109},
      {0, 112, 111},
      {0, 114, 113},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(81, {
      {0, 0, 0},
      {35240468, 0, 0},
      {36096192, 0, 0},
      {123060826, 0, 0},
      {184634770, 0, 0},
      {459968607, 0, 0},
      {619875033, 0, 0},
      {950731750, 0, 0},
      {1058429216, 0, 0},
      {1182296898, 0, 0},
      {1238120570, 0, 0},
      {1271484400, 0, 0},
      {1429389803, 0, 0},
      {1717510093, 0, 0},
      {1766422419, 0, 0},
      {1775308984, 0, 0},
      {1817271123, 0, 0},
      {1917336504, 0, 0},
      {1957265068, 0, 0},
      {1998433745, 0, 0},
      {2055664760, 0, 0},
      {2303184249, 0, 0},
      {2308565678, 0, 0},
      {2451531615, 0, 0},
      {2496297824, 0, 0},
      {2507457870, 0, 0},
      {2550501832, 0, 0},
      {2590402790, 0, 0},
      {2649103430, 0, 0},
      {2831059514, 0, 0},
      {2836440943, 0, 0},
      {3269075805, 0, 0},
      {3361419439, 0, 0},
      {3457269042, 0, 0},
      {3464197236, 0, 0},
      {3472029049, 0, 0},
      {3518630848, 0, 0},
      {3587381650, 0, 0},
      {3653985133, 0, 0},
      {4185590212, 0, 0},
      {4233562270, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 40, 37},
      {0, 22, 30},
      {0, 2, 7},
      {0, 24, 11},
      {0, 16, 33},
      {0, 6, 34},
      {0, 42, 27},
      {0, 5, 43},
      {0, 4, 44},
      {0, 36, 8},
      {0, 39, 45},
      {0, 46, 1},
      {0, 3, 47},
      {0, 48, 23},
      {0, 49, 9},
      {0, 50, 35},
      {0, 52, 51},
      {0, 32, 53},
      {0, 13, 10},
      {0, 26, 14},
      {0, 19, 54},
      {0, 55, 25},
      {0, 56, 38},
      {0, 17, 57},
      {0, 59, 58},
      {0, 61, 60},
      {0, 62, 29},
      {0, 12, 15},
      {0, 18, 63},
      {0, 28, 64},
      {0, 65, 31},
      {0, 67, 66},
      {0, 20, 41},
      {0, 69, 68},
      {0, 71, 70},
      {0, 21, 72},
      {0, 74, 73},
      {0, 76, 75},
      {0, 78, 77},
      {0, 80, 79},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(61, {
      {0, 0, 0},
      {37459569, 0, 0},
      {162167595, 0, 0},
      {535067202, 0, 0},
      {701281393, 0, 0},
      {837715723, 0, 0},
      {1320550031, 0, 0},
      {1630583316, 0, 0},
      {1913735398, 0, 0},
      {1918481917, 0, 0},
      {1955871800, 0, 0},
      {1977038330, 0, 0},
      {2053214130, 0, 0},
      {2443959748, 0, 0},
      {2564745684, 0, 0},
      {2622612602, 0, 0},
      {2677252364, 0, 0},
      {2736026107, 0, 0},
      {2790624748, 0, 0},
      {2882994691, 0, 0},
      {2888125966, 0, 0},
      {2970183398, 0, 0},
      {3253403867, 0, 0},
      {3427283542, 0, 0},
      {3570411982, 0, 0},
      {3619787319, 0, 0},
      {3662767579, 0, 0},
      {3884846406, 0, 0},
      {3910458990, 0, 0},
      {3927915220, 0, 0},
      {4224872590, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 20},
      {0, 6, 25},
      {0, 23, 3},
      {0, 2, 4},
      {0, 14, 17},
      {0, 11, 8},
      {0, 27, 10},
      {0, 19, 28},
      {0, 12, 16},
      {0, 33, 32},
      {0, 35, 34},
      {0, 37, 36},
      {0, 39, 38},
      {0, 40, 15},
      {0, 41, 7},
      {0, 1, 21},
      {0, 24, 13},
      {0, 29, 42},
      {0, 44, 43},
      {0, 22, 45},
      {0, 47, 46},
      {0, 49, 48},
      {0, 50, 30},
      {0, 31, 51},
      {0, 53, 52},
      {0, 55, 54},
      {0, 56, 9},
      {0, 57, 26},
      {0, 59, 58},
      {0, 60, 18},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(39, {
      {0, 0, 0},
      {744062262, 0, 0},
      {810488476, 0, 0},
      {1040775722, 0, 0},
      {1280126114, 0, 0},
      {1367301635, 0, 0},
      {1684282922, 0, 0},
      {1918481917, 0, 0},
      {1978689945, 0, 0},
      {1980341560, 0, 0},
      {2443959748, 0, 0},
      {2629265310, 0, 0},
      {2790624748, 0, 0},
      {2970183398, 0, 0},
      {3044188332, 0, 0},
      {3496407048, 0, 0},
      {3662767579, 0, 0},
      {3887377256, 0, 0},
      {3971481069, 0, 0},
      {4224872590, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 2},
      {0, 18, 15},
      {0, 21, 6},
      {0, 13, 11},
      {0, 4, 22},
      {0, 14, 1},
      {0, 24, 23},
      {0, 25, 8},
      {0, 27, 26},
      {0, 20, 17},
      {0, 5, 28},
      {0, 29, 9},
      {0, 16, 10},
      {0, 31, 30},
      {0, 32, 7},
      {0, 19, 33},
      {0, 35, 34},
      {0, 37, 36},
      {0, 38, 12},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 4), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(27, {
      {0, 0, 0},
      {37459569, 0, 0},
      {837715723, 0, 0},
      {1352628475, 0, 0},
      {1918481917, 0, 0},
      {1978689945, 0, 0},
      {1980341560, 0, 0},
      {2096388952, 0, 0},
      {2622612602, 0, 0},
      {2790624748, 0, 0},
      {2970183398, 0, 0},
      {3510682541, 0, 0},
      {3783543823, 0, 0},
      {4224872590, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 7, 11},
      {0, 2, 8},
      {0, 15, 12},
      {0, 1, 3},
      {0, 16, 6},
      {0, 18, 17},
      {0, 19, 14},
      {0, 20, 5},
      {0, 10, 21},
      {0, 22, 4},
      {0, 23, 13},
      {0, 25, 24},
      {0, 9, 26},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 5), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(13, {
      {0, 0, 0},
      {1510333659, 0, 0},
      {1684282922, 0, 0},
      {1918481917, 0, 0},
      {2790624748, 0, 0},
      {3662767579, 0, 0},
      {4224872590, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 1},
      {0, 8, 2},
      {0, 9, 7},
      {0, 3, 10},
      {0, 6, 11},
      {0, 4, 12},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 6), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(27, {
      {0, 0, 0},
      {161668409, 0, 0},
      {188347929, 0, 0},
      {653708953, 0, 0},
      {976111724, 0, 0},
      {1510333659, 0, 0},
      {1918481917, 0, 0},
      {2790624748, 0, 0},
      {3033873113, 0, 0},
      {3499234137, 0, 0},
      {3525913657, 0, 0},
      {3552593177, 0, 0},
      {3570411982, 0, 0},
      {4224872590, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 8, 3},
      {0, 2, 9},
      {0, 10, 11},
      {0, 15, 1},
      {0, 17, 16},
      {0, 19, 18},
      {0, 5, 4},
      {0, 20, 6},
      {0, 12, 21},
      {0, 14, 22},
      {0, 24, 23},
      {0, 7, 25},
      {0, 13, 26},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 7), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(31, {
      {0, 0, 0},
      {226836633, 0, 0},
      {296981500, 0, 0},
      {718877177, 0, 0},
      {745556697, 0, 0},
      {798915737, 0, 0},
      {1510333659, 0, 0},
      {1684282922, 0, 0},
      {2444465148, 0, 0},
      {2713718873, 0, 0},
      {3495546641, 0, 0},
      {3564402361, 0, 0},
      {4056442905, 0, 0},
      {4083122425, 0, 0},
      {4123141705, 0, 0},
      {4224872590, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 14, 4},
      {0, 5, 3},
      {0, 9, 8},
      {0, 13, 12},
      {0, 1, 11},
      {0, 18, 17},
      {0, 2, 19},
      {0, 21, 20},
      {0, 23, 22},
      {0, 25, 24},
      {0, 26, 7},
      {0, 27, 16},
      {0, 10, 6},
      {0, 29, 28},
      {0, 15, 30},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 8), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(35, {
      {0, 0, 0},
      {161668409, 0, 0},
      {188347929, 0, 0},
      {215027449, 0, 0},
      {296981500, 0, 0},
      {653708953, 0, 0},
      {680388473, 0, 0},
      {1119069977, 0, 0},
      {1510333659, 0, 0},
      {1584774136, 0, 0},
      {2049792025, 0, 0},
      {2444465148, 0, 0},
      {2568512089, 0, 0},
      {3033873113, 0, 0},
      {3499234137, 0, 0},
      {3525913657, 0, 0},
      {3552593177, 0, 0},
      {4224872590, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 7, 6},
      {0, 10, 12},
      {0, 4, 3},
      {0, 16, 11},
      {0, 19, 14},
      {0, 5, 2},
      {0, 20, 13},
      {0, 21, 15},
      {0, 1, 22},
      {0, 24, 23},
      {0, 26, 25},
      {0, 28, 27},
      {0, 18, 29},
      {0, 8, 30},
      {0, 32, 31},
      {0, 9, 33},
      {0, 17, 34},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 9), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(25, {
      {0, 0, 0},
      {825595257, 0, 0},
      {1064945649, 0, 0},
      {1290956281, 0, 0},
      {1510333659, 0, 0},
      {2096388952, 0, 0},
      {2248357849, 0, 0},
      {2713718873, 0, 0},
      {3187066832, 0, 0},
      {3205759417, 0, 0},
      {4064212479, 0, 0},
      {4163160985, 0, 0},
      {4224872590, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 8, 3},
      {0, 2, 9},
      {0, 7, 6},
      {0, 5, 14},
      {0, 16, 15},
      {0, 17, 11},
      {0, 19, 18},
      {0, 20, 1},
      {0, 4, 13},
      {0, 22, 21},
      {0, 10, 23},
      {0, 12, 24},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 10), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(27, {
      {0, 0, 0},
      {123108003, 0, 0},
      {296981500, 0, 0},
      {595410904, 0, 0},
      {1466938734, 0, 0},
      {1503477720, 0, 0},
      {1816558243, 0, 0},
      {1990431740, 0, 0},
      {2724625059, 0, 0},
      {2790624748, 0, 0},
      {2812498065, 0, 0},
      {3160388974, 0, 0},
      {3745223676, 0, 0},
      {3982311384, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 13},
      {0, 8, 1},
      {0, 12, 11},
      {0, 15, 3},
      {0, 6, 4},
      {0, 16, 7},
      {0, 17, 14},
      {0, 18, 2},
      {0, 19, 10},
      {0, 21, 20},
      {0, 23, 22},
      {0, 25, 24},
      {0, 9, 26},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 11), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(25, {
      {0, 0, 0},
      {94145952, 0, 0},
      {1054641568, 0, 0},
      {1269075360, 0, 0},
      {1675922848, 0, 0},
      {2038205856, 0, 0},
      {2433519008, 0, 0},
      {2636942752, 0, 0},
      {2790624748, 0, 0},
      {2840366496, 0, 0},
      {2851900832, 0, 0},
      {2964622752, 0, 0},
      {3654061472, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 7, 1},
      {0, 12, 6},
      {0, 14, 10},
      {0, 13, 4},
      {0, 11, 15},
      {0, 3, 16},
      {0, 2, 17},
      {0, 18, 5},
      {0, 9, 19},
      {0, 21, 20},
      {0, 23, 22},
      {0, 8, 24},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 12), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(45, {
      {0, 0, 0},
      {107544081, 0, 0},
      {125015036, 0, 0},
      {586244865, 0, 0},
      {1033081852, 0, 0},
      {1064945649, 0, 0},
      {1155765244, 0, 0},
      {1304296041, 0, 0},
      {1543646433, 0, 0},
      {1782996825, 0, 0},
      {1941148668, 0, 0},
      {2002490364, 0, 0},
      {2022347217, 0, 0},
      {2063832060, 0, 0},
      {2487708241, 0, 0},
      {2726532092, 0, 0},
      {2849215484, 0, 0},
      {2966409025, 0, 0},
      {3445109809, 0, 0},
      {3458449569, 0, 0},
      {3634598908, 0, 0},
      {3695940604, 0, 0},
      {3923810593, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 7, 2},
      {0, 14, 13},
      {0, 1, 23},
      {0, 6, 5},
      {0, 16, 15},
      {0, 24, 17},
      {0, 12, 25},
      {0, 22, 18},
      {0, 10, 26},
      {0, 28, 27},
      {0, 21, 29},
      {0, 31, 30},
      {0, 9, 8},
      {0, 11, 32},
      {0, 33, 19},
      {0, 3, 34},
      {0, 36, 35},
      {0, 38, 37},
      {0, 20, 39},
      {0, 41, 40},
      {0, 42, 4},
      {0, 44, 43},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 13), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(23, {
      {0, 0, 0},
      {247698428, 0, 0},
      {309040124, 0, 0},
      {333554713, 0, 0},
      {572905105, 0, 0},
      {1033081852, 0, 0},
      {2002490364, 0, 0},
      {2009007457, 0, 0},
      {2487708241, 0, 0},
      {3634598908, 0, 0},
      {3695940604, 0, 0},
      {3923810593, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 6, 1},
      {0, 9, 7},
      {0, 5, 12},
      {0, 14, 13},
      {0, 15, 8},
      {0, 3, 16},
      {0, 17, 11},
      {0, 10, 4},
      {0, 2, 18},
      {0, 20, 19},
      {0, 22, 21},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 14), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(11, {
      {0, 0, 0},
      {247698428, 0, 0},
      {1033081852, 0, 0},
      {2002490364, 0, 0},
      {2910557180, 0, 0},
      {3757282300, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 6, 4},
      {0, 7, 3},
      {0, 2, 8},
      {0, 1, 5},
      {0, 10, 9},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 15), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {1033081852, 0, 0},
      {1094423548, 0, 0},
      {2002490364, 0, 0},
      {3757282300, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 5},
      {0, 6, 2},
      {0, 4, 7},
      {0, 8, 1},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFunctionCall, 16), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(57, {
      {0, 0, 0},
      {135486769, 0, 0},
      {450406196, 0, 0},
      {503094540, 0, 0},
      {543621065, 0, 0},
      {827698488, 0, 0},
      {1294403159, 0, 0},
      {1296054774, 0, 0},
      {1297706389, 0, 0},
      {1322549027, 0, 0},
      {1784441183, 0, 0},
      {2194691858, 0, 0},
      {2448331885, 0, 0},
      {2468230023, 0, 0},
      {2547657777, 0, 0},
      {2549309392, 0, 0},
      {2550961007, 0, 0},
      {2934934694, 0, 0},
      {2936586309, 0, 0},
      {2938237924, 0, 0},
      {3094180193, 0, 0},
      {3095831808, 0, 0},
      {3183924418, 0, 0},
      {3561562003, 0, 0},
      {3563213618, 0, 0},
      {3564865233, 0, 0},
      {4028622909, 0, 0},
      {4039938779, 0, 0},
      {4050155669, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 27, 28},
      {0, 10, 2},
      {0, 25, 24},
      {0, 1, 12},
      {0, 30, 3},
      {0, 20, 31},
      {0, 9, 32},
      {0, 34, 33},
      {0, 35, 22},
      {0, 26, 15},
      {0, 19, 36},
      {0, 18, 37},
      {0, 38, 16},
      {0, 39, 8},
      {0, 5, 40},
      {0, 6, 41},
      {0, 21, 42},
      {0, 11, 29},
      {0, 4, 43},
      {0, 13, 23},
      {0, 14, 17},
      {0, 7, 44},
      {0, 46, 45},
      {0, 48, 47},
      {0, 50, 49},
      {0, 52, 51},
      {0, 54, 53},
      {0, 56, 55},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpVariable, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(57, {
      {0, 0, 0},
      {37459569, 0, 0},
      {112745085, 0, 0},
      {137840602, 0, 0},
      {565334834, 0, 0},
      {625975427, 0, 0},
      {630964591, 0, 0},
      {680016782, 0, 0},
      {769422756, 0, 0},
      {1009983433, 0, 0},
      {1093210099, 0, 0},
      {1572088444, 0, 0},
      {1584774136, 0, 0},
      {1641565587, 0, 0},
      {1918481917, 0, 0},
      {2190437442, 0, 0},
      {2790624748, 0, 0},
      {3085467405, 0, 0},
      {3181646225, 0, 0},
      {3192069648, 0, 0},
      {3253403867, 0, 0},
      {3390051757, 0, 0},
      {3560665067, 0, 0},
      {3662767579, 0, 0},
      {4053789056, 0, 0},
      {4064212479, 0, 0},
      {4192247221, 0, 0},
      {4224872590, 0, 0},
      {4290024976, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 20},
      {0, 28, 10},
      {0, 13, 8},
      {0, 15, 17},
      {0, 30, 21},
      {0, 19, 31},
      {0, 4, 32},
      {0, 34, 33},
      {0, 35, 5},
      {0, 7, 24},
      {0, 9, 36},
      {0, 3, 37},
      {0, 38, 6},
      {0, 39, 23},
      {0, 27, 40},
      {0, 14, 41},
      {0, 25, 42},
      {0, 1, 29},
      {0, 12, 43},
      {0, 11, 26},
      {0, 18, 22},
      {0, 16, 44},
      {0, 46, 45},
      {0, 48, 47},
      {0, 50, 49},
      {0, 52, 51},
      {0, 54, 53},
      {0, 56, 55},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpVariable, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(27, {
      {0, 0, 0},
      {162255877, 0, 0},
      {679771963, 0, 0},
      {789872778, 0, 0},
      {1154919607, 0, 0},
      {1343794461, 0, 0},
      {1951208733, 0, 0},
      {2263349224, 0, 0},
      {2320303498, 0, 0},
      {2924146124, 0, 0},
      {2984325996, 0, 0},
      {3334207724, 0, 0},
      {3868239231, 0, 0},
      {3869890846, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 5, 3},
      {0, 9, 7},
      {0, 12, 4},
      {0, 16, 15},
      {0, 18, 17},
      {0, 14, 19},
      {0, 13, 10},
      {0, 20, 1},
      {0, 21, 8},
      {0, 2, 22},
      {0, 11, 23},
      {0, 6, 24},
      {0, 26, 25},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpLoad, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(83, {
      {0, 0, 0},
      {169674806, 0, 0},
      {269823086, 0, 0},
      {408465899, 0, 0},
      {451264926, 0, 0},
      {543558236, 0, 0},
      {810488476, 0, 0},
      {850497536, 0, 0},
      {870594305, 0, 0},
      {883854656, 0, 0},
      {1033363654, 0, 0},
      {1069781886, 0, 0},
      {1141965917, 0, 0},
      {1323407757, 0, 0},
      {1570165302, 0, 0},
      {1684282922, 0, 0},
      {1742737136, 0, 0},
      {1901166356, 0, 0},
      {1949759310, 0, 0},
      {2043873558, 0, 0},
      {2087004702, 0, 0},
      {2096388952, 0, 0},
      {2157103435, 0, 0},
      {2219733501, 0, 0},
      {2356768706, 0, 0},
      {2443959748, 0, 0},
      {2517964682, 0, 0},
      {2614879967, 0, 0},
      {2622612602, 0, 0},
      {2660843182, 0, 0},
      {2959147533, 0, 0},
      {2970183398, 0, 0},
      {3044188332, 0, 0},
      {3091876332, 0, 0},
      {3187066832, 0, 0},
      {3244209297, 0, 0},
      {3487022798, 0, 0},
      {3496407048, 0, 0},
      {3570411982, 0, 0},
      {3692647551, 0, 0},
      {3713290482, 0, 0},
      {3831290364, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 1},
      {0, 35, 13},
      {0, 25, 11},
      {0, 7, 10},
      {0, 19, 36},
      {0, 43, 27},
      {0, 16, 29},
      {0, 22, 3},
      {0, 41, 30},
      {0, 44, 12},
      {0, 2, 24},
      {0, 40, 32},
      {0, 23, 45},
      {0, 46, 39},
      {0, 17, 33},
      {0, 48, 47},
      {0, 8, 49},
      {0, 51, 50},
      {0, 52, 20},
      {0, 53, 14},
      {0, 31, 54},
      {0, 15, 55},
      {0, 57, 56},
      {0, 59, 58},
      {0, 6, 26},
      {0, 61, 60},
      {0, 34, 62},
      {0, 64, 63},
      {0, 5, 37},
      {0, 9, 65},
      {0, 18, 28},
      {0, 66, 38},
      {0, 68, 67},
      {0, 69, 21},
      {0, 71, 70},
      {0, 73, 72},
      {0, 75, 74},
      {0, 77, 76},
      {0, 79, 78},
      {0, 80, 42},
      {0, 82, 81},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpLoad, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(83, {
      {0, 0, 0},
      {28782128, 0, 0},
      {30433743, 0, 0},
      {37459569, 0, 0},
      {137840602, 0, 0},
      {522971108, 0, 0},
      {565334834, 0, 0},
      {625975427, 0, 0},
      {630964591, 0, 0},
      {680016782, 0, 0},
      {1009983433, 0, 0},
      {1079999262, 0, 0},
      {1395113939, 0, 0},
      {1572088444, 0, 0},
      {1584774136, 0, 0},
      {1649426421, 0, 0},
      {1918481917, 0, 0},
      {1957218950, 0, 0},
      {2311941439, 0, 0},
      {2313593054, 0, 0},
      {2790624748, 0, 0},
      {2838165089, 0, 0},
      {2839816704, 0, 0},
      {2841468319, 0, 0},
      {3085467405, 0, 0},
      {3181646225, 0, 0},
      {3192069648, 0, 0},
      {3253403867, 0, 0},
      {3364388739, 0, 0},
      {3366040354, 0, 0},
      {3367691969, 0, 0},
      {3369343584, 0, 0},
      {3560665067, 0, 0},
      {3662767579, 0, 0},
      {3945795573, 0, 0},
      {4053789056, 0, 0},
      {4064212479, 0, 0},
      {4224872590, 0, 0},
      {4239834800, 0, 0},
      {4241486415, 0, 0},
      {4243138030, 0, 0},
      {4244789645, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 27},
      {0, 15, 2},
      {0, 10, 26},
      {0, 7, 24},
      {0, 9, 31},
      {0, 43, 30},
      {0, 29, 12},
      {0, 11, 41},
      {0, 40, 39},
      {0, 44, 23},
      {0, 22, 6},
      {0, 34, 35},
      {0, 18, 45},
      {0, 46, 21},
      {0, 17, 19},
      {0, 48, 47},
      {0, 28, 49},
      {0, 51, 50},
      {0, 52, 38},
      {0, 53, 33},
      {0, 4, 54},
      {0, 13, 55},
      {0, 57, 56},
      {0, 59, 58},
      {0, 37, 8},
      {0, 61, 60},
      {0, 5, 62},
      {0, 64, 63},
      {0, 36, 32},
      {0, 3, 65},
      {0, 14, 16},
      {0, 66, 25},
      {0, 68, 67},
      {0, 69, 20},
      {0, 71, 70},
      {0, 73, 72},
      {0, 75, 74},
      {0, 77, 76},
      {0, 79, 78},
      {0, 80, 42},
      {0, 82, 81},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpLoad, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(49, {
      {0, 0, 0},
      {137840602, 0, 0},
      {522971108, 0, 0},
      {769422756, 0, 0},
      {1009983433, 0, 0},
      {1079999262, 0, 0},
      {1558345254, 0, 0},
      {1572088444, 0, 0},
      {1641565587, 0, 0},
      {1918481917, 0, 0},
      {2311941439, 0, 0},
      {2313593054, 0, 0},
      {2790624748, 0, 0},
      {2838165089, 0, 0},
      {2994529201, 0, 0},
      {2996180816, 0, 0},
      {2997832431, 0, 0},
      {3027538652, 0, 0},
      {3253403867, 0, 0},
      {3364388739, 0, 0},
      {3560665067, 0, 0},
      {3662767579, 0, 0},
      {3945795573, 0, 0},
      {4192247221, 0, 0},
      {4224872590, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 14, 17},
      {0, 16, 15},
      {0, 13, 11},
      {0, 10, 3},
      {0, 22, 18},
      {0, 6, 8},
      {0, 19, 2},
      {0, 27, 26},
      {0, 28, 5},
      {0, 30, 29},
      {0, 32, 31},
      {0, 34, 33},
      {0, 4, 35},
      {0, 37, 36},
      {0, 21, 1},
      {0, 39, 38},
      {0, 40, 24},
      {0, 7, 23},
      {0, 20, 9},
      {0, 42, 41},
      {0, 43, 25},
      {0, 44, 12},
      {0, 46, 45},
      {0, 48, 47},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpStore, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(59, {
      {0, 0, 0},
      {139011596, 0, 0},
      {177111659, 0, 0},
      {296981500, 0, 0},
      {408465899, 0, 0},
      {495107308, 0, 0},
      {810488476, 0, 0},
      {870594305, 0, 0},
      {1367301635, 0, 0},
      {1901166356, 0, 0},
      {2055836767, 0, 0},
      {2087004702, 0, 0},
      {2096388952, 0, 0},
      {2204920111, 0, 0},
      {2517964682, 0, 0},
      {2622612602, 0, 0},
      {2660843182, 0, 0},
      {2842919847, 0, 0},
      {2855506940, 0, 0},
      {2959147533, 0, 0},
      {3044188332, 0, 0},
      {3187066832, 0, 0},
      {3504158761, 0, 0},
      {3570411982, 0, 0},
      {3619787319, 0, 0},
      {3653838348, 0, 0},
      {3692647551, 0, 0},
      {3764205609, 0, 0},
      {3831290364, 0, 0},
      {3913885196, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 20, 29},
      {0, 25, 8},
      {0, 5, 1},
      {0, 24, 26},
      {0, 14, 9},
      {0, 27, 16},
      {0, 31, 7},
      {0, 33, 32},
      {0, 17, 34},
      {0, 35, 13},
      {0, 22, 6},
      {0, 3, 2},
      {0, 23, 36},
      {0, 28, 37},
      {0, 19, 4},
      {0, 38, 10},
      {0, 39, 15},
      {0, 40, 18},
      {0, 42, 41},
      {0, 43, 12},
      {0, 44, 21},
      {0, 45, 11},
      {0, 47, 46},
      {0, 49, 48},
      {0, 51, 50},
      {0, 53, 52},
      {0, 55, 54},
      {0, 57, 56},
      {0, 30, 58},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpStore, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(35, {
      {0, 0, 0},
      {440421571, 0, 0},
      {827698488, 0, 0},
      {907126242, 0, 0},
      {908777857, 0, 0},
      {910429472, 0, 0},
      {1294403159, 0, 0},
      {1296054774, 0, 0},
      {1297706389, 0, 0},
      {2080953106, 0, 0},
      {2468230023, 0, 0},
      {2547657777, 0, 0},
      {2549309392, 0, 0},
      {2550961007, 0, 0},
      {3094857332, 0, 0},
      {3561562003, 0, 0},
      {3563213618, 0, 0},
      {3564865233, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 16, 12},
      {0, 17, 13},
      {0, 14, 19},
      {0, 18, 20},
      {0, 5, 21},
      {0, 11, 7},
      {0, 15, 22},
      {0, 9, 8},
      {0, 24, 23},
      {0, 25, 4},
      {0, 27, 26},
      {0, 28, 3},
      {0, 29, 10},
      {0, 6, 1},
      {0, 31, 30},
      {0, 32, 2},
      {0, 34, 33},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpAccessChain, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(99, {
      {0, 0, 0},
      {27130513, 0, 0},
      {28782128, 0, 0},
      {30433743, 0, 0},
      {32085358, 0, 0},
      {155458798, 0, 0},
      {157110413, 0, 0},
      {163402553, 0, 0},
      {165054168, 0, 0},
      {213642219, 0, 0},
      {215293834, 0, 0},
      {216945449, 0, 0},
      {221900294, 0, 0},
      {545986953, 0, 0},
      {979993429, 0, 0},
      {1079999262, 0, 0},
      {1302400505, 0, 0},
      {1313182965, 0, 0},
      {1314834580, 0, 0},
      {1315613425, 0, 0},
      {1317265040, 0, 0},
      {1558345254, 0, 0},
      {1649426421, 0, 0},
      {2311941439, 0, 0},
      {2313593054, 0, 0},
      {2602027658, 0, 0},
      {2838165089, 0, 0},
      {2839816704, 0, 0},
      {2841468319, 0, 0},
      {2863084840, 0, 0},
      {2994529201, 0, 0},
      {2996180816, 0, 0},
      {2997832431, 0, 0},
      {3027538652, 0, 0},
      {3187387500, 0, 0},
      {3189039115, 0, 0},
      {3364388739, 0, 0},
      {3366040354, 0, 0},
      {3367691969, 0, 0},
      {3369343584, 0, 0},
      {3716914380, 0, 0},
      {3928842969, 0, 0},
      {3930494584, 0, 0},
      {3932146199, 0, 0},
      {3945482286, 0, 0},
      {4105051793, 0, 0},
      {4239834800, 0, 0},
      {4241486415, 0, 0},
      {4243138030, 0, 0},
      {4244789645, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 29, 10},
      {0, 17, 18},
      {0, 13, 14},
      {0, 44, 25},
      {0, 8, 7},
      {0, 20, 11},
      {0, 33, 19},
      {0, 6, 45},
      {0, 42, 43},
      {0, 40, 5},
      {0, 9, 16},
      {0, 1, 4},
      {0, 35, 34},
      {0, 12, 21},
      {0, 52, 51},
      {0, 31, 30},
      {0, 41, 32},
      {0, 54, 53},
      {0, 55, 2},
      {0, 3, 56},
      {0, 58, 57},
      {0, 60, 59},
      {0, 61, 22},
      {0, 63, 62},
      {0, 65, 64},
      {0, 67, 66},
      {0, 39, 68},
      {0, 38, 69},
      {0, 47, 70},
      {0, 49, 71},
      {0, 28, 48},
      {0, 37, 15},
      {0, 73, 72},
      {0, 74, 27},
      {0, 23, 75},
      {0, 76, 26},
      {0, 24, 77},
      {0, 79, 78},
      {0, 81, 80},
      {0, 82, 46},
      {0, 36, 83},
      {0, 85, 84},
      {0, 87, 86},
      {0, 89, 88},
      {0, 91, 90},
      {0, 93, 92},
      {0, 95, 94},
      {0, 97, 96},
      {0, 50, 98},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpAccessChain, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(101, {
      {0, 0, 0},
      {112745085, 0, 0},
      {116376005, 0, 0},
      {137840602, 0, 0},
      {400248103, 0, 0},
      {406044930, 0, 0},
      {468372467, 0, 0},
      {522971108, 0, 0},
      {615341051, 0, 0},
      {625975427, 0, 0},
      {630964591, 0, 0},
      {680016782, 0, 0},
      {763027711, 0, 0},
      {977312655, 0, 0},
      {1009983433, 0, 0},
      {1062250709, 0, 0},
      {1395113939, 0, 0},
      {1410849099, 0, 0},
      {1642805350, 0, 0},
      {1692932387, 0, 0},
      {1698730948, 0, 0},
      {1827244161, 0, 0},
      {1918481917, 0, 0},
      {2096472894, 0, 0},
      {2190437442, 0, 0},
      {2299842241, 0, 0},
      {2433358586, 0, 0},
      {2593325766, 0, 0},
      {2785441472, 0, 0},
      {2790624748, 0, 0},
      {2879917723, 0, 0},
      {2882994691, 0, 0},
      {2902069960, 0, 0},
      {3090408469, 0, 0},
      {3181646225, 0, 0},
      {3255947500, 0, 0},
      {3263901372, 0, 0},
      {3268751013, 0, 0},
      {3347863687, 0, 0},
      {3390051757, 0, 0},
      {3560665067, 0, 0},
      {3617689692, 0, 0},
      {3662767579, 0, 0},
      {3717523241, 0, 0},
      {3854557817, 0, 0},
      {3910458990, 0, 0},
      {3941049054, 0, 0},
      {3945795573, 0, 0},
      {4080527786, 0, 0},
      {4101009465, 0, 0},
      {4290024976, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 32, 44},
      {0, 41, 26},
      {0, 16, 10},
      {0, 27, 45},
      {0, 25, 38},
      {0, 12, 18},
      {0, 6, 35},
      {0, 46, 23},
      {0, 20, 37},
      {0, 52, 19},
      {0, 53, 21},
      {0, 54, 48},
      {0, 33, 55},
      {0, 3, 8},
      {0, 28, 56},
      {0, 13, 57},
      {0, 59, 58},
      {0, 1, 49},
      {0, 47, 60},
      {0, 61, 14},
      {0, 63, 62},
      {0, 64, 43},
      {0, 7, 4},
      {0, 65, 15},
      {0, 67, 66},
      {0, 68, 17},
      {0, 36, 2},
      {0, 30, 69},
      {0, 71, 70},
      {0, 34, 5},
      {0, 73, 72},
      {0, 75, 74},
      {0, 77, 76},
      {0, 24, 78},
      {0, 39, 31},
      {0, 80, 79},
      {0, 9, 11},
      {0, 42, 81},
      {0, 83, 82},
      {0, 29, 50},
      {0, 84, 51},
      {0, 86, 85},
      {0, 22, 40},
      {0, 88, 87},
      {0, 90, 89},
      {0, 92, 91},
      {0, 94, 93},
      {0, 96, 95},
      {0, 98, 97},
      {0, 100, 99},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpAccessChain, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(69, {
      {0, 0, 0},
      {51041423, 0, 0},
      {142465290, 0, 0},
      {144116905, 0, 0},
      {290391815, 0, 0},
      {438318340, 0, 0},
      {529742207, 0, 0},
      {677668732, 0, 0},
      {917019124, 0, 0},
      {1064945649, 0, 0},
      {1156369516, 0, 0},
      {1158021131, 0, 0},
      {1304296041, 0, 0},
      {1452222566, 0, 0},
      {1543646433, 0, 0},
      {1691572958, 0, 0},
      {1782996825, 0, 0},
      {1784648440, 0, 0},
      {1930923350, 0, 0},
      {2170273742, 0, 0},
      {2318200267, 0, 0},
      {2466126792, 0, 0},
      {2557550659, 0, 0},
      {2705477184, 0, 0},
      {2796901051, 0, 0},
      {2798552666, 0, 0},
      {2944827576, 0, 0},
      {3092754101, 0, 0},
      {3184177968, 0, 0},
      {3332104493, 0, 0},
      {3571454885, 0, 0},
      {3810805277, 0, 0},
      {3958731802, 0, 0},
      {4106658327, 0, 0},
      {4198082194, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 27, 33},
      {0, 21, 5},
      {0, 26, 13},
      {0, 20, 8},
      {0, 15, 7},
      {0, 37, 36},
      {0, 32, 29},
      {0, 38, 4},
      {0, 30, 1},
      {0, 9, 12},
      {0, 39, 18},
      {0, 22, 40},
      {0, 42, 41},
      {0, 44, 43},
      {0, 45, 35},
      {0, 46, 34},
      {0, 6, 14},
      {0, 28, 23},
      {0, 48, 47},
      {0, 49, 31},
      {0, 51, 50},
      {0, 19, 24},
      {0, 52, 10},
      {0, 2, 53},
      {0, 55, 54},
      {0, 25, 56},
      {0, 11, 57},
      {0, 59, 58},
      {0, 3, 17},
      {0, 61, 60},
      {0, 16, 62},
      {0, 64, 63},
      {0, 66, 65},
      {0, 68, 67},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpAccessChain, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(85, {
      {0, 0, 0},
      {142465290, 0, 0},
      {144116905, 0, 0},
      {198967948, 0, 0},
      {290391815, 0, 0},
      {529742207, 0, 0},
      {586244865, 0, 0},
      {677668732, 0, 0},
      {825595257, 0, 0},
      {917019124, 0, 0},
      {973521782, 0, 0},
      {1064945649, 0, 0},
      {1156369516, 0, 0},
      {1158021131, 0, 0},
      {1212872174, 0, 0},
      {1304296041, 0, 0},
      {1452222566, 0, 0},
      {1543646433, 0, 0},
      {1600149091, 0, 0},
      {1782996825, 0, 0},
      {1784648440, 0, 0},
      {1839499483, 0, 0},
      {1930923350, 0, 0},
      {2170273742, 0, 0},
      {2226776400, 0, 0},
      {2318200267, 0, 0},
      {2466126792, 0, 0},
      {2557550659, 0, 0},
      {2614053317, 0, 0},
      {2796901051, 0, 0},
      {2798552666, 0, 0},
      {2853403709, 0, 0},
      {2944827576, 0, 0},
      {3184177968, 0, 0},
      {3240680626, 0, 0},
      {3480031018, 0, 0},
      {3571454885, 0, 0},
      {3810805277, 0, 0},
      {3867307935, 0, 0},
      {3958731802, 0, 0},
      {4106658327, 0, 0},
      {4198082194, 0, 0},
      {4254584852, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 7, 11},
      {0, 15, 4},
      {0, 32, 25},
      {0, 44, 39},
      {0, 36, 22},
      {0, 45, 17},
      {0, 24, 46},
      {0, 10, 9},
      {0, 6, 27},
      {0, 28, 18},
      {0, 42, 34},
      {0, 31, 14},
      {0, 41, 38},
      {0, 26, 3},
      {0, 47, 33},
      {0, 21, 8},
      {0, 5, 35},
      {0, 40, 16},
      {0, 37, 23},
      {0, 49, 48},
      {0, 51, 50},
      {0, 53, 52},
      {0, 55, 54},
      {0, 57, 56},
      {0, 59, 58},
      {0, 61, 60},
      {0, 63, 62},
      {0, 65, 64},
      {0, 67, 66},
      {0, 68, 12},
      {0, 29, 69},
      {0, 70, 1},
      {0, 30, 2},
      {0, 43, 71},
      {0, 73, 72},
      {0, 74, 20},
      {0, 75, 19},
      {0, 77, 76},
      {0, 13, 78},
      {0, 80, 79},
      {0, 82, 81},
      {0, 84, 83},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpAccessChain, 4), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {144116905, 0, 0},
      {1158021131, 0, 0},
      {1784648440, 0, 0},
      {2798552666, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 5},
      {0, 4, 2},
      {0, 6, 3},
      {0, 8, 7},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpAccessChain, 5), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(5, {
      {0, 0, 0},
      {142465290, 0, 0},
      {1782996825, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 1},
      {0, 4, 3},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpAccessChain, 6), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {679771963, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 4},
      {0, 2, 5},
      {0, 6, 1},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpVectorShuffle, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(59, {
      {0, 0, 0},
      {177111659, 0, 0},
      {413918748, 0, 0},
      {529383565, 0, 0},
      {646282397, 0, 0},
      {837715723, 0, 0},
      {1019457583, 0, 0},
      {1022544883, 0, 0},
      {1054461787, 0, 0},
      {1097775533, 0, 0},
      {1136775085, 0, 0},
      {1191015885, 0, 0},
      {1196280518, 0, 0},
      {1203545131, 0, 0},
      {1352628475, 0, 0},
      {1367301635, 0, 0},
      {1918742169, 0, 0},
      {1922045399, 0, 0},
      {2055836767, 0, 0},
      {2183547611, 0, 0},
      {2204920111, 0, 0},
      {2358141757, 0, 0},
      {2572638469, 0, 0},
      {2597020383, 0, 0},
      {2842919847, 0, 0},
      {3619787319, 0, 0},
      {3701632935, 0, 0},
      {3783543823, 0, 0},
      {4245257809, 0, 0},
      {4265894873, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 11, 23},
      {0, 12, 2},
      {0, 9, 7},
      {0, 21, 19},
      {0, 4, 29},
      {0, 10, 28},
      {0, 17, 16},
      {0, 27, 3},
      {0, 32, 31},
      {0, 33, 22},
      {0, 6, 34},
      {0, 35, 8},
      {0, 36, 24},
      {0, 38, 37},
      {0, 1, 14},
      {0, 39, 20},
      {0, 5, 40},
      {0, 42, 41},
      {0, 43, 26},
      {0, 45, 44},
      {0, 47, 46},
      {0, 48, 18},
      {0, 15, 49},
      {0, 50, 25},
      {0, 51, 13},
      {0, 53, 52},
      {0, 55, 54},
      {0, 57, 56},
      {0, 30, 58},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpVectorShuffle, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(59, {
      {0, 0, 0},
      {236660303, 0, 0},
      {342159236, 0, 0},
      {371428004, 0, 0},
      {373079619, 0, 0},
      {488500848, 0, 0},
      {495107308, 0, 0},
      {864295921, 0, 0},
      {1071164424, 0, 0},
      {1136911283, 0, 0},
      {1178317551, 0, 0},
      {1510422521, 0, 0},
      {1570165302, 0, 0},
      {1822823090, 0, 0},
      {1858116930, 0, 0},
      {1977038330, 0, 0},
      {2096388952, 0, 0},
      {2157103435, 0, 0},
      {2231688008, 0, 0},
      {2604576561, 0, 0},
      {2622612602, 0, 0},
      {2771938750, 0, 0},
      {2777172031, 0, 0},
      {2996594997, 0, 0},
      {3187066832, 0, 0},
      {3496407048, 0, 0},
      {3570411982, 0, 0},
      {3609540589, 0, 0},
      {3713290482, 0, 0},
      {3797761273, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 18, 8},
      {0, 27, 9},
      {0, 21, 10},
      {0, 14, 24},
      {0, 12, 19},
      {0, 11, 15},
      {0, 23, 2},
      {0, 7, 13},
      {0, 31, 22},
      {0, 32, 4},
      {0, 33, 29},
      {0, 34, 1},
      {0, 35, 3},
      {0, 37, 36},
      {0, 38, 28},
      {0, 39, 5},
      {0, 41, 40},
      {0, 42, 17},
      {0, 16, 43},
      {0, 45, 44},
      {0, 46, 6},
      {0, 48, 47},
      {0, 50, 49},
      {0, 52, 51},
      {0, 25, 53},
      {0, 54, 20},
      {0, 55, 26},
      {0, 57, 56},
      {0, 30, 58},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpVectorShuffle, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(47, {
      {0, 0, 0},
      {236660303, 0, 0},
      {342159236, 0, 0},
      {488500848, 0, 0},
      {495107308, 0, 0},
      {864295921, 0, 0},
      {1178317551, 0, 0},
      {1510422521, 0, 0},
      {1570165302, 0, 0},
      {1858116930, 0, 0},
      {1977038330, 0, 0},
      {2096388952, 0, 0},
      {2157103435, 0, 0},
      {2231688008, 0, 0},
      {2604576561, 0, 0},
      {2622612602, 0, 0},
      {2771938750, 0, 0},
      {2777172031, 0, 0},
      {2996594997, 0, 0},
      {3496407048, 0, 0},
      {3570411982, 0, 0},
      {3609540589, 0, 0},
      {3713290482, 0, 0},
      {3797761273, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 21, 13},
      {0, 16, 6},
      {0, 14, 9},
      {0, 7, 10},
      {0, 18, 2},
      {0, 17, 5},
      {0, 25, 8},
      {0, 22, 12},
      {0, 26, 23},
      {0, 27, 1},
      {0, 28, 3},
      {0, 30, 29},
      {0, 32, 31},
      {0, 34, 33},
      {0, 35, 11},
      {0, 36, 4},
      {0, 38, 37},
      {0, 40, 39},
      {0, 41, 15},
      {0, 42, 19},
      {0, 20, 43},
      {0, 45, 44},
      {0, 24, 46},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpVectorShuffle, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(15, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1146476634, 0, 0},
      {2160380860, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {3800912395, 0, 0},
      {3802564010, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 3},
      {0, 9, 6},
      {0, 8, 7},
      {0, 11, 10},
      {0, 4, 12},
      {0, 5, 13},
      {0, 14, 1},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeConstruct, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(79, {
      {0, 0, 0},
      {107497541, 0, 0},
      {289648234, 0, 0},
      {348584153, 0, 0},
      {369686787, 0, 0},
      {429277936, 0, 0},
      {449954059, 0, 0},
      {508217552, 0, 0},
      {742917749, 0, 0},
      {1032593647, 0, 0},
      {1158929937, 0, 0},
      {1209418480, 0, 0},
      {1319785741, 0, 0},
      {1321616112, 0, 0},
      {1417363940, 0, 0},
      {1541020250, 0, 0},
      {1564342316, 0, 0},
      {1578775276, 0, 0},
      {1631434666, 0, 0},
      {1636389511, 0, 0},
      {2012838864, 0, 0},
      {2262137600, 0, 0},
      {2281956980, 0, 0},
      {2359973133, 0, 0},
      {2464905186, 0, 0},
      {2613179511, 0, 0},
      {2621255555, 0, 0},
      {2817335337, 0, 0},
      {2881302403, 0, 0},
      {3063300848, 0, 0},
      {3151638847, 0, 0},
      {3233393284, 0, 0},
      {3323682385, 0, 0},
      {3337532056, 0, 0},
      {3456899824, 0, 0},
      {3547456240, 0, 0},
      {3675926744, 0, 0},
      {3753486980, 0, 0},
      {3931641900, 0, 0},
      {3970432934, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 25, 1},
      {0, 6, 4},
      {0, 8, 19},
      {0, 39, 24},
      {0, 3, 2},
      {0, 34, 14},
      {0, 10, 9},
      {0, 18, 38},
      {0, 32, 15},
      {0, 27, 16},
      {0, 28, 35},
      {0, 13, 26},
      {0, 20, 23},
      {0, 21, 11},
      {0, 36, 33},
      {0, 5, 22},
      {0, 42, 41},
      {0, 43, 29},
      {0, 45, 44},
      {0, 7, 46},
      {0, 48, 47},
      {0, 30, 31},
      {0, 50, 49},
      {0, 52, 51},
      {0, 54, 53},
      {0, 55, 17},
      {0, 57, 56},
      {0, 59, 58},
      {0, 61, 60},
      {0, 62, 12},
      {0, 64, 63},
      {0, 66, 65},
      {0, 67, 37},
      {0, 69, 68},
      {0, 71, 70},
      {0, 73, 72},
      {0, 75, 74},
      {0, 77, 76},
      {0, 40, 78},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeConstruct, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(87, {
      {0, 0, 0},
      {153013225, 0, 0},
      {296836635, 0, 0},
      {296981500, 0, 0},
      {778500192, 0, 0},
      {810488476, 0, 0},
      {848380423, 0, 0},
      {900522183, 0, 0},
      {910398460, 0, 0},
      {959681532, 0, 0},
      {1141965917, 0, 0},
      {1287304304, 0, 0},
      {1323407757, 0, 0},
      {1417363940, 0, 0},
      {1471851763, 0, 0},
      {1526654696, 0, 0},
      {1654776395, 0, 0},
      {1684282922, 0, 0},
      {1739837626, 0, 0},
      {1791352211, 0, 0},
      {2195550588, 0, 0},
      {2319227476, 0, 0},
      {2491124112, 0, 0},
      {2789375411, 0, 0},
      {2807448986, 0, 0},
      {2817579280, 0, 0},
      {2835131395, 0, 0},
      {2847102741, 0, 0},
      {2855506940, 0, 0},
      {2860348412, 0, 0},
      {3079287749, 0, 0},
      {3091876332, 0, 0},
      {3168953855, 0, 0},
      {3374978006, 0, 0},
      {3399062057, 0, 0},
      {3510257966, 0, 0},
      {3554463148, 0, 0},
      {3579593979, 0, 0},
      {3757851979, 0, 0},
      {3759503594, 0, 0},
      {3761155209, 0, 0},
      {3762806824, 0, 0},
      {3902853271, 0, 0},
      {4140081844, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 38, 42},
      {0, 14, 23},
      {0, 26, 18},
      {0, 39, 35},
      {0, 6, 40},
      {0, 16, 13},
      {0, 33, 34},
      {0, 12, 4},
      {0, 27, 41},
      {0, 25, 21},
      {0, 24, 1},
      {0, 37, 19},
      {0, 32, 22},
      {0, 2, 8},
      {0, 20, 17},
      {0, 43, 36},
      {0, 29, 15},
      {0, 46, 45},
      {0, 48, 47},
      {0, 50, 49},
      {0, 52, 51},
      {0, 54, 53},
      {0, 7, 55},
      {0, 56, 30},
      {0, 57, 5},
      {0, 59, 58},
      {0, 60, 11},
      {0, 9, 61},
      {0, 63, 62},
      {0, 65, 64},
      {0, 66, 31},
      {0, 68, 67},
      {0, 10, 69},
      {0, 71, 70},
      {0, 28, 72},
      {0, 74, 73},
      {0, 76, 75},
      {0, 78, 77},
      {0, 79, 3},
      {0, 81, 80},
      {0, 83, 82},
      {0, 85, 84},
      {0, 44, 86},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeConstruct, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(81, {
      {0, 0, 0},
      {14244860, 0, 0},
      {150820676, 0, 0},
      {153013225, 0, 0},
      {269823086, 0, 0},
      {289648234, 0, 0},
      {296981500, 0, 0},
      {678695941, 0, 0},
      {810488476, 0, 0},
      {850592577, 0, 0},
      {870594305, 0, 0},
      {910398460, 0, 0},
      {959681532, 0, 0},
      {1206571206, 0, 0},
      {1287304304, 0, 0},
      {1323407757, 0, 0},
      {1471851763, 0, 0},
      {1526654696, 0, 0},
      {1684282922, 0, 0},
      {1734446471, 0, 0},
      {1758530522, 0, 0},
      {2117320444, 0, 0},
      {2118972059, 0, 0},
      {2120623674, 0, 0},
      {2122275289, 0, 0},
      {2219733501, 0, 0},
      {2262321736, 0, 0},
      {2807448986, 0, 0},
      {2817579280, 0, 0},
      {2835131395, 0, 0},
      {2855506940, 0, 0},
      {2860348412, 0, 0},
      {2951272396, 0, 0},
      {3079287749, 0, 0},
      {3168953855, 0, 0},
      {3502816184, 0, 0},
      {3510257966, 0, 0},
      {3554463148, 0, 0},
      {3997952447, 0, 0},
      {4140081844, 0, 0},
      {4182141402, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 21, 26},
      {0, 29, 16},
      {0, 22, 36},
      {0, 1, 23},
      {0, 20, 5},
      {0, 19, 35},
      {0, 10, 38},
      {0, 13, 24},
      {0, 28, 7},
      {0, 27, 3},
      {0, 40, 2},
      {0, 34, 9},
      {0, 32, 11},
      {0, 33, 18},
      {0, 39, 37},
      {0, 31, 17},
      {0, 43, 42},
      {0, 45, 44},
      {0, 47, 46},
      {0, 49, 48},
      {0, 51, 50},
      {0, 8, 52},
      {0, 15, 53},
      {0, 55, 54},
      {0, 56, 14},
      {0, 58, 57},
      {0, 60, 59},
      {0, 61, 25},
      {0, 63, 62},
      {0, 4, 64},
      {0, 66, 65},
      {0, 68, 67},
      {0, 70, 69},
      {0, 71, 12},
      {0, 6, 72},
      {0, 30, 73},
      {0, 75, 74},
      {0, 77, 76},
      {0, 79, 78},
      {0, 41, 80},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeConstruct, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(111, {
      {0, 0, 0},
      {34183582, 0, 0},
      {93914936, 0, 0},
      {94303122, 0, 0},
      {117998987, 0, 0},
      {153013225, 0, 0},
      {296981500, 0, 0},
      {451264926, 0, 0},
      {473485679, 0, 0},
      {476788909, 0, 0},
      {478440524, 0, 0},
      {480092139, 0, 0},
      {481743754, 0, 0},
      {810488476, 0, 0},
      {871966503, 0, 0},
      {910398460, 0, 0},
      {918189168, 0, 0},
      {933769938, 0, 0},
      {959681532, 0, 0},
      {1149665466, 0, 0},
      {1166917451, 0, 0},
      {1227221002, 0, 0},
      {1310740861, 0, 0},
      {1323407757, 0, 0},
      {1341516288, 0, 0},
      {1373166395, 0, 0},
      {1445161581, 0, 0},
      {1461645203, 0, 0},
      {1471851763, 0, 0},
      {1526654696, 0, 0},
      {1561718045, 0, 0},
      {1593584949, 0, 0},
      {1684282922, 0, 0},
      {1800404122, 0, 0},
      {1862284649, 0, 0},
      {2213411495, 0, 0},
      {2668680621, 0, 0},
      {2805256437, 0, 0},
      {2807448986, 0, 0},
      {2835131395, 0, 0},
      {2855506940, 0, 0},
      {2860348412, 0, 0},
      {3000904950, 0, 0},
      {3107413701, 0, 0},
      {3168953855, 0, 0},
      {3333131702, 0, 0},
      {3365041621, 0, 0},
      {3456899824, 0, 0},
      {3505028338, 0, 0},
      {3510257966, 0, 0},
      {3554463148, 0, 0},
      {3606320646, 0, 0},
      {3692647551, 0, 0},
      {3861006967, 0, 0},
      {4126287524, 0, 0},
      {4140081844, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 14, 33},
      {0, 35, 25},
      {0, 27, 17},
      {0, 8, 20},
      {0, 3, 54},
      {0, 1, 19},
      {0, 10, 46},
      {0, 11, 9},
      {0, 39, 28},
      {0, 53, 49},
      {0, 12, 2},
      {0, 34, 4},
      {0, 47, 36},
      {0, 23, 45},
      {0, 5, 37},
      {0, 24, 38},
      {0, 43, 26},
      {0, 48, 51},
      {0, 44, 32},
      {0, 15, 16},
      {0, 57, 22},
      {0, 55, 50},
      {0, 29, 58},
      {0, 60, 59},
      {0, 41, 61},
      {0, 63, 62},
      {0, 65, 64},
      {0, 67, 66},
      {0, 69, 68},
      {0, 13, 70},
      {0, 71, 7},
      {0, 42, 31},
      {0, 73, 72},
      {0, 75, 74},
      {0, 21, 30},
      {0, 77, 76},
      {0, 79, 78},
      {0, 81, 80},
      {0, 82, 18},
      {0, 84, 83},
      {0, 86, 85},
      {0, 88, 87},
      {0, 90, 89},
      {0, 52, 91},
      {0, 6, 92},
      {0, 94, 93},
      {0, 96, 95},
      {0, 98, 97},
      {0, 99, 40},
      {0, 101, 100},
      {0, 103, 102},
      {0, 105, 104},
      {0, 107, 106},
      {0, 109, 108},
      {0, 56, 110},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeConstruct, 4), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(155, {
      {0, 0, 0},
      {18776483, 0, 0},
      {37009196, 0, 0},
      {277023757, 0, 0},
      {296981500, 0, 0},
      {348988933, 0, 0},
      {451264926, 0, 0},
      {564884461, 0, 0},
      {804899022, 0, 0},
      {810488476, 0, 0},
      {870594305, 0, 0},
      {876864198, 0, 0},
      {900522183, 0, 0},
      {928261291, 0, 0},
      {959681532, 0, 0},
      {1164724902, 0, 0},
      {1323407757, 0, 0},
      {1332774287, 0, 0},
      {1404739463, 0, 0},
      {1447712361, 0, 0},
      {1450415100, 0, 0},
      {1513770932, 0, 0},
      {1620634991, 0, 0},
      {1692600167, 0, 0},
      {1860649552, 0, 0},
      {1932614728, 0, 0},
      {2087004702, 0, 0},
      {2148510256, 0, 0},
      {2220475432, 0, 0},
      {2388524817, 0, 0},
      {2460489993, 0, 0},
      {2676385521, 0, 0},
      {2748350697, 0, 0},
      {2855506940, 0, 0},
      {2860348412, 0, 0},
      {2916400082, 0, 0},
      {2988365258, 0, 0},
      {3061856840, 0, 0},
      {3063508455, 0, 0},
      {3065160070, 0, 0},
      {3066811685, 0, 0},
      {3068463300, 0, 0},
      {3070114915, 0, 0},
      {3071766530, 0, 0},
      {3073418145, 0, 0},
      {3075069760, 0, 0},
      {3076721375, 0, 0},
      {3078372990, 0, 0},
      {3080024605, 0, 0},
      {3081676220, 0, 0},
      {3083327835, 0, 0},
      {3084979450, 0, 0},
      {3086631065, 0, 0},
      {3088282680, 0, 0},
      {3114708520, 0, 0},
      {3116360135, 0, 0},
      {3118011750, 0, 0},
      {3119663365, 0, 0},
      {3121314980, 0, 0},
      {3124618210, 0, 0},
      {3126269825, 0, 0},
      {3127921440, 0, 0},
      {3129573055, 0, 0},
      {3131224670, 0, 0},
      {3132876285, 0, 0},
      {3134527900, 0, 0},
      {3136179515, 0, 0},
      {3204260786, 0, 0},
      {3264086791, 0, 0},
      {3276225962, 0, 0},
      {3444275347, 0, 0},
      {3516240523, 0, 0},
      {3588205699, 0, 0},
      {3732136051, 0, 0},
      {3804101227, 0, 0},
      {3874089391, 0, 0},
      {4044115788, 0, 0},
      {4116080964, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 45, 43},
      {0, 3, 46},
      {0, 71, 36},
      {0, 44, 34},
      {0, 76, 54},
      {0, 73, 55},
      {0, 57, 67},
      {0, 51, 56},
      {0, 31, 27},
      {0, 38, 37},
      {0, 40, 39},
      {0, 42, 41},
      {0, 49, 47},
      {0, 35, 50},
      {0, 21, 70},
      {0, 19, 5},
      {0, 8, 58},
      {0, 17, 11},
      {0, 24, 18},
      {0, 30, 29},
      {0, 52, 9},
      {0, 77, 22},
      {0, 62, 48},
      {0, 25, 53},
      {0, 20, 59},
      {0, 26, 60},
      {0, 72, 6},
      {0, 79, 69},
      {0, 80, 7},
      {0, 81, 2},
      {0, 12, 13},
      {0, 82, 68},
      {0, 65, 61},
      {0, 74, 63},
      {0, 23, 83},
      {0, 64, 10},
      {0, 84, 32},
      {0, 66, 28},
      {0, 15, 85},
      {0, 86, 16},
      {0, 88, 87},
      {0, 90, 89},
      {0, 92, 91},
      {0, 1, 93},
      {0, 95, 94},
      {0, 97, 96},
      {0, 99, 98},
      {0, 100, 75},
      {0, 102, 101},
      {0, 104, 103},
      {0, 106, 105},
      {0, 107, 14},
      {0, 109, 108},
      {0, 111, 110},
      {0, 113, 112},
      {0, 115, 114},
      {0, 117, 116},
      {0, 119, 118},
      {0, 121, 120},
      {0, 123, 122},
      {0, 125, 124},
      {0, 127, 126},
      {0, 129, 128},
      {0, 131, 130},
      {0, 133, 132},
      {0, 135, 134},
      {0, 137, 136},
      {0, 139, 138},
      {0, 141, 140},
      {0, 143, 142},
      {0, 145, 144},
      {0, 147, 146},
      {0, 33, 148},
      {0, 4, 149},
      {0, 78, 150},
      {0, 152, 151},
      {0, 154, 153},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeConstruct, 5), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(11, {
      {0, 0, 0},
      {679771963, 0, 0},
      {789872778, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 6, 2},
      {0, 4, 7},
      {0, 1, 8},
      {0, 9, 5},
      {0, 3, 10},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeExtract, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(49, {
      {0, 0, 0},
      {126463145, 0, 0},
      {171307615, 0, 0},
      {342159236, 0, 0},
      {354479447, 0, 0},
      {593829839, 0, 0},
      {743407979, 0, 0},
      {898191441, 0, 0},
      {900522183, 0, 0},
      {1265796414, 0, 0},
      {1287304304, 0, 0},
      {1356063462, 0, 0},
      {1368383673, 0, 0},
      {1526654696, 0, 0},
      {1766994680, 0, 0},
      {1793544760, 0, 0},
      {1811839150, 0, 0},
      {2234361374, 0, 0},
      {2279700640, 0, 0},
      {2383939514, 0, 0},
      {2780898906, 0, 0},
      {2996594997, 0, 0},
      {3413713311, 0, 0},
      {3554463148, 0, 0},
      {3635542517, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 11, 15},
      {0, 20, 14},
      {0, 7, 18},
      {0, 6, 1},
      {0, 12, 10},
      {0, 23, 19},
      {0, 13, 5},
      {0, 24, 17},
      {0, 21, 3},
      {0, 22, 16},
      {0, 26, 2},
      {0, 27, 8},
      {0, 4, 28},
      {0, 29, 9},
      {0, 31, 30},
      {0, 33, 32},
      {0, 35, 34},
      {0, 37, 36},
      {0, 39, 38},
      {0, 41, 40},
      {0, 43, 42},
      {0, 45, 44},
      {0, 47, 46},
      {0, 25, 48},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeExtract, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(153, {
      {0, 0, 0},
      {13107491, 0, 0},
      {257136089, 0, 0},
      {293528591, 0, 0},
      {321459212, 0, 0},
      {425022309, 0, 0},
      {490769168, 0, 0},
      {495107308, 0, 0},
      {517919178, 0, 0},
      {617312262, 0, 0},
      {708736129, 0, 0},
      {753756604, 0, 0},
      {765238787, 0, 0},
      {796985462, 0, 0},
      {819503463, 0, 0},
      {850497536, 0, 0},
      {948086521, 0, 0},
      {1004589179, 0, 0},
      {1120149824, 0, 0},
      {1165671422, 0, 0},
      {1203545131, 0, 0},
      {1297165140, 0, 0},
      {1335363438, 0, 0},
      {1351676723, 0, 0},
      {1391866096, 0, 0},
      {1584369690, 0, 0},
      {1631216488, 0, 0},
      {1691646294, 0, 0},
      {1779143013, 0, 0},
      {1858116930, 0, 0},
      {1890300748, 0, 0},
      {1915438939, 0, 0},
      {1918742169, 0, 0},
      {1922045399, 0, 0},
      {1961990747, 0, 0},
      {2037710159, 0, 0},
      {2037814253, 0, 0},
      {2043873558, 0, 0},
      {2096388952, 0, 0},
      {2169307971, 0, 0},
      {2257843797, 0, 0},
      {2262220987, 0, 0},
      {2338272340, 0, 0},
      {2405770322, 0, 0},
      {2498042266, 0, 0},
      {2563789125, 0, 0},
      {2588618056, 0, 0},
      {2645120714, 0, 0},
      {2864863800, 0, 0},
      {2909957084, 0, 0},
      {2975894973, 0, 0},
      {3041450802, 0, 0},
      {3151638847, 0, 0},
      {3187066832, 0, 0},
      {3244716568, 0, 0},
      {3271748023, 0, 0},
      {3304438238, 0, 0},
      {3312467582, 0, 0},
      {3325419312, 0, 0},
      {3370185097, 0, 0},
      {3419674548, 0, 0},
      {3435931956, 0, 0},
      {3504158761, 0, 0},
      {3602522282, 0, 0},
      {3653059026, 0, 0},
      {3716353056, 0, 0},
      {3782099915, 0, 0},
      {3838648480, 0, 0},
      {3847846774, 0, 0},
      {3913593633, 0, 0},
      {3989799199, 0, 0},
      {3997038726, 0, 0},
      {4046301857, 0, 0},
      {4092654294, 0, 0},
      {4176581069, 0, 0},
      {4242327928, 0, 0},
      {4285652249, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 74, 38},
      {0, 12, 56},
      {0, 28, 24},
      {0, 60, 43},
      {0, 65, 72},
      {0, 18, 2},
      {0, 52, 3},
      {0, 19, 10},
      {0, 49, 36},
      {0, 67, 66},
      {0, 41, 17},
      {0, 53, 11},
      {0, 29, 68},
      {0, 26, 55},
      {0, 70, 76},
      {0, 73, 47},
      {0, 51, 22},
      {0, 39, 21},
      {0, 5, 9},
      {0, 40, 48},
      {0, 59, 44},
      {0, 6, 69},
      {0, 32, 31},
      {0, 4, 33},
      {0, 13, 54},
      {0, 14, 50},
      {0, 35, 75},
      {0, 58, 23},
      {0, 16, 34},
      {0, 27, 63},
      {0, 45, 61},
      {0, 20, 46},
      {0, 71, 1},
      {0, 79, 78},
      {0, 81, 80},
      {0, 83, 82},
      {0, 84, 8},
      {0, 86, 85},
      {0, 88, 87},
      {0, 90, 89},
      {0, 92, 91},
      {0, 94, 93},
      {0, 96, 95},
      {0, 98, 97},
      {0, 64, 99},
      {0, 101, 100},
      {0, 103, 102},
      {0, 105, 104},
      {0, 106, 62},
      {0, 108, 107},
      {0, 110, 109},
      {0, 7, 111},
      {0, 113, 112},
      {0, 115, 114},
      {0, 117, 116},
      {0, 119, 118},
      {0, 121, 120},
      {0, 123, 122},
      {0, 30, 124},
      {0, 126, 125},
      {0, 128, 127},
      {0, 130, 129},
      {0, 132, 131},
      {0, 134, 133},
      {0, 135, 25},
      {0, 57, 136},
      {0, 138, 137},
      {0, 42, 139},
      {0, 37, 140},
      {0, 142, 141},
      {0, 143, 15},
      {0, 145, 144},
      {0, 147, 146},
      {0, 149, 148},
      {0, 151, 150},
      {0, 152, 77},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeExtract, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(47, {
      {0, 0, 0},
      {545678922, 0, 0},
      {630592085, 0, 0},
      {679771963, 0, 0},
      {899570100, 0, 0},
      {906176560, 0, 0},
      {929101967, 0, 0},
      {1100599986, 0, 0},
      {1103903216, 0, 0},
      {1107206446, 0, 0},
      {1369578001, 0, 0},
      {1372881231, 0, 0},
      {2320303498, 0, 0},
      {2926633629, 0, 0},
      {3249265647, 0, 0},
      {3334207724, 0, 0},
      {3486057732, 0, 0},
      {3674863070, 0, 0},
      {3705139860, 0, 0},
      {3800912395, 0, 0},
      {3802564010, 0, 0},
      {3822983876, 0, 0},
      {4141567741, 0, 0},
      {4292991777, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 9, 17},
      {0, 20, 11},
      {0, 25, 5},
      {0, 2, 14},
      {0, 23, 13},
      {0, 16, 26},
      {0, 27, 24},
      {0, 28, 8},
      {0, 29, 18},
      {0, 22, 30},
      {0, 6, 31},
      {0, 21, 32},
      {0, 3, 33},
      {0, 35, 34},
      {0, 1, 12},
      {0, 10, 36},
      {0, 37, 19},
      {0, 4, 15},
      {0, 39, 38},
      {0, 7, 40},
      {0, 42, 41},
      {0, 44, 43},
      {0, 46, 45},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeInsert, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(103, {
      {0, 0, 0},
      {125792961, 0, 0},
      {132755933, 0, 0},
      {156014509, 0, 0},
      {436066778, 0, 0},
      {463084678, 0, 0},
      {531559080, 0, 0},
      {565233904, 0, 0},
      {578132535, 0, 0},
      {600906020, 0, 0},
      {602222721, 0, 0},
      {694743357, 0, 0},
      {760554870, 0, 0},
      {996663016, 0, 0},
      {1022309772, 0, 0},
      {1351676723, 0, 0},
      {1496901698, 0, 0},
      {1502470404, 0, 0},
      {1522901980, 0, 0},
      {1548254487, 0, 0},
      {1637661947, 0, 0},
      {1788504755, 0, 0},
      {2092468906, 0, 0},
      {2094647776, 0, 0},
      {2127660080, 0, 0},
      {2213946343, 0, 0},
      {2225172640, 0, 0},
      {2259467579, 0, 0},
      {2263866576, 0, 0},
      {2600961503, 0, 0},
      {2727022058, 0, 0},
      {2752967311, 0, 0},
      {2864705739, 0, 0},
      {3021406120, 0, 0},
      {3044723416, 0, 0},
      {3052439312, 0, 0},
      {3136865519, 0, 0},
      {3297860332, 0, 0},
      {3352361837, 0, 0},
      {3670298840, 0, 0},
      {3712946115, 0, 0},
      {3732709413, 0, 0},
      {3764662384, 0, 0},
      {3788324110, 0, 0},
      {3928555688, 0, 0},
      {4083347580, 0, 0},
      {4098876453, 0, 0},
      {4147239510, 0, 0},
      {4199470013, 0, 0},
      {4211577142, 0, 0},
      {4218799564, 0, 0},
      {4290374884, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 2},
      {0, 9, 8},
      {0, 17, 10},
      {0, 20, 18},
      {0, 22, 21},
      {0, 26, 23},
      {0, 31, 29},
      {0, 35, 34},
      {0, 45, 36},
      {0, 5, 3},
      {0, 12, 6},
      {0, 15, 14},
      {0, 25, 19},
      {0, 28, 27},
      {0, 38, 33},
      {0, 43, 39},
      {0, 47, 46},
      {0, 50, 49},
      {0, 7, 51},
      {0, 1, 48},
      {0, 37, 24},
      {0, 44, 42},
      {0, 13, 11},
      {0, 41, 40},
      {0, 54, 53},
      {0, 56, 55},
      {0, 58, 57},
      {0, 60, 59},
      {0, 62, 61},
      {0, 64, 63},
      {0, 66, 65},
      {0, 68, 67},
      {0, 70, 69},
      {0, 72, 71},
      {0, 30, 16},
      {0, 73, 32},
      {0, 75, 74},
      {0, 77, 76},
      {0, 79, 78},
      {0, 81, 80},
      {0, 83, 82},
      {0, 85, 84},
      {0, 87, 86},
      {0, 89, 88},
      {0, 91, 90},
      {0, 93, 92},
      {0, 95, 94},
      {0, 97, 96},
      {0, 99, 98},
      {0, 101, 100},
      {0, 52, 102},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeInsert, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(93, {
      {0, 0, 0},
      {17185761, 0, 0},
      {117250846, 0, 0},
      {296981500, 0, 0},
      {330388453, 0, 0},
      {346929928, 0, 0},
      {533021259, 0, 0},
      {564302770, 0, 0},
      {680157484, 0, 0},
      {721450866, 0, 0},
      {798549062, 0, 0},
      {853200279, 0, 0},
      {864295921, 0, 0},
      {900522183, 0, 0},
      {973908139, 0, 0},
      {983243705, 0, 0},
      {1033363654, 0, 0},
      {1037370721, 0, 0},
      {1464587427, 0, 0},
      {1670691893, 0, 0},
      {1686512349, 0, 0},
      {1849065716, 0, 0},
      {1917602962, 0, 0},
      {1965902997, 0, 0},
      {2121980967, 0, 0},
      {2311072371, 0, 0},
      {2339901602, 0, 0},
      {2517964682, 0, 0},
      {2542834724, 0, 0},
      {2558655180, 0, 0},
      {2736881867, 0, 0},
      {2855506940, 0, 0},
      {2888753905, 0, 0},
      {2950446516, 0, 0},
      {3044188332, 0, 0},
      {3079287749, 0, 0},
      {3153451899, 0, 0},
      {3214537066, 0, 0},
      {3234673086, 0, 0},
      {3349230696, 0, 0},
      {3504158761, 0, 0},
      {3570411982, 0, 0},
      {3652695478, 0, 0},
      {3764205609, 0, 0},
      {3940720663, 0, 0},
      {4180570743, 0, 0},
      {4221373527, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 24, 18},
      {0, 4, 2},
      {0, 15, 14},
      {0, 21, 20},
      {0, 29, 26},
      {0, 42, 36},
      {0, 7, 45},
      {0, 37, 9},
      {0, 8, 5},
      {0, 32, 11},
      {0, 39, 38},
      {0, 12, 10},
      {0, 28, 19},
      {0, 1, 46},
      {0, 17, 6},
      {0, 30, 23},
      {0, 44, 33},
      {0, 35, 13},
      {0, 16, 48},
      {0, 50, 49},
      {0, 52, 51},
      {0, 54, 53},
      {0, 55, 40},
      {0, 57, 56},
      {0, 59, 58},
      {0, 61, 60},
      {0, 25, 22},
      {0, 63, 62},
      {0, 3, 64},
      {0, 66, 65},
      {0, 68, 67},
      {0, 70, 69},
      {0, 34, 71},
      {0, 73, 72},
      {0, 75, 74},
      {0, 77, 76},
      {0, 27, 43},
      {0, 79, 78},
      {0, 81, 80},
      {0, 83, 82},
      {0, 84, 31},
      {0, 86, 85},
      {0, 41, 87},
      {0, 89, 88},
      {0, 91, 90},
      {0, 47, 92},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeInsert, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(115, {
      {0, 0, 0},
      {132755933, 0, 0},
      {156014509, 0, 0},
      {255227811, 0, 0},
      {371186900, 0, 0},
      {371428004, 0, 0},
      {374731234, 0, 0},
      {531559080, 0, 0},
      {565233904, 0, 0},
      {578132535, 0, 0},
      {591140762, 0, 0},
      {600906020, 0, 0},
      {602222721, 0, 0},
      {656610661, 0, 0},
      {760554870, 0, 0},
      {996663016, 0, 0},
      {1022309772, 0, 0},
      {1496901698, 0, 0},
      {1502470404, 0, 0},
      {1522901980, 0, 0},
      {1536350567, 0, 0},
      {1543280290, 0, 0},
      {1548254487, 0, 0},
      {1788504755, 0, 0},
      {2064733527, 0, 0},
      {2092468906, 0, 0},
      {2094647776, 0, 0},
      {2162986400, 0, 0},
      {2225172640, 0, 0},
      {2259467579, 0, 0},
      {2263866576, 0, 0},
      {2360004627, 0, 0},
      {2507709226, 0, 0},
      {2600961503, 0, 0},
      {2727022058, 0, 0},
      {2752967311, 0, 0},
      {2864705739, 0, 0},
      {3021406120, 0, 0},
      {3052439312, 0, 0},
      {3136865519, 0, 0},
      {3297860332, 0, 0},
      {3352361837, 0, 0},
      {3598957382, 0, 0},
      {3619787319, 0, 0},
      {3655201337, 0, 0},
      {3670298840, 0, 0},
      {3774892253, 0, 0},
      {3788324110, 0, 0},
      {3808408202, 0, 0},
      {3951925872, 0, 0},
      {3952316364, 0, 0},
      {4098876453, 0, 0},
      {4147239510, 0, 0},
      {4199470013, 0, 0},
      {4211577142, 0, 0},
      {4217306348, 0, 0},
      {4218799564, 0, 0},
      {4290374884, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 6, 43},
      {0, 4, 1},
      {0, 11, 9},
      {0, 13, 12},
      {0, 19, 18},
      {0, 25, 23},
      {0, 28, 26},
      {0, 35, 33},
      {0, 39, 38},
      {0, 2, 49},
      {0, 7, 3},
      {0, 16, 14},
      {0, 29, 22},
      {0, 37, 30},
      {0, 45, 41},
      {0, 51, 47},
      {0, 54, 52},
      {0, 57, 56},
      {0, 53, 8},
      {0, 32, 10},
      {0, 42, 40},
      {0, 24, 46},
      {0, 15, 50},
      {0, 55, 20},
      {0, 59, 44},
      {0, 61, 60},
      {0, 63, 62},
      {0, 65, 64},
      {0, 67, 66},
      {0, 69, 68},
      {0, 71, 70},
      {0, 73, 72},
      {0, 75, 74},
      {0, 77, 76},
      {0, 31, 17},
      {0, 36, 34},
      {0, 79, 78},
      {0, 81, 80},
      {0, 27, 82},
      {0, 5, 21},
      {0, 48, 83},
      {0, 85, 84},
      {0, 87, 86},
      {0, 89, 88},
      {0, 91, 90},
      {0, 93, 92},
      {0, 95, 94},
      {0, 97, 96},
      {0, 99, 98},
      {0, 101, 100},
      {0, 103, 102},
      {0, 105, 104},
      {0, 107, 106},
      {0, 109, 108},
      {0, 111, 110},
      {0, 113, 112},
      {0, 58, 114},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpCompositeInsert, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {3866587616, 0, 0},
      {3868239231, 0, 0},
      {3869890846, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 4},
      {0, 2, 5},
      {0, 3, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpSampledImage, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {1164218401, 0, 0},
      {2036361232, 0, 0},
      {2637132451, 0, 0},
      {3237903670, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 5},
      {0, 3, 6},
      {0, 1, 7},
      {0, 2, 8},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpSampledImage, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {543558236, 0, 0},
      {1069781886, 0, 0},
      {1596005536, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 4},
      {0, 2, 5},
      {0, 1, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpSampledImage, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {1949759310, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpSampledImage, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpImageSampleImplicitLod, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(87, {
      {0, 0, 0},
      {236660303, 0, 0},
      {347505241, 0, 0},
      {426360862, 0, 0},
      {439998433, 0, 0},
      {488500848, 0, 0},
      {495107308, 0, 0},
      {868652905, 0, 0},
      {1191735827, 0, 0},
      {1265998516, 0, 0},
      {1309728002, 0, 0},
      {1365842164, 0, 0},
      {1396344138, 0, 0},
      {1508074873, 0, 0},
      {1553476262, 0, 0},
      {1642818143, 0, 0},
      {1851510470, 0, 0},
      {1858116930, 0, 0},
      {1863199739, 0, 0},
      {1979978194, 0, 0},
      {1986584654, 0, 0},
      {2092100514, 0, 0},
      {2098706974, 0, 0},
      {2231688008, 0, 0},
      {2232491275, 0, 0},
      {2329992200, 0, 0},
      {2637935122, 0, 0},
      {2693892518, 0, 0},
      {2759250216, 0, 0},
      {2839765116, 0, 0},
      {2855895374, 0, 0},
      {2913136690, 0, 0},
      {3012980338, 0, 0},
      {3327770644, 0, 0},
      {3362344229, 0, 0},
      {3398925952, 0, 0},
      {3448018532, 0, 0},
      {3457985288, 0, 0},
      {3566035349, 0, 0},
      {3657635382, 0, 0},
      {3702405475, 0, 0},
      {3757479030, 0, 0},
      {3797204453, 0, 0},
      {4291477370, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 32, 28},
      {0, 9, 35},
      {0, 31, 11},
      {0, 10, 30},
      {0, 25, 21},
      {0, 40, 2},
      {0, 15, 19},
      {0, 24, 36},
      {0, 42, 4},
      {0, 18, 16},
      {0, 29, 26},
      {0, 43, 7},
      {0, 45, 8},
      {0, 37, 13},
      {0, 47, 46},
      {0, 48, 33},
      {0, 49, 14},
      {0, 3, 22},
      {0, 50, 12},
      {0, 41, 39},
      {0, 51, 34},
      {0, 52, 20},
      {0, 54, 53},
      {0, 56, 55},
      {0, 58, 57},
      {0, 60, 59},
      {0, 61, 23},
      {0, 63, 62},
      {0, 65, 64},
      {0, 27, 66},
      {0, 67, 38},
      {0, 68, 17},
      {0, 70, 69},
      {0, 72, 71},
      {0, 74, 73},
      {0, 76, 75},
      {0, 5, 77},
      {0, 78, 1},
      {0, 80, 79},
      {0, 82, 81},
      {0, 83, 6},
      {0, 85, 84},
      {0, 44, 86},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpImageSampleImplicitLod, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(15, {
      {0, 0, 0},
      {883854656, 0, 0},
      {1962971231, 0, 0},
      {2036361232, 0, 0},
      {2356768706, 0, 0},
      {2637132451, 0, 0},
      {3237903670, 0, 0},
      {3829682756, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 8, 2},
      {0, 6, 9},
      {0, 10, 7},
      {0, 4, 5},
      {0, 12, 11},
      {0, 3, 13},
      {0, 14, 1},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpImageSampleImplicitLod, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(87, {
      {0, 0, 0},
      {150685616, 0, 0},
      {255302575, 0, 0},
      {414620710, 0, 0},
      {557400685, 0, 0},
      {575205902, 0, 0},
      {618761615, 0, 0},
      {646282397, 0, 0},
      {686024761, 0, 0},
      {740921498, 0, 0},
      {921246433, 0, 0},
      {1057578789, 0, 0},
      {1162127370, 0, 0},
      {1329499601, 0, 0},
      {1352628475, 0, 0},
      {1502028603, 0, 0},
      {1519723107, 0, 0},
      {1543798545, 0, 0},
      {1545450160, 0, 0},
      {1570165302, 0, 0},
      {1600392975, 0, 0},
      {1641415225, 0, 0},
      {2204920111, 0, 0},
      {2257971049, 0, 0},
      {2276405827, 0, 0},
      {2339018837, 0, 0},
      {2340670452, 0, 0},
      {2517964682, 0, 0},
      {2532518896, 0, 0},
      {2674090849, 0, 0},
      {2754074729, 0, 0},
      {2804281092, 0, 0},
      {2816338013, 0, 0},
      {2841008029, 0, 0},
      {3234673086, 0, 0},
      {3249261197, 0, 0},
      {3619787319, 0, 0},
      {3627739127, 0, 0},
      {3669223677, 0, 0},
      {3787567939, 0, 0},
      {3898287302, 0, 0},
      {4142016703, 0, 0},
      {4237092412, 0, 0},
      {4285779501, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 16, 15},
      {0, 2, 33},
      {0, 41, 35},
      {0, 32, 30},
      {0, 39, 38},
      {0, 5, 1},
      {0, 9, 43},
      {0, 40, 22},
      {0, 29, 12},
      {0, 4, 3},
      {0, 25, 37},
      {0, 34, 26},
      {0, 45, 19},
      {0, 31, 24},
      {0, 47, 46},
      {0, 48, 20},
      {0, 49, 6},
      {0, 8, 21},
      {0, 50, 11},
      {0, 13, 10},
      {0, 51, 42},
      {0, 52, 23},
      {0, 54, 53},
      {0, 56, 55},
      {0, 58, 57},
      {0, 60, 59},
      {0, 61, 28},
      {0, 63, 62},
      {0, 65, 64},
      {0, 17, 66},
      {0, 67, 18},
      {0, 68, 7},
      {0, 70, 69},
      {0, 72, 71},
      {0, 74, 73},
      {0, 76, 75},
      {0, 14, 77},
      {0, 78, 27},
      {0, 80, 79},
      {0, 82, 81},
      {0, 83, 36},
      {0, 85, 84},
      {0, 44, 86},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpImageSampleImplicitLod, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {2855506940, 0, 0},
      {3266548732, 0, 0},
      {3732640764, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 1},
      {0, 5, 4},
      {0, 3, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpImageSampleImplicitLod, 5), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpImageSampleExplicitLod, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(139, {
      {0, 0, 0},
      {27177503, 0, 0},
      {30663912, 0, 0},
      {151672195, 0, 0},
      {162608772, 0, 0},
      {180913835, 0, 0},
      {371621315, 0, 0},
      {414444763, 0, 0},
      {421602934, 0, 0},
      {443347828, 0, 0},
      {458937500, 0, 0},
      {587888644, 0, 0},
      {601656217, 0, 0},
      {665789406, 0, 0},
      {712168842, 0, 0},
      {730943059, 0, 0},
      {750870327, 0, 0},
      {875212982, 0, 0},
      {899320334, 0, 0},
      {973908139, 0, 0},
      {989813600, 0, 0},
      {1057606514, 0, 0},
      {1171541710, 0, 0},
      {1243764146, 0, 0},
      {1310404265, 0, 0},
      {1366337101, 0, 0},
      {1443547269, 0, 0},
      {1472185378, 0, 0},
      {1473799048, 0, 0},
      {1543935193, 0, 0},
      {1572834111, 0, 0},
      {1623013158, 0, 0},
      {1686512349, 0, 0},
      {1705716306, 0, 0},
      {1747355813, 0, 0},
      {1755165354, 0, 0},
      {1781864804, 0, 0},
      {1916983087, 0, 0},
      {1941403425, 0, 0},
      {2023008475, 0, 0},
      {2043684541, 0, 0},
      {2274226560, 0, 0},
      {2285438321, 0, 0},
      {2315690100, 0, 0},
      {2344328209, 0, 0},
      {2414725163, 0, 0},
      {2493146691, 0, 0},
      {2495155989, 0, 0},
      {2558655180, 0, 0},
      {2577859137, 0, 0},
      {2857814560, 0, 0},
      {2895151306, 0, 0},
      {2986830770, 0, 0},
      {3006548167, 0, 0},
      {3127329373, 0, 0},
      {3157581152, 0, 0},
      {3216471040, 0, 0},
      {3296722158, 0, 0},
      {3367298820, 0, 0},
      {3376009661, 0, 0},
      {3450001968, 0, 0},
      {3526837441, 0, 0},
      {3609540589, 0, 0},
      {3743398113, 0, 0},
      {3858973601, 0, 0},
      {3953984401, 0, 0},
      {3999472204, 0, 0},
      {4088613871, 0, 0},
      {4184019303, 0, 0},
      {4258229445, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 31, 16},
      {0, 58, 47},
      {0, 21, 61},
      {0, 6, 14},
      {0, 65, 23},
      {0, 35, 5},
      {0, 2, 7},
      {0, 10, 25},
      {0, 40, 22},
      {0, 9, 50},
      {0, 20, 11},
      {0, 38, 36},
      {0, 13, 12},
      {0, 67, 28},
      {0, 71, 68},
      {0, 73, 72},
      {0, 3, 29},
      {0, 27, 8},
      {0, 44, 37},
      {0, 74, 63},
      {0, 76, 75},
      {0, 18, 1},
      {0, 78, 77},
      {0, 80, 79},
      {0, 82, 81},
      {0, 26, 15},
      {0, 83, 43},
      {0, 85, 84},
      {0, 19, 86},
      {0, 48, 32},
      {0, 33, 46},
      {0, 87, 49},
      {0, 89, 88},
      {0, 91, 90},
      {0, 41, 30},
      {0, 52, 42},
      {0, 64, 55},
      {0, 92, 53},
      {0, 94, 93},
      {0, 51, 39},
      {0, 45, 95},
      {0, 66, 54},
      {0, 97, 96},
      {0, 57, 98},
      {0, 99, 69},
      {0, 101, 100},
      {0, 56, 102},
      {0, 4, 59},
      {0, 34, 17},
      {0, 103, 24},
      {0, 105, 104},
      {0, 107, 106},
      {0, 109, 108},
      {0, 60, 110},
      {0, 111, 62},
      {0, 113, 112},
      {0, 115, 114},
      {0, 117, 116},
      {0, 119, 118},
      {0, 121, 120},
      {0, 123, 122},
      {0, 125, 124},
      {0, 127, 126},
      {0, 129, 128},
      {0, 70, 130},
      {0, 132, 131},
      {0, 134, 133},
      {0, 136, 135},
      {0, 138, 137},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpImageSampleExplicitLod, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(11, {
      {0, 0, 0},
      {883854656, 0, 0},
      {1962971231, 0, 0},
      {2036361232, 0, 0},
      {2366506734, 0, 0},
      {3829682756, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 2},
      {0, 6, 7},
      {0, 8, 5},
      {0, 3, 9},
      {0, 1, 10},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpImageSampleExplicitLod, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(73, {
      {0, 0, 0},
      {178571546, 0, 0},
      {223310468, 0, 0},
      {388034151, 0, 0},
      {449954059, 0, 0},
      {694743357, 0, 0},
      {797415788, 0, 0},
      {835638766, 0, 0},
      {1002144380, 0, 0},
      {1221183390, 0, 0},
      {1570165302, 0, 0},
      {1663234329, 0, 0},
      {1750829822, 0, 0},
      {1894133125, 0, 0},
      {1967643923, 0, 0},
      {1980341560, 0, 0},
      {2278706468, 0, 0},
      {2326990117, 0, 0},
      {2464905186, 0, 0},
      {2511346984, 0, 0},
      {2517964682, 0, 0},
      {2616085763, 0, 0},
      {2710583246, 0, 0},
      {2745872368, 0, 0},
      {2924263085, 0, 0},
      {3027500544, 0, 0},
      {3044723416, 0, 0},
      {3202324433, 0, 0},
      {3289213933, 0, 0},
      {3323682385, 0, 0},
      {3366848728, 0, 0},
      {3417583519, 0, 0},
      {3732916270, 0, 0},
      {3787909072, 0, 0},
      {3877813395, 0, 0},
      {4028028350, 0, 0},
      {4178218543, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 36, 31},
      {0, 15, 3},
      {0, 17, 1},
      {0, 24, 12},
      {0, 35, 34},
      {0, 28, 27},
      {0, 21, 38},
      {0, 6, 13},
      {0, 14, 7},
      {0, 39, 25},
      {0, 40, 30},
      {0, 42, 41},
      {0, 32, 43},
      {0, 23, 9},
      {0, 11, 44},
      {0, 45, 22},
      {0, 47, 46},
      {0, 2, 16},
      {0, 49, 48},
      {0, 4, 50},
      {0, 51, 18},
      {0, 53, 52},
      {0, 33, 54},
      {0, 26, 55},
      {0, 57, 56},
      {0, 5, 58},
      {0, 59, 8},
      {0, 19, 60},
      {0, 10, 61},
      {0, 29, 62},
      {0, 37, 63},
      {0, 65, 64},
      {0, 67, 66},
      {0, 20, 68},
      {0, 70, 69},
      {0, 72, 71},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpImageSampleExplicitLod, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {2855506940, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpImageSampleExplicitLod, 5), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(13, {
      {0, 0, 0},
      {3533637837, 0, 0},
      {3535289452, 0, 0},
      {3536941067, 0, 0},
      {3538592682, 0, 0},
      {3540244297, 0, 0},
      {3541895912, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 7},
      {0, 2, 8},
      {0, 9, 3},
      {0, 4, 10},
      {0, 5, 11},
      {0, 12, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpImageSampleExplicitLod, 6), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 5},
      {0, 2, 6},
      {0, 1, 3},
      {0, 8, 7},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFAdd, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(45, {
      {0, 0, 0},
      {328661377, 0, 0},
      {464259778, 0, 0},
      {920941800, 0, 0},
      {969500141, 0, 0},
      {1449907751, 0, 0},
      {1451831482, 0, 0},
      {1543798545, 0, 0},
      {1545450160, 0, 0},
      {1626224034, 0, 0},
      {1669930486, 0, 0},
      {1770165905, 0, 0},
      {2278571792, 0, 0},
      {2432827426, 0, 0},
      {2656211099, 0, 0},
      {2736844435, 0, 0},
      {2870852215, 0, 0},
      {2919626325, 0, 0},
      {2923708820, 0, 0},
      {3325419312, 0, 0},
      {3678875745, 0, 0},
      {4182141402, 0, 0},
      {4241374559, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 2, 6},
      {0, 9, 13},
      {0, 5, 15},
      {0, 4, 11},
      {0, 20, 22},
      {0, 10, 1},
      {0, 18, 14},
      {0, 16, 3},
      {0, 12, 21},
      {0, 8, 7},
      {0, 24, 17},
      {0, 19, 25},
      {0, 27, 26},
      {0, 29, 28},
      {0, 31, 30},
      {0, 33, 32},
      {0, 35, 34},
      {0, 37, 36},
      {0, 39, 38},
      {0, 41, 40},
      {0, 43, 42},
      {0, 23, 44},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFAdd, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(89, {
      {0, 0, 0},
      {135920445, 0, 0},
      {176166202, 0, 0},
      {294390719, 0, 0},
      {296981500, 0, 0},
      {743407979, 0, 0},
      {810488476, 0, 0},
      {837715723, 0, 0},
      {885020215, 0, 0},
      {922996215, 0, 0},
      {959681532, 0, 0},
      {963902061, 0, 0},
      {1136775085, 0, 0},
      {1189681639, 0, 0},
      {1203545131, 0, 0},
      {1297294717, 0, 0},
      {1317058015, 0, 0},
      {1352397672, 0, 0},
      {1367301635, 0, 0},
      {1412908157, 0, 0},
      {1570165302, 0, 0},
      {1763758554, 0, 0},
      {1791427568, 0, 0},
      {1992893964, 0, 0},
      {2013867381, 0, 0},
      {2096388952, 0, 0},
      {2219733501, 0, 0},
      {2383939514, 0, 0},
      {2517964682, 0, 0},
      {2555315060, 0, 0},
      {2572638469, 0, 0},
      {2762094724, 0, 0},
      {2770161927, 0, 0},
      {2855506940, 0, 0},
      {3044188332, 0, 0},
      {3187066832, 0, 0},
      {3319278167, 0, 0},
      {3653838348, 0, 0},
      {3675926744, 0, 0},
      {3701632935, 0, 0},
      {3712946115, 0, 0},
      {3732709413, 0, 0},
      {3743748793, 0, 0},
      {3783543823, 0, 0},
      {3930727258, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 15, 12},
      {0, 38, 16},
      {0, 41, 40},
      {0, 1, 33},
      {0, 21, 34},
      {0, 9, 2},
      {0, 24, 7},
      {0, 39, 44},
      {0, 29, 22},
      {0, 17, 19},
      {0, 36, 32},
      {0, 26, 18},
      {0, 30, 3},
      {0, 11, 8},
      {0, 42, 35},
      {0, 46, 31},
      {0, 27, 5},
      {0, 48, 47},
      {0, 28, 49},
      {0, 51, 50},
      {0, 52, 23},
      {0, 54, 53},
      {0, 13, 14},
      {0, 6, 55},
      {0, 57, 56},
      {0, 59, 58},
      {0, 60, 43},
      {0, 62, 61},
      {0, 37, 63},
      {0, 65, 64},
      {0, 67, 66},
      {0, 69, 68},
      {0, 70, 4},
      {0, 10, 71},
      {0, 72, 20},
      {0, 74, 73},
      {0, 76, 75},
      {0, 78, 77},
      {0, 80, 79},
      {0, 81, 25},
      {0, 83, 82},
      {0, 85, 84},
      {0, 87, 86},
      {0, 45, 88},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFAdd, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(103, {
      {0, 0, 0},
      {126463145, 0, 0},
      {220008971, 0, 0},
      {246375791, 0, 0},
      {503145996, 0, 0},
      {628331516, 0, 0},
      {643418617, 0, 0},
      {743407979, 0, 0},
      {837715723, 0, 0},
      {858902117, 0, 0},
      {870594305, 0, 0},
      {939671928, 0, 0},
      {959681532, 0, 0},
      {1051471757, 0, 0},
      {1092948665, 0, 0},
      {1097775533, 0, 0},
      {1136775085, 0, 0},
      {1140367371, 0, 0},
      {1332643570, 0, 0},
      {1367301635, 0, 0},
      {1558001705, 0, 0},
      {1684282922, 0, 0},
      {2096388952, 0, 0},
      {2183547611, 0, 0},
      {2219733501, 0, 0},
      {2358141757, 0, 0},
      {2359973133, 0, 0},
      {2383939514, 0, 0},
      {2444465148, 0, 0},
      {2517964682, 0, 0},
      {2567901801, 0, 0},
      {2598189097, 0, 0},
      {2655147757, 0, 0},
      {2683080096, 0, 0},
      {2705434194, 0, 0},
      {2738307068, 0, 0},
      {2780898906, 0, 0},
      {3030911670, 0, 0},
      {3032677281, 0, 0},
      {3063300848, 0, 0},
      {3277199633, 0, 0},
      {3289969989, 0, 0},
      {3401762422, 0, 0},
      {3436143898, 0, 0},
      {3560552546, 0, 0},
      {3656163446, 0, 0},
      {3675926744, 0, 0},
      {3701632935, 0, 0},
      {3743748793, 0, 0},
      {3752211294, 0, 0},
      {3794803132, 0, 0},
      {4241374559, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 21},
      {0, 17, 11},
      {0, 36, 35},
      {0, 46, 45},
      {0, 50, 49},
      {0, 9, 3},
      {0, 20, 47},
      {0, 37, 31},
      {0, 2, 34},
      {0, 40, 13},
      {0, 51, 32},
      {0, 41, 10},
      {0, 38, 19},
      {0, 18, 44},
      {0, 43, 16},
      {0, 48, 24},
      {0, 26, 5},
      {0, 53, 8},
      {0, 15, 7},
      {0, 25, 23},
      {0, 54, 27},
      {0, 56, 55},
      {0, 58, 57},
      {0, 60, 59},
      {0, 39, 42},
      {0, 62, 61},
      {0, 30, 63},
      {0, 4, 64},
      {0, 65, 28},
      {0, 66, 22},
      {0, 68, 67},
      {0, 69, 14},
      {0, 70, 33},
      {0, 71, 6},
      {0, 73, 72},
      {0, 75, 74},
      {0, 29, 76},
      {0, 78, 77},
      {0, 80, 79},
      {0, 82, 81},
      {0, 84, 83},
      {0, 86, 85},
      {0, 88, 87},
      {0, 90, 89},
      {0, 91, 12},
      {0, 93, 92},
      {0, 95, 94},
      {0, 97, 96},
      {0, 99, 98},
      {0, 101, 100},
      {0, 52, 102},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFAdd, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 5},
      {0, 4, 6},
      {0, 1, 7},
      {0, 2, 8},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFSub, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(159, {
      {0, 0, 0},
      {50385656, 0, 0},
      {117250846, 0, 0},
      {171494987, 0, 0},
      {195244192, 0, 0},
      {210754155, 0, 0},
      {265392489, 0, 0},
      {333855951, 0, 0},
      {416853049, 0, 0},
      {529068443, 0, 0},
      {533021259, 0, 0},
      {615982737, 0, 0},
      {660038281, 0, 0},
      {663341511, 0, 0},
      {669812542, 0, 0},
      {716890919, 0, 0},
      {1081536219, 0, 0},
      {1119744229, 0, 0},
      {1123617794, 0, 0},
      {1139547465, 0, 0},
      {1162789888, 0, 0},
      {1178317551, 0, 0},
      {1190147516, 0, 0},
      {1193734351, 0, 0},
      {1215030156, 0, 0},
      {1220749418, 0, 0},
      {1318479490, 0, 0},
      {1461398554, 0, 0},
      {1486207619, 0, 0},
      {1551372768, 0, 0},
      {1763758554, 0, 0},
      {1797960910, 0, 0},
      {1850331254, 0, 0},
      {1894417995, 0, 0},
      {1964254745, 0, 0},
      {1965902997, 0, 0},
      {1989327599, 0, 0},
      {2095027856, 0, 0},
      {2123683379, 0, 0},
      {2124837447, 0, 0},
      {2137526937, 0, 0},
      {2269114589, 0, 0},
      {2269130237, 0, 0},
      {2330636993, 0, 0},
      {2481746922, 0, 0},
      {2503770904, 0, 0},
      {2589449658, 0, 0},
      {2603020391, 0, 0},
      {2604576561, 0, 0},
      {2795773560, 0, 0},
      {2835131395, 0, 0},
      {2852854788, 0, 0},
      {2890638791, 0, 0},
      {2895413148, 0, 0},
      {2950446516, 0, 0},
      {2963744582, 0, 0},
      {3079287749, 0, 0},
      {3088785099, 0, 0},
      {3280064277, 0, 0},
      {3335250889, 0, 0},
      {3510242586, 0, 0},
      {3517169445, 0, 0},
      {3518703473, 0, 0},
      {3536471583, 0, 0},
      {3579593979, 0, 0},
      {3591222197, 0, 0},
      {3673811979, 0, 0},
      {3727034815, 0, 0},
      {3730093054, 0, 0},
      {3898287302, 0, 0},
      {3944781937, 0, 0},
      {3950980241, 0, 0},
      {4033586023, 0, 0},
      {4041974454, 0, 0},
      {4052965752, 0, 0},
      {4083161638, 0, 0},
      {4167600590, 0, 0},
      {4185661467, 0, 0},
      {4237092412, 0, 0},
      {4244540017, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 44, 18},
      {0, 69, 57},
      {0, 24, 16},
      {0, 79, 5},
      {0, 59, 4},
      {0, 76, 40},
      {0, 53, 45},
      {0, 14, 2},
      {0, 62, 61},
      {0, 33, 75},
      {0, 38, 37},
      {0, 42, 58},
      {0, 66, 47},
      {0, 63, 67},
      {0, 1, 7},
      {0, 10, 3},
      {0, 13, 12},
      {0, 23, 22},
      {0, 32, 28},
      {0, 36, 35},
      {0, 72, 49},
      {0, 74, 73},
      {0, 77, 55},
      {0, 27, 41},
      {0, 31, 15},
      {0, 6, 54},
      {0, 78, 17},
      {0, 81, 56},
      {0, 83, 82},
      {0, 85, 84},
      {0, 48, 30},
      {0, 71, 60},
      {0, 65, 51},
      {0, 87, 86},
      {0, 50, 34},
      {0, 89, 88},
      {0, 90, 9},
      {0, 25, 8},
      {0, 92, 91},
      {0, 93, 26},
      {0, 95, 94},
      {0, 52, 39},
      {0, 29, 20},
      {0, 97, 96},
      {0, 99, 98},
      {0, 101, 100},
      {0, 64, 102},
      {0, 104, 103},
      {0, 106, 105},
      {0, 21, 107},
      {0, 108, 68},
      {0, 109, 46},
      {0, 110, 11},
      {0, 112, 111},
      {0, 114, 113},
      {0, 116, 115},
      {0, 117, 70},
      {0, 43, 118},
      {0, 120, 119},
      {0, 122, 121},
      {0, 124, 123},
      {0, 126, 125},
      {0, 128, 127},
      {0, 129, 19},
      {0, 131, 130},
      {0, 133, 132},
      {0, 135, 134},
      {0, 137, 136},
      {0, 139, 138},
      {0, 141, 140},
      {0, 143, 142},
      {0, 145, 144},
      {0, 147, 146},
      {0, 149, 148},
      {0, 151, 150},
      {0, 153, 152},
      {0, 155, 154},
      {0, 157, 156},
      {0, 158, 80},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFSub, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(103, {
      {0, 0, 0},
      {50998433, 0, 0},
      {171494987, 0, 0},
      {249378857, 0, 0},
      {296981500, 0, 0},
      {508007510, 0, 0},
      {610429940, 0, 0},
      {660038281, 0, 0},
      {663341511, 0, 0},
      {836581417, 0, 0},
      {1027242654, 0, 0},
      {1167160774, 0, 0},
      {1191015885, 0, 0},
      {1200870684, 0, 0},
      {1203545131, 0, 0},
      {1265796414, 0, 0},
      {1319785741, 0, 0},
      {1669959736, 0, 0},
      {1684282922, 0, 0},
      {1752686878, 0, 0},
      {1850331254, 0, 0},
      {1901166356, 0, 0},
      {1906988301, 0, 0},
      {2055836767, 0, 0},
      {2095027856, 0, 0},
      {2096388952, 0, 0},
      {2144962711, 0, 0},
      {2217833278, 0, 0},
      {2500819054, 0, 0},
      {2525173102, 0, 0},
      {2575525651, 0, 0},
      {2660843182, 0, 0},
      {2855506940, 0, 0},
      {2918750759, 0, 0},
      {2919787747, 0, 0},
      {3091876332, 0, 0},
      {3187066832, 0, 0},
      {3244209297, 0, 0},
      {3423702268, 0, 0},
      {3508792859, 0, 0},
      {3548535223, 0, 0},
      {3619787319, 0, 0},
      {3653838348, 0, 0},
      {3692647551, 0, 0},
      {3713290482, 0, 0},
      {3753486980, 0, 0},
      {3783756895, 0, 0},
      {3797961332, 0, 0},
      {3836822275, 0, 0},
      {4043078107, 0, 0},
      {4052965752, 0, 0},
      {4091394002, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 31, 49},
      {0, 24, 19},
      {0, 46, 45},
      {0, 6, 48},
      {0, 12, 33},
      {0, 17, 21},
      {0, 43, 11},
      {0, 7, 2},
      {0, 9, 8},
      {0, 28, 13},
      {0, 44, 38},
      {0, 30, 50},
      {0, 26, 22},
      {0, 29, 51},
      {0, 34, 37},
      {0, 53, 40},
      {0, 23, 54},
      {0, 55, 25},
      {0, 27, 18},
      {0, 1, 10},
      {0, 57, 56},
      {0, 59, 58},
      {0, 5, 47},
      {0, 60, 20},
      {0, 62, 61},
      {0, 64, 63},
      {0, 66, 65},
      {0, 67, 39},
      {0, 69, 68},
      {0, 16, 70},
      {0, 3, 71},
      {0, 73, 72},
      {0, 41, 15},
      {0, 35, 74},
      {0, 76, 75},
      {0, 78, 77},
      {0, 36, 79},
      {0, 81, 80},
      {0, 83, 82},
      {0, 14, 84},
      {0, 86, 85},
      {0, 88, 87},
      {0, 32, 89},
      {0, 42, 90},
      {0, 92, 91},
      {0, 94, 93},
      {0, 96, 95},
      {0, 98, 97},
      {0, 52, 99},
      {0, 100, 4},
      {0, 102, 101},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFSub, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(157, {
      {0, 0, 0},
      {49456560, 0, 0},
      {170690025, 0, 0},
      {243178923, 0, 0},
      {295017943, 0, 0},
      {296981500, 0, 0},
      {330249537, 0, 0},
      {435256475, 0, 0},
      {443558693, 0, 0},
      {456043370, 0, 0},
      {470277359, 0, 0},
      {592180731, 0, 0},
      {663258455, 0, 0},
      {706238670, 0, 0},
      {810488476, 0, 0},
      {870594305, 0, 0},
      {877895868, 0, 0},
      {900522183, 0, 0},
      {1077859090, 0, 0},
      {1082941229, 0, 0},
      {1104362365, 0, 0},
      {1132589448, 0, 0},
      {1173092699, 0, 0},
      {1203545131, 0, 0},
      {1265796414, 0, 0},
      {1278818058, 0, 0},
      {1285705317, 0, 0},
      {1319785741, 0, 0},
      {1382106590, 0, 0},
      {1461897718, 0, 0},
      {1474506522, 0, 0},
      {1530183840, 0, 0},
      {1558001705, 0, 0},
      {1558990974, 0, 0},
      {1616846013, 0, 0},
      {1633850097, 0, 0},
      {1684282922, 0, 0},
      {1725011064, 0, 0},
      {1767704813, 0, 0},
      {1923453688, 0, 0},
      {1941148668, 0, 0},
      {1955104493, 0, 0},
      {2022961611, 0, 0},
      {2162274327, 0, 0},
      {2212501241, 0, 0},
      {2219733501, 0, 0},
      {2234361374, 0, 0},
      {2272221101, 0, 0},
      {2305269460, 0, 0},
      {2488410748, 0, 0},
      {2566666743, 0, 0},
      {2598189097, 0, 0},
      {2775815164, 0, 0},
      {2793529873, 0, 0},
      {2844616706, 0, 0},
      {2970183398, 0, 0},
      {3103302036, 0, 0},
      {3110479131, 0, 0},
      {3115038057, 0, 0},
      {3116932970, 0, 0},
      {3152745753, 0, 0},
      {3187066832, 0, 0},
      {3244209297, 0, 0},
      {3383007207, 0, 0},
      {3392887901, 0, 0},
      {3508792859, 0, 0},
      {3737376990, 0, 0},
      {3753486980, 0, 0},
      {3765247327, 0, 0},
      {3817149113, 0, 0},
      {3839047923, 0, 0},
      {3886529747, 0, 0},
      {4044928561, 0, 0},
      {4061558677, 0, 0},
      {4069720347, 0, 0},
      {4069810315, 0, 0},
      {4128942283, 0, 0},
      {4164704452, 0, 0},
      {4273793488, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 74, 47},
      {0, 34, 33},
      {0, 36, 14},
      {0, 61, 48},
      {0, 13, 31},
      {0, 39, 25},
      {0, 37, 29},
      {0, 65, 54},
      {0, 4, 73},
      {0, 38, 10},
      {0, 15, 43},
      {0, 6, 35},
      {0, 9, 16},
      {0, 30, 19},
      {0, 49, 44},
      {0, 57, 53},
      {0, 60, 58},
      {0, 72, 66},
      {0, 59, 76},
      {0, 1, 68},
      {0, 70, 42},
      {0, 63, 3},
      {0, 28, 69},
      {0, 17, 55},
      {0, 45, 64},
      {0, 81, 80},
      {0, 7, 82},
      {0, 12, 11},
      {0, 21, 50},
      {0, 83, 18},
      {0, 22, 84},
      {0, 85, 26},
      {0, 20, 86},
      {0, 87, 40},
      {0, 56, 88},
      {0, 90, 89},
      {0, 92, 91},
      {0, 93, 2},
      {0, 95, 94},
      {0, 97, 96},
      {0, 98, 41},
      {0, 100, 99},
      {0, 101, 52},
      {0, 103, 102},
      {0, 77, 71},
      {0, 104, 78},
      {0, 105, 46},
      {0, 32, 8},
      {0, 106, 51},
      {0, 108, 107},
      {0, 23, 109},
      {0, 110, 27},
      {0, 112, 111},
      {0, 113, 75},
      {0, 115, 114},
      {0, 117, 116},
      {0, 119, 118},
      {0, 121, 120},
      {0, 123, 122},
      {0, 124, 62},
      {0, 126, 125},
      {0, 128, 127},
      {0, 67, 129},
      {0, 131, 130},
      {0, 5, 132},
      {0, 134, 133},
      {0, 136, 135},
      {0, 138, 137},
      {0, 139, 24},
      {0, 141, 140},
      {0, 143, 142},
      {0, 145, 144},
      {0, 147, 146},
      {0, 149, 148},
      {0, 151, 150},
      {0, 153, 152},
      {0, 79, 154},
      {0, 156, 155},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFSub, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 5},
      {0, 3, 6},
      {0, 1, 7},
      {0, 8, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFMul, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(41, {
      {0, 0, 0},
      {342197850, 0, 0},
      {885020215, 0, 0},
      {963902061, 0, 0},
      {1041368449, 0, 0},
      {1352397672, 0, 0},
      {1791427568, 0, 0},
      {2013867381, 0, 0},
      {2513230733, 0, 0},
      {2555315060, 0, 0},
      {2562485583, 0, 0},
      {2567901801, 0, 0},
      {2655147757, 0, 0},
      {2680283743, 0, 0},
      {2752766693, 0, 0},
      {2806716850, 0, 0},
      {3030911670, 0, 0},
      {3401762422, 0, 0},
      {3697738938, 0, 0},
      {4164704452, 0, 0},
      {4273793488, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 14, 10},
      {0, 7, 16},
      {0, 1, 15},
      {0, 9, 6},
      {0, 4, 12},
      {0, 18, 5},
      {0, 13, 2},
      {0, 19, 3},
      {0, 17, 20},
      {0, 23, 22},
      {0, 24, 8},
      {0, 26, 25},
      {0, 27, 11},
      {0, 29, 28},
      {0, 31, 30},
      {0, 33, 32},
      {0, 35, 34},
      {0, 37, 36},
      {0, 39, 38},
      {0, 21, 40},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFMul, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(129, {
      {0, 0, 0},
      {126463145, 0, 0},
      {129135650, 0, 0},
      {200922300, 0, 0},
      {328661377, 0, 0},
      {354479447, 0, 0},
      {360730278, 0, 0},
      {451264926, 0, 0},
      {529068443, 0, 0},
      {593829839, 0, 0},
      {742917749, 0, 0},
      {761731755, 0, 0},
      {810488476, 0, 0},
      {870594305, 0, 0},
      {894529125, 0, 0},
      {959681532, 0, 0},
      {1054461787, 0, 0},
      {1077859090, 0, 0},
      {1086964761, 0, 0},
      {1158929937, 0, 0},
      {1168927492, 0, 0},
      {1196280518, 0, 0},
      {1203545131, 0, 0},
      {1367301635, 0, 0},
      {1508550646, 0, 0},
      {1618544981, 0, 0},
      {1661163736, 0, 0},
      {1684282922, 0, 0},
      {1766994680, 0, 0},
      {1830851200, 0, 0},
      {1901166356, 0, 0},
      {1955104493, 0, 0},
      {2055836767, 0, 0},
      {2096388952, 0, 0},
      {2100052708, 0, 0},
      {2161102232, 0, 0},
      {2197904616, 0, 0},
      {2262137600, 0, 0},
      {2278571792, 0, 0},
      {2281956980, 0, 0},
      {2438466459, 0, 0},
      {2443959748, 0, 0},
      {2517964682, 0, 0},
      {2557754096, 0, 0},
      {2622612602, 0, 0},
      {2660843182, 0, 0},
      {2736844435, 0, 0},
      {2780898906, 0, 0},
      {3044188332, 0, 0},
      {3059119137, 0, 0},
      {3194725903, 0, 0},
      {3270430997, 0, 0},
      {3337532056, 0, 0},
      {3407526215, 0, 0},
      {3496407048, 0, 0},
      {3504158761, 0, 0},
      {3534518722, 0, 0},
      {3570411982, 0, 0},
      {3701632935, 0, 0},
      {3929248764, 0, 0},
      {3944781937, 0, 0},
      {3970432934, 0, 0},
      {4008405264, 0, 0},
      {4245257809, 0, 0},
      {4253051659, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 6, 26},
      {0, 46, 24},
      {0, 64, 50},
      {0, 7, 17},
      {0, 40, 57},
      {0, 56, 49},
      {0, 34, 10},
      {0, 32, 61},
      {0, 36, 44},
      {0, 8, 43},
      {0, 4, 18},
      {0, 25, 23},
      {0, 9, 54},
      {0, 45, 41},
      {0, 13, 21},
      {0, 47, 31},
      {0, 39, 53},
      {0, 11, 3},
      {0, 29, 20},
      {0, 38, 58},
      {0, 37, 14},
      {0, 66, 52},
      {0, 67, 35},
      {0, 48, 68},
      {0, 1, 69},
      {0, 70, 28},
      {0, 27, 63},
      {0, 72, 71},
      {0, 74, 73},
      {0, 75, 60},
      {0, 77, 76},
      {0, 5, 51},
      {0, 15, 78},
      {0, 30, 79},
      {0, 55, 80},
      {0, 42, 81},
      {0, 83, 82},
      {0, 85, 84},
      {0, 86, 2},
      {0, 19, 16},
      {0, 87, 59},
      {0, 62, 88},
      {0, 90, 89},
      {0, 22, 91},
      {0, 93, 92},
      {0, 95, 94},
      {0, 97, 96},
      {0, 99, 98},
      {0, 101, 100},
      {0, 12, 102},
      {0, 104, 103},
      {0, 33, 105},
      {0, 107, 106},
      {0, 109, 108},
      {0, 111, 110},
      {0, 113, 112},
      {0, 115, 114},
      {0, 117, 116},
      {0, 119, 118},
      {0, 121, 120},
      {0, 123, 122},
      {0, 125, 124},
      {0, 127, 126},
      {0, 65, 128},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFMul, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(127, {
      {0, 0, 0},
      {13319433, 0, 0},
      {15502752, 0, 0},
      {162608772, 0, 0},
      {171307615, 0, 0},
      {296981500, 0, 0},
      {354479447, 0, 0},
      {413918748, 0, 0},
      {443490822, 0, 0},
      {487719832, 0, 0},
      {593829839, 0, 0},
      {615982737, 0, 0},
      {703543228, 0, 0},
      {810488476, 0, 0},
      {870594305, 0, 0},
      {875212982, 0, 0},
      {959681532, 0, 0},
      {1019457583, 0, 0},
      {1203545131, 0, 0},
      {1278448636, 0, 0},
      {1325348861, 0, 0},
      {1368383673, 0, 0},
      {1400019344, 0, 0},
      {1646147798, 0, 0},
      {1679946323, 0, 0},
      {1684282922, 0, 0},
      {1747355813, 0, 0},
      {1755648697, 0, 0},
      {1793544760, 0, 0},
      {1811839150, 0, 0},
      {1901166356, 0, 0},
      {1947620272, 0, 0},
      {1992893964, 0, 0},
      {2042001863, 0, 0},
      {2096388952, 0, 0},
      {2123388694, 0, 0},
      {2128251367, 0, 0},
      {2130747644, 0, 0},
      {2135340676, 0, 0},
      {2161102232, 0, 0},
      {2443959748, 0, 0},
      {2513230733, 0, 0},
      {2557754096, 0, 0},
      {2580096524, 0, 0},
      {2589449658, 0, 0},
      {2614879967, 0, 0},
      {2698156268, 0, 0},
      {2970183398, 0, 0},
      {3002890475, 0, 0},
      {3133016299, 0, 0},
      {3142155593, 0, 0},
      {3187066832, 0, 0},
      {3266548732, 0, 0},
      {3287039847, 0, 0},
      {3357301402, 0, 0},
      {3413713311, 0, 0},
      {3434076295, 0, 0},
      {3496407048, 0, 0},
      {3504158761, 0, 0},
      {3882634684, 0, 0},
      {3929248764, 0, 0},
      {3987079331, 0, 0},
      {4076840151, 0, 0},
      {4243119782, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 31, 8},
      {0, 14, 56},
      {0, 7, 12},
      {0, 9, 30},
      {0, 42, 36},
      {0, 19, 11},
      {0, 22, 40},
      {0, 15, 3},
      {0, 57, 26},
      {0, 58, 61},
      {0, 55, 51},
      {0, 48, 34},
      {0, 20, 1},
      {0, 24, 23},
      {0, 46, 35},
      {0, 59, 49},
      {0, 21, 63},
      {0, 62, 44},
      {0, 6, 50},
      {0, 28, 18},
      {0, 66, 65},
      {0, 41, 32},
      {0, 39, 54},
      {0, 53, 67},
      {0, 68, 37},
      {0, 33, 69},
      {0, 43, 70},
      {0, 71, 38},
      {0, 72, 27},
      {0, 13, 47},
      {0, 45, 73},
      {0, 75, 74},
      {0, 76, 5},
      {0, 77, 17},
      {0, 79, 78},
      {0, 52, 80},
      {0, 2, 81},
      {0, 83, 82},
      {0, 85, 84},
      {0, 87, 86},
      {0, 4, 88},
      {0, 16, 29},
      {0, 90, 89},
      {0, 92, 91},
      {0, 94, 93},
      {0, 60, 95},
      {0, 97, 96},
      {0, 98, 10},
      {0, 25, 99},
      {0, 101, 100},
      {0, 103, 102},
      {0, 105, 104},
      {0, 107, 106},
      {0, 109, 108},
      {0, 111, 110},
      {0, 113, 112},
      {0, 115, 114},
      {0, 117, 116},
      {0, 119, 118},
      {0, 121, 120},
      {0, 123, 122},
      {0, 125, 124},
      {0, 64, 126},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFMul, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(9, {
      {0, 0, 0},
      {679771963, 0, 0},
      {1951208733, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 4, 5},
      {0, 3, 6},
      {0, 7, 1},
      {0, 2, 8},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFDiv, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(153, {
      {0, 0, 0},
      {10142671, 0, 0},
      {27865391, 0, 0},
      {29517006, 0, 0},
      {41739659, 0, 0},
      {97231530, 0, 0},
      {171334650, 0, 0},
      {200553094, 0, 0},
      {257136089, 0, 0},
      {294390719, 0, 0},
      {375530199, 0, 0},
      {380957745, 0, 0},
      {388034151, 0, 0},
      {455591063, 0, 0},
      {462664429, 0, 0},
      {491456522, 0, 0},
      {502863753, 0, 0},
      {626480004, 0, 0},
      {643418617, 0, 0},
      {651464351, 0, 0},
      {701281393, 0, 0},
      {744817486, 0, 0},
      {783918780, 0, 0},
      {862784766, 0, 0},
      {930804377, 0, 0},
      {952536201, 0, 0},
      {955476870, 0, 0},
      {1043738701, 0, 0},
      {1047011733, 0, 0},
      {1080545747, 0, 0},
      {1137442027, 0, 0},
      {1235468610, 0, 0},
      {1412908157, 0, 0},
      {1431749301, 0, 0},
      {1434223270, 0, 0},
      {1440646342, 0, 0},
      {1508570930, 0, 0},
      {1510422521, 0, 0},
      {1548121999, 0, 0},
      {1582841441, 0, 0},
      {1612225949, 0, 0},
      {1665981878, 0, 0},
      {1680746207, 0, 0},
      {1696076631, 0, 0},
      {1702168830, 0, 0},
      {1761469971, 0, 0},
      {1799299383, 0, 0},
      {1910240213, 0, 0},
      {1917451875, 0, 0},
      {1945006185, 0, 0},
      {1998444837, 0, 0},
      {2045285083, 0, 0},
      {2217966239, 0, 0},
      {2279273489, 0, 0},
      {2289803479, 0, 0},
      {2348676810, 0, 0},
      {2353194283, 0, 0},
      {2403632109, 0, 0},
      {2409539315, 0, 0},
      {2414984922, 0, 0},
      {2477389837, 0, 0},
      {2524531022, 0, 0},
      {2573160348, 0, 0},
      {2639720559, 0, 0},
      {2773229577, 0, 0},
      {2796513469, 0, 0},
      {2881225774, 0, 0},
      {2890570341, 0, 0},
      {2952850186, 0, 0},
      {3023287679, 0, 0},
      {3118548424, 0, 0},
      {3877813395, 0, 0},
      {3931288033, 0, 0},
      {3972309363, 0, 0},
      {4117704995, 0, 0},
      {4140081844, 0, 0},
      {4258414038, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 74, 53},
      {0, 58, 52},
      {0, 65, 60},
      {0, 41, 5},
      {0, 1, 67},
      {0, 24, 28},
      {0, 27, 26},
      {0, 55, 31},
      {0, 36, 61},
      {0, 13, 49},
      {0, 56, 48},
      {0, 16, 64},
      {0, 76, 42},
      {0, 45, 29},
      {0, 23, 6},
      {0, 72, 12},
      {0, 35, 19},
      {0, 20, 7},
      {0, 21, 46},
      {0, 71, 78},
      {0, 80, 79},
      {0, 47, 17},
      {0, 81, 70},
      {0, 34, 25},
      {0, 83, 82},
      {0, 85, 84},
      {0, 37, 86},
      {0, 87, 73},
      {0, 10, 4},
      {0, 40, 30},
      {0, 88, 57},
      {0, 54, 89},
      {0, 50, 90},
      {0, 11, 91},
      {0, 39, 15},
      {0, 59, 44},
      {0, 92, 66},
      {0, 69, 93},
      {0, 95, 94},
      {0, 14, 96},
      {0, 98, 97},
      {0, 62, 51},
      {0, 100, 99},
      {0, 102, 101},
      {0, 104, 103},
      {0, 32, 43},
      {0, 105, 38},
      {0, 107, 106},
      {0, 109, 108},
      {0, 22, 9},
      {0, 33, 110},
      {0, 2, 111},
      {0, 112, 3},
      {0, 114, 113},
      {0, 116, 115},
      {0, 68, 63},
      {0, 118, 117},
      {0, 120, 119},
      {0, 121, 8},
      {0, 123, 122},
      {0, 125, 124},
      {0, 127, 126},
      {0, 129, 128},
      {0, 131, 130},
      {0, 133, 132},
      {0, 75, 18},
      {0, 135, 134},
      {0, 137, 136},
      {0, 139, 138},
      {0, 141, 140},
      {0, 143, 142},
      {0, 145, 144},
      {0, 147, 146},
      {0, 149, 148},
      {0, 150, 77},
      {0, 152, 151},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFDiv, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(131, {
      {0, 0, 0},
      {5908395, 0, 0},
      {139011596, 0, 0},
      {296981500, 0, 0},
      {342615870, 0, 0},
      {370232173, 0, 0},
      {492958971, 0, 0},
      {528662843, 0, 0},
      {551924251, 0, 0},
      {604894932, 0, 0},
      {610429940, 0, 0},
      {780957373, 0, 0},
      {810488476, 0, 0},
      {872544165, 0, 0},
      {878733439, 0, 0},
      {918849409, 0, 0},
      {959681532, 0, 0},
      {1013756921, 0, 0},
      {1038982109, 0, 0},
      {1081611718, 0, 0},
      {1125913837, 0, 0},
      {1209418480, 0, 0},
      {1318081294, 0, 0},
      {1367301635, 0, 0},
      {1417425499, 0, 0},
      {1625742020, 0, 0},
      {1684282922, 0, 0},
      {1746004874, 0, 0},
      {1758287856, 0, 0},
      {1777640493, 0, 0},
      {2066323109, 0, 0},
      {2094550054, 0, 0},
      {2096388952, 0, 0},
      {2144962711, 0, 0},
      {2434845539, 0, 0},
      {2480811229, 0, 0},
      {2552825357, 0, 0},
      {2636946065, 0, 0},
      {2651956495, 0, 0},
      {2669086217, 0, 0},
      {2680819379, 0, 0},
      {2709694527, 0, 0},
      {2715304020, 0, 0},
      {2790648021, 0, 0},
      {2802261839, 0, 0},
      {2806296851, 0, 0},
      {2864543087, 0, 0},
      {2952260510, 0, 0},
      {2963184673, 0, 0},
      {3091876332, 0, 0},
      {3098991995, 0, 0},
      {3131890669, 0, 0},
      {3138977758, 0, 0},
      {3198541202, 0, 0},
      {3260579369, 0, 0},
      {3263841912, 0, 0},
      {3335250889, 0, 0},
      {3345856521, 0, 0},
      {3381478137, 0, 0},
      {3489269251, 0, 0},
      {3510242586, 0, 0},
      {3820814597, 0, 0},
      {3900859293, 0, 0},
      {4041974454, 0, 0},
      {4244540017, 0, 0},
      {4265894873, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 15, 52},
      {0, 20, 18},
      {0, 39, 29},
      {0, 9, 43},
      {0, 22, 13},
      {0, 46, 27},
      {0, 51, 48},
      {0, 19, 57},
      {0, 34, 24},
      {0, 64, 59},
      {0, 5, 7},
      {0, 38, 37},
      {0, 45, 47},
      {0, 2, 56},
      {0, 67, 8},
      {0, 17, 68},
      {0, 69, 61},
      {0, 70, 6},
      {0, 55, 54},
      {0, 72, 71},
      {0, 4, 73},
      {0, 74, 40},
      {0, 30, 11},
      {0, 42, 36},
      {0, 75, 58},
      {0, 31, 76},
      {0, 1, 77},
      {0, 44, 14},
      {0, 78, 50},
      {0, 79, 23},
      {0, 26, 80},
      {0, 81, 12},
      {0, 83, 82},
      {0, 84, 21},
      {0, 32, 85},
      {0, 87, 86},
      {0, 35, 10},
      {0, 88, 62},
      {0, 90, 89},
      {0, 41, 91},
      {0, 92, 53},
      {0, 93, 63},
      {0, 95, 94},
      {0, 33, 96},
      {0, 98, 97},
      {0, 99, 3},
      {0, 100, 28},
      {0, 101, 49},
      {0, 102, 60},
      {0, 104, 103},
      {0, 106, 105},
      {0, 108, 107},
      {0, 110, 109},
      {0, 65, 111},
      {0, 25, 112},
      {0, 114, 113},
      {0, 116, 115},
      {0, 117, 16},
      {0, 119, 118},
      {0, 121, 120},
      {0, 123, 122},
      {0, 125, 124},
      {0, 127, 126},
      {0, 128, 66},
      {0, 130, 129},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFDiv, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(95, {
      {0, 0, 0},
      {116093251, 0, 0},
      {149720480, 0, 0},
      {183103444, 0, 0},
      {251209228, 0, 0},
      {296981500, 0, 0},
      {357505993, 0, 0},
      {394654115, 0, 0},
      {410274915, 0, 0},
      {452208841, 0, 0},
      {788046331, 0, 0},
      {797934924, 0, 0},
      {810488476, 0, 0},
      {1144188012, 0, 0},
      {1220127364, 0, 0},
      {1321616112, 0, 0},
      {1324351672, 0, 0},
      {1348149915, 0, 0},
      {1459457331, 0, 0},
      {1465623797, 0, 0},
      {1531216990, 0, 0},
      {1543672828, 0, 0},
      {1578775276, 0, 0},
      {1738815671, 0, 0},
      {1904128160, 0, 0},
      {2071351379, 0, 0},
      {2119793999, 0, 0},
      {2274779301, 0, 0},
      {2291766425, 0, 0},
      {2357410109, 0, 0},
      {2438466459, 0, 0},
      {2496463830, 0, 0},
      {2630220147, 0, 0},
      {2682510803, 0, 0},
      {3047649911, 0, 0},
      {3085703811, 0, 0},
      {3235459678, 0, 0},
      {3261703164, 0, 0},
      {3331487616, 0, 0},
      {3462674048, 0, 0},
      {3570219049, 0, 0},
      {3585315836, 0, 0},
      {3602108619, 0, 0},
      {3724004880, 0, 0},
      {3931641900, 0, 0},
      {3955205564, 0, 0},
      {4073492988, 0, 0},
      {4127308103, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 24, 37},
      {0, 13, 38},
      {0, 17, 39},
      {0, 35, 23},
      {0, 18, 36},
      {0, 46, 19},
      {0, 20, 33},
      {0, 47, 6},
      {0, 1, 45},
      {0, 3, 27},
      {0, 8, 49},
      {0, 50, 29},
      {0, 10, 51},
      {0, 43, 31},
      {0, 53, 52},
      {0, 54, 26},
      {0, 7, 55},
      {0, 56, 32},
      {0, 57, 41},
      {0, 59, 58},
      {0, 61, 60},
      {0, 63, 62},
      {0, 64, 25},
      {0, 2, 34},
      {0, 65, 14},
      {0, 67, 66},
      {0, 12, 21},
      {0, 9, 68},
      {0, 69, 16},
      {0, 71, 70},
      {0, 72, 44},
      {0, 11, 73},
      {0, 74, 30},
      {0, 4, 75},
      {0, 28, 15},
      {0, 76, 42},
      {0, 5, 77},
      {0, 78, 40},
      {0, 80, 79},
      {0, 82, 81},
      {0, 22, 83},
      {0, 85, 84},
      {0, 86, 48},
      {0, 88, 87},
      {0, 90, 89},
      {0, 92, 91},
      {0, 94, 93},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpFDiv, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(7, {
      {0, 0, 0},
      {679771963, 0, 0},
      {2320303498, 0, 0},
      {3334207724, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 3, 4},
      {0, 2, 5},
      {0, 1, 6},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpVectorTimesScalar, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(121, {
      {0, 0, 0},
      {14113753, 0, 0},
      {102358168, 0, 0},
      {179458548, 0, 0},
      {330388453, 0, 0},
      {386525753, 0, 0},
      {470277359, 0, 0},
      {497658126, 0, 0},
      {508007510, 0, 0},
      {815034111, 0, 0},
      {826214242, 0, 0},
      {849867303, 0, 0},
      {885645401, 0, 0},
      {939415664, 0, 0},
      {968885186, 0, 0},
      {1105835505, 0, 0},
      {1159301677, 0, 0},
      {1461897718, 0, 0},
      {1482251215, 0, 0},
      {1486206763, 0, 0},
      {1527762373, 0, 0},
      {1558990974, 0, 0},
      {1618754372, 0, 0},
      {1669959736, 0, 0},
      {1752686878, 0, 0},
      {2004567202, 0, 0},
      {2055637638, 0, 0},
      {2113506324, 0, 0},
      {2154320787, 0, 0},
      {2162274327, 0, 0},
      {2306141594, 0, 0},
      {2345566651, 0, 0},
      {2457690657, 0, 0},
      {2473053808, 0, 0},
      {2500422644, 0, 0},
      {2504802016, 0, 0},
      {2506771164, 0, 0},
      {2793529873, 0, 0},
      {2801333547, 0, 0},
      {2879050471, 0, 0},
      {3032677281, 0, 0},
      {3045470312, 0, 0},
      {3181546731, 0, 0},
      {3240977890, 0, 0},
      {3262572726, 0, 0},
      {3307100165, 0, 0},
      {3425841570, 0, 0},
      {3560552546, 0, 0},
      {3641833815, 0, 0},
      {3652695478, 0, 0},
      {3782362128, 0, 0},
      {3797961332, 0, 0},
      {3837583704, 0, 0},
      {3886529747, 0, 0},
      {3907920335, 0, 0},
      {4043078107, 0, 0},
      {4044928561, 0, 0},
      {4069720347, 0, 0},
      {4180570743, 0, 0},
      {4245743275, 0, 0},
      {4285201458, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 44, 28},
      {0, 13, 45},
      {0, 19, 15},
      {0, 32, 31},
      {0, 43, 42},
      {0, 16, 52},
      {0, 33, 22},
      {0, 57, 55},
      {0, 24, 21},
      {0, 2, 59},
      {0, 10, 3},
      {0, 18, 12},
      {0, 41, 39},
      {0, 60, 46},
      {0, 4, 25},
      {0, 58, 49},
      {0, 14, 1},
      {0, 27, 17},
      {0, 50, 36},
      {0, 23, 54},
      {0, 5, 30},
      {0, 11, 7},
      {0, 38, 29},
      {0, 37, 8},
      {0, 48, 56},
      {0, 20, 6},
      {0, 34, 26},
      {0, 63, 62},
      {0, 65, 64},
      {0, 67, 66},
      {0, 69, 68},
      {0, 71, 70},
      {0, 73, 72},
      {0, 75, 74},
      {0, 9, 76},
      {0, 78, 77},
      {0, 80, 79},
      {0, 82, 81},
      {0, 84, 83},
      {0, 40, 35},
      {0, 85, 47},
      {0, 86, 51},
      {0, 88, 87},
      {0, 90, 89},
      {0, 53, 91},
      {0, 93, 92},
      {0, 95, 94},
      {0, 97, 96},
      {0, 99, 98},
      {0, 101, 100},
      {0, 103, 102},
      {0, 105, 104},
      {0, 107, 106},
      {0, 109, 108},
      {0, 111, 110},
      {0, 113, 112},
      {0, 115, 114},
      {0, 117, 116},
      {0, 119, 118},
      {0, 61, 120},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpVectorTimesScalar, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(127, {
      {0, 0, 0},
      {100979271, 0, 0},
      {269576093, 0, 0},
      {314809953, 0, 0},
      {354479447, 0, 0},
      {497658126, 0, 0},
      {882718761, 0, 0},
      {968885186, 0, 0},
      {973908139, 0, 0},
      {1019457583, 0, 0},
      {1191015885, 0, 0},
      {1266262705, 0, 0},
      {1310404265, 0, 0},
      {1325348861, 0, 0},
      {1367301635, 0, 0},
      {1368383673, 0, 0},
      {1570165302, 0, 0},
      {1618544981, 0, 0},
      {1646147798, 0, 0},
      {1674464100, 0, 0},
      {1679946323, 0, 0},
      {1686512349, 0, 0},
      {1766401548, 0, 0},
      {1774052499, 0, 0},
      {1788301425, 0, 0},
      {2023008475, 0, 0},
      {2055836767, 0, 0},
      {2096388952, 0, 0},
      {2123388694, 0, 0},
      {2129301998, 0, 0},
      {2212501241, 0, 0},
      {2274226560, 0, 0},
      {2362972044, 0, 0},
      {2378763734, 0, 0},
      {2506771164, 0, 0},
      {2558655180, 0, 0},
      {2622612602, 0, 0},
      {2660843182, 0, 0},
      {2698156268, 0, 0},
      {2801333547, 0, 0},
      {2850246066, 0, 0},
      {2895151306, 0, 0},
      {2970183398, 0, 0},
      {2986830770, 0, 0},
      {3001444829, 0, 0},
      {3133016299, 0, 0},
      {3152745753, 0, 0},
      {3187066832, 0, 0},
      {3261122899, 0, 0},
      {3496407048, 0, 0},
      {3513669836, 0, 0},
      {3536390697, 0, 0},
      {3570411982, 0, 0},
      {3653838348, 0, 0},
      {3713290482, 0, 0},
      {3858973601, 0, 0},
      {3873587660, 0, 0},
      {3877583949, 0, 0},
      {3882634684, 0, 0},
      {3907920335, 0, 0},
      {3997432565, 0, 0},
      {4169226615, 0, 0},
      {4219766939, 0, 0},
      {4243119782, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 25, 12},
      {0, 41, 29},
      {0, 56, 44},
      {0, 1, 3},
      {0, 48, 24},
      {0, 33, 60},
      {0, 8, 50},
      {0, 35, 21},
      {0, 11, 7},
      {0, 34, 23},
      {0, 59, 57},
      {0, 10, 62},
      {0, 40, 2},
      {0, 5, 49},
      {0, 39, 17},
      {0, 9, 61},
      {0, 30, 6},
      {0, 19, 46},
      {0, 53, 54},
      {0, 31, 52},
      {0, 55, 43},
      {0, 66, 65},
      {0, 16, 67},
      {0, 51, 68},
      {0, 70, 69},
      {0, 26, 36},
      {0, 72, 71},
      {0, 74, 73},
      {0, 76, 75},
      {0, 78, 77},
      {0, 80, 79},
      {0, 82, 81},
      {0, 37, 83},
      {0, 85, 84},
      {0, 13, 86},
      {0, 20, 18},
      {0, 38, 28},
      {0, 58, 45},
      {0, 87, 63},
      {0, 15, 88},
      {0, 32, 22},
      {0, 89, 4},
      {0, 90, 14},
      {0, 91, 42},
      {0, 93, 92},
      {0, 95, 94},
      {0, 97, 96},
      {0, 99, 98},
      {0, 101, 100},
      {0, 103, 102},
      {0, 105, 104},
      {0, 107, 106},
      {0, 109, 108},
      {0, 111, 110},
      {0, 113, 112},
      {0, 115, 114},
      {0, 27, 47},
      {0, 117, 116},
      {0, 119, 118},
      {0, 121, 120},
      {0, 123, 122},
      {0, 125, 124},
      {0, 126, 64},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpVectorTimesScalar, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(137, {
      {0, 0, 0},
      {11698369, 0, 0},
      {146392076, 0, 0},
      {151810803, 0, 0},
      {223800276, 0, 0},
      {227103506, 0, 0},
      {253329281, 0, 0},
      {346929928, 0, 0},
      {461040879, 0, 0},
      {629859130, 0, 0},
      {680157484, 0, 0},
      {783918780, 0, 0},
      {810488476, 0, 0},
      {824323032, 0, 0},
      {870594305, 0, 0},
      {959681532, 0, 0},
      {975807626, 0, 0},
      {1081642571, 0, 0},
      {1084574846, 0, 0},
      {1094817798, 0, 0},
      {1141965917, 0, 0},
      {1164137269, 0, 0},
      {1166917451, 0, 0},
      {1204787336, 0, 0},
      {1232501371, 0, 0},
      {1318479490, 0, 0},
      {1369818198, 0, 0},
      {1372785527, 0, 0},
      {1526654696, 0, 0},
      {1543672828, 0, 0},
      {1548121999, 0, 0},
      {1635292159, 0, 0},
      {1641070431, 0, 0},
      {1684282922, 0, 0},
      {1767704813, 0, 0},
      {1781765116, 0, 0},
      {1838763297, 0, 0},
      {1901166356, 0, 0},
      {1904846533, 0, 0},
      {2011183308, 0, 0},
      {2032069771, 0, 0},
      {2071351379, 0, 0},
      {2087004702, 0, 0},
      {2244928358, 0, 0},
      {2314864456, 0, 0},
      {2374216296, 0, 0},
      {2394332122, 0, 0},
      {2443610186, 0, 0},
      {2524697596, 0, 0},
      {2526961521, 0, 0},
      {2568098594, 0, 0},
      {2807907995, 0, 0},
      {3103302036, 0, 0},
      {3117071189, 0, 0},
      {3188115516, 0, 0},
      {3417584874, 0, 0},
      {3554463148, 0, 0},
      {3561482820, 0, 0},
      {3691770462, 0, 0},
      {3729929345, 0, 0},
      {3733675151, 0, 0},
      {3831290364, 0, 0},
      {3866493821, 0, 0},
      {3929248764, 0, 0},
      {4060703604, 0, 0},
      {4092487128, 0, 0},
      {4167600590, 0, 0},
      {4214779116, 0, 0},
      {4248015868, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 36, 13},
      {0, 49, 60},
      {0, 51, 9},
      {0, 3, 62},
      {0, 67, 41},
      {0, 4, 31},
      {0, 66, 5},
      {0, 55, 32},
      {0, 2, 1},
      {0, 30, 16},
      {0, 7, 38},
      {0, 19, 10},
      {0, 34, 20},
      {0, 45, 46},
      {0, 22, 11},
      {0, 25, 23},
      {0, 40, 39},
      {0, 21, 57},
      {0, 6, 35},
      {0, 61, 8},
      {0, 52, 26},
      {0, 70, 59},
      {0, 71, 14},
      {0, 68, 47},
      {0, 73, 72},
      {0, 29, 74},
      {0, 76, 75},
      {0, 77, 17},
      {0, 79, 78},
      {0, 81, 80},
      {0, 82, 18},
      {0, 83, 42},
      {0, 85, 84},
      {0, 87, 86},
      {0, 27, 37},
      {0, 53, 43},
      {0, 89, 88},
      {0, 64, 54},
      {0, 90, 65},
      {0, 92, 91},
      {0, 58, 93},
      {0, 56, 48},
      {0, 94, 28},
      {0, 96, 95},
      {0, 98, 97},
      {0, 44, 99},
      {0, 101, 100},
      {0, 15, 12},
      {0, 103, 102},
      {0, 104, 33},
      {0, 106, 105},
      {0, 108, 107},
      {0, 24, 109},
      {0, 111, 110},
      {0, 113, 112},
      {0, 114, 50},
      {0, 116, 115},
      {0, 118, 117},
      {0, 120, 119},
      {0, 122, 121},
      {0, 124, 123},
      {0, 126, 125},
      {0, 128, 127},
      {0, 129, 63},
      {0, 131, 130},
      {0, 133, 132},
      {0, 135, 134},
      {0, 136, 69},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpVectorTimesScalar, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {1951208733, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpDot, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(97, {
      {0, 0, 0},
      {78001013, 0, 0},
      {170690025, 0, 0},
      {206688607, 0, 0},
      {443490822, 0, 0},
      {461476226, 0, 0},
      {537830163, 0, 0},
      {669982125, 0, 0},
      {790502615, 0, 0},
      {805072272, 0, 0},
      {1173092699, 0, 0},
      {1220643281, 0, 0},
      {1448448666, 0, 0},
      {1466804584, 0, 0},
      {1473411044, 0, 0},
      {1515695460, 0, 0},
      {1587730355, 0, 0},
      {1625742020, 0, 0},
      {2071351379, 0, 0},
      {2250055803, 0, 0},
      {2291766425, 0, 0},
      {2416108131, 0, 0},
      {2427834344, 0, 0},
      {2436009347, 0, 0},
      {2455417440, 0, 0},
      {2480811229, 0, 0},
      {2654325647, 0, 0},
      {2919796598, 0, 0},
      {3047649911, 0, 0},
      {3088511797, 0, 0},
      {3104643263, 0, 0},
      {3198541202, 0, 0},
      {3204986803, 0, 0},
      {3272233597, 0, 0},
      {3383007207, 0, 0},
      {3602108619, 0, 0},
      {3622349409, 0, 0},
      {3714664910, 0, 0},
      {3717942504, 0, 0},
      {3732000233, 0, 0},
      {3759072440, 0, 0},
      {3765247327, 0, 0},
      {3805423332, 0, 0},
      {3829325073, 0, 0},
      {3866493821, 0, 0},
      {4058280485, 0, 0},
      {4061558677, 0, 0},
      {4148979936, 0, 0},
      {4155586396, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 13, 38},
      {0, 39, 14},
      {0, 44, 9},
      {0, 48, 47},
      {0, 23, 15},
      {0, 33, 25},
      {0, 1, 42},
      {0, 5, 46},
      {0, 31, 3},
      {0, 36, 28},
      {0, 16, 12},
      {0, 32, 22},
      {0, 41, 21},
      {0, 6, 50},
      {0, 51, 29},
      {0, 45, 34},
      {0, 37, 8},
      {0, 19, 52},
      {0, 11, 4},
      {0, 43, 40},
      {0, 27, 53},
      {0, 54, 10},
      {0, 24, 55},
      {0, 57, 56},
      {0, 58, 26},
      {0, 2, 59},
      {0, 61, 60},
      {0, 63, 62},
      {0, 65, 64},
      {0, 20, 66},
      {0, 30, 35},
      {0, 67, 17},
      {0, 68, 7},
      {0, 70, 69},
      {0, 71, 18},
      {0, 73, 72},
      {0, 75, 74},
      {0, 77, 76},
      {0, 79, 78},
      {0, 81, 80},
      {0, 83, 82},
      {0, 85, 84},
      {0, 87, 86},
      {0, 89, 88},
      {0, 91, 90},
      {0, 93, 92},
      {0, 95, 94},
      {0, 49, 96},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpDot, 1), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(117, {
      {0, 0, 0},
      {50385656, 0, 0},
      {181902171, 0, 0},
      {560078433, 0, 0},
      {615982737, 0, 0},
      {674428451, 0, 0},
      {837715723, 0, 0},
      {886972033, 0, 0},
      {900101778, 0, 0},
      {983299427, 0, 0},
      {1237148906, 0, 0},
      {1364157225, 0, 0},
      {1367301635, 0, 0},
      {1380160211, 0, 0},
      {1451831482, 0, 0},
      {1499923635, 0, 0},
      {1570165302, 0, 0},
      {1735295265, 0, 0},
      {1766401548, 0, 0},
      {1796311149, 0, 0},
      {1826456251, 0, 0},
      {1839669171, 0, 0},
      {2012838864, 0, 0},
      {2024071551, 0, 0},
      {2096388952, 0, 0},
      {2161102232, 0, 0},
      {2197874825, 0, 0},
      {2279700640, 0, 0},
      {2289183712, 0, 0},
      {2351620600, 0, 0},
      {2362972044, 0, 0},
      {2472176885, 0, 0},
      {2477434291, 0, 0},
      {2530899578, 0, 0},
      {2531826164, 0, 0},
      {2558133383, 0, 0},
      {2589449658, 0, 0},
      {2621255555, 0, 0},
      {2622612602, 0, 0},
      {2872580757, 0, 0},
      {2881302403, 0, 0},
      {2891091137, 0, 0},
      {2923708820, 0, 0},
      {2936040203, 0, 0},
      {2970183398, 0, 0},
      {3187066832, 0, 0},
      {3224952074, 0, 0},
      {3244383472, 0, 0},
      {3261122899, 0, 0},
      {3362830643, 0, 0},
      {3538158875, 0, 0},
      {3635542517, 0, 0},
      {3682213068, 0, 0},
      {3721902098, 0, 0},
      {3826846522, 0, 0},
      {3877583949, 0, 0},
      {3997432565, 0, 0},
      {4093615095, 0, 0},
      {4106828015, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 52, 28},
      {0, 33, 20},
      {0, 46, 57},
      {0, 47, 54},
      {0, 21, 17},
      {0, 31, 58},
      {0, 12, 53},
      {0, 29, 3},
      {0, 35, 34},
      {0, 48, 41},
      {0, 8, 5},
      {0, 7, 55},
      {0, 37, 32},
      {0, 60, 38},
      {0, 61, 16},
      {0, 14, 62},
      {0, 23, 63},
      {0, 13, 19},
      {0, 64, 9},
      {0, 65, 39},
      {0, 2, 66},
      {0, 67, 42},
      {0, 69, 68},
      {0, 25, 70},
      {0, 1, 49},
      {0, 6, 71},
      {0, 72, 15},
      {0, 73, 11},
      {0, 75, 74},
      {0, 77, 76},
      {0, 4, 78},
      {0, 56, 50},
      {0, 80, 79},
      {0, 10, 81},
      {0, 83, 82},
      {0, 85, 84},
      {0, 86, 27},
      {0, 43, 40},
      {0, 88, 87},
      {0, 44, 24},
      {0, 30, 89},
      {0, 51, 36},
      {0, 45, 90},
      {0, 18, 91},
      {0, 93, 92},
      {0, 22, 94},
      {0, 26, 95},
      {0, 97, 96},
      {0, 99, 98},
      {0, 101, 100},
      {0, 103, 102},
      {0, 105, 104},
      {0, 107, 106},
      {0, 109, 108},
      {0, 111, 110},
      {0, 113, 112},
      {0, 59, 114},
      {0, 116, 115},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpDot, 2), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(179, {
      {0, 0, 0},
      {27177503, 0, 0},
      {50385656, 0, 0},
      {129748122, 0, 0},
      {139011596, 0, 0},
      {162608772, 0, 0},
      {181902171, 0, 0},
      {225200779, 0, 0},
      {342159236, 0, 0},
      {386293029, 0, 0},
      {429023543, 0, 0},
      {443558693, 0, 0},
      {504514034, 0, 0},
      {615982737, 0, 0},
      {669812542, 0, 0},
      {674428451, 0, 0},
      {837715723, 0, 0},
      {861753115, 0, 0},
      {875212982, 0, 0},
      {876867882, 0, 0},
      {899320334, 0, 0},
      {900101778, 0, 0},
      {938517572, 0, 0},
      {1347339159, 0, 0},
      {1356063462, 0, 0},
      {1373856501, 0, 0},
      {1376656865, 0, 0},
      {1451831482, 0, 0},
      {1522979646, 0, 0},
      {1548491889, 0, 0},
      {1570165302, 0, 0},
      {1735295265, 0, 0},
      {1747355813, 0, 0},
      {1766401548, 0, 0},
      {1871105284, 0, 0},
      {1918742169, 0, 0},
      {1922045399, 0, 0},
      {1978689945, 0, 0},
      {2024071551, 0, 0},
      {2059975069, 0, 0},
      {2076833303, 0, 0},
      {2096388952, 0, 0},
      {2181030375, 0, 0},
      {2197874825, 0, 0},
      {2362972044, 0, 0},
      {2414725163, 0, 0},
      {2517964682, 0, 0},
      {2564745684, 0, 0},
      {2577387676, 0, 0},
      {2589449658, 0, 0},
      {2604242419, 0, 0},
      {2683080096, 0, 0},
      {2696349144, 0, 0},
      {2763960513, 0, 0},
      {2817823941, 0, 0},
      {2852854788, 0, 0},
      {2891091137, 0, 0},
      {2919626325, 0, 0},
      {2923708820, 0, 0},
      {2936040203, 0, 0},
      {2963744582, 0, 0},
      {2970183398, 0, 0},
      {2984459037, 0, 0},
      {2996594997, 0, 0},
      {3015046341, 0, 0},
      {3055195668, 0, 0},
      {3127329373, 0, 0},
      {3187066832, 0, 0},
      {3193597927, 0, 0},
      {3200890815, 0, 0},
      {3224258475, 0, 0},
      {3224480461, 0, 0},
      {3261122899, 0, 0},
      {3609540589, 0, 0},
      {3619404941, 0, 0},
      {3619626927, 0, 0},
      {3727034815, 0, 0},
      {3742724777, 0, 0},
      {3742946763, 0, 0},
      {3836179806, 0, 0},
      {3913885196, 0, 0},
      {3927338499, 0, 0},
      {3927466635, 0, 0},
      {3997432565, 0, 0},
      {3999472204, 0, 0},
      {4010499223, 0, 0},
      {4032662899, 0, 0},
      {4110915453, 0, 0},
      {4145966869, 0, 0},
      {4228303141, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 23, 87},
      {0, 9, 28},
      {0, 42, 17},
      {0, 74, 70},
      {0, 86, 77},
      {0, 18, 5},
      {0, 31, 32},
      {0, 34, 3},
      {0, 38, 68},
      {0, 50, 29},
      {0, 72, 62},
      {0, 21, 15},
      {0, 14, 54},
      {0, 56, 22},
      {0, 48, 88},
      {0, 2, 76},
      {0, 6, 47},
      {0, 26, 79},
      {0, 65, 12},
      {0, 37, 81},
      {0, 91, 60},
      {0, 30, 92},
      {0, 25, 7},
      {0, 45, 40},
      {0, 66, 52},
      {0, 71, 69},
      {0, 78, 75},
      {0, 84, 82},
      {0, 94, 93},
      {0, 27, 95},
      {0, 97, 96},
      {0, 99, 98},
      {0, 100, 39},
      {0, 55, 101},
      {0, 58, 102},
      {0, 89, 103},
      {0, 35, 11},
      {0, 104, 36},
      {0, 53, 10},
      {0, 1, 64},
      {0, 73, 20},
      {0, 105, 13},
      {0, 107, 106},
      {0, 8, 16},
      {0, 24, 19},
      {0, 85, 63},
      {0, 109, 108},
      {0, 111, 110},
      {0, 4, 112},
      {0, 114, 113},
      {0, 116, 115},
      {0, 118, 117},
      {0, 83, 119},
      {0, 121, 120},
      {0, 123, 122},
      {0, 49, 44},
      {0, 124, 57},
      {0, 125, 59},
      {0, 126, 67},
      {0, 128, 127},
      {0, 130, 129},
      {0, 132, 131},
      {0, 134, 133},
      {0, 135, 51},
      {0, 137, 136},
      {0, 138, 61},
      {0, 43, 41},
      {0, 140, 139},
      {0, 142, 141},
      {0, 144, 143},
      {0, 146, 145},
      {0, 148, 147},
      {0, 149, 33},
      {0, 80, 150},
      {0, 152, 151},
      {0, 154, 153},
      {0, 156, 155},
      {0, 158, 157},
      {0, 160, 159},
      {0, 162, 161},
      {0, 164, 163},
      {0, 166, 165},
      {0, 168, 167},
      {0, 46, 169},
      {0, 171, 170},
      {0, 90, 172},
      {0, 174, 173},
      {0, 176, 175},
      {0, 178, 177},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpDot, 3), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {1036475267, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpLabel, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(3, {
      {0, 0, 0},
      {1036475267, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 1, 2},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpBranch, 0), std::move(codec));
  }

  {
    std::unique_ptr<HuffmanCodec<uint64_t>> codec(new HuffmanCodec<uint64_t>(119, {
      {0, 0, 0},
      {57149555, 0, 0},
      {139011596, 0, 0},
      {255835594, 0, 0},
      {330249537, 0, 0},
      {388686774, 0, 0},
      {508217552, 0, 0},
      {550831114, 0, 0},
      {559246409, 0, 0},
      {599185303, 0, 0},
      {649208064, 0, 0},
      {679061455, 0, 0},
      {810488476, 0, 0},
      {951841533, 0, 0},
      {1008886329, 0, 0},
      {1022544883, 0, 0},
      {1215030156, 0, 0},
      {1305703280, 0, 0},
      {1367301635, 0, 0},
      {1453447304, 0, 0},
      {1487177499, 0, 0},
      {1603937321, 0, 0},
      {1617826947, 0, 0},
      {1643868273, 0, 0},
      {1672607981, 0, 0},
      {1681941034, 0, 0},
      {1755165354, 0, 0},
      {1781864804, 0, 0},
      {1795715718, 0, 0},
      {1977038330, 0, 0},
      {2096388952, 0, 0},
      {2204920111, 0, 0},
      {2244470522, 0, 0},
      {2330636993, 0, 0},
      {2400601988, 0, 0},
      {2424848261, 0, 0},
      {2603020391, 0, 0},
      {2622612602, 0, 0},
      {2645135839, 0, 0},
      {2660843182, 0, 0},
      {2708915136, 0, 0},
      {2724166585, 0, 0},
      {2728667725, 0, 0},
      {2890638791, 0, 0},
      {2901034693, 0, 0},
      {2941648648, 0, 0},
      {2970183398, 0, 0},
      {2998120306, 0, 0},
      {3123244280, 0, 0},
      {3187066832, 0, 0},
      {3209399506, 0, 0},
      {3230260738, 0, 0},
      {3344189994, 0, 0},
      {3345707173, 0, 0},
      {3367298820, 0, 0},
      {3397078357, 0, 0},
      {3569736966, 0, 0},
      {3816961131, 0, 0},
      {4091670162, 0, 0},
      {4237497041, 0, 0},
      {1111111111111111111, 0, 0},
      {0, 17, 44},
      {0, 25, 20},
      {0, 29, 34},
      {0, 18, 2},
      {0, 54, 49},
      {0, 28, 7},
      {0, 47, 52},
      {0, 23, 56},
      {0, 55, 26},
      {0, 24, 61},
      {0, 13, 62},
      {0, 63, 45},
      {0, 27, 15},
      {0, 64, 8},
      {0, 65, 59},
      {0, 35, 22},
      {0, 53, 38},
      {0, 58, 51},
      {0, 11, 66},
      {0, 10, 3},
      {0, 46, 67},
      {0, 69, 68},
      {0, 1, 50},
      {0, 42, 19},
      {0, 70, 6},
      {0, 31, 71},
      {0, 16, 72},
      {0, 74, 73},
      {0, 76, 75},
      {0, 78, 77},
      {0, 79, 4},
      {0, 5, 37},
      {0, 14, 36},
      {0, 80, 57},
      {0, 81, 48},
      {0, 83, 82},
      {0, 39, 84},
      {0, 86, 85},
      {0, 40, 87},
      {0, 89, 88},
      {0, 91, 90},
      {0, 93, 92},
      {0, 21, 9},
      {0, 41, 32},
      {0, 12, 43},
      {0, 95, 94},
      {0, 97, 96},
      {0, 99, 98},
      {0, 100, 33},
      {0, 60, 101},
      {0, 103, 102},
      {0, 105, 104},
      {0, 107, 106},
      {0, 109, 108},
      {0, 110, 30},
      {0, 112, 111},
      {0, 114, 113},
      {0, 116, 115},
      {0, 118, 117},
    }));

    codecs.emplace(std::pair<uint32_t, uint32_t>(SpvOpReturnValue, 0), std::move(codec));
  }

  return codecs;
}

std::unordered_set<uint32_t> GetDescriptorsWithCodingScheme() {
  std::unordered_set<uint32_t> descriptors_with_coding_scheme = {
    3816961131,
    3569736966,
    3397078357,
    3344189994,
    3230260738,
    2941648648,
    2901034693,
    2728667725,
    2400601988,
    1795715718,
    1681941034,
    1487177499,
    1453447304,
    679061455,
    649208064,
    559246409,
    388686774,
    4228303141,
    4110915453,
    4010499223,
    3927466635,
    3927338499,
    3836179806,
    3742724777,
    3619404941,
    3224480461,
    3224258475,
    3200890815,
    3742946763,
    3193597927,
    2604242419,
    2577387676,
    2181030375,
    1376656865,
    1347339159,
    938517572,
    876867882,
    429023543,
    129748122,
    4106828015,
    4093615095,
    3826846522,
    3721902098,
    3244383472,
    2891091137,
    2872580757,
    2558133383,
    2477434291,
    1839669171,
    2059975069,
    1735295265,
    1364157225,
    1237148906,
    886972033,
    674428451,
    4148979936,
    3805423332,
    3732000233,
    3717942504,
    3714664910,
    3622349409,
    3272233597,
    3204986803,
    3088511797,
    1672607981,
    2416108131,
    2250055803,
    1796311149,
    1515695460,
    537830163,
    461476226,
    206688607,
    78001013,
    3866493821,
    3417584874,
    3188115516,
    2526961521,
    2443610186,
    2394332122,
    2374216296,
    2032069771,
    2011183308,
    1904846533,
    1641070431,
    1635292159,
    1372785527,
    1369818198,
    1204787336,
    1826456251,
    1164137269,
    1081642571,
    629859130,
    253329281,
    227103506,
    11698369,
    4219766939,
    4169226615,
    3997432565,
    3873587660,
    3513669836,
    3261122899,
    2129301998,
    1774052499,
    1266262705,
    4285201458,
    4245743275,
    3907920335,
    3837583704,
    3641833815,
    3307100165,
    1232501371,
    3262572726,
    3045470312,
    2879050471,
    2801333547,
    2506771164,
    2504802016,
    2500422644,
    2473053808,
    2457690657,
    2345566651,
    2306141594,
    2154320787,
    2055637638,
    1527762373,
    1486206763,
    1159301677,
    1105835505,
    968885186,
    885645401,
    849867303,
    815034111,
    497658126,
    386525753,
    179458548,
    102358168,
    4127308103,
    4073492988,
    1473411044,
    805072272,
    3724004880,
    3602108619,
    3585315836,
    3331487616,
    3261703164,
    3235459678,
    3085703811,
    3047649911,
    2357410109,
    2291766425,
    2071351379,
    1904128160,
    1738815671,
    1531216990,
    1465623797,
    1324351672,
    1220127364,
    1144188012,
    183103444,
    116093251,
    3900859293,
    3345856521,
    3691770462,
    3263841912,
    3198541202,
    3098991995,
    3682213068,
    2963184673,
    2864543087,
    2802261839,
    2790648021,
    900101778,
    2715304020,
    100979271,
    2709694527,
    2669086217,
    2531826164,
    2651956495,
    2552825357,
    2480811229,
    3138977758,
    2434845539,
    2066323109,
    1777640493,
    1758287856,
    1746004874,
    3945482286,
    3932146199,
    3129573055,
    3126269825,
    3716914380,
    985750227,
    1543672828,
    3189039115,
    1839499483,
    2696349144,
    1536350567,
    3971481069,
    3001444829,
    4028622909,
    215293834,
    213642219,
    153085016,
    1189681639,
    165054168,
    29517006,
    2614879967,
    27865391,
    1649426421,
    4239834800,
    1947620272,
    28782128,
    3207966516,
    3713290482,
    2042001863,
    2724166585,
    2356768706,
    1793544760,
    4092654294,
    2157103435,
    2087004702,
    2043873558,
    27177503,
    1033363654,
    4214779116,
    408465899,
    451264926,
    2377112119,
    1182296898,
    760554870,
    3566035349,
    2630220147,
    4192247221,
    1572088444,
    3538592682,
    769422756,
    1674803691,
    630964591,
    3458449569,
    565334834,
    137840602,
    3955205564,
    2009007457,
    1258105452,
    333554713,
    3923810593,
    126463145,
    3445109809,
    2966409025,
    2849215484,
    1910240213,
    3131890669,
    586244865,
    2320303498,
    3116932970,
    1317265040,
    2812498065,
    1466938734,
    4064212479,
    2613179511,
    2095546797,
    1671139745,
    2568512089,
    3695940604,
    1119069977,
    215027449,
    4123141705,
    3495546641,
    1978689945,
    3202324433,
    3783543823,
    2674422363,
    1352628475,
    1290956281,
    1894417995,
    740921498,
    4211577142,
    1033081852,
    3884846406,
    3253403867,
    2790624748,
    2538917932,
    2144962711,
    3323202731,
    4290024976,
    2564745684,
    2963744582,
    2443959748,
    354479447,
    750870327,
    1918481917,
    4032662899,
    3587381650,
    2414725163,
    1081611718,
    1625742020,
    2308565678,
    1871105284,
    2807907995,
    2121980967,
    1054641568,
    413918748,
    1917336504,
    1816558243,
    4130950286,
    1522979646,
    1669959736,
    1320550031,
    3104643263,
    3823959661,
    3525913657,
    3584683259,
    2918750759,
    3536390697,
    94303122,
    3296691317,
    801484894,
    2496463830,
    3266028549,
    3085157904,
    973908139,
    3787909072,
    3107413701,
    2378763734,
    920604853,
    2516325050,
    1838993983,
    1603937321,
    3183924418,
    1945006185,
    3982311384,
    2682510803,
    680388473,
    979993429,
    2405770322,
    461040879,
    2817579280,
    14113753,
    2894979602,
    168339452,
    951841533,
    4154758669,
    2637132451,
    3877583949,
    1949856502,
    922996215,
    3941049054,
    4182141402,
    2262220987,
    1957218950,
    2094550054,
    1846856260,
    3499234137,
    3086631065,
    3054834317,
    593829839,
    522971108,
    1162127370,
    4233562270,
    2780190687,
    1558345254,
    3716353056,
    3518630848,
    1158929937,
    2038205856,
    86116519,
    4185661467,
    975807626,
    3910458990,
    4124281183,
    3361419439,
    171334650,
    2590402790,
    2890570341,
    2303184249,
    385229009,
    1998433745,
    1717510093,
    4022124023,
    1429389803,
    945128292,
    904486530,
    3869890846,
    619875033,
    459968607,
    3743748793,
    359054425,
    1417363940,
    3653985133,
    255835594,
    1047011733,
    2763232252,
    1329499601,
    328661377,
    2162274327,
    2100532220,
    4255182614,
    4243119782,
    3982047273,
    4053789056,
    401211099,
    950731750,
    1319785741,
    32085358,
    3882634684,
    3117071189,
    3554463148,
    3570219049,
    3535289452,
    2314864456,
    3913885196,
    2763960513,
    1079999262,
    27130513,
    3033873113,
    2976581453,
    2598189097,
    595410904,
    1572834111,
    13319433,
    1084574846,
    2123388694,
    560078433,
    1679946323,
    3518703473,
    184634770,
    296981500,
    1646147798,
    455591063,
    1325348861,
    3224952074,
    1027242654,
    2281956980,
    4221373527,
    1289566249,
    4044928561,
    882718761,
    1510333659,
    836581417,
    1901166356,
    2276405827,
    4052965752,
    1155765244,
    503145996,
    251209228,
    495107308,
    3944781937,
    37459569,
    4248015868,
    4198082194,
    1302400505,
    4106658327,
    680016782,
    2319227476,
    2738307068,
    3929248764,
    2850246066,
    1824526196,
    3912967080,
    3044723416,
    3133016299,
    2517964682,
    3647586740,
    3653838348,
    929101967,
    3571454885,
    2806296851,
    977312655,
    646282397,
    3448018532,
    824323032,
    204234270,
    1579585816,
    3712763835,
    1212872174,
    3953984401,
    3168953855,
    2944827576,
    1582841441,
    2796901051,
    3323682385,
    1317058015,
    2557550659,
    1620634991,
    2986830770,
    2490492987,
    1817271123,
    40653745,
    1696076631,
    2466126792,
    4169878842,
    3251128023,
    2444465148,
    678695941,
    2481746922,
    2836440943,
    774727851,
    2246405597,
    4028028350,
    2524697596,
    1977038330,
    2817823941,
    2219733501,
    688216667,
    3634598908,
    3232633974,
    2724625059,
    3269075805,
    3732640764,
    2263349224,
    1680746207,
    2414984922,
    2507457870,
    50998433,
    3092528578,
    3712946115,
    1543935193,
    807276090,
    1221183390,
    172029722,
    2122275289,
    3990925720,
    2261697609,
    2736881867,
    295017943,
    3278176820,
    3748965853,
    3174324790,
    1103903216,
    3184177968,
    1113409935,
    2299842241,
    2162986400,
    1538342947,
    4056442905,
    1631434666,
    205885885,
    1594733696,
    1955104493,
    1022309772,
    3820814597,
    993150979,
    1209418480,
    1784441183,
    3958731802,
    2250225826,
    3065160070,
    2024071551,
    107497541,
    628544021,
    2732195517,
    4241486415,
    3969279737,
    870594305,
    2916400082,
    1193734351,
    3202349435,
    3831290364,
    3282979782,
    3928764629,
    1308462133,
    3216471040,
    2433519008,
    2022961611,
    3604842236,
    3374978006,
    2855895374,
    3496407048,
    1482251215,
    3994511488,
    2997832431,
    1132589448,
    1348149915,
    2092468906,
    2451531615,
    779021139,
    3730093054,
    3413713311,
    1022915255,
    2204920111,
    2660843182,
    1080545747,
    1642805350,
    1766422419,
    4141567741,
    1558990974,
    4185590212,
    2841468319,
    701281393,
    3325419312,
    451957774,
    357505993,
    1156369516,
    3187387500,
    2259467579,
    2678954464,
    3154597438,
    543558236,
    2359973133,
    1990431740,
    2705477184,
    1041368449,
    3122368657,
    3181646225,
    1094423548,
    2955375511,
    2888125966,
    153013225,
    2936040203,
    1758530522,
    573901046,
    3030911670,
    1675922848,
    4235213885,
    4091916710,
    2633682514,
    4254584852,
    2328748202,
    3357301402,
    3877813395,
    2004567202,
    2496297824,
    3334207724,
    1600149091,
    293528591,
    1782996825,
    3757282300,
    1107206446,
    1092948665,
    1797960910,
    1206726575,
    1496351055,
    3021406120,
    99347751,
    3797204453,
    1468919488,
    797415788,
    1314843976,
    2934934694,
    490769168,
    1474506522,
    3811268385,
    864295921,
    3081676220,
    151810803,
    2588618056,
    2998120306,
    416853049,
    3495967422,
    3233393284,
    508007510,
    759277550,
    1971252067,
    869050696,
    810488476,
    745556697,
    789872778,
    3362723943,
    1617826947,
    3260309823,
    2197904616,
    1199157863,
    1643868273,
    2430404313,
    321630747,
    2503194620,
    3194725903,
    2881225774,
    3997952447,
    1389644742,
    2713718873,
    3585511591,
    1684282922,
    3366848728,
    284226441,
    1541020250,
    4018237905,
    1369578001,
    2424848261,
    2654325647,
    1626224034,
    1081536219,
    309040124,
    123060826,
    3997038726,
    1670691893,
    1543280290,
    443347828,
    1776629361,
    3118548424,
    478440524,
    679771963,
    3729929345,
    4244789645,
    2366506734,
    2838165089,
    1619778288,
    1313182965,
    3240680626,
    1323407757,
    883854656,
    2194691858,
    15502752,
    3760372982,
    1366337101,
    3656163446,
    295018543,
    825595257,
    57149555,
    2563789125,
    2353194283,
    2636942752,
    4026740269,
    3570411982,
    123108003,
    3782362128,
    1280126114,
    1410849099,
    4228502127,
    3609540589,
    3365041621,
    269823086,
    348988933,
    1636389511,
    2936586309,
    2761603302,
    2318200267,
    449954059,
    2895413148,
    1755165354,
    4274214049,
    778500192,
    3345707173,
    3732136051,
    721450866,
    1600392975,
    2466255445,
    4050155669,
    3541895912,
    1139547465,
    394654115,
    1380991098,
    3516240523,
    2234361374,
    1094817798,
    744817486,
    3564402361,
    1452222566,
    1851510470,
    3619787319,
    4265894873,
    216945449,
    3061690214,
    2910557180,
    255227811,
    4167600590,
    1587209598,
    3157581152,
    3184381405,
    2572638469,
    615748604,
    2532518896,
    1774874546,
    599185303,
    1561718045,
    1742737136,
    1674464100,
    3136865519,
    706016261,
    2793529873,
    3504981554,
    4155122613,
    2080953106,
    1104362365,
    2879917501,
    850497536,
    1392080469,
    1287937401,
    718877177,
    1917966999,
    1822823090,
    3701632935,
    3591222197,
    2817335337,
    1941148668,
    3110479131,
    3289213933,
    583624926,
    468372467,
    1633850097,
    2110223508,
    898191441,
    112745085,
    4018820793,
    3085119011,
    2919626325,
    3094857332,
    2348201466,
    2192810893,
    4163160985,
    1269075360,
    3952316364,
    2881886868,
    439764402,
    1584774136,
    169674806,
    3759072440,
    102542696,
    2996180816,
    804899022,
    1015552308,
    963902061,
    3504158761,
    2002490364,
    2806716850,
    265778447,
    4083122425,
    181902171,
    1238120570,
    75986790,
    1265796414,
    899570100,
    2988365258,
    3655201337,
    3654061472,
    3061856840,
    1077859090,
    615341051,
    3678875745,
    3349230696,
    3647606635,
    2549309392,
    1508570930,
    1766401548,
    1448448666,
    1499923635,
    2882994691,
    3674863070,
    3056042030,
    4240893633,
    1395113939,
    2964622752,
    1951208733,
    3536941067,
    4176581069,
    1203545131,
    3092754101,
    246375791,
    2736026107,
    1069781886,
    3687777340,
    1564342316,
    535067202,
    1395923345,
    3240977890,
    1447712361,
    2602027658,
    718301639,
    3123244280,
    1032593647,
    2840366496,
    2680819379,
    3839389658,
    277023757,
    1172110445,
    1755648697,
    2472176885,
    223800276,
    625975427,
    976111724,
    4145966869,
    2789375411,
    618087261,
    249378857,
    4058280485,
    827698488,
    1558001705,
    3561482820,
    2562485583,
    4243138030,
    615982737,
    1220643281,
    150685616,
    3091876332,
    1040775722,
    669982125,
    4116080964,
    3582002820,
    910398460,
    1036475267,
    3800912395,
    146392076,
    1686512349,
    2326636627,
    2839816704,
    3502816184,
    226836633,
    3953733490,
    257136089,
    819503463,
    2863084840,
    1949759310,
    210754155,
    1367301635,
    3822983876,
    4273793488,
    3635397748,
    3930494584,
    3127921440,
    3167253437,
    3868239231,
    1859128680,
    3480031018,
    3810805277,
    2677252364,
    156014509,
    3627739127,
    2321729979,
    1146476634,
    4039938779,
    1964254745,
    2055836767,
    119981689,
    2629265310,
    2448331885,
    3737376990,
    144116905,
    2272221101,
    2197874825,
    1277245109,
    2503770904,
    360730278,
    3489360962,
    1166917451,
    707478563,
    4155586396,
    162255877,
    347505241,
    4215670524,
    3187066832,
    2399809085,
    2754074729,
    4060703604,
    628331516,
    1304296041,
    616435646,
    4080527786,
    1443829854,
    2512398201,
    708736129,
    13107491,
    3794803132,
    2049792025,
    2455417440,
    3367313400,
    3357250579,
    3694383800,
    2339901602,
    3242843022,
    2282454607,
    1243764146,
    835458563,
    1297706389,
    464259778,
    1766994680,
    1294403159,
    2568098594,
    3107165180,
    4040340620,
    3352361837,
    1031290113,
    2903897222,
    1677700667,
    3160388974,
    107544081,
    3044188332,
    2285081596,
    2835131395,
    2984459037,
    4174489262,
    1236389532,
    2938237924,
    321459212,
    3407526215,
    300939750,
    3441531391,
    2909957084,
    3192069648,
    1849065716,
    2524531022,
    505940164,
    4121643374,
    3774892253,
    3197739982,
    2161102232,
    2715370488,
    1992893964,
    1781864804,
    587888644,
    1039111164,
    4237497041,
    451382997,
    969500141,
    1415510495,
    3743398113,
    3027538652,
    2525173102,
    1708264968,
    3366040354,
    1100599986,
    188347929,
    2597020383,
    2705434194,
    2593884753,
    3472123498,
    2975894973,
    3152745753,
    1154919607,
    1930923350,
    3287039847,
    1372881231,
    2280400314,
    3369343584,
    2351620600,
    2645135839,
    2752766693,
    1471851763,
    1989520052,
    1141965917,
    1503477720,
    653708953,
    1765126703,
    2432827426,
    95470391,
    2567901801,
    2589449658,
    4218799564,
    3249265647,
    3673811979,
    210116709,
    1593584949,
    1791352211,
    3457985288,
    3345288309,
    531559080,
    2491124112,
    3410158390,
    4224872590,
    3705139860,
    162608772,
    4258229445,
    925559698,
    3928842969,
    4253051659,
    3633746133,
    3867307935,
    3560665067,
    798915737,
    2945369269,
    2677264274,
    2278571792,
    177111659,
    85880059,
    1297165140,
    1630583316,
    2232491275,
    1848784182,
    2487708241,
    626480004,
    3427283542,
    2108571893,
    304448521,
    3332104493,
    2244470522,
    436416061,
    221900294,
    1502470404,
    3552593177,
    440421571,
    450406196,
    503094540,
    3836822275,
    2708915136,
    3750617468,
    1119744229,
    3614752756,
    921246433,
    2285438321,
    626892406,
    2362972044,
    72782198,
    2929019254,
    2795773560,
    907126242,
    155458798,
    2798552666,
    1404739463,
    4285652249,
    1998444837,
    908777857,
    872544165,
    910429472,
    135486769,
    3457269042,
    426360862,
    1725011064,
    296836635,
    1322549027,
    2044728014,
    1530183840,
    529742207,
    4272200782,
    1341516288,
    2608484640,
    41739659,
    3260579369,
    2745872368,
    2894051250,
    862784766,
    3077271274,
    3094180193,
    3619626927,
    3745223676,
    2976066508,
    2854085372,
    2959147533,
    3266548732,
    1776526161,
    3712296962,
    1955871800,
    2580096524,
    2507709226,
    3564865233,
    948086521,
    1548254487,
    142465290,
    1472185378,
    1459457331,
    2274226560,
    3153451899,
    492958971,
    3563213618,
    1285705317,
    410274915,
    3710645347,
    1309728002,
    2119793999,
    1343794461,
    4024173916,
    2383939514,
    955476870,
    2698156268,
    35240468,
    2655147757,
    3764205609,
    3802564010,
    170690025,
    2311941439,
    3181546731,
    3866587616,
    3648138580,
    93914936,
    170378107,
    2120623674,
    1064945649,
    1618754372,
    244668133,
    247698428,
    3669223677,
    470277359,
    1781765116,
    1691572958,
    1373856501,
    2668769415,
    1087394637,
    1009983433,
    2180701723,
    4008405264,
    2831059514,
    2645120714,
    2649103430,
    2664825925,
    790502615,
    1739837626,
    2293247016,
    1784648440,
    1887808856,
    1788504755,
    112452386,
    1979978194,
    3462674048,
    2170273742,
    538168945,
    753954113,
    374731234,
    3715846592,
    1962971231,
    1860649552,
    1378082995,
    665789406,
    1717555224,
    139011596,
    1375043498,
    1618544981,
    1889460471,
    2262321736,
    1788301425,
    1652168174,
    2668680621,
    2636946065,
    2856623532,
    2759951687,
    959681532,
    3209399506,
    3055195668,
    1227221002,
    508217552,
    3289969989,
    243178923,
    2956189845,
    3075866530,
    2274779301,
    3940720663,
    3998230222,
    1178317551,
    4016096296,
    1545450160,
    2842919847,
    314809953,
    2952850186,
    3747079365,
    4147239510,
    169135842,
    1332643570,
    2994529201,
    973521782,
    1584369690,
    1043738701,
    2851900832,
    290391815,
    283209196,
    2468230023,
    1164221089,
    1991787192,
    3358097187,
    51041423,
    52882140,
    2339018837,
    2053214130,
    3757479030,
    158160339,
    853200279,
    1986584654,
    438318340,
    827246872,
    3299488628,
    2924263085,
    3472029049,
    2736844435,
    677668732,
    604894932,
    1158021131,
    1400019344,
    2268204687,
    1450415100,
    3854557817,
    1543646433,
    1278448636,
    342615870,
    1554194368,
    3080024605,
    3423702268,
    1675764636,
    1622381564,
    2078849875,
    2113115132,
    1380160211,
    3132876285,
    125015036,
    269576093,
    94145952,
    2777172031,
    2683080096,
    3812456892,
    488500848,
    3270430997,
    2895151306,
    116376005,
    400248103,
    406044930,
    1616846013,
    10142671,
    763027711,
    225200779,
    1062250709,
    2013867381,
    2113506324,
    1692932387,
    1827244161,
    3124618210,
    2096472894,
    2924146124,
    2128251367,
    2433358586,
    1939359710,
    2593325766,
    2879917723,
    694743357,
    2902069960,
    220008971,
    3090408469,
    917019124,
    1705716306,
    3263901372,
    3347863687,
    3447882276,
    1661163736,
    3617689692,
    3928555688,
    1057578789,
    435256475,
    4101009465,
    1941403425,
    198967948,
    3733675151,
    2043684541,
    3517169445,
    2226776400,
    2853403709,
    529383565,
    2807448986,
    4234287173,
    1019457583,
    1022544883,
    2493146691,
    1054461787,
    1008886329,
    1136775085,
    1191015885,
    1196280518,
    1979847999,
    50385656,
    1918742169,
    3999472204,
    3697687030,
    2220475432,
    2358141757,
    2360004627,
    4245257809,
    236660303,
    429277936,
    342159236,
    2622612602,
    371428004,
    373079619,
    643418617,
    2095027856,
    1071164424,
    1136911283,
    1548491889,
    2169307971,
    375530199,
    1510422521,
    3151638847,
    1698730948,
    2231688008,
    2604576561,
    2771938750,
    2996594997,
    289648234,
    348584153,
    2748350697,
    2926633629,
    2123683379,
    369686787,
    742917749,
    3538158875,
    2937761472,
    1545298048,
    1321616112,
    2855506940,
    900522183,
    1578775276,
    2217833278,
    2012838864,
    3753486980,
    2839765116,
    2464905186,
    2621255555,
    1305703280,
    861753115,
    3319278167,
    3063300848,
    149720480,
    1082941229,
    3337532056,
    2248357849,
    3675926744,
    1508550646,
    2289803479,
    3456899824,
    3931641900,
    3970432934,
    3419674548,
    1093210099,
    456043370,
    848380423,
    1287304304,
    1526654696,
    2055664760,
    1373166395,
    4291477370,
    2195550588,
    2847102741,
    3399062057,
    1641565587,
    2888753905,
    3579593979,
    3653059026,
    3757851979,
    2922615804,
    2919796598,
    1553476262,
    2566666743,
    3759503594,
    550831114,
    3761155209,
    3762806824,
    3902853271,
    4140081844,
    14244860,
    3847846774,
    150820676,
    1278818058,
    850592577,
    1206571206,
    1734446471,
    2117320444,
    1382106590,
    2436009347,
    2118972059,
    2951272396,
    36096192,
    117998987,
    473485679,
    2244928358,
    476788909,
    3489269251,
    610429940,
    480092139,
    481743754,
    871966503,
    918189168,
    601656217,
    933769938,
    939671928,
    1799299383,
    3312467582,
    1149665466,
    3006548167,
    1310740861,
    3602693817,
    1461645203,
    3367691969,
    1800404122,
    3486057732,
    1862284649,
    2076833303,
    2213411495,
    2805256437,
    3927915220,
    3000904950,
    2094647776,
    3333131702,
    1315613425,
    3752211294,
    603915804,
    3505028338,
    663258455,
    3322500634,
    1612225949,
    3606320646,
    157110413,
    1352397672,
    3861006967,
    452208841,
    18776483,
    1058429216,
    37009196,
    564884461,
    876864198,
    2952260510,
    2860348412,
    928261291,
    1164724902,
    2775815164,
    1332774287,
    780957373,
    939415664,
    1513770932,
    788046331,
    1692600167,
    4069810315,
    673708384,
    4024252457,
    1932614728,
    2148510256,
    3131224670,
    2388524817,
    2460489993,
    2676385521,
    826214242,
    3692647551,
    3063508455,
    3071766530,
    2063832060,
    1525861001,
    3073418145,
    837715723,
    3075069760,
    3076721375,
    3078372990,
    983243705,
    3083327835,
    171307615,
    1824016656,
    3084979450,
    1310404265,
    1775308984,
    3114708520,
    3116360135,
    3121314980,
    3134527900,
    1691646294,
    2804281092,
    97231530,
    3136179515,
    3204260786,
    3276225962,
    1220749418,
    3588205699,
    3874089391,
    4044115788,
    3268751013,
    743407979,
    166253838,
    1356063462,
    1368383673,
    2279700640,
    2130747644,
    3945795573,
    2780898906,
    3635542517,
    425022309,
    517919178,
    4061558677,
    2190437442,
    543621065,
    753756604,
    2500819054,
    1004589179,
    1165671422,
    30433743,
    3444275347,
    1335363438,
    1913735398,
    1265998516,
    3829325073,
    3662767579,
    463084678,
    1351676723,
    1391866096,
    3398925952,
    1631216488,
    815757910,
    1915438939,
    2427834344,
    1445161581,
    1890300748,
    2864863800,
    1961990747,
    575205902,
    2037710159,
    2037814253,
    617312262,
    3732916270,
    783918780,
    2257843797,
    2096388952,
    2338272340,
    1434223270,
    578132535,
    1980341560,
    1002144380,
    3244716568,
    4258414038,
    3271748023,
    3304438238,
    3717523241,
    3370185097,
    3435931956,
    1957265068,
    3602522282,
    2547657777,
    439998433,
    3838648480,
    3913593633,
    3989799199,
    906176560,
    1894133125,
    4046301857,
    4242327928,
    630592085,
    2693892518,
    4292991777,
    545678922,
    125792961,
    3015046341,
    132755933,
    2615111110,
    1570165302,
    1440646342,
    436066778,
    565233904,
    600906020,
    602222721,
    3951925872,
    1496901698,
    1522901980,
    2785441472,
    3041450802,
    1637661947,
    2127660080,
    3487022798,
    2269114589,
    1314834580,
    2315690100,
    3817149113,
    4091670162,
    1431749301,
    1858116930,
    2213946343,
    2225172640,
    2263866576,
    2727022058,
    2752967311,
    2864705739,
    3052439312,
    3510257966,
    2614053317,
    3297860332,
    3670298840,
    3732709413,
    3788324110,
    4098876453,
    4290374884,
    1623013158,
    3381478137,
    17185761,
    3931288033,
    2890638791,
    330388453,
    346929928,
    2022347217,
    4083347580,
    533021259,
    564302770,
    1917602962,
    680157484,
    3264086791,
    3727034815,
    798549062,
    3068463300,
    669812542,
    1965902997,
    2311072371,
    3079287749,
    2542834724,
    1587730355,
    2558655180,
    1838763297,
    4172568578,
    2160380860,
    2950446516,
    1830851200,
    3214537066,
    3234673086,
    3652695478,
    3103302036,
    3465954368,
    4180570743,
    3534518722,
    371186900,
    4091394002,
    1013756921,
    443558693,
    591140762,
    656610661,
    2064733527,
    3808408202,
    983299427,
    4217306348,
    1164218401,
    2036361232,
    3237903670,
    2970183398,
    2293637521,
    135920445,
    1596005536,
    868652905,
    1191735827,
    3987079331,
    1365842164,
    1508074873,
    1642818143,
    3436143898,
    4105051793,
    1863199739,
    3425841570,
    1070791291,
    2135340676,
    2639720559,
    3364388739,
    3797761273,
    2092100514,
    2098706974,
    2329992200,
    414444763,
    2759250216,
    2913136690,
    3012980338,
    3327770644,
    4128942283,
    3362344229,
    161668409,
    3401762422,
    2852854788,
    4237092412,
    1245448751,
    3702405475,
    918849409,
    3829682756,
    1612361408,
    255302575,
    414620710,
    386293029,
    618761615,
    686024761,
    744062262,
    1502028603,
    1543798545,
    1641415225,
    1548121999,
    2257971049,
    2124837447,
    878733439,
    2340670452,
    2674090849,
    3118011750,
    2816338013,
    178571546,
    2841008029,
    3249261197,
    370232173,
    4092487128,
    3787567939,
    3898287302,
    4142016703,
    4285779501,
    30663912,
    151672195,
    180913835,
    3534235309,
    34183582,
    4083161638,
    651464351,
    1410311776,
    371621315,
    421602934,
    458937500,
    2710583246,
    712168842,
    730943059,
    1519723107,
    875212982,
    1247793383,
    4217322139,
    989813600,
    1057606514,
    3764662384,
    1443547269,
    3066811685,
    3598957382,
    1791427568,
    1171541710,
    3930727258,
    1473799048,
    1296054774,
    1747355813,
    765238787,
    2023008475,
    1190147516,
    2344328209,
    2495155989,
    2577859137,
    2857814560,
    3127329373,
    3296722158,
    2773229577,
    3376009661,
    3450001968,
    920941800,
    3526837441,
    3858973601,
    1702168830,
    4088613871,
    1464587427,
    223310468,
    388034151,
    2346547796,
    1663234329,
    1750829822,
    1967643923,
    2881302403,
    2278706468,
    2326990117,
    2511346984,
    3088785099,
    2616085763,
    3027500544,
    3417583519,
    4178218543,
    1412908157,
    797934924,
    3533637837,
    1449907751,
    3362830643,
    1451831482,
    2637935122,
    3070114915,
    3023287679,
    551924251,
    1669930486,
    46736908,
    2870852215,
    1120149824,
    2923708820,
    3887377256,
    3464197236,
    4241374559,
    527665290,
    996663016,
    885020215,
    1763758554,
    3059119137,
    2555315060,
    2762094724,
    2530899578,
    2770161927,
    2262137600,
    3547456240,
    858902117,
    1140367371,
    1215030156,
    443490822,
    294390719,
    3032677281,
    1917451875,
    4184019303,
    3277199633,
    1271484400,
    1297294717,
    3560552546,
    171494987,
    195244192,
    3002890475,
    1811839150,
    265392489,
    1461398554,
    3205759417,
    333855951,
    529068443,
    660038281,
    557400685,
    663341511,
    930804377,
    1922045399,
    716890919,
    162167595,
    1654776395,
    1779143013,
    1123617794,
    2984325996,
    1162789888,
    1318479490,
    1235468610,
    3561562003,
    1486207619,
    1551372768,
    1850331254,
    3255947500,
    1037370721,
    1989327599,
    2137526937,
    835638766,
    2269130237,
    1962162282,
    3244209297,
    2330636993,
    3095831808,
    1396344138,
    2603020391,
    3434076295,
    3280064277,
    2656211099,
    3335250889,
    2550961007,
    3510242586,
    3536471583,
    3950980241,
    4033586023,
    117250846,
    3088282680,
    4041974454,
    4244540017,
    1167160774,
    899320334,
    1200870684,
    1752686878,
    1906988301,
    3804101227,
    2575525651,
    2919787747,
    3508792859,
    3548535223,
    3783756895,
    3797961332,
    4043078107,
    3115038057,
    2313593054,
    49456560,
    592180731,
    1051471757,
    1097775533,
    706238670,
    877895868,
    1173092699,
    1461897718,
    1767704813,
    1770165905,
    1923453688,
    2212501241,
    2305269460,
    2488410748,
    3782099915,
    2844616706,
    3383007207,
    3392887901,
    504514034,
    3765247327,
    1000070091,
    3727494858,
    3657635382,
    3839047923,
    3886529747,
    4069720347,
    4164704452,
    342197850,
    3540244297,
    2513230733,
    4117704995,
    3367298820,
    2680283743,
    3119663365,
    3697738938,
    545363837,
    163402553,
    5908395,
    129135650,
    2289183712,
    200922300,
    761731755,
    894529125,
    1086964761,
    1168927492,
    2100052708,
    2438466459,
    3390051757,
    2498042266,
    2557754096,
    2600961503,
    487719832,
    703543228,
    2726532092,
    4199470013,
    3142155593,
    2550501832,
    4076840151,
    200553094,
    380957745,
    572905105,
    462664429,
    1466804584,
    330249537,
    2605012269,
    491456522,
    4126287524,
    502863753,
    952536201,
    3510682541,
    1137442027,
    1665981878,
    1761469971,
    3085467405,
    2045285083,
    796985462,
    3433956341,
    2217966239,
    2183547611,
    2279273489,
    1916983087,
    2348676810,
    2403632109,
    2409539315,
    545986953,
    176166202,
    2477389837,
    2573160348,
    2796513469,
    3972309363,
    528662843,
    1038982109,
    1125913837,
    1318081294,
    1417425499,
  };
  return descriptors_with_coding_scheme;
}
