target=upperlower xcase batch1 batch2 batchw xletter tablemod posmod markmod1 markmod2

#include "header.inc"
#include "confparm.inc"
#define TRANS 1
\text{sizelim1=5}
\text{sizelim2=1999}

#if #TARGET (upperlower)
 \title{Transform: Upper or lower case}
 \text{data=randrow(
	upper,1
	lower,2
)}
 \text{result=transforms the alphabetic letters of <tt>\ll</tt>
	to \data[1] case.}
#endif

#if #TARGET (xcase)
 \title{Transform: Case exchange}
 \text{result=transforms upper-case letters to lower case and lower-case letters to
       upper-case.}
#endif

#if #TARGET (batch1)
 \title{Transform: Modif-batch I}
 \text{chars=\allchars}
 \text{c=wims(charcnt \alpha)}
 \text{c=wims(char randint(1..\c) of \alpha)}
 \text{data=randomrow(
   upper-case letters,\upper
   lower-case letters,\lower
   alphabetic characters,\alpha
   numeric digits (0,1,...,9),\digits
   spacing characters (space, tab, new ligne),\space
)}
 \text{result=transforms all the \data[1] in the string into <tt>'\c'</tt>.}
#endif

#if #TARGET (batch2)
 \title{Transform: Modif-batch II}
 \text{chars=\allchars}
 \text{c=wims(charcnt \alpha)}
 \text{c=wims(char randint(1..\c) of \alpha)}
 \text{data=randomrow(
   vowel letters (both cases),aeiouyAEIOUY
   upper-case vowel letters,AEIOUY
   lower-case vowel letters,aeiouy
   consonant letters (both cases),bcdfghjklmnpqrstvwxzBCDFGHJKLMNPQRSTVWXZ
   upper-case consonant letters,BCDFGHJKLMNPQRSTVWXZ
   lower-case consonant letters,bcdfghjklmnpqrstvwxz
   odd numeric digits,13579
   even numeric digits,02468
   mathematic operators (<tt>\mathop</tt>),\mathop
)}
 \text{result=transforms all the \data[1] in the string into <tt>'\c'</tt>.}
#endif

#if #TARGET (batchw)
 \title{Transform: Modif-batch by word}
 \text{chars=\allchars}
 \text{c=wims(charcnt \alpha)}
 \text{c=wims(char randint(1..\c) of \alpha)}
 \text{word=wims(exec randic randint(8..14))}
 \text{word=wims(deaccent \word)}
 \text{wordl=wims(tolower \word)}
 \text{wordu=wims(toupper \word)}
 \integer{dir=random(0,1)}
 \text{data=randrow(
   both cases,\wordl\wordu
   lower-case only,\wordl
   upper-case only,\wordu
)}
 \text{result=transforms all the characters in the string that appear in
	the word <tt>\word</tt> (\data[1]) into
	<tt>'\c'</tt>.}
#endif

#if #TARGET (xletter)
 \title{Transform: Exchange of letters}
 \text{c=wims(charcnt \alpha)}
 \text{sh=shuffle(\c)}
 \text{c1=wims(char \sh[1] of \alpha)}
 \text{c2=wims(char \sh[2] of \alpha)}
 \text{result=transforms the string by replacing the letter <tt>'\c1'</tt>
	by <tt>'\c2'</tt>, and vice versa.}
#endif

#if #TARGET (tablemod)
 \title{Transform: By table}
 \text{cc=wims(text delete \space in \chars)}
 \text{cc=wims(words2items wims(text expand \cc using 10))}
 \text{c2=item(1..10,shuffle(\cc))}
 \text{c1=wims(sort items \c2)}
 \text{tab1=wims(nospace wims(items2words \c1))}
 \text{tab2=wims(nospace wims(items2words \c2))}
 \text{C1=wims(replace internal , by </tt></td><td align=center><tt>
		in <td align=center><tt>\c1</tt></td>)}
 \text{C2=wims(replace internal , by </tt></td><td align=center><tt>
		in <td align=center><tt>\c2</tt></td>)}
 \text{result=modifies the characters of the string according to the following table.
    <p><center><table border=1>
    <tr><th>Original character\C1</tr>
    <tr><th>Transformed to\C2</tr>
    </table></center>}
#endif

#if #TARGET (posmod)
 \title{Transform: Positional modif.}
 \integer{start=randint(1..10)}
 \integer{period=randint(2..8)}
 \text{str=wims(values \start+\period*x for x in 0,1,2,3,4)}
 \text{c=wims(charcnt \alpha)}
 \text{c=wims(char randint(1..\c) of \alpha)}
 \text{result=remplaces the characters in positions number \str,... of the string
	by <tt>'\c'</tt>. (Repeating every \period characters, starting from
	number \start.)}
#endif

#if #TARGET (markmod1)
 \title{Transform: Marker I}
 \integer{markcnt=1}
 #define MARK 1
#endif
#if #TARGET (markmod2)
 \title{Transform: Marker II}
 \integer{markcnt=randitem(2,3,-1)}
 #define MARK 1
#endif

#ifdef MARK
 \text{chars=\allchars}
 \text{c=wims(charcnt \alpha)}
 \text{c=wims(char randint(1..\c) of \alpha)}
 #include "mark.inc"
 \text{result=transforms \data[1] of the string into <tt>'\c'</tt>.}
#endif

\text{compare=}
\text{listsc=}
\integer{shift=randint(0..10)}
\text{ns=wims(values x for x in 0,1,2,3,4,5,
	  8,10,10+\shift,21+\shift,33+\shift,
	  42+\shift,51+\shift,72+\shift,83+\shift,100+\shift,
	  randint(150..200),randint(200..300),randint(500..800),
	  randint(\sizelim2-100..\sizelim2-1)
)}
\for{n in \ns}{
 #include "list.inc"
 \text{listsc=wims(append item "\list" to \listsc)}
#if #TARGET (upperlower)
 \text{list1=\data[2]=1?wims(toupper \list):wims(tolower \list)}
#endif
#if #TARGET (xcase)
 \text{list1=wims(translate internal \upper\lower to \lower\upper in \list)}
#endif
#if #TARGET (batch1) || #TARGET (batch2) || #TARGET (batchw)
 \text{nn=wims(charcnt \data[2])}
 \text{cc=wims(makelist \c for x=1 to \nn)}
 \text{cc=wims(text select \c in \cc)}
 \text{list1=wims(translate internal \data[2] to \cc in \list)}
#endif
#if #TARGET (xletter)
 \text{list1=wims(translate internal \c1\c2 to \c2\c1 in \list)}
#endif
#if #TARGET (tablemod)
 \text{list1=wims(translate internal \tab1 to \tab2 in \list)}
#endif
#if #TARGET (posmod)
 \text{cand=wims(text repeat \c to \n)}
 \text{mask=wims(char 1 to \period of 1000000000000000000000000000)}
 \text{header=\start>1?wims(char 1 to \start-1 of \list):}
 \text{body=wims(char \start to -1 of \list)}
 \text{list1=wims(text insert \cand into \body mask \mask)}
 \text{list1=\header\list1}
#endif
#ifdef MARK
 \text{mask=wims(text mark \data[2] in \list)}
 \text{appear=item(\markcnt,wims(positionof char 1 in \mask))}
 \text{list1=\appear notsametext ?wims(replace char number \appear by \c in \list):\list}
#endif
 \text{compare=\compare(\list1),}
}

#include "src.inc"
#include "example.inc"
#include "main.inc"

