/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.Formula;
import SharpTools.Function;
import SharpTools.SharpCellEditor;
import SharpTools.SharpOptionPane;
import SharpTools.SharpTools;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.JTextField;

class FunctionListListener
implements ActionListener {
    public static Properties translation = SharpTools.translation;
    JFrame frame;
    JTable table;
    final ImageIcon helpIcon = new ImageIcon(this.getClass().getResource("/images/help32.gif"));

    FunctionListListener(JFrame frame, JTable table) {
        this.frame = frame;
        this.table = table;
    }

    public void actionPerformed(ActionEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        String funcName = (String)cb.getSelectedItem();
        try {
            if (this.table.isEditing()) {
                int row = this.table.getEditingRow();
                int col = this.table.getEditingRow();
                JTextField text = ((SharpCellEditor)this.table.getCellEditor(row, col)).getTextField();
                if (!funcName.equals(translation.getProperty("Functions"))) {
                    text.replaceSelection(funcName + "()");
                    Function fh = Formula.getFuncHandler(funcName);
                    if (fh != null && fh.requireParams()) {
                        text.setCaretPosition(text.getCaretPosition() - 1);
                    }
                } else {
                    this.showGeneralFunctionHelp();
                }
                text.requestFocus();
            } else {
                Function fh = Formula.getFuncHandler(funcName);
                if (fh != null) {
                    String message = "<html><font size=2 color=black><b>" + fh.getUsage() + "</b><p><p>" + fh.getDescription() + "<p></font>";
                    SharpOptionPane.showMessageDialog(this.frame, message, translation.getProperty("Function"), 1, this.helpIcon);
                } else {
                    this.showGeneralFunctionHelp();
                }
                this.table.requestFocus();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        cb.setSelectedIndex(0);
    }

    private void showGeneralFunctionHelp() {
        String message = translation.getProperty("helpmessage");
        SharpOptionPane.showMessageDialog(this.frame, message, "Function", 1, this.helpIcon);
    }
}

