#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import os

from winswitch.util.simple_logger import Logger
logger = Logger("commands_util", log_colour=Logger.WHITE)
from winswitch.util.paths import APP_DIR, WINSWITCH_LIBEXEC_DIR
from winswitch.util.which import win32_which, which
from winswitch.globals import WIN32, OSX
from winswitch.util.distro_packaging_util import get_distro_helper
from winswitch.consts import NX_TYPE, XPRA_TYPE, VNC_TYPE, WINDOWS_TYPE

XPRA_COMMAND = ""
XVFB_COMMAND = ""
SSH_COMMAND = ""
NXAGENT_COMMAND = ""
NXPROXY_COMMAND = ""
XMING_COMMAND = ""
XNEST_COMMAND = ""
XMODMAP_COMMAND = ""
SETXKBMAP_COMMAND = ""
XKBCOMP_COMMAND = ""
VNC_COMMAND = ""
XVNC_COMMAND = ""
KEYGEN_COMMAND = ""
DEVILSPIE_COMMAND = ""
XLOADIMAGE_COMMAND = ""
PULSEAUDIO_COMMAND = ""
DEVILSPIE_COMMAND = ""
XLOADIMAGE_COMMAND = ""
XSET_COMMAND = ""
XPROP_COMMAND = ""
XDPYINFO_COMMAND = ""
SMBCLIENT_COMMAND = ""
VNCSHADOW_COMMAND = ""
JAVA_COMMAND = ""
SCREEN_COMMAND = ""
XTERM_COMMAND = ""
VIRSH_COMMAND = ""
VBOXHEADLESS_COMMAND = ""
VBOXMANAGE_COMMAND = ""
VNCCONFIG_COMMAND = ""
VNCPASSWD_COMMAND = ""
IMPORT_COMMAND = ""
XWD_COMMAND = ""
PNMTOPNG_COMMAND = ""
XWDTOPNM_COMMAND = ""
PNMSCALE_COMMAND = ""
WINSWITCH_SERVER_COMMAND = ""
WINVNC_COMMAND = ""
RDESKTOP_COMMAND = ""
XFREERDP_COMMAND = ""
SEAMLESSRDP_COMMAND = ""
XDG_OPEN_COMMAND = ""
XDG_MIME_COMMAND = ""
CUPSD_COMMAND = ""
GNOME_KEYRING_DAEMON_COMMAND = ""
XSCREENSAVER_COMMAND_COMMAND = ""
SELINUXENABLED_COMMAND = ""
# these are in libexec on *nix:
GST_CAPTURE_COMMAND = ""
GST_PLAYBACK_COMMAND = ""
# on osx, we have a separate app with its own plist:
GST_LAUNCHER_APP = None
VASH_WRAPPER_APP = None

dh = get_distro_helper()
if WIN32:
	SSH_COMMAND = "%s\\PuTTY\\TortoisePlink.exe" % APP_DIR
	KEYGEN_COMMAND = "%s\\PuTTY\\puttygen.exe" % APP_DIR
	XPRA_COMMAND = "%s\\Xpra.exe" % APP_DIR
	NXPROXY_COMMAND = "%s\\nxproxy\\nxproxy.exe" % APP_DIR
	XMING_COMMAND = "%s\\Xming\\Xming.exe" % APP_DIR
	VNC_COMMAND = "%s\\TigerVNC\\vncviewer.exe" % APP_DIR
	WINSWITCH_SERVER_COMMAND = "%s\\Switch-Server.exe" % APP_DIR
	WINVNC_COMMAND = "%s\\TigerVNC\\winvnc4.exe" % APP_DIR
	SEAMLESSRDP_COMMAND = "%s\\SeamlessRDP\\seamlessrdpshell.exe" % APP_DIR
	RDESKTOP_COMMAND = win32_which("mstsc") or "mstsc"
	JAVA_COMMAND = win32_which("java")
	GST_CAPTURE_COMMAND = "%s\\gst_capture.exe" % APP_DIR
	GST_PLAYBACK_COMMAND = "%s\\gst_playback.exe" % APP_DIR
else:
	if OSX:
		py2app_helpers_dir = os.path.join(APP_DIR, "Helpers")
		py2app_macos_dir = os.path.join(APP_DIR, "MacOS")
		py2app_bin_dir = os.path.join(APP_DIR, "Resources", "bin")
		logger.sdebug("will try to locate commands from py2app_helpers_dir=%s" % py2app_helpers_dir)
		if os.path.exists(py2app_helpers_dir):
			def py2app_find(name):
				for d in [py2app_helpers_dir, py2app_bin_dir]:
					filename = os.path.join(d, name)
					if os.path.exists(filename):
						logger.sdebug("found %s" % filename)
						return	filename
				logger.serror("%s is missing" % name)
				return	None
			NXPROXY_COMMAND = py2app_find("nxproxy")
			XPRA_COMMAND = py2app_find("xpra")
			VNC_COMMAND = py2app_find("vncviewer")
			VNCPASSWD_COMMAND = py2app_find("vncpasswd")
			RDESKTOP_COMMAND = py2app_find("rdesktop")
			XFREERDP_COMMAND = py2app_find("xfreerdp")
			WINSWITCH_SERVER_COMMAND = py2app_find("Switch-Server")
		#using a sub-app with its own plist:
		GST_LAUNCHER_APP = os.path.join(APP_DIR, "GST_Launcher.app")
		VASH_WRAPPER_APP = os.path.join(APP_DIR, "Vash_Wrapper.app")
		def py2app_main(name):
			filename = os.path.join(py2app_macos_dir, name)
			if os.path.exists(filename):
				logger.sdebug("found %s" % filename)
				return	filename
			logger.serror("%s is missing (was expected in: %s)" % (name, filename))
			return	None
		#but the same wrapper can also be used in visible mode (ie: for video):
		GST_CAPTURE_COMMAND = py2app_main("GST_Launcher")
		GST_PLAYBACK_COMMAND = GST_PLAYBACK_COMMAND

	NXPROXY_COMMAND = NXPROXY_COMMAND or dh.find_command(NX_TYPE) or which("nxproxy")
	XPRA_COMMAND = XPRA_COMMAND or dh.find_command(XPRA_TYPE) or which("xpra")
	VNC_COMMAND = VNC_COMMAND or dh.find_command(VNC_TYPE) or which("vncviewer")
	VNCPASSWD_COMMAND = VNCPASSWD_COMMAND or which("vncpasswd")
	RDESKTOP_COMMAND = RDESKTOP_COMMAND or dh.find_command(WINDOWS_TYPE) or which("rdesktop")
	XFREERDP_COMMAND = XFREERDP_COMMAND or which("xfreerdp")
	WINSWITCH_SERVER_COMMAND = WINSWITCH_SERVER_COMMAND or which("winswitch_server")
	GST_CAPTURE_COMMAND = GST_CAPTURE_COMMAND or os.path.join(WINSWITCH_LIBEXEC_DIR, "gst_capture")
	GST_PLAYBACK_COMMAND = GST_PLAYBACK_COMMAND or os.path.join(WINSWITCH_LIBEXEC_DIR, "gst_playback")
	NXAGENT_COMMAND = which("nxagent")
	SSH_COMMAND = which("ssh")
	KEYGEN_COMMAND = which("ssh-keygen")
	XVFB_COMMAND = which("Xvfb")
	XMODMAP_COMMAND = which("xmodmap")
	SETXKBMAP_COMMAND = which("setxkbmap")
	XKBCOMP_COMMAND = which("xkbcomp")
	PULSEAUDIO_COMMAND = which("pulseaudio")
	XVNC_COMMAND = which("Xvnc", "Xvnc4")
	DEVILSPIE_COMMAND = which("devilspie")
	XLOADIMAGE_COMMAND = which("xloadimage")
	XSET_COMMAND = which("xset")
	XPROP_COMMAND = which("xprop")
	XDPYINFO_COMMAND = which("xdpyinfo")
	XNEST_COMMAND = which("Xephyr", "Xnest")
	SMBCLIENT_COMMAND = which("smbclient")
	VNCSHADOW_COMMAND = which("x0vncserver") or which("x0vnc4server") or which("x11vnc")
	JAVA_COMMAND = which("java")
	SCREEN_COMMAND = which("screen")
	XTERM_COMMAND = which("xterm")
	VIRSH_COMMAND = which("virsh")
	VBOXHEADLESS_COMMAND = which("VBoxHeadless")
	VBOXMANAGE_COMMAND = which("VBoxManage")
	VNCCONFIG_COMMAND = which("vncconfig")
	IMPORT_COMMAND = which("import")
	XWD_COMMAND = which("xwd")
	PNMTOPNG_COMMAND = which("pnmtopng")
	XWDTOPNM_COMMAND = which("xwdtopnm")
	PNMSCALE_COMMAND = which("pnmscale")
	XDG_OPEN_COMMAND = which("xdg-open")
	XDG_MIME_COMMAND = which("xdg-mime")
	CUPSD_COMMAND = which("cupsd")
	GNOME_KEYRING_DAEMON_COMMAND = which("gnome-keyring-daemon")
	XSCREENSAVER_COMMAND_COMMAND = which("xscreensaver-command")
	SELINUXENABLED_COMMAND = which("selinuxenabled")


def do_get_xvnc_type(path):
	try:
		from winswitch.consts import XVNC_TIGHT, XVNC_TIGER
		if not path or not os.path.exists(path):
			return	None
		cmd = [path, "-version"]
		try:
			from winswitch.util.process_util import get_output
			code, out, _ = get_output(cmd)
			if code!=0:
				return  XVNC_TIGHT
		except:
			return  XVNC_TIGHT
		low_out = out.lower()
		if len(low_out)<128 and low_out.find("tightvnc")>=0:
			#ie: Xvnc version TightVNC-1.3.10
			return	XVNC_TIGHT
		if low_out.find("tigervnc")>=0:
			return	XVNC_TIGER
	except:
		return	None

xvnc_types = {}
def	get_xvnc_type(path):
	"""
	We cache the type of the server we detect by path.
	If the binary is changed from under our feet, things might break.
	"""
	global	xvnc_types
	if path in xvnc_types:
		return	xvnc_types[path]
	vnc_type = do_get_xvnc_type(path)
	xvnc_types[path] = vnc_type
	return	vnc_type

logger.slog("ssh=%s, keygen=%s, xpra=%s, nxagent=%s, nxproxy=%s, vncviewer=%s, Xvnc=%s, vncshadow=%s, rdesktop=%s, java=%s, screen=%s, xterm=%s, Xming=%s, xmodmap=%s, Xvfb=%s, Xnest=%s, cupsd=%s, gst_capture=%s, gst_playback=%s, app dir=%s" % (SSH_COMMAND, KEYGEN_COMMAND, XPRA_COMMAND, NXAGENT_COMMAND, NXPROXY_COMMAND, VNC_COMMAND, XVNC_COMMAND, VNCSHADOW_COMMAND, RDESKTOP_COMMAND, JAVA_COMMAND, SCREEN_COMMAND, XTERM_COMMAND, XMING_COMMAND, XMODMAP_COMMAND, XVFB_COMMAND, XNEST_COMMAND, CUPSD_COMMAND, GST_CAPTURE_COMMAND, GST_PLAYBACK_COMMAND, APP_DIR))
