#!/bin/sh

date=$(date +%Y%m%d)

if [ ! -d ../wxgeometrie-upstream ]; then
    echo "../wxgeometrie-upstream should contain a clone of https://github.com/wxgeo/wxgeometrie.git"
else
    (cd ../wxgeometrie-upstream; git pull)
    rsync -a --delete --exclude .git --exclude .gitignore ../wxgeometrie-upstream/* ./
    dch --newversion 0.1.0+git${date}-1 "upgraded to the new upstream version"
    echo "Synchronized to the new upstream version, see debian/changelog"
fi

