#!/bin/sh

export SourceDir=$HOME/xalan-src/c
# export SourceDir=$HOME/xalan-src/c/trunk

#export DestDir=/usr/local
export DestDir=/opt/apache/debug

export XERCESCROOT=${DestDir}
export XALANCROOT=${SourceDir}

export PATH=$PATH:${SourceDir}
export LD_LIBRARY_PATH=${DestDir}:$LD_LIBRARY_PATH

runConfigure -p linux -c gcc -x g++ -P "${DestDir}" -d -C "--srcdir=${SourceDir}"

make clean

# MAKE WHAT YOU NEED
# The standard make builds only the libxalan-c.so library and Xalan executable.
# The "samples" builds the sample applications.
# The "tests" builds the diagnostic tests.

  make
  make samples
# make tests

# INSTALL WHAT YOU NEED
# The standard "install" installs only the libxalan-c.so and Xalan executable.
# The "install-extras" installs license and other documentation.
# The "install-package" installs libxalan-c.so, Xalan executable, samples and extras.

# make install
# make install-extras
# make install-package

# Note: The install-extras are targeted to $(datadir)/doc/libxalan-c
# The standard $(datadir) = $(prefix)/share

