<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:exslt="http://exslt.org/common" version="1.0"
                exclude-result-prefixes="exslt">

<!--
     This file contains the XSL templates used to construct a
     list of XML files used by XNav.

     Copyright © 2004-2007 Brendt Wohlberg <software@wohlberg.net>

     Please see the XNav distribution README file for license
     information.
-->


 <xsl:output method="text"/>



   <!-- Stylesheet parameter setting base path for processing -->
   <xsl:param name="basep" select="'./'"/>



   <!-- Template matching root to initiate processing on top level
        xnav file -->
   <xsl:template match="/">
     <xsl:call-template name="navtreedepend">
       <xsl:with-param name="p" select="$basep"/>
       <xsl:with-param name="y" select="."/>
     </xsl:call-template>
   </xsl:template>



   <!-- Main template, called recursively -->
   <xsl:template name="navtreedepend">
     <!-- Cumulative path to this level -->
     <xsl:param name="p" select="'./'"/>
     <!-- The xnav element for this level -->
     <xsl:param name="y" select="/.."/>
     <!-- A cumulative list of xnav files -->
     <xsl:param name="c" select="''"/>

     <xsl:variable name="nc" select="concat($c, '    ', $p, 'xnav.xml')"/>
     <xsl:value-of select="concat($p, 'index.html')"/>
     <xsl:text>    </xsl:text>
     <xsl:value-of select="concat($p, 'index.xml')"/>
     <xsl:value-of select="$c"/>
     <xsl:text>&#10;</xsl:text>
     <xsl:for-each select="$y/xnav/file">
       <xsl:value-of select="concat($p, substring-before(@href, '.xml'),
                                    '.html')"/>
       <xsl:text>    </xsl:text>
       <xsl:value-of select="concat($p, @href)"/>
       <xsl:value-of select="$nc"/>
       <xsl:text>&#10;</xsl:text>
     </xsl:for-each>
     
     <!-- Descend down the tree -->
     <xsl:for-each select="$y/xnav/directory[not(@enter='no')]">
       <!-- Variable $dhref is @href with a single final '/' character -->
       <xsl:variable name="dhref" select="concat(
                                            substring(@href,1,
                                              string-length(@href)-1),
                                            translate(
                                              substring(@href,
                                                string-length(@href)),
                                              '/',''),
                                            '/'
                                          )"/>
       <xsl:variable name="xnav"
                     select="document(concat($dhref, 'xnav.xml'), /)"/>
       <!-- Detect and signal problems parsing xnav.xml document -->
       <xsl:if test="count($xnav)=0">
         <xsl:text>error-path    </xsl:text>
         <xsl:value-of select="concat($basep, $dhref, 'xnav.xml')"/>
         <xsl:text>&#10;</xsl:text>
         <xsl:message terminate='yes'>
           <xsl:text>Error in processing file </xsl:text>
           <xsl:value-of select="concat($basep, $dhref, 'xnav.xml')"/>
         </xsl:message>
       </xsl:if>
       <xsl:call-template name="navtreedepend">
         <xsl:with-param name="p" select="concat($p, $dhref)"/>
         <xsl:with-param name="y" select="$xnav"/>
         <xsl:with-param name="c" select="$nc"/>
       </xsl:call-template>

     </xsl:for-each>

   </xsl:template>



</xsl:stylesheet>
