/* Native-dependent code for GNU/Linux UltraSPARC.

   Copyright (C) 2003-2021 Free Software Foundation, Inc.

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#include "defs.h"
#include "gdbarch.h"

#include "sparc64-tdep.h"
#include "sparc-nat.h"

/* Determine whether `gregset_t' contains register REGNUM.  */

static int
sparc64_gregset_supplies_p (struct gdbarch *gdbarch, int regnum)
{
  if (gdbarch_ptr_bit (gdbarch) == 32)
    return sparc32_gregset_supplies_p (gdbarch, regnum);

  /* Integer registers.  */
  if ((regnum >= SPARC_G1_REGNUM && regnum <= SPARC_G7_REGNUM)
      || (regnum >= SPARC_O0_REGNUM && regnum <= SPARC_O7_REGNUM)
      || (regnum >= SPARC_L0_REGNUM && regnum <= SPARC_L7_REGNUM)
      || (regnum >= SPARC_I0_REGNUM && regnum <= SPARC_I7_REGNUM))
    return 1;

  /* Control registers.  */
  if (regnum == SPARC64_PC_REGNUM
      || regnum == SPARC64_NPC_REGNUM
      || regnum == SPARC64_STATE_REGNUM
      || regnum == SPARC64_Y_REGNUM
      || regnum == SPARC64_FPRS_REGNUM)
    return 1;

  return 0;
}

/* Determine whether `fpregset_t' contains register REGNUM.  */

static int
sparc64_fpregset_supplies_p (struct gdbarch *gdbarch, int regnum)
{
  if (gdbarch_ptr_bit (gdbarch) == 32)
    return sparc32_fpregset_supplies_p (gdbarch, regnum);

  /* Floating-point registers.  */
  if ((regnum >= SPARC_F0_REGNUM && regnum <= SPARC_F31_REGNUM)
      || (regnum >= SPARC64_F32_REGNUM && regnum <= SPARC64_F62_REGNUM))
    return 1;

  /* Control registers.  */
  if (regnum == SPARC64_FSR_REGNUM)
    return 1;

  return 0;
}

void _initialize_sparc64_nat ();
void
_initialize_sparc64_nat ()
{
  sparc_supply_gregset = sparc64_supply_gregset;
  sparc_collect_gregset = sparc64_collect_gregset;
  sparc_supply_fpregset = sparc64_supply_fpregset;
  sparc_collect_fpregset = sparc64_collect_fpregset;
  sparc_gregset_supplies_p = sparc64_gregset_supplies_p;
  sparc_fpregset_supplies_p = sparc64_fpregset_supplies_p;
}
