/* math-display.c generated by valac 0.30.0.14-c43a, the Vala compiler
 * generated from math-display.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libcalculator.h"
#include <gtksourceview/gtksource.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <atk/atk.h>
#include <gdk/gdk.h>


#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;
typedef struct _MathDisplayPrivate MathDisplayPrivate;

#define TYPE_HISTORY_VIEW (history_view_get_type ())
#define HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_VIEW, HistoryView))
#define HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_VIEW, HistoryViewClass))
#define IS_HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_VIEW))
#define IS_HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_VIEW))
#define HISTORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_VIEW, HistoryViewClass))

typedef struct _HistoryView HistoryView;
typedef struct _HistoryViewClass HistoryViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;

#define TYPE_FUNCTION_COMPLETION_PROVIDER (function_completion_provider_get_type ())
#define FUNCTION_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProvider))
#define FUNCTION_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProviderClass))
#define IS_FUNCTION_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER))
#define IS_FUNCTION_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_COMPLETION_PROVIDER))
#define FUNCTION_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProviderClass))

typedef struct _FunctionCompletionProvider FunctionCompletionProvider;
typedef struct _FunctionCompletionProviderClass FunctionCompletionProviderClass;

#define TYPE_VARIABLE_COMPLETION_PROVIDER (variable_completion_provider_get_type ())
#define VARIABLE_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProvider))
#define VARIABLE_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderClass))
#define IS_VARIABLE_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER))
#define IS_VARIABLE_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VARIABLE_COMPLETION_PROVIDER))
#define VARIABLE_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderClass))

typedef struct _VariableCompletionProvider VariableCompletionProvider;
typedef struct _VariableCompletionProviderClass VariableCompletionProviderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GdkEventKey_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventKey_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _CompletionProviderPrivate CompletionProviderPrivate;
typedef struct _FunctionCompletionProviderPrivate FunctionCompletionProviderPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _VariableCompletionProviderPrivate VariableCompletionProviderPrivate;

struct _MathDisplay {
	GtkViewport parent_instance;
	MathDisplayPrivate * priv;
};

struct _MathDisplayClass {
	GtkViewportClass parent_class;
};

struct _MathDisplayPrivate {
	MathEquation* _equation;
	HistoryView* history;
	GtkSourceView* source_view;
	GtkTextBuffer* info_buffer;
	GtkSpinner* spinner;
};

struct _CompletionProvider {
	GObject parent_instance;
	CompletionProviderPrivate * priv;
};

struct _CompletionProviderClass {
	GObjectClass parent_class;
	gchar* (*get_name) (CompletionProvider* self);
	gboolean (*get_start_iter) (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
	gboolean (*activate_proposal) (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
	void (*populate) (CompletionProvider* self, GtkSourceCompletionContext* context);
};

struct _FunctionCompletionProvider {
	CompletionProvider parent_instance;
	FunctionCompletionProviderPrivate * priv;
};

struct _FunctionCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _VariableCompletionProvider {
	CompletionProvider parent_instance;
	VariableCompletionProviderPrivate * priv;
};

struct _VariableCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _VariableCompletionProviderPrivate {
	MathEquation* _equation;
};


static gpointer math_display_parent_class = NULL;
static gpointer completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderIface* completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static gpointer function_completion_provider_parent_class = NULL;
static gpointer variable_completion_provider_parent_class = NULL;

GType math_display_get_type (void) G_GNUC_CONST;
GType history_view_get_type (void) G_GNUC_CONST;
#define MATH_DISPLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_DISPLAY, MathDisplayPrivate))
enum  {
	MATH_DISPLAY_DUMMY_PROPERTY,
	MATH_DISPLAY_EQUATION
};
MathDisplay* math_display_new (MathEquation* equation);
MathDisplay* math_display_construct (GType object_type, MathEquation* equation);
void math_display_handler (MathDisplay* self, const gchar* answer, Number* number, gint number_base, guint representation_base);
static void _math_display_handler_math_equation_history_signal (MathEquation* _sender, const gchar* answer, Number* number, gint number_base, guint representation_base, gpointer self);
HistoryView* history_view_new (MathDisplay* display, GtkBox* box);
HistoryView* history_view_construct (GType object_type, MathDisplay* display, GtkBox* box);
static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self);
static gboolean math_display_key_press_cb (MathDisplay* self, GdkEventKey* event);
static gboolean _math_display_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void math_display_create_autocompletion (MathDisplay* self);
static void __lambda4_ (MathDisplay* self, GParamSpec* pspec);
static void math_display_status_changed_cb (MathDisplay* self);
static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda5_ (MathDisplay* self, GParamSpec* pspec);
static void math_display_error_status_changed_cb (MathDisplay* self);
static void ___lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
void math_display_grabfocus (MathDisplay* self);
void math_display_update_history (MathDisplay* self, const gchar* answer, Number* number, gint number_base, guint representation_base);
void math_display_display_text (MathDisplay* self, const gchar* prev_eq);
void history_view_insert_entry (HistoryView* self, const gchar* equation, Number* answer, gint number_base, guint representation_base);
void math_display_insert_text (MathDisplay* self, const gchar* answer);
FunctionCompletionProvider* function_completion_provider_new (void);
FunctionCompletionProvider* function_completion_provider_construct (GType object_type);
GType completion_provider_get_type (void) G_GNUC_CONST;
GType function_completion_provider_get_type (void) G_GNUC_CONST;
MathEquation* math_display_get_equation (MathDisplay* self);
VariableCompletionProvider* variable_completion_provider_new (MathEquation* equation);
VariableCompletionProvider* variable_completion_provider_construct (GType object_type, MathEquation* equation);
GType variable_completion_provider_get_type (void) G_GNUC_CONST;
static gboolean math_display_function_completion_window_visible (MathDisplay* self);
MathFunction** function_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, int* result_length1);
gchar** variable_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, MathVariables* variables, int* result_length1);
static gboolean math_display_real_key_press_event (GtkWidget* base, GdkEventKey* event);
static GdkEventKey* _vala_GdkEventKey_copy (GdkEventKey* self);
static void _vala_GdkEventKey_free (GdkEventKey* self);
void math_display_grab_focus (MathDisplay* self);
static void math_display_finalize (GObject* obj);
static void _vala_math_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
enum  {
	COMPLETION_PROVIDER_DUMMY_PROPERTY
};
gchar* completion_provider_get_name (CompletionProvider* self);
static gchar* completion_provider_real_get_name (CompletionProvider* self);
void completion_provider_move_iter_to_name_start (GtkTextIter* iter);
gboolean completion_provider_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static gboolean completion_provider_real_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
gboolean completion_provider_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static gboolean completion_provider_real_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
void completion_provider_populate (CompletionProvider* self, GtkSourceCompletionContext* context);
static void completion_provider_real_populate (CompletionProvider* self, GtkSourceCompletionContext* context);
CompletionProvider* completion_provider_new (void);
CompletionProvider* completion_provider_construct (GType object_type);
enum  {
	FUNCTION_COMPLETION_PROVIDER_DUMMY_PROPERTY
};
static gchar* function_completion_provider_real_get_name (CompletionProvider* base);
static void function_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define VARIABLE_COMPLETION_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderPrivate))
enum  {
	VARIABLE_COMPLETION_PROVIDER_DUMMY_PROPERTY
};
static gchar* variable_completion_provider_real_get_name (CompletionProvider* base);
static void variable_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context);
static void variable_completion_provider_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _math_display_handler_math_equation_history_signal (MathEquation* _sender, const gchar* answer, Number* number, gint number_base, guint representation_base, gpointer self) {
	math_display_handler ((MathDisplay*) self, answer, number, number_base, representation_base);
}


static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self) {
	return g_boxed_copy (pango_font_description_get_type (), self);
}


static gpointer __vala_PangoFontDescription_copy0 (gpointer self) {
	return self ? _vala_PangoFontDescription_copy (self) : NULL;
}


static gboolean _math_display_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = math_display_key_press_cb ((MathDisplay*) self, event);
	return result;
}


static void __lambda4_ (MathDisplay* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_display_status_changed_cb (self);
}


static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda4_ ((MathDisplay*) self, pspec);
}


static void __lambda5_ (MathDisplay* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_display_error_status_changed_cb (self);
}


static void ___lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda5_ ((MathDisplay*) self, pspec);
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


MathDisplay* math_display_construct (GType object_type, MathEquation* equation) {
	MathDisplay * self = NULL;
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	GtkBox* main_box = NULL;
	GtkBox* _tmp3_ = NULL;
	HistoryView* _tmp4_ = NULL;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp5_ = NULL;
	MathEquation* _tmp6_ = NULL;
	GtkSourceView* _tmp7_ = NULL;
	GtkSourceView* _tmp8_ = NULL;
	GtkSourceView* _tmp9_ = NULL;
	GtkSourceView* _tmp10_ = NULL;
	GtkSourceView* _tmp11_ = NULL;
	PangoFontDescription* font_desc = NULL;
	GtkSourceView* _tmp12_ = NULL;
	GtkStyleContext* _tmp13_ = NULL;
	PangoFontDescription* _tmp14_ = NULL;
	PangoFontDescription* _tmp15_ = NULL;
	GtkSourceView* _tmp16_ = NULL;
	GtkSourceView* _tmp17_ = NULL;
	GtkSourceView* _tmp18_ = NULL;
	GtkSourceView* _tmp19_ = NULL;
	AtkObject* _tmp20_ = NULL;
	GtkSourceView* _tmp21_ = NULL;
	GtkSourceView* _tmp22_ = NULL;
	GtkBox* info_box = NULL;
	GtkBox* _tmp23_ = NULL;
	GtkTextView* info_view = NULL;
	GtkTextView* _tmp24_ = NULL;
	GtkTextBuffer* _tmp25_ = NULL;
	GtkTextBuffer* _tmp26_ = NULL;
	GtkSpinner* _tmp27_ = NULL;
	GtkSpinner* _tmp28_ = NULL;
	GtkSourceView* _tmp29_ = NULL;
	MathEquation* _tmp30_ = NULL;
	MathEquation* _tmp31_ = NULL;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathDisplay*) g_object_new (object_type, NULL);
	_tmp0_ = equation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp1_;
	_tmp2_ = self->priv->_equation;
	g_signal_connect_object (_tmp2_, "history-signal", (GCallback) _math_display_handler_math_equation_history_signal, self, 0);
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp3_);
	main_box = _tmp3_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_box);
	_tmp4_ = history_view_new (self, main_box);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->history);
	self->priv->history = _tmp4_;
	_tmp5_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp5_);
	scrolled_window = _tmp5_;
	gtk_scrolled_window_set_policy (scrolled_window, GTK_POLICY_AUTOMATIC, GTK_POLICY_NEVER);
	_tmp6_ = equation;
	_tmp7_ = (GtkSourceView*) gtk_source_view_new_with_buffer ((GtkSourceBuffer*) _tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->source_view);
	self->priv->source_view = _tmp7_;
	_tmp8_ = self->priv->source_view;
	gtk_text_view_set_accepts_tab ((GtkTextView*) _tmp8_, FALSE);
	_tmp9_ = self->priv->source_view;
	gtk_text_view_set_pixels_above_lines ((GtkTextView*) _tmp9_, 8);
	_tmp10_ = self->priv->source_view;
	gtk_text_view_set_pixels_below_lines ((GtkTextView*) _tmp10_, 2);
	_tmp11_ = self->priv->source_view;
	gtk_text_view_set_justification ((GtkTextView*) _tmp11_, GTK_JUSTIFY_RIGHT);
	_tmp12_ = self->priv->source_view;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	_tmp14_ = gtk_style_context_get_font (_tmp13_, GTK_STATE_FLAG_NORMAL);
	_tmp15_ = __vala_PangoFontDescription_copy0 (_tmp14_);
	font_desc = _tmp15_;
	pango_font_description_set_size (font_desc, 16 * PANGO_SCALE);
	_tmp16_ = self->priv->source_view;
	gtk_widget_override_font ((GtkWidget*) _tmp16_, font_desc);
	_tmp17_ = self->priv->source_view;
	gtk_buildable_set_name ((GtkBuildable*) _tmp17_, "displayitem");
	_tmp18_ = self->priv->source_view;
	gtk_widget_set_size_request ((GtkWidget*) _tmp18_, 20, 20);
	_tmp19_ = self->priv->source_view;
	_tmp20_ = gtk_widget_get_accessible ((GtkWidget*) _tmp19_);
	atk_object_set_role (_tmp20_, ATK_ROLE_EDITBAR);
	_tmp21_ = self->priv->source_view;
	g_signal_connect_object ((GtkWidget*) _tmp21_, "key-press-event", (GCallback) _math_display_key_press_cb_gtk_widget_key_press_event, self, 0);
	math_display_create_autocompletion (self);
	gtk_box_pack_start (main_box, (GtkWidget*) scrolled_window, FALSE, FALSE, (guint) 0);
	_tmp22_ = self->priv->source_view;
	gtk_container_add ((GtkContainer*) scrolled_window, (GtkWidget*) _tmp22_);
	gtk_widget_show ((GtkWidget*) scrolled_window);
	_tmp23_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp23_);
	info_box = _tmp23_;
	gtk_box_pack_start (main_box, (GtkWidget*) info_box, FALSE, TRUE, (guint) 0);
	_tmp24_ = (GtkTextView*) gtk_text_view_new ();
	g_object_ref_sink (_tmp24_);
	info_view = _tmp24_;
	gtk_text_view_set_wrap_mode (info_view, GTK_WRAP_WORD);
	gtk_widget_set_can_focus ((GtkWidget*) info_view, FALSE);
	gtk_text_view_set_editable (info_view, FALSE);
	gtk_text_view_set_justification (info_view, GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start (info_box, (GtkWidget*) info_view, TRUE, TRUE, (guint) 0);
	_tmp25_ = gtk_text_view_get_buffer (info_view);
	_tmp26_ = _g_object_ref0 (_tmp25_);
	_g_object_unref0 (self->priv->info_buffer);
	self->priv->info_buffer = _tmp26_;
	_tmp27_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp27_;
	_tmp28_ = self->priv->spinner;
	gtk_box_pack_end (info_box, (GtkWidget*) _tmp28_, FALSE, FALSE, (guint) 0);
	gtk_widget_show ((GtkWidget*) info_box);
	gtk_widget_show ((GtkWidget*) info_view);
	_tmp29_ = self->priv->source_view;
	gtk_widget_show ((GtkWidget*) _tmp29_);
	gtk_widget_show ((GtkWidget*) main_box);
	_tmp30_ = equation;
	g_signal_connect_object ((GObject*) _tmp30_, "notify::status", (GCallback) ___lambda4__g_object_notify, self, 0);
	math_display_status_changed_cb (self);
	_tmp31_ = equation;
	g_signal_connect_object ((GObject*) _tmp31_, "notify::error-token-end", (GCallback) ___lambda5__g_object_notify, self, 0);
	_g_object_unref0 (info_view);
	_g_object_unref0 (info_box);
	__vala_PangoFontDescription_free0 (font_desc);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (main_box);
	return self;
}


MathDisplay* math_display_new (MathEquation* equation) {
	return math_display_construct (TYPE_MATH_DISPLAY, equation);
}


void math_display_grabfocus (MathDisplay* self) {
	GtkSourceView* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}


void math_display_handler (MathDisplay* self, const gchar* answer, Number* number, gint number_base, guint representation_base) {
	const gchar* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	guint _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (answer != NULL);
	g_return_if_fail (number != NULL);
	_tmp0_ = answer;
	_tmp1_ = number;
	_tmp2_ = number_base;
	_tmp3_ = representation_base;
	math_display_update_history (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
}


void math_display_display_text (MathDisplay* self, const gchar* prev_eq) {
	MathEquation* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prev_eq != NULL);
	_tmp0_ = self->priv->_equation;
	_tmp1_ = prev_eq;
	math_equation_display_selected (_tmp0_, _tmp1_);
}


void math_display_update_history (MathDisplay* self, const gchar* answer, Number* number, gint number_base, guint representation_base) {
	HistoryView* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	guint _tmp4_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (answer != NULL);
	g_return_if_fail (number != NULL);
	_tmp0_ = self->priv->history;
	_tmp1_ = answer;
	_tmp2_ = number;
	_tmp3_ = number_base;
	_tmp4_ = representation_base;
	history_view_insert_entry (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
}


void math_display_insert_text (MathDisplay* self, const gchar* answer) {
	MathEquation* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (answer != NULL);
	_tmp0_ = self->priv->_equation;
	_tmp1_ = answer;
	math_equation_insert_selected (_tmp0_, _tmp1_);
}


static void math_display_create_autocompletion (MathDisplay* self) {
	GtkSourceCompletion* completion = NULL;
	GtkSourceView* _tmp0_ = NULL;
	GtkSourceCompletion* _tmp1_ = NULL;
	GtkSourceCompletion* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	_tmp1_ = gtk_source_view_get_completion (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	completion = _tmp2_;
	{
		GtkSourceCompletion* _tmp3_ = NULL;
		FunctionCompletionProvider* _tmp4_ = NULL;
		FunctionCompletionProvider* _tmp5_ = NULL;
		GtkSourceCompletion* _tmp6_ = NULL;
		MathEquation* _tmp7_ = NULL;
		MathEquation* _tmp8_ = NULL;
		VariableCompletionProvider* _tmp9_ = NULL;
		VariableCompletionProvider* _tmp10_ = NULL;
		_tmp3_ = completion;
		_tmp4_ = function_completion_provider_new ();
		_tmp5_ = _tmp4_;
		gtk_source_completion_add_provider (_tmp3_, (GtkSourceCompletionProvider*) _tmp5_, &_inner_error_);
		_g_object_unref0 (_tmp5_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp6_ = completion;
		_tmp7_ = math_display_get_equation (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = variable_completion_provider_new (_tmp8_);
		_tmp10_ = _tmp9_;
		gtk_source_completion_add_provider (_tmp6_, (GtkSourceCompletionProvider*) _tmp10_, &_inner_error_);
		_g_object_unref0 (_tmp10_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("math-display.vala:119: Could not add CompletionProvider to source-view");
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (completion);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (completion);
}


static gboolean math_display_function_completion_window_visible (MathDisplay* self) {
	gboolean result = FALSE;
	GList* providers_list = NULL;
	GtkSourceView* _tmp0_ = NULL;
	GtkSourceCompletion* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->source_view;
	_tmp1_ = gtk_source_view_get_completion (_tmp0_);
	_tmp2_ = gtk_source_completion_get_providers (_tmp1_);
	providers_list = _tmp2_;
	_tmp3_ = providers_list;
	_tmp4_ = g_list_length (_tmp3_);
	if (_tmp4_ > ((guint) 0)) {
		MathFunction** functions = NULL;
		MathEquation* _tmp5_ = NULL;
		MathEquation* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		MathFunction** _tmp8_ = NULL;
		gint functions_length1 = 0;
		gint _functions_size_ = 0;
		gchar** variables = NULL;
		MathEquation* _tmp9_ = NULL;
		MathEquation* _tmp10_ = NULL;
		MathEquation* _tmp11_ = NULL;
		MathEquation* _tmp12_ = NULL;
		MathVariables* _tmp13_ = NULL;
		MathVariables* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gchar** _tmp16_ = NULL;
		gint variables_length1 = 0;
		gint _variables_size_ = 0;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		MathFunction** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		_tmp5_ = math_display_get_equation (self);
		_tmp6_ = _tmp5_;
		_tmp8_ = function_completion_provider_get_matches_for_completion_at_cursor ((GtkTextBuffer*) _tmp6_, &_tmp7_);
		functions = _tmp8_;
		functions_length1 = _tmp7_;
		_functions_size_ = functions_length1;
		_tmp9_ = math_display_get_equation (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = math_display_get_equation (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = math_equation_get_variables (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp16_ = variable_completion_provider_get_matches_for_completion_at_cursor ((GtkTextBuffer*) _tmp10_, _tmp14_, &_tmp15_);
		variables = _tmp16_;
		variables_length1 = _tmp15_;
		_variables_size_ = variables_length1;
		_tmp19_ = functions;
		_tmp19__length1 = functions_length1;
		if (_tmp19__length1 > 0) {
			_tmp18_ = TRUE;
		} else {
			gchar** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			_tmp20_ = variables;
			_tmp20__length1 = variables_length1;
			_tmp18_ = _tmp20__length1 > 0;
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			_tmp17_ = FALSE;
		}
		result = _tmp17_;
		variables = (_vala_array_free (variables, variables_length1, (GDestroyNotify) g_free), NULL);
		functions = (_vala_array_free (functions, functions_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean math_display_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MathDisplay * self;
	gboolean result = FALSE;
	GtkSourceView* _tmp0_ = NULL;
	GdkEventKey* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	self = (MathDisplay*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->source_view;
	_tmp1_ = event;
	g_signal_emit_by_name ((GtkWidget*) _tmp0_, "key-press-event", _tmp1_, &_tmp2_);
	result = _tmp2_;
	return result;
}


static GdkEventKey* _vala_GdkEventKey_copy (GdkEventKey* self) {
	return g_boxed_copy (gdk_event_get_type (), self);
}


static gpointer __vala_GdkEventKey_copy0 (gpointer self) {
	return self ? _vala_GdkEventKey_copy (self) : NULL;
}


static void _vala_GdkEventKey_free (GdkEventKey* self) {
	g_boxed_free (gdk_event_get_type (), self);
}


static gboolean math_display_key_press_cb (MathDisplay* self, GdkEventKey* event) {
	gboolean result = FALSE;
	guint new_keyval = 0U;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	GdkModifierType state = 0;
	GdkEventKey* _tmp9_ = NULL;
	GdkModifierType _tmp10_ = 0;
	guint32 c = 0U;
	GdkEventKey* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	guint32 _tmp13_ = 0U;
	gboolean _tmp14_ = FALSE;
	GdkEventKey* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	GdkEventKey* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	gboolean _tmp38_ = FALSE;
	GdkEventKey* _tmp39_ = NULL;
	guint _tmp40_ = 0U;
	GdkModifierType _tmp45_ = 0;
	GdkModifierType _tmp55_ = 0;
	GdkModifierType _tmp78_ = 0;
	gboolean _tmp85_ = FALSE;
	GdkModifierType _tmp86_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	new_keyval = (guint) 0;
	_tmp0_ = event;
	_tmp1_ = _tmp0_->keyval;
	switch (_tmp1_) {
		case GDK_KEY_KP_Insert:
		{
			new_keyval = (guint) GDK_KEY_0;
			break;
		}
		case GDK_KEY_KP_End:
		{
			new_keyval = (guint) GDK_KEY_1;
			break;
		}
		case GDK_KEY_KP_Down:
		{
			new_keyval = (guint) GDK_KEY_2;
			break;
		}
		case GDK_KEY_KP_Page_Down:
		{
			new_keyval = (guint) GDK_KEY_3;
			break;
		}
		case GDK_KEY_KP_Left:
		{
			new_keyval = (guint) GDK_KEY_4;
			break;
		}
		case GDK_KEY_KP_Begin:
		{
			new_keyval = (guint) GDK_KEY_5;
			break;
		}
		case GDK_KEY_KP_Right:
		{
			new_keyval = (guint) GDK_KEY_6;
			break;
		}
		case GDK_KEY_KP_Home:
		{
			new_keyval = (guint) GDK_KEY_7;
			break;
		}
		case GDK_KEY_KP_Up:
		{
			new_keyval = (guint) GDK_KEY_8;
			break;
		}
		case GDK_KEY_KP_Page_Up:
		{
			new_keyval = (guint) GDK_KEY_9;
			break;
		}
		default:
		break;
	}
	_tmp2_ = new_keyval;
	if (_tmp2_ != ((guint) 0)) {
		GdkEventKey* new_event = NULL;
		GdkEventKey* _tmp3_ = NULL;
		GdkEventKey* _tmp4_ = NULL;
		GdkEventKey* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		GdkEventKey* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp3_ = event;
		_tmp4_ = __vala_GdkEventKey_copy0 (_tmp3_);
		new_event = _tmp4_;
		_tmp5_ = new_event;
		_tmp6_ = new_keyval;
		_tmp5_->keyval = _tmp6_;
		_tmp7_ = new_event;
		g_signal_emit_by_name ((GtkWidget*) self, "key-press-event", _tmp7_, &_tmp8_);
		result = _tmp8_;
		__vala_GdkEventKey_free0 (new_event);
		return result;
	}
	_tmp9_ = event;
	_tmp10_ = _tmp9_->state;
	state = _tmp10_ & (GDK_CONTROL_MASK | GDK_MOD1_MASK);
	_tmp11_ = event;
	_tmp12_ = _tmp11_->keyval;
	_tmp13_ = gdk_keyval_to_unicode (_tmp12_);
	c = _tmp13_;
	_tmp15_ = event;
	_tmp16_ = _tmp15_->keyval;
	if (_tmp16_ == ((guint) GDK_KEY_Return)) {
		_tmp14_ = TRUE;
	} else {
		GdkEventKey* _tmp17_ = NULL;
		guint _tmp18_ = 0U;
		_tmp17_ = event;
		_tmp18_ = _tmp17_->keyval;
		_tmp14_ = _tmp18_ == ((guint) GDK_KEY_KP_Enter);
	}
	if (_tmp14_) {
		gboolean _tmp19_ = FALSE;
		MathEquation* _tmp20_ = NULL;
		MathEquation* _tmp21_ = NULL;
		_tmp19_ = math_display_function_completion_window_visible (self);
		if (_tmp19_) {
			result = FALSE;
			return result;
		}
		_tmp20_ = math_display_get_equation (self);
		_tmp21_ = _tmp20_;
		math_equation_solve (_tmp21_);
		result = TRUE;
		return result;
	}
	_tmp25_ = event;
	_tmp26_ = _tmp25_->keyval;
	if (_tmp26_ == ((guint) GDK_KEY_Escape)) {
		GdkModifierType _tmp27_ = 0;
		_tmp27_ = state;
		_tmp24_ = _tmp27_ == 0;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		_tmp23_ = TRUE;
	} else {
		gboolean _tmp28_ = FALSE;
		GdkEventKey* _tmp29_ = NULL;
		guint _tmp30_ = 0U;
		_tmp29_ = event;
		_tmp30_ = _tmp29_->keyval;
		if (_tmp30_ == ((guint) GDK_KEY_BackSpace)) {
			GdkModifierType _tmp31_ = 0;
			_tmp31_ = state;
			_tmp28_ = _tmp31_ == GDK_CONTROL_MASK;
		} else {
			_tmp28_ = FALSE;
		}
		_tmp23_ = _tmp28_;
	}
	if (_tmp23_) {
		_tmp22_ = TRUE;
	} else {
		gboolean _tmp32_ = FALSE;
		GdkEventKey* _tmp33_ = NULL;
		guint _tmp34_ = 0U;
		_tmp33_ = event;
		_tmp34_ = _tmp33_->keyval;
		if (_tmp34_ == ((guint) GDK_KEY_Delete)) {
			GdkModifierType _tmp35_ = 0;
			_tmp35_ = state;
			_tmp32_ = _tmp35_ == GDK_SHIFT_MASK;
		} else {
			_tmp32_ = FALSE;
		}
		_tmp22_ = _tmp32_;
	}
	if (_tmp22_) {
		MathEquation* _tmp36_ = NULL;
		MathEquation* _tmp37_ = NULL;
		_tmp36_ = math_display_get_equation (self);
		_tmp37_ = _tmp36_;
		math_equation_clear (_tmp37_);
		result = TRUE;
		return result;
	}
	_tmp39_ = event;
	_tmp40_ = _tmp39_->keyval;
	if (_tmp40_ == ((guint) GDK_KEY_KP_Decimal)) {
		_tmp38_ = TRUE;
	} else {
		GdkEventKey* _tmp41_ = NULL;
		guint _tmp42_ = 0U;
		_tmp41_ = event;
		_tmp42_ = _tmp41_->keyval;
		_tmp38_ = _tmp42_ == ((guint) GDK_KEY_KP_Separator);
	}
	if (_tmp38_) {
		MathEquation* _tmp43_ = NULL;
		MathEquation* _tmp44_ = NULL;
		_tmp43_ = math_display_get_equation (self);
		_tmp44_ = _tmp43_;
		math_equation_insert_numeric_point (_tmp44_);
		result = TRUE;
		return result;
	}
	_tmp45_ = state;
	if (_tmp45_ == 0) {
		guint32 _tmp46_ = 0U;
		guint32 _tmp49_ = 0U;
		guint32 _tmp52_ = 0U;
		_tmp46_ = c;
		if (_tmp46_ == ((guint32) '*')) {
			MathEquation* _tmp47_ = NULL;
			MathEquation* _tmp48_ = NULL;
			_tmp47_ = math_display_get_equation (self);
			_tmp48_ = _tmp47_;
			math_equation_insert (_tmp48_, "×");
			result = TRUE;
			return result;
		}
		_tmp49_ = c;
		if (_tmp49_ == ((guint32) '/')) {
			MathEquation* _tmp50_ = NULL;
			MathEquation* _tmp51_ = NULL;
			_tmp50_ = math_display_get_equation (self);
			_tmp51_ = _tmp50_;
			math_equation_insert (_tmp51_, "÷");
			result = TRUE;
			return result;
		}
		_tmp52_ = c;
		if (_tmp52_ == ((guint32) '-')) {
			MathEquation* _tmp53_ = NULL;
			MathEquation* _tmp54_ = NULL;
			_tmp53_ = math_display_get_equation (self);
			_tmp54_ = _tmp53_;
			math_equation_insert_subtract (_tmp54_);
			result = TRUE;
			return result;
		}
	}
	_tmp55_ = state;
	if (_tmp55_ == GDK_CONTROL_MASK) {
		GdkEventKey* _tmp56_ = NULL;
		guint _tmp57_ = 0U;
		_tmp56_ = event;
		_tmp57_ = _tmp56_->keyval;
		switch (_tmp57_) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp58_ = NULL;
				MathEquation* _tmp59_ = NULL;
				_tmp58_ = math_display_get_equation (self);
				_tmp59_ = _tmp58_;
				math_equation_insert (_tmp59_, "⌈");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp60_ = NULL;
				MathEquation* _tmp61_ = NULL;
				_tmp60_ = math_display_get_equation (self);
				_tmp61_ = _tmp60_;
				math_equation_insert (_tmp61_, "⌉");
				result = TRUE;
				return result;
			}
			case GDK_KEY_e:
			{
				MathEquation* _tmp62_ = NULL;
				MathEquation* _tmp63_ = NULL;
				_tmp62_ = math_display_get_equation (self);
				_tmp63_ = _tmp62_;
				math_equation_insert_exponent (_tmp63_);
				result = TRUE;
				return result;
			}
			case GDK_KEY_f:
			{
				MathEquation* _tmp64_ = NULL;
				MathEquation* _tmp65_ = NULL;
				_tmp64_ = math_display_get_equation (self);
				_tmp65_ = _tmp64_;
				math_equation_factorize (_tmp65_);
				result = TRUE;
				return result;
			}
			case GDK_KEY_i:
			{
				MathEquation* _tmp66_ = NULL;
				MathEquation* _tmp67_ = NULL;
				_tmp66_ = math_display_get_equation (self);
				_tmp67_ = _tmp66_;
				math_equation_insert (_tmp67_, "⁻¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_p:
			{
				MathEquation* _tmp68_ = NULL;
				MathEquation* _tmp69_ = NULL;
				_tmp68_ = math_display_get_equation (self);
				_tmp69_ = _tmp68_;
				math_equation_insert (_tmp69_, "π");
				result = TRUE;
				return result;
			}
			case GDK_KEY_r:
			{
				MathEquation* _tmp70_ = NULL;
				MathEquation* _tmp71_ = NULL;
				_tmp70_ = math_display_get_equation (self);
				_tmp71_ = _tmp70_;
				math_equation_insert (_tmp71_, "√");
				result = TRUE;
				return result;
			}
			case GDK_KEY_u:
			{
				MathEquation* _tmp72_ = NULL;
				MathEquation* _tmp73_ = NULL;
				_tmp72_ = math_display_get_equation (self);
				_tmp73_ = _tmp72_;
				math_equation_insert (_tmp73_, "µ");
				result = TRUE;
				return result;
			}
			case GDK_KEY_minus:
			{
				MathEquation* _tmp74_ = NULL;
				MathEquation* _tmp75_ = NULL;
				_tmp74_ = math_display_get_equation (self);
				_tmp75_ = _tmp74_;
				math_equation_insert (_tmp75_, "⁻");
				result = TRUE;
				return result;
			}
			case GDK_KEY_apostrophe:
			{
				MathEquation* _tmp76_ = NULL;
				MathEquation* _tmp77_ = NULL;
				_tmp76_ = math_display_get_equation (self);
				_tmp77_ = _tmp76_;
				math_equation_insert (_tmp77_, "°");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	_tmp78_ = state;
	if (_tmp78_ == GDK_MOD1_MASK) {
		GdkEventKey* _tmp79_ = NULL;
		guint _tmp80_ = 0U;
		_tmp79_ = event;
		_tmp80_ = _tmp79_->keyval;
		switch (_tmp80_) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp81_ = NULL;
				MathEquation* _tmp82_ = NULL;
				_tmp81_ = math_display_get_equation (self);
				_tmp82_ = _tmp81_;
				math_equation_insert (_tmp82_, "⌊");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp83_ = NULL;
				MathEquation* _tmp84_ = NULL;
				_tmp83_ = math_display_get_equation (self);
				_tmp84_ = _tmp83_;
				math_equation_insert (_tmp84_, "⌋");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	_tmp86_ = state;
	if (_tmp86_ == GDK_CONTROL_MASK) {
		_tmp85_ = TRUE;
	} else {
		MathEquation* _tmp87_ = NULL;
		MathEquation* _tmp88_ = NULL;
		NumberMode _tmp89_ = 0;
		NumberMode _tmp90_ = 0;
		_tmp87_ = math_display_get_equation (self);
		_tmp88_ = _tmp87_;
		_tmp89_ = math_equation_get_number_mode (_tmp88_);
		_tmp90_ = _tmp89_;
		_tmp85_ = _tmp90_ == NUMBER_MODE_SUPERSCRIPT;
	}
	if (_tmp85_) {
		GdkEventKey* _tmp91_ = NULL;
		guint _tmp92_ = 0U;
		_tmp91_ = event;
		_tmp92_ = _tmp91_->keyval;
		switch (_tmp92_) {
			case GDK_KEY_0:
			case GDK_KEY_KP_0:
			{
				MathEquation* _tmp93_ = NULL;
				MathEquation* _tmp94_ = NULL;
				_tmp93_ = math_display_get_equation (self);
				_tmp94_ = _tmp93_;
				math_equation_insert (_tmp94_, "⁰");
				result = TRUE;
				return result;
			}
			case GDK_KEY_1:
			case GDK_KEY_KP_1:
			{
				MathEquation* _tmp95_ = NULL;
				MathEquation* _tmp96_ = NULL;
				_tmp95_ = math_display_get_equation (self);
				_tmp96_ = _tmp95_;
				math_equation_insert (_tmp96_, "¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_2:
			case GDK_KEY_KP_2:
			{
				MathEquation* _tmp97_ = NULL;
				MathEquation* _tmp98_ = NULL;
				_tmp97_ = math_display_get_equation (self);
				_tmp98_ = _tmp97_;
				math_equation_insert (_tmp98_, "²");
				result = TRUE;
				return result;
			}
			case GDK_KEY_3:
			case GDK_KEY_KP_3:
			{
				MathEquation* _tmp99_ = NULL;
				MathEquation* _tmp100_ = NULL;
				_tmp99_ = math_display_get_equation (self);
				_tmp100_ = _tmp99_;
				math_equation_insert (_tmp100_, "³");
				result = TRUE;
				return result;
			}
			case GDK_KEY_4:
			case GDK_KEY_KP_4:
			{
				MathEquation* _tmp101_ = NULL;
				MathEquation* _tmp102_ = NULL;
				_tmp101_ = math_display_get_equation (self);
				_tmp102_ = _tmp101_;
				math_equation_insert (_tmp102_, "⁴");
				result = TRUE;
				return result;
			}
			case GDK_KEY_5:
			case GDK_KEY_KP_5:
			{
				MathEquation* _tmp103_ = NULL;
				MathEquation* _tmp104_ = NULL;
				_tmp103_ = math_display_get_equation (self);
				_tmp104_ = _tmp103_;
				math_equation_insert (_tmp104_, "⁵");
				result = TRUE;
				return result;
			}
			case GDK_KEY_6:
			case GDK_KEY_KP_6:
			{
				MathEquation* _tmp105_ = NULL;
				MathEquation* _tmp106_ = NULL;
				_tmp105_ = math_display_get_equation (self);
				_tmp106_ = _tmp105_;
				math_equation_insert (_tmp106_, "⁶");
				result = TRUE;
				return result;
			}
			case GDK_KEY_7:
			case GDK_KEY_KP_7:
			{
				MathEquation* _tmp107_ = NULL;
				MathEquation* _tmp108_ = NULL;
				_tmp107_ = math_display_get_equation (self);
				_tmp108_ = _tmp107_;
				math_equation_insert (_tmp108_, "⁷");
				result = TRUE;
				return result;
			}
			case GDK_KEY_8:
			case GDK_KEY_KP_8:
			{
				MathEquation* _tmp109_ = NULL;
				MathEquation* _tmp110_ = NULL;
				_tmp109_ = math_display_get_equation (self);
				_tmp110_ = _tmp109_;
				math_equation_insert (_tmp110_, "⁸");
				result = TRUE;
				return result;
			}
			case GDK_KEY_9:
			case GDK_KEY_KP_9:
			{
				MathEquation* _tmp111_ = NULL;
				MathEquation* _tmp112_ = NULL;
				_tmp111_ = math_display_get_equation (self);
				_tmp112_ = _tmp111_;
				math_equation_insert (_tmp112_, "⁹");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	} else {
		gboolean _tmp113_ = FALSE;
		GdkModifierType _tmp114_ = 0;
		_tmp114_ = state;
		if (_tmp114_ == GDK_MOD1_MASK) {
			_tmp113_ = TRUE;
		} else {
			MathEquation* _tmp115_ = NULL;
			MathEquation* _tmp116_ = NULL;
			NumberMode _tmp117_ = 0;
			NumberMode _tmp118_ = 0;
			_tmp115_ = math_display_get_equation (self);
			_tmp116_ = _tmp115_;
			_tmp117_ = math_equation_get_number_mode (_tmp116_);
			_tmp118_ = _tmp117_;
			_tmp113_ = _tmp118_ == NUMBER_MODE_SUBSCRIPT;
		}
		if (_tmp113_) {
			GdkEventKey* _tmp119_ = NULL;
			guint _tmp120_ = 0U;
			_tmp119_ = event;
			_tmp120_ = _tmp119_->keyval;
			switch (_tmp120_) {
				case GDK_KEY_0:
				case GDK_KEY_KP_0:
				{
					MathEquation* _tmp121_ = NULL;
					MathEquation* _tmp122_ = NULL;
					_tmp121_ = math_display_get_equation (self);
					_tmp122_ = _tmp121_;
					math_equation_insert (_tmp122_, "₀");
					result = TRUE;
					return result;
				}
				case GDK_KEY_1:
				case GDK_KEY_KP_1:
				{
					MathEquation* _tmp123_ = NULL;
					MathEquation* _tmp124_ = NULL;
					_tmp123_ = math_display_get_equation (self);
					_tmp124_ = _tmp123_;
					math_equation_insert (_tmp124_, "₁");
					result = TRUE;
					return result;
				}
				case GDK_KEY_2:
				case GDK_KEY_KP_2:
				{
					MathEquation* _tmp125_ = NULL;
					MathEquation* _tmp126_ = NULL;
					_tmp125_ = math_display_get_equation (self);
					_tmp126_ = _tmp125_;
					math_equation_insert (_tmp126_, "₂");
					result = TRUE;
					return result;
				}
				case GDK_KEY_3:
				case GDK_KEY_KP_3:
				{
					MathEquation* _tmp127_ = NULL;
					MathEquation* _tmp128_ = NULL;
					_tmp127_ = math_display_get_equation (self);
					_tmp128_ = _tmp127_;
					math_equation_insert (_tmp128_, "₃");
					result = TRUE;
					return result;
				}
				case GDK_KEY_4:
				case GDK_KEY_KP_4:
				{
					MathEquation* _tmp129_ = NULL;
					MathEquation* _tmp130_ = NULL;
					_tmp129_ = math_display_get_equation (self);
					_tmp130_ = _tmp129_;
					math_equation_insert (_tmp130_, "₄");
					result = TRUE;
					return result;
				}
				case GDK_KEY_5:
				case GDK_KEY_KP_5:
				{
					MathEquation* _tmp131_ = NULL;
					MathEquation* _tmp132_ = NULL;
					_tmp131_ = math_display_get_equation (self);
					_tmp132_ = _tmp131_;
					math_equation_insert (_tmp132_, "₅");
					result = TRUE;
					return result;
				}
				case GDK_KEY_6:
				case GDK_KEY_KP_6:
				{
					MathEquation* _tmp133_ = NULL;
					MathEquation* _tmp134_ = NULL;
					_tmp133_ = math_display_get_equation (self);
					_tmp134_ = _tmp133_;
					math_equation_insert (_tmp134_, "₆");
					result = TRUE;
					return result;
				}
				case GDK_KEY_7:
				case GDK_KEY_KP_7:
				{
					MathEquation* _tmp135_ = NULL;
					MathEquation* _tmp136_ = NULL;
					_tmp135_ = math_display_get_equation (self);
					_tmp136_ = _tmp135_;
					math_equation_insert (_tmp136_, "₇");
					result = TRUE;
					return result;
				}
				case GDK_KEY_8:
				case GDK_KEY_KP_8:
				{
					MathEquation* _tmp137_ = NULL;
					MathEquation* _tmp138_ = NULL;
					_tmp137_ = math_display_get_equation (self);
					_tmp138_ = _tmp137_;
					math_equation_insert (_tmp138_, "₈");
					result = TRUE;
					return result;
				}
				case GDK_KEY_9:
				case GDK_KEY_KP_9:
				{
					MathEquation* _tmp139_ = NULL;
					MathEquation* _tmp140_ = NULL;
					_tmp139_ = math_display_get_equation (self);
					_tmp140_ = _tmp139_;
					math_equation_insert (_tmp140_, "₉");
					result = TRUE;
					return result;
				}
				default:
				break;
			}
		}
	}
	result = FALSE;
	return result;
}


static void math_display_status_changed_cb (MathDisplay* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	MathEquation* _tmp7_ = NULL;
	MathEquation* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->info_buffer;
	_tmp1_ = math_display_get_equation (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = math_equation_get_status (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gtk_text_buffer_set_text (_tmp0_, _tmp5_, -1);
	_g_free0 (_tmp5_);
	_tmp7_ = math_display_get_equation (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = math_equation_get_in_solve (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		GtkSpinner* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = self->priv->spinner;
		_tmp12_ = gtk_widget_get_visible ((GtkWidget*) _tmp11_);
		_tmp6_ = !_tmp12_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GtkSpinner* _tmp13_ = NULL;
		GtkSpinner* _tmp14_ = NULL;
		_tmp13_ = self->priv->spinner;
		gtk_widget_show ((GtkWidget*) _tmp13_);
		_tmp14_ = self->priv->spinner;
		gtk_spinner_start (_tmp14_);
	} else {
		gboolean _tmp15_ = FALSE;
		MathEquation* _tmp16_ = NULL;
		MathEquation* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		_tmp16_ = math_display_get_equation (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = math_equation_get_in_solve (_tmp17_);
		_tmp19_ = _tmp18_;
		if (!_tmp19_) {
			GtkSpinner* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
			_tmp20_ = self->priv->spinner;
			_tmp21_ = gtk_widget_get_visible ((GtkWidget*) _tmp20_);
			_tmp15_ = _tmp21_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			GtkSpinner* _tmp22_ = NULL;
			GtkSpinner* _tmp23_ = NULL;
			_tmp22_ = self->priv->spinner;
			gtk_widget_hide ((GtkWidget*) _tmp22_);
			_tmp23_ = self->priv->spinner;
			gtk_spinner_stop (_tmp23_);
		}
	}
}


static void math_display_error_status_changed_cb (MathDisplay* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	MathEquation* _tmp4_ = NULL;
	MathEquation* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	MathEquation* _tmp8_ = NULL;
	MathEquation* _tmp9_ = NULL;
	GtkTextIter _tmp10_ = {0};
	MathEquation* _tmp11_ = NULL;
	MathEquation* _tmp12_ = NULL;
	GtkTextIter _tmp13_ = {0};
	MathEquation* _tmp14_ = NULL;
	MathEquation* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	guint _tmp17_ = 0U;
	MathEquation* _tmp18_ = NULL;
	MathEquation* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	MathEquation* _tmp22_ = NULL;
	MathEquation* _tmp23_ = NULL;
	GtkTextIter _tmp24_ = {0};
	GtkTextIter _tmp25_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = math_display_get_equation (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = math_equation_get_error_token_end (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = math_display_get_equation (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = math_equation_get_error_token_start (_tmp5_);
	_tmp7_ = _tmp6_;
	if ((_tmp3_ - _tmp7_) == ((guint) 0)) {
		return;
	}
	_tmp8_ = math_display_get_equation (self);
	_tmp9_ = _tmp8_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp9_, &_tmp10_);
	start = _tmp10_;
	_tmp11_ = math_display_get_equation (self);
	_tmp12_ = _tmp11_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp12_, &_tmp13_);
	end = _tmp13_;
	_tmp14_ = math_display_get_equation (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = math_equation_get_error_token_start (_tmp15_);
	_tmp17_ = _tmp16_;
	gtk_text_iter_set_offset (&start, (gint) _tmp17_);
	_tmp18_ = math_display_get_equation (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = math_equation_get_error_token_end (_tmp19_);
	_tmp21_ = _tmp20_;
	gtk_text_iter_set_offset (&end, (gint) _tmp21_);
	_tmp22_ = math_display_get_equation (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = start;
	_tmp25_ = end;
	gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp23_, &_tmp24_, &_tmp25_);
}


void math_display_grab_focus (MathDisplay* self) {
	GtkSourceView* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}


MathEquation* math_display_get_equation (MathDisplay* self) {
	MathEquation* result;
	MathEquation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}


static void math_display_class_init (MathDisplayClass * klass) {
	math_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathDisplayPrivate));
	((GtkWidgetClass *) klass)->key_press_event = math_display_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_display_get_property;
	G_OBJECT_CLASS (klass)->finalize = math_display_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_DISPLAY_EQUATION, g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void math_display_instance_init (MathDisplay * self) {
	self->priv = MATH_DISPLAY_GET_PRIVATE (self);
}


static void math_display_finalize (GObject* obj) {
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_DISPLAY, MathDisplay);
	_g_object_unref0 (self->priv->_equation);
	_g_object_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->source_view);
	_g_object_unref0 (self->priv->info_buffer);
	_g_object_unref0 (self->priv->spinner);
	G_OBJECT_CLASS (math_display_parent_class)->finalize (obj);
}


GType math_display_get_type (void) {
	static volatile gsize math_display_type_id__volatile = 0;
	if (g_once_init_enter (&math_display_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathDisplay), 0, (GInstanceInitFunc) math_display_instance_init, NULL };
		GType math_display_type_id;
		math_display_type_id = g_type_register_static (gtk_viewport_get_type (), "MathDisplay", &g_define_type_info, 0);
		g_once_init_leave (&math_display_type_id__volatile, math_display_type_id);
	}
	return math_display_type_id__volatile;
}


static void _vala_math_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_DISPLAY, MathDisplay);
	switch (property_id) {
		case MATH_DISPLAY_EQUATION:
		g_value_set_object (value, math_display_get_equation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gchar* completion_provider_real_get_name (CompletionProvider* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}


gchar* completion_provider_get_name (CompletionProvider* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return COMPLETION_PROVIDER_GET_CLASS (self)->get_name (self);
}


void completion_provider_move_iter_to_name_start (GtkTextIter* iter) {
	g_return_if_fail (iter != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gunichar current_char = 0U;
		gunichar _tmp1_ = 0U;
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_ = FALSE;
		_tmp0_ = gtk_text_iter_backward_char (iter);
		if (!_tmp0_) {
			break;
		}
		_tmp1_ = gtk_text_iter_get_char (iter);
		current_char = _tmp1_;
		_tmp2_ = current_char;
		_tmp3_ = g_unichar_isalpha (_tmp2_);
		if (!_tmp3_) {
			gtk_text_iter_forward_char (iter);
			break;
		}
	}
}


static gboolean completion_provider_real_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	GtkTextIter _vala_iter = {0};
	gboolean result = FALSE;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	result = FALSE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


gboolean completion_provider_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	g_return_val_if_fail (self != NULL, FALSE);
	return COMPLETION_PROVIDER_GET_CLASS (self)->get_start_iter (self, context, proposal, iter);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gboolean completion_provider_real_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	gboolean result = FALSE;
	gchar* proposed_string = NULL;
	GtkSourceCompletionProposal* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkTextBuffer* buffer = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GtkTextIter _tmp6_ = {0};
	GtkTextBuffer* _tmp7_ = NULL;
	GtkTextIter _tmp8_ = {0};
	GtkTextBuffer* _tmp9_ = NULL;
	GtkTextIter _tmp10_ = {0};
	GtkTextIter _tmp11_ = {0};
	GtkTextBuffer* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	g_return_val_if_fail (proposal != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = proposal;
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
	proposed_string = _tmp1_;
	_tmp2_ = gtk_text_iter_get_buffer (iter);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buffer = _tmp3_;
	_tmp4_ = buffer;
	_tmp5_ = gtk_text_iter_get_offset (iter);
	gtk_text_buffer_get_iter_at_offset (_tmp4_, &_tmp6_, _tmp5_);
	start_iter = _tmp6_;
	completion_provider_move_iter_to_name_start (&start_iter);
	_tmp7_ = buffer;
	_tmp8_ = start_iter;
	gtk_text_buffer_place_cursor (_tmp7_, &_tmp8_);
	_tmp9_ = buffer;
	_tmp10_ = start_iter;
	_tmp11_ = *iter;
	g_signal_emit_by_name (_tmp9_, "delete-range", &_tmp10_, &_tmp11_);
	_tmp12_ = buffer;
	_tmp13_ = proposed_string;
	_tmp14_ = proposed_string;
	_tmp15_ = strlen (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_text_buffer_insert_at_cursor (_tmp12_, _tmp13_, _tmp16_);
	_tmp17_ = proposed_string;
	_tmp18_ = string_contains (_tmp17_, "()");
	if (_tmp18_) {
		GtkTextBuffer* _tmp19_ = NULL;
		GtkTextBuffer* _tmp20_ = NULL;
		GtkTextMark* _tmp21_ = NULL;
		GtkTextIter _tmp22_ = {0};
		GtkTextBuffer* _tmp23_ = NULL;
		GtkTextIter _tmp24_ = {0};
		_tmp19_ = buffer;
		_tmp20_ = buffer;
		_tmp21_ = gtk_text_buffer_get_insert (_tmp20_);
		gtk_text_buffer_get_iter_at_mark (_tmp19_, &_tmp22_, _tmp21_);
		end = _tmp22_;
		gtk_text_iter_backward_chars (&end, 1);
		_tmp23_ = buffer;
		_tmp24_ = end;
		gtk_text_buffer_place_cursor (_tmp23_, &_tmp24_);
	}
	result = TRUE;
	_g_object_unref0 (buffer);
	_g_free0 (proposed_string);
	return result;
}


gboolean completion_provider_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	g_return_val_if_fail (self != NULL, FALSE);
	return COMPLETION_PROVIDER_GET_CLASS (self)->activate_proposal (self, proposal, iter);
}


static void completion_provider_real_populate (CompletionProvider* self, GtkSourceCompletionContext* context) {
	g_return_if_fail (context != NULL);
}


void completion_provider_populate (CompletionProvider* self, GtkSourceCompletionContext* context) {
	g_return_if_fail (self != NULL);
	COMPLETION_PROVIDER_GET_CLASS (self)->populate (self, context);
}


CompletionProvider* completion_provider_construct (GType object_type) {
	CompletionProvider * self = NULL;
	self = (CompletionProvider*) g_object_new (object_type, NULL);
	return self;
}


CompletionProvider* completion_provider_new (void) {
	return completion_provider_construct (TYPE_COMPLETION_PROVIDER);
}


static void completion_provider_class_init (CompletionProviderClass * klass) {
	completion_provider_parent_class = g_type_class_peek_parent (klass);
	((CompletionProviderClass *) klass)->get_name = completion_provider_real_get_name;
	((CompletionProviderClass *) klass)->get_start_iter = completion_provider_real_get_start_iter;
	((CompletionProviderClass *) klass)->activate_proposal = completion_provider_real_activate_proposal;
	((CompletionProviderClass *) klass)->populate = completion_provider_real_populate;
}


static void completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface) {
	completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*)(GtkSourceCompletionProvider*)) completion_provider_get_name;
	iface->get_start_iter = (gboolean (*)(GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_get_start_iter;
	iface->activate_proposal = (gboolean (*)(GtkSourceCompletionProvider*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_activate_proposal;
	iface->populate = (void (*)(GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_populate;
}


static void completion_provider_instance_init (CompletionProvider * self) {
}


GType completion_provider_get_type (void) {
	static volatile gsize completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProvider), 0, (GInstanceInitFunc) completion_provider_instance_init, NULL };
		static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType completion_provider_type_id;
		completion_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProvider", &g_define_type_info, 0);
		g_type_add_interface_static (completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
		g_once_init_leave (&completion_provider_type_id__volatile, completion_provider_type_id);
	}
	return completion_provider_type_id__volatile;
}


static gchar* function_completion_provider_real_get_name (CompletionProvider* base) {
	FunctionCompletionProvider * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	self = (FunctionCompletionProvider*) base;
	_tmp0_ = g_strdup ("Defined Functions");
	result = _tmp0_;
	return result;
}


MathFunction** function_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, int* result_length1) {
	MathFunction** result = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextMark* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	gchar* search_pattern = NULL;
	GtkTextBuffer* _tmp8_ = NULL;
	GtkTextIter _tmp9_ = {0};
	GtkTextIter _tmp10_ = {0};
	gchar* _tmp11_ = NULL;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp12_ = NULL;
	MathFunction** functions = NULL;
	gint _tmp13_ = 0;
	MathFunction** _tmp14_ = NULL;
	gint functions_length1 = 0;
	gint _functions_size_ = 0;
	MathFunction** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	g_return_val_if_fail (text_buffer != NULL, NULL);
	_tmp0_ = text_buffer;
	_tmp1_ = text_buffer;
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
	gtk_text_buffer_get_iter_at_mark (_tmp0_, &_tmp3_, _tmp2_);
	end_iter = _tmp3_;
	_tmp4_ = text_buffer;
	_tmp5_ = text_buffer;
	_tmp6_ = gtk_text_buffer_get_insert (_tmp5_);
	gtk_text_buffer_get_iter_at_mark (_tmp4_, &_tmp7_, _tmp6_);
	start_iter = _tmp7_;
	completion_provider_move_iter_to_name_start (&start_iter);
	_tmp8_ = text_buffer;
	_tmp9_ = start_iter;
	_tmp10_ = end_iter;
	_tmp11_ = gtk_text_buffer_get_slice (_tmp8_, &_tmp9_, &_tmp10_, FALSE);
	search_pattern = _tmp11_;
	_tmp12_ = function_manager_get_default_function_manager ();
	function_manager = _tmp12_;
	_tmp14_ = function_manager_functions_eligible_for_autocompletion_for_text (function_manager, search_pattern, &_tmp13_);
	functions = _tmp14_;
	functions_length1 = _tmp13_;
	_functions_size_ = functions_length1;
	_tmp15_ = functions;
	_tmp15__length1 = functions_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	_g_object_unref0 (function_manager);
	_g_free0 (search_pattern);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_ = NULL;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_ = NULL;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


static void function_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context) {
	FunctionCompletionProvider * self;
	GtkTextIter iter1 = {0};
	GtkSourceCompletionContext* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkTextBuffer* text_buffer = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	MathFunction** functions = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	MathFunction** _tmp7_ = NULL;
	gint functions_length1 = 0;
	gint _functions_size_ = 0;
	GList* proposals = NULL;
	MathFunction** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	GtkSourceCompletionContext* _tmp52_ = NULL;
	GList* _tmp53_ = NULL;
	self = (FunctionCompletionProvider*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp2_ = gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
	iter1 = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = gtk_text_iter_get_buffer (&iter1);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	text_buffer = _tmp4_;
	_tmp5_ = text_buffer;
	_tmp7_ = function_completion_provider_get_matches_for_completion_at_cursor (_tmp5_, &_tmp6_);
	functions = _tmp7_;
	functions_length1 = _tmp6_;
	_functions_size_ = functions_length1;
	proposals = NULL;
	_tmp8_ = functions;
	_tmp8__length1 = functions_length1;
	if (_tmp8__length1 > 0) {
		MathFunction** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		__g_list_free__g_object_unref0_0 (proposals);
		proposals = NULL;
		_tmp9_ = functions;
		_tmp9__length1 = functions_length1;
		{
			MathFunction** function_collection = NULL;
			gint function_collection_length1 = 0;
			gint _function_collection_size_ = 0;
			gint function_it = 0;
			function_collection = _tmp9_;
			function_collection_length1 = _tmp9__length1;
			for (function_it = 0; function_it < _tmp9__length1; function_it = function_it + 1) {
				MathFunction* _tmp10_ = NULL;
				MathFunction* function = NULL;
				_tmp10_ = _g_object_ref0 (function_collection[function_it]);
				function = _tmp10_;
				{
					gchar* display_text = NULL;
					MathFunction* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					MathFunction* _tmp14_ = NULL;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					gchar** _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					gchar* details_text = NULL;
					MathFunction* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					gchar* label_text = NULL;
					MathFunction* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					MathFunction* _tmp29_ = NULL;
					gboolean _tmp30_ = FALSE;
					GtkSourceCompletionItem* proposal = NULL;
					const gchar* _tmp46_ = NULL;
					const gchar* _tmp47_ = NULL;
					const gchar* _tmp48_ = NULL;
					GtkSourceCompletionItem* _tmp49_ = NULL;
					GtkSourceCompletionItem* _tmp50_ = NULL;
					GtkSourceCompletionItem* _tmp51_ = NULL;
					_tmp11_ = function;
					_tmp12_ = math_function_get_name (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = function;
					_tmp15_ = math_function_get_arguments (_tmp14_, &_tmp15__length1);
					_tmp16_ = _tmp15_;
					_tmp16__length1 = _tmp15__length1;
					_tmp17_ = _vala_g_strjoinv (";", _tmp16_, _tmp16__length1);
					_tmp18_ = _tmp17_;
					_tmp19_ = g_strdup_printf ("%s(%s)", _tmp13_, _tmp18_);
					_tmp20_ = _tmp19_;
					_g_free0 (_tmp18_);
					display_text = _tmp20_;
					_tmp21_ = function;
					_tmp22_ = math_function_get_description (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strdup_printf ("%s", _tmp23_);
					details_text = _tmp24_;
					_tmp25_ = function;
					_tmp26_ = math_function_get_name (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = g_strconcat (_tmp27_, "()", NULL);
					label_text = _tmp28_;
					_tmp29_ = function;
					_tmp30_ = math_function_is_custom_function (_tmp29_);
					if (_tmp30_) {
						MathFunction* _tmp31_ = NULL;
						const gchar* _tmp32_ = NULL;
						const gchar* _tmp33_ = NULL;
						MathFunction* _tmp34_ = NULL;
						gchar** _tmp35_ = NULL;
						gint _tmp35__length1 = 0;
						gchar** _tmp36_ = NULL;
						gint _tmp36__length1 = 0;
						gchar* _tmp37_ = NULL;
						gchar* _tmp38_ = NULL;
						MathFunction* _tmp39_ = NULL;
						const gchar* _tmp40_ = NULL;
						const gchar* _tmp41_ = NULL;
						MathFunction* _tmp42_ = NULL;
						const gchar* _tmp43_ = NULL;
						const gchar* _tmp44_ = NULL;
						gchar* _tmp45_ = NULL;
						_tmp31_ = function;
						_tmp32_ = math_function_get_name (_tmp31_);
						_tmp33_ = _tmp32_;
						_tmp34_ = function;
						_tmp35_ = math_function_get_arguments (_tmp34_, &_tmp35__length1);
						_tmp36_ = _tmp35_;
						_tmp36__length1 = _tmp35__length1;
						_tmp37_ = _vala_g_strjoinv (";", _tmp36_, _tmp36__length1);
						_tmp38_ = _tmp37_;
						_tmp39_ = function;
						_tmp40_ = math_function_get_expression (_tmp39_);
						_tmp41_ = _tmp40_;
						_tmp42_ = function;
						_tmp43_ = math_function_get_description (_tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = g_strdup_printf ("%s(%s)=%s\n%s", _tmp33_, _tmp38_, _tmp41_, _tmp44_);
						_g_free0 (details_text);
						details_text = _tmp45_;
						_g_free0 (_tmp38_);
					}
					_tmp46_ = display_text;
					_tmp47_ = label_text;
					_tmp48_ = details_text;
					_tmp49_ = gtk_source_completion_item_new (_tmp46_, _tmp47_, NULL, _tmp48_);
					proposal = _tmp49_;
					_tmp50_ = proposal;
					_tmp51_ = _g_object_ref0 (_tmp50_);
					proposals = g_list_append (proposals, _tmp51_);
					_g_object_unref0 (proposal);
					_g_free0 (label_text);
					_g_free0 (details_text);
					_g_free0 (display_text);
					_g_object_unref0 (function);
				}
			}
		}
	}
	_tmp52_ = context;
	_tmp53_ = proposals;
	gtk_source_completion_context_add_proposals (_tmp52_, (GtkSourceCompletionProvider*) self, _tmp53_, TRUE);
	__g_list_free__g_object_unref0_0 (proposals);
	functions = (_vala_array_free (functions, functions_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (text_buffer);
}


FunctionCompletionProvider* function_completion_provider_construct (GType object_type) {
	FunctionCompletionProvider * self = NULL;
	self = (FunctionCompletionProvider*) completion_provider_construct (object_type);
	return self;
}


FunctionCompletionProvider* function_completion_provider_new (void) {
	return function_completion_provider_construct (TYPE_FUNCTION_COMPLETION_PROVIDER);
}


static void function_completion_provider_class_init (FunctionCompletionProviderClass * klass) {
	function_completion_provider_parent_class = g_type_class_peek_parent (klass);
	((CompletionProviderClass *) klass)->get_name = function_completion_provider_real_get_name;
	((CompletionProviderClass *) klass)->populate = function_completion_provider_real_populate;
}


static void function_completion_provider_instance_init (FunctionCompletionProvider * self) {
}


GType function_completion_provider_get_type (void) {
	static volatile gsize function_completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&function_completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionCompletionProvider), 0, (GInstanceInitFunc) function_completion_provider_instance_init, NULL };
		GType function_completion_provider_type_id;
		function_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "FunctionCompletionProvider", &g_define_type_info, 0);
		g_once_init_leave (&function_completion_provider_type_id__volatile, function_completion_provider_type_id);
	}
	return function_completion_provider_type_id__volatile;
}


VariableCompletionProvider* variable_completion_provider_construct (GType object_type, MathEquation* equation) {
	VariableCompletionProvider * self = NULL;
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (VariableCompletionProvider*) completion_provider_construct (object_type);
	_tmp0_ = equation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp1_;
	return self;
}


VariableCompletionProvider* variable_completion_provider_new (MathEquation* equation) {
	return variable_completion_provider_construct (TYPE_VARIABLE_COMPLETION_PROVIDER, equation);
}


static gchar* variable_completion_provider_real_get_name (CompletionProvider* base) {
	VariableCompletionProvider * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	self = (VariableCompletionProvider*) base;
	_tmp0_ = g_strdup ("Defined Variables");
	result = _tmp0_;
	return result;
}


gchar** variable_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, MathVariables* variables, int* result_length1) {
	gchar** result = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextMark* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	gchar* search_pattern = NULL;
	GtkTextBuffer* _tmp8_ = NULL;
	GtkTextIter _tmp9_ = {0};
	GtkTextIter _tmp10_ = {0};
	gchar* _tmp11_ = NULL;
	gchar** math_variables = NULL;
	MathVariables* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gchar** _tmp14_ = NULL;
	gint math_variables_length1 = 0;
	gint _math_variables_size_ = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	g_return_val_if_fail (text_buffer != NULL, NULL);
	g_return_val_if_fail (variables != NULL, NULL);
	_tmp0_ = text_buffer;
	_tmp1_ = text_buffer;
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
	gtk_text_buffer_get_iter_at_mark (_tmp0_, &_tmp3_, _tmp2_);
	end_iter = _tmp3_;
	_tmp4_ = text_buffer;
	_tmp5_ = text_buffer;
	_tmp6_ = gtk_text_buffer_get_insert (_tmp5_);
	gtk_text_buffer_get_iter_at_mark (_tmp4_, &_tmp7_, _tmp6_);
	start_iter = _tmp7_;
	completion_provider_move_iter_to_name_start (&start_iter);
	_tmp8_ = text_buffer;
	_tmp9_ = start_iter;
	_tmp10_ = end_iter;
	_tmp11_ = gtk_text_buffer_get_slice (_tmp8_, &_tmp9_, &_tmp10_, FALSE);
	search_pattern = _tmp11_;
	_tmp12_ = variables;
	_tmp14_ = math_variables_variables_eligible_for_autocompletion (_tmp12_, search_pattern, &_tmp13_);
	math_variables = _tmp14_;
	math_variables_length1 = _tmp13_;
	_math_variables_size_ = math_variables_length1;
	_tmp15_ = math_variables;
	_tmp15__length1 = math_variables_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	_g_free0 (search_pattern);
	return result;
}


static void variable_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context) {
	VariableCompletionProvider * self;
	GtkTextIter iter1 = {0};
	GtkSourceCompletionContext* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkTextBuffer* text_buffer = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	gchar** variables = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	MathEquation* _tmp6_ = NULL;
	MathVariables* _tmp7_ = NULL;
	MathVariables* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar** _tmp10_ = NULL;
	gint variables_length1 = 0;
	gint _variables_size_ = 0;
	GList* proposals = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GtkSourceCompletionContext* _tmp35_ = NULL;
	GList* _tmp36_ = NULL;
	self = (VariableCompletionProvider*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp2_ = gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
	iter1 = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = gtk_text_iter_get_buffer (&iter1);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	text_buffer = _tmp4_;
	_tmp5_ = text_buffer;
	_tmp6_ = self->priv->_equation;
	_tmp7_ = math_equation_get_variables (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp10_ = variable_completion_provider_get_matches_for_completion_at_cursor (_tmp5_, _tmp8_, &_tmp9_);
	variables = _tmp10_;
	variables_length1 = _tmp9_;
	_variables_size_ = variables_length1;
	proposals = NULL;
	_tmp11_ = variables;
	_tmp11__length1 = variables_length1;
	if (_tmp11__length1 > 0) {
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		__g_list_free__g_object_unref0_0 (proposals);
		proposals = NULL;
		_tmp12_ = variables;
		_tmp12__length1 = variables_length1;
		{
			gchar** variable_collection = NULL;
			gint variable_collection_length1 = 0;
			gint _variable_collection_size_ = 0;
			gint variable_it = 0;
			variable_collection = _tmp12_;
			variable_collection_length1 = _tmp12__length1;
			for (variable_it = 0; variable_it < _tmp12__length1; variable_it = variable_it + 1) {
				gchar* _tmp13_ = NULL;
				gchar* variable = NULL;
				_tmp13_ = g_strdup (variable_collection[variable_it]);
				variable = _tmp13_;
				{
					gchar* display_text = NULL;
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					gchar* details_text = NULL;
					MathEquation* _tmp16_ = NULL;
					Serializer* _tmp17_ = NULL;
					Serializer* _tmp18_ = NULL;
					MathEquation* _tmp19_ = NULL;
					MathVariables* _tmp20_ = NULL;
					MathVariables* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					Number* _tmp23_ = NULL;
					Number* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					gchar* label_text = NULL;
					const gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					GtkSourceCompletionItem* proposal = NULL;
					const gchar* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					const gchar* _tmp31_ = NULL;
					GtkSourceCompletionItem* _tmp32_ = NULL;
					GtkSourceCompletionItem* _tmp33_ = NULL;
					GtkSourceCompletionItem* _tmp34_ = NULL;
					_tmp14_ = variable;
					_tmp15_ = g_strdup_printf ("%s", _tmp14_);
					display_text = _tmp15_;
					_tmp16_ = self->priv->_equation;
					_tmp17_ = math_equation_get_serializer (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = self->priv->_equation;
					_tmp20_ = math_equation_get_variables (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = variable;
					_tmp23_ = math_variables_get (_tmp21_, _tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = serializer_to_string (_tmp18_, _tmp24_);
					_tmp26_ = _tmp25_;
					_g_object_unref0 (_tmp24_);
					details_text = _tmp26_;
					_tmp27_ = variable;
					_tmp28_ = g_strdup (_tmp27_);
					label_text = _tmp28_;
					_tmp29_ = display_text;
					_tmp30_ = label_text;
					_tmp31_ = details_text;
					_tmp32_ = gtk_source_completion_item_new (_tmp29_, _tmp30_, NULL, _tmp31_);
					proposal = _tmp32_;
					_tmp33_ = proposal;
					_tmp34_ = _g_object_ref0 (_tmp33_);
					proposals = g_list_append (proposals, _tmp34_);
					_g_object_unref0 (proposal);
					_g_free0 (label_text);
					_g_free0 (details_text);
					_g_free0 (display_text);
					_g_free0 (variable);
				}
			}
		}
	}
	_tmp35_ = context;
	_tmp36_ = proposals;
	gtk_source_completion_context_add_proposals (_tmp35_, (GtkSourceCompletionProvider*) self, _tmp36_, TRUE);
	__g_list_free__g_object_unref0_0 (proposals);
	variables = (_vala_array_free (variables, variables_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (text_buffer);
}


static void variable_completion_provider_class_init (VariableCompletionProviderClass * klass) {
	variable_completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VariableCompletionProviderPrivate));
	((CompletionProviderClass *) klass)->get_name = variable_completion_provider_real_get_name;
	((CompletionProviderClass *) klass)->populate = variable_completion_provider_real_populate;
	G_OBJECT_CLASS (klass)->finalize = variable_completion_provider_finalize;
}


static void variable_completion_provider_instance_init (VariableCompletionProvider * self) {
	self->priv = VARIABLE_COMPLETION_PROVIDER_GET_PRIVATE (self);
}


static void variable_completion_provider_finalize (GObject* obj) {
	VariableCompletionProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProvider);
	_g_object_unref0 (self->priv->_equation);
	G_OBJECT_CLASS (variable_completion_provider_parent_class)->finalize (obj);
}


GType variable_completion_provider_get_type (void) {
	static volatile gsize variable_completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&variable_completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VariableCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) variable_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VariableCompletionProvider), 0, (GInstanceInitFunc) variable_completion_provider_instance_init, NULL };
		GType variable_completion_provider_type_id;
		variable_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "VariableCompletionProvider", &g_define_type_info, 0);
		g_once_init_leave (&variable_completion_provider_type_id__volatile, variable_completion_provider_type_id);
	}
	return variable_completion_provider_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



