/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 or 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef MIRAL_VERSION_H_
#define MIRAL_VERSION_H_

#include "mir_toolkit/mir_version_number.h"

// =========================================================================================
// ==>  miral/version.h is generated by cmake.  DO NOT EDIT! (edit version.h.in instead) <==
// =========================================================================================

/**
 * MIRAL_MAJOR_VERSION
 *
 * The major MirAL API version. This will increase once per API incompatible release.
 *
 * See also: http://semver.org/
 */
#define MIRAL_MAJOR_VERSION (2)

/**
 * MIRAL_MINOR_VERSION
 *
 * The minor MirAL API version. This will increase each time new backwards-compatible API
 * is added, and will reset to 0 each time MIRAL_MAJOR_VERSION is incremented.
 *
 * See also: http://semver.org/
 */
#define MIRAL_MINOR_VERSION (0)

/**
 * MIRAL_MICRO_VERSION
 *
 * The micro miral API version. This will increment each release.
 * This is usually uninteresting for server code, but may be of use in selecting
 * whether to use a feature that has previously been buggy.
 *
 * This corresponds to the PATCH field of http://semver.org/
 */
#define MIRAL_MICRO_VERSION (0)

/**
 * MIRAL_VERSION
 *
 * The current version of the MirAL headers in use.
 */
#define MIRAL_VERSION \
    MIR_VERSION_NUMBER(MIRAL_MAJOR_VERSION, \
                       MIRAL_MINOR_VERSION, \
                       MIRAL_MICRO_VERSION)

#endif /* MIRAL_VERSION_H_ */
