/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SampleElements;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@GwtCompatible
public abstract class AbstractContainerTester<C, E>
extends AbstractTester<OneSizeTestContainerGenerator<C, E>> {
    protected SampleElements<E> samples;
    protected C container;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.samples = ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).samples();
        this.resetContainer();
    }

    protected abstract Collection<E> actualContents();

    protected C resetContainer() {
        return (C)this.resetContainer(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).createTestSubject());
    }

    protected C resetContainer(C newValue) {
        this.container = newValue;
        return this.container;
    }

    protected final void expectContents(E ... elements) {
        this.expectContents(Arrays.asList(elements));
    }

    protected void expectContents(Collection<E> expected) {
        Helpers.assertEqualIgnoringOrder(expected, this.actualContents());
    }

    protected void expectUnchanged() {
        this.expectContents(this.getSampleElements());
    }

    protected final void expectAdded(E ... elements) {
        List<E> expected = Helpers.copyToList(this.getSampleElements());
        expected.addAll(Arrays.asList(elements));
        this.expectContents(expected);
    }

    protected final void expectAdded(int index, E ... elements) {
        this.expectAdded(index, Arrays.asList(elements));
    }

    protected final void expectAdded(int index, Collection<E> elements) {
        List<E> expected = Helpers.copyToList(this.getSampleElements());
        expected.addAll(index, elements);
        this.expectContents(expected);
    }

    protected void expectMissing(E ... elements) {
        for (E element : elements) {
            AbstractContainerTester.assertFalse((String)("Should not contain " + element), (boolean)this.actualContents().contains(element));
        }
    }

    protected E[] createSamplesArray() {
        E[] array = ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).createArray(this.getNumElements());
        this.getSampleElements().toArray(array);
        return array;
    }

    protected ArrayWithDuplicate<E> createArrayWithDuplicateElement() {
        E duplicate;
        Object[] elements = this.createSamplesArray();
        elements[elements.length / 2 + 1] = duplicate = elements[elements.length / 2 - 1];
        return new ArrayWithDuplicate(elements, duplicate);
    }

    protected int getNumElements() {
        return ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getCollectionSize().getNumElements();
    }

    protected Collection<E> getSampleElements(int howMany) {
        return ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getSampleElements(howMany);
    }

    protected Collection<E> getSampleElements() {
        return this.getSampleElements(this.getNumElements());
    }

    protected List<E> getOrderedElements() {
        ArrayList<E> list = new ArrayList<E>();
        for (E e : ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).order(new ArrayList<E>(this.getSampleElements()))) {
            list.add(e);
        }
        return Collections.unmodifiableList(list);
    }

    protected int getNullLocation() {
        return this.getNumElements() / 2;
    }

    protected MinimalCollection<E> createDisjointCollection() {
        return MinimalCollection.of(this.samples.e3, this.samples.e4);
    }

    protected MinimalCollection<E> emptyCollection() {
        return MinimalCollection.of(new Object[0]);
    }

    public static class ArrayWithDuplicate<E> {
        public final E[] elements;
        public final E duplicate;

        private ArrayWithDuplicate(E[] elements, E duplicate) {
            this.elements = elements;
            this.duplicate = duplicate;
        }
    }
}

