/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;

public class LayoutPanelParser
implements ElementParser {
    private static final String ERR_PAIRING = "'%s' must be paired with '%s' or '%s'.";
    private static final String ERR_TOO_MANY = "There are too many %s constraints.";
    private static final String ERR_NEGATIVE_WIDTH = "Attribute 'width' can not be negative.";
    private static final String ERR_NEGATIVE_HEIGHT = "Attribute 'height' can not be negative.";
    private static final String LAYER = "layer";

    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        for (XMLElement layerElem : elem.consumeChildElements()) {
            if (!this.isElementType(elem, layerElem, LAYER)) {
                writer.die(layerElem, "Only <%s:%s> children are allowed.", new Object[]{elem.getPrefix(), LAYER});
            }
            String childFieldName = writer.parseElementToField(layerElem.consumeSingleChildElement());
            writer.addStatement("%1$s.add(%2$s);", new Object[]{fieldName, childFieldName});
            String left = layerElem.consumeLengthAttribute("left");
            String right = layerElem.consumeLengthAttribute("right");
            String width = layerElem.consumeLengthAttribute("width");
            if (this.isNegative(width)) {
                writer.die(layerElem, ERR_NEGATIVE_WIDTH, new Object[0]);
            }
            if (left != null) {
                if (right != null) {
                    if (width != null) {
                        writer.die(layerElem, ERR_TOO_MANY, new Object[]{"horizontal"});
                    }
                    this.generateConstraint(fieldName, childFieldName, "LeftRight", left, right, writer);
                } else if (width != null) {
                    this.generateConstraint(fieldName, childFieldName, "LeftWidth", left, width, writer);
                } else {
                    writer.die(layerElem, ERR_PAIRING, new Object[]{"left", "right", "width"});
                }
            } else if (right != null) {
                if (width != null) {
                    this.generateConstraint(fieldName, childFieldName, "RightWidth", right, width, writer);
                } else {
                    writer.die(layerElem, ERR_PAIRING, new Object[]{"right", "left", "width"});
                }
            }
            String top = layerElem.consumeLengthAttribute("top");
            String bottom = layerElem.consumeLengthAttribute("bottom");
            String height = layerElem.consumeLengthAttribute("height");
            if (this.isNegative(height)) {
                writer.die(layerElem, ERR_NEGATIVE_HEIGHT, new Object[0]);
            }
            if (top != null) {
                if (bottom != null) {
                    if (height != null) {
                        writer.die(layerElem, ERR_TOO_MANY, new Object[]{"vertical"});
                    }
                    this.generateConstraint(fieldName, childFieldName, "TopBottom", top, bottom, writer);
                    continue;
                }
                if (height != null) {
                    this.generateConstraint(fieldName, childFieldName, "TopHeight", top, height, writer);
                    continue;
                }
                writer.die(layerElem, ERR_PAIRING, new Object[]{"top", "bottom", "height"});
                continue;
            }
            if (bottom == null) continue;
            if (height != null) {
                this.generateConstraint(fieldName, childFieldName, "BottomHeight", bottom, height, writer);
                continue;
            }
            writer.die(layerElem, ERR_PAIRING, new Object[]{"bottom", "top", "height"});
        }
    }

    private void generateConstraint(String panelName, String widgetName, String constraintName, String first, String second, UiBinderWriter writer) {
        writer.addStatement("%s.setWidget%s(%s, %s, %s);", new Object[]{panelName, constraintName, widgetName, first, second});
    }

    private boolean isElementType(XMLElement parent, XMLElement child, String type) {
        return parent.getNamespaceUri().equals(child.getNamespaceUri()) && type.equals(child.getLocalName());
    }

    private boolean isNegative(String expression) {
        if (expression != null && expression.length() >= 2 && expression.charAt(0) == '-') {
            char secondChar = expression.charAt(1);
            return Character.isDigit(secondChar);
        }
        return false;
    }
}

