/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_GSTR.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfgGetString
su(bsystem): cmdline
ty(pe): H
sy(nopsis): 
sh(ort description): Scan an option as string
he(ader files): 
lo(ng description): Check if the current option applies to the string
	type and perform the actions, if so.\par
	On success the value of \para{*num} has been changed to a pointer
	to the string, which has been duplicated into the heap.\par
	The string \tok{*num} is pointing to on entry of the function is 
	deallocated.
pr(erequistes): \tok{*num} must contain \tok{NULL} or a pointer to a 
	dynamically allocated string
re(lated to): 
se(condary subsystems): 
va:
 \item		\tok{0}: success
 \item		\tok{1}: failed, no argument, **num not changed
 \item		\tok{2}: no memory, **num not changed
xr(ef): 
im(port): 
fi(le): cfg_gstr.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <string.h>
#endif
#include <limits.h>
#include <portable.h>
#include "dynstr.h"
#include "cfg.loc"
#include "dynstr.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_GSTR.C 1.6 2001/02/27 01:28:02 ska Exp ska $";
#endif

int cfgGetString(struct Cfg_Getopt * const optstru, char ** const num)
{	char *p;

	DBG_ENTER("cfgGetString", Suppl_cmdline)

	assert(optstru);

	chkHeap
	if(optArgType() == CFG_TERROR)
		DBG_RETURN_I( 1)		/* no argument at all */

	if((p = Strdup(optArgString())) == 0)
		DBG_RETURN_I( 2)

	StrRepl_(num, p);
	DBG_RETURN_I( 0)
}
