/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIII.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgInitINI(void)
		Initializes the INI interface for random access.
		To change the default INI filename or the path to the system
		INI file, call cfgChangeNameINI() or cfgChangePathINI()
		before calling this function.
		Must be called _before_ any of the other "random access" functions
		can be called.
		Return: 0: on success

ob(ject): cfgInitINI
su(bsystem): inifile/2
sh(ort description): Initialize the INI interfaces for random access
lo(ng description): Initializes the INI subsystem for random access. To use
	other than the default INI filename or the default path to the
	system INI file, call cfgchangeNameINI() or cfgChangePathINI()
	before calling this function.
wa: cfgInitINI() must be called \em{before} any of the other random access
	function can be called, except cfgExitINI().
re(lated to): 
fi(le): cfgiii.c
in(itialized by): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"
#include "supplio.h"
#include "dynstr.h"
#include "appname.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIII.C 1.5 2001/02/27 01:27:44 ska Exp ska $";
#endif

int cfgi_opFileStru(inifstru * const f, char * const fnam)
{	
	assert(f);
	assert(fnam);

	chkHeap
	StrRepl(f->cfgi_fnam, fnam);
	chkHeap
	if((f->cfgi_fp = Fyopen(fnam, "rt")) != 0) {
		chkHeap
		/* system INI file available */
	//	f->cfgi_avail = 1;					/* for Nxt*() functions */
	//	FFgetpos(f->cfgi_fp, f->cfgi_pos);
		return 1;
	}
	return 0;
}

int cfgInitINI(void)
{	char *path;

	DBG_ENTER("cfgInitINI", Suppl_inifile2)

	/* Test if an INI file is already opened */
	if(sysini.cfgi_fnam || usrini.cfgi_fnam)
	 	DBG_RETURN_I( CFG_ERR_ALREADY)

	chkHeap
	/* Try to open the system INI file */
	if((path = cfgi_sysINIfile()) == 0)
		return CFG_ERR_MEM;
	chkHeap

	cfgi_opFileStru(aS(sysini), path);
	chkHeap

	if((path = cfgi_userINIfile()) == 0) {
		chkHeap
		cfgi_clFileStru(aS(sysini));
		chkHeap
		DBG_RETURN_I( CFG_ERR_MEM)
	}
	chkHeap

//printf("user INI file: %s\n", path);
	cfgi_opFileStru(aS(usrini), path);
	chkHeap

	/* Update all necessary fields because INIT automatically
		opens the NULL section */
	cfgOpenSection(0);
	chkHeap

	DBG_RETURN_I( CFG_ERR_NONE)
}
