#ifdef USE_VBR
#include "l3bs_old.c"
#else
/*
 *	for new GOGO-no-coda (1999/09, 2000)
 *	modified by shigeo
 *	renewed by sakai (2000/02)
 *			by shigeo@(2000/11/10)
 */

extern const int *scalefac_long;
extern const int *scalefac_short;

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "l3bs.h"		/* the public interface */
#include "l3psy.h"
#include "mdct.h"
#include "loop.h"
#include "huffman.h"
#include "bitstrem.h"		/* for putbits() */

static unsigned slen1_tab[16] = {0, 0, 0, 0, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4};
static unsigned slen2_tab[16] = {0, 1, 2, 3, 0, 1, 2, 3, 1, 2, 3, 1, 2, 3, 2, 3};

/* export to putbits.nas */
int BitCount = 0;
int BitsRemaining = 0;
void write_main_data_with_side_info(unsigned int val, unsigned int nbits);

/* forward declarations */
static void store_side_info(III_side_info_t *si, int bitsPerFrame);
static void Huffmancodebits(int *ix, gr_info *gi);

typedef struct list_t{
	int frameLength;
	int SILength;
	III_side_info_t	l3_side;
} list_t;

static list_t queBuf[2];
static struct{
	int frameSize;
	int frameLength;
	int SILength;
	int element;
	int stat;
} que;

/*
 * 00/11/10 by shigeo
 * store, getJԂAqueobt@͍ő2
 * ̂Ƃ̑JڏԂ5Ȃ
 * pushׂ͂̔ԍ
 * pop͏oׂ̔ԍ
 * up1Ƃ̏Ԕԍ
 * down1Ƃ̏Ԕԍ(-1͂肦Ȃ)
 */
static struct{
	int push, pop;
	int up, down;
} queTbl[5] = {		/*  box0 box1 */
	{ 0, -1, 1,-1},	/* [   ][   ] */
	{ 1,  0, 2, 0},	/* [ * ][   ] */
	{-1,  0,-1, 3},	/* [old][new] */
	{ 0,  1, 4, 0},	/* [   ][ * ] */
	{-1,  1,-1, 1}	/* [new][old] */
};


static list_t *get_side_info(void){
	int idx;

	assert(que.element == 0);
	idx = queTbl[que.stat].pop;
	que.stat = queTbl[que.stat].down;
	que.element--;
	que.frameLength -= queBuf[idx].frameLength;
	que.SILength -= queBuf[idx].SILength;
	return &queBuf[idx];
}

static void store_side_info(III_side_info_t *si, int bitsPerFrame){
	static int bitsTbl[2][2] = {{104, 168}, {168, 288}};
	int bits;
	int idx;

	assert(que.element == 2);	/* max of que-buf is 2 */
	bits = bitsTbl[gl.version][gl.stereo - 1];
	idx = queTbl[que.stat].push;
	que.stat = queTbl[que.stat].up;
	queBuf[idx].frameLength = bitsPerFrame;
	queBuf[idx].SILength = bits;
	queBuf[idx].l3_side = *si;

	que.element++;
	que.frameLength += bitsPerFrame;
	que.SILength += bits;
}

/* WriteMainDataBits()͂̂񐔌Ă΂̂ŃCCWJ */
/* nbits != 0 ł邱ƁB */
/* static void WriteMainDataBits( unsigned val, unsigned nbits ); */
#define WriteMainDataBits(_val,_nbits)					\
{									\
	unsigned val=(_val), nbits=(_nbits);				\
	assert( ( 0 < nbits) && (nbits <= 32) );			\
	if( nbits > BitsRemaining ){					\
		write_main_data_with_side_info(val, nbits);		\
	}else{								\
		putbits( val, nbits );					\
		BitCount += nbits;					\
		BitsRemaining -= nbits;					\
	}								\
	assert( BitCount <= que.frameSize );				\
	assert( BitsRemaining >= 0 );					\
	assert( (BitCount + BitsRemaining) == que.frameSize );		\
}

#define WriteMainDataBits24(_val,_nbits)				\
{									\
	unsigned val=(_val), nbits=(_nbits);				\
	assert( ( 0 < nbits) && (nbits <= 32) );			\
	if( nbits > BitsRemaining ){					\
		write_main_data_with_side_info(val, nbits);		\
	}else{								\
		putbits24( val, nbits );				\
		BitCount += nbits;					\
		BitsRemaining -= nbits;					\
	}								\
	assert( BitCount <= que.frameSize );				\
	assert( BitsRemaining >= 0 );					\
	assert( (BitCount + BitsRemaining) == que.frameSize );		\
}

static void
encodeMainData(int l3_enc[2][2][576], III_side_info_t *si, III_scalefac_t *scalefac)
{
	int i, gr, ch, sfb, window;
	int *facl, (*facs)[3];
	int tmp;

	if (gl.version == 1) {
		/* MPEG 1 */
		for (gr = 0; gr < 2; gr++) {
			for (ch = 0; ch < gl.stereo; ch++) {
				gr_info *gi = &(si->gr[gr].ch[ch].tt);
				unsigned slen1 = slen1_tab[gi->scalefac_compress];
				unsigned slen2 = slen2_tab[gi->scalefac_compress];
				int *ix = &l3_enc[gr][ch][0];
				facl = scalefac->l[gr][ch];
				facs = scalefac->s[gr][ch];

				if (gi->block_type == SHORT_TYPE) {
					if (slen1) {
						tmp  = facs[0][0]; tmp <<= slen1;
						tmp |= facs[0][1]; tmp <<= slen1;
						tmp |= facs[0][2]; tmp <<= slen1;
						tmp |= facs[1][0]; tmp <<= slen1;
						tmp |= facs[1][1]; tmp <<= slen1;
						tmp |= facs[1][2];
						WriteMainDataBits24(tmp, slen1 * 6); // max = 4*3*2
						tmp  = facs[2][0]; tmp <<= slen1;
						tmp |= facs[2][1]; tmp <<= slen1;
						tmp |= facs[2][2]; tmp <<= slen1;
						tmp |= facs[3][0]; tmp <<= slen1;
						tmp |= facs[3][1]; tmp <<= slen1;
						tmp |= facs[3][2];
						WriteMainDataBits24(tmp, slen1 * 6); // max = 4*3*2
						tmp  = facs[4][0]; tmp <<= slen1;
						tmp |= facs[4][1]; tmp <<= slen1;
						tmp |= facs[4][2]; tmp <<= slen1;
						tmp |= facs[5][0]; tmp <<= slen1;
						tmp |= facs[5][1]; tmp <<= slen1;
						tmp |= facs[5][2];
						WriteMainDataBits24(tmp, slen1 * 6); // max = 4*3*2
					}
					if (slen2) {
						tmp  = facs[ 6][0]; tmp <<= slen2;
						tmp |= facs[ 6][1]; tmp <<= slen2;
						tmp |= facs[ 6][2]; tmp <<= slen2;
						tmp |= facs[ 7][0]; tmp <<= slen2;
						tmp |= facs[ 7][1]; tmp <<= slen2;
						tmp |= facs[ 7][2]; tmp <<= slen2;
						tmp |= facs[ 8][0]; tmp <<= slen2;
						tmp |= facs[ 8][1];
						WriteMainDataBits24(tmp, slen2 * 8); // max(slen2)=3
						tmp  = facs[ 8][2]; tmp <<= slen2;
						tmp |= facs[ 9][0]; tmp <<= slen2;
						tmp |= facs[ 9][1]; tmp <<= slen2;
						tmp |= facs[ 9][2]; tmp <<= slen2;
						tmp |= facs[10][0]; tmp <<= slen2;
						tmp |= facs[10][1]; tmp <<= slen2;
						tmp |= facs[10][2]; tmp <<= slen2;
						tmp |= facs[11][0]; tmp <<= slen2;
						tmp |= facs[11][1]; tmp <<= slen2;
						tmp |= facs[11][2];
						WriteMainDataBits(tmp, slen2 * 10); // max(slen2)=3
					}
				} else {
					if (slen1) {
						tmp = 0; /* max = 4*6 */
						for (sfb = 0; sfb < 6; sfb++) {
							tmp = facl[sfb] | (tmp<<slen1);
						}
						WriteMainDataBits24(tmp, slen1*6);
						tmp = 0; /* max = 4*5 */
						for (sfb = 6; sfb < 11; sfb++) {
							tmp = facl[sfb] | (tmp<<slen1);
						}
						WriteMainDataBits24(tmp, slen1*5);

					}
					if (slen2) {
						tmp = 0; /* max = 3*10 */
						for (sfb = 11; sfb < 21; sfb++){
							tmp = facl[sfb] | (tmp<<slen2);
						}
						WriteMainDataBits(tmp, slen2*10);
					}
				}
				Huffmancodebits(ix, gi);

			}	/* for ch */
		}		/* for gr */
	} else {
		/* MPEG 2 */
		gr = 0;
		for (ch = 0; ch < gl.stereo; ch++) {
			gr_info *gi = &(si->gr[gr].ch[ch].tt);
			int *ix = &l3_enc[gr][ch][0];
			int sfb_partition;

			facl = scalefac->l[gr][ch];
			facs = scalefac->s[gr][ch];

			if (gi->block_type == SHORT_TYPE) {
				{
					for (sfb = 0, sfb_partition = 0; sfb_partition < 4; sfb_partition++) {
						int sfbs = gi->sfbTblSub[sfb_partition] / 3;
						int slen = gi->slen[sfb_partition];
						if (slen){
							for (i = 0; i < sfbs; i++, sfb++){
								for (window = 0; window < 3; window++){
									WriteMainDataBits(facs[sfb][window], slen);
								}
							}
						}
					}
				}
			} else {
				for (sfb = 0, sfb_partition = 0; sfb_partition < 4; sfb_partition++) {
					int sfbs = gi->sfbTblSub[sfb_partition];
					int slen = gi->slen[sfb_partition];
					if (slen){
						for (i = 0; i < sfbs; i++, sfb++){
							WriteMainDataBits(facl[sfb], slen);
						}
					}
				}
			}
			Huffmancodebits(ix, gi);
		}	/* for ch */
	}
} /* end of encodeMainData */

/* 153clk -> 96clk by shigeo 00/02/07 */
/* absolute of v, w, x, y <=1 always */
static int
L3_huffman_coder_count1(struct huffcodetab *h, int *ix, int count)
{
	int huffbits, len, p;
	int ret = 0;
	while( count ){
		huffbits = len = p = 0;
		if (ix[0]) {
			if (ix[0] < 0) huffbits++;
			p = 8;
			len++;
		}
		if (ix[1]) {
			huffbits <<= 1;
			if (ix[1] < 0) huffbits++;
			p |= 4;
			len++;
		}
		if (ix[2]) {
			huffbits <<= 1;
			if (ix[2] < 0) huffbits++;
			p |= 2;
			len++;
		}
		if (ix[3]) {
			huffbits <<= 1;
			if (ix[3] < 0) huffbits++;
			p |= 1;
			len++;
		}
		huffbits += h->table[p] << len;
		/* max of len = 19 + 4 */
		len += h->hlen[p];
		if( len ) WriteMainDataBits24(huffbits, len);
		ret += len;
		ix += 4;
		count--;
	}
	return ret;
}

static void Huffmancodebits(int *ix, gr_info * gi){
	int region1Start;
	int region2Start;
	int bigvalues;
	int i, x, y, bits, stuffingBits;
	struct huffcodetab *h;
	int written = 0;
	/* defined in putbits.nas */
	extern int HuffmanCodePutBits(int table_select, int x,int y);

	/* 1: Write the bigvalues */
	bigvalues = gi->big_values * 2;
	if(bigvalues){
		if(gi->block_type == SHORT_TYPE){
			int sfb, window, line, start, end;
			I192_3 *ix_s;

			ix_s = (I192_3 *) ix;
			region1Start = 12;
			region2Start = 576;

			for (sfb = 0; sfb < 13; sfb++) {
				unsigned tableindex;
				start = scalefac_short[sfb];
				end = scalefac_short[sfb + 1];

				if (start < region1Start)
					tableindex = gi->table_select[0];
				else
					tableindex = gi->table_select[1];
				if (tableindex) {
					for (window = 0; window < 3; window++) {
						for (line = start; line < end; line += 2) {
							x = (*ix_s)[line][window];
							y = (*ix_s)[line + 1][window];
							bits = HuffmanCodePutBits(tableindex, x, y);
							written += bits;
						}
					}
				}
			}
		} else {
			/* Long blocks */
			unsigned scalefac_index;
			unsigned tableindex;

			scalefac_index = gi->region0_count + 1;
			region1Start = scalefac_long[scalefac_index];
			scalefac_index += gi->region1_count + 1;
			region2Start = scalefac_long[scalefac_index];

			if(region1Start > bigvalues) region1Start = bigvalues;
			/* get table pointer */
			tableindex = gi->table_select[0];
			if(tableindex){
				for(i = 0; i < region1Start; i += 2){
					x = ix[i];
					y = ix[i + 1];
					bits = HuffmanCodePutBits(tableindex, x, y);
					written += bits;
				}
			}
			if(region2Start > bigvalues) region2Start = bigvalues;
			/* get table pointer */
			tableindex = gi->table_select[1];
			if (tableindex) {
				for (i = region1Start; i < region2Start; i += 2) {
					/* get huffman code */
					x = ix[i];
					y = ix[i + 1];
					bits = HuffmanCodePutBits(tableindex, x, y);
					written += bits;
				}
			}
			/* get table pointer */
			tableindex = gi->table_select[2];
			if (tableindex) {
				for (i = region2Start; i < bigvalues; i += 2) {
					/* get huffman code */
					x = ix[i];
					y = ix[i + 1];
					bits = HuffmanCodePutBits(tableindex, x, y);
					written += bits;
				}
			}
		}
	}

	h = &ht[gi->count1table_select + 32];
	written += L3_huffman_coder_count1(h, &ix[bigvalues], gi->count1);

	stuffingBits = gi->part2_3_length - gi->part2_length - written;

	if(stuffingBits){
		int words = stuffingBits >> 5;
		int remain = stuffingBits & 31;

		while(words--) WriteMainDataBits(~0, 32);
		if(remain) WriteMainDataBits(~0, remain);
		written += stuffingBits;
	}
}

void InitFormatBitStream(void){
	BitCount = 0;
	que.frameSize = 0;
	BitsRemaining = 0;
	que.element = 0;
	que.frameLength = 0;
	que.SILength = 0;
	que.stat = 0;
}

void write_main_data_with_side_info(unsigned int val, unsigned int nbits){
	int gr, ch, region, window;
	list_t	*l;
	III_side_info_t	*si;
	int tmp;

	l = get_side_info();
	si = &l->l3_side;

	if(BitsRemaining){
		unsigned extra = val >> (nbits - BitsRemaining);
		nbits -= BitsRemaining;
		putbits( extra, BitsRemaining );
	}

	/* write header */
	tmp = (0xFFF<<4) | (gl.version<<3) | (1<<1) | 1;
	putbits24(tmp, 16);
	tmp = (si->rate_idx<<12) | (gl.freq_idx<<10) | (si->padding<<9) | (gl.extension<<8) | (gl.mode<<6)
		| (si->mode_ext<<4) | (0 /* copyright */<<3) | (1 /* gl.original */<<2) | (gl.emphasis);
	putbits24(tmp, 16);

	if (gl.version == 1) {
		/* MPEG1 */
		/* write frame info */
		putbits24(si->main_data_begin, 9);

		if (gl.stereo == 2) {
			putbits24(0, 3 + 8);
		} else {
			putbits24(0, 5 + 4);
		}

		/* write spectrum info */
		for (gr = 0; gr < 2; gr++) {
			for (ch = 0; ch < gl.stereo; ch++) {
				gr_info *gi = &(si->gr[gr].ch[ch].tt);

				putbits24(gi->part2_3_length, 12);
				tmp = (gi->big_values<<13) | (gi->global_gain<<5) | (gi->scalefac_compress<<1) | gi->window_switching_flag;
				putbits24(tmp, 9 + 8 + 4 + 1);
				if (gi->window_switching_flag) {
					tmp = (gi->block_type<<20) | (0<<19) | (gi->table_select[0]<<14) | (gi->table_select[1]<<9);
					putbits24(tmp,22);
				} else {
					assert(gi->block_type == 0);
					tmp = (gi->table_select[0]<<17) | (gi->table_select[1]<<12) | (gi->table_select[2]<<7) | (gi->region0_count<<3) | gi->region1_count;
					putbits24(tmp, 22);
				}

				tmp = (gi->preflag<<2) | (gi->scalefac_scale<<1) | gi->count1table_select;
				putbits24(tmp, 3);
			}
		}
	} else {
		/* MPEG2 */
		/* write frame info */
		putbits24(si->main_data_begin, 8);
		if (gl.stereo == 2) {
			putbits24(0, 2);
		} else {
			putbits24(0, 1);
		}

		/* write spectrum info */
		gr = 0;
		for (ch = 0; ch < gl.stereo; ch++) {
			gr_info *gi = &(si->gr[gr].ch[ch].tt);

			putbits24(gi->part2_3_length, 12);
			putbits24(gi->big_values, 9);
			putbits24(gi->global_gain, 8);
			putbits24(gi->scalefac_compress, 9);
			putbits24(gi->window_switching_flag, 1);

			if (gi->window_switching_flag) {
				putbits24(gi->block_type, 2);
				putbits24(0, 1);

				for (region = 0; region < 2; region++)
					putbits24(gi->table_select[region], 5);
				for (window = 0; window < 3; window++) {
					putbits24(0, 3);
				}
			} else {
				for (region = 0; region < 3; region++)
					putbits24(gi->table_select[region], 5);

				putbits24(gi->region0_count, 4);
				putbits24(gi->region1_count, 3);
			}

			putbits24(gi->scalefac_scale, 1);
			putbits24(gi->count1table_select, 1);
		}
	}
	que.frameSize = l->frameLength;
	BitCount = l->SILength;
	BitsRemaining = que.frameSize - BitCount;

	if( nbits ){
		putbits( val, nbits );
		BitCount += nbits;
		BitsRemaining -= nbits;
	}
}

void III_format_bitstream(int bitsPerFrame, int l3_enc[2][2][576], III_side_info_t *l3_side, III_scalefac_t *scalefac){
	store_side_info(l3_side, bitsPerFrame);

	encodeMainData(l3_enc, l3_side, scalefac);

	if(l3_side->resvDrain){
		int words, remain;
		words = l3_side->resvDrain >> 5;
		remain = l3_side->resvDrain & 31;
		while(words--) WriteMainDataBits(0, 32);
		if(remain) WriteMainDataBits(0, remain);
	}

	l3_side->main_data_begin = ((BitsRemaining & -8) + (que.frameLength & -8) - (que.SILength & -8)) >> 3;
}

void III_FlushBitstream(void){
	if(que.element){
		int remain = que.frameLength - que.SILength;
		int words = remain >> 5;

		while(words--) WriteMainDataBits(0, 32);

		remain &= 31;
		if(remain) WriteMainDataBits(0, remain);
	}

	BitCount = 0;
	que.frameSize = 0;
	BitsRemaining = 0;
}
#endif /* USE_VBR */

