/*
 * Decompiled with CFR 0.152.
 */
package org.openpreservation.jhove.qa;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;
import org.openpreservation.jhove.qa.ControllerState;
import org.openpreservation.jhove.qa.LogWriter;
import org.openpreservation.jhove.qa.cli.CLI;
import org.openpreservation.jhove.qa.comparator.Comparator;
import org.openpreservation.jhove.qa.comparator.XmlOutputElement;
import org.openpreservation.jhove.qa.comparator.XmlUnitComparator;

public final class Controller {
    private final CLI cli = new CLI();
    private ControllerState state = ControllerState.OK;
    private Comparator comparator;
    private LogWriter log = new LogWriter();
    private String[] inputArgs;

    public Controller() {
        this(new XmlOutputElement[0]);
    }

    public Controller(XmlOutputElement ... ignoredElements) {
        this.ignoreElements(ignoredElements);
    }

    public String[] getInputArgs() {
        return this.inputArgs;
    }

    public void setInputArgs(String ... args) {
        this.inputArgs = args;
    }

    public ControllerState getState() {
        return this.state;
    }

    public void ignoreElements(XmlOutputElement ... ignoredElements) {
        this.comparator = new XmlUnitComparator(ignoredElements);
    }

    public void run() {
        if (!this.isValidInput()) {
            this.printHelp();
            return;
        }
        File bf = new File(this.cli.getBaselineFolderPath());
        File cf = new File(this.cli.getCandidateFolderPath());
        this.traverseFolders(bf, cf);
        this.log.flush(this.cli.getKey());
    }

    private boolean isValidInput() {
        if (this.inputArgs == null) {
            this.assignState(ControllerState.SYSTEM_ERROR);
            return false;
        }
        try {
            this.cli.parse(this.inputArgs);
        }
        catch (ParseException e) {
            if (e.getMessage().equals("HELP")) {
                this.assignState(ControllerState.OK);
            } else {
                this.assignState(ControllerState.SYSTEM_ERROR);
            }
            return false;
        }
        this.ignoreElements(this.cli.getIgnoredElements());
        boolean valid = true;
        File sourceFolder = new File(this.cli.getBaselineFolderPath());
        File candidateFolder = new File(this.cli.getCandidateFolderPath());
        File[] sourceFiles = sourceFolder.listFiles(new JhoveFileFilter());
        File[] candidateFiles = candidateFolder.listFiles(new JhoveFileFilter());
        if (sourceFiles == null || sourceFiles.length == 0 || candidateFiles == null || candidateFiles.length == 0) {
            valid = false;
            this.assignState(ControllerState.TEST_NOT_EXECUTABLE);
        }
        return valid;
    }

    private void assignState(ControllerState newState) {
        this.state = newState == ControllerState.SYSTEM_ERROR ? newState : (newState == ControllerState.OK ? (this.state == ControllerState.OK ? newState : this.state) : (this.state == ControllerState.OK || this.state == newState ? newState : ControllerState.MULTIPLE_PROBLEMS));
    }

    private void traverseFolders(File baselineFolder, File candidateFolder) {
        ArrayList<File> baselineFiles = new ArrayList<File>(Arrays.asList(baselineFolder.listFiles()));
        ArrayList<File> candidateFiles = new ArrayList<File>(Arrays.asList(candidateFolder.listFiles()));
        Iterator iter = baselineFiles.iterator();
        this.log.submitLog("Comparing folders:" + baselineFolder.getPath());
        while (iter.hasNext()) {
            File bf = (File)iter.next();
            File cf = new File(candidateFolder, bf.getName());
            if (bf.isDirectory() && cf.isDirectory()) {
                this.traverseFolders(bf, cf);
            } else if (candidateFiles.contains(cf)) {
                this.log.submitLog("Testing file:" + bf.getName());
                ControllerState comparisonState = this.comparator.compare(bf, cf);
                this.assignState(comparisonState);
                this.log.submitLog(this.comparator.getMessage());
                candidateFiles.remove(cf);
            } else if (!Controller.isSystemFile(cf.getName())) {
                this.log.submitLog("Missing candidate file:" + cf.getName());
                this.assignState(ControllerState.FILE_MISSING_CANDIDATE);
            }
            iter.remove();
        }
        if (candidateFiles.size() > 0) {
            for (File f : candidateFiles) {
                if (Controller.isSystemFile(f.getName()) || f.isDirectory()) continue;
                this.log.submitLog("Missing baseline file:" + f.getName());
                this.assignState(ControllerState.FILE_MISSING_BASELINE);
            }
        }
    }

    private void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("jhvtest", this.cli.getOptions());
    }

    private static boolean isSystemFile(String name) {
        boolean systemFile = false;
        if (name.startsWith(".DS_Store")) {
            systemFile = true;
        }
        return systemFile;
    }

    private class JhoveFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jhove.xml");
        }
    }
}

