/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;

public class CommentsChunk
extends Chunk {
    public CommentsChunk(AiffModule aiffModule, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(aiffModule, chunkHeader, dataInputStream);
    }

    @Override
    public boolean readChunk(RepInfo repInfo) throws IOException {
        AiffModule aiffModule = (AiffModule)this._module;
        int n = aiffModule.readUnsignedShort(this._dstream);
        this.bytesLeft -= 2L;
        if (n == 0) {
            return true;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>(n);
        for (int i = 0; i < n; ++i) {
            long l = aiffModule.readUnsignedInt(this._dstream);
            Date date = aiffModule.timestampToDate(l);
            int n2 = aiffModule.readSignedShort(this._dstream);
            int n3 = aiffModule.readUnsignedShort(this._dstream);
            this.bytesLeft -= 8L;
            byte[] byArray = new byte[n3];
            ModuleBase.readByteBuf(this._dstream, byArray, aiffModule);
            this.bytesLeft -= (long)n3;
            for (int j = 0; j < byArray.length; ++j) {
                if (byArray[j] >= 32 && byArray[j] <= 127) continue;
                byArray[j] = 32;
            }
            String string = new String(byArray, "ASCII");
            Property[] propertyArray = new Property[]{new Property("Timestamp", PropertyType.DATE, date), new Property("CommentText", PropertyType.STRING, string)};
            arrayList.add(new Property("Comment", PropertyType.PROPERTY, PropertyArity.ARRAY, propertyArray));
        }
        aiffModule.addAiffProperty(new Property("Comments", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        return true;
    }
}

