/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_Processor.h"

CMPIObjectPath* CPU_OpenDRIM_Processor_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_Processor& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_Processor_classnames[0], OpenDRIM_Processor_NAMESPACE);

	if (!instance.SystemCreationClassName_isNULL)
		op.addKey("SystemCreationClassName", instance.SystemCreationClassName);

	if (!instance.SystemName_isNULL)
		op.addKey("SystemName", instance.SystemName);

	if (!instance.CreationClassName_isNULL)
		op.addKey("CreationClassName", instance.CreationClassName);

	if (!instance.DeviceID_isNULL)
		op.addKey("DeviceID", instance.DeviceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* CPU_OpenDRIM_Processor_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_Processor& instance) {
	_E_;
	Objectpath op(broker, CPU_OpenDRIM_Processor_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.InstallDate_isNULL)
		ci.setPropertyDatetime("InstallDate", instance.InstallDate);

	if (!instance.Name_isNULL)
		ci.setProperty("Name", instance.Name);

	if (!instance.OperationalStatus_isNULL)
		ci.setProperty("OperationalStatus", instance.OperationalStatus);

	if (!instance.StatusDescriptions_isNULL)
		ci.setProperty("StatusDescriptions", instance.StatusDescriptions);

	if (!instance.Status_isNULL)
		ci.setProperty("Status", instance.Status);

	if (!instance.HealthState_isNULL)
		ci.setProperty("HealthState", instance.HealthState);

	if (!instance.PrimaryStatus_isNULL)
		ci.setProperty("PrimaryStatus", instance.PrimaryStatus);

	if (!instance.DetailedStatus_isNULL)
		ci.setProperty("DetailedStatus", instance.DetailedStatus);

	if (!instance.OperatingStatus_isNULL)
		ci.setProperty("OperatingStatus", instance.OperatingStatus);

	if (!instance.CommunicationStatus_isNULL)
		ci.setProperty("CommunicationStatus", instance.CommunicationStatus);

	if (!instance.EnabledState_isNULL)
		ci.setProperty("EnabledState", instance.EnabledState);

	if (!instance.OtherEnabledState_isNULL)
		ci.setProperty("OtherEnabledState", instance.OtherEnabledState);

	if (!instance.RequestedState_isNULL)
		ci.setProperty("RequestedState", instance.RequestedState);

	if (!instance.EnabledDefault_isNULL)
		ci.setProperty("EnabledDefault", instance.EnabledDefault);

	if (!instance.TimeOfLastStateChange_isNULL)
		ci.setPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange);

	if (!instance.AvailableRequestedStates_isNULL)
		ci.setProperty("AvailableRequestedStates", instance.AvailableRequestedStates);

	if (!instance.TransitioningToState_isNULL)
		ci.setProperty("TransitioningToState", instance.TransitioningToState);

	if (!instance.PowerManagementSupported_isNULL)
		ci.setProperty("PowerManagementSupported", instance.PowerManagementSupported);

	if (!instance.PowerManagementCapabilities_isNULL)
		ci.setProperty("PowerManagementCapabilities", instance.PowerManagementCapabilities);

	if (!instance.Availability_isNULL)
		ci.setProperty("Availability", instance.Availability);

	if (!instance.StatusInfo_isNULL)
		ci.setProperty("StatusInfo", instance.StatusInfo);

	if (!instance.LastErrorCode_isNULL)
		ci.setProperty("LastErrorCode", instance.LastErrorCode);

	if (!instance.ErrorDescription_isNULL)
		ci.setProperty("ErrorDescription", instance.ErrorDescription);

	if (!instance.ErrorCleared_isNULL)
		ci.setProperty("ErrorCleared", instance.ErrorCleared);

	if (!instance.OtherIdentifyingInfo_isNULL)
		ci.setProperty("OtherIdentifyingInfo", instance.OtherIdentifyingInfo);

	if (!instance.PowerOnHours_isNULL)
		ci.setProperty("PowerOnHours", instance.PowerOnHours);

	if (!instance.TotalPowerOnHours_isNULL)
		ci.setProperty("TotalPowerOnHours", instance.TotalPowerOnHours);

	if (!instance.IdentifyingDescriptions_isNULL)
		ci.setProperty("IdentifyingDescriptions", instance.IdentifyingDescriptions);

	if (!instance.AdditionalAvailability_isNULL)
		ci.setProperty("AdditionalAvailability", instance.AdditionalAvailability);

	if (!instance.MaxQuiesceTime_isNULL)
		ci.setProperty("MaxQuiesceTime", instance.MaxQuiesceTime);

	if (!instance.LocationIndicator_isNULL)
		ci.setProperty("LocationIndicator", instance.LocationIndicator);

	if (!instance.Role_isNULL)
		ci.setProperty("Role", instance.Role);

	if (!instance.Family_isNULL)
		ci.setProperty("Family", instance.Family);

	if (!instance.OtherFamilyDescription_isNULL)
		ci.setProperty("OtherFamilyDescription", instance.OtherFamilyDescription);

	if (!instance.UpgradeMethod_isNULL)
		ci.setProperty("UpgradeMethod", instance.UpgradeMethod);

	if (!instance.MaxClockSpeed_isNULL)
		ci.setProperty("MaxClockSpeed", instance.MaxClockSpeed);

	if (!instance.CurrentClockSpeed_isNULL)
		ci.setProperty("CurrentClockSpeed", instance.CurrentClockSpeed);

	if (!instance.DataWidth_isNULL)
		ci.setProperty("DataWidth", instance.DataWidth);

	if (!instance.AddressWidth_isNULL)
		ci.setProperty("AddressWidth", instance.AddressWidth);

	if (!instance.LoadPercentage_isNULL)
		ci.setProperty("LoadPercentage", instance.LoadPercentage);

	if (!instance.Stepping_isNULL)
		ci.setProperty("Stepping", instance.Stepping);

	if (!instance.UniqueID_isNULL)
		ci.setProperty("UniqueID", instance.UniqueID);

	if (!instance.CPUStatus_isNULL)
		ci.setProperty("CPUStatus", instance.CPUStatus);

	if (!instance.ExternalBusClockSpeed_isNULL)
		ci.setProperty("ExternalBusClockSpeed", instance.ExternalBusClockSpeed);

	if (!instance.Characteristics_isNULL)
		ci.setProperty("Characteristics", instance.Characteristics);

	if (!instance.NumberOfEnabledCores_isNULL)
		ci.setProperty("NumberOfEnabledCores", instance.NumberOfEnabledCores);

	_L_;
	return ci.getHdl();
}

void CPU_OpenDRIM_Processor_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_Processor& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("DeviceID", instance.DeviceID) == OK)
		instance.DeviceID_isNULL = false;

	if (op.getKey("SystemCreationClassName", instance.SystemCreationClassName) == OK)
		instance.SystemCreationClassName_isNULL = false;

	if (op.getKey("SystemName", instance.SystemName) == OK)
		instance.SystemName_isNULL = false;

	if (op.getKey("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	_L_;
}

void CPU_OpenDRIM_Processor_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_Processor& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getPropertyDatetime("InstallDate", instance.InstallDate) == OK)
		instance.InstallDate_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("OperationalStatus", instance.OperationalStatus) == OK)
		instance.OperationalStatus_isNULL = false;

	if (inst.getProperty("StatusDescriptions", instance.StatusDescriptions) == OK)
		instance.StatusDescriptions_isNULL = false;

	if (inst.getProperty("Status", instance.Status) == OK)
		instance.Status_isNULL = false;

	if (inst.getProperty("HealthState", instance.HealthState) == OK)
		instance.HealthState_isNULL = false;

	if (inst.getProperty("PrimaryStatus", instance.PrimaryStatus) == OK)
		instance.PrimaryStatus_isNULL = false;

	if (inst.getProperty("DetailedStatus", instance.DetailedStatus) == OK)
		instance.DetailedStatus_isNULL = false;

	if (inst.getProperty("OperatingStatus", instance.OperatingStatus) == OK)
		instance.OperatingStatus_isNULL = false;

	if (inst.getProperty("CommunicationStatus", instance.CommunicationStatus) == OK)
		instance.CommunicationStatus_isNULL = false;

	if (inst.getProperty("EnabledState", instance.EnabledState) == OK)
		instance.EnabledState_isNULL = false;

	if (inst.getProperty("OtherEnabledState", instance.OtherEnabledState) == OK)
		instance.OtherEnabledState_isNULL = false;

	if (inst.getProperty("RequestedState", instance.RequestedState) == OK)
		instance.RequestedState_isNULL = false;

	if (inst.getProperty("EnabledDefault", instance.EnabledDefault) == OK)
		instance.EnabledDefault_isNULL = false;

	if (inst.getPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange) == OK)
		instance.TimeOfLastStateChange_isNULL = false;

	if (inst.getProperty("AvailableRequestedStates", instance.AvailableRequestedStates) == OK)
		instance.AvailableRequestedStates_isNULL = false;

	if (inst.getProperty("TransitioningToState", instance.TransitioningToState) == OK)
		instance.TransitioningToState_isNULL = false;

	if (inst.getProperty("SystemCreationClassName", instance.SystemCreationClassName) == OK)
		instance.SystemCreationClassName_isNULL = false;

	if (inst.getProperty("SystemName", instance.SystemName) == OK)
		instance.SystemName_isNULL = false;

	if (inst.getProperty("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	if (inst.getProperty("DeviceID", instance.DeviceID) == OK)
		instance.DeviceID_isNULL = false;

	if (inst.getProperty("PowerManagementSupported", instance.PowerManagementSupported) == OK)
		instance.PowerManagementSupported_isNULL = false;

	if (inst.getProperty("PowerManagementCapabilities", instance.PowerManagementCapabilities) == OK)
		instance.PowerManagementCapabilities_isNULL = false;

	if (inst.getProperty("Availability", instance.Availability) == OK)
		instance.Availability_isNULL = false;

	if (inst.getProperty("StatusInfo", instance.StatusInfo) == OK)
		instance.StatusInfo_isNULL = false;

	if (inst.getProperty("LastErrorCode", instance.LastErrorCode) == OK)
		instance.LastErrorCode_isNULL = false;

	if (inst.getProperty("ErrorDescription", instance.ErrorDescription) == OK)
		instance.ErrorDescription_isNULL = false;

	if (inst.getProperty("ErrorCleared", instance.ErrorCleared) == OK)
		instance.ErrorCleared_isNULL = false;

	if (inst.getProperty("OtherIdentifyingInfo", instance.OtherIdentifyingInfo) == OK)
		instance.OtherIdentifyingInfo_isNULL = false;

	if (inst.getProperty("PowerOnHours", instance.PowerOnHours) == OK)
		instance.PowerOnHours_isNULL = false;

	if (inst.getProperty("TotalPowerOnHours", instance.TotalPowerOnHours) == OK)
		instance.TotalPowerOnHours_isNULL = false;

	if (inst.getProperty("IdentifyingDescriptions", instance.IdentifyingDescriptions) == OK)
		instance.IdentifyingDescriptions_isNULL = false;

	if (inst.getProperty("AdditionalAvailability", instance.AdditionalAvailability) == OK)
		instance.AdditionalAvailability_isNULL = false;

	if (inst.getProperty("MaxQuiesceTime", instance.MaxQuiesceTime) == OK)
		instance.MaxQuiesceTime_isNULL = false;

	if (inst.getProperty("LocationIndicator", instance.LocationIndicator) == OK)
		instance.LocationIndicator_isNULL = false;

	if (inst.getProperty("Role", instance.Role) == OK)
		instance.Role_isNULL = false;

	if (inst.getProperty("Family", instance.Family) == OK)
		instance.Family_isNULL = false;

	if (inst.getProperty("OtherFamilyDescription", instance.OtherFamilyDescription) == OK)
		instance.OtherFamilyDescription_isNULL = false;

	if (inst.getProperty("UpgradeMethod", instance.UpgradeMethod) == OK)
		instance.UpgradeMethod_isNULL = false;

	if (inst.getProperty("MaxClockSpeed", instance.MaxClockSpeed) == OK)
		instance.MaxClockSpeed_isNULL = false;

	if (inst.getProperty("CurrentClockSpeed", instance.CurrentClockSpeed) == OK)
		instance.CurrentClockSpeed_isNULL = false;

	if (inst.getProperty("DataWidth", instance.DataWidth) == OK)
		instance.DataWidth_isNULL = false;

	if (inst.getProperty("AddressWidth", instance.AddressWidth) == OK)
		instance.AddressWidth_isNULL = false;

	if (inst.getProperty("LoadPercentage", instance.LoadPercentage) == OK)
		instance.LoadPercentage_isNULL = false;

	if (inst.getProperty("Stepping", instance.Stepping) == OK)
		instance.Stepping_isNULL = false;

	if (inst.getProperty("UniqueID", instance.UniqueID) == OK)
		instance.UniqueID_isNULL = false;

	if (inst.getProperty("CPUStatus", instance.CPUStatus) == OK)
		instance.CPUStatus_isNULL = false;

	if (inst.getProperty("ExternalBusClockSpeed", instance.ExternalBusClockSpeed) == OK)
		instance.ExternalBusClockSpeed_isNULL = false;

	if (inst.getProperty("Characteristics", instance.Characteristics) == OK)
		instance.Characteristics_isNULL = false;

	if (inst.getProperty("NumberOfEnabledCores", instance.NumberOfEnabledCores) == OK)
		instance.NumberOfEnabledCores_isNULL = false;

	_L_;
}

void CPU_OpenDRIM_Processor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Processor_RequestStateChange_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	unsigned short RequestedState;
	data = in->ft->getArg(in, "RequestedState", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, RequestedState);	
		args.setRequestedState(RequestedState);
	}			

	Objectpath Job;
	data = in->ft->getArg(in, "Job", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Job);	
		args.setJob(Job);
	}			

	string TimeoutPeriod;
	data = in->ft->getArg(in, "TimeoutPeriod", &rc);
	if (rc.rc == OK) {
		CT_ToCDatetime(data, TimeoutPeriod);	
		args.setTimeoutPeriod(TimeoutPeriod);
	}			

	_L_;
}

void CPU_OpenDRIM_Processor_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_Processor_RequestStateChange_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	Objectpath Job;
	errorMessage = args.getJob(Job);
	if (errorMessage == OK) {
		value = CT_toCMPI(Job);
		out->ft->addArg(out, "Job", &value, CMPI_ref);
	}

	_L_;
}
void CPU_OpenDRIM_Processor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Processor_SetPowerState_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	unsigned short PowerState;
	data = in->ft->getArg(in, "PowerState", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, PowerState);	
		args.setPowerState(PowerState);
	}			

	string Time;
	data = in->ft->getArg(in, "Time", &rc);
	if (rc.rc == OK) {
		CT_ToCDatetime(data, Time);	
		args.setTime(Time);
	}			

	_L_;
}

void CPU_OpenDRIM_Processor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Processor_EnableDevice_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	bool Enabled;
	data = in->ft->getArg(in, "Enabled", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, Enabled);	
		args.setEnabled(Enabled);
	}			

	_L_;
}

void CPU_OpenDRIM_Processor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Processor_OnlineDevice_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	bool Online;
	data = in->ft->getArg(in, "Online", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, Online);	
		args.setOnline(Online);
	}			

	_L_;
}

void CPU_OpenDRIM_Processor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Processor_QuiesceDevice_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	bool Quiesce;
	data = in->ft->getArg(in, "Quiesce", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, Quiesce);	
		args.setQuiesce(Quiesce);
	}			

	_L_;
}

