/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_PROCESSORCOREHARDWARETHREADACCESS_H_
#define OPENDRIM_PROCESSORCOREHARDWARETHREADACCESS_H_

#include "CPU_Common.h"

#include "OpenDRIM_ProcessorCoreHardwareThread.h"
#include "assocOpenDRIM_ProcessorCoreHardwareThread.h"

int CPU_OpenDRIM_ProcessorCoreHardwareThread_load(const CMPIBroker* broker, string& errorMessage);

int CPU_OpenDRIM_ProcessorCoreHardwareThread_unload(string& errorMessage);

int CPU_OpenDRIM_ProcessorCoreHardwareThread_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ProcessorCoreHardwareThread>& instances, const char** properties, string& errorMessage, const string& discriminant);

int CPU_OpenDRIM_ProcessorCoreHardwareThread_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ProcessorCoreHardwareThread& instance, const char** properties, string& errorMessage);

int CPU_OpenDRIM_ProcessorCoreHardwareThread_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorCoreHardwareThread& newInstance, const OpenDRIM_ProcessorCoreHardwareThread& oldInstance, const char** properties, string& errorMessage);

int CPU_OpenDRIM_ProcessorCoreHardwareThread_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorCoreHardwareThread& instance, string& errorMessage);

int CPU_OpenDRIM_ProcessorCoreHardwareThread_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorCoreHardwareThread& instance, string& errorMessage);

int CPU_OpenDRIM_ProcessorCoreHardwareThread_associatorPartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const char** properties, vector<Instance>& GroupComponent_associatedInstances, string& errorMessage, const string& discriminant);

int CPU_OpenDRIM_ProcessorCoreHardwareThread_associatorGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const char** properties, vector<Instance>& PartComponent_associatedInstances, string& errorMessage, const string& discriminant);

int CPU_OpenDRIM_ProcessorCoreHardwareThread_referencePartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const vector<Instance>& GroupComponent_instances, vector<OpenDRIM_ProcessorCoreHardwareThread>& OpenDRIM_ProcessorCoreHardwareThread_instances, const char** properties, string& errorMessage, const string& discriminant);

int CPU_OpenDRIM_ProcessorCoreHardwareThread_referenceGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const vector<Instance>& PartComponent_instances, vector<OpenDRIM_ProcessorCoreHardwareThread>& OpenDRIM_ProcessorCoreHardwareThread_instances, const char** properties, string& errorMessage, const string& discriminant);

int CPU_OpenDRIM_ProcessorCoreHardwareThread_populate(OpenDRIM_ProcessorCoreHardwareThread& instance, string& errorMessage);

#endif /*OPENDRIM_PROCESSORCOREHARDWARETHREADACCESS_H_*/
