/*###############################################################################
# Linux Management Providers (LMP), DNS provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_DNSSettingDataAccess.h"

int DNS_OpenDRIM_DNSSettingData_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSSettingData_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSSettingData_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_DNSSettingData>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	const string filepath1("/etc/network/interfaces");
	ifstream ifs1(filepath1.c_str(), ifstream::in);
	
	if (!ifs1.is_open())
	{
		errorMessage = "Failed to open /etc/resolv.conf";
		return FAILED;
	}
	
	string line;
	while (getline(ifs1, line))
	{
		if (CF_startsWith(line, "iface"))
		{
			string ethname;
			ethname=line.substr(line.find_first_of(" ")+1);
			ethname=ethname.substr(0,ethname.find_first_of(" "));
			
			if(ethname!="lo")
			{
				OpenDRIM_DNSSettingData instance;
				instance.setInstanceID(ethname);
				
				if(discriminant=="ei")
					CF_assert(DNS_OpenDRIM_DNSSettingData_populate(instance,errorMessage));
				
				result.push_back(instance);
			}
		}
	}
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSSettingData_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_DNSSettingData& instance, const char** properties, string& errorMessage) {
	_E_;
	const string filepath1("/etc/network/interfaces");
	ifstream ifs1(filepath1.c_str(), ifstream::in);
	
	if (!ifs1.is_open())
	{
		errorMessage = "Failed to open /etc/resolv.conf";
		return FAILED;
	}
	
	string line;
	while (getline(ifs1, line))
	{
		if (CF_startsWith(line, "iface"))
		{
			string ethname;
			ethname=line.substr(line.find_first_of(" ")+1);
			ethname=ethname.substr(0,ethname.find_first_of(" "));
			
			if(ethname!="lo")
			{
				if(instance.InstanceID==ethname)
				{
					CF_assert(DNS_OpenDRIM_DNSSettingData_populate(instance,errorMessage));
					return OK;
				}
			}
		}
	}
	errorMessage = "Invalid path";
	return NOT_FOUND;
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSSettingData_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSSettingData& newInstance, const OpenDRIM_DNSSettingData& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_DNSSettingData_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSSettingData& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_DNSSettingData_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSSettingData& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_DNSSettingData_populate(OpenDRIM_DNSSettingData& instance, string& errorMessage) {
	_E_;
	vector<string> nameservers;
	const string filepath("/etc/resolv.conf");
	ifstream ifs(filepath.c_str(), ifstream::in);
	
	if (!ifs.is_open())
	{
		errorMessage = "Failed to open /etc/resolv.conf";
		return FAILED;
	}
	
	string line;
	while (getline(ifs, line))
	{
		if (CF_startsWith(line, "nameserver"))
		{
			string nameserver = line.substr(line.find_first_of(" ")+1);
			nameservers.push_back(nameserver);
		}
	}
	
	string hostname;
	CF_assert(CF_getSystemName(hostname, errorMessage));
	instance.setAddressOrigin(2);
	instance.setDNSServerAddresses(nameservers);
	instance.setElementName(instance.InstanceID+" DNS Setting");
	instance.setRequestedHostname(hostname);
	_L_;
	return OK;
}

