#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 VA
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Hacknet
# send your bug reports to contact@dotslashplay.it
###

script_version=20221210.2

GAME_ID='hacknet'
GAME_NAME='Hacknet'

ARCHIVE_BASE_0='hacknet_en_5_069_15083.sh'
ARCHIVE_BASE_0_MD5='305d230cad47d696e4141320189cd4bc'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='350000'
ARCHIVE_BASE_0_VERSION='5.069-gog15083'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/hacknet'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN32_FILES='
*.bin.x86'
CONTENT_GAME_BIN64_FILES='
*.bin.x86_64'
CONTENT_LIBS_BIN32_PATH="${CONTENT_PATH_DEFAULT}/lib"
CONTENT_LIBS_BIN32_FILES='
libcef.so
libCSteamworks.so
libjpeg.so.62
libmojoshader.so
libmono-2.0.so.1
libogg.so.0
libopenal.so.1
libpng15.so.15
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0
libsteam_api.so
libtheoradec.so.1
libtheoraplay.so
libvorbisfile.so.3
libvorbis.so.0
libXNAWebRenderer.so'
CONTENT_LIBS_BIN64_PATH="${CONTENT_PATH_DEFAULT}/lib64"
CONTENT_LIBS_BIN64_FILES='
libcef.so
libCSteamworks.so
libjpeg.so.62
libmojoshader.so
libmono-2.0.so.1
libogg.so.0
libopenal.so.1
libpng15.so.15
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0
libsteam_api.so
libtheoradec.so.1
libtheoraplay.so
libvorbisfile.so.3
libvorbis.so.0
libXNAWebRenderer.so'
CONTENT_GAME_DATA_FILES='
Content
locales
Extensions
mono
Hacknet.exe
Hacknet.bmp
icudtl.dat
natives_blob.bin
snapshot_blob.bin
FNA.dll.config
*.dll
*.pak'

APP_MAIN_EXE_BIN32='Hacknet.bin.x86'
APP_MAIN_EXE_BIN64='Hacknet.bin.x86_64'
APP_MAIN_ICON='../support/icon.png'

USER_PERSISTENT_DIRECTORIES='
Content/People'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID"
PKG_BIN32_DEPENDENCIES_LIBRARIES='
ld-linux.so.2
ld-linux-x86-64.so.2
libasound.so.2
libatk-1.0.so.0
libcairo.so.2
libc.so.6
libcups.so.2
libdbus-1.so.3
libdl.so.2
libexpat.so.1
libfontconfig.so.1
libfreetype.so.6
libgcc_s.so.1
libgconf-2.so.4
libglib-2.0.so.0
libgmodule-2.0.so.0
libgobject-2.0.so.0
libm.so.6
libnspr4.so
libnss3.so
libnssutil3.so
libpango-1.0.so.0
libpangocairo-1.0.so.0
libpthread.so.0
librt.so.1
libsmime3.so
libstdc++.so.6
libX11.so.6
libXcomposite.so.1
libXcursor.so.1
libXdamage.so.1
libXext.so.6
libXfixes.so.3
libXi.so.6
libXrandr.so.2
libXrender.so.1
libXss.so.1
libXtst.so.6
libz.so.1'

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN32_DEPENDENCIES_LIBRARIES"

# Apply common tweaks for Mono games

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
## Work around terminfo Mono bug,
## cf. https://github.com/mono/mono/issues/6752
export TERM="${TERM%-256color}"
## Work around Mono unpredictable behaviour with non-US locales
export LANG=C'

# Load common functions

target_version='2.19'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Ensure that Chromium Embedded Framework is functional
	chmod 755 'cefprocess.bin.x86' 'cefprocess.bin.x86_64'
)

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write
done

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
