#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Mopi
# SPDX-FileCopyrightText: © 2021 Anna Lea
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Among the Sleep
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220209.5

# Set game-specific variables

GAME_ID='among-the-sleep'
GAME_NAME='Among the Sleep'

ARCHIVE_BASE_GOG_0='among_the_sleep_en_3_0_1_16406.sh'
ARCHIVE_BASE_GOG_0_MD5='de6e5fc26d7d5954782a6e98966f34cf'
ARCHIVE_BASE_GOG_0_TYPE='mojosetup'
ARCHIVE_BASE_GOG_0_SIZE='3800000'
ARCHIVE_BASE_GOG_0_VERSION='3.0.1-gog16406'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/among_the_sleep'

ARCHIVE_BASE_HUMBLE_0='Among_the_Sleep_Linux.zip'
ARCHIVE_BASE_HUMBLE_0_MD5='0d7296eb48bfebeb9a37827ee94bd34c'
ARCHIVE_BASE_HUMBLE_0_SIZE='2900000'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.0-humble1'
ARCHIVE_BASE_HUMBLE_0_URL='https://www.humblebundle.com/store/among-the-sleep'

UNITY3D_NAME='Among the Sleep'

CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_HUMBLE='.'
ARCHIVE_GAME_BIN32_FILES='
Among?the?Sleep.x86
Among?the?Sleep_Data/Mono/x86
Among?the?Sleep_Data/Plugins/x86'
ARCHIVE_GAME_BIN64_FILES='
Among?the?Sleep.x86_64
Among?the?Sleep_Data/Mono/x86_64
Among?the?Sleep_Data/Plugins/x86_64'
ARCHIVE_GAME_DATA_FILES='
Among?the?Sleep_Data'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 libGL.so.1 libX11.so.6 libz.so.1 libgdk-x11-2.0.so.0 libgdk_pixbuf-2.0.so.0 libglib-2.0.so.0 libgobject-2.0.so.0 xcursor libxrandr"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"

# Enforce a consistent Unity3D name

(
	content_path=$(content_path_default)
	unity3d_name=$(unity3d_name)
	alt_name='Among The Sleep'
	cd "${PLAYIT_WORKDIR}/gamedata/${content_path}"
	if [ -e "${alt_name}.x86" ]; then
		mv "${alt_name}.x86" "${unity3d_name}.x86"
	fi
	if [ -e "${alt_name}.x86_64" ]; then
		mv "${alt_name}.x86_64" "${unity3d_name}.x86_64"
	fi
	if [ -e "${alt_name}_Data" ]; then
		mv "${alt_name}_Data" "${unity3d_name}_Data"
	fi
)

# Include game data

prepare_package_layout

# Delete up temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write 'APP_MAIN'
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
