# Marxists and Spanish Anarchism

In this appendix of our FAQ we discuss and reply to various analyses of
Spanish anarchism put forward by Marxists, particularly Marxist-Leninists of
various shades. The history and politics of Spanish Anarchism is not well
known in many circles, particularly Marxist ones, and the various
misrepresentations and distortions that Marxists have spread about that
history and politics are many. This appendix is an attempt to put the record
straight with regards the Spanish Anarchist movement and point out the errors
associated with the standard Marxist accounts of that movement, its politics
and its history.

Hopefully this appendix will go some way towards making Marxists (and others)
investigate the actual facts of anarchism and Spanish anarchist history rather
than depending on inaccurate secondary material (usually written by their
comrades).

Part of this essay is based on the article _"Trotskyist Lies on Anarchism"_
which appeared in **Black Flag** issue no. 211 and Tom Wetzel's article
**Workers' Power and the Spanish Revolution**.

## 1\. Were the Spanish Anarchists _"Primitive Rebels"_?

The thesis that the Spanish Anarchists were _"primitive rebels,"_ with a
primitive understanding of the nature of revolution is a common one amongst
Marxists. One of the main sources for this kind of argument is Eric Hobsbawm's
**Primitive Rebels**, who was a member of the British Communist Party at the
time. While the obvious Stalinist nature of the author may be thought enough
to alert the intelligent of its political biases, its basic thesis is repeated
by many Marxists.

Before discussing Hobsbawm in more detail, it would be useful to refute some
of the more silly things so-called serious historians have asserted about
Spanish Anarchism. Indeed, it would be hard to find another social or
political movement which has been more misrepresented or its ideas and
activities so distorted by historians whose attitudes seem more supported by
ideological conviction rather than history or investigation of social life.

One of the most common descriptions of Spanish anarchism is that it was
_"religious"_ or _"millenarium"_ in nature. Hobsbawm himself accepts this
conceptualisation, along with historians and commentators like Gerald Brenan
and Franz Brokenau (who, in fact, did state _"Anarchism **is** a religious
movement"_). Such use of religion was largely due to the influence of Juan
Diaz del Moral, a lawyer and historian who was also a landowner. As Jerome R.
Mintz points out, _"according to Diaz del Moral, the moral and passionate
obreros conscientes [conscious workers -- i.e. workers who considered
themselves to be anarchists] absorbed in their pamphlets and newspapers were
akin to frenzied believers in a new religion."_ [**The Anarchists of Casas
Viejas**, p. 5f] However, such a perspective was formed by his class position
and privileges which could not help but reflect them:

> _"Diaz del Moral ascribed to the campesinos [of Andalusia] racial and
cultural stereotypes that were common saws of his class. The sole cause for
the waves of rural unrest, Diaz del Moral asserted, could be found in the
psychology of the campesinos . . . He believed that the Andalusian field
workers had inherited a Moorish tendency toward ecstasy and millenarianism
that accounted for their attraction to anarchist teaching. Diaz del Moral was
mystified by expressions of animosity directed toward him, but the workers
considered him to be a senorito, a landowner who does not labour . . .
Although he was both scholarly and sympathetic, Diaz del Moral could not
comprehend the hunger and the desperation of the campesinos around him . . .
To Diaz del Moral, campesino ignorance, passion, ecstasy, illusion, and
depression, not having a legitimate basis in reality, could be found only in
the roots of their racial heritage."_ [**Op. Cit.**, pp. 5-6]

Hence the _"religious"_ nature of anarchism -- it was one of the ways an
uncomprehending member of the middle-class could explain working class
discontent and rebellion. Unfortunately, this "explanation" has become common
place in history books (partly reflected academics class interest too and lack
of understanding of working class interests, needs and hopes).

As Mintz argues, _"at first glance the religious model seems to make anarchism
easier to understand, particularly in the absence of detailed observation and
intimate contact. The model was, however, also used to serve the political
ends of anarchism's opponents. Here the use of the terms 'religious' and
'millenarium' stamp anarchist goals as unrealistic and unattainable. Anarchism
is thus dismissed as a viable solution to social ills."_ He continues by
arguing that the _"oversimplifications posited became serious distortions of
anarchist belief and practice"_ (as we shall see). [**Op. Cit.**, p. 5 and p.
6]

Temma Kaplan's critique of the _"religious"_ view is also worth mentioning.
She argues that _"the millenarium theory is too mechanistic to explain the
complex pattern of Andalusian anarchist activity. The millenarian argument, in
portraying the Andalusian anarchists as fundamentally religious, overlooks
their clear comprehension of the social sources of their oppression."_ She
concludes that _"the degree of organisation, not the religiosity of workers
and the community, accounts for mass mobilisations carried on by the
Andalusian anarchists at the end of the nineteenth century."_ She also notes
that the _"[i]n a secular age, the taint of religion is the taint of
irrationality."_ [**Anarchists of Andalusia: 1868-1903**, pp. 210-12 and p.
211] Thus, the Andalusian anarchists had a clear idea who their enemies were,
namely the ruling class of the region. She also points out that, for all their
revolutionary elan, the anarchists developed a rational strategy of
revolution, channelling their energies into organising a trade union movement
that could be used as a vehicle for social and economic change. Moreover, as
well as a clear idea of how to change society they had a clear vision of what
sort of society they desired -- one built around collective ownership and
federations of workers' associations and communes.

Therefore the idea that anarchism can be explained in _"religious"_ terms is
fundamentally flawed. It basically assumes that the Spanish workers were
fundamentally irrational, unable to comprehend the sources of their
unhappiness nor able to define their own political goals and tactics and
instead looked to naive theories which reinforced their irrationalities. In
actuality, like most people, they were sensible, intelligent human beings who
believed in a better life and were willing to apply their ideas in their
everyday life. That historians apply patronising attitudes towards them says
more about the historians than the campesinos.

This uncomprehending attitude to historians can be seen from some of the more
strange assertions they make against the Spanish Anarchists. Gerald Brenan,
Eric Hobsbawm and Raymond Carr, for example, all maintained that there was a
connection between anarchist strikes and sexual practices. Carr's description
gives a flavour:

> _"Austere puritans, they sought to impose vegetarianism, sexual abstinence,
and atheism on one of the most backward peasantries of Europe . . . Thus
strikes were moments of exaltation as well as demands for better conditions;
spontaneous and often disconnected they would bring, not only the abolition of
piece-work, but 'the day,' so near at hand that sexual intercourse and alcohol
were abandoned by enthusiasts till it should dawn."_ [**Spain: 1808-1975**, p.
444]

Mintz, an American anthropologist who actually stayed with the campesino's for
a number of years after 1965, actually asked them about such claims. As he put
it, the _"level-headed anarchists were astonished by such descriptions of
supposed Spanish puritanism by over-enthusiastic historians."_ [**Op. Cit.**,
p. 6] As one anarchist put it, _"[o]f course, without any work the husband
couldn't provide any food at dinnertime, and so they were angry at each other,
and she wouldn't have anything to do with him. In that sense, yes, there were
no sexual relations."_ [quoted, **Op. Cit.**, p. 7]

Mintz traces the citations which allowed the historians to arrive at such
ridiculous views to a French social historian, Angel Maraud, who observed that
during the general strike of 1902 in Moron, marriages were postponed to after
the promised division of the lands. As Mintz points out, _"as a Frenchman,
Maraud undoubtedly assumed that everyone knew a formal wedding ceremony did
not necessarily govern the sexual relations of courting couples."_ [**Op.
Cit.**, p. 6f]

As for abstinence and puritanism, nothing could be further from the truth. As
Mintz argues, the anarchists considered alcoholism as being _"responsible for
much of the social malaise among many workers . . . Excessive drinking robbed
the worker of his senses and deprived his family of food. Anarchist newspapers
and pamphlets hammered out the evil of this vice."_ However, _"[p]roscriptions
were not of a puritanical order"_ (and so there was no desire to "impose" such
things on people) and quotes an anarchist who stated that _"coffee and tobacco
were not prohibited, but one was advised against using them. Men were warned
against going to a brothel. It was not a matter of morality but of hygiene."_
As for vegetarianism, it _"attracted few adherents, even among the **obreros
conscientes**."_ [**Op. Cit.**, pp. 86-7 and p. 88]

Moreover, academic mockery of anarchist attempts to combat alcoholism (and
**not** alcohol as such) forgets the social context. Being academics they may
not have experienced wage labour directly and so do not realise the misery it
can cause. People turn to drink simply because their jobs are so bad and seek
escape from the drudgery of their everyday lives. As Bakunin argued,
_"confined in their life like a prisoner in his prison, without horizon,
without outlet . . . the people would have the singularly narrow souls and
blunted instincts of the bourgeois if they did not feel a desire to escape;
but of escape there are but three methods -- two chimerical and a third real.
The first two are the dram-shop and the church, debauchery of the body or
debauchery of the mind; the third is social revolution."_ [**God and the
State**, p. 16] So to combat alcoholism was particularly important as many
workers turned to alcohol as a means of escaping the misery of life under
capitalism. Thus Bookchin:

> _"[T]o abstain from smoking, to live by high moral standards, and to
especially adjure the consumption of alcohol was very important at the time.
Spain was going through her own belated industrial revolution during the
period of anarchist ascendancy with all its demoralising features. The
collapse of morale among the proletariat, with rampant drunkenness, venereal
disease, and the collapse of sanitary facilities, was the foremost problem
which Spanish revolutionaries had to deal with . . . On this score, the
Spanish anarchists were eminently successful. Few CNT workers, much less a
committed anarchist, would have dared show up drunk at meetings or misbehave
overtly with their comrades. If one considers the terrible working and living
conditions of the period, alcoholism was not as serious a problem in Spain as
it was in England during the industrial revolution."_ [_"Introductory Essay"_,
**The Anarchist Collectives**, Sam Dolgoff (ed.), pp. xix-xxf]

Mintz sums up by stating _"[c]ontrary to exaggerated accounts of anarchist
zeal, most thoughtful **obreros conscientes** believed in moderation, not
abstinence."_ [**Op. Cit.**, p. 88] Unfortunately Mintz's work, the product of
years of living with and talking to the people actually involved in the
movement, does not seem to have made much impact on the historians.
Unsurprising, really, as history is rarely about the actions, ideas and hopes
of working people.

As can be seen, historians seem to delight in misrepresenting the ideas and
actions of the Spanish Anarchists. Sometimes, as just seen, the distortions
are quite serious, extremely misleading and ensure that anarchism cannot be
understood or viewed as a serious political theory (we can understand why
Marxists historians would seek this). Sometimes they can be subtle as when
Ronald Fraser states that at the CNT's Saragossa congress in 1936 _"the
proposal to create a libertarian militia to crush a military uprising was
rejected almost scornfully, in the name of traditional anti-militarism."_
[**Blood of Spain**, p. 101] Hugh Thomas makes the same claim, stating at
_"there was no sign that anyone [at the congress] realised that there was a
danger of fascism; and no agreement, in consequence, on the arming of
militias, much less the organisation of a revolutionary army as suggested by
Juan Garcia Oliver."_ [**The Spanish Civil War**, p. 181]

However, what Fraser and Thomas omit to tell the reader is that this motion
_"was defeated by one favouring the idea of guerrilla warfare."_ [Peter
Marshal, **Demanding the Impossible**, p. 460] The Saragossa resolution itself
stated that a _"permanent army constitutes the greatest danger for the
revolution . . . The armed people will be the best guarantee against all
attempts to restore the destroyed regime by interior or exterior forces . . .
Each Commune should have its arms and elements of defence."_ [quoted by Robert
Alexander, **The Anarchists in the Spanish Civil War**, vol. 1, p. 64]

Fraser's and Hugh's omission is extremely serious -- it gives a radically
false impression of anarchist politics. Their comments could led a reader to
think that anarchists, as Marxists claim, do not believe in defending a
revolution. As can be seen from the actual resolutions of the Saragossa
conference, this is not the case. Indeed, given that the congress was
explicitly discussing, along with many other issues, the question of _"defence
of the revolution"_ their omission seriously distorts the CNT's position and
anarchist theory. As seen, the congress supported the need to arm the people
and to keep those arms under the control of the communes (as well as the role
of _"Confederal Defence Forces"_ and the efficient organisation of forces on a
national level). Given that Thomas quotes extensively from the Saragossa
resolution on libertarian communism we can only surmise that he forgot to read
the section entitled **_"Defence of the Revolution."_**

Hugh and Thomas omissions, however, ensure that anarchism is presented as an
utopian and naive theory, unaware of the problems facing society. In reality,
the opposite is the case -- the Spanish anarchists were well aware of the need
to arm the people and resist counter-revolution and fascism by force.
Regardless of Thomas' claims, it is clear that the CNT and FAI realised the
danger of fascism existed and passed appropriate resolutions outlining how to
organise an effective means of self-defence (indeed, as early as February 14
of that year, the CNT had issued a prophetic manifesto warning that right-wing
elements were ready to provoke a military coup [Murray Bookchin, **The Spanish
Anarchists**, p. 273]). To state otherwise, while quoting from the document
that discusses the issue, must be considered a deliberate lie.

However, to return to our main point -- Eric Hobsbawm's thesis that the
Spanish anarchists were an example of _"pre-political"_ groups -- the
_"primitive rebels"_ of his title.

Essentially, Hobsbawm describes the Spanish Anarchists -- particularly the
Andalusian anarchists -- as modern-day secular mystics who, like the
millenarians of the Middle Ages, were guided by the irrational belief that it
was possible to will profound social change. The actions of the Spanish
anarchist movement, therefore, can be explained in terms of millenarian
behaviour -- the belief that it was able to jump start to utopia via an act of
will.

The Spanish farm and industrial workers, it is argued, were unable to grasp
the complexities of the economic and political structures that dominated their
lives and so were attracted to anarchism. According to Hobsbawm, anarchism is
marked by _"theoretical primitivism"_ and a primitive understanding of
revolution and this explained why anarchism was popular with Spanish workers,
particularly farm workers. According to Hobsbawm, anarchism told the workers
that by spontaneously rising up together they could overthrow the forces of
repression and create the new millennium.

Obviously, we cannot refute Hobsbawm's claims of anarchism's _"theoretical
primitivism"_ in this appendix, the reader is invited to consult the main FAQ.
Moreover, we cannot stress more that Hobsbawm's assertion that anarchists
believe in spontaneous, overnight uprisings is false. Rather, we see
revolution as a **process** in which day-to-day struggle and organisation play
a key role -- it is not seen as occurring independently of the on-going class
struggle or social evolution. While we discuss in depth the nature of an
anarchist social revolution in [ section J.7](secJ7.md), we can present a
few quotes by Bakunin to refute Hobsbawm's claim:

> _"Revolutions are not improvised. They are not made at will by individuals.
They come about through the force of circumstances and are independent of any
deliberate ill or conspiracy."_ [quoted by Brian Morris, **Bakunin: The
Philosophy of Freedom**, p. 139]

>

> _"It is impossible to rouse people by artificial means. Popular revolutions
are born by the actual force of events . . . It is impossible to bring about
such a revolution artificially. It is not even possible to speed it up at all
significantly . . . There are some periods in history when revolutions are
quite simply impossible; there are other periods when they are inevitable."_
[**Michael Bakunin: Selected Writings**, p. 183]

As Brian Morris correctly argues, _"Bakunin denies that a social revolution
could be made by the will of individuals, independent of social and economic
circumstances. He was much less a voluntarist than his Marxist critics make
out . . . he was . . . aware that the social revolution would be a long
process that may take many years for its realisation."_ [**Bakunin: The
Philosophy of Freedom**, pp. 138-9] To aid the process of social revolution,
Bakunin supported the need for _"pioneering groups or associations of advanced
workers who were willing to initiate this great movement of self-
emancipation."_ However, more is needed -- namely popular working class
organisations -- _"what is the organisation of the masses? . . . It is the
organisation by professions and trades . . . The organisation of the trade
sections . . . bear in themselves the living seed of the new society which is
to replace the old world. They are creating not only the ideas but also the
facts of the future itself."_ [**Bakunin on Anarchism**, p. 252 and p. 255]

Therefore, Bakunin saw revolution as a process which starts with day-to-day
struggle and creation of labour unions to organise that struggle. As he put it
himself:

> _"What policy should the International [Workers' Association] follow during
th[e] somewhat extended time period that separates us from this terrible
social revolution . . . the International will give labour unrest in all
countries an **essentially economic** character, with the aim of reducing
working hours and increasing salary, by means of the **association of the
working masses** . . . It will [also] propagandise its principles . . .
Lastly, the International will expand and organise across frontiers of all
countries, so that when the revolution -- brought about by the force of
circumstances -- breaks out, the International will be a real force and will
know what it has to do. Then it will be able to take the revolution into its
own hands and give it a direction that will benefit the people: an earnest
international organisation of workers' associations from all countries,
capable of replacing this departing world of States and bourgeoisie."_ [**The
Basic Bakunin**, pp. 109-10]

However, while quoting Bakunin refutes part of his thesis, Hobsbawm does base
his case on some actual events of Spanish Anarchist history. Therefore we need
to look at these cases and show how he gets these wrong. Without an empirical
basis, his case obviously falls even without quotes by Bakunin. Luckily the
important examples he uses have been analysed by people without the
ideological blinkers inherent in Leninism.

While we shall concentrate on just two cases -- Casa Viejas in 1933 and the
Jerez rising of 1892 -- a few general points should be mentioned. As Jerome
Mintz notes, Hobsbawms' _"account is based primarily on a preconceived
evolutionary model of political development rather than on data gathered in
field research. The model scales labour movements in accord with their
progress toward mass parties and central authority. In short, he explains how
anarchosyndicalists were presumed to act rather than what actually took place,
and the uprising at Casa Viejas was used to prove an already established point
of view. Unfortunately, his evolutionary model misled him on virtually every
point."_ [**Op. Cit.**, p. 271] We should also note his "model" is essentially
Marxist ideology -- namely, Marx's assertion that his aim for mass political
parties expressed the interests of the working class and all other visions
were the products of sectarians. Mintz also points out that Hobsbawm does not
live up to his own model:

> _"While Hobsbawm's theoretical model is evolutionary, in his own treatment
anarchism is often regarded as unchanging from one decade to the other. In his
text, attitudes and beliefs of 1903-5, 1918-20, 1933, and 1936 are lumped
together or considered interchangeable. Of course during these decades the
anarchosyndicalists had developed their programs and the individuals involved
had become more experienced."_ [**Op. Cit.**, p. 271f]

Hobsbawm believed that Casas Viejas was the classic _"anarchist"_ uprising --
_"utopian, millenarian, apocalyptic, as all witnesses agree it to have been."_
[**Primitive Rebels**, p. 90] As Mintz states, _"the facts prove otherwise.
Casas Viejas rose not in a frenzy of blind millenarianism but in response to a
call for a nation-wide revolutionary strike. The insurrection of January 1933
was hatched by faistas [members of the FAI] in Barcelona and was to be fought
primarily there and in other urban centres. The uprisings in the countryside
would be diversionary and designed to keep the civil guard from shifting
reinforcements. The faista plot was then fed by intensive newspaper
propaganda, by travelling orators, and by actions undertaken by the [CNT]
defence committees. Representatives of the defence committees from Casas
Viejas and Medina had received instructions at a regional meeting held days
before. On January 11, the anarchosyndicalists of Casas Viejas believed that
they were joining their companeros who had already been at the barricades
since January 8."_ [**Op. Cit.**, p. 272]

Hobsbawm argued that the uprising occurred in accordance with an established
economic pattern:

> _"Economic conditions naturally determined the timing and periodicity of the
revolutionary outbreaks -- for instance, social movements tended to reach a
peak intensity during the worse months of the year -- January to March, when
farm labourers have least work (the march on Jerez in 1892 and the rising of
Casas Viejas in 1933 both occurred early in January), March-July, when the
proceeding harvest has been exhausted and times are lean."_ [**Op. Cit.**, p.
79]

Mintz states the obvious:

> _"In reality, most agricultural strikes took place in May and June, the
period of the harvest and the only time of the year when the campesinos had
any leverage against the landowners. The uprising at Casas Viejas occurred in
January precisely because it was **not** an agricultural strike. The timing of
the insurrection, hurriedly called to coincide with a planned railway strike
that would make it difficult for the government to shift its forces, was
determined by strategic rather than economic considerations."_ [**Op. Cit.**,
p. 273]

As for the revolt itself, Hobsbawm asserts that:

> _"Secure from the outside world, [the men] put up the red and black flag of
anarchy and set about dividing the land. They made no attempt to spread the
movement or kill anyone."_ [**Op. Cit.**, p. 274]

Which, as Mintz clearly shows, was nonsense:

> _"As is already evident, rather than securing themselves from the rest of
world, the uprising at Casas Viejas was a pathetic attempt to join in an ill-
fated national insurrection. With regard to his second point, there was
neither the time nor the opportunity to 'set about dividing the land.' The men
were scattered in various locations guarding roads and paths leading to the
town. There were no meetings or discussions during this brief period of
control. Only a few hours separated the shooting at the barracks and the
entrance of the small [government] rescue force from Alcala. Contrary to
Hobsbawm's description of peaceful enterprise, at the outset the anarchists
surrounding the barracks had fired on the civil guards, mortally wounding two
men."_ [**Op. Cit.**, p. 274]

As can be seen, Hobsbawm was totally wrong about the uprising itself and so it
cannot be used as evidence for his thesis. On other, less key issues, he was
equally wrong. Mintz gives an excellent summary:

> _"Since kinship is a key feature in 'primitive' societies, according to
Hobsbawm, it was a major factor in the leadership of the sindicato [union] in
Casas Viejas.  
>  _

>

> _"There is no evidence that kinship had anything to do with leadership in
the anarchist movement in Casa Viejas or anywhere else. The reverse would be
closer to the truth. Since the anarchists expressed belief in universal
brotherhood, kinship ties were often undermined. In times of strike or in
carrying out any decision of the collective membership, obreros conscientes
sometimes had to act counter to their kinship demands in order to keep faith
with the movement and with their companeros. _

>

> _"Hobsbawm's specific examples are unfortunately based in part on errors of
fact. . . _

>

> _"Hobsbawm's model [also] requires a charismatic leader. Accordingly, the
inspired leader of the uprising is said to be 'old Curro Cruz ('Six Fingers')
who issued the call for revolution . . . ' _

>

> _[. . .] _

>

> _"This celebration of Seisdedo's role ['Six Fingers'], however, ignores the
unanimous view of townspeople of every class and political persuasion, who
assert that the old man was apolitical and had nothing to do with the uprising
. . . every observer and participant in the uprising agrees that Seisdedos was
not the leader and was never anything other than a virtuous charcoal burner
with but a slight interest in anarchosyndicalism. _

>

> _[. . .] _

>

> _"Should the role of charismatic leader be given to someone else in the
town? This was not a case of mistaken identity. No single person in Casas
Viejas could lay clam to dominating the hearts and minds of the men. . .The
sindicato was governed by a junta. Among the cast of characters there is no
sign of charismatic leadership . . ."_ [**Op. Cit.**, pp. 274-6

Mintz sums up by stating _"Hobsbawm's adherence to a model, and the
accumulation of misinformation, led him away from the essential conflicts
underlying the tragedy and from the reality of the people who participated in
it."_ [**Op. Cit.**, p. 276]

The Jerez uprising of 1892 also fails to provide Hobsbawm with any empirical
evidence to support his claims. Indeed, as in Casas Viejas, the evidence
actually works against him. The actual events of the uprising are as follows.
Just before midnight of 8th January 1892, several hundred workers entered the
town of Jerez crying _"Long live the revolution! Long live Anarchy!"_ Armed
with only rocks, sticks, scythes and other farm equipment, they marched toward
the city jail with the evident intention of releasing its prisoners -- who
included many political prisoners, victims of the government's recent anti-
anarchist campaign. A few people were killed and the uprising dispersed by a
regiment of mounted troops.

Hobsbawm claims this revolt as evidence for his _"primitive rebels"_ thesis.
As historian George R. Esenwein argues:

> _"[T]he Jerez incident cannot be explained in terms of this model. What the
millenarian view fails to do in this instance is to credit the workers with
the ability to define their own political goals. This is not to deny that
there were millenarian aspects of the rising, for the mob action of the
workers on the night of 8 January indicates a degree of irrationalism that is
consistent with millenarian behaviour. But . . . the agitators seem to have
had a clear motive in mind when they rose: they sought to release their
comrades from the local jail and thereby demonstrate their defiance of the
government's incessant persecution of the International [Workers' Association]
movement. However clumsily and crudely they expressed their grievance, the
workers were patently aiming to achieve this objective and not to overthrow
the local government in order to inaugurate the birth of a libertarian
society."_ [**Anarchist Ideology and the Working Class Movement in Spain:
1868-1898**, p. 184]

Similarly, many Marxists (and liberal historians) point to the _"cycle of
insurrections"_ that occurred during the 1930s. They usually portray these
revolts as isolated insurrections organised by the FAI who appeared in
villages and proclaimed libertarian communism. The picture is one of
disorganisation, millenarianism and a believe in spontaneous revolution
inspired by a few militants and their daring actions. Nothing could be further
from the truth. The _"cycle of insurrections"_ was far more complex that this,
as Juan Gomez Casas makes clear:

> _"Between 1932 and 1934 . . . the Spanish anarchists tried to destroy the
existing social order through a series of increasingly violent strikes and
insurrections, which were at first spontaneous, later co-ordinated."_
[**Anarchist Organisation: The History of the FAI**, p. 135]

Stuart Christie stresses this point when he wrote _"[i]t has been widely
assumed that the cycle of insurrections which began in . . . January 1933 were
organised and instigated by the FAI . . . In fact the rising had nothing to do
with the FAI. It began as an entirely spontaneous local affair directed
against a local employer, but quickly mushroomed into a popular movement which
threatened to engulf the whole of Catalonia and the rest of Spain . . . [CNT
militant] Arturo Parera later confirmed that the FAI had not participated in
the aborted movement 'as an organisation.'"_ [**We, the Anarchists**, p. 66]
While the initial revolts, such as those of the miners of Alto Llobregat in
January 1932, were spontaneous acts which caught the CNT and FAI by surprise,
the following insurrections became increasingly organised and co-ordinated by
those organisations. The January 1933 revolt, as noted above, was based around
a planned strike by the CNT railway workers union. The revolt of December 1933
was organised by a National Revolutionary Committee. Both revolts aimed at
uprisings all across Spain, based on the existing organisations of the CNT --
the unions and their "Defence committees". Such a degree of planning belies
any claims that Spanish Anarchists were _"primitive rebels"_ or did not
understand the complexities of modern society or what was required to change
it.

Ultimately, Hobsbawm's thesis and its underlying model represents Marxist
arrogance and sectarianism. His model assumes the validity of the Marxist
claim that true working class movements are based on mass political parties
based on hierarchical, centralised, leadership and those who reject this model
and political action (electioneering) are sects and sectarians. It was for
this reason that Marx, faced with the increased influence of Bakunin,
overturned the First International's original basis of free discussion with
his own concept of what a real workers' movement should be.

Originally, because the various sections of the International worked under
different circumstances and had attained different degrees of development, the
theoretical ideals which reflected the real movement would also diverge. The
International, therefore, was open to all socialist and working class
tendencies. The general policies of the International would be, by necessity,
based on conference decisions that reflected the free political development
that flowed from local needs. These decisions would be determined by free
discussion within and between sections of all economic, social and political
ideas. Marx, however, replaced this policy with a common program of
_"political action"_ (i.e. electioneering) by mass political parties via the
fixed Hague conference of 1872. Rather than having this position agreed by the
normal exchange of ideas and theoretical discussion in the sections guided by
the needs of the practical struggle, Marx imposed what **he** considered as
the future of the workers movement onto the International -- and denounced
those who disagreed with him as sectarians. The notion that what Marx
considered as necessary might be another sectarian position imposed on the
workers' movement did not enter his head nor that of his followers -- as can
be seen, Hobsbawm (mis)interpreted anarchism and its history thanks to this
Marxist model and vision.

However, once we look at the anarchist movement without the blinkers created
by Marxism, we see that rather than being a movement of _"primitive rebels"_
Spanish Anarchism was a movement of working class people using valid tactics
to meet their own social, economic and political goals -- tactics and goals
which evolved to meet changing circumstances. Seeing the rise of anarchism and
anarcho-syndicalism as the political expression of the class struggle, guided
by the needs of the practical struggle they faced naturally follows when we
recognise the Marxist model for what it is -- just one possible interpretation
of the future of the workers' movement rather than **the** future of that
movement. Moreover, as the history of Social Democracy indicates, the
predictions of Bakunin and the anarchists within the First International were
proved correct. Therefore, rather than being _"primitive rebels"_ or sectarian
politics forced upon the working class, anarchism reflected the politics
required to built a **revolutionary** workers' movement rather than a
reformist mass party.

## 2\. How accurate is Felix Morrow's book on the Spanish Revolution?

It is fair to say that most Marxists in Britain base their criticisms of the
Spanish Anarchism, particularly the revolution of 1936, on the work of
Trotskyist Felix Morrow. Morrow's book **Revolution and Counter-Revolution in
Spain**, first published in 1938, actually is not that bad -- for some kinds
of information. However, it is basically written as Trotskyist propaganda. All
too often Morrow is inaccurate, and over-eager to bend reality to fit the
party line. This is particularly the case when discussing the actions and
ideas of the CNT and FAI and when discussing the activities of his fellow
Trotskyists in Spain, the Bolshevik-Leninists. We discuss the first set of
inaccuracies in the following sections, here we mention the second, Morrow's
comments on the Spanish Trotskyists.

The Bolshevik-Leninists, for example, an obscure sect who perhaps numbered 20
members at most, are, according to Morrow, transformed into the only ones who
could save the Spanish Revolution -- because they alone were members of the
Fourth International, Morrow's own organisation. As he put it:

> _"Only the small forces of the Bolshevik-Leninists. . . clearly pointed the
road for the workers."_ [Felix Morrow, **Revolution and Counter-Revolution in
Spain**, p. 191]

>

> _"Could that party [the party needed to lead the revolution] be any but a
party standing on the platform of the Fourth International?"_ [**Op. Cit.**,
p. 248]

And so on. As we will make clear in the following discussion, Morrow was as
wrong about this as he was about anarchism.

The POUM -- a more significant Marxist party in Spain, though still tiny
compared to the anarchists -- is also written up as far more important than it
was, and slagged off for failing to lead the masses to victory (or listening
to the Bolshevik-Leninists). The Fourth Internationalists _"offered the POUM
the rarest and most precious form of aid: a consistent Marxist analysis"_
[**Op. Cit.**, p. 105] (never mind Spanish workers needing guns and
solidarity!). But when such a programme -- prepared in advance -- was offered
to the POUM by the Fourth International representative -- only two hours after
arriving in Spain, and a quarter of an hour after meeting the POUM [**Op.
Cit.**, p. 139] -- the POUM were not interested. The POUM have been both
attacked (and claimed as their own) by Trotskyists ever since.

It is Morrow's attacks on anarchism, though, that have most readily entered
leftist folklore -- even among Marxists who reject Leninism. Some of Morrow's
criticisms are fair enough -- but these were voiced by anarchists long before
Morrow put pen to paper. Morrow, in fact, quotes and accepts the analyses of
anarchists like Camillo Berneri (_"Berneri had been right"_ etc. [**Op.
Cit.**, p. 153]), and praises anarchists like Durruti (_"the greatest military
figure produced by the war"_ [**Op. Cit.**, p. 224]) -- then sticks the boot
into anarchism. Indeed, Durruti's analysis is praised but he is transformed
into _"no theoretician, but an activist leader of masses. . . his words
express the revolutionary outlook of the class-conscious workers."_ [**Op.
Cit.**, p. 250] Of course, his words, activity and _"outlook"_ (i.e. political
analysis) did not spring out of thin air but rather, to state the obvious,
were informed by and reflected his anarchist politics, history, activity and
vision (which in turn reflected his experiences and needs as a member of the
working class). Morrow obviously wanted to have his cake and eat it.

Typically for today's left, perhaps, the most quoted sections of Morrow's book
are the most inaccurate. In the next eight sections we discuss some of the
most inaccurate claims. After that we point out that Morrow's analysis of the
militias is deeply ironic given Trotsky's actions as leader of the Red Army.
Then we discuss some of Morrow's inaccurate assertions about anarchism in
general.

Of course, some of the errors we highlight in Morrow's work are the product of
the conditions in which it was written -- thousands of miles from Spain in
America, dependent on papers produced by Spanish Marxists, Anarchists and
others. We cannot blame him for such mistakes (although we can blame the
Trotskyist publisher who reprints his account without indicating his factual
errors and the Marxist writers who repeat his claims without checking their
accuracy). We **do,** however, blame Morrow for his errors and
misrepresentations of the activities and politics of the Spanish Anarchists
and anarchism in general. These errors derive from his politics and inability
to understand anarchism or provide an honest account of it.

By the end of our discussion we hope to show why anarchists argue that
Morrow's book is deeply flawed and its objectively skewed by the authors
politics and so cannot be taken at face value. Morrow's book may bring comfort
to those Marxists who look for ready-made answers and are prepared to accept
the works of hacks at face-value. Those who want to learn from the past --
instead of re-writing it -- will have to look elsewhere.

## 3\. Did a _"highly centralised"_ FAI control the CNT?

According to Morrow, _"Spanish Anarchism had in the FAI a highly centralised
party apparatus through which it maintained control of the CNT"_ [**Op.
Cit.**, p. 100]

In reality, the FAI -- the Iberian Anarchist Federation -- was founded, in
1927, as a confederation of regional federations (including the Portuguese
Anarchist Union). These regional federations, in turn, co-ordinated local and
district federations of highly autonomous anarchist affinity groups. In the
words of Murray Bookchin:

> _"Like the CNT, the FAI was structured along confederal lines: the affinity
groups were linked together in a Local Federation and the Local Federation in
District and Regional Federations. A Local Federation was administered by an
ongoing secretariat, usually of three persons, and a committee composed of one
mandated delegate from each affinity group. This body comprised a sort of
local executive committee. To allow for a full expression of rank-and-file
views, the Local Federation was obliged to convene assemblies of all the
**faistas** in its area. The District and Regional Federations, in turn, were
simply the Local federation writ large, replicating the structure of the lower
body. All the Local Districts and Regional Federations were linked together by
a Peninsular Committee whose tasks, at least theoretically, were
administrative. . . [A FAI secretary] admits that the FAI 'exhibited a
tendency towards centralism' . . . Yet it must also be emphasised that the
affinity groups were far more independent than any comparable bodies in the
Socialist Party, much less the Communist. . . the FAI was not an internally
repressive organisation . . . Almost as a matter of second nature, dissidents
were permitted a considerable amount of freedom in voicing and publishing
material against the leadership and established policies."_ [**The Spanish
Anarchists**, pp. 197-8]

And:

> _"Most writers on the Spanish labour movement seem to concur in the view
that, with the departure of the moderates, the CNT was to fall under the
complete domination of the FAI . . . But is this appraisal correct? The FAI .
. . was more loosely jointed as an organisation than many of its admirers and
critics seem to recognise. It has no bureaucratic apparatus, no membership
cards or dues, and no headquarters with paid officials, secretaries, and
clerks. . . They jealously guarded the autonomy of their affinity groups from
the authority of higher organisational bodies -- a state of mind hardly
conducive to the development of a tightly knit, vanguard organisation. _

>

> _"The FAI, moreover, was not a politically homogeneous organisation which
followed a fixed 'line' like the Communists and many Socialists. It had no
official program by which all **faistas** could mechanically guide their
actions."_ [**Op. Cit.**, p. 224]

So, while the FAI may have had centralising tendencies, a _"highly
centralised"_ political party it was not. Further, many anarcho-syndicalists
and affinity groups were not in the FAI (though most seem to have supported
it), and many FAI members put loyalty to the CNT (the anarcho-syndicalist
union confederation) first. For instance, according to the minutes of the FAI
national plenum of January-February 1936:

> _"The Regional Committee [of Aragon, Rioja, and Navarra] is completely
neglected by the majority of the militants because they are absorbed in the
larger activities of the CNT"  
>  _

And:

> _"One of the reasons for the poor condition of the FAI was the fact that
almost all the comrades were active in the defence groups of the CNT"_ (report
from the Regional Federation of the North).

These are internal documents and so unlikely to be lies. [Juan Gomez Casas,
**Anarchist Organisation: the History of the FAI**, p. 165 and p. 168]

Anarchists were obviously the main influence in the CNT. Indeed, the CNT was
anarcho-syndicalist long before the FAI was founded -- from its creation in
1910 the CNT had been anarcho-syndicalist and remained so for 17 years before
the FAI existed. However, Morrow was not the only person to assert _"FAI
control"_ of the CNT. In fact, the claim of _"FAI control"_ was an invention
of a reformist minority within the organisation -- people like Angel Pestana,
ex-CNT National Secretary, who wanted to turn the CNT into a politically
_"neutral"_ union movement. Pestana later showed what he meant by forming the
Syndicalist Party and standing for Parliament (the Cortes). Obviously, in the
struggle against the reformists, anarcho-syndicalists -- inside the FAI or not
-- voted for people they trusted to run CNT committees. The reformists (called
**Treinistas**) lost, split from the CNT (taking about 10% of the membership
with them), and the myth of _"FAI dictatorship"_ was born. Rather than accept
that the membership no longer supported them, the **Treinistas** consoled
themselves with tales that a minority, the FAI, had taken control of the CNT.

In fact, due to its decentralised and federal structure, the FAI could not
have had the sort of dominance over the CNT that is often attributed to it. At
union congresses, where policies and the program for the movement were argued
out:

> _"[D]elegates, whether or not they were members of the FAI, were presenting
resolutions adopted by their unions at open membership meetings. Actions taken
at the congress had to be reported back to their unions at open meetings, and
given the degree of union education among the members, it was impossible for
delegates to support personal, non-representative positions."_ [Juan Gomez
Casas, **Anarchist Organisation: The History of the FAI**, p. 121]

The union committees were typically rotated out of office frequently and
committeemen continued to work as wage-earners. In a movement so closely based
on the shop floor, the FAI could not maintain influence for long if they
ignored the concerns and opinions of co-workers. Moreover, only a minority of
the anarcho-syndicalist activists in the CNT belonged to the FAI and, as Juan
Gomez Casas points out in his history of the FAI, FAI militants frequently had
a prior loyalty to the CNT. Thus his summation seems correct:

> _"As a minority organisation, the FAI could not possibly have had the kind
of control attributed to it . . . in 1931 . . . there were fifty CNT members
for each member of a FAI group. The FAI was strongly federalist, with its
groups at the base freely associated. It could not dominate an organisation
like the CNT, which had fifty times as many members and was also opposed to
hierarchy and centralism. We know that FAI militants were also CNT militants,
and frequently they were loyal first to the CNT. Their influence was limited
to the base of the organisation through participation in the plenums of
militants or unions meetings."_ [**Op. Cit.**, p. 133]

He sums up by arguing:

> _"The myth of the FAI as conqueror and ruler of the CNT was created
basically by the **Treinistas**"_ [**Op. Cit.**, p. 134]

Therefore, Morrow is re-cycling an argument which was produced by the
reformist wing of the CNT after it had lost influence in the union rank-and-
file. Perhaps he judges the FAI by his own standards? After all, the aim of
Leninists is for the vanguard party to control the labour unions in their
countries. Anarchists reject such a vision and believe in union autonomy --
influence of political parties and groups should only exist in as much as they
influence the rank-and-file who control the union. Rather than aim to control
the CNT, the FAI worked to influence its membership. In the words of Francisco
Ascaso (friend of Durruti and an influential anarchist militant in the CNT and
FAI in his own right):

> _"There is not a single militant who as a 'FAIista' intervenes in union
meetings. I work, therefore I am an exploited person. I pay my dues to the
workers' union and when I intervene at union meetings I do it as someone who
us exploited, and with the right which is granted me by the card in my
possession, as do the other militants, whether they belong to the FAI or
not."_ [cited by Abel Paz, **Durruti: The People Armed**, p. 137]

In other words, the FAI _"controlled"_ the CNT only to the extent it
influenced the membership -- who, in fact, controlled the organisation. We
must also note that Ascaso's comment echoes Bakunin's that the _"purpose of
the Alliance [i.e. anarchist federation] is to promote the Revolution . . . it
will combat all ambition to dominate the revolutionary movement of the people,
either by cliques or individuals. The Alliance will promote the Revolution
only through the NATURAL BUT NEVER OFFICIAL INFLUENCE of all members of the
Alliance."_ [**Bakunin on Anarchism**, p. 387]

Regardless of Morrow's claims, the FAI was a federation of autonomous affinity
groups in which, as one member put it, _"[e]ach FAI group thought and acted as
it deemed fit, without bothering about what the others might be thinking or
deciding . . . they had no . . . opportunity or jurisdiction . . . to foist a
party line upon the grass-roots."_ [Francisco Carrasquer, quoted by Stuart
Christie, **We, the Anarchists!**, p. 28] There was co-ordination in a federal
structure, of course, but that did not create a _"highly centralised"_ party-
like organisation. Morrow judged the FAI according to his own standards,
squeezing it into his ideological vision of the world rather than reporting
the reality of the situation (see Stuart Christie's work for a more detailed
refutation of the usual Marxist and Liberal inventions of the activities and
nature of the FAI).

In addition, Morrow's picture of the FAI implicitly paints the CNT as a mere
"transmission belt" for that organisation (and so a re-production of the
Bolshevik position on the relationship of the labour unions and the
revolutionary party). Such a picture, however, ignores the CNT's character as
a non-hierarchical, democratic (self-managed) mass movement which had many
tendencies within it. It also fails to understand the way anarchists seek to
influence mass organisations -- not by assuming positions of power but by
convincing their fellow workers' of the validity of their ideas in policy
making mass assemblies (see [section J.3.6](secJ3.md#secj36) for more
details).

In other words, Morrow's claims are simply false and express a total lack of
understanding of the nature of the CNT, the FAI and their relationship.

## 4\. What is the history of the CNT and the Communist International?

Morrow states that the _"tide of the October Revolution had, for a short time,
overtaken the CNT. It had sent a delegate to the Comintern [Communist
International] Congress in 1921. The anarchists had then resorted to organised
fraction work and recaptured it."_ [**Op. Cit.**, p. 100] He links this to the
FAI by stating _"[t]henceforward . . . the FAI . . . maintained control of the
CNT."_ Given that the FAI was formed in 1927 and the CNT disassociated itself
with the Comintern in 1922, five years before the FAI was created,
_"thenceforward"_ does not do the FAI's ability to control the CNT before it
was created justice!

Partly it is the inability of the Communist Party and its Trotskyist off-
shoots to dominate the CNT which explains Morrow's comments. Seeing anarchism
as _"petty bourgeois"_ it is hard to combine this with the obvious truth that
a mass, revolutionary, workers' union could be so heavily influenced by
anarchism rather than Marxism. Hence the need for FAI (or anarchist) "control"
of the CNT. It allows Trotskyists ignore dangerous ideological questions. As
J. Romero Maura notes, the question why anarchism influenced the CNT _"in fact
raises the problem why the reformist social democratic, or alternatively the
communist conceptions, did not impose themselves on the CNT as they managed to
in most of the rest of Europe. This question . . . is based on the false
assumption that the anarcho-syndicalist conception of the workers' struggle in
pre-revolutionary society was completely at odds with what the **real** social
process signified (hence the constant reference to religious', 'messianic',
models as explanations)."_ He argues that the _"explanation of Spanish
anarcho-syndicalist success in organising a mass movement with a sustained
revolutionary **elan** should initially be sought in the very nature of the
anarchist concept of society and of how to achieve revolution."_ [J. Romero
Maura, _"The Spanish Case"_, in **Anarchism Today**, D. Apter and J. Joll
(eds.), p. 78 and p. 65] Once we do that, we can see the weakness of Morrow's
(and others) _"Myth of the FAI"_ \-- having dismissed the obvious reason for
anarchist influence, namely its practicality and valid politics, there can
only be "control by the FAI."

However, the question of affiliation of the CNT to the Comintern is worth
discussing as it indicates the differences between anarchists and Leninists.
As will be seen, the truth of this matter is somewhat different to Morrow's
claims and indicates well his distorted vision.

Firstly to correct a factual error. The CNT in fact sent two delegations to
the Comintern. At its 1919 national congress, the CNT discussed the Russian
Revolution and accepted a proposition that stated it _"declares itself a
staunch defender of the principles upheld by Bakunin in the First
International. It declares further that it affiliates provisionally to the
Third International on account of its predominantly revolutionary character,
pending the holding of the International Congress in Spain, which must
establish the foundations which are to govern the true workers'
International."_ [**No Gods, No Masters**, vol. 2, pp. 220-1]

In June 1920, Angel Pestana arrived in Moscow and represented the CNT at the
Second Congress of the Communist International. He was arrested when he
arrived back in Spain and so could not give his eye-witness account of the
strangulation of the revolution and the deeply dishonest manipulation of the
congress by the Communist Party. A later delegation arrived in April 1921,
headed by Andres Nin and Joaquin Maurin professing to represent the CNT.
Actually, Nin and Maurin represented virtually no one but the Lerida local
federation (their stronghold). Their actions and clams were disavowed by a
plenum of the CNT the following August.

How did Nin and Maurin manage to get into a position to be sent to Russia?
Simply because of the repression the CNT was under at the time. This was the
period when Catalan bosses hired gun men to assassinate CNT militants and
members and the police exercised the notorious practice known as **ley de
fugas** (shot while trying to escape). In such a situation, the normal
workings of the CNT came under must stress and _"with the best known
libertarian militants imprisoned, deported, exiled, if not murdered outright,
Nin and his group managed to hoist themselves on to the National Committee . .
. Pestana's report not being available, it was decided that a further
delegation should be sent . . . in response to Moscow's invitation to the CNT
to take part in the foundation of the Red International of Labour Unions."_
[Ignaio de Llorens, **The CNT and the Russian Revolution**, p. 8] Juan Gomez
Casas confirms this account:

> _"At a plenum held in Lerida in 1921, while the CNT was in disarray [due to
repression] in Catalonia, a group of Bolsheviks was designated to represent
the Spanish CNT in Russia . . . The restoration of constitutional guarantees
by the Spanish government in April 1922, permitted the anarcho-syndicalists to
meet in Saragossa in June 11 . . . [where they] confirmed the withdrawal of
the CNT from the Third International and the entrance on principle into the
new [revolutionary syndicalist] International Working Men's Association."_
[**Anarchist Organisation: History of the FAI**, p. 61]

We should note that along with pro-Bolshevik Nin and Maurin was anarchist
Gaston Leval. Leval quickly got in touch with Russian and other anarchists,
helping some imprisoned Russia anarchists get deported after bringing news of
their hunger strike to the assembled international delegates. By embarrassing
Lenin and Trotsky, Leval helped save his comrades from the prison camp and so
saved their lives.

By the time Leval arrived back in Spain, Pestana's account of his experiences
had been published -- along with accounts of the Bolshevik repression of
workers, the Kronstadt revolt, the anarchist movement and other socialist
parties. These accounts made it clear that the Russian Revolution had become
dominated by the Communist Party and the _"dictatorship of the proletariat"_
little more that dictatorship by the central committee of that party.

Moreover, the way the two internationals operated violated basic libertarian
principles. Firstly, the _"Red Labour International completely subordinated
trade unions to the Communist Party."_ [Peirats, **Anarchists in the Spanish
Revolution**, p. 38] This completely violated the CNT principle of unions
being controlled by their members (via self-management from the bottom up).
Secondly, the congresses' methodology in its debates and decision-making were
alien to the CNT tradition. In that organisation self-management was its pride
and glory and its gatherings and congresses reflected this. Pestana could not
fathom the fierce struggle surrounding the make-up of the chairmanship of the
Comintern congress:

> _"Pestana says that he was particularly intrigued by the struggle for the
chairmanship. He soon realised that the chair **was** the congress, and that
the Congress was a farce. The chairman made the rules, presided over
deliberations, modified proposals at will, changed the agenda, and presented
proposals of his own. For a start, the way the chair handled the gavel was
very inequitable. For example, Zinoviev gave a speech which lasted one and
one-half hours, although each speaker was supposedly limited to ten minutes.
Pestana tried to rebut the speech, but was cut off by the chairman, watch in
hand. Pestana himself was rebutted by Trotsky who spoke for three-quarters of
an hour, and when Pestana wanted to answer Trotsky's attack on him, the
chairman declared the debate over."_ [**Op. Cit.**, pp. 37-8]

In addition, _"[i]n theory, every delegate was free to table a motion, but the
chair itself selected the ones that were 'interesting.' Proportional voting
[by delegation or delegate] had been provided for, but was not implemented.
The Russian Communist Party ensured that it enjoyed a comfortable majority."_
Peirats continues by noting that _"[t]o top it all, certain important
decisions were not even made in the congress hall, but were made begin the
scenes."_ That was how the resolution that _"[i]n forthcoming world congresses
of the Third International, the national trade union organisations affiliated
to it are to be represented by delegates from each country's Communist Party"_
was adopted. He also noted that _"[o]bjections to this decision were quite
simply ignored."_ [**No Gods, No Masters**, vol. 2, p. 224]

Many of the syndicalist delegates to this _"pantomime"_ congress later meet in
Berlin and founded the anarcho-syndicalist **International Workers
Association** based on union autonomy, self-management and federalism.
Unsurprisingly, once Pestana and Leval reported back to their organisation,
the CNT rejected the Bolshevik Myth and re-affirmed the libertarian principles
it had proclaimed at its 1919 congress. At a plenum of the CNT in 1922, the
organisation withdrew its provisional affiliation and voted to join the
syndicalist International formed in Berlin.

Therefore, rather than the anarchists conducting _"fraction work"_ to
_"recapture"_ the CNT, the facts are the pro-Bolshevik National Committee of
1921 came about due to the extreme repression the CNT was suffering at the
time. Militants were being assassinated in the streets, including committee
members. In this context it is easy to see how an unrepresentative minority
could temporarily gain influence in the National Committee. Moreover, it was
CNT plenary session which revoked the organisations provisional affiliation to
the Comintern -- that is, a regular meeting of mandated and accountable
delegates. In other words, by the membership itself who had been informed of
what had actually been happening under the Bolsheviks. In addition, it was
this plenum which agreed affiliation to the anarcho-syndicalist
**International Workers Association** founded in Berlin during 1922 by
syndicalists and anarchists horrified by the Bolshevik dictatorship, having
seen it at first hand.

Thus the decision of the CNT in 1922 (and the process by which this decision
was made) follow exactly the decisions and processes of 1919. That congress
agreed to provisionally affiliate to the Comintern until such time as a real
workers' International inspired by the ideas of Bakunin was created. The only
difference was that this International was formed in Germany, not Spain. Given
this, it is impossible to argue that the anarchists _"recaptured"_ the CNT.

As can be seen, Morrow's comment presents radically false image of what
happened during this period. Rather than resort to _"fraction work"_ to
_"recapture"_ the CNT, the policies of the CNT in 1919 and 1922 were
identical. Moreover, the decision to disaffiliate from the Comintern was made
by a confederal meeting of mandated delegates representing the rank-and-file
as was the original. The anarchists did not "capture" the CNT, rather they
continued to influence the membership of the organisation as they had always
done. Lastly, the concept of "capture" displays no real understanding of how
the CNT worked -- each syndicate was autonomous and self-managed. There was no
real officialdom to take over, just administrative posts which were unpaid and
conducted after working hours. To "capture" the CNT was impossible as each
syndicate would ignore any unrepresentative minority which tried to do so.

However, Morrow's comments allow us to indicate some of the key differences
between anarchists and Leninists -- the CNT rejected the Comintern because it
violated its principles of self-management, union autonomy and equality and
built party domination of the union movement in its place.

## 5\. Why did the CNT not join the Workers' Alliance?

Morrow in his discussion of the struggles of the 1930s implies that the CNT
was at fault in not joining the Socialist UGT's _"Workers' Alliance"_
(**Alianza Obrera**). These were first put forward by the Marxist-Leninists of
the BOC (Workers and Peasants Bloc -- later to form the POUM) after their
attempts to turn the CNT into a Bolshevik vanguard failed [Paul Preston, **The
Coming of the Spanish Civil War**, p. 154]. Socialist Party and UGT interest
began only after their election defeat in 1933. By 1934, however, there
existed quite a few alliances, including one in Asturias in which the CNT
participated. Nationally, however, the CNT refused to join with the UGT and
this, he implies, lead to the defeat of the October 1934 uprising (see [next
section](append32.md#app6) for a discussion of this rebellion).

However, Morrow fails to provide any relevant historical background to
understand the CNT's decision. Moreover, their reasons **why** they did not
join have a striking similarity to Morrow's own arguments against the
"Workers' Alliance" (which may explain why Morrow does not mention them). In
effect, the CNT is dammed for having policies similar to Morrow's but having
principles enough to stick to them.

First, we must discuss the history of UGT and CNT relationships in order to
understand the context within which the anarchists made their decision. Unless
we do this, Morrow's claims may seem more reasonable than they actually are.
Once we have done this we will discuss the politics of that decision.

From 1931 (the birth of the Second Spanish Republic) to 1933 the Socialists,
in coalition with Republicans, had attacked the CNT (a repeat, in many ways,
of the UGT's collaboration with the quasi-fascist Primo de Rivera dictatorship
of 1923-30). Laws were passed, with Socialist help, making lightening strikes
illegal and state arbitration compulsory. Anarchist-organised strikes were
violently repressed, and the UGT provided scabs -- as against the CNT
Telephone Company strike of 1931. This strike gives in indication of the role
of the socialists during its time as part of the government (Socialist Largo
Caballero was the Minister of Labour, for example):

> _"The UGT . . . had its own bone to pick with the CNT. The telephone
syndicate, which the CNT had established in 1918, was a constant challenge to
the Socialists' grip on the Madrid labour movement. Like the construction
workers' syndicate, it was a CNT enclave in a solidly UGT centre. Accordingly,
the government and the Socialist Party found no difficulty in forming a common
front to break the strike and weaken CNT influence.  
>  _

>

> _"The Ministry of Labour declared the strike illegal and the Ministry of the
Interior called out the Civil Guard to intimidate the strikers . . . Shedding
all pretence of labour solidarity, the UGT provided the **Compania
Telefonica** with scabs while **El Socialista**, the Socialist Party organ,
accused the CNT of being run by **pistoleros.** Those tactics were successful
in Madrid, where the defeated strikers were obliged to enrol in the UGT to
retain their jobs. So far as the Socialists were concerned, the CNT's appeals
for solidarity had fallen on deaf ears. . . _

>

> _"In Seville, however, the strike began to take on very serious dimensions.
. . on July 20, a general strike broke out in Seville and serious fighting
erupted in the streets. This strike . . . stemmed from the walkout of the
telephone workers . . . pitched battles took place in the countryside around
the city between the Civil Guard and the agricultural workers. Maura, as
minister of interior, decided to crush the 'insurrection' ruthlessly. Martial
law was declared and the CNT's headquarters was reduced to shambles by
artillery fire. After nine days, during which heavily armed police detachments
patrolled the streets, the Seville general strike came to an end. The struggle
in the Andalusian capital left 40 dead and some 200 wounded."_ [Murray
Bookchin, **The Spanish Anarchists**, pp. 221-2]

Elsewhere, _"[d]uring a Barcelona building strike CNT workers barricaded
themselves in and said they would only surrender to regular troops. The army
arrived and then machine-gunned them as soon as they surrendered."_ [Antony
Beevor, **The Spanish Civil War**, p. 33] In other words, the republican-
socialist government repressed the CNT with violence as well as using the law
to undermine CNT activities and strikes.

Morrow fails to discuss this history of violence against the CNT. He mentions
in passing that the republican-socialist coalition government _"[i]n crushing
the CNT, the troops broadened the repression to the whole working class."_ He
states that _"[u]nder the cover of putting down an anarchist putsch in January
1933, the Civil Guard 'mopped up' various groups of trouble makers. And
encounter with peasants at Casas Viejas, early in January 1933, became a
**cause celebre** which shook the government to its foundations."_ However,
his account of the Casas Viejas massacre is totally inaccurate. He states that
_"the little village . . ., after two years of patient waiting for the
Institute of Agrarian Reform to divide the neighbouring Duke's estate, the
peasants had moved in and begun to till the soil for themselves."_ [**Op.
Cit.**, p. 22]

Nothing could be further from the truth. Firstly, we must note that the land
workers (who were not, in the main, peasants) were members of the CNT.
Secondly, as we pointed in [section 1](append32.md#app1), the uprising had
nothing to do with land reform. The CNT members did not _"till the soil"_,
rather they rose in insurrection as part of a planned CNT-FAI uprising based
on an expected rail workers strike (the _"anarchist putsch"_ Morrow mentions).
The workers were too busy fighting the Civil and Assault Guards to till
anything. He is correct in terms of the repression, of course, but his account
of the events leading up to it is not only wrong, it is misleading (indeed, it
appears to be an invention based on Trotskyist ideology rather than having any
basis in reality). Rather than being part of a _"broadened . . . repression
[against] the whole working class,"_ it was actually part of the _"putting
down"_ of the anarchist revolt. CNT members were killed -- along with a dozen
politically neutral workers who were selected at random and murdered. Thus
Morrow downplays the role of the Socialists in repressing the CNT and FAI --
he presents it as general repression rather than a massacre resulting from
repressing a CNT revolt.

He even quotes a communist paper stating that 9 000 political prisoners were
in jail in June 1933. Morrow states that they were _"mostly workers."_ [p. 23]
Yes, they were mostly workers, CNT members in fact -- _"[i]n mid-April [1933].
. . the CNT launched a massive campaign to release imprisoned CNT-FAI
militants whose numbers had now soared to about 9 000."_ [Bookchin, **Op.
Cit.**, pp. 231-2]

Moreover, during and after CNT insurrections in Catalonia in 1932, and the
much wider insurrections of January 1933 (9 000 CNT members jailed) and
December 1933 (16 000 jailed) Socialist solidarity was nil. Indeed, the 1932
and January 1933 revolts had been repressed by the government which the
Socialist Party was a member of.

In other words, and to state the obvious, the socialists had been part of a
government which repressed CNT revolts and syndicates, imprisoned and killed
their members, passed laws to restrict their ability to strike and use direct
action and provided scabs during strikes. Little wonder that Peirats states
_"[i]t was difficult for the CNT and the FAI to get used to the idea of an
alliance with their Socialist oppressors."_ [**Anarchists in the Spanish
Revolution**, p. 94]

It is **only** in this context can we understand the events of 1934 and the
refusal of the CNT to run into the UGT's alliance. Morrow, needless to say,
does not present this essential context and so the reader cannot understand
why the CNT acted as it did in response to Socialist appeals for "unity."
Instead, Morrow implies that CNT-FAI opposition to "workers alliances" were
due to them believing _"all governments were equally bad."_ [p. 29] Perhaps if
Morrow had presented an honest account of the repression the republican-
socialist government had inflicted on the CNT then the reader could make an
informed judgement on why anarchist opposition to the socialist proposals
existed. Rather than being sectarian or against labour unity, they had been at
receiving end of extensive socialist scabbing and state repression.

Moreover, as well as the recent history of socialist repression and scabbing,
there was also the experience of a similar alliance between the CNT and UGT
that had occurred in 1917. The first test of the alliance came with a miners
strike in Andalusia, and a _"CNT proposal for a joint general strike, to be
initiated by UGT miners and railway workers, had been rejected by the Madrid
Socialists . . . the miners, after striking for four months, returned to work
in defeat."_ Little wonder that _"the pact was in shreds. It was to be
eliminated completely when a general strike broke out in Barcelona over the
arrests of the CNT leaders and the assassination of Layret. Once again the CNT
called upon the UGT for support. Not only was aid refused but it was denied
with an arrogance that clearly indicated the Socialists had lost all interest
in future collaboration. . . The strike in Catalonia collapsed and, with it,
any prospect of collaboration between the two unions for years to come."_
[Bookchin, **Op. Cit.**, pp. 175-6]

Of course, such historical context would confuse readers with facts and so
goes unmentioned by Morrow.

In addition, there was another reason for opposing the "workers' alliances" --
particularly an alliance between the UGT and CNT. Given the history of UGT and
CNT pacts plus the actions of the UGT and socialists in the previous
government it was completely sensible and politically principled. This reason
was political and flowed from the CNT's libertarian vision. As Durruti argued
in 1934:

> _"The alliance, to be revolutionary, must be genuinely working class. It
must be the result of an agreement between the workers' organisation, and
those alone. No party, however, socialist it may be, can belong to a workers'
alliance, which should be built from its foundations, in the enterprises where
the workers struggle. Its representative bodies must be the workers' committee
chosen in the shops, the factories, the mines and the villages. We must reject
any agreement on a national level, between National Committees, but rather
favour an alliance carried out at the base by the workers themselves. Then and
only then, can the revolutionary drive come to life, develop and take root."_
[quoted by Abel Paz, **Durruti: The People Armed**, p. 154]

In the Central Region, Orobon Fernandez argued along similar lines in Madrid's
**La Tierra**:

> _"Revolutionary proletarian democracy is direct management of society by the
workers, a certain bulwark against party dictatorships and a guarantee of the
development of the revolution's forces and undertakings. . . what matters must
is that general guidelines are laid down so that these may serve as a platform
of the alliance and furnish a combative and constructive norm for the united
forces . . . [These include:] acceptance of revolutionary proletarian
democracy, which is to say, the will of the majority of the proletariat, as
the common denominator and determining factor of the new order of things. . .
immediate socialisation of the means of production, transportation, exchange,
accommodation and finance . . . federated according to their area of interest
and confederated at national level, the municipal and industrial organisations
will maintain the principle of unity in the economic structure."_ [quoted by
Jose Peirats, **The CNT in the Spanish Revolution**, vol. 1, pp. 74-5]

The May 1936 Saragossa congress of the CNT passed a resolution concerning
revolutionary alliances which was obviously based on these arguments. It
stated that in order _"to make the social revolution an effective reality, the
social and political system regulating the life of the country has to be
utterly destroyed"_ and that the _"new revolutionary order will be determined
by the free choice of the working class."_ [quoted by Jose Peirats, **Op.
Cit.**, p. 100]

Only such an alliance, from the bottom up and based on workers' self-
management could be a revolutionary one. Indeed, any pact not based on this
but rather conducted between organisations would be a pact the CNT and the
bureaucracy of the UGT -- and remove any possibility of creating genuine
bodies of working class self-management (as the history of the Civil War
proved). Indeed, Morrow seems to agree:

> _"The broad character of the proletarian insurrection was explained by the
Communist Left (Trotskyist). It devoted itself to efforts to build the
indispensable instrument of the insurrection: workers' councils constituted by
delegates representing all the labour parties and unions, the shops and
streets; to be created in every locality and joined together nationally . . .
Unfortunately, the socialists failed to understand the profound need of these
Workers' Alliances. The bureaucratic traditions were not to be so easily
overcome . . . the socialist leaders thought that the Workers' Alliances meant
they would have merely to share leadership with the Communist Left and other
dissident communist groups . . . actually in most cases they [Workers'
Alliances] were merely 'top' committees, without elected or lower-rank
delegates, that is, little more than liaison committees between the leadership
of the organisations involved."_ [**Op. Cit.**, pp. 27-8]

As can be seen, this closely follows Durruti's arguments. Bar the reference of
_"labour parties,"_ Morrow's _"indispensable instrument"_ is identical to
Durruti's and other anarchist's arguments against taking part in the "Workers'
Alliances" created by the UGT and the creation of genuine alliances from the
bottom-up. Thus Morrow faults the CNT for trying to force the UGT to form a
**real** workers' alliance by not taking part in what Morrow himself admits
were _"little more than liaison committees between the leadership"_! Also,
Morrow argues that _"[w]ithout developing soviets -- workers' councils -- it
was inevitable that even the anarchists and the POUM would drift into
governmental collaboration with the bourgeoisie"_ and he asks _"[h]ow could
party agreements be the substitute for the necessary vast network of workers'
councils?"_ [**Op. Cit.**, p. 89 and p. 114] Which was, of course, the CNT-
FAI's argument. It seems strange that Morrow faults the CNT for trying to
create real workers' councils, the _"indispensable instrument"_ of the
revolution, by not taking part in a _"party agreements"_ urged by the UGT
which would undermine real attempts at rank-and-file unity from below.

Of course, Morrow's statement that _"labour parties and unions"_ should be
represented by delegates as well as _"the shop and street"_ contradicts claims
it would be democratic. After all, that it would mean that some workers would
have multiple votes (one from their shop, their union and their party).
Moreover, it would mean that parties would have an influence greater than
their actual support in the working class -- something a minuscule group like
the Spanish Trotskyists would obviously favour as would the bureaucrats of the
Socialist and Communist Parties. Little wonder the anarchists urged a workers'
alliance made up of actual workers rather than an organisation which would
allow bureaucrats, politicians and sects more influence than they actually had
or deserved.

In addition, the "Workers' Alliances" were not seen by the UGT and Socialist
Party as an organisation of equals. Rather, in words of historian Paul
Preston, _"from the first it seemed that the Socialists saw the Alianza Obrera
was a possible means of dominating the workers movement in areas where the
PSOE and UGT were relatively weak."_ [**Op. Cit.**, p. 154] The Socialist
Party only allowed regional branches of the Alianza Obrera to be formed only
if they could guarantee Party control would never be lost. [Adrian Schubert
_"The Epic Failure: The Asturian Revolution of October 1934"_, in **Revolution
and War in Spain**, Paul Preston (ed.), p. 127] Raymond Carr argues that the
Socialists, _"in spite of professions to the contrary, wished to keep
socialist domination of the **Alianza Obrera**"_ [**Spain: 1808-1975**, pp.
634-5f] And only one month after the first alliance was set up, one of its
founder members -- the Catalan **Socialist Union** \-- left in protest over
PSOE domination. [Preston, **The Coming of the Spanish Civil War**, p. 157] In
Madrid, the Alianza was _"dominated by the Socialists, who imposed their own
policy."_ [**Op. Cit.**, p. 154] Indeed, as Jose Peirats notes, in Asturias
where the CNT had joined the Alliance, _"despite the provisions of the terms
of the alliance to which the CNT had subscribed, the order for the uprising
was issued by the socialists. In Oviedo a specifically socialist,
revolutionary committee was secretly at work in Oviedo, which contained no CNT
representatives."_ [**The CNT in the Spanish Revolution**, vol. 1, p. 78]
Largo Caballero's desire for trade union unity in 1936 was from a similar
mould -- _"[t]he clear implication was that proletarian unification meant
Socialist take-over."_ Little wonder Preston states that _"[i]f the use that
he [Caballero] made of the Alianza Obreras in 1934 had revealed anything, it
was that the domination of the working class movement by the UGT meant far
more to Largo Caballero than any future prospect of revolution."_ [Preston,
**Op. Cit.**, p. 270]

As can be seen, the CNT's position seemed a sensible one given the nature and
activities of the "Workers' Alliance" in practice. Also it seems strange that,
if unity was the UGT's aims, that a CNT call, made by the national plenary in
February 1934, for information and for the UGT to clearly and publicly state
its revolutionary objectives, met with no reply. [Peirats, **Op. Cit.**, p.
75] In addition, the Catalan Workers' Alliance called a general strike in
March 1934 the day **after** the CNT's -- hardly an example of workers' unity.
[Norman Jones, _"Regionalism and Revolution in Catalonia"_, **Revolution and
War in Spain**, Paul Preston (ed.), p. 102]

Thus, the reasons why the CNT did not join in the UGT's "Workers' Alliance"
are clear. As well as the natural distrust towards organisations that had
repressed them and provided scabs to break their strikes just one year
previously, there were political reasons for opposing such an alliance. Rather
than being a force to ensure revolutionary organisations springing from the
workplace, the "Workers' Alliance" was little more than pacts between the
bureaucrats of the UGT and various Marxist Parties. This was Morrow's own
argument, which also provided the explanation why such an alliance would
weaken any real revolutionary movement. To requote Morrow, _"[w]ithout
developing soviets -- workers' councils -- it was inevitable that even the
anarchists and the POUM would drift into governmental collaboration with the
bourgeoisie."_ [**Op. Cit.**, p. 89]

That is exactly what happened in July, 1936, when the CNT did forsake its
anarchist politics and joined in a "Workers' Alliance" type organisation with
other anti-fascist parties and unions to set up the _"Central Committee of
Anti-Fascist Militias"_ (see [section 20](append32.md#app20)). Thus Morrow
himself provides the explanation of the CNT's **political** rationale for
being wary of the UGT's _"Workers' Alliance"_ while, of course, refusing to
provide the historical context the decision was made.

However, while the CNT's refusal to join the "Workers' Alliance" outside of
Asturias may have been principled (and sensible), it may be argued that they
were the only organisation with revolutionary potential (indeed, this would be
the only argument Trotskyists could put forward to explain their hypocrisy).
Such an argument would be false for two reason.

Firstly, such Alliances may have potentially created a revolutionary situation
but they would have hindered the formation of working class organs of self-
management such as workers' councils (soviets). This was the experience of the
Central Committee of Anti-Fascist Militias and of the Asturias revolt -- in
spite of massive revolutionary upheaval such councils based on delegates from
workplace and community assembles were **not** formed.

Secondly, the CNT policy of "Unity, yes, but by the rank-and-file" was a valid
method of "from the bottom up solidarity." This can be seen from just two
examples -- Aragon in 1934 and Madrid in 1936. In Aragon, there was a
_"general strike that had totally paralysed the Aragonese capital throughout
April 1935, ending . . . on 10 May. . . the Zaragoza general strike had been a
powerful advertisement of the value of a united working-class front . . .
[However,] no formal agreement . . . had been reached in Zaragoza. The pact
there has been created on a purely circumstantial basis with a unity of trade-
union action achieved in quite specific circumstances and generated to a
considerable extent by the workers themselves."_ [Graham Kelsey, **Anarchism
in Aragon**, p. 72] In Madrid, April 1936 (in the words of Morrow himself)
_"the CNT declared a general strike in Madrid . . . The UGT had not been asked
to join the strike, and at first had denounced it . . . But the workers came
out of all the shops and factories and public services . . . because they
wanted to fight, and only the anarchists were calling them to struggle."_
[**Op. Cit.**, p. 41]

Thus Morrow's comments against the CNT refusing to join the Workers' Alliance
do not provide the reader with the historical context required to make an
informed judgement of the CNT's decision. Moreover, they seem hypocritical as
the CNT's reasons for refusing to join is similar to Morrow's own arguments
against the Workers' Alliance. In addition, the CNT's practical counter-
proposal of solidarity from below had more revolutionary potential as it was
far more likely to promote rank-and-file unity plus the creation of self-
managed organisations such as workers' councils. The Workers' Alliance system
would have hindered such developments.

## 6\. Was the October 1934 revolt sabotaged by the CNT?

Again, following Morrow, Marxists have often alleged that the Socialist and
Workers Alliance strike wave, of October 1934, was sabotaged by the CNT. To
understand this allegation, you have to understand the background to October
1934, and the split in the workers' movement between the CNT and the UGT
(unions controlled by the reformist Socialist Party, the PSOE).

Socialist conversion to "revolution" occurred only after the elections of
November 1933. In the face of massive and bloody repression (see [last
section](append32.md#app5)), the CNT-FAI had agitated for a mass abstention
at the polling booth. Faced with this campaign, the republicans and socialists
lost and all the laws they had passed against the CNT were used against
themselves. When cabinet seats were offered to the non-republican (fascist or
quasi-fascist) right, in October 1934, the PSOE/UGT called for a general
strike. If the CNT, nationally, failed to take part in this -- a mistake
recognised by many anarchist writers -- this was not (as reading Morrow
suggests) because the CNT thought _"all governments were equally bad"_
[Morrow, **Op. Cit.**, p. 29], but because of well-founded, as it turned out,
mistrust of Socialist aims.

A CNT call, on the 13th of February 1934, for the UGT to clearly and publicly
state its revolutionary objectives, had met with no reply. As Peirats argues,
_"[t]hat the absence of the CNT did not bother them [the UGT and Socialist
Party] is clear from their silence in regards to the [CNT's] National
Plenary's request."_ [Peirats, **Anarchists in the Spanish Revolution**, p.
96] Rhetoric aside, the Socialist Party's main aim in October seems to have
been to force new elections, so they could again form a (mildly reformist)
coalition with the Republicans (their programme for the revolt was written by
right-wing socialist Indalecio Prieto and seemed more like an election
manifesto prepared by the Liberal Republicans than a program for revolutionary
change). This was the viewpoint of the CNT, for example. Thus, the CNT, in
effect, was to be used as cannon-fodder to help produce another government
that would attack the CNT.

As we discussed in the [last section](append32.md#app5), the UGT backed
"Workers Alliances" were little better. To repeat our comments again, the
Socialist Party (PSOE) saw the alliances as a means of dominating the workers
movement in areas where the UGT was weak. The Socialist "Liaison Committee",
for instance, set up to prepare for insurrection, only allowed regional
branches to take part in the alliances if they could guarantee Party control
(see [last section](append32.md#app5)). Raymond Carr argues that the
Socialists, _"in spite of professions to the contrary, wished to keep
socialist domination of the **Alianza Obrera.**"_ [**Spain: 1808-1975**, pp.
634-5f] Only one month after the first alliance was set up, one of its founder
members -- the Socialist Union of Catalonia -- left in protest over PSOE
domination.

During October the only real centre of resistance was in Asturias (on the
Spanish north coast). However, before discussing that area, we must mention
Madrid and Barcelona. According to Morrow, Catalonia _"should have been the
fortress of the uprising"_ and that _"[t]erribly discredited for their refusal
to join the October revolt, the anarchists sought to apologise by pointing to
the repression they were undergoing at the time from Companys."_ [**Op.
Cit.**, p. 30 and p. 32] Morrow fails, however and yet again, to mention a few
important facts.

Firstly, the uprising in Catalonia was pushed for and lead by Estat Catala
which had _"temporary ascendancy over the other groups in the Esquerra"_ (the
Catalan Nationalist Party which was the Catalan government). _"Companys felt
obliged to yield to Dencas' [the leader of Estat Catala] demand that Catalonia
should take this opportunity for breaking with Madrid."_ [Gerald Brenan, **The
Spanish Labyrinth**, pp. 282-3] Estat Catala _"was a Youth movement . . . and
composed mostly of workmen and adventurers -- men drawn from the same soil as
the **sindicatos libres** [boss created anti-CNT yellow unions] of a dozen
years before -- with a violent antagonism to the Anarcho-Syndicalists. It had
a small military organisation, the **escamots**, who wore green uniforms. It
represented Catalan Nationalism in its most intransigent form: it was in fact
Catalan Fascism."_ [**Op. Cit.**, p. 282] Gabriel Jackson calls Estat Catala a
_"quasi-fascist movement within the younger ranks of the Esquerra."_ [**The
Spanish Republic and the Civil War: 1931-1939**, p. 150] Ronald Fraser terms
it _"the extreme nationalist and proto-fascist"_ wing of the party. [**Blood
of Spain**, p. 535] Hugh Thomas notes _"the fascist colouring of Dencas
ideas."_ [**The Spanish Civil War**, p. 135]

In other words, Morrow attacks the CNT for not participating in a revolt
organised and led by Catalan Fascists (or, at best, near fascists)!

Secondly, far from being apologetics, the repression the CNT was suffering
from Dencas police forces was very real and was occurring right up to the
moment of the revolt. In the words of historian Paul Preston:

> _"[T]he Anarchists bitterly resented the way in which the Generalitat had
followed a repressive policy against them in the previous months. This had
been the work of the Generalitat's counsellor for public order, Josep Dencas,
leader of the quasi-fascist, ultra-nationalist party Estat Catala."_ [**The
Coming of the Spanish Civil War**, p. 176]

This is confirmed by anarchist accounts of the rising. As Peirats points out:

> _"On the eve of the rebellion the Catalan police jailed as many anarchists
as they could put their hands on . . . The union offices had been shut for
some time. The press censor had completely blacked out the October 6th issue
of **Solidaridad Obrera** . . . When the woodworkers began to open their
offices, they were attacked by the police, and a furious gunfight ensured. The
official radio . . . reported . . . that the fight had already began against
the FAI fascists . . . In the afternoon large numbers of police and
**escamots** turned out to attack and shut down the editorial offices of
**Solidaridad Obrera**."_ [Peirats, **Op. Cit.**, pp. 98-9]

In other words, the first shots fired in the Catalan revolt were against the
CNT by those in revolt against the central government!

Why were the first shots of the revolt directed at the members of the CNT?
Simply because they were trying to take part in the revolt in an organised and
coherent manner as urged by the CNT's Regional Committee itself. In spite of
the mass arrests of anarchists and CNT militants the night before by the
Catalan rebels, the CNT's Catalan Regional Committee issued a clandestine
leaflet that stated that the CNT _"must enter the battle in a manner
consistent with its revolutionary anarchist principles . . . The revolt which
broke out this morning must acquire the characteristics of a popular act
through the actions of the proletariat . . . We demand the right to intervene
in this struggle and we will take this."_ A leaflet had to be issued as
**Solidaridad Obrera** was several hours late in appearing due censorship by
the Catalan state. The workers had tried to open their union halls (all CNT
union buildings had been closed by the Catalan government since the CNT revolt
of December 1933) because the CNT's leaflet had called for the _"[i]mmediate
opening of our union buildings and the concentration of the workers on those
premises."_ [quoted by Peirats, **The CNT in the Spanish Revolution**, vol. 1,
p. 85] The participation of the CNT in the revolt as an organised force was
something the Catalan rebels refused to allow and so they fired on workers
trying to open their union buildings. Indeed, after shutting down
**Solidaridad Obrera**, the police then tried to break up the CNT's regional
plenum that was then in session, but fortunately it was meeting on different
premises and so they failed. [Peirats, **Op. Cit.**, pp. 85-6]

Juan Gomez Casas argues that:

> _"The situation [in October 1934] was especially difficult in Catalonia. The
Workers' Alliance . . . declared a general strike. Luis Companys, president of
the Catalan Parliament, proclaimed the Catalan State within the Spanish
Federal Republic . . . But at the same time, militants of the CNT and the FAI
were arrested . . . **Solidaridad Obrera** was censored. The Catalan
libertarians understood that the Catalan nationalists had two objectives in
mind: to oppose the central government and to destroy the CNT. Jose Dencas,
Counsellor of Defence, issued a strict order: 'Watch out for the FAI' . . .
Luis Companys broadcast a message on October 5 to all 'citizens regardless of
ideology.' However, many anarchosyndicalist militants were held by his deputy,
Dencas, in the underground cells of police headquarters."_ [**Op. Cit.**, pp.
151-2]

Hence the paradoxical situation in which the anarchists, anarcho-syndicalists
and FAI members found themselves in during this time. The uprising was
organised by Catalan fascists who continued to direct their blows against the
CNT. As Abel Paz argues, _"[f]or the rank and file Catalan worker . . . the
insurgents . . . were actually orienting their action in order to destroy the
CNT. After that, how could they collaborate with the reactionary movement
which was directing its blows against the working class? Here was the paradox
of the Catalan uprising of October 6, 1934."_ [**Durruti: The People Armed**,
p. 158]

In other words, during the Catalan revolt, _"the CNT had a difficult time
because the insurgents were its worst enemies."_ [Peirats, **The Anarchists in
the Spanish Revolution**, p. 98] However, the complexity of the actual
situation does not bother the reader of Morrow's work as it is not reported.
Little wonder, as Peirats argues, the _"absurd contention according to which
the confederal proletariat of Catalonia betrayed their brethren in Asturias
melts away in the face of a truthful narration of the facts."_ [**The CNT in
the Spanish Revolution**, vol. 1, p. 86]

In summary, therefore, Morrow expected the membership of the Catalan CNT and
FAI to join in a struggle started and directed by Catalan fascists, whose
leaders in the government were arresting and shooting their members, censoring
their press, closing their union offices and refusing them a role in the
revolt as self-organised forces. We think that sums up the validity of
Trotskyism as a revolutionary theory quite well.

In Madrid, the revolt was slightly less farcical. Here the CNT joined the
general strike. However, the UGT gave the government 24 hours notice of the
general strike, allowing the state to round up the Socialist "leaders," seize
arm depots and repress the insurrection before it got started [Morrow, **Op.
Cit.**, p. 30]. As Bookchin argues, the _"massive strike in Madrid, which was
supported by the entire left, foundered for want of arms and a revolutionary
sense of direction."_ [**Op. Cit.**, p. 245] He continues:

> _"As usual, the Socialists emerged as unreliable allies of the Anarchists. A
revolutionary committee, established by the CNT and FAI to co-ordinate their
own operations, was denied direly needed weapons by the UGT. The arms, as it
turned out, had been conveniently intercepted by government troops. But even
if they had been available, it is almost certain that the Socialists would not
have shared them with the Anarchists. Indeed, relationships between the two
major sectors of the labour movement had already been poisoned by the failure
of the Socialist Youth and the UGT to keep the CNT adequately informed of
their plans or confer with Anarchosyndicalist delegates. Despite heavy
fighting in Madrid, the CNT and FAI were obliged to function largely on their
own. When, at length, a UGT delegate informed the revolutionary committee that
Largo Caballero was not interested in common action with the CNT, the
committee disbanded."_ [**Op. Cit.**, p. 246]

Bookchin correctly states that _"Abad de Santillan was to observe with ample
justification that Socialist attempts to blame the failure of the October
Insurrection on Anarchist abstention was a shabby falsehood"_ and quotes
Santillan:

> _"Can there be talk of abstention of the CNT and censure of it by those who
go on strike without warning our organisation about it, who refuse to meet
with the delegates of the National Committee [of the CNT], who consent to let
the Lerrous-Gil Robles Government take possession of the arms deposits and let
them go unused before handing them over to the Confederation and the FAI?"_
[**Ibid.**]

Historian Paul Preston confirms that in Madrid _"Socialists and Anarchists
went on strike . . ."_ and that _"the Socialists actually rejected the
participation of Anarchist and Trotskyist groups who offered to help make a
revolutionary coup in Madrid."_ [**The Coming of the Spanish Civil War**, p.
174] Moreover, _"when delegates travelled secretly to Madrid to try to co-
ordinate support for the revolutionary Asturian miners, they were rebuffed by
the UGT leadership."_ [Graham Kelsey, **Anarchism in Aragon**, p. 73]

Therefore, in two of the three centres of the revolt, the uprising was badly
organised. In Catalonia, the revolt was led by fascist Catalan Nationalists
who arrested and shot at CNT militants. In Madrid, the CNT backed the strike
and was ignored by the Socialists. The revolt itself was badly organised and
quickly repressed (thanks, in part, to the actions of the Socialists
themselves). Little wonder Peirats asks:

> _"Although it seems absurd, one constantly has to ask whether the Socialists
meant to start a true revolution [in October 1934] in Spain. If the answer is
affirmative, the questions keep coming: Why did they not make the action a
national one? Why did they try to do it without the powerful national CNT? Is
a peaceful general strike revolutionary? Was what happened in Asturias
expected, or were orders exceeded? Did they mean only to scare the Radical-
CEDA government with their action?"_ [**The Anarchists in the Spanish
Revolution**, pp 95-6]

The only real centre of resistance was in Asturias (on the Spanish north
coast). Here, the CNT had joined the Socialists and Communists in a "Workers
Alliance". But, against the alliance's terms, the Socialists alone gave the
order for the uprising -- and the Socialist-controlled Provincial Committee
starved the CNT of arms. This despite the CNT having over 22 000 affiliates in
the area (to the UGT's 40 000). We discuss the activities of the CNT during
the revolt in Asturias later (in [section 20](append32.md#app20)) and so
will not do so here.

Morrow states that the _"backbone of the struggle was broken . . . when the
refusal of the CNT railroad workers to strike enabled the government to
transport goods and troops."_ [Morrow, **Op. Cit.**, p. 30] Yet in Asturias
(the only area where major troop transportation was needed) the main
government attack was from a sea borne landing of Foreign Legion and Moroccan
troops - against the port and CNT stronghold (15 000 affiliates) of Gijon
(and, we must stress, the Socialists and Communists refused to provide the
anarchists of these ports with weapons to resist the troop landings). Hence
his claim seems somewhat at odds with the actual events of the October
uprising.

Moreover, he seems alone in this claim. No other historian (for example, Hugh
Thomas in **The Spanish Civil War**, Raymond Carr in **Spain: 1808-1975**,
Paul Preston in **The Coming of the Spanish Civil War**, Gerald Brenan, **The
Spanish Labyrinth**, Gabriel Jackson, **The Spanish Republic and the Civil
War: 1931-1939**) makes this claim. But, of course, these are not Trotskyists
and so can be ignored. However, for objective readers such an omission might
be significant.

Indeed, when these other historians **do** discuss the crushing of the
Asturias they all stress the fact that the troops came from the sea. For
example, Paul Preston notes that _"[w]ith CEDA approval, Franco . . . insisted
on the use of troops from Africa . . . they shipped Moorish mercenaries to
Asturias."_ [**The Coming of the Spanish Civil War**, p. 177] Gabriel Jackson
argues that the government _"feared to send in the regular Army because of the
strong possibility that the Spanish conscripts would refuse to fire on the
revolutionaries -- or even desert to them. The War Minister . . . , acting on
the advice of Generals Franco and Goded, sent in contingents of the Morrish
**regulares** and of the Foreign Legions."_ These troops arrived _"at the
ports of Aviles and Gijon."_ [**The Spanish Republic and the Civil War:
1931-1939**, p. 157]

Richard A. H. Robinson argues that it _"was soon decided that the [Asturias]
rebellion could only be crushed by experienced, professional troops. The other
areas of Spain could not be denuded of their garrisons in case there were
other revolutionary outbreaks. Franco therefore called upon Colonel Yague to
lead a force of Moorish regulars to help re-conquer the province from the
rebels."_ [**The Origins of Franco's Spain**, pp. 190-1] Stanley G. Payne
gives a more detailed account of the state's attack:

> _"Army reinforcements were soon being rushed toward the region . . . Eduardo
Lopez Ochoa . . . head[ed] the main relief column . . . he began to make his
way eastward [from Galicia] with a modest force of some 360 troops in trucks,
half of whom had to be detached on the way to hold the route open. Meanwhile .
. . in the main Asturian coastal city of Gijon . . . reinforcements first
arrived by sea on the seventh, followed by larger units from the Moroccan
Protectorate on the tenth."_ [**Spain's First Democracy**, p. 219]

No mention of trains in these accounts, so indicating that Morrow's assertions
are false. The main attack on Asturias, and so the transportation of troops
and goods, was by **_sea_**, not by trains.

In addition, these historians point to other reasons for the defeat of the
revolt -- the amazingly bad organisation of it by the Socialist Party. Raymond
Carr sums up the overwhelming opinion of the historians when he says that
_"[a]s a national movement the revolution was a fiasco."_ [**Op. Cit.**, p.
633] Hugh Thomas states that the revolt in Catalonia was _"crushed nearly as
quickly as the general strike had been in Madrid."_ [**The Spanish Civil
War**, p. 136] Brenan correctly argues that _"[f]rom the moment that Barcelona
capitulated and the rising in Madrid fizzled out, the miners were of course
doomed."_ [**Op. Cit.**, p. 286] The failure of both these revolts was
directly attributable to the policies and actions of the Socialists who
controlled the _"Workers' Alliances"_ in both areas. Hence historian Paul
Heywood:

> _ "[A]n important factor which contributed to the strikes' collapse and made
the state's task easier was the underlying attitude of the Socialists. For all
the talk of united action by the Left, the Socialists still wished to dominate
any combined moves. Unwilling to cede its traditional hegemony, the PSOE
rendered the Alianze obrera necessarily ineffective . . .  
>  _

>

> _"Thus, there was little genuine unity on the Spanish Left. Moreover, the
strike was very poorly planned. Differences within the PSOE meant that there
was no agreement even as to the programme of the strike. For the . . .
leftists, it represented the initiation of a full-scale Socialist revolution;
for . . . the centrists in the party, the aim of the strike was to force
Alcala-Zamora to reconsider and invite the Socialists back into a coalition
government with the Republicans."_ [**Marxism and the Failure of Organised
Socialism in Spain 1879-1936** pp. 144-5]

Significantly, Heywood argues that _"[o]ne thing, however, did emerge from the
October strike. The example of Asturias provided a pointed lesson for the
Left: crucially, the key to the relative success of the insurrection there was
the participation of the CNT in an effective Alianza obrera. Without the CNT,
the Asturian rising would have been as short-lived and as easily defeated as
those in Madrid and Barcelona."_ [**Op. Cit.**, p. 145]

Having discussed both Madrid and Barcelona above, we leave it to the reader to
conclude whether Morrow's comments are correct or whether a more likely
alternative explanation for the revolt's failure is possible.

However, even assuming Morrow's claims that the failure of the CNT rail
workers' union to continue striking in the face of a completely farcical
"revolt" played a key role in its defeat were true, it does not explain many
facts. Firstly, the government had declared martial law -- placing the railway
workers in a dangerous position. Secondly, as Jerome R. Mintz points out,
railway workers _"were represented by two competing unions -- the Sindicato
Nacional Ferroviario of the UGT . . . and the CNT-affiliated FNIFF . . . The
UGT . . . controlled the large majority of the workers. [In 1933] Trifon
Gomez, secretary of the UGT union, did not believe it possible to mobilise the
workers, few of whom had revolutionary aspirations."_ [**The Anarchists of
Casa Viejas**, p. 178] Outside of Catalonia, the majority of the railway
workers belonged to the UGT [Sam Dolgoff, **The Anarchist Collectives**, p.
90f] Asturias (the only area where major troop transportation was needed) does
not border Catalonia -- apparently the army managed to cross Spain on a rail
network manned by a minority of its workers.

However, these points are of little import when compared to the fact that
Asturias the main government attack was, as we mentioned above, from a sea
borne landing of Foreign Legion and Moroccan troops. Troops from Morocco who
land by sea do not need trains. Indeed, The ports of Aviles and Gijon were the
principle military bases for launching the repression against the uprising.

The real failure of the Asturias revolt did not lie with the CNT, it lay
(unsurprisingly enough) with the Socialists and Communists. Despite CNT pleas
the Socialists refused arms, Gjon fell after a bloody struggle and became the
main base for the crushing of the entire region (_"Arriving at the ports of
Aviles and Gijon on October 8, these troops were able to overcome the
resistance of the local fishermen and stevedores. The revolutionary committees
here were Anarchist dominated. Though they had joined the rising and accepted
the slogan UHP [Unity, Proletarian Brothers], the Socialists and Communists of
Oviedo clearly distrusted them and had refused arms to their delegate the day
before."_ [Gabriel Jackson, **Op. Cit.**, p. 157]).

This Socialist and Communist sabotage of Anarchist resistance was repeated in
the Civil War, less than two years later.

As can be seen, Morrow's account of the October Insurrection of 1934 leaves a
lot to be desired. The claim that the CNT was responsible for its failure
cannot withstand a close examination of the events. Indeed, by providing the
facts which Morrow does not provide we can safely say that the failure of the
revolt across Spain rested squarely with the PSOE and UGT. It was badly
organised, they failed to co-operate or even communicate with CNT when aid was
offered, they relied upon the enemies of the CNT in Catalonia and refused arms
to the CNT in both Madrid and Asturias (so allowing the government force, the
main force of which landed by sea, easy access to Asturias). All in all, even
if the minority of railway workers in the CNT had joined the strike it would
have, in all probability, resulted in the same outcome.

Unfortunately, Morrow's assertions have become commonplace in the ranks of the
Left and have become even more distorted in the hands of his Trotskyist
readers. For example, we find Nick Wrack arguing that the _"Socialist Party
called a general strike and there were insurrectionary movements in Asturias
and Catalonia, In Madrid and Catalonia the anarchist CNT stood to one side,
arguing that this was a 'struggle between politicians' and did not concern the
workers even though this was a strike against a move to incorporate fascism
into the government."_ He continues, _"[i]n Asturias the anarchist militants
participated under the pressure of the masses and because of the traditions of
unity in that area. However, because of their abstentionist stupidity, the
anarchists elsewhere continued to work, even working trains which brought the
Moorish troops under Franco to suppress the Asturias insurrection."_
[_"Marxism, Anarchism and the State"_, pp. 31-7, **Militant International
Review**, no. 46, p. 34]

Its hard to work out where to start in this travesty of history. We will start
with the simple errors. The CNT **did** take part in the struggle in Madrid.
As Paul Preston notes, in Madrid the _"Socialists and Anarchists went on
strike"_ [**The Coming of the Spanish Civil War**, p. 174] In Catalonia, as
indicated above, the "insurrectionary movement" in Catalonia was organised and
lead by Catalan Fascists, who shot upon CNT members when they tried to open
their union halls and who arrested CNT and FAI militants the night before the
uprising. Moreover, the people organising the revolt had been repressing the
CNT for months previously. Obviously attempts by Catalan Fascists to become a
government should be supported by socialists, including Trotskyists. Moreover,
the UGT and PSOE had worked with the quasi-fascist Primo do Rivera
dictatorship during the 1920s. The hypocrisy is clear. So much for the CNT
standing _"to one side, arguing that this was a 'struggle between politicians'
and did not concern the workers even though this was a strike against a move
to incorporate fascism into the government."_

His comments that _"the anarchists . . . work[ed] trains which brought the
Moorish troops under Franco to suppress the Asturias insurrection"_ is just
plain silly. It was **not** anarchists who ran the trains, it was railway
workers -- under martial law -- some of whom were in the CNT and some of whom
were anarchists. Moreover, as noted above the Moorish troops under Franco
arrived **by sea** and not by train. And, of course, no mention of the fact
that the CNT-FAI in the strategically key port of Gijon was denied arms by the
Socialists and Communists, which allowed the Moorish troops to disembark
without real resistance.

Morrow has a lot to answer for.

## 7\. Were the Friends of Durruti Marxists?

It is sometimes claimed that the **Friends of Durruti** Group which formed
during the Spanish Revolution were Marxists or represented a "break" with
anarchism and a move towards Marxism. Both these assertions are false. We
discuss whether the Friends of Durruti (FoD) represented a "break" with
anarchism in the [following section](append32.md#app8). Here we indicate
that claims of the FoD being Marxists are false.

The Friends of Durruti were formed, in March 1937, by anarchist militants who
had refused to submit to Communist-controlled "militarisation" of the workers'
militias. During the Maydays -- the government attack against the revolution
two months later -- the Friends of Durruti were notable for their calls to
stand firm and crush the counter-revolution. During and after the May Days,
the leaders of the CNT asserted that the FoD were Marxists (which was quite
ironic as it was the CNT leaders who were acting as Marxists in Spain usually
did by joining with bourgeois governments). This was a slander, pure and
simple.

The best source to refute claims that the FoD were Marxists (or becoming
Marxist) or that they were influenced by, or moved towards, the Bolshevik-
Leninists is Agustin Guillamon's book **The Friends of Durruti Group:
1937-1939**. Guillamon is a Marxist (of the "left-communist" kind) and no
anarchist (indeed he states that the _"Spanish Revolution was the tomb of
anarchism as a revolutionary theory of the proletariat."_ [p. 108]). That
indicates that his account can be considered objective and not anarchist
wishful thinking. Here we use his work to refute the claims that the FoD were
Marxists. [Section 9](append32.md#app9) discusses their links (or lack of
them) with the Spanish Trotskyists.

So were the FoD Marxists? Guillamon makes it clear -- no, they were not. In
his words, _"[t]here is nothing in the Group's theoretical tenets, much less
in the columns of **El Amigo del Pueblo** [their newspaper], or in their
various manifestos and handbills to merit the description 'marxist' being
applied to the Group [by the CNT leadership]. They were simply an opposition
to the CNT's leadership's collaborationist policy, making their stand within
the organisation and upon anarcho-syndicalist ideology."_ [p. 61] He stresses
this in his conclusion:

> _"The Friends of Durruti was an affinity group, like many another existing
in anarcho-syndicalist quarters. It was not influenced to any extent by the
Trotskyists, nor by the POUM. Its ideology and watchwords were
quintessentially in the CNT idiom: it cannot be said that they displayed a
marxist ideology at any time . . . They were against the abandonment of
revolutionary objectives and of anarchism's fundamental and quintessential
ideological principles, which the CNT-FAI leaders had thrown over in favour of
anti-fascist unity and the need to adapt to circumstances."_ [p. 107]

In other words, they wanted to return the CNT _"to its class struggle roots."_
[**Ibid.**] Indeed, Balius (a leading member of the group and writer of its
1938 pamphlet **Towards a Fresh Revolution**) was moved to challenge the
charges of "marxist" levelled at him:

> _"I will not repay defamatory comment in kind. But what I cannot keep mum
about is that a legend of marxism has been woven about my person and I should
like the record put straight . . . It grieves me that at the present time
there is somebody who dares call me a Marxist when I could refute with
unanswerable arguments those who hang such an unjustified label on me. As one
who attends our union assemblies and specific gatherings, I might speak of the
loss of class sensibility which I have observed on a number of occasions. I
have heard it said that we should be making politics -- in as many words,
comrades -- in an abstract sense, and virtually no one protested. And I, who
have been aghast at countless such instances, am dubbed a marxist just because
I feel, myself to be a one hundred percent revolutionary . . . On returning
from exile in France in the days of Primo de Rivera . . . I have been a
defender of the CNT and the FAI ever since. In spite of my paralysis, I have
done time in prison and been taken in manacles to Madrid for my fervent and
steadfast championship of our organisations and for fighting those who once
were friends of mine Is that not enough? . . . So where is this marxism of
mine? Is it because my roots are not in the factory? . . . The time has come
to clarify my position. It is not good enough to say that the matter has
already been agreed. The truth must shine through. As far as I am concerned, I
call upon all the comrades who have used the press to hang this label upon me
to spell out what makes me a marxist."_ [**El Amigo del Pueblo**, no. 4, p. 3]

As can be seen, the FoD were not Marxists. Two more questions arise. Were they
a "break" with anarchism (i.e. moving towards Marxism) and were they
influenced by the Spanish Trotskyists. We turn to these questions in the next
two sections.

## 8\. Did the Friends of Durruti _"break with"_ anarchism?

Morrow claims that the Friends of Durruti (FoD) _"represented a conscious
break with the anti-statism of traditional anarchism. They explicitly declared
the need for democratic organs of power, juntas or soviets, in the overthrow
of capitalism."_ [Morrow, **Op. Cit.**, p. 247] The truth of the matter is
somewhat different.

Before discussing his assertion in more detail a few comments are required.
Typically, in Morrow's topsy-turvy world, all anarchists like the Friends of
Durruti (Morrow also includes the Libertarian Youth, the _"politically
awakened"_ CNT rank and file, local FAI groups, etc.) who remained true to
anarchism and stuck to their guns (often literally) -- represented a break
with anarchism and a move towards Marxism, the revolutionary vanguard party
(no doubt part of the 4th International), and a fight for the "workers state."
Those anarchists, on the other hand, who compromised for "anti-fascist unity"
(but mainly to try and get weapons to fight Franco) are the real anarchists
because _"class collaboration . . . lies concealed in the heart of anarchist
philosophy."_ [**Op. Cit.**, p. 101]

Morrow, of course, would have had a fit if anarchists pointed to the example
of the Social Democrat's who crushed the German Revolution or Stalin's Russia
as examples that "rule by an elite lies concealed in the heart of Marxist
philosophy." It does not spring into Morrow's mind that those anarchists he
praises are the ones who show the revolutionary heart of anarchism. This can
best be seen from his comments on the Friends of Durruti, who we argue were
not evolving towards "Marxism" but rather were trying to push the CNT and FAI
back to its pre-Civil War politics and strategy. Moreover, as we argue in
[section 12](append32.md#app12), anarchism has always argued for self-
managed working class organisations to carry out and defend a revolution. The
FoD were simply following in the tradition founded by Bakunin.

In other words, we will show that they did not _"break with"_ anarchism --
rather they refused to compromise their anarchism in the face of "comrades"
who thought winning the war meant entering the government. This is clear from
their leaflets, paper and manifesto. Moreover, as will become obvious, their
"break" with anarchism actually just restates pre-war CNT policy and
organisation.

For example, their leaflets, in April 1937, called for the unions and
municipalities to _"replace the state"_ and for no retreat:

> _"We have the organs that must supplant a State in ruins. The Trade Unions
and Municipalities must take charge of economic and social life."_ [quoted by
Agustin Guillamon, **Op. Cit.**, p. 38]

This clearly is within the CNT and anarcho-syndicalist tradition. Their
manifesto, in 1938, repeated this call (_"the state cannot be retained in the
face of the unions"_), and made three demands as part of their programme. It
is worth quoting these at length:

> _"I - Establishment of a Revolutionary Junta or National Defence Council.  
>  _

>

> _"This body will be organised as follows: members of the revolutionary Junta
will be elected by democratic vote in the union organisations. Account is to
be taken of the number of comrades away at the front . . . The Junta will
steer clear of economic affairs, which are the exclusive preserve of the
unions. _

>

> _"The functions of the revolutionary Junta are as follows: _

>

> _ "a) The management of the war  
>  "b) The supervision of revolutionary order  
>  "c) International affairs  
>  "d) Revolutionary propaganda.  
>  _

>

> _"Posts to come up regularly for re-allocation so as to prevent anyone
growing attached to them. And the trade union assemblies will exercise control
over the Junta's activities. _

>

> _"II - All economic power to the syndicates. _

>

> _"Since July the unions have supplied evidence of the great capacity for
constructive labour. . . It will be the unions that structure the proletarian
economy. _

>

> _"An Economic Council may also be set up, taking into consideration the
natures of the Industrial Unions and Industrial federations, to improve on the
co-ordination of economic activities. _

>

> _"III - Free municipality. _

>

> _[...] _

>

> _"The Municipality shall take charge of those functions of society that fall
outside the preserve of the unions. And since the society we are going to
build shall be composed exclusively of producers, it will be the unions, no
less, that will provide sustenance for the municipalities. . . _

>

> _"The Municipalities will be organised at the level of local, comarcal and
peninsula federations. Unions and municipalities will maintain liaison at
local, comarcal and national levels."_ [**Towards a Fresh Revolution**]

This programme basically mimics the pre-war CNT policy and organisation and so
cannot be considered as a _"break"_ with anarchist or CNT politics or
tradition.

Firstly, we should note that the _"municipality"_ was a common CNT expression
to describe a _"commune"_ which was considered as _"all the residents of a
village or hamlet meeting in assembly (council) with full powers to administer
and order local affairs, primarily production and distribution."_ In the
cities and town the equivalent organisation was _"the union"_ which _"brings
individuals together, grouping them according to the nature of their work . .
. First, it groups the workers of a factory, workshop or firm together, this
being the smallest cell enjoying autonomy with regard to whatever concerns it
alone . . . The local unions federate with one another, forming a local
federation, composed of the committee elected by the unions, and of the
general assembly that, in the last analysis, holds supreme sovereignty."_
[Issac Puente, **Libertarian Communism**, p. 25 and p. 24]

In addition, the _"national federations [of unions] will hold as common
property the roads, railways, buildings, equipment, machinery and workshops"_
and the _"free municipality will federate with its counterparts in other
localities and with the national industrial federations."_ [**Op. Cit.**, p.
29 and p. 26] Thus Puente's classic pre-war pamphlet is almost identical to
points two and three of the FoD Programme.

Moreover, the _"Economic Council"_ urged by the FoD in point two of their
programme is obviously inspired by the work of Abad Diego de Santillan,
particularly his book **After the Revolution** (**El Organismo Economico de la
Revolucion**). Discussing the role of the _"Federal Council of Economy"_, de
Santillan says that it _"receives its orientation from below and operates in
accordance with the resolutions of the regional and national assemblies."_ [p.
86] Just as the CNT Congresses were the supreme policy-making body in the CNT
itself, they envisioned a similar body emanating from the rank-and-file
assemblies to make the guiding decisions for a socialised economy.

This leaves point one of their programme, the call for a _"Revolutionary Junta
or National Defence Council."_ It is here that Morrow and a host of other
Marxists claim the FoD broke with anarchism towards Marxism. Nothing could be
further from the truth.

Firstly, anarchists have long supported the idea of workers' councils (or
soviets) as an expression of working class power to control their own lives
(and so society) -- indeed, far longer than Marxists. Thus we find Bakunin
arguing that the _"future social organisation must be made solely from the
bottom up, by the free association or federation of workers, firstly in their
unions, then in the communes, regions, nations and finally in a great
federation, international and universal."_ Anarchists _"attain this goal . . .
by the development and organisation, not of the political but of the social
(and, by consequence, anti-political) power of the working masses."_
[**Michael Bakunin: Selected Writings**, p. 206 and p. 198] These councils of
workers' delegates (workers' councils) would be the basis of the commune and
defence of the revolution:

> _"the federative Alliance of all working men's associations . . . constitute
the Commune . . .. Commune will be organised by the standing federation of the
Barricades. . . [T]he federation of insurgent associations, communes and
provinces . . . [would] organise a revolutionary force capable of defeating
reaction . . . it is the very fact of the expansion and organisation of the
revolution for the purpose of self-defence among the insurgent areas that will
bring about the triumph of the revolution."_ [**Op. Cit.**, pp. 170-1]

This perspective can be seen in the words of the German anarcho-syndicalist H.
Ruediger (member of the IWA's secretariat in 1937) when he argued that for
anarchists _"social re-organisation, like the defence of the revolution,
should be concentrated in the hands of **working class organisations** \--
whether labour unions or new organs of spontaneous creation, such as free
councils, etc., which, as an expression of the will of the workers themselves,
from **below up**, should construct the revolutionary social community."_
[quoted in **The May Days in Barcelona**, Vernon Richards (ed.), p. 71]

Camillo Berneri sums up the anarchist perspective clearly when he wrote:

> _"The Marxists . . . foresee the natural disappearance of theState as a
consequence of the destruction of classes by the means of 'the dictatorship of
the proletariat,' that is to say State Socialism, whereas the Anarchists
desire the destruction of the classes by means of a social revolution which
eliminates, with the classes, the State. The Marxists, moreover, do not
propose the armed conquest of the Commune by the whole proletariat, but the
propose the conquest of the State by the party which imagines that it
represents the proletariat. The Anarchists allow the use of direct power by
the proletariat, but they understand by the organ of this power to be formed
by the entire corpus of systems of communist administration -- corporate
organisations [i.e. industrial unions], communal institutions, both regional
and national -- freely constituted outside and in opposition to all political
monopoly by parties and endeavouring to a minimum administrational
centralisation."_ [_"Dictatorship of the Proletariat and State Socialism"_,
**Cienfuegos Press Anarchist Review**, no. 4, p. 52]

In other words, anarchists **do** support democratic organs of power when they
are **directly** democratic (i.e. self-managed). _"The basic idea of Anarchism
is simple,"_ argued Voline, _"no party . . . placed above or outside the
labouring masses . . . ever succeeds in emancipating them . . . Effective
emancipation can only be achieved by the **direct, widespread, and independent
action of those concerned, of the workers themselves**, grouped, not under the
banner of a political party . . . but in their own class organisations
(productive workers' unions, factory committees, co-operatives, et cetra) on
the basis of concrete action and self-government."_ [**The Unknown
Revolution**, p, 197]

Anarchists oppose **representative** organs of power as these are governments
and so based on minority power and subject to bureaucratic deformations which
ensure **un**-accountablity from below. Anarchists argue _"that, by its very
nature, political power could not be exercised except by a very restricted
group of men at the centre. Therefore this power -- the **real** power --
could not belong to the soviets. It would actually be in the hands of the
party."_ [Voline, **Op. Cit.**, p. 213]

Thus Morrow's argument is flawed on the basic point that he does not
understand anarchist theory or the nature of an anarchist revolution (also see
[ section 12](append32.md#app12)).

Secondly, and more importantly given the Spanish context, the FoD's vision has
a marked similarity to pre-Civil War CNT organisation, policy and vision. This
means that the idea of a National Defence Council was not the radical break
with the CNT that some claim. Before the civil war the CNT had long has its
defence groups, federated at regional and national level. Historian Jerome
Mintz provides a good summary:

> _"The policies and actions of the CNT were conducted primarily by
administrative juntas, beginning with the sindicato, whose junta consisted of
a president, secretary, treasurer, and council members. At each step in the
confederation, a representative [sic! -- delegate] was sent to participate at
the next organisational level -- from sindicato to the district to the
regional confederation, then to the national confederation. In addition to the
juntas, however, there were two major committee systems established as
adjuncts to the juntas that had developed some autonomy: the **comites pro
presos**, or committees for political prisoners, which worked for the release
of prisoners and raised money for the relief of their families; and the
**comites de defensa**, or defence committees, whose task was to stockpile
weapons for the coming battle and to organise the shock troops who would bear
the brunt of the fighting."_ [**The Anarchists of Casas Viejas**, p. 141]

Thus we see that the CNT had its _"juntas"_ (which means council or committee
and so does not imply any authoritarianism) as well as _"defence committees"_
which were elected by democratic vote in the union organisations decades
before the FoD existed. The Defence Committees (or councils) were a CNT
insurgent agency in existence well before July 1936 and had, in fact, played a
key role in many insurrections and strikes, including the events of July 1936.
In other words, the _"break"_ with anarchism Morrow presents was, in fact, an
exact reproduction of the way the CNT had traditionally operated and acted --
it is the same program of a _"workers defence council"_ and _"union management
of the economy"_ that the CNT had advocated prior to the outbreak of the Civil
War. The only _"break"_ that **did** occur post 19th of July was that of the
CNT and FAI ignoring its politics and history in favour of "anti-fascist
unity" and a UGT "Workers' Alliance" with all anti-fascist unions and parties
(see [section 20](append32.md#app20)).

Moreover, the CNT insurrection of December 1933 had been co-ordinated by a
National Revolutionary Committee [**No Gods, No Masters**, vol. 2, p. 235].
D.A. Santillan argued that the _"local Council of Economy will assume the
mission of defence and raise voluntary corps for guard duty and if need be,
for combat"_ in the _"cases of emergency or danger of a counter-revolution."_
[**After the Revolution**, p. 80] During the war itself a CNT national plenum
of regions, in September 1936, called for a National Defence Council, with
majority union representation and based on Regional Defence Councils. The
Defence Council of Aragon, set up soon after, was based on these ideas. The
need for co-ordinated revolutionary defence and attack is just common sense --
and had been reflected in CNT theory, policy and structure for decades.

An understanding of the basic ideas of anarchist theory on revolution combined
with the awareness of the CNT's juntas (administrative councils or committees)
had _"defence committees"_ associated with them makes it extremely clear that
rather than being a _"conscious break with the anti-statism of traditional
anarchism"_ the FoD's programme was, in fact, a conscious **return** to the
anti-statism of traditional anarchism and the revolutionary program and vision
of the pre-Civil War CNT.

This is confirmed if we look at the activities of the CNT in Aragon where they
formed the _"Defence Council of Aragon"_ in September 1936. In the words of
historian Antony Beevor, _"[i]n late September delegates from the Aragonese
collectives attended a conference at Bujaraloz, near where Durruti's column
was based. They decided to establish a Defence Council of Aragon, and elected
as president Joaquin Ascaso."_ [**Op. Cit.**, p. 96] In February 1937, the
first congress of the regional federation of collectives was held at Caspe to
co-ordinate the activities of the collectives -- an obvious example of a
regional economic council desired by the FoD. Morrow does mention the Council
of Aragon -- _"the anarchist-controlled Council for the Defence of Aragon"_
[**Op. Cit.**, p. 111] -- however, he strangely fails to relate this fact to
anarchist politics. After all, in Aragon the CNT-FAI remained true to
anarchism, created a defence council and a federation of collectives. If
Morrow had discussed the events in Aragon he would have had to draw the
conclusion that the FoD were not a _"conscious break with the traditional
anti-statism of anarchism"_ but rather were an expression of it.

This can be seen from the comments made after the end of the war by the
Franco-Spanish Group of **The Friends of Durruti**. They clearly argued for a
return to the principles of anarchism and the pre-war CNT. They argued not
only for workers' self-organisation and self-management as the basis of the
revolution but also to the pre-war CNT idea of a workers' alliance from the
bottom up rather than a UGT-style one at the top (see [section
5](append32.md#app5)). In their words:

> _"A revolution requires the absolute domination of the workers'
organisations as was the case in July, 1936, when the CNT-FAI were masters . .
. We incline to the view that it is necessary to form a Revolutionary
Alliance; a Workers' Front; where no one would be allowed to enter and take
their place except on a revolutionary basis . . . "_ [**The Friends of Durruti
Accuse**]

As can be seen, rather than a "revolutionary government" the FoD were
consistently arguing for a federation of workers' associations as the basis of
the revolution. In this they were loyally following Bakunin's basic arguments
and the ideas of anarchism. Rather than the FoD breaking with anarchism, it is
clear that it was the leading committees of the CNT and FAI which actually
broke with the politics of anarchism and the tactics, ideas and ideals of the
CNT.

Lastly there are the words of Jaime Balius, one of the FoD's main activists,
who states in 1976 that:

> _"We did not support the formation of Soviets; there were no grounds in
Spain for calling for such. We stood for 'all power to the trade unions'. In
no way were we politically orientated . . . Ours was solely an attempt to save
the revolution; at the historical level it can be compared to Kronstadt
because if there the sailors and workers called for 'all power to the
Soviets', we were calling for all power to the unions."_ [quoted by Ronald
Fraser, **Blood of Spain**, p. 381]

_"Political"_ here meaning "state-political" -- a common anarchist use of the
word. According to Fraser, the _"proposed revolutionary junta was to be
composed of combatants from the barricades."_ [**Ibid.**] This echoes
Bakunin's comment that the _"Commune will be organised by the standing
federation of the Barricades and by the creation of a Revolutionary Communal
Council composed of one or two delegates from each barricade . . . vested with
plenary but accountable and removable mandates."_ [**Op. Cit.**, pp. 170-1]

As can be seen, rather than calling for power to a party or looking to form a
government (i.e. being _"politically orientated"_) the FoD were calling for
_"all power to the unions."_ This meant, in the context of the CNT, all power
to the union assemblies in the workplace. Decision making would flow from the
bottom upwards rather than being delegated to a "revolutionary" government as
in Trotskyism. To stress the point, the FoD did not represent a _"break"_ with
anarchism or the CNT tradition. To claim otherwise means to misunderstand
anarchist politics and CNT history.

Our analysis, we must note, also makes a mockery of Guillamon's claim that
because the FoD thought that libertarian communism had to be _"impose[d]"_ and
_"defended by force of arms"_ their position represented an _"evolution within
anarchist thought processes."_ [**Op. Cit.**, p. 95] As has been made clear
above, from Bakunin onwards revolutionary anarchism has been aware of the need
for an insurrection to create an anarchist society by destroying both the
state and capitalism (i.e. to _"impose"_ a free society upon those who wish
hierarchy to continue and are in a position of power) and for that revolution
to be defended against attempts to defeat it. Similarly, his claim that the
FoD's _"revolutionary junta"_ was the equivalent of what _"others call the
vanguard or the revolutionary party"_ cannot be defended given our discussion
above -- it is clear that the junta was not seen as a form of delegated power
by rather as a means of defending the revolution like the CNT's defence
committees and under the direct control of the union assemblies.

It may be argued that the FoD did not actually mean this sort of structure.
Indeed, their manifesto states that they are _"introducing a slight variation
in anarchism into our program. The establishment of a Revolutionary Junta."_
Surely this implies that they saw themselves as having moved away from
anarchism and CNT policy? As can be seen from Balius' comments during and
after the revolution, the FoD were arguing for _"all power to the unions"_ and
stating that _"apolitical anarchism had failed."_ However, _"apolitical"_
anarchism came about post-July 19th when the CNT-FAI (ignoring anarchist
theory and CNT policy and history) **ignored** the state machine rather than
destroying it and supplanting it with libertarian organs of self-management.
The social revolution that spontaneously occurred after July 19th was
essentially economic and social (i.e. _"apolitical"_) and not _"anti-
political"_ (i.e. the destruction of the state machine). Such a revolution
would soon come to grief on the shores of the (revitalised) state machine --
as the FoD correctly argued had happened.

To state that they had introduced a variation into their anarchism makes sense
post-July 1936. The _"apolitical"_ line of the CNT-FAI had obviously failed
and a new departure was required. While it is clear that the FoD's "new"
position was nothing of the kind, it was elemental anarchist principles, it
was "new" in respect to the policy the CNT ("anarchism") had conducted during
the Civil War -- a policy they justified by selective use of anarchist theory
and principles. In the face of this, the FoD could claim they were presenting
a new variation in spite of its obvious similarities to pre-war CNT policies
and anarchist theory. Thus the claim that the FoD saw their ideas as some sort
of departure from traditional anarchism cannot be maintained, given the
obvious links this "new" idea had with the past policies and structure of the
CNT. As Guillamon makes it clear, the FoD made _"their stand within the
organisation and upon anarcho-syndicalist ideology"_ and _"[a]t all times the
Group articulated an anarcho-syndicalist ideology, although it also voiced
radical criticism of the CNT and FAI leadership. But it is a huge leap from
that to claiming that the Group espoused marxist positions."_ [**Op. Cit.**,
p. 61 and p. 95]

One last comment. Morrow states that the _"CNT leadership . . . expelled the
Friends of Durruti"_ [**Op. Cit.**, p. 189] This is not true. The CNT
leadership did **try** to expel the FoD. However, as Balius points out, the
_"higher committees order[ed] our expulsion, but this was rejected by the rank
and file in the trade union assemblies and at a plenum of FAI groups held in
the Casa CNT-FAI."_ [quoted by Agustin Guillamon, **Op. Cit.**, p. 73] Thus
the CNT leadership could never get their desire ratified by any assembly of
unions or FAI groups. Unfortunately, Morrow gets his facts wrong (and also
presents a somewhat false impression of the relationship of the CNT leadership
and the rank and file).

## 9\. Were the Friends of Durruti influenced by Trotskyists?

Morrow implies that the Bolshevik-Leninists _"established close contacts with
the anarchist workers, especially the 'Friends of Durruti'"_ [**Op. Cit.**, p.
139] The truth, as usual, is somewhat different.

To prove this we must again turn to Guillamon's work in which he dedicates a
chapter to this issue. He brings this chapter by stating:

> _"It requires only a cursory perusal of **El Amigo del Pueblo** or Balius's
statements to establish that the Friends of Durruti were never marxists, nor
influenced at all by the Trotskyists or the Bolshevik-Leninist Section. But
there is a school of historians determined to maintain the opposite and hence
the necessity for this chapter."_ [**Op. Cit.**, p. 94]

He stresses that the FoD _"were not in any way **beholden** to Spanish
Trotskyism is transparent from several documents"_ and notes that while the
POUM and Trotskyists displayed _"an interest"_ in _"bringing the Friends of
Durruti under their influence"_ this was _"something in which they never
succeeded."_ [**Op. Cit.**, p. 96 and p. 110]

Pre-May, 1937, Balius himself states that the FoD _"had no contact with the
POUM, nor with the Trotskyists."_ [**Op. Cit.**, p. 104] Post-May, this had
not changed as witness E. Wolf letter to Trotsky in July 1937 which stated
that it _"will be impossible to achieve any collaboration with them . . .
Neither the POUMists nor the Friends would agree to the meeting [to discuss
joint action]."_ [**Op. Cit.**, pp. 97-8]

In other words, the Friends of Durruti did not establish _"close contacts"_
with the Bolshevik-Leninists after the May Days of 1937. While the Bolshevik-
Leninists may have wished for such contacts, the FoD did not (they probably
remembered their fellow anarchists and workers imprisoned and murdered when
Trotsky was in power in Russia). They were, of course, contacts of a limited
kind but no influence or significant co-operation. Little wonder Balius stated
in 1946 that the _"alleged influence of the POUM or the Trotskyists upon us is
untrue."_ [quoted, **Op. Cit.**, p. 104]

It is hardly surprising that the FoD were not influenced by Trotskyism. After
all, they were well aware of the policies Trotsky introduced when he was in
power. Moreover, the program of the Bolshevik-Leninists was similar in
rhetoric to the anarchist vision -- they differed on the question of whether
they actually **meant** _"all power to the working class"_ or not (see section
[12](append32.md#app12) and [13](append32.md#app13)). And, of course, the
Trotskyists activities during the May Days amounted to little more that
demanding that the workers' do what they were already doing (as can be seen
from the leaflet they produced -- as George Orwell noted, _"it merely demanded
what was happening already"_ [**Homage to Catalonia**, p. 221]). As usual, the
"vanguard of the proletariat" were trying to catch up with the proletariat.

In theory and practice the FoD were miles ahead of the Bolshevik-Leninists --
as to be expected, as the FoD were anarchists.

## 10\. What does the Friends of Durruti's programme tell us about Trotskyism?

Morrow states that the FoD's _"slogans included the essential points of a
revolutionary program: all power to the working class, and democratic organs
of the workers, peasants and combatants, as the expression of the workers'
power."_ [**Op. Cit.**, p. 133] It is useful to compare Leninism to these
points to see if that provides a revolutionary program.

Firstly, as we argue in more detail in [section 11](append32.md#app11),
Trotsky abolished the democratic organs of the Red Army. Lenin's rule also saw
the elimination of the factory committee movement and its replacement with
one-man management appointed from above (see [section 17](append32.md#app17)
and Maurice Brinton's **The Bolsheviks and Workers' Control** for details).
Both these events occurred before the start of the Russian Civil War in May
1918. Moreover, neither Lenin nor Trotsky considered workers' self-management
of production as a key aspects of socialism. On this level, Leninism in power
did not constitute a _"revolutionary program."_

Secondly, Leninism does **not** call for _"all power to the working class"_ or
even _"workers' power"_ to manage their own affairs. To quote Trotsky, in an
article written in 1937, _"the proletariat can take power only through its
vanguard."_ The working classes' role is one of supporting the party:

> _"Without the confidence of the class in the vanguard, without support of
the vanguard by the class, there can be no talk of the conquest of power.  
>  _

>

> _"In this sense the proletarian revolution and dictatorship are the work of
the whole class, but only under the leadership of the vanguard."_

Thus, rather than the working class as a whole seizing power, it is the
_"vanguard"_ which takes power -- _"a revolutionary party, even after seizing
power . . . is still by no means the sovereign ruler of society."_
[**Stalinism and Bolshevism**] So much for "workers' power" -- unless you
equate that with the "power" to give your power, your control over your own
affairs, to a minority who claim to represent you. Indeed, Trotsky even
attacks the idea that workers' can achieve power directly via organs of self-
management like workers' councils (or soviets):

> _"Those who propose the abstraction of the Soviets from the party
dictatorship should understand that only thanks to the party dictatorship were
the Soviets able to lift themselves out of the mud of reformism and attain the
state form of the proletariat."_ [**Op. Cit.**]

In other words, the dictatorship of the proletariat is, in fact, expressed by
_"the party dictatorship."_ In this Trotsky follows Lenin who asserted that:

> _"The very presentation of the question -- 'dictatorship of the Party **or**
dictatorship of the class, dictatorship (Party) of the leaders **or**
dictatorship (Party) of the masses?' -- is evidence of the most incredible and
hopeless confusion of mind . . . [because] classes are usually . . . led by
political parties. . . "_ [**Left-wing Communism: An Infantile Disorder**, pp.
25-6]

As has been made clear above, the FoD being anarchists aimed for a society of
generalised self-management, a system in which working people directly
controlled their own affairs and so society. As these words by Lenin and
Trotsky indicate they did not aim for such a society, a society based on _"all
power to the working class."_ Rather, they aimed for a society in which the
workers would delegate their power into the hands of a few, the revolutionary
party, who would exercise power **on their behalf.** The FoD meant exactly
what they said when they argued for _"all power to the working class"_ \--
they did not mean this as a euphemism for party rule. In this they followed
Bakunin:

> _"[T]he federated Alliance of all labour associations . . . will constitute
the Commune . . . there will be a federation of the standing barricades and a
Revolutionary Communal Council will operate on the basis of one or two
delegates from each barricade . . . these deputies being invested with binding
mandates and accountable and revocable at all times. . . An appeal will be
issued to all provinces, communes and associations inviting them to follow the
example set . . . [and] to reorganise along revolutionary lines . . . and to
then delegate deputies to an agreed place of assembly (all of those deputies
invested with binding mandates and accountable and subject to recall), in
order to found the federation of insurgent associations, communes and
provinces . . . Thus it is through the very act of extrapolation and
organisation of the Revolution with an eye to the mutual defences of insurgent
areas that the . . . Revolution, founded upon . . . the ruins of States, will
emerge triumphant. . .  
>  _

>

> _"Since it is the people which must make the revolution everywhere, and
since the ultimate direction of it must at all times be vested in the people
organised into a free federation of agricultural and industrial organisations
. . . being organised from the bottom up through revolutionary delegation . .
."_ [**No God, No Masters**, vol. 1, pp. 155-6]

And:

> _"Not even as revolutionary transition will we countenance national
Conventions, nor Constituent Assemblies, nor provisional governments, nor so-
called revolutionary dictatorships: because we are persuaded that revolution s
sincere, honest and real only among the masses and that, whenever it is
concentrated in the hands of a few governing individuals, it inevitably and
immediately turns into reaction."_ [**Op. Cit.**, p. 160]

As can be seen, Bakunin's vision is precisely, to use Morrow' words, _"all
power to the working class, and democratic organs of the workers, peasants and
combatants, as the expression of the workers' power."_ Thus the Friends of
Durruti's program is not a _"break"_ with anarchism (as we discussed in more
detail in [section 8](append32.md#app8)) but rather in the tradition started
by Bakunin -- in other words, an anarchist program. It is Leninism, as can be
seen, which rejects this _"revolutionary program"_ in favour of all power to
the representatives of the working class (i.e. party) which it confuses with
the working class as a whole.

Given that Morrow asserts that _"all power to the working class"_ was an
_"essential"_ point of _"a revolutionary program"_ we can only conclude that
Trotskyism does not provide a revolutionary program -- rather it provides a
program based, at best, on representative government in which the workers'
delegate their power to a minority or, at worse, on party dictatorship
**over** the working class (the experience of Bolshevik Russia would suggest
the former quickly becomes the latter, and is justified by Bolshevik
ideology).

By his own arguments, here as in so many other cases, Morrow indicates that
Trotskyism is not a revolutionary movement or theory.

## 11\. Why is Morrow's comments against the militarisation of the Militias
ironic?

Morrow denounces the Stalinist militarisation of the militias (their
_"campaign for wiping out the internal democratic life of the militias"_) as
follows:

> _"The Stalinists early sought to set an 'example' by handing their militias
over to government control, helping to institute the salute, supremacy of
officers behind the lines, etc. . .  
>  _

>

> _"The example was wasted on the CNT masses . . . The POUM reprinted for
distribution in the militias the original Red Army Manual of Trotsky,
providing for a democratic internal regime and political life in the army."_
[**Op. Cit.**, p. 126]

Morrow states that he supported the _"democratic election of soldiers'
committees in each unit, centralised in a national election of soldiers'
delegates to a national council."_ Moreover, he attacks the POUM leadership
because it _"**forbade** election of soldiers' committees"_ and argued that
the _"simple, concrete slogan of elected soldier's committees was the only
road for securing proletariat control of the army."_ He attacks the POUM
because its _"ten thousand militiamen were controlled bureaucratically by
officials appointed by the Central Committee of the party, election of
soldiers' committees being expressly forbidden."_ [**Op. Cit.**, p. 127, p.
128 and pp. 136-7]

Again, Morrow is correct. A revolutionary working class militia **does**
require self-management, the election of delegates, soldiers' councils and so
on. Bakunin, for example, argued that the fighters on the barricades would
take a role in determining the development of the revolution as the _"Commune
will be organised by the standing federation of the Barricades . . . composed
of one or two delegates from each barricade . . . vested with plenary but
accountable and removable mandates."_ This would complement _"the federative
Alliance of all working men's [and women's] associations . . . which will
constitute the Commune."_ [**Michael Bakunin: Selected Writings**, pp. 170-1]
That is **exactly** why the CNT militia organised in this fashion (and, we
must note, they were only applying the organisational principles of the CNT
and FAI -- i.e. anarchism -- to the militias). The militia columns were
organised in a libertarian fashion from the bottom up:

> _"The establishment of war committees is acceptable to all confederal
militias. We start from the individual and form groups of ten, which come to
accommodations among themselves for small-scale operations. Ten such groups
together make up one centuria, which appoints a delegate to represent it.
Thirty centurias make up one column, which is directed by a war committee, on
which the delegates from the centurias have their say. . . although every
column retains its freedom of action, we arrive at co-ordination of forces,
which is not the same thing as unity of command."_ [**No Gods, No Masters**,
vol. 2, pp. 256-7]

In other words, Morrow is arguing for an **anarchist** solution to the problem
of defending the revolution and organising those who were fighting fascism. We
say anarchist for good reason. What is ironic about Morrow's comments and
description of _"workers' control of the army"_ is that these features were
**exactly** those eliminated by Trotsky when he created the Red Army in 1918!
Indeed, Trotsky acted in **exactly** the same way as Morrow attacks the
Stalinists for acting (and they used many of the same arguments as Trotsky did
to justify it).

As Maurice Brinton correctly summarises:

> _"Trotsky, appointed Commissar of Military Affairs after Brest-Litovsk, had
rapidly been reorganising the Red Army. The death penalty for disobedience
under fire had been restored. So, more gradually, had saluting, special forms
of address, separate living quarters and other privileges for officers.
Democratic forms of organisation, including the election of officers, had been
quickly dispensed with."_ [**The Bolsheviks and Workers' Control**, p. 37]

He notes that _"[f]or years, Trotskyist literature has denounced these
reactionary facets of the Red Army as examples of what happened to it 'under
Stalinism.'"_ [**Op. Cit.**, p. 37f] This claim was, amazingly enough, also
made by Trotsky himself. In 1935 he re-wrote history by arguing that _"[i]n
the fire of the cruel struggle [of the Civil War], there could not be even a
question of a privileged position for officers: the very word was scrubbed out
of the vocabulary."_ Only _"after the victories had been won and the passage
made to a peaceful situation"_ did _"the military apparatus"_ try to _"become
the most influential and privileged part of the whole bureaucratic apparatus"_
with _"the Stalinist bureaucracy . . . gradually over the succeeding ten to
twelve years"_ ensuring for them _"a superior position"_ and giving them
_"ranks and decorations."_ [**How Did Stalin Defeat the Opposition?**]

In fact, _"ranks and decorations"_ and _"superior"_ positions were introduced
by Trotsky **before** the outbreak of the Civil War in May 1918. Having been
responsible for such developments you would think he would remember them!

On March 28th, 1918, Trotsky gave a report to the Moscow City Conference of
the Communist Party. In this report he stated that _"the principle of election
is politically purposeless and technically inexpedient, and it has been, in
practice, abolished by decree"_ and that the Bolsheviks _"fac[ed] the task of
creating a regular Army."_ Why the change? Simply because the Bolshevik Party
held power (_"political power is in the hands of the same working class from
whose ranks the Army is recruited"_). Of course, power was actually held by
the Bolshevik party, not the working class, but never fear:

> _"Once we have established the Soviet regime, that is a system under which
the government is headed by persons who have been directly elected by the
Soviets of Workers', Peasants' and Soldiers' Deputies, there can be no
antagonism between the government and the mass of the workers, just as there
is no antagonism between the administration of the union and the general
assembly of its members, and, therefore, there cannot be any grounds for
fearing the **appointment** of members of the commanding staff by the organs
of the Soviet Power."_ [**Work, Discipline, Order**]

Of course, most workers' are well aware that the administration of a trade
union usually works against them during periods of struggle. Indeed, so are
most Trotskyists as they often denounce the betrayals by that administration.
Thus Trotsky's own analogy indicates the fallacy of his argument. Elected
officials do not necessary reflect the interests of those who elected them.
That is why anarchists have always supported **delegation** rather than
representation combined with decentralisation, strict accountability and the
power of instant recall. In a highly centralised system (as created by the
Bolsheviks and as exists in most social democratic trade unions) the ability
to recall an administration is difficult as it requires the agreement of
**all** the people. Thus there are quite a few grounds for fearing the
appointment of commanders by the government -- no matter which party makes it
up.

If, as Morrow argues, the _"simple, concrete slogan of elected soldier's
committees was the only road for securing proletariat control of the army"_
then Trotsky's regime in the Red Army ensured the defeat of proletarian
control of that organisation. The question Morrow raises of who would control
the army, the working class or the bourgeois failed to realise the real
question -- who was to control the army, the working class, the bourgeois or
the state bureaucracy. Trotsky ensured that it would be the latter.

Hence Morrow's own arguments indicate the anti-revolutionary nature of
Trotskyism -- unless, of course, we decide to look only at what people say and
not what they do.

Of course some Trotskyists know what Trotsky actually did when he held power
and try and present apologetics for his obvious destruction of soldiers'
democracy. One argues that the _"Red Army, more than any other institution of
the civil war years, embodied the contradiction between the political
consciousness and circumstantial coercion. On the one hand the creation of a
Red Army was a retreat: it was a conscripted not a voluntary army; officers
were appointed not elected . . . But the Red Army was also filled with a
magnificent socialist consciousness."_ [John Rees, _"In Defence of October"_,
**International Socialism**, no. 52, pp. 3-82, p. 46]

This argument is somewhat weak for two reasons.

Firstly, the regressive features of the Red Army appeared **before** the start
of the Civil War. It was a political decision to organise in this way, a
decision **not justified at the time in terms of circumstantial necessity**.
Indeed, far from it (like most of the other Bolshevik policies of the period).
Rather it was justified under the rather dubious rationale that workers did
not need to fear the actions of a workers' state. Circumstances were not
mentioned at all nor was the move considered as a retreat or as a defeat. It
was not even considered as a matter of principle.

This perspective was reiterated by Trotsky after the end of the Civil War.
Writing in 1922, he argued that:

> _"There was and could be no question of controlling troops by means of
elected committees and commanders who were subordinate to these committees and
might be replaced at any moment . . . [The old army] had carried out a social
revolution within itself, casting aside the commanders from the landlord and
bourgeois classes and establishing organs of revolutionary self-government, in
the shape of the Soviets of Soldiers' Deputies. These organisational and
political measures were correct and necessary from the standpoint of breaking
up the old army. But a new army capable of fighting could certainly not grow
directly out of them . . . The attempt made to apply our old organisational
methods to the building of a Red Army threatened to undermine it from the very
outset . . . the system of election could in no way secure competent, suitable
and authoritative commanders for the revolutionary army. The Red Army was
built from above, in accordance with the principles of the dictatorship of the
working class. Commanders were selected and tested by the organs of the Soviet
power and the Communist Party. Election of commanders by the units themselves
-- which were politically ill-educated, being composed of recently mobilised
young peasants -- would inevitably have been transformed into a game of
chance, and would often, in fact, have created favourable circumstances for
the machinations of various intriguers and adventurers. Similarly, the
revolutionary army, as an army for action and not as an arena of propaganda,
was incompatible with a regime of elected committees, which in fact could not
but destroy all centralised control."_ [**The Path of the Red Army**]

If a _"circumstantial"_ factor exists in this rationale, it is the claim that
the soldiers were _"politically ill-educated."_ However, **every** mass
movement or revolution **starts** with those involved being _"politically ill-
educated."_ The very process of struggle educates them politically. A key part
of this radicalisation is practising self-management and self-organisation --
in other words, in participating in the decision making process of the
struggle, by discussing ideas and actions, by hearing other viewpoints,
electing and mandating delegates. To remove this ensures that those involved
**remain** _"politically ill-educated"_ and, ultimately, incapable of self-
government. It also contains the rationale for continuing party dictatorship:

> _"If some people . . . have assumed the right to violate everybody's freedom
on the pretext of preparing the triumph of freedom, they will always find that
the people are not yet sufficiently mature, that the dangers of reaction are
ever-present, that the education of the people has not yet been completed. And
with these excuses they will seek to perpetuate their own power."_ [Errico
Malatesta, **Life and Ideas**, p. 52]

In addition, Trotsky's rationale refutes any claim that Bolshevism is somehow
"fundamentally" democratic. The ramifications of it were felt everywhere in
the soviet system as the Bolsheviks ignored the "wrong" democratic decisions
made by the working masses and replaced their democratic organisations with
appointees from above. Indeed, Trotsky admits that the _"Red Army was built
from above, in accordance with the principles of the dictatorship of the
working class."_ Which means, to state the obvious, appointment from above,
the dismantling of self-government, and so on are _"in accordance with the
principles"_ of Trotskyism. These comments were not made in the heat of the
civil war, but afterward during peacetime. Notice Trotsky admits that a
_"social revolution"_ had swept through the Tsarist army. His actions, he also
admits, reversed that revolution and replaced its organs of _"self-
government"_ with ones identical to the old regime. When that happens it is
usually called by its true name, namely **counter**-revolution.

For a Trotskyist, therefore, to present themselves as a supporter of self-
managed militias is the height of hypocrisy. The Stalinists repeated the same
arguments used by Trotsky and acted in exactly the same way in their campaign
against the CNT and POUM militias. Certain acts have certain ramifications, no
matter who does them or under what government. In other words, abolishing
democracy in the army will generate autocratic tendencies which will undermine
socialistic ones **no matter who does it.** The same means cannot be used to
serve different ends as there is an intrinsic relationship between the
instruments used and the results obtained -- that is why the bourgeoisie do
not encourage democracy in the army or the workplace! Just as the capitalist
workplace is organised to produce proletarians and capital along with cloth
and steel, the capitalist army is organised to protect and reinforce minority
power. The army and the capitalist workplace are not simply means or neutral
instruments. Rather they are social structures which generate, reinforce and
**protect** specific social relations. This is what the Russian masses
instinctively realised and conducted a social-revolution in both the army and
workplace to **transform** these structures into ones which would enhance
rather than crush freedom and working class autonomy. The Bolsheviks reversed
these movements in favour of structures which reproduced capitalist social
relationships **and justified it in terms of "socialism."** Unfortunately,
capitalist means and organisations would only generate capitalist ends.

It was for these reasons that the CNT and its militias were organised from the
bottom up in a self-managed way. It was the only way **socialists** and a
socialist society could be created -- that is why anarchists are anarchists,
we recognise that a socialist (i.e. libertarian) society cannot be created by
authoritarian organisations. As the justly famous Sonvillier Circular argued
_"[h]ow could one expect an egalitarian society to emerge out of an
authoritarian organisation? It is impossible."_ [quoted by Brian Morris,
**Bakunin: The Philosophy of Freedom**, p. 61] Just as the capitalist state
cannot be utilised by the working class for its own ends, capitalist/statist
organisational principles such as appointment, autocratic management,
centralisation and delegation of power and so on cannot be utilised for social
liberation. They are not designed to be used for that purpose (and, indeed,
they were developed in the first place to stop it and enforce minority rule!).

In addition, to abolish democracy on the pretext that people are not ready for
it ensures that it will never exist. Anarchists, in contrast, argue that
_"[o]nly freedom or the struggle for freedom can be the school for freedom."_
[Malatesta, **Op. Cit.**, p. 59]

Secondly, how can a _"socialist consciousness"_ be encouraged, or continue to
exist, without socialist institutions to express it? Such a position is
idealistic nonsense, expressing the wishful notion that the social
relationships people experiences does not impact on those involved. In effect,
Rees is arguing that as long as the leaders have the "right ideas" it does not
matter how an organisation is structured. However, how people develop, the
ideas they have in their heads, are influenced by the relations they create
with each other -- autocratic organisations do not encourage self-management
or socialism, they produce bureaucrats and subjects.

An autocratic organisation **cannot** encourage a socialist consciousness by
its institutional life, only in spite of it. For example, the capitalist
workplace encourages a spirit of revolt and solidarity in those subject to its
hierarchical management and this is expressed in direct action -- by
**resisting** the authority of the boss. It only generates a socialist
perspective via resistance to it. Similarly with the Red Army. Education
programs to encourage reading and writing does not generate socialists, it
generates soldiers who are literate. If these soldiers do not have the
institutional means to manage their own affairs, a forum to discuss political
and social issues, then they remain order takers and any socialist conscious
will wither and die.

The Red Army was based on the fallacy that the structure of an organisation is
unimportant and it is the politics of those in charge that matter (Marxists
make a similar claim for the state, so we should not be too surprised).
However, it is no co-incidence that bourgeois structures are always
hierarchical -- self-management is a politically educational experience which
erodes the power of those in charge and transforms those who do it. It is to
stop this development, to protect the power of the ruling few, that the
bourgeois always turn to centralised, hierarchical structures -- they
reinforce elite rule. You cannot use the same form of organisation and expect
different results -- they are designed that way for a reason! To twitter on
about the Red Army being _"filled with a magnificent socialist consciousness"_
while justifying the elimination of the only means by which that consciousness
could survive, prosper and grow indicates a complete lack of socialist
politics and any understanding of materialist philosophy.

Moreover, one of the basic principles of the anarchist militia was equality
between all members. Delegates received the same pay, ate the same food, wore
the same clothes as the rest of the unit. Not so in the Red Army. Trotsky
thought, when he was in charge of it, that inequality was _"in some cases . .
. quite explicable and unavoidable"_ and that _"[e]very Red Army warrior fully
accepts that the commander of his unit should enjoy certain privileges as
regards lodging, means of transport and even uniform."_ [**More Equality!**]

Of course, Trotsky would think that, being the head commander of the Army.
Unfortunately, because soldier democracy had been abolished by decree, we have
no idea whether the rank and file of the Red Army agreed with him. For
Trotsky, privilege _"is, in itself, in certain cases, inevitable"_ but
_"**[o]stentatious indulgence** in privilege is not just evil, it is a
crime."_ Hence his desire for _"more"_ equality rather than equality -- to aim
for _"eliminating the most abnormal [!] phenomena, softening [!] the
inequality that exists"_ rather than abolish it as they did in the CNT
militias. [**Op. Cit.**]

But, of course, such inequalities that existed in the Red Army are to be
expected in an autocratically run organisation. The inequality inherent in
hierarchy, the inequality in power between the order giver and order taker,
will, sooner or later, be reflected in material inequality. As happened in the
Red Army (and all across the "workers' state"). All Trotsky wanted was for
those in power to be respectable in their privilege rather than showing it
off. The anarchist militias did not have this problem because being
libertarian, delegates were subject to recall and power rested with the rank
and file, **not** an elected government.

As another irony of history, Morrow quotes a Bolshevik-Leninist leaflet (which
_"points the road"_) as demanding _"[e]qual pay for officers and soldiers."_
[**Op. Cit.**, p. 191] Obviously these good Trotskyists had no idea what their
hero actually wrote on this subject or did when in power. We have to wonder
how long their egalitarian demands would have survived once they had acquired
power -- if the experience of Trotsky in power is anything to go by, not very
long.

Trotsky did not consider how the abolition of democracy and its replacement
with an autocratic system would effect the morale or consciousness of the
soldiers subject to it. He argued that in the Red Army _"the **best** soldier
does not mean at all the **most submissive and uncomplaining.**"_ Rather,
_"the best soldier will nearly always be sharper, more observant and critical
than the others. . . by his critical comments, based on facts accessible to
all, he will pretty often undermine the prestige of the commanders and
commissars in the eyes of the mass of the soldiers."_ However, not having a
democratic army the soldiers could hardly express their opinion other than
rebellion or by indiscipline. Trotsky, however, adds a comment that makes his
praise of critical soldiers seem less than sincere. He states that _"counter-
revolutionary elements, agents of the enemy, make conscious and skilful use of
the circumstances I have mentioned [presumably excessive privilege rather than
critical soldiers, but who can tell] in order to stir up discontent and
intensify antagonism between rank and file and the commanding personnel."_
[**Op. Cit.**] The question, of course, arises of who can tell the difference
between a critical soldier and a _"counter-revolutionary element"_? Without a
democratic organisation, soldier are dependent (as in any other hierarchy) on
the power of the commanders, commissars and, in the Red Army, the Bolshevik
Secret Police (the Cheka). In other words, members of the very class of
autocrats their comments are directed against.

Without democratic organisation, the Red Army could never be a means for
creating a socialist society, only a means of reproducing autocratic
organisation. The influence of the autocratic organisation created by Trotsky
had a massive impact on the development of the Soviet State. According to
Trotsky himself:

> _"The demobilisation of the Red Army of five million played no small role in
the formation of the bureaucracy. The victorious commanders assumed leading
posts in the local Soviets, in economy, in education, and they persistently
introduced everywhere that regime which had ensured success in the civil war.
Thus on all sides the masses were pushed away gradually from actual
participation in the leadership of the country."_ [**The Revolution
Betrayed**]

Obviously Trotsky had forgotten who created the regime in the Red Army in the
first place! He also seems to have forgotten that after militarising the Red
Army, he turned his power to militarising workers (starting with the railway
workers). He also forgets that Lenin had been arguing that workers' must
_"**unquestioningly obey the single will** of the leaders of labour"_ from
April 1918 along with granting _"individual executives dictatorial power (or
'unlimited' powers)"_ and that _"the appointment of individuals, dictators
with unlimited powers"_ was, in fact, _"in general compatible with the
fundamental principles of Soviet government"_ simply because _"the history of
revolutionary movements"_ had _"shown"_ that _"the dictatorship of individuals
was very often the expression, the vehicle, the channel of the dictatorship of
revolutionary classes."_ He notes that _"[u]ndoubtably, the dictatorship of
individuals was compatible with bourgeois democracy."_ [**The Immediate Tasks
of the Soviet Government**, p. 34 and p. 32]

In other words, Lenin urged the creation of, and implemented, **bourgeois**
forms of workplace management based on the appointment of managers from above.
To indicate that this was not in contradiction with Soviet principles, he
points to the example of **bourgeois** revolutions! As if bourgeois methods do
not reflect bourgeois interests and goals. In addition, these "dictators" were
given the same autocratic powers Trotsky claimed the demobilisation of the Red
Army four years later had _"persistently introduced everywhere."_ Yes, _"on
all sides the masses were pushed away gradually from actual participation in
the leadership of the country"_ but the process had started immediately after
the October Revolution and was urged and organised by Lenin and Trotsky before
the Civil War had started.

Lenin's support for appointment of (_"dictatorial"_) managers from above makes
Trotsky's 1922 comment that the _"Red Army was built from above, in accordance
with the principles of the dictatorship of the working class"_ take on a new
light. [**The Path of the Red Army**] After all, Lenin argued for an economy
system built from above via the appointment of managers before the start of
the Civil War. The Red Army was created from above via the appointment of
officers before the start of the Civil War. Things had certainly changed since
Lenin had argued in **The State and Revolution** that _"[a]ll officials,
without exception, [would be] elected and subject to recall **at any time.**"_
This would _"serve as the bridge between capitalism and socialism."_ [**The
Essential Lenin**, p. 302] One major difference, given Trotsky's rationales,
seems to be that the Bolsheviks were now in power and so election and recall
without exception could be forgotten and replaced by appointment.

In summary, Trotsky's argument against functional democracy in the Red Army
could, and was, used to justify the suppression of any democratic decision or
organisation of the working class the Bolshevik government disapproved of. He
used the same argument, for example, to justify the undermining of the Factory
Committee movement and the struggle for workers' control in favour of one-man
management -- the form of management in the workplace was irrelevant as the
workers' were now citizens of a workers' state and under a workers' government
(see [section 17](append32.md#app17)). Needless to say, a state which
eliminates functional democracy in the grassroots will not stay democratic for
long (and to remain the sovereign power in society, any state will have to
eliminate it or, at the very least, bring it under central control -- as
institutionalised in the USSR constitution of 1918).

Instead of seeing socialism as a product of free association, of working class
self-organisation from the bottom up by self-managed organisations, Trotsky
saw it as a centralised, top-down system. Of course, being a democrat of sorts
he saw the Bolshevik Government as being elected by the mass of the population
(or, more correctly, he saw it being elected by the national congress of
soviets). However, his vision of centralisation of power provided the
rationale for destroying functional democracy in the grass-roots -- and
without healthy roots, any plant will wither and die. Little wonder, then,
that the Bolshevik experiment proved such a disaster -- yes, the civil war did
not help but the logic of Bolshevism has started to undermine working class
self-management **before** is started.

Thus Trotsky's argument that the democratic nature of a workers' army or
militia is irrelevant because a "workers' state" exists is flawed on many
different levels. And the experience of Trotsky in power indicates well the
poverty of Trotskyism and Morrow's criticism of the CNT -- his suggestion for
a self-managed militia is pure anarchism with nothing to do with Leninism and
the experience of Bolshevism in power.

## 12\. What is ironic about Morrow's vision of revolution?

Equally ironic as Morrow's comments concerning democratic militias (see [last
section](append32.md#app11)) is his argument that the revolution needed to
_"give the factory committees, militia committees, peasant committees, a
democratic character, by having them elected by all workers in each unit; to
bring together these elected delegates in village, city, regional councils . .
. [and] a national congress."_ [**Op. Cit.**, p. 100]

Such a position is correct, such developments were required to ensure the
success of the revolution. However, it is somewhat ironic that a Trotskyist
would present them as somehow being opposed to anarchism when, in fact, they
are pure anarchism. Indeed, anarchists were arguing in favour of workers'
councils more than five decades before Lenin discovered the importance of the
Russian Soviets in 1917. Moreover, as we will indicate, what is even more
ironic is the fact that Trotskyism does not actually see these organs as an
expression of working class self-management and power but rather as a means of
the party to take power. In addition, we must also note that it was Lenin and
Trotsky who helped undermine the Russian workers' factory committees, militia
committees and so on in favour of party rule. We will discuss each of these
ironies in turn.

Firstly, as noted, such Morrow's stated position is exactly what Bakunin and
the anarchist movement had been arguing since the 1860s. To quote Bakunin:

> _"the federative alliance of all working men's associations . . . constitute
the Commune . . . all provinces, communes and associations . . . by first
**reorganising** on revolutionary lines . . . [will] constitute the federation
of insurgent associations, communes and provinces . . . [and] organise a
revolutionary force capable defeating reaction . . . [and for] self-defence .
. . [The] revolution everywhere must be created by the people, and supreme
control must always belong to the people organised into a free federation of
agricultural and industrial associations . . . organised from the bottom
upwards by means of revolutionary delegation. . . "_ [**Michael Bakunin:
Selected Writings**, p. 170-2]

>

> _"The future social organisation must be made solely from the bottom up, by
the free association or federation of workers, firstly in their unions, then
in the communes, regions, nations and finally in a great federation,
international and universal."_ [**Op. Cit.**, p. 206]

Here is Kropotkin presenting the same vision:

> _"independent Communes for the territorial organisation, and of federations
of Trade Unions [i.e. workplace associations] for the organisation of men [and
women] in accordance with their different functions. . . [and] free combines
and societies . . . for the satisfaction of all possible and imaginable needs,
economic, sanitary, and educational; for mutual protection, for the propaganda
of ideas, for arts, for amusement, and so on."_ [Peter Kropotkin, **Evolution
and Environment**, p. 79]

>

> _"the complete independence of the Communes, the Federation of free communes
and the social revolution in the communes, that is to say the formation of
associated productive groups in place of the state organisation."_ [quoted by
Camillo Berneri, **Peter Kropotkin: His Federalist Ideas**]

Bakunin also mentions that those defending the revolution would have a say in
the revolutionary structure -- the _"Commune will be organised by the standing
federation of the Barricades and by the creation of a Revolutionary Council
composed of . . . delegates from each barricade . . . vested with plenary but
accountable and removable mandates."_ [**Op. Cit.**, p. 171] This obviously
parallels the democratic nature of the CNT militias.

Interestingly enough, Marx commented that _"odd barricades, these barricades
of the Alliance [Bakunin's anarchist organisation], where instead of fighting
they spend their time writing mandates."_ [Marx, Engels and Lenin, **Anarchism
and Anarcho-Syndicalism**, p. 111] Obviously the importance of militia self-
management was as lost on him as it was on Lenin and Trotsky -- under Marx's
state would its defenders just be cannon-fodder, obeying their government and
officers without the ability to help determine the revolution they were
fighting for? Apparently so. Moreover, Marx quotes Bakunin's support for
_"responsible and recallable delegates, vested with their imperative
mandates"_ without commenting on the fact Bakunin **predicts** those features
of the Paris Commune Marx praised in his **Civil War in France** by a number
of years. Looks like Morrow is not the first Marxist to appropriate anarchist
ideas without crediting their source.

As can be seen, Morrow's suggestion on how to push the Spanish Revolution
forward just repeats the ideas of anarchism. Any one familiar with anarchist
theory would not be surprised by this as they would know that we have seen a
free federation of workplace and communal associations as the basis of a
revolution and, therefore, a free society since the time of Proudhon. Thus
Morrow's "Trotskyist" vision of a federation of workers' council actually
reproduces basic anarchist ideas, ideas which pre-date Lenin's support for
soviets as the basis of his "workers' state" by over half a century (we will
indicate the fundamental difference between the anarchist vision and the
Trotskyist in due course).

As an aside, these quotes by Bakunin and Kropotkin make a mockery of Lenin's
assertion that anarchists do not analysis _"**what** to put in the place of
what has been destroyed [i.e. the old state machine] and **how**"_
[**Essential Works of Lenin**, p. 362] Anarchists have always suggested a
clear answer to what we should _"replace"_ the state with -- namely free
federations of working class organisations created in the struggle against
capital and state. To state otherwise is to either be ignorant of anarchist
theory or seek to deceive.

Some anarchists like Bakunin and the anarcho-syndicalists and collectivists
saw these organisations being based primarily on libertarian labour unions
complemented by whatever organisations were created in the process of
revolution (_"The future society must be nothing else than the
universalisation of the organisation that the International has formed for
itself"_ \-- _"The Sonvillier Circular"_ echoing Bakunin, quoted by Brian
Morris, **Bakunin: The Philosophy of Freedom**, p. 61] Others like Kropotkin
and anarcho-communists saw it as a free federation of organisations created by
the process of revolution itself. While anarchists did not present a blueprint
of what would occur after the revolution (and rightly so) they did provide a
general outline in terms of a decentralised, free federation of self-managed
workers' associations as well as linking these future forms of working class
self-government with the forms generated in the current class struggle in the
here and now.

Similarly, Lenin's other assertion that anarchists do not study _"the
**concrete** lessons of previous proletarian revolutions"_ [**Ibid.**] is
equally baseless, as any one reading, say, Kropotkin's work would soon realise
(for example, **The Great French Revolution**, **Modern Science and
Anarchism** or his pamphlet _"Revolutionary Government"_). Starting with
Bakunin, anarchists analysed the experiences of the Paris Commune and the
class struggle itself to generalise political conclusions from them (for
example, the vision of a free society as a federation of workers' associations
is clearly a product of analysing the class struggle and looking at the
failures of the Commune). Given that Lenin states in the same work that
_"anarchists had tried to claim the Paris Commune as their 'own'"_ [p. 350]
suggests that anarchists **had** studied the Paris Commune and he was aware of
that fact. Of course, Lenin states that we had _"failed to give . . . a true
solution"_ to its lessons -- given that the solution anarchists proposed was a
federation of workers councils to smash the state and defend the revolution
his comments seem strange as this, according to **The State and Revolution**,
is the "Marxist" solution as well (in fact, as we will soon see, Lenin played
lip service to this and instead saw the solution as government by his party
rather than the masses as a whole).

Thus, Morrow's vision of what was required for a successful revolution
parallels that of anarchism. We shall now discuss where and how they differ.

The essential difference between the anarchist and Trotskyist vision of
workers' councils as the basis of a revolution is what role these councils
should play. For anarchists, these federations of self-managed assemblies is
the actual framework of the revolution (and the free society it is trying to
create). As Murray Bookchin puts it:

> _"There can be no separation of the revolutionary process from the
revolutionary goal. **A society based on self-administration must be achieved
by means of self-administration** . . . Assembly and community must arise from
within the revolutionary process itself; indeed, the revolutionary process
must **be** the formation of assembly and community, and with it, the
destruction of power. Assembly and community must become 'fighting words,' not
distinct panaceas. They must be created as **modes of struggle** against the
existing society, not as theoretical or programmatic abstractions. . . The
factory committees . . . must be managed directly by workers' assemblies in
the factories. . . neighbourhood committees, councils and boards must be
rooted completely in the neighbourhood assemble. They must be answerable at
every point to the assembly, they and their work must be under continual
review by the assembly; and finally, their members must be subject to
immediate recall by the assembly. The specific gravity of society, in short,
must be shifted to its base -- the armed people in permanent assembly."_
[**Post-Scarcity Anarchism**, pp. 167-9]

Thus the anarchist social revolution sees workers' councils as organs of
working class self-management, the means by which they control their own lives
and create a new society based on their needs, visions, dreams and hopes. They
are not seen as means by which others, the revolutionary party, seized power
**on behalf** of the people as Trotskyists do.

Harsh words? No, as can be seen from Morrow who is quite clear on the role of
working class organisation -- it is seen purely as the means by which the
party can take power. As he argues, there is _"no magic in the soviet form: it
is merely the most accurate, most quickly reflecting and responsively changing
form of political representation of the masses. . . It would provide the arena
in which the revolutionary party can win the support of the working class."_
[**Op. Cit.**, p. 136]

He states that initially the _"reformist majority in the executive committee
would decline the assumption of state power. But the workers could still find
in the soviets their natural organs of struggle until the genuinely
revolutionary elements in the various parties banded together to win a
revolutionary majority in the congress and establish a workers' state."_ In
other words, the _"workers' state, the dictatorship of the proletariat . . .
can only be brought into existence by the direct, **political** intervention
of the masses, through the factory and village councils (soviets) at that
point where a majority in the soviets is wielded by the workers' party or
parties which are determined to overthrow the bourgeois state. Such was the
basic theoretical contribution of Lenin."_ [**Op. Cit.**, p. 100 and p. 113]

From an anarchist perspective, this indicates well the fundamental difference
between anarchism and Trotskyism. For anarchists, the existence of an
_"executive committee"_ indicates that the workers' council do not, in fact,
have power in society -- rather it is the minority in the executive committee
who have been delegated power. Rather than govern themselves and society
directly, workers are turned into voters implementing the decisions their
leaders have made on their behalf. If revolutionary bodies like workers'
councils **did** create a "workers' state" (as Morrow recommends) then their
power would be transferred and centralised into the hands of a so-called
"revolutionary" government. In this, Morrow follows his guru Trotsky:

> _"the proletariat can take power only through its vanguard. In itself the
necessity for state power arises from an insufficient cultural level of the
masses and their heterogeneity. In the revolutionary vanguard, organised in a
party, is crystallised the aspirations of the masses to obtain their freedom.
Without the confidence of the class in the vanguard, without support of the
vanguard by the class, there can be no talk of the conquest of power.  
>  _

>

> _"In this sense the proletarian revolution and dictatorship are the work of
the whole class, but only under the leadership of the vanguard."_ [Trotsky,
**Stalinism and Bolshevism**]

Thus, rather than the working class as a whole "seizing power", it is the
_"vanguard"_ which takes power -- _"a revolutionary party, even after seizing
power . . . is still by no means the sovereign ruler of society."_ [**Ibid.**]
He mocks the anarchist idea that a socialist revolution should be based on the
self-management of workers within their own autonomous class organisations:

> _"Those who propose the abstraction of Soviets to the party dictatorship
should understand that only thanks to the party dictatorship were the Soviets
able to lift themselves out of the mud of reformism and attain the state form
of the proletariat."_ [Trotsky, **Op. Cit.**, p. 18]

In this he followed comments made when he was in power. In 1920 he argued that
_"[w]e have more than once been accused of having substituted for the
dictatorships of the Soviets the dictatorship of the party. Yet it can be said
with complete justice that the dictatorship of the Soviets became possible
only be means of the dictatorship of the party. It is thanks to the . . .
party . . . [that] the Soviets . . . [became] transformed from shapeless
parliaments of labour into the apparatus of the supremacy of labour. In this
'substitution' of the power of the party for the power of the working class
these is nothing accidental, and in reality there is no substitution at all.
The Communists express the fundamental interests of the working class."_
[**Terrorism and Communism**, p. 109] Any claims that Trotsky's infamously
authoritarian (indeed dictatorial) politics were a temporary aberration caused
by the necessities of the Russian Civil War are refuted by these quotes -- 17
years later he was still arguing the same point.

He had the same vision of party dictatorship being the basis of a revolution
in 1924. Commenting on the Bolshevik Party conference of April 1917, he states
that _"whole of . . . Conference was devoted to the following fundamental
question: Are we heading toward the conquest of power in the name of the
socialist revolution or are we helping (anybody and everybody) to complete the
democratic revolution? . . . Lenin's position was this: . . . the capture of
the soviet majority; the overthrow of the Provisional Government; the seizure
of power through the soviets."_ Note, **through** the soviets not **by** the
soviets thus indicating the fact the Party would hold the real power, not the
soviets of workers' delegates. Moreover, he states that _"to prepare the
insurrection and to carry it out under cover of preparing for the Second
Soviet Congress and under the slogan of defending it, was of inestimable
advantage to us."_ He continued by noting that it was _"one thing to prepare
an armed insurrection under the naked slogan of the seizure of power by the
party, and quite another thing to prepare and then carry out an insurrection
under the slogan of defending the rights of the Congress of Soviets."_ The
Soviet Congress just provided _"the legal cover"_ for the Bolshevik plans
rather than a desire to see the Soviets actually start managing society.
[**The Lessons of October**]

We are not denying that Trotskyists do aim to gain a majority within working
class conferences. That is clear. Anarchists also seek to gain the support of
the mass of the population. It is what they do next that counts. Trotskyists
seek to create a government above these organisations and dominate the
executive committees that requires. Thus power in society shifts to the top,
to the leaders of the centralised party in charge of the centralised state.
The workers' become mere electors rather than actual controllers of the
revolution. Anarchists, in contrast, seek to dissolve power back into the
hands of society and empower the individual by giving them a direct say in the
revolution through their workplace, community and militia assemblies and their
councils and conferences.

Trotskyists, therefore, advocate workers councils because they see them as
**the** means the vanguard party can take power. Rather than seeing socialism
or "workers' power" as a society in which everyone would directly control
their own affairs, Trotskyists see it in terms of working class people
delegating their power into the hands of a government. Needless to say, the
two things are not identical and, in practice, the government soon turns from
being the people's servant into its master.

It is clear that Morrow always discusses workers councils in terms of the
strategy and program of the party, not the value that workers councils have as
organs of direct workers control of society. He clearly advocates workers
councils because he sees them as the best way for the vanguard party to rally
workers around its leadership and organise the seizure of state power. At no
time does he see then as means by which working class people can govern
themselves directly -- quite the reverse.

The danger of such an approach is obvious. The government will soon become
isolated from the mass of the population and, due to the centralised nature of
the state, difficult to hold accountable. Moreover, given the dominant role of
the party in the new state and the perspective that it is the workers'
vanguard, it becomes increasingly likely that it will place its power before
that of those it claims to represent.

Certainly Trotsky's role in the Russian revolution tells us that the power of
the party was more important to him than democratic control by workers through
mass bodies. When the workers and sailors of the Kronstadt navy base rebelled
in 1921, in solidarity with striking workers in Petrograd, they were demanding
freedom of the press for socialist and anarchist groups and new elections to
the soviets. But the reaction of the Bolshevik leadership was to crush the
Kronstadt dissent in blood. Trotsky's attitude towards workers democracy was
clearly expressed at the time:

> _"They [the dissent Bolsheviks of the Workers' Opposition] have placed the
workers' right to elect representatives above the Party. As if the Party were
not entitled to assert its dictatorship even if that dictatorship temporarily
clashed with the passing moods of the worker's democracy!"  
>  _

He spoke of the _"revolutionary historic birthright of the Party"_ and that it
_"is obliged to maintain its dictatorship . . . regardless of temporary
vacillations even in the working class . . . The dictatorship does not base
itself at every given moment on the formal principle of a workers'
democracy."_ [quoted by M. Brinton, **Op. Cit.**, p. 78]

This perspective naturally follows from Trotsky's vanguardist politics. For
Leninists, the party is the bearer of _"socialist consciousness"_ and,
according to Lenin in **What is to be Done?**, workers, by their own efforts,
can only achieve a _"trade union"_ consciousness and, indeed, _"there can be
no talk of an independent ideology being developed by the masses of workers in
the process of their struggle"_ and so _"**the only choice is**: either
bourgeois or socialist ideology"_ (the later being developed not by workers
but by the _"bourgeois intelligentsia"_). [**Essential Works of Lenin**, p. 82
and p. 74] To weaken or question the party means to weaken or question the
socialist nature of the revolution and so weaken the _"dictatorship of the
proletariat."_ Thus we have the paradoxical situation of the "proletarian
dictatorship" repressing workers, eliminating democracy and maintaining itself
against the _"passing moods"_ of the workers (which means rejecting what
democracy is all about). Hence Lenin's comment at a conference of the Cheka
(his political police) in 1920:

> _"Without revolutionary coercion directed against the avowed enemies of the
workers and peasants, it is impossible to break down the resistance of these
exploiters. On the other hand, revolutionary coercion is bound to be employed
towards the wavering and unstable elements among the masses themselves."_
[**Collected Works**, vol. 42, p. 170]

Significantly, of the 17 000 camp detainees on whom statistical information
was available on 1 November 1920, peasants and workers constituted the largest
groups, at 39% and 34% respectively. Similarly, of the 40 913 prisoners held
in December 1921 (of whom 44% had been committed by the Cheka) nearly 84% were
illiterate or minimally educated, clearly, therefore, either peasants of
workers. [George Leggett, **The Cheka: Lenin's Political Police**, p. 178]
Needless to say, Lenin failed to mention this aspect of his system in **The
State and Revolution** (a failure shared by Morrow and later Trotskyists).

It is hard to combine these facts and Lenin's and Trotsky's comments with the
claim that the "workers' state" is an instrument of class rule -- after all,
Lenin is acknowledging that coercion will be exercised against members of the
working class as well. The question of course arises -- who decides what a
_"wavering"_ or _"unstable"_ element is? Given their comments on the role of
the party and the need for the party to assume power, it will mean in practice
whoever rejects the government's decisions (for example, strikers, local
soviets who reject central decrees and instructions, workers who vote for
anarchists or parties other than the Bolshevik party in elections to soviets,
unions and so on, socialists and anarchists, etc.). Given a hierarchical
system, Lenin's comment is simply a justification for state repression of its
enemies (including elements within or even the whole working class).

It could be argued, however, that workers could use the soviets to recall the
government. However, this fails for two reasons (we will ignore the question
of the interests of the bureaucratic machine which will inevitably surround a
centralised body -- see [ section H.3.9](secH3.md#sech39) for further
discussion).

Firstly, the Leninist state will be highly centralised, with power flowing
from the top-down. This means that in order to revoke the government, all the
soviets in all parts of the country must, at the same time, recall their
delegates and organise a national congress of soviets (which, we stress, is
not in permanent session). The local soviets are bound to carry out the
commands of the central government (to quote the Soviet constitution of 1918
-- they are to _"carry out all orders of the respective higher organs of the
soviet power"_). Any independence on their part would be considered
_"wavering"_ or an expression of _"unstable"_ natures and so subject to
_"revolutionary coercion"_. In a highly centralised system, the means of
accountability is reduced to the usual bourgeois level -- vote in the general
election every few years (which, in any case, can be annulled by the
government to ensure that the soviets do not go back into the _"mud"_ via the
_"passing moods"_ caused by the _"insufficient cultural level of the
masses"_). In other words, the soviet form may be the _"most accurate, most
quickly reflecting and responsively changing form of political representation
of the masses"_ (to use Morrow's words) but only **before** they become
transformed into state organs.

Secondly, _"revolutionary coercion"_ against _"wavering"_ elements does not
happen in isolation. It will encourage critical workers to keep quiet in case
they, too, are deemed _"unstable"_ and become subject to _"revolutionary"_
coercion. As a government policy it can have no other effect than deterring
democracy.

Thus Trotskyist politics provides the rationale for eliminating even the
limited role of soviets for electing representatives they hold in that
ideology.

Morrow argues that _"[o]ne must never forget . . . that soviets **do not
begin** as organs of state power"_ rather they start as _"organs defending the
workers' daily interests"_ and include _"powerful strike committees."_ [**Op.
Cit.**, p. 136] That is true, initially workers' councils are expressions of
working class power and are organs of working class self-management and self-
activity. They are subject to direct control from below and unite from the
bottom up. However, once they are turned into _"organs of state power"_ their
role (to re-quote the Soviet constitution of 1918) becomes that of
_"carry[ing] out all orders of the respective higher organs of the soviet
power."_ Soviet power is replaced by party power and they become a shell of
their former selves -- essentially rubber-stamps for the decisions of the
party central committee.

Ironically, Morrow quotes the main theoretician of the Spanish Socialist Party
as stating _"the organ of the proletarian dictatorship will be the Socialist
Party"_ and states that they _"were saying precisely what the anarchist
leaders had been accusing both communists and revolutionary socialists of
meaning by the proletarian dictatorship."_ [**Op. Cit.**, p. 99 and p. 100]
This is hardly surprising, as this was what the likes of Lenin and Trotsky
**had** been arguing. As well as the quotes we have provided above, we may add
Trotsky's comment that the _"fundamental instrument of proletarian revolution
is the party."_ [**Lessons of October**] And the resolution of the Second
World Congress of the Communist International which stated that _"[e]very
class struggle is a political struggle. The goal of this struggle . . . is the
conquest of political power. Political power cannot be seized, organised and
operated except through a political party."_ [cited by Duncan Hallas, **The
Comintern**, p. 35] In addition, we may quote Lenin's opinion that:

> _"The very presentation of the question -- 'dictatorship of the Party **or**
dictatorship of the class, dictatorship (Party) of the leaders **or**
dictatorship (Party) of the masses?' -- is evidence of the most incredible and
hopeless confusion of mind . . . [because] classes are usually . . . led by
political parties. . . "  
>  _

And:

> _"To go so far in this matter as to draw a contrast in general between the
dictatorship of the masses and the dictatorship of the leaders, is
ridiculously absurd and stupid."_ [**Left-wing Communism: An Infantile
Disorder**, pp. 25-6 and p. 27]

As Lenin and Trotsky constantly argued, proletarian dictatorship was
impossible without the political party of the workers (whatever its name).
Indeed, to even discuss any difference between the dictatorship of the class
and that of the party just indicated a confused mind. Hence Morrow's comments
are incredulous, particularly as he himself stresses that the soviet form is
useful purely as a means of gaining support for the revolutionary party which
would take over the executive of the workers' councils. He clearly is aware
that the party is the **essential** organ of proletarian rule from a Leninist
perspective -- without the dictatorship of the party, Trotsky argues, the
soviets fall back into the mud. Trotsky, indeed, stressed this need for the
dictatorship of the party rather than of the proletariat in a letter written
in 1937:

> _"The revolutionary dictatorship of a proletarian party is for me not a
thing that one can freely accept or reject: It is an objective necessity
imposed upon us by the social realities -- the class struggle, the
heterogeneity of the revolutionary class, the necessity for a selected
vanguard in order to assure the victory. The dictatorship of a party belongs
to the barbarian prehistory as does the state itself, but we can not jump over
this chapter, which can open (not at one stroke) genuine human history. . .
The revolutionary party (vanguard) which renounces its own dictatorship
surrenders the masses to the counter-revolution . . . Abstractly speaking, it
would be very well if the party dictatorship could be replaced by the
'dictatorship' of the whole toiling people without any party, but this
presupposes such a high level of political development among the masses that
it can never be achieved under capitalist conditions. The reason for the
revolution comes from the circumstance that capitalism does not permit the
material and the moral development of the masses."_ [Trotsky, **Writings
1936-37**, pp. 513-4]

The net result of Bolshevik politics in Russia was that Lenin and Trotsky
undermined the self-management of working class bodies during the Russian
Revolution and **before** the Civil War started in May 1918. We have already
chronicled Trotsky's elimination of democracy and equality in the Red Army
(see [section 11](append32.md#app11)). A similar fate befell the factory
committees (see [section 17](append32.md#app17)) and soviet democracy (as
noted above). The logic of Bolshevism is such that at no point did Lenin
describe the suppression of soviet democracy and workers' control as a defeat
(indeed, as far as workers' control went Lenin quickly moved to a position
favouring one-man management). We discuss the Russian Revolution in more
detail in the appendix on ["What happened during the Russian
Revolution?"](append41.md) and so will not do so here.

All in all, while Morrow's rhetoric on the nature of the social revolution may
sound anarchist, there are important differences between the two visions.
While Trotskyists support workers' councils on purely instrumentalist grounds
as the best means of gaining support for their party's assumption of
governmental power, anarchists see workers' councils as the means by which
people can revolutionise society and themselves by practising self-management
in all aspects of their lives. The difference is important and its
ramifications signify why the Russian Revolution became the "dictatorship
**over** the proletariat" Bakunin predicted. His words still ring true:

> _"[b]y popular government they [the Marxists] mean government of the people
by a small under of representatives elected by the people. . . [That is,]
government of the vast majority of the people by a privileged minority. But
this minority, the Marxists say, will consist of workers. Yes, perhaps, of
**former** workers, who, as soon as they become rulers or representatives of
the people will cease to be workers and will begin to look upon the whole
workers' world from the heights of the state. They will no longer represent
the people but themselves and their own pretensions to govern the people."_
[**Statism and Anarchy**, p. 178]

It was for this reason that he argued the anarchists do _"not accept, even in
the process of revolutionary transition, either constituent assemblies,
provisional governments or so-called revolutionary dictatorships; because we
are convinced that revolution is only sincere, honest and real in the hands of
the masses, and that when it is concentrated in those of a few ruling
individuals it inevitably and immediately becomes reaction."_ [**Michael
Bakunin: Selected Writings**, p. 237] The history of the Russian Revolution
proved him right. Hence anarchist support for popular assemblies and
federations of workers' councils as the framework of the social revolution
rather than as a means to elect a "revolutionary" government.

One last point. We must point out that Morrow's follows Lenin in favouring
executive committees associated with workers' councils. In this he actually
ignores Marx's (and Lenin's, in **State and Revolution**) comments that the
Paris Commune was _"to be a working, not a parliamentary, body, executive and
legislative at the same time."_ [**Selected Writings**, p. 287] The existence
of executive committees was coded into the Soviet Union's 1918 Constitution.
This suggests two things. Firstly, Leninism and Trotskyism differ on
fundamental points with Marx and so the claim that Leninism equals Marxism is
difficult to support (the existence of libertarian Marxists like Anton
Pannekoek and other council communists also disprove such claims). Secondly,
it indicates that Lenin's claims in **State and Revolution** were ignored once
the Bolsheviks took power so indicating that use of that work to prove the
democratic nature of Bolshevism is flawed.

Moreover, Marx's support of the fusion of executive and legislative powers is
not as revolutionary as some imagine. For anarchists, as Bookchin argues,
_"[i]n point of fact, the consolidation of 'executive and legislative'
functions in a single body was regressive. It simply identified the process of
policy-making, a function that rightly should belong to the people in
assembly, with the technical execution of these policies, a function that
should be left to strictly administrative bodies subject to rotation, recall,
limitations of tenure . . . Accordingly, the melding of policy formation with
administration placed the institutional emphasis of classical [Marxist]
socialism on centralised bodies, indeed, by an ironical twist of historical
events, bestowing the privilege of formulating policy on the 'higher bodies'
of socialist hierarchies and their execution precisely on the more popular
'revolutionary committees' below."_ [**Toward an Ecological Society**, pp.
215-6]

## 13\. Why do anarchists reject the Marxist "workers' state"?

Morrow asserts two _"fundamental"_ tenets of _"anarchism"_ in his book [**Op.
Cit.**, pp. 101-2]. Unfortunately for him, his claims are somewhat at odds
with reality. Anarchism, as we will prove in [section
14](append32.md#app14), does not hold one of the positions Morrow states it
does. The first _"tenet"_ of anarchism he fails to discuss at all and so the
reader cannot understand **why** anarchists think as they do. We discuss this
_"tenet"_ here.

The first tenet is that anarchism _"has consistently refused to recognise the
distinction between a bourgeois and a workers' state. Even in the days of
Lenin and Trotsky, anarchism denounced the Soviet Union as an exploiters'
regime."_ [**Op. Cit.**, p. 101] It is due to this, he argues, the CNT co-
operated with the bourgeois state:

> _"The false anarchist teachings on the nature of the state . . . should
logically have led them [the CNT] to refuse governmental participation in any
event . . . the anarchists were in the intolerable position of objecting to
the necessary administrative co-ordination and centralisation of the work they
had already begun. Their anti-statism 'as such' had to be thrown off. What
**did** remain, to wreck disaster in the end, was their failure to recognise
the distinction between a workers' and a bourgeois state."_ [**Op. Cit.**, p.
101]

Needless to say, Morrow does not bother to explain **why** anarchists consider
the bourgeois and workers' state to be similar. If he did then perhaps his
readers would agree with the anarchists on this matter. However, before
discussing that we have to address a misrepresentation of Morrow's. Rather
than the expression of anarchist politics, the actions of the CNT were in
direct opposition to them. As we showed in the [ section
12](append32.md#app12), anarchists see a social revolution in terms of
creating federations of workers associations (i.e. workers' councils). It was
this vision that had created the structure of the CNT (as Bakunin had argued,
_"the organisation of the trade sections and their representation in the
Chambers of Labour . . . bear in themselves the living seeds of the new
society which is to replace the old one. They are creating not only the ideas,
but also the facts of the future itself"_ [**Bakunin on Anarchism**, p. 255]).

Thus, the social revolution would see the workers' organisation (be they
labour unions or spontaneously created organs) _"tak[ing] the revolution into
its own hands . . . an earnest international organisation of workers'
associations . . . [would] replac[e] this departing political world of States
and bourgeoisie."_ [**The Basic Bakunin**, p. 110] This is **precisely** what
the CNT did not do -- rather it decided against following anarchist theory and
instead decided to co-operate with other parties and unions in the _"Central
Committee of Anti-Fascist Militias"_ (at least temporarily until the CNT
stronghold in Saragossa was liberated by CNT militias). In effect, it created
a UGT-like "Alliance" with other anti-fascist parties and unions and rejected
its pre-war policy of "unity from below." The CNT and FAI leadership decided
not to talk of libertarian communism but only of the fight against fascism. A
greater mistake they could not have made.

An anarchist approach in the aftermath of the fascist uprising would have
meant replacing the Generalitat with a federal assembly of delegates from
workplace and local community assemblies (a Defence Council, to use a CNT
expression). Only popular assemblies (not political parties) would be
represented (parties would have an influence only in proportion to their
influence in the basic assemblies). All the CNT would have had do was to call
a Regional Congress of unions and invite the UGT, independent unions and
unorganised workplaces to send delegates to create the framework of this
system. This, we must stress, was **not** done. We will discuss why in
[section 20](append32.md#app20) and so will refrain from doing so here.
However, **because** the CNT in effect "postponed" the political aspects of
the social revolution (namely, to quote Kropotkin, to _"smash the State and
replace it with the Federation [of Communes]"_ [**No Gods, No Masters**, vol.
1, p. 259]) the natural result would be exactly as Morrow explains:

> _"But isn't it a far cry from the failure to create the organs to overthrow
the bourgeoisie, to the acceptance of the role of class collaboration with the
bourgeoisie? Not at all . . . Without developing soviets -- workers' councils
-- it was inevitable that even the anarchists and the POUM would drift into
governmental collaboration with the bourgeoisie."_ [**Op. Cit.**, pp. 88-9]

As Kropotkin predicted, _"there can be no half-way house: either the Commune
is to be absolutely free to endow itself with whatever institutions it wishes
and introduce all reforms and revolutions it may deem necessary, or else it
will remain . . . a mere subsidiary of the State, chained in its every
movement."_ [**Op. Cit.**, p. 259] Without an alternative means of co-
ordinating the struggle, the CNT would, as Morrow argued, have little choice
but to collaborate with the state. However, rather than being a product of
anarchist theory, as Morrow states, this came about by **ignoring** that
theory (see [section 20](append32.md#app20)).

This can be seen from the false alternative used to justify the CNT's and
FAI's actions -- namely, _"either libertarian communism, which means anarchist
dictatorship, or democracy, which means collaboration."_ The creation of
libertarian communism is done **from below** by those subject to capitalist
and statist hierarchy overthrowing those with power over them by smashing the
state machine and replacing it with self-managed organisations as well as
expropriating capital and placing it under workers' self-management. As Murray
Bookchin argues:

> _"Underlying all [the] errors [of the CNT], at least in theoretical terms,
was the CNT-FAI's absurd notion that if it assumed power in the areas it
controlled, it was establishing a 'State.' As long as the institutions of
power consisted of armed workers and peasants as distinguished from a
professional bureaucracy, police force, army, and cabal of politicians and
judges, they were no[t] a State . . . These institutions, in fact comprised a
revolutionary people in arms . . . not a professional apparatus that could be
regarded as a State in any meaningful sense of the term. . . That the 'taking
of power' by an armed people in militias, libertarian unions and federations,
peasant communes and industrial collectives could be viewed as an 'anarchist
dictatorship' reveals the incredible confusion that filled the minds of the
'influential militants.'"_ [_"Looking Back at Spain,"_ pp. 53-96, **The
Radical Papers**, pp. 86-7]

This perspective explains why anarchists do not see any fundamental difference
between a so-called "workers' state" and the existing state. For anarchists,
the state is based fundamentally on hierarchical power -- the delegation of
power into the hands of a few, of a government, of an "executive" committee.
Unlike Lenin, who stressed the "bodies of armed men" aspect of the state,
anarchists consider the real question as one of who will tell these "bodies of
armed men" what to do. Will it be the people as a whole (as expressed through
their self-managed organisations) or will be it a government (perhaps elected
by representative organisations)?

If it **was** simply a question of consolidating a revolution and its self-
defence then there would be no argument:

> _"But perhaps the truth is simply this: . . . [some] take the expression
'dictatorship of the proletariat' to mean simply the revolutionary action of
the workers in taking possession of the land and the instruments of labour,
and trying to build a society and organise a way of life in which there will
be no place for a class that exploits and oppresses the producers.  
>  _

>

> _"Thus constructed, the 'dictatorship of the proletariat' would be the
effective power of all workers trying to bring down capitalist society and
would thus turn into Anarchy as soon as resistance from reactionaries would
have ceased and no one can any longer seek to compel the masses by violence to
obey and work for him. In which case, the discrepancy between us would be
nothing more than a question of semantics. Dictatorship of the proletariat
would signify the dictatorship of everyone, which is to say, it would be a
dictatorship no longer, just as government by everybody is no longer a
government in the authoritarian, historical and practical sense of the word. _

>

> _"But the real supporters of 'dictatorship of the proletariat' do not take
that line, as they are making quite plain in Russia. Of course, the
proletariat has a hand in this, just as the people has a part to play in
democratic regimes, that is to say, to conceal the reality of things. In
reality, what we have is the dictatorship of one party, or rather, of one'
party's leaders: a genuine dictatorship, with its decrees, its penal
sanctions, its henchmen and above all its armed forces, which are at present
[1919] also deployed in the defence of the revolution against its external
enemies, but which will tomorrow be used to impose the dictator's will upon
the workers, to apply a break on revolution, to consolidate the new interests
in the process of emerging and protect a new privileged class against the
masses."_ [Malatesta, **No Gods, No Masters**, vol. 2, pp. 38-9]

Maurice Brinton sums up the issue well when he argued that _"workers' power"_
_"cannot be identified or equated with the power of the Party -- as it
repeatedly was by the Bolsheviks . . . What 'taking power' really implies is
that the vast majority of the working class at last realises its ability to
manage both production and society -- and organises to this end."_ [**The
Bolsheviks and Workers' Control**, p. xiv]

The question is, therefore, one of **who** "seizes power" -- will it be the
mass of the population or will it be a party claiming to represent the mass of
the population. The difference is vital -- and anyone who confuses the issue
(like Lenin) does so either out of stupidity or vested interests.

If it **is** the mass of people then they have to express themselves and their
power (i.e. the power to manage their own affairs). That requires that
individuals -- no matter where they are, be it in the workplace, community or
on the front line -- are part of self-managed organisations. Only by self-
management in functional groups can working class people be said to
controlling their own lives and determining their own fate. Such a system of
popular assemblies and their means of defence would not be a state in the
anarchist sense of the word.

As we argued in [section 12](append32.md#app12), the Trotskyist vision of
revolution, while seeming in some ways similar to that of anarchists, differ
on this question. For Trotskyists, the **party** takes power, **not** the mass
of the population directly. Only if you view "proletarian" seizure of power in
terms of electing a political party to government could you see the
elimination of functional democracy in the armed forces and the workplaces as
no threat to working class power. Given Trotsky's actual elimination of
democracy in the Red Army and Navy plus his comments on one-man management
(and their justifications -- see sections [11](append32.md#app11) and
[17](append32.md#app17)) it is clear that Trotskyists consider the workers'
state in terms of party government, **not** self-management, **not**
functional direct democracy.

Yes, the Trotskyists do claim that it is the workers, via their soviets, who
will elect the government and hold it accountable but such a position fails to
realise that a social revolution can only be created from below, by the direct
action of the mass of the population. By delegating power into the hands of a
few, the revolution is distorted. The initiative and power no longer rests in
the hands of the mass of the population and so they can no longer take part in
the constructive work of the revolution **and so it will not reflect their
interests and needs.** As power flows from the top-down, bureaucratic
distortions are inevitable.

Moreover, the government will inevitably clash with its subjects and
Trotskyist theory provides the justification for the government imposing its
wishes and negating workers' democracy (see [section 12](append32.md#app12)
for evidence for this claim). Moreover, in the centralised state desired by
Trotskyists democratic accountability will inevitably suffer as power flows to
the top:

> _"The power of the local soviets passed into the hands of the [National]
Executive Committee, the power of the Executive Committee passed into the
hands of the Council of People's Commissars, and finally, the power of the
Council of People's Commissars passed into the hands of the Political Bureau
of the Communist Party."_ [Murray Bookchin, **Post-Scarcity Anarchism**, p.
152]

Little wonder, then, these CNT aphorisms:

> _"power corrupts both those who exercise it and those over whom it is
exercised; those who think they can conquer the State in order to destroy it
are unaware that the State overcomes all its conquerors. . . dictatorship of
the proletariat is dictatorship without the proletariat and against them."_
[Peter Marshall, **Demanding the Impossible**, p. 456]

That, in a nut shell, why anarchists consider the workers' state as no real
change from the bourgeois state. Rather than creating a system in which
working class people directly manage their own affairs, the workers' state,
like any other state, involves the delegation of that power into the hands of
a few. Given that state institutions generate specific social relations,
specific relations of authority (namely those order giver and order taker)
they cannot help becoming separated from society, becoming a new class based
on the state's bureaucratic machine. Any state structure (particularly a
highly centralised one, as desired by Leninists) has a certain independence
from society and so serves the interests of those within the State
institutions rather than the people as a whole.

Perhaps a Leninist will point to **The State and Revolution** as evidence that
Lenin desired a state based round the soviets -- workers' council -- and so
our comments are unjustified. However, as Marx said, judge people by what they
do, not what they say. The first act of the October Revolution was to form an
executive power **over** the soviets (although, of course, in theory
accountable to their national congress). In **The State and Revolution** Lenin
praised Marx's comment that the Paris Commune was both administrative **and**
executive. The "workers' state" created by Lenin did not follow that model (as
Russian anarcho-syndicalists argued in August 1918, _"the Soviet of People's
Commissars [i]s an organ which does not stem from the soviet structure but
only interferes with its work"_ [**The Anarchists in the Russian Revolution**,
p. 118]).

Thus the Bolshevik state was not based around soviet self-management **nor**
the fusion of executive and administrative in their hands but rather the use
of the soviets to elect a government (a separate executive) which had the real
power. The issue is quite simple -- either _"All power to the Soviets"_ means
just that or it means _"All power to the government elected by the Soviets"_.
The two are not the same as the first, for the obvious reason that in the
second the soviets become simply ratification machines for the government and
not organs in which the working masses can run their own affairs. We must also
point out that the other promises made in Lenin's book went the same way as
his support for the combining administration and executive tasks in the Paris
Commune -- and, we stress, all **before** the Civil War started in May 1918
(the usual Trotskyist defence of such betrayals is blame the Civil War which
is hard to do as it had not started yet).

So it is unsurprising that Morrow does not explain why anarchists reject the
"dictatorship of the proletariat" -- to do so would be to show that Trotskyism
is not the revolutionary movement for workers' liberty it likes to claim it
is. Moreover, it would involve giving an objective account of anarchist theory
and admitting that the CNT did not follow its teachings.

## 14\. What is wrong with Morrow's _"fundamental tenet"_ of anarchism?

According to Morrow the _"second fundamental tenet in anarchist teaching"_ is,
apparently, the following:

> _"Since Bakunin, the anarchists had accused Marxists of over-estimating the
importance of state power, and had characterised this as merely the reflection
of the petty-bourgeois intellectuals' pre-occupation with lucrative
administrative posts. Anarchism calls upon workers to turn their backs on the
state and seek control of the factories as the real source of power. The
ultimate sources of power (property relations) being secured, the state power
will collapse, never to be replaced."  
>  _

He then sums up by stating the Spanish anarchists _"thus failed to understand
that it was only the collapse of state power . . . which had enabled them to
seize the factories."_ [**Op. Cit.**, p. 102]

It would be interesting to discover in what work of Bakunin, or any anarchist,
such a position could be found. Morrow gives us no references to help us in
our quest -- hardly surprising as no anarchist (Spanish or otherwise) ever
argued this point before July 1936. However, in September 1936, we discover
the CNT arguing that the _"withering away of the State is socialism's ultimate
objective. Facts have demonstrated that in practice it is achieved by
liquidation of the bourgeois State, brought to a state of asphyxiation by
economic expropriation."_ [**No Gods, No Masters**, vol. 2, p. 261] This, we
must note, was the same month the CNT decided to join the Catalan Government!
So much for the state having withered away.

However, will soon be made clear, such comments were a revision of anarchist
theory brought about by the apparent victory of the CNT on July 19th, 1936
(just as other revisions occurred to justify CNT participation in the state).
In other words, Morrow's _"second fundamental tenet"_ does not exist in
anarchist theory. To prove this, we will quote Bakunin and a few other famous
anarchists as well as giving an overview of some of the insurrections
organised by the CNT before 1936. We start with Bakunin, Kropotkin and
Malatesta.

Given that Bakunin thought that it was the _"power of the State"_ which
_"sustains the privileged classes"_ against the _"legitimate indignation of
the masses of the people"_ it is hard to know what Morrow is talking about.
[**The Political Philosophy of Bakunin**, p. 196] Given this perspective, it
naturally follows that to abolish capitalism, to allow the seizure of
factories by the workers, the state had to be abolished (or _"destroyed"_).
Equally clear is that the _"natural and necessary consequence of this
destruction will be . . . [among others, the] dissolution of army, magistracy,
bureaucracy, police and priesthood. . . confiscation of all productive capital
and means of production on behalf of workers' associations, who are to put
them to use . . . the federative Alliance of all working men's associations .
. . will constitute the Commune."_ [**Michael Bakunin: Selected Writings** p.
253 and p. 170]

Thus, the state has to be abolished in order to ensure that workers' can take
over the means of production, so abolishing capitalism. This is the **direct
opposite** of Morrow's claim that _"[s]ince Bakunin"_ anarchism had _"call[ed]
upon the workers to turn their backs to the state and seek control of the
factories as the real source of power."_ While control of the economy by
workers is an important, indeed a key, aspect of a social revolution it is not
a sufficient one for anarchists. It must be combined with the destruction of
the state (as Bakunin argued, _"[n]o revolution could succeed . . . today
unless it was simultaneously a political and a social revolution"_ [**No Gods,
No Masters**, vol. 1, p. 141]). As the power of the state _"sustains"_ the
capitalists it clearly follows that the capitalist only has his property
because the state protects his property claims -- without the state, workers'
would seize the means of production. Which means, contra Morrow, Bakunin was
aware that in order for workers' to take over their workplaces the state had
to be destroyed as it was by means of the state that capitalist property
rights are enforced.

And, just to stress the obvious, you cannot _"turn your backs on the state"_
while dissolving the state bureaucracy, the army, police and so on. This is
clear for Bakunin. He argued that _"[l]iberty can only be created by liberty,
by an insurrection of all the people and the voluntary organisation of the
workers from below upward."_ And the nature of this workers' organisation?
Workers' councils -- the _"proletariat . . . must enter the International
[Workers' Association] en masse, form[ing] factory, artisan, and agrarian
sections, and unite them into local federations."_ [**Statism and Anarchy**,
p. 179 and p. 49]

Similarly, we discover Kropotkin arguing that _"expropriation"_ would occur at
the same time as _"the capitalists' power to resist [had] been smashed"_ and
that _"the authorities"_ will be _"overthrown."_ [**No Gods, No Masters**,
vol. 1, p. 232 and p. 233] He also recognised the need for self-defence,
arguing that the revolution must _"withstand both the attempts to form a
government that would seek to strangle it and any onslaughts which may emanate
from without."_ [**Op. Cit.**, p. 232] He argued the Commune _"must smash the
State and replace it with the Federation and it will act accordingly."_ [**Op.
Cit.**, p. 259] You cannot do all this by _"turning your backs"_ on the state.
To smash the state you need to face it and fight it -- there is no other way.

Elsewhere he argued that the commune of the future would base itself on _"the
principles of anarchist communism"_ and _"entirely abolish . . . property,
government, and the state."_ They will _"proclaim and establish their
independence by direct socialist revolutionary action, abolishing private
property"_ when _"governments are swept away by the people . . . the insurgent
people will not wait until some new government decrees, in its marvellous
wisdom, a few economic reforms."_ Rather, they _"will take possession on the
spot and establish their rights by utilising it without delay. They will
organise themselves in the workshops to continue the work, but what they will
produce will be what is wanted by the masses, not what gives the highest
profit to employers. . . they will organise themselves to turn to immediate
use the wealth stored up in the towns; they will take possession of it as if
it had never been stolen from them by the middle class."_ [**The Commune of
Paris**] Note that Kropotkin explicitly states that only **after**
_"governments are swept away"_ would the _"insurgent people . . . organise
themselves in the workshops."_

As Malatesta noted, the anarchist principles formulated in 1872 at the
Congress of St Imier (under the influence of Bakunin, obviously) stated that
_"[d]estruction of all political power is the first duty of the proletariat"_
who must _"establish solidarity in revolutionary action outside the framework
of bourgeois politics."_ He adds, _"[n]eedless to say, for the delegates of
St. Imier as for us and for all anarchists, the abolition of political power
is not possible without the simultaneous destruction of economic privilege."_
[**Life and Ideas**, pp. 157-8]

Malatesta himself always stressed that revolution required _"the
insurrectionary act which sweeps away the material obstacles, the armed forces
of the government."_ He argued that _"[o]nce the government has been
overthrown . . . it will be the task of the people . . . to provide for the
satisfaction of immediate needs and to prepare for the future by destroying
privileges and harmful institutions."_ [**Op. Cit.**, p. 163 and p. 161] In
other words, the revolution needs to smash the state and at the same time
abolish capitalism by expropriation by the workers.

Thus anarchism is clear on that you need to destroy the state in order to
expropriate capital. Morrow's assertions on this are clearly false. Rather
than urging _"workers to turn their backs on the state and seek control of the
factories as the real source of power"_ anarchism calls upon workers to
_"overthrow,"_ _"smash,"_ _"sweep away,"_ _"destroy"_, _"dissolve"_ the state
and its bureaucratic machinery via an _"insurrectionary act"_ and expropriate
capital **at the same time** \-- in other words, a popular uprising probably
combined with a general strike (_"an excellent means for starting the social
revolution,"_ in Malatesta's words, but not in itself enough to made _"armed
insurrection unnecessary"_ [Errico Malatesta, **The Anarchist Reader**, pp.
224-5]).

That, in itself, indicates that Morrow's _"fundamental tenet"_ of anarchism
does not, in fact, actually exist. In addition, if we look at the history of
the CNT during the 1930s we discover that the union organised numerous
insurrections which did not, in fact, involve workers _"turning their backs on
the state"_ but rather attacking the state. For example, in the spontaneous
revolt of CNT miners in January 1932, the workers _"seized town halls, raised
the black-and-red flags of the CNT, and declared **communismo liberatario.**"_
In Tarassa, the same year, the workers again _"seiz[ed] town halls"_ and the
town _"swept by street fighting."_ The revolt in January 1933 began with
_"assaults by Anarchist action groups . . . on Barcelona's military barracks .
. . Serious fighting occurred in working-class **barrios** and the outlying
areas of Barcelona . . . Uprising occurred in Tarassa, Sardanola-Ripollet,
Lerida, in several **pueblos** in Valencia province, and in Andalusia."_ In
Casas Viejas, as we discussed in [section 1](append32.md#app1), the CNT
members surrounded and attacked the barracks of the Civil Guard. In December
1933, the workers _"reared barricades, attacked public buildings, and engaged
in heavy street fighting . . . many villages declared libertarian communism."_
[Murray Bookchin, **The Spanish Anarchists**, p. 225, p. 226, p. 227 and p.
238]

Moreover, _"[w]herever possible . . . insurrections had carried out industrial
and agrarian take-overs and established committees for workers' and peasant's
control, libertarian systems of logistics and distribution -- in short, a
miniature society 'organised on the lines set down by Kropotkin.'"_ [Bookchin,
**Op. Cit.**, p. 239]

Now, does all that really sound like workers turning their backs on the state
and only seizing control of their factories?

Perhaps it will be argued that Morrow is referring to **after** the
insurrection (although he clearly is not). What about the defence of the
revolution? Anarchists have always been clear on this too -- the revolution
would be defended by the people in arms. We have discussed this issue above
(in sections [1](append32.md#app1) and [8](append32.md#app8) in
particular) so we do not need to discuss it in much detail here. We will just
provide another quote by Bakunin (although written in 1865, Bakunin made the
same points over and over again until his death in 1876):

> _"While it [the revolution] will be carried out locally everywhere, the
revolution will of necessity take a federalist format. Immediately after
established government has been overthrown, communes will have to reorganise
themselves along revolutionary lines . . . In order to defend the revolution,
their volunteers will at the same time form a communal militia. But no commune
can defend itself in isolation. So it will be necessary for each of them to
radiate outwards, to raise all its neighbouring communes in revolt . . . and
to federate with them for common defence."_ [**No Gods, No Masters**, vol. 1,
p. 142]

This was essentially the position agreed by the CNT in May 1936:

> _"The armed people will be the best guarantee against all attempts to
restore the destroyed regime by interior or exterior forces . . . Each Commune
should have its arms and elements of defence."_ [quoted by Robert Alexander,
**The Anarchists in the Spanish Civil War**, vol. 1, p. 64]

Like the CNT with its _"Defence Committees"_ the defence of the revolution
would rest with the commune and its federation. Thus Morrow's _"fundamental
tenet"_ of anarchism does not exist. We have **never** urged the ignoring of
the state nor the idea that seizing economic power will eliminate political
power by itself. Nor is anarchism against the defence of a revolution. The
position of the CNT in May 1936 was identical to that of Bakunin in 1865. The
question is, of course, how do you organise a revolution and its defence -- is
it by the whole people or is it by a party representing that people.
Anarchists argue for the former, Trotskyists the latter. Needless to say, a
state structure (i.e. a centralised, hierarchical structure based on the
delegation of power) is required only when a revolution is seen as rule by a
party -- little wonder anarchists reject the concept of a "workers' state" as
a contradiction in terms.

The question of July 1936 however rears its head. If anarchism **does** stand
for insurrection, workers councils and so on, then why did the CNT ignore the
state? Surely that suggests anarchism is, as Morrow claims, flawed? No, it
does not -- as we argue in some detail in [section 20](append32.md#app20)
this confuses mistakes by **anarchists** with errors in anarchist theory. The
CNT-FAI did not pursue anarchist theory and so July 1936 does not invalidate
anarchism. As Bakunin argued, _"[n]o revolution could succeed . . . unless it
was simultaneously a political and a social revolution."_ [**No Gods, No
Masters**, vol. 1, p. 141] The revolution of July 1936 was a social revolution
(it expropriated capital and revolutionised social relationships across
society) but it was not a political revolution -- in other words, it did not
destroy the state. The CNT refused to do this because of the danger of fascism
and fear of isolation (see [section 20](append32.md#app20)). Little wonder
the social revolution was defeated -- the CNT did not apply basic anarchist
theory. To dismiss anarchist ideas because they were not applied seems
somewhat strange.

To finish this section we must indicate that Morrow's statement concerning
anarchists "turning our backs" to the state and concentrating on property
actually contradicts both Engels and Lenin.

As Lenin notes in **The State and Revolution**, _"Marx agreed with Proudhon on
the necessity of 'smashing' the present state machine. . . [there is]
similarity between Marxism and anarchism (Proudhon and Bakunin) . . . on this
point"_ and that anarchists advocate _"the destruction of the state machine."_
[**Essential Works of Lenin**, p. 310 and p. 358] You can hardly smash the
state or destroy the state machine by "turning your back" to it. Similarly,
Engels argued (although distorting his thought somewhat) that Bakunin saw
_"the **state** as the main evil to be abolished . . . [and] maintains that it
is the **state** which has created capital, that the capitalist has his
capital **only by the grace of the state** . . . [Hence] it is above all the
state which must be done away with . . . organise, and when ALL workers are
won over . . . abolish the state and replace it with the organisation of the
International."_ [**The Marx-Engels Reader**, pp. 728-9] You cannot
_"abolish"_ and _"replace"_ the state by ignoring it ("turning your back to
it"). We must also stress that Engels comments disprove Lenin's assertion that
anarchists _"have absolutely no clear idea of **what** the proletariat will
put in its [the states] place."_ [**Op. Cit.**, p. 358] We have always been
clear, namely a federation of workers' associations (this was the organisation
of the First International). In other, more modern, words, a system of
workers' councils -- a position Marxists only embraced six decades later when
Lenin advocated them as the basis of his "workers' state."

Thus Morrow's comments against anarchism are in contradiction to usual Marxist
claims against anarchism (namely, that we seek to smash the state but do not
understand that the workers' state is necessary to abolish capitalism).
Indeed, Engels attributed the opposite idea to Bakunin that Morrow implies
anarchists think with regards to property -- namely the idea that the
capitalist has his property because of the state. Morrow's _"fundamental
tenet"_ of anarchism not only does not exist in anarchist theory, it does not
even exist in the Marxist critique of that theory! It is impressive enough to
assign a false doctrine to your enemies, it takes real ability to make a claim
which contradicts your own theory's assertions!

## 15\. Did Spanish Anarchism aim for the creation of _"collectives"_ before
the revolution?

The formation of the worker-managed enterprises called _"collectives"_ in the
Spanish revolution of 1936 has sometimes led people (particularly Marxists) to
misconceptions about anarcho-syndicalist and communist-anarchist theory. These
comments by a Marxist-Leninist are typical:

> _"Spanish anarchists believed that a system of autonomous collectives, with
the weakest possible connections between them, was the alternative to
capitalism and also to the Marxist view of society running the entire economy
as one whole."  
>  _

And:

> _"The anarchist theory led to the ordinary anarchist considering each
factory as owned simply by the workers that laboured there, and not by the
working class as a whole."_ [Joseph Green, _"The Black Autonomy Collective and
the Spanish Civil War"_, **Communist Voice** no. 10, Vol. 2, no. 5, Oct. 1,
1996]

This assertion is sometimes voiced by Libertarian Marxists of the council
communist tendency (who should know better):

> _"At the time of the Civil War, a popular idea amongst the Spanish working
class and peasants was that each factory, area of land, etc., should be owned
collectively by its workers, and that these 'collectives' should be linked
with each other on a 'federal' basis - that is, without any superior central
authority.  
>  _

>

> _"This basic idea had been propagated by anarchists in Spain for more than
50 years. When the Civil War began, peasants and working class people in those
parts of the country which had not immediately fallen under fascist control
seized the opportunity to turn anarchist ideal into reality."_ [_"Anarchism
and the Spanish 'Revolution'"_, **Subversion** no. 18]

Trotskyist Felix Morrow also presents a similar analysis when he states that
the POUM _"recorded the tendency of CNT unions to treat collectivised property
as their own. It never attacked the anarcho-syndicalist theories which created
the tendency."_ [**Op. Cit.**, p. 104]

However, the truth of the matter is somewhat different.

Firstly, as will soon become clear, CNT policy and anarchist theory was
**not** in favour of workers' owning their individual workplaces. Instead both
argued for **socialisation** of the means of life by a system of federations
of workers' assemblies. Individual workplaces would be managed by their
workers but they would not exist in isolation or independently of the others
-- they would be members of various federations (minimally an industrial one
and one which united all workplaces regardless of industry in a geographical
area). These would facilitate co-ordination and co-operation between self-
managed workplaces. The workplace would, indeed, be autonomous but such
autonomy did not negate the need for federal organs of co-ordination nor did
federation negate that autonomy (as we will discuss later in [section
18](append32.md#app18), autonomy means the ability to make agreements with
others and so joining a federation is an expression of autonomy and not
necessarily its abandonment, it depends on the nature of the federation).

Secondly, rather than being the product of _"more than 50 years"_ of anarchist
propaganda or of _"anarcho-syndicalist theories"_, the _"collectives"_
instituted during the Civil War were seen by the CNT as merely a temporary
stop-gap. They had not been advocated in the CNT's pre-Civil War program, but
came into existence precisely because the CNT was unable to carry out its
libertarian communist program, which would have required setting up workers
congresses and federal councils to establish co-ordination and aid the
planning of common activities between the self-managed workplaces. In other
words, the idea of self-managed workplaces was seen as one step in a process
of socialisation, the basic building block of a federal structure of workers'
councils. They were **not** seen as an end in themselves no matter how
important they were as the base of a socialised economy.

Thus the CNT had never proposed that factories or other facilities would be
owned by the people who happened to work there. The CNT's program called for
the construction of _"libertarian communism."_ This was the CNT's agreed goal,
recognising it must be freely created from below. In addition, the Spanish
Anarchists argued for _"free experimentation, free show of initiative and
suggestions, as well as the freedom of organisation,"_ recognising that _"[i]n
each locality the degree of [libertarian] communism, collectivism or mutualism
will depend on conditions prevailing. Why dictate rules? We who make freedom
our banner, cannot deny it in economy."_ [D. A. de Santillan, **After the
Revolution**, p. 97] In other words, the CNT recognised that libertarian
communism would not be created overnight and different areas will develop at
different speeds and in different directions depending on the material
circumstances they faced and what their population desired.

However, libertarian communism was the CNTs declared goal. This meant that the
CNT aimed for a situation where the economy as a whole would be socialised and
**not** an mutualist economy consisting independent co-operatives owned and
controlled by their workers (with the producers operating totally
independently of each other on the basis of market exchange). Instead, workers
would manage their workplace directly, but would not own it -- rather
ownership would rest with society as a whole but the day-to-day management of
the means of production would be delegated to those who did the actual work.
Councils of workers' delegates, mandated by and accountable to workplace
assemblies, would be created to co-ordinate activity at all levels of the
economy.

A few quotes will be needed to show that this was, in fact, the position of
the Spanish Anarchists. According to Issac Puente, the _"national federations
will hold as common property all the roads, railways, buildings, equipment,
machinery and workshops."_ The village commune _"will federate with its
counterparts in other localities and with the national industrial
federations."_ [**Libertarian Communism**, p. 29 and p. 26] In D. A. de
Santillan's vision, libertarian communism would see workers' councils
overseeing 18 industrial sectors. There would also be _"councils of the
economy"_ for local, regional and national levels (ultimately, international
as well). [**Op. Cit.**, pp. 50-1 and pp. 80-7] These councils would be
_"constitute[d] by delegations or through assemblies"_ and _"receives [their]
orientation from below and operates in accordance with the resolutions"_ of
their appropriate _"assemblies."_ [**Op. Cit.**, p. 83 and p. 86]

The CNT's national conference in Saragossa during May 1936 stressed this
vision. Its resolution declared that the revolution would abolish _"private
property, the State, the principle of authority, and . . . classes."_ It
argued that _"the economic plan of organisation, throughout national
production, will adjust to the strictest principles of social economy,
directly administered by the producers through their various organs of
production, designated in general assemblies of the various organisations, and
always controlled by them."_ In urban areas, _"the workshop or factory
council"_ would make _"pacts with other labour centres"_ via _"Councils of
Statistics and Production"_ which are the _"organ of relations of Union to
Union (association of producers)"_, in other words, workers' councils. These
would _"federate among themselves, forming a network of constant and close
relations among all the producers of the Iberian Confederation."_ In rural
areas, _"the producers of the Commune"_ would create a _"Council of
Cultivation"_ which would _"establish the same network of relations as the
Workshop, Factory Councils and those of Production and Statistics,
complementing the free federation represented by the Commune."_

The resolution argues that _"[b]oth the Associations of industrial producers
and Associations of agricultural producers will federate nationally"_ and
_"Communes will federate on a county and regional basis . . . Together these
Communes will constitute an Iberian Confederation of Autonomous Libertarian
Communes."_ Being anarchists, the CNT stressed that _"[n]one of these organs
will have executive or bureaucratic character"_ and their members _"will carry
out their mission as producers, meeting after the work day to discuss
questions of details which don't require the decision of the communal
assemblies."_ The assemblies themselves _"will meet as often as needed by the
interests of the Commune. . . When problems are dealt with which affect a
country or province, it must be the Federations which deliberate, and in the
meetings and assemblies all Communities will be represented and the delegates
will bring points of view previously agreed upon"_ by the Commune assembly.
[quoted by Robert Alexander, **The Anarchists in the Spanish Revolution**,
vol. 1, p. 59, p. 60 and p. 62]

Joan Ferrer, a bookkeeper who was the secretary of the CNT commercial workers
union in Barcelona, explained this vision:

> _"It was our idea in the CNT that everything should start from the worker,
not -- as with the Communists -- that everything should be run by the state.
To this end we wanted to set up industrial federations -- textiles, metal-
working, department stores, etc. -- which would be represented on an overall
Economics Council which would direct the economy. Everything, including
economic planning, would thus remain in the hands of the workers."_ [quoted by
Ronald Fraser, **Blood of Spain**, p. 180]

However, social revolution is a dynamic process and things rarely develop
exactly as predicted or hoped in pre-revolutionary times. The "collectives" in
Spain are an example of this. Although the regional union conferences in
Catalonia had put off overthrowing the government in July of 1936, workers
began taking over the management of industries as soon as the street-fighting
had died down. The initiative for this did not come from the higher bodies --
the regional and national committees -- but from the rank-and-file activists
in the local unions. In some cases this happened because the top management of
the enterprise had fled and it was necessary for the workers to take over if
production was to continue. But in many cases the local union militants
decided to take advantage of the situation to end wage labour by creating
self-managed workplaces.

As to be expected of a real movement, mistakes were made by those involved and
the development of the movement reflected the real problems the workers faced
and their general level of consciousness and what they wanted. This is natural
and to denounce such developments in favour of ideal solutions means to
misunderstand the dynamic of a revolutionary situation. In the words of
Malatesta:

> _"To organise a [libertarian] communist society on a large scale it would be
necessary to transform all economic life radically, such as methods of
production, of exchange and consumption; and all this could not be achieved
other than gradually, as the objective circumstances permitted and to the
extent that the masses understood what advantages could be gained and were
able to act for themselves."_ [**Life and Ideas**, p. 36]

This was the situation in revolutionary Spain. Moreover, the situation was
complicated by the continued existence of the bourgeois state. As Gaston
Leval, in his justly famous study of the collectives, states _"it was not . .
. true socialisation, but . . . a self-management straddling capitalism and
socialism, which we maintain would not have occurred had the Revolution been
able to extend itself fully under the direction of our syndicates."_ [Gaston
Leval, **Collectives in the Spanish Revolution**, p. 227-8] Leval in fact
terms it _"a form of workers neo-capitalism"_ but such a description is
inaccurate (and unfortunate) simply because wage labour had been abolished and
so it was not a form of capitalism -- rather it was a form of mutualism, of
workers' co-operatives exchanging the product of their labour on the market.

However, Leval basic argument was correct -- due to the fact the political
aspect of the revolution (the abolition of the state) had been "postponed"
until after the defeat of fascism, the economic aspects of the revolution
would also remain incomplete. The unions that had seized workplaces were
confronted with a dilemma. They had control of their individual workplaces,
but the original libertarian plan for economic co-ordination was precluded by
the continued existence of the State. It was in this context of a partial
revolution, under attack by the counter-revolution, that the idea of
"collectives" was first put forward to solve some of the problems facing the
workers and their self-managed workplaces. Unfortunately, this very "solution"
caused problems of its own. For example, Gaston Leval indicates that the
collectivisation decree of October 1936 _"legalising collectivisation"_,
_"distorted everything right from the start"_ [**Op. Cit.**, p. 227] and did
not allow the collectives to develop beyond a mutualist condition into full
libertarian communism. It basically legalised the existing situation while
hindering its development towards libertarian communism by undermining union
control.

This dilemma of self-managed individual workplaces and lack of federations to
co-ordinate them was debated at a CNT union plenary in September of 1936. The
idea of converting the worker-managed workplaces into co-operatives, operating
in a market economy, had never been advocated by the Spanish anarchists before
the Civil War, but was now seen by some as a temporary stop-gap that would
solve the immediate question of what to do with the workplaces that had been
seized by the workers. It was at this meeting that the term "collective" was
first adopted to describe this solution. This concept of "collectivisation"
was suggested by Joan Fabregas, a Catalan nationalist of middle class origin
who had joined the CNT after July of 1936. As one CNT militant recalled:

> _"Up to that moment, I had never heard of collectivisation as a solution for
industry -- the department stores were being run by the union. What the new
system meant was that each collectivised firm would retain its individual
character, but with the ultimate objective of federating all enterprises
within the same industry."_ [quoted by Ronald Fraser, **Blood of Spain**, p.
212]

However, a number of unions went beyond "collectivisation" and took over all
the facilities in their industries, eliminating competition between separate
firms. The many small barber and beauty shops in Barcelona were shut down and
replaced with large neighbourhood haircutting centres, run through the
assemblies of the CNT barbers' union. The CNT bakers union did something
similar. The CNT Wood Industry Union shut down the many small cabinet-making
shops, where conditions were often dangerous and unhealthy. They were replaced
with two large factories, which included new facilities for the benefit of the
workforce, such as a large swimming pool.

The union ran the entire industry, from the felling of timber in the Val
d'Aran to the furniture showrooms in Barcelona. The railway, maritime shipping
and water, gas and electric industry unions also pursued this strategy of
industrial unification, as did the textile union in the industrial town of
Badalona, outside Barcelona. This was considered to be a step in the direction
of eventual socialisation.

At the Catalan union plenary of September, 1936, _"the bigger, more powerful
unions, like the woodworkers, the transport workers, the public entertainment
union, all of which had already socialised [i.e. unified their industries
under union management], wanted to extend their solution to the rest of
industry. The smaller, weaker unions wanted to form co-operatives. . ."_
[Fraser, **Op. Cit.**, p. 212]

The collectives came out of this conflict and discussion as a sort of "middle
ground" -- however, it should be stressed that it did not stop many unions
from ignoring the Catalan's governments' attempt to legalise (and so control)
the collectives (the so-called _"collectivisation"_ decree) as far as they
could. As Albert Perez-Baro, a Catalan Civil Servant noted, _"the CNT . . .
pursued its own, unilateral objectives which were different. Syndical
collectivisation or syndicalised collectives, I would call those objectives;
that's to say, collectives run by their respective unions . . . The CNT's
policy was thus not the same as that pursued by the decree."_ [quoted by
Fraser, **Op. Cit.**, pp. 212-3] Indeed, Abad de Santillan stated later that
he _"was an enemy of the decree because I considered it premature . . . When I
became [economics] councillor [of the Generalitat for the CNT], I had no
intention of taking into account of carrying out the decree; I intended to
allow our great people to carry on the task as they saw fit, according to
their own aspiration."_ [quoted, **Op. Cit.**, p. 212f]

Therefore, when Leninist Joseph Green argues the initial collectivisation of
workplaces _"was the masses starting to take things into their own hands, and
they showed that they could continue production in their workplaces . . . The
taking over of the individual workplaces and communities is one step in a
revolutionary process. But there is yet more that must be done -- the
workplaces and communities must be integrated into an overall economy"_ he is
just showing his ignorance. The CNT, despite Green's assertions to the
contrary, were well aware that the initial collectivisations were just one
step in the revolution and were acting appropriately. It takes some gall (or
extreme ignorance) to claim that CNT theory, policy and actions were, in fact,
the exact opposite of what they were. Similarly, when he argues _"[h]ow did
the anarchists relate the various workplace collectives to each other in
Barcelona? . . . they made use of a patchwork system including a Central
Labour Bank, an Economic Council, credit . . ."_ he strangely fails to mention
the socialisation attempts made by many CNT industrial unions during the
revolution, attempts which reflected pre-war CNT policy. But such facts would
get in the way of a political diatribe and so are ignored. [Green, **Op.
Cit.**]

Green continues his inaccurate diatribe by arguing that:

> _"The problem is that, saddled with their false theory, they could not
understand the real nature of the economic steps taken in the collectives, and
thus they could not deal with the economic relations that arose among the
collectives."_ [**Op. Cit.**]

However, the only thing false about this is the false assertions concerning
anarchist theory. As is crystal clear from our comments above, the Spanish
anarchists (like all anarchists) were well aware of the need for economic
relations between collectives (self-managed workplaces) before the revolution
and acted to create them during it. These were the industrial federations and
federations of rural communities/collectives predicted in anarchist and CNT
theory and actually created, in part at least, during the revolution itself.

Thus Green's "critique" of anarchism is, in fact, **exactly** what anarchist
theory actually argues and what the Spanish anarchists themselves argued and
tried to implement in all industries. Of course, there are fundamental
differences between the anarchist vision of socialisation and the Leninist
vision of Nationalisation but this does not mean that anarchism is blind to
the necessity of integrating workplaces and communities into a coherent system
of federations of workers' councils (as proven above). However, such
federation has two sources -- it is either imposed from above or agreed to
from below. Anarchists choose the former as the latter negates any claim that
a revolution is a popular, mass movement from below (and, incidentally, the
Leninist claim that the "workers' state" is simply a tool of the workers to
defeat capitalist oppression).

The actual process in Spain towards industrial federations and so
socialisation was dependent on the wishes of the workers involved -- as would
be expected in a true social revolution. For example, the department stores
were collectivised and an attempt to federate the stores failed. The works
councils opposed it, considering the enterprises as their own and were
unwilling to join a federation -- the general assemblies of the collectives
agreed. Joan Ferrer, the secretary of the CNT commercial union, considered it
natural as _"[o]nly a few months before, the traditional relationship between
employer and worker had been overthrown. Now the workers were being asked to
make a new leap -- to the concept of collective ownership. It was asking a lot
to expect the latter to happen overnight."_ [quoted by Fraser, **Op. Cit.**,
p. 220]

However, before Leninists like Green rush in and assert that this proves that
_"anarchist theory led to the ordinary anarchist considering each factory as
owned simply by the workers that laboured there"_ we should point out two
things. Firstly, it was the "ordinary anarchists" who were trying to organise
socialisation (i.e. CNT members and militants). Secondly, the Russian
Revolution also saw workers taking over their workplaces and treating them as
their own property. Leninists like Green would have a fit if we took these
examples to "prove" that Leninism _"led to the ordinary Bolshevik worker
considering each factory as owned simply by the workers that laboured there"_
(which was what the Mensheviks **did** argue in 1917 when Martov _"blamed the
Bolsheviks for creating the local, particularistic attitudes prevailing among
the masses."_ [Samuel Farber, **Before Stalinism**, p. 72]). In other words,
such events are a natural part of the process of a revolution and are to be
expected regardless of the dominant theory in that revolution.

To summarise.

The Spanish revolution does confirm anarchist theory and in no way contradicts
it. While many of the aspects of the collectives were in accord with pre-war
CNT policy and anarchist theory, other aspects of them were in contradiction
to them. This was seen by the militants of the CNT and FAI who worked to
transform these spontaneously created organs of economic self-management into
parts of a socialised economy as required for libertarian communism. Such a
transformation flowed from below and was not imposed from above, as would be
expected in a libertarian social revolution.

As can be seen, the standard Marxist account of the collectives and its
relationship to anarchist theory and CNT policy is simply wrong.

## 16\. How does the development of the collectives indicate the differences
between Bolshevism and anarchism?

As argued in the [last section](append32.md#app15), the collectives formed
during the Spanish Revolution reflected certain aspects of anarchist theory
but not others. They were a compromise solution brought upon by the
development of the revolution and did not, as such, reflect CNT or anarchist
theory or vision bar being self-managed by their workers. The militants of the
CNT and FAI tried to convince their members to federate together and truly
socialise the economy, with various degrees of success. A similar process
occurred during the Russian Revolution of 1917. There workers created factory
committees which tried to introduce workers' self-management of production.
The differences in outcome in these two experiences and the actions of the
Bolsheviks and anarchists indicate well the fundamental differences between
the two philosophies. In this section we discuss the contrasting solutions
pursued by the CNT and the Bolsheviks in their respective revolutions.

The simple fact is that revolutions are complex and dynamic processes which
involve many contradictory developments. The question is how do you push them
forward -- either from below or from above. Both the Spanish and the Russian
revolution were marked by "localism" -- when the workers in a factory consider
it their own property and ignore wider issues and organisation.

Lenin and the Bolsheviks "solved" the problem of localism by eliminating
workers' self-management in favour of one-man management appointed from above.
Attempts by the workers and factory committees themselves to combat localism
were stopped by the Bolshevik dominated trade unions which _"prevented the
convocation of a planned All-Russian Congress of Factory Committees"_ in
November 1917 when _"called upon"_ by the Bolsheviks _"to render a special
serve to the nascent Soviet State and to discipline the Factory Committees."_
[I. Deutscher, quoted by Maurice Brinton, **The Bolsheviks and Workers'
Control**, p. 19] Instead, the Bolsheviks built from the top-down their system
of _"unified administration"_ based on converting the Tsarist system of
central bodies which governed and regulated certain industries during the war.
[Brinton, **Op. Cit.**, p. 36] The CNT, in comparison, tried to solve the
problem of localism by a process of discussion and debate from below. Both
were aware of the fact the revolution was progressing in ways different from
their desired goal but their solution reflected their different politics --
libertarian in the case of the CNT, authoritarian in the case of Bolshevism.

Therefore, the actual economic aspects of the Spanish revolution reflected the
various degrees of political development in each workplace and industry. Some
industries socialised according to the CNT's pre-war vision of libertarian
communism, others remained at the level of self-managed workplaces in spite of
the theories of the union and anarchists. This was the case with other aspects
of the collectives. As Vernon Richards points out, _"[i]n some factories . . .
the profits or income were shared out among the workers . . . As a result,
wages fluctuated in different factories and even within the same industry . .
. But fortunately . . . the injustice of this form of collectivisation was
recognised and combated by the CNT syndicates from the beginning."_ [**Lessons
of the Spanish Revolution**, pp. 106-7]

Thus the collectives, rather than expressing the economic vision of communist-
anarchism or anarcho-syndicalism, came into existence precisely because the
CNT was unable to carry out its libertarian communist program, which would
have required setting up workers congresses and co-ordinating councils to
establish common ownership and society wide self-management. To assert that
the collectives were an exact reflection of anarchist or anarcho-syndicalist
theory is, therefore, incorrect. Rather, they reflected certain aspects of
that theory (such as workers' self-management in the workplace) while others
(industrial federations to co-ordinate economic activity, for example) were
only partially meet. This, we must stress, is to be expected as a revolution
is a **process** and not an event. As Kropotkin argued:

> _"It is a whole insurrectionary period of three, four, perhaps five years
that we must traverse to accomplish our revolution in the property system and
in social organisation."_ [**Words of a Rebel**, p. 72]

Thus the divergence of the actual revolution from the program of the CNT was
to be expected and so did not represent a failure or a feature of anarchist or
anarcho-syndicalist theory as Morrow and other Marxists assert. Rather, it
expresses the nature of a social revolution, a movement from below which, by
its very nature, reflects real needs and problems and subject to change via
discussion and debate. Bakunin's comments stress this aspect of the
revolution:

> _"I do not say that the peasants [and workers], freely organised from the
bottom up, will miraculously create an ideal organisation, confirming in all
respects to our dreams. But I am convinced that what they construct will be
living and vibrant, a thousands times better and more just than any existing
organisation. Moreover, this . . . organisation, being on the one hand open to
revolutionary propaganda . . . , and on the other, not petrified by the
intervention of the State . . . will develop and perfect itself through free
experimentation as fully as one can reasonably expect in our times.  
>  _

>

> _"With the abolition of the State, the spontaneous self-organisation of
popular life . . . will revert to the communes. The development of each
commune will take its point of departure the actual condition of its
civilisation . . ."_ [**Bakunin on Anarchism**, p. 207]

To **impose** an "ideal" solution would destroy a revolution -- the actions
and decisions (**including what others may consider mistakes**) of a free
people are infinitely more productive and useful than the decisions and
decrees of the best central committee. Moreover, a centralised system by
necessity is an imposed system (as it excludes by its very nature the
participation of the mass of the people in determining their own fate). As
Bakunin argued, _"Collectivism could be imposed only on slaves, and this kind
of collectivism would then be the negation of humanity. In a free community,
collectivism can come about only through the pressure of circumstances, not by
imposition from above but by a free spontaneous movement from below."_ [**Op.
Cit.**, p. 200] Thus socialisation must proceed from below, reflecting the
real development and desires of those involved. To "speed-up" the process via
centralisation can only result in replacing socialisation with nationalisation
and the elimination of workers' self-management with hierarchical management.
Workers' again would be reduced to the level of order-takers, with control
over their workplaces resting not in their hands but in those of the state.

Lenin argued that _"Communism requires and presupposes the greatest possible
centralisation of large-scale production throughout the country. The all-
Russian centre, therefore, should definitely be given the right of direct
control over all the enterprises of the given branch of industry. The regional
centres define their functions depending on local conditions of life, etc., in
accordance with the general production directions and decisions of the
centre."_ He continued by explicitly arguing that _"[t]o deprive the all-
Russia centre of the right to direct control over all the enterprises of the
given industry . . . would be regional anarcho-syndicalism, and not
communism."_ [Marx, Engels and Lenin, **Anarchism and Anarcho-Syndicalism**,
p. 292]

We expect that Morrow would subscribe to this "solution" to the problems of a
social revolution generates. However, such a system has its own problems.

First is the basic fallacy that the centre will not start to view the whole
economy as its property (and being centralised, such a body would be difficult
to effectively control). Indeed, Stalin's power was derived from the state
bureaucracy which ran the economy in its own interests. Not that it suddenly
arose with Stalin. It was a feature of the Soviet system from the start.
Samuel Farber, for example, notes that, _"in practice, [the]
hypercentralisation [pursued by the Bolsheviks from early 1918 onwards] turned
into infighting and scrambles for control among competing bureaucracies"_ and
he points to the _"not untypical example of a small condensed milk plant with
few than 15 workers that became the object of a drawn-out competition among
six organisations including the Supreme Council of National Economy, the
Council of People's Commissars of the Northern Region, the Vologda Council of
People's Commissars, and the Petrograd Food Commissariat."_ [**Op. Cit.**, p.
73] In other words, centralised bodies are not immune to viewing resources as
their own property (and compared to an individual workplace, the state's power
to enforce its viewpoint against the rest of society is considerably
stronger).

Secondly, to eliminate the dangers of workers' self-management generating
"propertarian" notions, the workers' have to have their control over their
workplace reduced, if not eliminated. This, by necessity, generates
**bourgeois** social relationships and, equally, appointment of managers from
above (which the Bolsheviks did embrace). Indeed, by 1920 Lenin was boasting
that in 1918 he had _"pointed out the necessity of recognising the dictatorial
authority of single individuals for the pursue of carrying out the Soviet
idea"_ and even claimed that at that stage _"there were no disputes in
connection with the question"_ of one-man management. [quoted by Brinton,
**Op. Cit.**, p. 65] While the first claim is true (Lenin argued for one-man
management appointed from above **before** the start of the Civil War in May
1918) the latter one is **not** true (excluding anarchists and anarcho-
syndicalists, there were also the dissent Left-Communists in the Bolshevik
party itself).

Thirdly, a centralised body effectively excludes the mass participation of the
mass of workers -- power rests in the hands of a few people which, by its
nature, generates bureaucratic rule. This can be seen from the example of
Lenin's Russia. The central bodies the Bolsheviks created had little knowledge
of the local situation and often gave orders that contradicted each other or
had little bearing to reality, so encouraging factories to ignore the centre.
In other words the government's attempts to centralise actually led to
localism (as well as economic mismanagement)! Perhaps this was what Green
means when he argues for a _"new centralism"_ which would be _"compatible with
and requiring the initiative of the workers at the base"_ [Green **Op.
Cit.**]-- that is, the initiative of the workers to ignore the central bodies
and keep the economy going **in spite** of the _"new centralism"_?

The simple fact is, a socialist society **must** be created from below, by the
working class itself. If the workers do not know how to create the necessary
conditions for a socialist organisation of labour, no one else can do it for
them or compel them to do it. If the state is used to combat "localism" and
such things then it obviously cannot be in the hands of the workers'
themselves. Socialism can only be created by workers' own actions and
organisations otherwise it will not be set up at all -- something else will
be, namely state capitalism.

Thus, a close look at Lenin's "solution" indicates that Trotskyist claim that
their state is the _"tool of the majority in their fight against exploitation
by the few"_ (to use Joseph Green's words) is refuted by their assertion that
this state will also bring the economy under centralised control and by the
actions of the Bolsheviks themselves.

Why is this? Simply because **if** the mass of collectives are not interested
in equality and mutual aid in society as a whole then how can the government
actually be the "tool" of the majority when it imposes such "mutual aid" and
"equality" upon the collectives? In other words, the interests of the
government replace those of the majority. After all, if workers **did** favour
mutual aid and equality then they would federate themselves to achieve it.
(which the collectives were actually doing all across Spain, we must note). If
they do not do this then how can the "workers' state" be said to be simply
their tool when it has to **impose** the appropriate economic structure upon
them? The government is elected by the whole people, so it will be claimed,
and so must be their tool. This is obviously flawed -- _"if,"_ argued
Malatesta, _"you consider these worthy electors as unable to look after their
own interests themselves, how is it that they will know how to choose for
themselves the shepherds who must guide them? And how will they be able to
solve this problem of social alchemy, of producing a genius from the votes of
a mass of fools? And what will happen to the minorities which are still the
most intelligent, most active and radical part of a society?"_ [Malatesta,
**Anarchy**, p. 53]

What does all this mean? Simply that Trotskyists recognise, implicitly at
least, that the workers' state is not, in fact, the simple tool of the
workers. Rather, it is the means by which "socialism" will be imposed upon the
workers by the party. If workers do not practice mutual aid and federation in
their day-to-day running of their lives, then how can the state impose it if
it is simply their tool? It suggests what is desired _"by all of the working
people as a whole"_ (nearly always a euphemism for the party in Trotskyist
ideology) is different that what they actually want (as expressed by their
actions). In other words, a conflict exists between the workers' and the so-
called "workers' state" -- in Russia, the party imposed **its** concept of the
interests of the working class, even against the working class itself.

Rather than indicate some kind of failure of anarchist theory, the experience
of workers' self-management in both Spain and Russia indicate the
authoritarian core of Trotskyist ideology. If workers do not practice mutual
aid or federation then a state claiming to represent them, to be simply their
tool, cannot force them to do so without exposing itself as being an alien
body with power **over** the workers.

For these reasons Bakunin was correct to argue that anarchists have _"no faith
except in freedom. Both [Marxists and anarchists], equally supporters of
science which is to destroy superstition and replace belief, differ in the
former wishing to impose it, and the latter striving to propagate it; so human
groups, convinced of its truth, may organise and federate spontaneously,
freely, from the bottom up, by their own momentum according to their real
interests, but never according to any plan laid down in advance and imposed
upon the **ignorant masses** by some superior intellects."_ Anarchists, he
continues, _"think that there is much more practical and intellectual common
sense in the instinctive aspirations and in the real needs of the mass of the
people than in the profound intelligence of all these doctors and teachers of
mankind who, after so many fruitless attempts to make humanity happy, still
aspire to add their own efforts."_ [**Michael Bakunin: Selected Writings**, p.
198]

In summary, the problem of "localism" and any other problems faced by a social
revolution will be solved in the interests of the working class only if
working class people solve them themselves. For this to happen it requires
working class people to manage their own affairs directly and that implies
self-managed organising from the bottom up (i.e. anarchism) rather than
delegating power to a minority at the top, to a "revolutionary" party or
government. This applies economically, socially and politically. As Bakunin
argued, the _"revolution should not only be made for the people's sake; it
should also be made by the people."_ [**No Gods, No Masters**, vol. 1, p. 141]

Thus the actual experience of the collectives and their development, rather
than refuting anarchism, indicates well that it is the only real form of
socialism. Attempts to nationalise the means of production inevitably
disempower workers and eliminate meaningful workers' self-management or
control. It does not eliminate wage labour but rather changes the name of the
boss. Socialism can only be built from below. If it is not, as the Russian
experience indicated, then state capitalism will be the inevitable outcome.

## 17\. Why is Morrow's support for _"proletarian methods of production"_
ironic?

Morrow states _"[i]n the midst of civil war the factory committees are
demonstrating the superiority of proletarian methods of production."_ [**Op.
Cit.**, p. 53] This is ironic as the Bolsheviks in power fought against the
factory committees and their attempts to introduce the kind of workers' self-
management Morrow praises in Spain (see Maurice Brinton's **The Bolsheviks and
Workers' Control** for details). Moreover, rather than seeing workers' self-
management as _"proletarian methods of production"_ Lenin and Trotsky thought
that how a workplace was managed was irrelevant under socialism. Trotsky
argued that _"[i]t would be a most crying error to confuse the question as to
the supremacy of the proletariat with the question of boards of workers at the
head of factories. The dictatorship of the proletariat is expressed in the
abolition of private property in the means of production, in the supremacy of
the collective will of the workers [a euphemism for the Party -- M.B.] and not
at all in the form in which individual economic organisations are
administered."_ Indeed, _"I consider if the civil war had not plundered our
economic organs of all that was strongest, most independent, most endowed with
initiative, we should undoubtedly have entered the path of one-man management
in the sphere of economic administration much sooner and much less
painfully."_ [quoted by Maurice Brinton, **Op. Cit.**, p. 66 and pp. 66-7]

In other words, Trotsky both in theory and in practice opposed _"proletarian
methods of production"_ \-- and if the regime introduced by Trotsky and Lenin
in Russia was **not** based on _"proletarian methods of production"_ then what
methods was it based on? One-man management with _"the appointment of
individuals, dictators with unlimited powers"_ by the government and _"the
people **unquestioningly obey[ing] the single will** of the leaders of
labour."_ [**The Immediate Tasks of the Soviet Government**, p. 32 and p. 34]
In other words, the usual **bourgeois** methods of production with the
workers' doing what the boss tells them. At no time did the Bolsheviks support
the kind of workers' self-management introduced by the anarchist influenced
workers of Spain -- indeed they hindered it and replaced it with one-man
management at the first opportunity (see Maurice Brinton's classic **The
Bolsheviks and Workers' Control** for details).

To point out the obvious, bourgeois methods of production means bourgeois
social relations and relations of production. In other words, Morrow comments
allows us to see that Lenin and Trotsky's regime was not proletarian at the
point of production. How ironic. And if it was not proletarian at the point of
production (i.e. at the source of **economic** power) how could it remain
proletarian at the political level? Unsurprisingly, it did not -- party power
soon replaced workers' power and the state bureaucracy replaced the party.

Yet again Morrow's book exposes the anti-revolutionary politics of Trotskyism
by allowing anarchists to show the divergence between the rhetoric of that
movement and what it did when it was in power. Morrow, faced with a workers'
movement influenced by anarchism, inadvertently indicates the poverty of
Trotskyism when he praises the accomplishments of that movement. The reality
of Leninism in power was that it eliminated the very things Morrow praises --
such as _"proletarian methods of production,"_ democratic militias, workers'
councils and so on. Needless to say, the irony of Morrow's work is lost on
most of the Trotskyists who read it.

## 18\. Were the federations of collectives an _"abandonment"_ of anarchist
ideas?

From our discussion in [section 15](append32.md#app15), it is clear that
anarchism does not deny the need for co-ordination and joint activity, for
federations of self-managed workplaces, industries and rural collectives at
all levels of society. Far from it. As proven in sections
[12](append32.md#app12) and [15](append32.md#app15), such federations are
a basic idea of anarchism. In anarchy co-ordination flows **from below** and
not imposed by a few from above. Unfortunately Marxists cannot tell the
difference between solidarity from below and unity imposed from above. Morrow,
for example, argues that _"the anarchist majority in the Council of Aragon led
in practice to the abandonment of the anarchist theory of the autonomy of
economic administration. The Council acted as a centralising agency."_ [**Op.
Cit.**, pp. 205-6]

Of course it does nothing of the kind. Yes, anarchists are in favour of
autonomy -- including the autonomy of economic administration. We are also in
favour of federalism to co-ordinate join activity and promote co-operation on
a wide-scale (what Morrow would, inaccuracy, call "centralism" or
"centralisation"). Rather than seeing such agreements of joint activity as the
"abandonment" of autonomy, we see it as an **expression** of that autonomy. It
would be a strange form of "freedom" that suggested making arrangements and
agreements with others meant a restriction of your liberty. For example, no
one would argue that to arrange to meet your friend at a certain place and
time meant the elimination of your autonomy even though it obviously reduces
your "liberty" to be somewhere else at the same time.

Similarly, when an individual joins a group and takes part in its collective
decisions and abides by their decisions, this does not represent the
abandonment of their autonomy. Rather, it is an expression of their freedom.
If we took Morrow's comment seriously then anarchists would be against all
forms of organisation and association as they would mean the _"abandonment of
autonomy"_ (of course some Marxists **do** make that claim, but such a
position indicates an essentially **negative** viewpoint of liberty, a
position they normally reject). In reality, of course, anarchists are aware
that freedom is impossible outside of association. Within an association
absolute "autonomy" cannot exist, but such "autonomy" would restrict freedom
to such a degree that it would be so self-defeating as to make a mockery of
the concept of autonomy and no sane person would seek it.

Of course anarchists are aware that even the best association could turn into
a bureaucracy that **does** restrict freedom. Any organisation could transform
from being an expression of liberty into a bureaucratic structure which
restricts liberty because power concentrates at the top, into the hands of an
elite. That is why we propose specific forms of organisation, ones based on
self-management, decentralisation and federalism which promote decision-making
from the bottom-up and ensure that the organisation remains in the hands of
its members and its policies are agreements between them rather than ones
imposed upon them. For this reason the basic building block of the federation
is the autonomous group assembly. It is this body which decides on its own
issues and mandates delegates to reach agreements within the federal
structure, leaving to itself the power to countermand the agreements its
delegates make. In this way autonomy is combined with co-ordination in an
organisation that is structured to accurately reflect the needs and interests
of its members by leaving power in their hands. In the words of Murray
Bookchin, anarchists _"do not deny the need for co-ordination between groups,
for discipline, for meticulous planning, and for unity in action. But [we]
believe that co-ordination, discipline, planning, and unity in action must be
achieved **voluntarily,** by means of self-discipline nourished by conviction
and understanding, not by coercion and a mindless, unquestioning obedience to
orders from above."_ [**Post-Scarcity Anarchism**, p. 215]

Therefore, anarchist support for _"the autonomy of economic administration"_
does not imply the lack of co-operation and co-ordination, of joint agreements
and federal structures which may, to the uninformed like Morrow, seem to imply
the _"abandonment"_ of autonomy. As Kropotkin argued, the commune _"cannot any
longer acknowledge any superior: that, above it, there cannot be anything,
save the interests of the Federation, freely embraced by itself in concert
with other Communes."_ [**No Gods, No Masters**, vol. 1, p. 259] This vision
was stressed in the CNT's Saragossa resolution on Libertarian Communism made
in May, 1936, which stated that the _"the foundation of this administration
will be the commune. These communes are to be autonomous and will be federated
at regional and national levels to achieve their general goals. The right to
autonomy does not preclude the duty to implement agreements regarding
collective benefits."_ [quoted by Jose Peirats, **The CNT in the Spanish
Revolution**, p. 106] Hence anarchists do not see making collective decisions
and working in a federation as an abandonment of autonomy or a violation of
anarchist theory.

The reason for this is simple. To exercise your autonomy by joining self-
managing organisations and, therefore, agreeing to abide by the decisions you
help make is not a denial of that autonomy (unlike joining a hierarchical
structure, we must stress). That is why anarchists have always stressed the
importance of the **nature** of the associations people join **as well as**
their voluntary nature -- as Kropotkin argued, the _"communes of the next
revolution will not only break down the state and substitute free federation
for parliamentary rule; they will part with parliamentary rule within the
commune itself . . . They will be anarchist within the commune as they will be
anarchist outside it."_ [**The Commune of Paris**] Moreover, within the
federal structures anarchists envision, the actual day-to-day running of the
association would be autonomous. There would be little or no need for the
federation to interfere with the mundane decisions a group has to make day in,
day out. As the Saragossa resolution makes clear:

> _ "[The] commune . . . will undertake to adhere to whatever general norms
may be agreed by majority vote after free debate . . . The inhabitants of a
commune are to debate among themselves their internal problems . . .
Federations are to deliberate over major problems affecting a country or
province and all communes are to be represented at their reunions and
assemblies, thereby enabling their delegates to convey the democratic
viewpoint of their respective communes . . . every commune which is implicated
will have its right to have its say . . . On matters of a regional nature, it
is the duty of the regional federation to implement agreements . . . So the
starting point is the individual, moving on through the commune, to the
federation and right on up finally to the confederation."_ [quoted by Jose
Peirats, **Op. Cit.**, pp. 106-7]

Since the Council of Aragon and the Federation of Collectives were based on a
federal structure, regular meetings of mandated delegates and decision-making
from the bottom up, it would be wrong to call them a _"centralising agency"_
or an _"abandonment"_ of the principle of _"autonomy."_ Rather, they were
expressions of that autonomy based around a **federal** and not centralised
organisation. The autonomy of the collective, of its mass assembly, was not
restricted by the federation nor did the federation interfere with the day to
day running of the collectives which made it up. The structure was a
federation of autonomous collectives. The role of the Council was to co-
ordinate the decisions of the federation delegate meetings -- in other words,
purely administrative implementation of collective agreements. To confuse this
with centralisation is a mistake common to Marxists, but it is still a
confusion.

To summarise, what Morrow claims is an _"abandonment"_ of anarchism is, in
fact, an expression of anarchist ideas. The Council of Aragon and the Aragon
Federation of Collectives were following the CNT's vision of libertarian
communism and not abandoning it, as Morrow claims. As anyone with even a basic
understanding of anarchism would know.

## 19\. Did the experience of the rural collectives refute anarchism?

Some Leninists attack the rural collectives on similar lines as they attack
the urban ones (as being independent identities and without co-ordination --
see [section 15](append32.md#app15) for details). They argue that
_"anarchist theory"_ resulted in them considering themselves as being
independent bodies and so they ignored wider social issues and organisation.
This meant that anarchist goals could not be achieved:

> _"Let's evaluate the Spanish collectives according to one of the basic goals
set by the anarchists themselves. This was to ensure equality among the
toilers. They believed that the autonomous collectives would rapidly equalise
conditions among themselves through 'mutual aid' and solidarity. This did not
happen . . . conditions varied greatly among the Spanish collectives, with
peasants at some agricultural collectives making three times that of peasants
at other collectives."_ [Joseph Green, **Op. Cit.**]

Of course, Green fails to mention that in the presumably "centralised" system
created by the Bolsheviks, the official rationing system had a differentiation
of **eight to one** under the class ration of May 1918. By 1921, this,
apparently, had fallen to around four to one (which is still higher than the
rural collectives) but, in fact, remained at eight to one due to workers in
selected defence-industry factories getting the naval ration which was
approximately double that of the top civilian workers' ration. [Mary McAuley,
**Bread and Justice: State and Society in Petrograd 1917-1922**, pp. 292-3]
This, we note, ignores the various privileges associated with state office and
Communist Party membership which would increase differentials even more (and
such inequality extended into other fields, Lenin for example warned in 1921
against _"giving non-Party workers a false sense of having some increase in
their rights"_ [Marx, Engels and Lenin, **Op. Cit.**, p. 325]). The various
resolutions made by workers for equality in rations were ignored by the
government (all this long before, to use Green's words _"their party
degenerated into Stalinist revisionism"_).

So, if equality is important, then the decentralised rural collectives were
far more successful in achieving it than the "centralised" system under Lenin
(as to be expected, as the rank-and-file were in control, not a few at the
top).

Needless to the collectives could not unify history instantly. Some towns and
workplaces started off on a more favourable position than others. Green quotes
an academic (David Miller) on this:

> _"Such variations no doubt reflected historical inequalities of wealth, but
at the same time the redistributive impact of the [anarchist] federation had
clearly been slight."  
>  _

Note that Green implicitly acknowledges that the collectives **did** form a
federation. This makes a mockery of his claims that earlier claims that the
anarchists _"believed that the village communities would enter the realm of a
future liberated society if only they became autonomous collectives. They
didn't see the collectives as only one step, and they didn't see the need for
the collectives to be integrated into a broader social control of all
production."_ [**Op. Cit.**] As proven above, such assertions are either the
product of ignorance or a conscious lie. We quoted numerous Spanish anarchist
documents that stated the exact opposite to Green's assertions. The Spanish
anarchists were well aware of the need for self-managed communities to
federate. Indeed, the federation of collectives fits **exactly** pre-war CNT
policy and anarchist theory (see sections [15](append32.md#app15) and
[18](append32.md#app18) for details). To re-quote a Spanish Anarchist
pamphlet, the village commune _"will federate with its counterparts in other
localities and with the national industrial federations."_ [Issac Puente,
**Libertarian Communism**, p. 26] Thus what Green asserts the CNT and FAI did
not see the need of, they in fact **did** see the need for and argued for
their creation before the Civil War and actually created during it! Green's
comments indicate a certain amount of "doublethink" -- he maintains that the
anarchists rejected federations while acknowledging they did federate.

However, historical differences are the product of **centuries** and so it
will take some time to overcome them, particularly when such changes are not
imposed by a central government. In addition, the collectives were not allowed
to operate freely and were soon being hindered (if not physically attacked) by
the state within a year. Green dismisses this recognition of reality by
arguing _"one could argue that the collectives didn't have much time to
develop, being in existence for only two and a half years at most, with the
anarchists only having one year of reasonably unhindered work, but one could
certainly not argue that this experience confirmed anarchist theory."_
However, his argument is deeply flawed for many reasons.

Firstly, we have to point out that Green quotes Miller who is using data from
collectives in Castille. Green, however, was apparently discussing the
collectives of Aragon and the Levante and their respective federations (as was
Miller). To state the obvious, it is hard to evaluate the activities of the
Aragon or Levante federation using data from collectives in the Castille
federation. Moreover, in order to evaluate the redistributive activities of
the federations you need to look at the differentials before and after the
federation was created. The data Miller uses does not do that and so the lack
of success of the federation cannot be evaluated using Green's source. Thus
Green uses data which is, frankly, a joke to dismiss anarchism. This says a
lot about the quality of his critique.

As far as the Castille federation goes, Robert Alexander notes _"[a]nother
feature of the work of regional federation was that of aiding the less
fortunate collectives. Thus, within a year, it spent 2 000 000 pesetas on
providing chemical fertilisers and machines to poorer collectives, the money
from this being provided by the sale of products of the wealthier ones."_
[**The Anarchists in the Spanish Civil War**, vol. 1, p. 438] He also quotes
an article from an anarchist paper which states _"there does not yet exist
sufficient solidarity"_ between rich and poor collectives and that notes _"the
difficulties which the State has put in the way of the development of the
collectives."_ [**Op. Cit.**, p. 439] Thus the CNT was open about the
difficulties it was experiencing in the collectives and the problems facing
it.

Secondly, the collectives may have been in existence for about one year before
the Stalinists attacked but their federations had not. The Castille federation
was born in April, 1937 (the general secretary stated in July of that year
_"[w]e have fought terrible battles with the Communists"_ [**Op. Cit.**, p.
446]). The Aragon federation was created in February 1937 (the Council of
Aragon was created in October 1936) and the Communists under Lister attacked
in August 1937. The Levante federation was formed a few weeks after the start
of the war and the attacks against them started in March 1937. The longest
period of free development, therefore, was only **seven** months and not a
year. Thus the federations of collectives -- the means seen by anarchist
theory to co-ordinate economic and social activities and promote equality --
existed for only a few months before they were physically attacked by the
state. Green expects miracles if he thinks history can be nullified in half a
year.

Thirdly, anarchists do not think communist-anarchism, in all its many aspects,
is possible overnight. Anarchists are well aware, to quote Kropotkin, the
_"revolution may assume a variety of characters and differing degrees of
intensity among different peoples."_ [**No Gods, No Masters**, vol. 1, p. 231]
Also, as noted above, we are well aware that a revolution is a **process**
(_"By revolution we do not mean just the insurrectionary act"_ [Malatesta,
**Life and Ideas**, p. 156]) which will take some time to fully develop once
the state has been destroyed and capital expropriated. Green's assertion that
the Spanish Revolution refutes anarchist theory is clearly a false one.

Green argues that a _"vast organisational task faces the oppressed masses who
are rising up to eliminate the old exploiting system, but anarchist theory
just brushes aside this problem -- co-ordination between collective would
supposedly be easily accomplished by 'mutual aid' or 'voluntary co-operation'
or, if absolutely need be, by the weakest possible federation."_ [**Op.
Cit.**] As can be seen from our discussion, such a claim is a false one.
Anarchists are well aware of difficulties involved in a revolution. That is
why we stress that revolution must come from below, by the actions of the
oppressed themselves -- it is far too complex to left to a few party leaders
to decree the abolition of capitalism. Moreover, as proven above anarchist
theory and practice is well aware of the need for organisation, co-operation
and co-ordination. We obviously do not _"brush it aside."_ This can be seen
from Green's reference to _"the weakest possible federation."_ This obviously
is a cover just in case the reader is familiar with anarchist theory and
history and knows that anarchists support the federation of workers'
associations and communes as the organisational framework of a revolution and
of the free society.

This distorted vision of anarchism even extents to other aspects of the
revolution. Green decides to attack the relative lack of international links
the Spanish anarchist movement had in 1936. He blames this on anarchist theory
and states _"again the localist anarchist outlook would go against such
preparations. True, the anarchists had had their own International association
in the 1870s, separate from the original First International and the Marxists.
It had flopped so badly that the anarchists never tried to resuscitate it and
seem to prefer to forget about it. Given anarchist localism, it is not
surprising that this International doesn't even seem to be been missed by
current-day anarchists."_ [**Op. Cit.**]

Actually, the anarchist International came out of the First International and
was made up of the libertarian wing of that association. Moreover, in 1936 the
CNT was a member of the International Workers' Association founded in 1922 in
Berlin. The IWA was small, but this was due to state and Fascist repression.
For example, the German FAUD, the Italian USI and the FORA in Argentina had
all been destroyed by fascist governments. However, those sections which did
exist (such as the Swedish SAC and French CGTSR) **did** send aid to Spain and
spread CNT and FAI news and appeals (as did anarchist groups across the
world). The IWA still exists today, with sections in over a dozen countries
(including the CNT in Spain). In addition, the International Anarchist
Federation also exists, having done so for a number of decades, and also has
sections in numerous countries. In other words, Green either knows nothing
about anarchist history and theory or he does and is lying.

He attacks the lack of CNT support for Moroccan independence during the war
and states _"[t]hey just didn't seem that concerned with the issue during the
Civil War."_ Actually, many anarchists **did** raise this important issue.
Just one example, Camillo Berneri argued that _"we must intensify our
propaganda in favour of Morocco autonomy."_ [_"What can we do?"_, **Cienfuegos
Press Anarchist Review**, no. 4, p. 51] Thus to state _"the anarchists . . .
didn't seem that concerned"_ is simply false. Many anarchists were and
publicly argued for it. Trapped as a minority force in the government, the CNT
could not push through this position.

Green also points out that inequality existed between men and woman. He even
quotes the anarchist women's organisation Mujeres Libres to prove his point.
He then notes what the Bolsheviks did to combat sexism, _"[a]mong the methods
of influence was mobilising the local population around social measures
promulgated throughout the country. The banner of the struggle was not
autonomy, but class-wide effort."_ Two points, Mujeres Libres was a nation
wide organisation which aimed to end sexism by collective action inside and
outside the anarchist movement by organising women to achieve their own
liberation (see Martha Ackelsberg's , **Free Women of Spain** for more
details). Thus its aims and mode of struggle **was** _"class-wide"_ \-- as
anyone familiar with that organisation and its activities would know.
Secondly, why is equality between men and women important? Because inequality
reduces the freedom of women to control their own lives, in a word, it hinders
they **autonomy.** Any campaign against sexism is based on the banner of
autonomy -- that Green decides to forget this suggests a lot about his
politics.

Thus Green gets it wrong again and again. Such is the quality of most Leninist
accounts of the Spanish revolution.

## 20\. Does the experience of the Spanish Revolution indicate the failure of
anarchism or the failure of anarchists?

Marxists usually point to the events in Catalonia after July 19th, 1936, as
evidence that anarchism is a flawed theory. They bemoan the fact that, when
given the chance, the anarchists did not _"seize power"_ and create a
_"dictatorship of the proletariat."_ To re-quote Trotsky:

> _"A revolutionary party, even having seized power (of which the anarchist
leaders were incapable in spite of the heroism of the anarchist workers), is
still by no means the sovereign ruler of society."_ [**Stalinism and
Bolshevism**]

However, as we argued in [ section 12](append32.md#app12), the Trotskyist
"definition" of "workers' power" and "proletarian dictatorship" is, in fact,
party power, party dictatorship and party sovereignty -- **not** working class
self-management. Indeed, in a letter written in 1937, Trotsky clarified what
he meant: _"Because the leaders of the CNT renounced dictatorship **for
themselves** they left the place open for the Stalinist dictatorship."_ [our
emphasis, **Writings 1936-7**, p. 514]

Hence the usual Trotskyist lament concerning the CNT is that the anarchist
leaders did not seize power themselves and create the so-called _"dictatorship
of the proletariat"_ (i.e. the dictatorship of those claiming to represent the
proletariat). A strange definition of _"workers' power,"_ we must admit. The
"leaders" of the CNT and FAI quite rightly rejected such a position --
unfortunately they also rejected the anarchist position at the same time, as
we will see.

Trotsky states that the _"leaders of the CNT . . . explained their open
betrayal of the theory of anarchism by the pressure of 'exceptional
circumstances' . . . Naturally, civil war is not a peaceful and ordinary but
an 'exceptional circumstance.' Every serious revolutionary organisation,
however, prepares precisely for 'exceptional circumstances.'"_ [_"Stalinism
and Bolshevism"_, **Op. Cit.**, p. 16]

Trotsky is, for once, correct. We will ignore the obvious fact that his own
(and every other Leninist) account of the degeneration of the Russian
Revolution into Stalinism is a variation of the _"exceptional circumstances"_
excuse and turn to his essential point. In order to evaluate anarchism and the
actions of the CNT we have to evaluate **all** the revolutionary situations it
found itself in, **not** just July, 1936 in Catalonia. This is something
Trotsky and his followers seldom do -- for reasons that will become clear.

Obviously space considerations does not allow us to discuss every
revolutionary situation anarchism faced. We will, therefore, concentrate on
the Russian Revolution and the activities of the CNT in Spain in the 1930s.
These examples will indicate that rather than signifying the failure of
anarchism, the actions of the CNT during the Civil War indicate the failure of
anarchists to apply anarchist theory and so signifies a betrayal of anarchism.
In other words, that anarchism is a valid form of revolutionary politics.

If we look at the Russian Revolution, we see anarchist theory gain its most
wide scale influence in those parts of the Ukraine protected by the Makhnovist
army. The Makhnovists fought against White (pro-Tsarist), Red and Ukrainian
Nationalists in favour of a system of _"free soviets"_ in which the _"working
people themselves must freely choose their own soviets, which are to carry out
the will and desires of the working people themselves. that is to say,
**administrative**, not ruling councils."_ As for the economy, the _"land, the
factories, the workshops, the mines, the railroads and the other wealth of the
people must belong to the working people themselves, to those who work in
them, that is to say, they must be socialised."_ [_"Some Makhnovist
Proclamations"_, contained in Peter Arshinov, **The History of the Makhnovist
Movement**, p. 273]

To ensure this end, the Makhnovists refused to set up governments in the towns
and cities they liberated, instead urging the creation of free soviets so that
the working people could govern themselves. Taking the example of
Aleksandrovsk, once they had liberated the city the Makhnovists _"immediately
invited the working population to participate in a general conference . . . it
was proposed that the workers organise the life of the city and the
functioning of the factories with their own forces and their own organisations
. . . The first conference was followed by a second. The problems of
organising life according to principles of self-management by workers were
examined and discussed with animation by the masses of workers, who all
welcomed this ideas with the greatest enthusiasm . . . Railroad workers took
the first step . . . They formed a committee charged with organising the
railway network of the region . . . From this point, the proletariat of
Aleksandrovsk began systematically to the problem of creating organs of self-
management."_ [**Op. Cit.**, p. 149]

They also organised free agricultural communes which _"[a]dmittedly . . . were
not numerous, and included only a minority of the population . . . But what
was most precious was that these communes were formed by the poor peasants
themselves. The Makhnovists never exerted any pressure on the peasants,
confining themselves to propagating the idea of free communes."_ [**Op.
Cit.**, p. 87] Makhno played an important role in abolishing the holdings of
the landed gentry. The local soviet and their district and regional congresses
equalised the use of the land between all sections of the peasant community.
[**Op. Cit.**, pp. 53-4]

Moreover, the Makhnovists took the time and energy to involve the whole
population in discussing the development of the revolution, the activities of
the army and social policy. They organised numerous conferences of workers',
soldiers' and peasants' delegates to discuss political and social issues. They
organised a regional congress of peasants and workers when they had liberated
Aleksandrovsk. When the Makhnovists tried to convene the third regional
congress of peasants, workers and insurgents in April 1919 and an
extraordinary congress of several regions in June 1919 (including Red Army
soldiers) the Bolsheviks viewed them as counter-revolutionary, tried to ban
them and declared their organisers and delegates outside the law. For example,
Trotsky issued order 1824 which stated the June 1919 congress was forbidden,
that to inform the population of it was an act of high treason and all
delegates should be arrested immediately as were all the spreading the call.
[**Op. Cit.**, p. 98-105 and p. 122-31]

The Makhnovists replied by holding the conferences anyway and asking _"[c]an
there exist laws made by a few people who call themselves revolutionaries,
which permit them to outlaw a whole people who are more revolutionary than
they are themselves?"_ and _"[w]hose interests should the revolution defend:
those of the Party or those of the people who set the revolution in motion
with their blood?"_ Makhno himself stated that he _"consider[ed] it an
inviolable right of the workers and peasants, a right won by the revolution,
to call conferences on their own account, to discuss their affairs."_ [**Op.
Cit.**, p. 103 and p. 129] These actions by the Bolsheviks should make the
reader ponder if the elimination of workers' democracy during the civil war
can fully be explained by the objective conditions facing Lenin's government
or whether Leninist ideology played an important role in it. As Arshinov
argues, _"[w]hoever studies the Russian Revolution should learn it [Trotsky's
order no. 1824] by heart."_ [**Op. Cit.**, p. 123] Obviously the Bolsheviks
considered that soviet system was threatened if soviet conferences were called
and the "dictatorship of the proletariat" was undermined if the proletariat
took part in such events.

In addition, the Makhnovists _"full applied the revolutionary principles of
freedom of speech, of thought, of the press, and of political association. In
all cities and towns occupied by the Makhnovists, they began by lifting all
the prohibitions and repealing all the restrictions imposed on the press and
on political organisations by one or another power."_ Indeed, the _"only
restriction that the Makhnovists considered necessary to impose on the
Bolsheviks, the left Socialist-Revolutionaries and other statists was a
prohibition on the formation of those 'revolutionary committees' which sought
to impose a dictatorship over the people."_ [**Op. Cit.**, p. 153 and p. 154]

The army itself, in stark contrast to the Red Army, was fundamentally
democratic (although, of course, the horrific nature of the civil war did
result in a few deviations from the ideal -- however, compared to the regime
imposed on the Red Army by Trotsky, the Makhnovists were much more democratic
movement). Arshinov proves a good summary:

> _"The Makhnovist insurrectionary army was organised according to three
fundamental principles: voluntary enlistment, the electoral principle, and
self-discipline.  
>  _

>

> _"**Voluntary enlistment** meant that the army was composed only of
revolutionary fighters who entered it of their own free will. _

>

> _"**The electoral principle** meant that the commanders of all units of the
army, including the staff, as well as all the men who held other positions in
the army, were either elected or accepted by the insurgents of the unit in
question or by the whole army. _

>

> _"**Self-discipline** meant that all the rules of discipline were drawn up
by commissions of insurgents, then approved by general assemblies of the
various units; once approved, they were rigorously observed on the individual
responsibility of each insurgent and each commander."_ [**Op. Cit.**, p. 96]

Thus the Makhnovists indicate the validity of anarchist theory. They organised
the self-defence of their region, refused to form of a "revolutionary"
government and so the life of the region, its social and revolutionary
development followed the path of self-activity of the working people who did
not allow any authorities to tell them what to do. They respected freedom of
association, speech, press and so on while actively encouraging workers' and
peasants' self-management and self-organisation.

Moving to the Spanish movement, the various revolts and uprisings organised by
the CNT and FAI that occurred before 1936 were marked by a similar
revolutionary developments as the Makhnovists. We discuss the actual events of
the revolts in 1932 and 1933 in more detail in [section
14](append32.md#app14) and so will not repeat ourselves here. However, all
were marked by the anarchist movement attacking town halls, army barracks and
other sources of state authority and urging the troops to revolt and side with
the masses (the anarchists paid a lot of attention to this issue -- like the
French syndicalists they produced anti-militarist propaganda arguing that
soldiers should side with their class and refuse orders to fire on strikers
and to join popular revolts). The revolts also saw workers taking over their
workplaces and the land, trying to abolish capitalism while trying to abolish
the state. In summary, they were **insurrections** which combined political
goals (the abolition of the state) and social ones (expropriation of capital
and the creation of self-managed workplaces and communes).

The events in Asturias in October 1934 gives a more detailed account of nature
of these insurrections. The anarchist role in this revolt has not been as
widely known as it should be and this is an ideal opportunity to discuss it.
Combined with the other insurrections of the 1930s it clearly indicates that
anarchism is a valid form of revolutionary theory.

While the CNT was the minority union in Asturias, it had a considerable
influence of its own (the CNT had over 22 000 affiliates in the area and the
UGT had 40 000). The CNT had some miners in their union (the majority were in
the UGT) but most of their membership was above ground, particularly in the
towns of Aviles and Gijon. The regional federation of the CNT had joined the
Socialist Party dominated "Alianza Obrera," unlike the other regional
federations of the CNT.

When the revolt started, the workers organised attacks on barracks, town halls
and other sources of state authority (just as the CNT revolts of 1932 and 1933
had). Bookchin indicates that _"[s]tructurely, the insurrection was managed by
hundreds of small revolutionary committees whose delegates were drawn from
unions, parties, the FAI and even anti-Stalinist Communist groups. Rarely, if
at all, were there large councils (or 'soviets') composed of delegates from
factories."_ [**The Spanish Anarchists**, p. 249] This, incidentally,
indicates that Morrow's claims that in Asturias _"the Workers' Alliances were
most nearly like soviets, and had been functioning for a year under socialist
and Communist Left leadership"_ are false. [**Op. Cit.**, p. 31] The claims
that the Asturias uprising had established soviets was simply Communist and
government propaganda.

In fact, the Socialists _"generally functioned through tightly knit
committees, commonly highly centralised and with strong bureaucratic
proclivities. In Asturias, the UGT tried to perpetuate this form wherever
possible . . . But the mountainous terrain of Asturias made such committees
difficult to co-ordinate, so that each one became an isolated miniature
central committee of its own, often retaining its traditional authoritarian
character."_ The anarchists, on the other hand, _"favoured looser structures,
often quasi-councils composed of factory workers and assemblies composed of
peasants. The ambience of these fairly decentralised structures, their
improvisatory character and libertarian spirit, fostered an almost festive
atmosphere in Anarchist-held areas."_ [**Op. Cit.**, p. 249] Bookchin quotes
an account which compares anarchist La Felguera with Marxist Sama, towns of
equal size and separated only by the Nalon river:

> _"[The October Insurrection] triumphed immediately in the metallurgical and
in the mining town. . . . Sama was organised along military lines.
Dictatorship of the proletariat, red army, Central Committee, discipline.
authority . . . La Felguera opted for **communismo libertario**: the people in
arms, liberty to come and go, respect for the technicians of the Duro-Felguera
metallurgical plant, public deliberations of all issues, abolition of money,
the rational distribution of food and clothing. Enthusiasm and gaiety in La
Felguera; the sullenness of the barracks in Sama. The bridges [of Sama] were
held by a corp of guards complete with officers and all. No one could enter or
leave Sama without a safe-conduct pass, or walk through the streets without
passwords. All of this was ridiculously useless, because the government troops
were far away and the Sama bourgeoisie disarmed and neutralised . . . The
workers of Sama who did not adhere to the Marxist religion preferred to go to
La Felguera, where at least they could breathe. Side by side there were two
concepts of socialism: the authoritarian and the libertarian; on each bank of
the Nalon, two populations of brothers began a new life: with dictatorship in
Sama; with liberty in La Felguera."_ [**Op. Cit.**, pp. 249-50]

Bookchin notes that _"[i]n contrast to the severely delimited Marxist
committee in Sama, La Felguera workers met in popular assembly, where they
socialised the industrial city's economy. The population was divided into
wards, each of which elected delegates to supply and distribution committees.
. . The La Felguera commune . . . proved to be so successful, indeed so
admirable, that surrounding communities invited the La Felguera Anarchists to
advice them on reorganising their own social order. Rarely were comparable
institutions created by the Socialists and, where they did emerge, it was on
the insistence of the rank-and-file workers."_ [**Op. Cit.**, p. 250]

In other words, the Asturias uprising saw anarchists yet again applying their
ideas with great success in a revolutionary situation. As Bookchin argues:

> _"Almost alone, the Anarchists were to create viable revolutionary
institutions structured around workers' control of industry and peasants'
control of land. That these institutions were to be duplicated by Socialist
workers and peasants was due in small measure to Anarchist example rather than
Socialist precept. To the degree that the Asturian miners and industrial
workers in various communities established direct control over the local
economy and structured their committees along libertarian lines, these
achievements were due to Anarchist precedents and long years of propaganda and
education."_ [**Op. Cit.**, p. 250-1]

Unlike their Socialist and Communist allies, the anarchists in Asturias took
the Alianza's slogan _"Unity, Proletarian Brothers"_ seriously. A key factor
in the defeat of the uprising (beyond its isolation due to socialist
incompetence elsewhere -- see [section 6](append32.md#app6)) was the fact
that _"[s]o far as the Aviles and Gijon Anarchists were concerned . . . their
Socialist and Communist 'brothers' were to honour the slogan only in the
breach. When Anarchist delegates from the seaports arrived in Oviedo on
October 7, pleading for arms to resist the imminent landings of government
troops, their requests were totally ignored by Socialists and Communists who,
as [historian Gabriel] Jackson notes, 'clearly mistrusted them.' The Oviedo
Committee was to pay a bitter price for its refusal. The next day, when
Anarchist resistance, hampered by the pitiful supply of weapons, failed to
prevent the government from landing its troops, the way into Asturias lay
open. The two seaports became the principal military bases for launching the
savage repression of the Asturian insurrection that occupied so much of
October and claimed thousands of lives."_ [Murray Bookchin, **Op. Cit.**, p.
248]

Therefore, to state as Morrow does that before July 1936, _"anarchism had
never been tested on a grand scale"_ and now _"leading great masses, it was to
have a definite test"_ is simply wrong. [**Op. Cit.**, p. 101] Anarchism had
had numerous definite tests before involving _"great masses,"_ both in Spain
and elsewhere. The revolts of the 1930s, the Makhnovists in the Ukraine, the
factory occupations in Italy in 1920 (see [section A.5.5](secA5.md#seca55))
and in numerous other revolutionary and near revolutionary situations
anarchism had been tested **and had passed** those tests. Defeat came about by
the actions of the Marxists (in the case of Asturias and Italy) or by superior
force (as in the 1932 and 1933 Spanish insurrections and the Ukraine) **not**
because of anarchist theory or activities. At no time did they collaborate
with the bourgeois state or compromise their politics. By concentrating on
July 1936, Marxists effectively distort the history of anarchism -- a bit like
arguing the actions of the Social Democratic Party in crushing the German
discredits Marxism while ignoring the actions and politics of the council
communists during it or the Russian Revolution.

But the question remains, why did the CNT and FAI make such a mess
(politically at least) of the Spanish Revolution of 1936? However, even this
question is unfair as the example of the Aragon Defence Council and Federation
of Collectives indicate that anarchists **did** apply their ideas successfully
in certain areas during that revolution.

Morrow is aware of that example, as he argues that the _"Catalonian [i.e. CNT]
militia marched into Aragon as an army of social liberation . . . Arriving in
a village, the militia committees sponsor the election of a village anti-
fascist committee . . . [which] organises production on a new basis"_ and
_"[e]very village wrested from the fascists was transformed into a forest of
revolution."_ Its _"municipal councils were elected directly by the
communities. The Council of Aragon was at first largely anarchist."_ He notes
that _"[l]ibertarian principles were attempted in the field of money and
wages"_ yet he fails to mention the obvious application of libertarian
principles in the field of **politics** with the state abolished and replaced
by a federation of workers' associations. To do so would be to invalidate his
basic thesis against anarchism and so it goes unmentioned, hoping the reader
will not notice this confirmation of anarchist **politics** in practice.
[**Op. Cit.**, p. 53, p. 204 and p. 205]

So, from the experience of the Ukraine, the previous revolts in 1932, 1933 and
1934 and the example of the Council of Aragon it appears clear that rather
than exposing anarchist theory (as Marxists claim), the example of July 1936
in Catalonia is an aberration. Anarchist politics had been confirmed as a
valid revolutionary theory many times before and, indeed, shown themselves as
the only one to ensure a free society. However, why did this aberration occur?

Most opponents of anarchism provide a rather (in)famous quote from FAI
militant Juan Garcia Oliver, describing the crucial decision made in Catalonia
in July of '36 to co-operate with Companys' government to explain the failure
of the CNT to "seize power":

> _"The CNT and FAI decided on collaboration and democracy, eschewing
revolutionary totalitarianism . . . by the anarchist and Confederal
dictatorship."_ [quoted by Stuart Christie, **We, the Anarchists!**, p. 105]

In this statement Garcia Oliver describes the capitalist state as "democracy"
and refers to the alternative of the directly democratic CNT unions taking
power as "totalitarianism" and "dictatorship." Marxists tend to think this
statement tells us something about the CNT's original program in the period
leading up to the crisis of July 1936. As proven above, any such assertion
would be false (see also [section 8](append32.md#app8)). In fact this
statement was made in December of 1937, many months after Garcia Oliver and
other influential CNT activists had embarked upon collaboration in the
government ministries and Republican army command. The quote is taken from a
report by the CNT leadership, presented by Garcia Oliver and Mariano Vazquez
(CNT National Secretary in 1937) at the congress of the International Workers
Association (IWA). The CNT was aware that government participation was in
violation of the principles of the IWA and the report was intended to provide
a rationalisation. That report is an indication of just how far Garcia Oliver
and other influential CNT radicals had been corrupted by the experience of
government collaboration.

Garcia Oliver's position in July of 1936 had been entirely different. He had
been one of the militants to argue in favour of overthrowing the Companys
government in Catalonia in the crucial union assemblies of July 20-21. As Juan
Gomez Casas argues:

> _"The position supported by Juan Garcia Oliver [in July of '36] has been
described as `anarchist dictatorship' Actually, though, Oliver was advocating
application of the goals of the Saragossa Congress in Barcelona and Catalonia
at a time in history when, in his opinion, libertarian communism was a real
possibility. It would always signify dissolution of the old parties dedicated
to the idea of [state] power, or at least make it impossible for them to
pursue their politics aimed at seizure of power. There will always be pockets
of opposition to new experiences and therefore resistance to joining 'the
spontaneity of the popular masses.' In addition, the masses would have
complete freedom of expression in the unions and in the economic organisations
of the revolution as well as in their political organisations."_ [**Anarchist
Organisation: The History of the FAI**, p. 188f]

Those libertarians who defended government participation in Spain argued that
a non-hierarchical re-organisation of society in Catalonia in July of '36
could only have been imposed by force, against the opposition of the parties
and sectors of society that have a vested interest in existing inequalities.
They argued that this would have been a "dictatorship," no better than the
alternative of government collaboration.

If this argument were valid, then it logically means that anarchism itself
would be impossible, for there will always be sectors of society -- bosses,
judges, politicians, etc. -- who will oppose social re-organisation on a
libertarian basis. As Malatesta once argued, some people _"seem almost to
believe that after having brought down government and private property we
would allow both to be quietly built up again, because of a respect for the
**freedom** of those who might feel the need to be rulers and property owners.
A truly curious way of interpreting our ideas!"_ [**Anarchy**, p. 41] It is
doubtful he would have predicted that certain anarchists would be included in
such believers!

Neither anarchism nor the CNT program called for suppressing other viewpoints.
The various viewpoints that existed among the workforce and population would
be reflected in the deliberations and debates of the workplace and community
assemblies as well as in the various local and regional congresses and
conference and on their co-ordinating Councils. The various political groups
would be free to organise, publish their periodicals and seek influence in the
various self-managed assemblies and structures that existed. The CNT would be
dominant because it had overwhelming support among the workers of Catalonia
(and would have remained dominant as long as that continued).

What is essential to a state is that its authority and armed power be top-
down, separate and distinct from the population. Otherwise it could not
function to protect the power of a boss class. When a population in society
directly and democratically controls the armed force (in fact, effectively
**is** the armed force as in the case of the CNT militias), directly manages
its own fairs in decentralised, federal organisations based on self-management
from the bottom upwards and manages the economy, this is not a "state" in the
historical sense. Thus the CNT would not in any real sense had "seized power"
in Catalonia, rather it would have allowed the mass of people, previously
disempowered by the state, to take control of their own lives -- both
individually and collectively -- by smashing the state and replacing it by a
free federation of workers' associations.

What this means is that a non-hierarchical society must be imposed by the
working class against the opposition of those who would lose power. In
building the new world we must destroy the old one. Revolutions are
authoritarian by their very nature, but only in respect to structures and
social relations which promote injustice, hierarchy and inequality. It is not
"authoritarian" to destroy authority, in other words! Revolutions, above all
else, must be libertarian in respect to the oppressed (indeed, they are acts
of liberation in which the oppressed end their oppression by their own direct
action). That is, they must develop structures that involve the great majority
of the population, who have previously been excluded from decision making
about social and economic issues.

So the dilemma of "anarchist dictatorship" or "collaboration" was a false one
and fundamentally wrong. It was never a case of banning parties, etc. under an
anarchist system, far from it. Full rights of free speech, organisation and so
on should have existed for all but the parties would only have as much
influence as they exerted in union, workplace, community, militia (and so on)
assemblies, as should be the case! "Collaboration" yes, but within the rank
and file and within organisations organised in a libertarian manner. Anarchism
does not respect the "freedom" to be a capitalist, boss or politician.

Instead of this "collaboration" from the bottom up, the CNT and FAI committees
favoured "collaboration" from the top down. In this they followed the example
of the UGT and its "Workers' Alliances" rather than their own activities
previous to the military revolt. Why? Why did the CNT and FAI in Catalonia
reject their previous political perspective and reject the basis ideas of
anarchism? As shown above, the CNT and FAI has successfully applied their
ideas in many insurrections before hand. Why the change of direction? There
were two main reasons.

Firstly, while a majority in Catalonia and certain other parts of Spain, the
CNT and FAI were a minority in such areas as Castille and Asturias. To combat
fascism required the combined forces of all parties and unions and by
collaborating with a UGT-like "Anti-Fascist Alliance" in Catalonia, it was
believed that such alliances could be formed elsewhere, with equality for the
CNT ensured by the Catalan CNT's decision of equal representation for minority
organisations in the Catalan Anti-Fascist Committee. This would, hopefully,
also ensure aid to CNT militias via the government's vast gold reserves and
stop foreign intervention by Britain and other countries to protect their
interests if libertarian communism was declared.

However, as Vernon Richards argues:

> _"This argument contains . . . two fundamental mistakes, which many of the
leaders of the CNT-FAI have since recognised, but for which there can be no
excuse, since they were not mistakes of judgement but the deliberate
abandonment of the principles of the CNT. Firstly, that an armed struggle
against fascism or any other form of reaction could be waged more successfully
within the framework of the State and subordinating all else, including the
transformation of the economic and social structure of the country, to winning
the war. Secondly, that it was essential, and possible, to collaborate with
political parties -- that is politicians -- honestly and sincerely, and at a
time when power was in the hands of the two workers organisations. . .  
>  _

>

> _"All the initiative . . . was in the hands of the workers. The politicians
were like generals without armies floundering in a desert of futility.
Collaboration with them could not, by any stretch of the imagination,
strengthen resistance to Franco. On the contrary, it was clear that
collaboration with political parties meant the recreation of governmental
institutions and the transferring of initiative from the armed workers to a
central body with executive powers. By removing the initiative from the
workers, the responsibility for the conduct of the struggle and its objectives
were also transferred to a governing hierarchy, and this could not have other
than an adverse effect on the morale of the revolutionary fighters."_
[**Lessons of the Spanish Revolution**, p. 42]

In addition, in failing to take the initiative to unite the working class
independently of the Republican state at the crucial moment, in July of '36,
the CNT of Catalonia was in effect abandoning the only feasible alternative to
the Popular Front strategy. Without a libertarian system of popular self-
management, the CNT and FAI had no alternative but to join the bourgeois
state. For a revolution to be successful, as Bakunin and Kropotkin argued, it
needs to create libertarian organisations (such as workers' associations, free
communes and their federations) which can effectively replace the state and
the market, that is to create a widespread libertarian organisation for social
and economic decision making through which working class people can start to
set their own agendas. Only by going this can the state and capitalism be
effectively smashed. If this is not done and the state is ignored rather than
smashed, it continue and get stronger as it will be the only medium that
exists for wide scale decision making. This will result in revolutionaries
having to work within it, trying to influence it since no other means exist to
reach collective decisions.

The failure to smash the state, this first betrayal of anarchist principles,
led to all the rest, and so the defeat of the revolution. Not destroying the
state meant that the revolution could never be fully successful economically
as politics and economics are bound together so closely. Only under the
political conditions of anarchism can its economic conditions flourish and
vice versa.

The CNT had never considered a "strategy" of collaboration with the Popular
Front prior to July of '36. In the months leading up to the July explosion,
the CNT had consistently criticised the Popular Front strategy as a fake unity
of leaders over the workers, a strategy that would subordinate the working
class to capitalist legality. However, in July of '36, the CNT conferences in
Catalonia had not seen clearly that their "temporary" participation in the
Anti-Fascist Militia Committee would drag them inexorably into a practice of
collaboration with the Popular Front. As Christie argues, _"the Militias
Committee was a compromise, an artificial political solution . . . It . . .
drew the CNT-FAI leadership inexorably into the State apparatus, until them
its principle enemy, and led to the steady erosion of anarchist influence and
credibility."_ [**Op. Cit.**, p. 105]

Secondly, the fear of fascism played a key role. After all, this was 1936. The
CNT and FAI had seen their comrades in Italy and Germany being crushed by
fascist dictatorships, sent to concentration camps and so on. In Spain,
Franco's forces were slaughtering union and political militants and members by
the tens of thousands (soon to reach hundreds of thousands by the end of the
war and beyond). The insurrection had not been initiated by the people
themselves (as had the previous revolts in the 1930s) and this also had a
psychological impact on the decision making process. The anarchists were,
therefore, in a position of being caught between two evils -- fascism and the
bourgeois state, elements of which had fought with them on the streets. To
pursue anarchist politics at such a time, it was argued, could have resulted
in the CNT fighting on two fronts -- against the fascists and also against the
Republican government. Such a situation would have been unbearable and so it
was better to accept collaboration than aid Fascism by dividing the forces of
the anti-fascist camp.

However, such a perspective failed to appreciate the depth of hatred the
politicians and bourgeois had for the CNT. Indeed, by their actions it would
appear they preferred fascism to the social revolution. So, in the name of
"anti-fascist" unity, the CNT worked with parties and classes which hated both
them and the revolution. In the words of Sam Dolgoff _"both before and after
July 19th, an unwavering determination to crush the revolutionary movement was
the leitmotif behind the policies of the Republican government; irrespective
of the party in power."_ [**The Anarchist Collectives**, p. 40]

Rather than eliminate a civil war developing within the civil war, the policy
of the CNT just postponed it -- until such time as the state was stronger than
the working class. The Republican government was quite happy to attack the
gains of the revolution, physically attacking rural and urban collectives,
union halls, assassinating CNT and FAI members of so on. The difference was
the CNT's act only postponed such conflict until the balance of power had
shifted back towards the status quo.

Moreover, the fact that the bourgeois republic was fighting fascism could have
meant that it would have tolerated the CNT social revolution rather than fight
it (and so weakening its own fight against Franco). However, such an argument
remains moot.

It is clear that anti-fascism destroyed the revolution, not fascism. As a
Scottish anarchist in Barcelona during the revolution argued, _"Fascism is not
something new, some new force of evil opposed to society, but is only the old
enemy, Capitalism, under a new and fearful sounding name . . . Anti-Fascism is
the new slogan by which the working class is being betrayed."_ [Ethal
McDonald, **Workers Free Press**, Oct. 1937] This was also argued by the
**Friends of Durruti** who stated that _"[d]emocracy defeated the Spanish
people, not Fascism."_ [**The Friends of Durruti Accuse**]

The majority at the July 20-21 conferences went along with proposal of
postponing the social revolution, of starting the work of creating libertarian
communism, and smashing the state and replacing it with a federation of
workers' assemblies. Most of the CNT militants there saw it as a temporary
expedient, until the rest of Spain was freed from Franco's forces (in
particular, Aragon and Saragossa). Companys' (the head of the Catalan
government) had proposed the creation of a body containing representatives of
all anti-fascist parties and unions called the _"Central Committee of Anti-
Fascist Militias,"_ sponsored by his government. The CNT meeting agreed to
this proposal, though only on condition that the CNT be given the majority on
it. A sizeable minority of delegates were apparently disgusted by this
decision. The delegation from Bajo Llobregat County (an industrial area south
of Barcelona) walked out saying they would never go along with government
collaboration.

Therefore, the decision to postpone the revolution and so to ignore the state
rather than smashing was a product of isolation and the fear of a fascist
victory. However, while "isolation" may explain the Catalan militants' fears
and so decisions, it does not justify their decision. If the CNT of Catalonia
had given Companys the boot and set up a federation of workplace and community
assemblies in Catalonia, uniting the rank-and-file of the other unions with
the CNT, this would have strengthened the resolve of workers in other parts of
Spain, and it might have also inspired workers in nearby countries to move in
a similar direction.

Isolation, the uneven support for a libertarian revolution across Spain and
the dangers of fascism were real problems, but they do not excuse the
libertarian movement for its mistakes. On the contrary, in following the
course of action advised by leaders like Horacio Prieto and Abad Diego de
Santillan, the CNT only weakened the revolution and helped to discredit
libertarian socialism. After all, as Bakunin and Kropotkin continually
stressed, revolutions break out in specific areas and then spread outward --
isolation is a feature of revolution which can only be overcome by action, by
showing a practical example which others can follow.

Most of the CNT militants at the July 20th meeting saw the compromise as a
temporary expedient, until the rest of Spain was freed from Franco's forces
(in particular, Aragon and Saragossa). As the official account states, _"[t]he
situation was considered and it was unanimously decided not to mention
Libertarian Communism until such time as we had captured that part of Spain
that was in the hands of the rebels."_ [quoted by Christie, **Op. Cit.**, p.
102] However, the membership of the CNT decided **themselves** to start the
social revolution (_"very rapidly collectives . . . began to spring up. It did
not happen on instructions from the CNT leadership . . . the initiative came
from CNT militants"_ [Ronald Fraser, **Blood of Spain**, p. 349]). The social
revolution began anyway, from below, but without the key political aspect
(abolition of the state) and so was fatally compromised from the beginning.

As Stuart Christie argues:

> _ "The higher committees of the CNT-FAI-FIJL in Catalonia saw themselves
caught on the horns of a dilemma: social revolution, fascism or bourgeois
democracy. Either they committed themselves to the solutions offered by social
revolution, regardless of the difficulties involved in fighting both fascism
and international capitalism, or, through fear of fascism . . . they
sacrificed their anarchist principles and revolutionary objectives to bolster,
to become part of the bourgeois state . . . Faced with an imperfect state of
affairs and preferring defeat to a possibly Pyrrhic victory, Catalan anarchist
leadership renounced anarchism in the name of expediency and removed the
social transformation of Spain from their agenda.  
>  _

>

> _"But what the CNT-FAI leaders failed to grasp was that the decision whether
or not to implement Libertarian Communism was not theirs to make. Anarchism
was not something which could be transformed from theory to practice by
organisational decree. . . _

>

> _"What the CNT-FAI leadership had failed to take on board was the fact that
the spontaneous defensive movement of 19 July had developed a political
direction of its own. On their own initiative, without any intervention by the
leadership of the unions or political parties, the rank and file militants of
the CNT, representing the dominant force within the Barcelona working class,
together with other union militants had, with the collapse of State power, . .
. been welded . . . into genuinely popular non-partisan revolutionary
committees . . . in their respective neighbourhoods. They were the natural
organisms of the revolution itself and direct expression of popular power."_
[**Op. Cit.**, p. 99]

In other words, the bulk of the CNT-FAI membership acted in an anarchist way
while the higher committees compromised their politics and achievements in the
name of anti-fascist unity. In this the membership followed years of anarchist
practice and theory. It was fear of fascism which made many of the leading
militants of the CNT abandon anarchist politics and instead embrace "anti-
fascist unity" and compromise with the bourgeois republic. To claim that July
1936 indicated the failure of anarchism means to ignore the constructive work
of millions of CNT members in their workplaces, communities and militias and
instead concentrate on a few militants who made the terrible mistake of
ignoring their political ideas in an extremely difficult situation. As we said
above, this may explain the decision but it does not justify it.

Therefore, it is clear that the experiences of the CNT and FAI in 1936
indicate a failure of anarchists to apply their politics rather than the
failure of those politics. The examples of the Makhnovists, the revolts in
Spain between 1932 and 1934 as well as the Council of Aragon show beyond doubt
that this is the case. Rather than act as anarchists in July 1936, the
militants of the Catalan CNT and FAI ignored their basic ideas (not lightly,
we stress, but in response to real dangers). They later justified their
decisions by putting their options in a Marxist light -- "either we impose
libertarian communism, and so become an anarchist dictatorship, or we
collaborate with the democratic government." As Vernon Richards makes clear:

> _"Such alternatives are contrary to the most elementary principles of
anarchism and revolutionary syndicalism. In the first place, an 'anarchist
dictatorship' is a contradiction in terms (in the same way as the
'dictatorship of the proletariat' is), for the moment anarchists impose their
social ideas on the people by force, they cease being anarchists . . . the
arms of the CNT-FAI held could be no use for imposing libertarian communism .
. . The power of the people in arms can only be used in the defence of the
revolution and the freedoms won by their militancy and their sacrificed. We do
not for one moment assume that all social revolutions are necessarily
anarchist. But whatever form the revolution against authority takes, the role
of anarchists is clear: that of inciting the people to abolish capitalistic
property and the institutions through which it exercises its power for the
exploitation of the majority by a minority. . . the role of anarchists [is] to
support, to incite and encourage the development of the social revolution and
to frustrate any attempts by the bourgeois capitalist state to reorganise
itself, which it would seek to do."_ [**Op. Cit.**, pp. 43-6]

Their compromise in the name of anti-fascist unity contained the rest of their
mistakes. Joining the "Central Committee of Anti-Fascist Militias" was the
second mistake as at no time could it be considered as the embryo of a new
workers' power. It was, rather, an organisation like the pre-war UGT "Workers'
Alliances" -- an attempt to create links between the top-level of other unions
and parties. Such an organisation, as the CNT recognised before the war (see
[section 5](append32.md#app5)), could not be a means of creating a
revolutionary federation of workers' associations and communes and, in fact, a
hindrance to such a development, if not its chief impediment.

Given that the CNT had rejected the call for revolution in favour of anti-
fascist unit on July 20th, such a development does not reflect the CNT's pre-
war program. Rather it was a reversion to Felix Morrow's Trotskyist position
of joining the UGT's "Workers' Alliance" in spite of its non-revolutionary
nature (see [section 5](append32.md#app5)).

The CNT did not carry out its program (and so apply anarchist politics) and so
did not replace the Generalitat (Catalan State) with a Defence Council in
which only union/workplace assemblies (not political parties) were
represented. To start the process of creating libertarian communism all the
CNT would have had do was to call a Regional Congress of unions and invite the
UGT, independent unions and unorganised workplaces to send delegates. It could
also have invited the various neighbourhood and village defence committees
that had either sprung up spontaneously or were already organised before the
war as part of the CNT. Unlike the other revolts it took part in the 1930s,
the CNT did not apply anarchist politics. However, to judge anarchism by this
single failure means to ignore the whole history of anarchism and its
successful applications elsewhere, including by the CNT and FAI during
numerous revolts in Spain during the 1930s and in Aragon in 1936.

Ironically enough, Kropotkin had attacked the official CNT line of not
mentioning Libertarian Communism _"until such time as we had captured that
part of Spain that was in the hands of the rebels."_ In analysing the Paris
Commune Kropotkin had lambasted those who had argued _"Let us first make sure
of victory, and then see what can be done."_ His comments are worth quoting at
length:

> _ "Make sure of victory! As if there were any way of forming a free commune
without laying hands upon property! As if there were any way of conquering the
foe while the great mass of the people is not directly interested in the
triumph of the revolution, by seeing that it will bring material, moral and
intellectual well-being to everybody.  
>  _

>

> _"The same thing happened with regard to the principle of government. By
proclaiming the free Commune, the people of Paris proclaimed an essential
anarchist principle, which was the breakdown of the state. _

>

> _"And yet, if we admit that a central government to regulate the relations
of communes between themselves is quite needless, why should we admit its
necessity to regulate the mutual relations of the groups which make up each
commune? . . . There is no more reason for a government inside the commune
than for a government outside."_ [**The Commune of Paris**]

Kropotkin's argument was sound, as the CNT discovered. By waiting until
victory in the war they were defeated. Kropotkin also indicated the inevitable
effects of the CNT's actions in co-operating with the state and joining
representative bodies. In his words:

> _ "Paris sent her devoted sons to the town hall. There, shelved in the midst
of files of old papers, obliged to rule when their instincts prompted them to
be and to act among the people, obliged to discuss when it was needful to act,
to compromise when no compromise was the best policy, and, finally, losing the
inspiration which only comes from continual contact with the masses, they saw
themselves reduced to impotence. Being paralysed by their separation from the
people -- the revolutionary centre of light and heat -- they themselves
paralysed the popular initiative."_ [**Op. Cit.**]

Which, in a nutshell, was what happened to the leading militants of the CNT
who collaborated with the state. As anarchist turned Minister admitted after
the war, _"[w]e were in the government, but the streets were slipping away
from us. We had lost the workers' trust and the movement's unity had been
whittled away."_ [**No Gods, No Masters**, vol. 2, p. 274] The actions of the
CNT-FAI higher committees and Ministers helped paralyse and defeat the May
Days revolt of 1937. The CNT committees and leaders become increasingly
isolated from the people, they compromised again and again and, ultimately,
became an impotent force. Kropotkin was proved correct. Which means that far
from refuting anarchist politics or analysis, the experience of the CNT-FAI in
the Spanish Revolution _**confirms**_ it.

In summary, therefore, the Spanish Revolution of 1936 indicates the failure of
anarchists rather than the failure of anarchism.

One last point, it could be argued that anarchist theory allowed the
leadership of the CNT and FAI to paint their collaboration with the state as a
libertarian policy. That is, of course, correct. Anarchism is against the so-
called "dictatorship of the proletariat" just as much as it is against the
actual dictatorship of the bourgeoisie (i.e. the existing system and its off-
shoots such as fascism). This allowed the CNT and FAI leaders to argue that
they were following anarchist theory by not destroying the state completely in
July 1936. Of course, such a position cannot be used to discredit anarchism
simply because such a revision meant that it can never be libertarian to
abolish government and the state. In other words, the use made of anarchist
theory by the leaders of the CNT and FAI in this case presents nothing else
than a betrayal of that theory rather than its legitimate use.

Also, and more importantly, while anarchist theory was corrupted to justify
working with other parties and unions in a democratic state, **Marxist**
theory was used to justify the brutal one-party dictatorship of the
Bolsheviks, first under Lenin and the Stalin. That, we feel, sums up the
difference between anarchism and Leninism quite well.

[‹ Reply to errors and distortions in David McNally's pamphlet "Socialism from
Below"](append31.md "Go to previous page" ) [up](append3.md "Go to parent
page" ) [Reply to errors and distortions in Phil Mitchinson's "Marxism and
direct action" ›](append33.md "Go to next page" )

