/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-snippets-manager.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-snippets-manager
 * @title: IAnjutaSnippetsManager
 * @short_description: Snippets Manager interface
 * @see_also:
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-macro.h
 *
 */

#include "ianjuta-snippets-manager.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_snippets_manager_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-snippets-manager-quark");
	}
	
	return quark;
}

/**
 * ianjuta_snippets_manager_insert:
 * @key: Trigger-key of the snippet
 * @editing_session: If after inserting the snippet there should be an editing
 * session. Mark as FALSE if not interested in the dynamic capabilities of the
 * snippet.
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Insert snippet in the current editor.
 */
gboolean
ianjuta_snippets_manager_insert (IAnjutaSnippetsManager *obj, const gchar* key,   gboolean editing_session, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SNIPPETS_MANAGER(obj), FALSE);
	return IANJUTA_SNIPPETS_MANAGER_GET_IFACE (obj)->insert (obj, key, editing_session, err);
}

/* Default implementation */
static gboolean
ianjuta_snippets_manager_insert_default (IAnjutaSnippetsManager *obj, const gchar* key,   gboolean editing_session, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_snippets_manager_base_init (IAnjutaSnippetsManagerIface* klass)
{
	static gboolean initialized = FALSE;

	klass->insert = ianjuta_snippets_manager_insert_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_snippets_manager_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaSnippetsManagerIface),
			(GBaseInitFunc) ianjuta_snippets_manager_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaSnippetsManager", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
