/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.atlas.iterator;

import java.util.Iterator ;

public class WrapperIterator<T> implements Iterator<T>
{
    private final Iterator<T> iter ;

    public WrapperIterator(Iterator<T> iter) { this.iter = iter ; }
    
    @Override
    public boolean hasNext()
    {
        return iter.hasNext() ;
    }

    @Override
    public T next()
    {
        return iter.next() ;
    }

    @Override
    public void remove()
    { iter.remove() ; }

}
