/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 12:02:29 GMT 2018
 */

package uk.ac.sanger.artemis.components;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.datatransfer.Clipboard;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeaturePatternPredicate;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SelectionChangeEvent;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.FeatureList;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class FeatureList_ESTest extends FeatureList_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("yS7,%(ViX ", "yS7,%(ViX ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      featureList0.setShowQualifiers(true);
      boolean boolean0 = featureList0.getShowQualifiers();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("yS7,%(ViX ");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      int int0 = featureList0.getLineHeight();
      assertEquals(14, int0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard(":5T#i");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = null;
      try {
        featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("yS7,%(ViX ");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      // Undeclared exception!
      try { 
        featureList0.getViewport();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.FeatureList", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("yS7,%(ViX ");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      StringVector stringVector0 = featureList0.getListStrings();
      assertEquals(0, stringVector0.size());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("yS7,%(ViX ", "yS7,%(ViX ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      SelectionChangeEvent selectionChangeEvent0 = new SelectionChangeEvent(simpleEntryGroup0, 4);
      featureList0.selectionChanged(selectionChangeEvent0);
      assertEquals(1, SelectionChangeEvent.SELECTION_CHANGED);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("yS7,%(ViX ");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      Entry entry0 = simpleEntryGroup0.createEntry();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "yS7,%(ViX ");
      Feature feature0 = filteredEntryGroup0.createFeature();
      EntryChangeEvent entryChangeEvent0 = new EntryChangeEvent(entry0, feature0, 2);
      featureList0.entryChanged(entryChangeEvent0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("yS7,%(ViX ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      featureList0.featureChanged((FeatureChangeEvent) null);
      assertFalse(featureList0.isFocusCycleRoot());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("yS7,%(ViX ", "yS7,%(ViX ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      featureList0.setShowProducts(false);
      assertFalse(featureList0.isFocusTraversalPolicySet());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("yS7,%(ViX ", "yS7,%(ViX ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      featureList0.setShowQualifiers(true);
      featureList0.setShowQualifiers(false);
      assertFalse(featureList0.isFocusTraversalPolicySet());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("yS7,%(ViX ", "yS7,%(ViX ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      featureList0.setShowQualifiers(true);
      featureList0.setShowQualifiers(true);
      assertFalse(featureList0.isFocusCycleRoot());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("yS7,%(ViX ", "yS7,%(ViX ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      StringVector stringVector0 = featureList0.getShowUserDefinedQualifier();
      assertNull(stringVector0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      featureList0.setShowSystematicID(true);
      assertFalse(featureList0.isFocusTraversalPolicyProvider());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("yS7,%(ViX ", "yS7,%(ViX ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      featureList0.setShowSystematicID(false);
      assertFalse(featureList0.isFocusTraversalPolicySet());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("yS7,%(ViX ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      featureList0.setShowGenes(true);
      assertFalse(featureList0.isFocusTraversalPolicySet());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("yS7,%(ViX ", "yS7,%(ViX ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(bases0.letter_index, true);
      FeaturePatternPredicate featurePatternPredicate0 = new FeaturePatternPredicate(aminoAcidSequence0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featurePatternPredicate0, "yS7,%(ViX ");
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(filteredEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      featureList0.setShowGenes(false);
      assertFalse(featureList0.isFocusTraversalPolicySet());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("yS7,%(ViX ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      featureList0.setCorrelationScores(false);
      assertFalse(featureList0.getIgnoreRepaint());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("yS7,%(ViX ", "yS7,%(ViX ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      boolean boolean0 = featureList0.getShowProducts();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("yS7,%(ViX ");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      boolean boolean0 = featureList0.getShowSysID();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("yS7,%(ViX ", "yS7,%(ViX ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      boolean boolean0 = featureList0.getShowQualifiers();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("yS7,%(ViX ");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      boolean boolean0 = featureList0.getCorrelationScores();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("yS7,%(ViX ", "yS7,%(ViX ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      featureList0.entryGroupChanged((EntryGroupChangeEvent) null);
      assertTrue(featureList0.getFocusTraversalKeysEnabled());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("yS7,%(ViX ", "yS7,%(ViX ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      featureList0.stopListening();
      assertFalse(featureList0.isFocusCycleRoot());
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("yS7,%(ViX ");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("yS7,%(ViX ");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureList featureList0 = new FeatureList(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
      featureList0.setShowUserDefinedQualifier("yS7,%(ViX ");
      assertFalse(featureList0.getIgnoreRepaint());
  }
}
