// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Heap_h__
#define __Heap_h__

#include <stdlib.h>

// use pt_malloc only for the cross-compiled mingw version!
#if defined(WIN32) && !defined(_MSC_VER) 

extern "C" void *pt_malloc (size_t);
extern "C" void  pt_free (void *);

namespace Puma {


class Heap {
public:
  Heap () {}
  ~Heap () {}
   
  void *malloc (size_t s) 
   { return pt_malloc (s); }
  void free(void *p) 
   { pt_free(p); }
};


} // namespace Puma

#else /* defined(WIN32) && !defined(_MSC_VER) */

namespace Puma {


class Heap {
public:
  Heap () {}
  ~Heap () {}

  void *malloc (size_t n) 
   { return ::malloc (n); }
  void free (void *p) 
   { ::free (p); }
};


} // namespace Puma

#endif /* defined(WIN32) && !defined(_MSC_VER) */

#endif /* __Heap_h__ */
