
#include <QtTest/QtTest>
#include "client/clientInterface.h"
#include "libCommon/attalCommon.h"
#include "libClient/imageTheme.h"
#include "libCommon/define.h"
#include "conf.h"

class TestAttal: public QObject
{
	Q_OBJECT
		private slots:
		void testLord();
		void testPlayer();
		void testGame();
};

void TestAttal::testLord()
{

	useTheme();

	DataTheme.init();
	GenericLord lord;
	GenericLordModel * model = DataTheme.lords.at( 1 );
	lord.setId( 1 );
	lord.reinit();
	QCOMPARE( lord.getCharac( LEVEL ) , 0 );
	QCOMPARE( lord.getOwner() , (GenericPlayer *)0 );
	QCOMPARE( lord.getId() , 1 );
	QCOMPARE( lord.getBaseCharac( MOVE ) , model->getBaseCharac( MOVE ) );
	lord.setBaseCharac( MOVE, lord.getCharac( MAXMOVE ) );
	lord.decreaseBaseCharac( MOVE, 2 );
	QCOMPARE( lord.getBaseCharac( MOVE ) , model->getBaseCharac( MAXMOVE ) -2  );
	lord.endTurn();
	QCOMPARE( lord.getBaseCharac( MOVE ) , model->getBaseCharac( MAXMOVE ) );
	QCOMPARE( ( uint ) lord.getRace() , model->getRace() );
	int count = lord.countUnits();
	Creature * crea = new Creature();
	lord.addCreatures( crea, 10 );
	lord.clearUnits();
	QCOMPARE( lord.countUnits() , 0 );
	lord.setCost( 0, 100);
	QCOMPARE( ( int ) lord.getCost(0) ,100 );
	lord.setVisible( false );
	QCOMPARE( lord.isVisible() ,false );
	GenericCell * cell = new GenericCell();
	lord.setCell( cell );
	QCOMPARE( lord.getCell() ,cell );
	QCOMPARE( cell->getLord() ,(GenericLord *)&lord );
	lord.removeFromGame();
	QCOMPARE( lord.getCell() , (GenericCell * )0 );
	QCOMPARE( cell->getLord() ,(GenericLord *)0 );
	QCOMPARE( lord.hasMachineType( 0 ) , false );
	
	delete crea;
	delete cell;

}

void TestAttal::testPlayer()
{
	GenericPlayer player;
	QCOMPARE( player.isAlive() , true );

}

void TestAttal::testGame()
{
}

QTEST_MAIN(TestAttal)
#include "testattal.moc"
