//
// BAGEL - Parallel electron correlation program.
// Filename: _hrr_80_44.cc
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <src/integral/hrrlist.h>
#include <array>
#include <algorithm>

using namespace std;
using namespace bagel;

void HRRList::perform_HRR_80_44(const int nloop, const double* data_start, const array<double,3>& AB, double* data_out) {
  for (int c = 0; c != nloop; ++c) {
    auto current_data = &data_start[c * 145];
    auto current_out = &data_out[c * 225];
   {
     //current index a: xxxx
      const auto a0_0 = current_data[0];
      const auto ax_0 = current_data[15];
      const auto ay_0 = current_data[16];
      const auto az_0 = current_data[21];
      const auto axx_0 = current_data[36];
      const auto axy_0 = current_data[37];
      const auto ayy_0 = current_data[38];
      const auto axz_0 = current_data[43];
      const auto ayz_0 = current_data[44];
      const auto azz_0 = current_data[49];
      const auto axxx_0 = current_data[64];
      const auto axxy_0 = current_data[65];
      const auto axyy_0 = current_data[66];
      const auto ayyy_0 = current_data[67];
      const auto axxz_0 = current_data[72];
      const auto axyz_0 = current_data[73];
      const auto ayyz_0 = current_data[74];
      const auto axzz_0 = current_data[79];
      const auto ayzz_0 = current_data[80];
      const auto azzz_0 = current_data[85];
      const auto axxxx_0 = current_data[100];
      const auto axxxy_0 = current_data[101];
      const auto axxyy_0 = current_data[102];
      const auto axyyy_0 = current_data[103];
      const auto ayyyy_0 = current_data[104];
      const auto axxxz_0 = current_data[109];
      const auto axxyz_0 = current_data[110];
      const auto axyyz_0 = current_data[111];
      const auto ayyyz_0 = current_data[112];
      const auto axxzz_0 = current_data[117];
      const auto axyzz_0 = current_data[118];
      const auto ayyzz_0 = current_data[119];
      const auto axzzz_0 = current_data[124];
      const auto ayzzz_0 = current_data[125];
      const auto azzzz_0 = current_data[130];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[0] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[1] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[2] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[3] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[4] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[5] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[6] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[7] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[8] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[9] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[10] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[11] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[12] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[13] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[14] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxy
      const auto a0_0 = current_data[1];
      const auto ax_0 = current_data[16];
      const auto ay_0 = current_data[17];
      const auto az_0 = current_data[22];
      const auto axx_0 = current_data[37];
      const auto axy_0 = current_data[38];
      const auto ayy_0 = current_data[39];
      const auto axz_0 = current_data[44];
      const auto ayz_0 = current_data[45];
      const auto azz_0 = current_data[50];
      const auto axxx_0 = current_data[65];
      const auto axxy_0 = current_data[66];
      const auto axyy_0 = current_data[67];
      const auto ayyy_0 = current_data[68];
      const auto axxz_0 = current_data[73];
      const auto axyz_0 = current_data[74];
      const auto ayyz_0 = current_data[75];
      const auto axzz_0 = current_data[80];
      const auto ayzz_0 = current_data[81];
      const auto azzz_0 = current_data[86];
      const auto axxxx_0 = current_data[101];
      const auto axxxy_0 = current_data[102];
      const auto axxyy_0 = current_data[103];
      const auto axyyy_0 = current_data[104];
      const auto ayyyy_0 = current_data[105];
      const auto axxxz_0 = current_data[110];
      const auto axxyz_0 = current_data[111];
      const auto axyyz_0 = current_data[112];
      const auto ayyyz_0 = current_data[113];
      const auto axxzz_0 = current_data[118];
      const auto axyzz_0 = current_data[119];
      const auto ayyzz_0 = current_data[120];
      const auto axzzz_0 = current_data[125];
      const auto ayzzz_0 = current_data[126];
      const auto azzzz_0 = current_data[131];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[15] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[16] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[17] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[18] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[19] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[20] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[21] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[22] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[23] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[24] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[25] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[26] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[27] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[28] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[29] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxyy
      const auto a0_0 = current_data[2];
      const auto ax_0 = current_data[17];
      const auto ay_0 = current_data[18];
      const auto az_0 = current_data[23];
      const auto axx_0 = current_data[38];
      const auto axy_0 = current_data[39];
      const auto ayy_0 = current_data[40];
      const auto axz_0 = current_data[45];
      const auto ayz_0 = current_data[46];
      const auto azz_0 = current_data[51];
      const auto axxx_0 = current_data[66];
      const auto axxy_0 = current_data[67];
      const auto axyy_0 = current_data[68];
      const auto ayyy_0 = current_data[69];
      const auto axxz_0 = current_data[74];
      const auto axyz_0 = current_data[75];
      const auto ayyz_0 = current_data[76];
      const auto axzz_0 = current_data[81];
      const auto ayzz_0 = current_data[82];
      const auto azzz_0 = current_data[87];
      const auto axxxx_0 = current_data[102];
      const auto axxxy_0 = current_data[103];
      const auto axxyy_0 = current_data[104];
      const auto axyyy_0 = current_data[105];
      const auto ayyyy_0 = current_data[106];
      const auto axxxz_0 = current_data[111];
      const auto axxyz_0 = current_data[112];
      const auto axyyz_0 = current_data[113];
      const auto ayyyz_0 = current_data[114];
      const auto axxzz_0 = current_data[119];
      const auto axyzz_0 = current_data[120];
      const auto ayyzz_0 = current_data[121];
      const auto axzzz_0 = current_data[126];
      const auto ayzzz_0 = current_data[127];
      const auto azzzz_0 = current_data[132];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[30] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[31] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[32] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[33] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[34] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[35] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[36] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[37] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[38] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[39] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[40] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[41] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[42] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[43] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[44] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyyy
      const auto a0_0 = current_data[3];
      const auto ax_0 = current_data[18];
      const auto ay_0 = current_data[19];
      const auto az_0 = current_data[24];
      const auto axx_0 = current_data[39];
      const auto axy_0 = current_data[40];
      const auto ayy_0 = current_data[41];
      const auto axz_0 = current_data[46];
      const auto ayz_0 = current_data[47];
      const auto azz_0 = current_data[52];
      const auto axxx_0 = current_data[67];
      const auto axxy_0 = current_data[68];
      const auto axyy_0 = current_data[69];
      const auto ayyy_0 = current_data[70];
      const auto axxz_0 = current_data[75];
      const auto axyz_0 = current_data[76];
      const auto ayyz_0 = current_data[77];
      const auto axzz_0 = current_data[82];
      const auto ayzz_0 = current_data[83];
      const auto azzz_0 = current_data[88];
      const auto axxxx_0 = current_data[103];
      const auto axxxy_0 = current_data[104];
      const auto axxyy_0 = current_data[105];
      const auto axyyy_0 = current_data[106];
      const auto ayyyy_0 = current_data[107];
      const auto axxxz_0 = current_data[112];
      const auto axxyz_0 = current_data[113];
      const auto axyyz_0 = current_data[114];
      const auto ayyyz_0 = current_data[115];
      const auto axxzz_0 = current_data[120];
      const auto axyzz_0 = current_data[121];
      const auto ayyzz_0 = current_data[122];
      const auto axzzz_0 = current_data[127];
      const auto ayzzz_0 = current_data[128];
      const auto azzzz_0 = current_data[133];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[45] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[46] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[47] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[48] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[49] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[50] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[51] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[52] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[53] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[54] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[55] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[56] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[57] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[58] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[59] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyyy
      const auto a0_0 = current_data[4];
      const auto ax_0 = current_data[19];
      const auto ay_0 = current_data[20];
      const auto az_0 = current_data[25];
      const auto axx_0 = current_data[40];
      const auto axy_0 = current_data[41];
      const auto ayy_0 = current_data[42];
      const auto axz_0 = current_data[47];
      const auto ayz_0 = current_data[48];
      const auto azz_0 = current_data[53];
      const auto axxx_0 = current_data[68];
      const auto axxy_0 = current_data[69];
      const auto axyy_0 = current_data[70];
      const auto ayyy_0 = current_data[71];
      const auto axxz_0 = current_data[76];
      const auto axyz_0 = current_data[77];
      const auto ayyz_0 = current_data[78];
      const auto axzz_0 = current_data[83];
      const auto ayzz_0 = current_data[84];
      const auto azzz_0 = current_data[89];
      const auto axxxx_0 = current_data[104];
      const auto axxxy_0 = current_data[105];
      const auto axxyy_0 = current_data[106];
      const auto axyyy_0 = current_data[107];
      const auto ayyyy_0 = current_data[108];
      const auto axxxz_0 = current_data[113];
      const auto axxyz_0 = current_data[114];
      const auto axyyz_0 = current_data[115];
      const auto ayyyz_0 = current_data[116];
      const auto axxzz_0 = current_data[121];
      const auto axyzz_0 = current_data[122];
      const auto ayyzz_0 = current_data[123];
      const auto axzzz_0 = current_data[128];
      const auto ayzzz_0 = current_data[129];
      const auto azzzz_0 = current_data[134];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[60] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[61] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[62] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[63] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[64] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[65] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[66] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[67] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[68] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[69] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[70] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[71] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[72] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[73] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[74] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxz
      const auto a0_0 = current_data[5];
      const auto ax_0 = current_data[21];
      const auto ay_0 = current_data[22];
      const auto az_0 = current_data[26];
      const auto axx_0 = current_data[43];
      const auto axy_0 = current_data[44];
      const auto ayy_0 = current_data[45];
      const auto axz_0 = current_data[49];
      const auto ayz_0 = current_data[50];
      const auto azz_0 = current_data[54];
      const auto axxx_0 = current_data[72];
      const auto axxy_0 = current_data[73];
      const auto axyy_0 = current_data[74];
      const auto ayyy_0 = current_data[75];
      const auto axxz_0 = current_data[79];
      const auto axyz_0 = current_data[80];
      const auto ayyz_0 = current_data[81];
      const auto axzz_0 = current_data[85];
      const auto ayzz_0 = current_data[86];
      const auto azzz_0 = current_data[90];
      const auto axxxx_0 = current_data[109];
      const auto axxxy_0 = current_data[110];
      const auto axxyy_0 = current_data[111];
      const auto axyyy_0 = current_data[112];
      const auto ayyyy_0 = current_data[113];
      const auto axxxz_0 = current_data[117];
      const auto axxyz_0 = current_data[118];
      const auto axyyz_0 = current_data[119];
      const auto ayyyz_0 = current_data[120];
      const auto axxzz_0 = current_data[124];
      const auto axyzz_0 = current_data[125];
      const auto ayyzz_0 = current_data[126];
      const auto axzzz_0 = current_data[130];
      const auto ayzzz_0 = current_data[131];
      const auto azzzz_0 = current_data[135];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[75] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[76] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[77] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[78] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[79] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[80] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[81] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[82] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[83] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[84] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[85] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[86] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[87] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[88] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[89] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxyz
      const auto a0_0 = current_data[6];
      const auto ax_0 = current_data[22];
      const auto ay_0 = current_data[23];
      const auto az_0 = current_data[27];
      const auto axx_0 = current_data[44];
      const auto axy_0 = current_data[45];
      const auto ayy_0 = current_data[46];
      const auto axz_0 = current_data[50];
      const auto ayz_0 = current_data[51];
      const auto azz_0 = current_data[55];
      const auto axxx_0 = current_data[73];
      const auto axxy_0 = current_data[74];
      const auto axyy_0 = current_data[75];
      const auto ayyy_0 = current_data[76];
      const auto axxz_0 = current_data[80];
      const auto axyz_0 = current_data[81];
      const auto ayyz_0 = current_data[82];
      const auto axzz_0 = current_data[86];
      const auto ayzz_0 = current_data[87];
      const auto azzz_0 = current_data[91];
      const auto axxxx_0 = current_data[110];
      const auto axxxy_0 = current_data[111];
      const auto axxyy_0 = current_data[112];
      const auto axyyy_0 = current_data[113];
      const auto ayyyy_0 = current_data[114];
      const auto axxxz_0 = current_data[118];
      const auto axxyz_0 = current_data[119];
      const auto axyyz_0 = current_data[120];
      const auto ayyyz_0 = current_data[121];
      const auto axxzz_0 = current_data[125];
      const auto axyzz_0 = current_data[126];
      const auto ayyzz_0 = current_data[127];
      const auto axzzz_0 = current_data[131];
      const auto ayzzz_0 = current_data[132];
      const auto azzzz_0 = current_data[136];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[90] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[91] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[92] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[93] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[94] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[95] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[96] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[97] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[98] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[99] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[100] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[101] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[102] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[103] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[104] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyyz
      const auto a0_0 = current_data[7];
      const auto ax_0 = current_data[23];
      const auto ay_0 = current_data[24];
      const auto az_0 = current_data[28];
      const auto axx_0 = current_data[45];
      const auto axy_0 = current_data[46];
      const auto ayy_0 = current_data[47];
      const auto axz_0 = current_data[51];
      const auto ayz_0 = current_data[52];
      const auto azz_0 = current_data[56];
      const auto axxx_0 = current_data[74];
      const auto axxy_0 = current_data[75];
      const auto axyy_0 = current_data[76];
      const auto ayyy_0 = current_data[77];
      const auto axxz_0 = current_data[81];
      const auto axyz_0 = current_data[82];
      const auto ayyz_0 = current_data[83];
      const auto axzz_0 = current_data[87];
      const auto ayzz_0 = current_data[88];
      const auto azzz_0 = current_data[92];
      const auto axxxx_0 = current_data[111];
      const auto axxxy_0 = current_data[112];
      const auto axxyy_0 = current_data[113];
      const auto axyyy_0 = current_data[114];
      const auto ayyyy_0 = current_data[115];
      const auto axxxz_0 = current_data[119];
      const auto axxyz_0 = current_data[120];
      const auto axyyz_0 = current_data[121];
      const auto ayyyz_0 = current_data[122];
      const auto axxzz_0 = current_data[126];
      const auto axyzz_0 = current_data[127];
      const auto ayyzz_0 = current_data[128];
      const auto axzzz_0 = current_data[132];
      const auto ayzzz_0 = current_data[133];
      const auto azzzz_0 = current_data[137];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[105] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[106] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[107] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[108] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[109] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[110] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[111] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[112] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[113] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[114] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[115] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[116] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[117] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[118] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[119] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyyz
      const auto a0_0 = current_data[8];
      const auto ax_0 = current_data[24];
      const auto ay_0 = current_data[25];
      const auto az_0 = current_data[29];
      const auto axx_0 = current_data[46];
      const auto axy_0 = current_data[47];
      const auto ayy_0 = current_data[48];
      const auto axz_0 = current_data[52];
      const auto ayz_0 = current_data[53];
      const auto azz_0 = current_data[57];
      const auto axxx_0 = current_data[75];
      const auto axxy_0 = current_data[76];
      const auto axyy_0 = current_data[77];
      const auto ayyy_0 = current_data[78];
      const auto axxz_0 = current_data[82];
      const auto axyz_0 = current_data[83];
      const auto ayyz_0 = current_data[84];
      const auto axzz_0 = current_data[88];
      const auto ayzz_0 = current_data[89];
      const auto azzz_0 = current_data[93];
      const auto axxxx_0 = current_data[112];
      const auto axxxy_0 = current_data[113];
      const auto axxyy_0 = current_data[114];
      const auto axyyy_0 = current_data[115];
      const auto ayyyy_0 = current_data[116];
      const auto axxxz_0 = current_data[120];
      const auto axxyz_0 = current_data[121];
      const auto axyyz_0 = current_data[122];
      const auto ayyyz_0 = current_data[123];
      const auto axxzz_0 = current_data[127];
      const auto axyzz_0 = current_data[128];
      const auto ayyzz_0 = current_data[129];
      const auto axzzz_0 = current_data[133];
      const auto ayzzz_0 = current_data[134];
      const auto azzzz_0 = current_data[138];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[120] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[121] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[122] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[123] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[124] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[125] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[126] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[127] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[128] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[129] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[130] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[131] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[132] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[133] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[134] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxzz
      const auto a0_0 = current_data[9];
      const auto ax_0 = current_data[26];
      const auto ay_0 = current_data[27];
      const auto az_0 = current_data[30];
      const auto axx_0 = current_data[49];
      const auto axy_0 = current_data[50];
      const auto ayy_0 = current_data[51];
      const auto axz_0 = current_data[54];
      const auto ayz_0 = current_data[55];
      const auto azz_0 = current_data[58];
      const auto axxx_0 = current_data[79];
      const auto axxy_0 = current_data[80];
      const auto axyy_0 = current_data[81];
      const auto ayyy_0 = current_data[82];
      const auto axxz_0 = current_data[85];
      const auto axyz_0 = current_data[86];
      const auto ayyz_0 = current_data[87];
      const auto axzz_0 = current_data[90];
      const auto ayzz_0 = current_data[91];
      const auto azzz_0 = current_data[94];
      const auto axxxx_0 = current_data[117];
      const auto axxxy_0 = current_data[118];
      const auto axxyy_0 = current_data[119];
      const auto axyyy_0 = current_data[120];
      const auto ayyyy_0 = current_data[121];
      const auto axxxz_0 = current_data[124];
      const auto axxyz_0 = current_data[125];
      const auto axyyz_0 = current_data[126];
      const auto ayyyz_0 = current_data[127];
      const auto axxzz_0 = current_data[130];
      const auto axyzz_0 = current_data[131];
      const auto ayyzz_0 = current_data[132];
      const auto axzzz_0 = current_data[135];
      const auto ayzzz_0 = current_data[136];
      const auto azzzz_0 = current_data[139];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[135] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[136] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[137] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[138] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[139] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[140] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[141] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[142] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[143] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[144] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[145] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[146] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[147] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[148] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[149] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyzz
      const auto a0_0 = current_data[10];
      const auto ax_0 = current_data[27];
      const auto ay_0 = current_data[28];
      const auto az_0 = current_data[31];
      const auto axx_0 = current_data[50];
      const auto axy_0 = current_data[51];
      const auto ayy_0 = current_data[52];
      const auto axz_0 = current_data[55];
      const auto ayz_0 = current_data[56];
      const auto azz_0 = current_data[59];
      const auto axxx_0 = current_data[80];
      const auto axxy_0 = current_data[81];
      const auto axyy_0 = current_data[82];
      const auto ayyy_0 = current_data[83];
      const auto axxz_0 = current_data[86];
      const auto axyz_0 = current_data[87];
      const auto ayyz_0 = current_data[88];
      const auto axzz_0 = current_data[91];
      const auto ayzz_0 = current_data[92];
      const auto azzz_0 = current_data[95];
      const auto axxxx_0 = current_data[118];
      const auto axxxy_0 = current_data[119];
      const auto axxyy_0 = current_data[120];
      const auto axyyy_0 = current_data[121];
      const auto ayyyy_0 = current_data[122];
      const auto axxxz_0 = current_data[125];
      const auto axxyz_0 = current_data[126];
      const auto axyyz_0 = current_data[127];
      const auto ayyyz_0 = current_data[128];
      const auto axxzz_0 = current_data[131];
      const auto axyzz_0 = current_data[132];
      const auto ayyzz_0 = current_data[133];
      const auto axzzz_0 = current_data[136];
      const auto ayzzz_0 = current_data[137];
      const auto azzzz_0 = current_data[140];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[150] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[151] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[152] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[153] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[154] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[155] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[156] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[157] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[158] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[159] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[160] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[161] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[162] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[163] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[164] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyzz
      const auto a0_0 = current_data[11];
      const auto ax_0 = current_data[28];
      const auto ay_0 = current_data[29];
      const auto az_0 = current_data[32];
      const auto axx_0 = current_data[51];
      const auto axy_0 = current_data[52];
      const auto ayy_0 = current_data[53];
      const auto axz_0 = current_data[56];
      const auto ayz_0 = current_data[57];
      const auto azz_0 = current_data[60];
      const auto axxx_0 = current_data[81];
      const auto axxy_0 = current_data[82];
      const auto axyy_0 = current_data[83];
      const auto ayyy_0 = current_data[84];
      const auto axxz_0 = current_data[87];
      const auto axyz_0 = current_data[88];
      const auto ayyz_0 = current_data[89];
      const auto axzz_0 = current_data[92];
      const auto ayzz_0 = current_data[93];
      const auto azzz_0 = current_data[96];
      const auto axxxx_0 = current_data[119];
      const auto axxxy_0 = current_data[120];
      const auto axxyy_0 = current_data[121];
      const auto axyyy_0 = current_data[122];
      const auto ayyyy_0 = current_data[123];
      const auto axxxz_0 = current_data[126];
      const auto axxyz_0 = current_data[127];
      const auto axyyz_0 = current_data[128];
      const auto ayyyz_0 = current_data[129];
      const auto axxzz_0 = current_data[132];
      const auto axyzz_0 = current_data[133];
      const auto ayyzz_0 = current_data[134];
      const auto axzzz_0 = current_data[137];
      const auto ayzzz_0 = current_data[138];
      const auto azzzz_0 = current_data[141];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[165] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[166] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[167] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[168] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[169] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[170] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[171] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[172] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[173] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[174] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[175] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[176] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[177] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[178] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[179] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xzzz
      const auto a0_0 = current_data[12];
      const auto ax_0 = current_data[30];
      const auto ay_0 = current_data[31];
      const auto az_0 = current_data[33];
      const auto axx_0 = current_data[54];
      const auto axy_0 = current_data[55];
      const auto ayy_0 = current_data[56];
      const auto axz_0 = current_data[58];
      const auto ayz_0 = current_data[59];
      const auto azz_0 = current_data[61];
      const auto axxx_0 = current_data[85];
      const auto axxy_0 = current_data[86];
      const auto axyy_0 = current_data[87];
      const auto ayyy_0 = current_data[88];
      const auto axxz_0 = current_data[90];
      const auto axyz_0 = current_data[91];
      const auto ayyz_0 = current_data[92];
      const auto axzz_0 = current_data[94];
      const auto ayzz_0 = current_data[95];
      const auto azzz_0 = current_data[97];
      const auto axxxx_0 = current_data[124];
      const auto axxxy_0 = current_data[125];
      const auto axxyy_0 = current_data[126];
      const auto axyyy_0 = current_data[127];
      const auto ayyyy_0 = current_data[128];
      const auto axxxz_0 = current_data[130];
      const auto axxyz_0 = current_data[131];
      const auto axyyz_0 = current_data[132];
      const auto ayyyz_0 = current_data[133];
      const auto axxzz_0 = current_data[135];
      const auto axyzz_0 = current_data[136];
      const auto ayyzz_0 = current_data[137];
      const auto axzzz_0 = current_data[139];
      const auto ayzzz_0 = current_data[140];
      const auto azzzz_0 = current_data[142];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[180] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[181] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[182] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[183] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[184] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[185] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[186] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[187] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[188] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[189] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[190] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[191] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[192] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[193] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[194] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yzzz
      const auto a0_0 = current_data[13];
      const auto ax_0 = current_data[31];
      const auto ay_0 = current_data[32];
      const auto az_0 = current_data[34];
      const auto axx_0 = current_data[55];
      const auto axy_0 = current_data[56];
      const auto ayy_0 = current_data[57];
      const auto axz_0 = current_data[59];
      const auto ayz_0 = current_data[60];
      const auto azz_0 = current_data[62];
      const auto axxx_0 = current_data[86];
      const auto axxy_0 = current_data[87];
      const auto axyy_0 = current_data[88];
      const auto ayyy_0 = current_data[89];
      const auto axxz_0 = current_data[91];
      const auto axyz_0 = current_data[92];
      const auto ayyz_0 = current_data[93];
      const auto axzz_0 = current_data[95];
      const auto ayzz_0 = current_data[96];
      const auto azzz_0 = current_data[98];
      const auto axxxx_0 = current_data[125];
      const auto axxxy_0 = current_data[126];
      const auto axxyy_0 = current_data[127];
      const auto axyyy_0 = current_data[128];
      const auto ayyyy_0 = current_data[129];
      const auto axxxz_0 = current_data[131];
      const auto axxyz_0 = current_data[132];
      const auto axyyz_0 = current_data[133];
      const auto ayyyz_0 = current_data[134];
      const auto axxzz_0 = current_data[136];
      const auto axyzz_0 = current_data[137];
      const auto ayyzz_0 = current_data[138];
      const auto axzzz_0 = current_data[140];
      const auto ayzzz_0 = current_data[141];
      const auto azzzz_0 = current_data[143];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[195] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[196] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[197] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[198] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[199] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[200] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[201] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[202] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[203] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[204] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[205] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[206] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[207] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[208] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[209] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: zzzz
      const auto a0_0 = current_data[14];
      const auto ax_0 = current_data[33];
      const auto ay_0 = current_data[34];
      const auto az_0 = current_data[35];
      const auto axx_0 = current_data[58];
      const auto axy_0 = current_data[59];
      const auto ayy_0 = current_data[60];
      const auto axz_0 = current_data[61];
      const auto ayz_0 = current_data[62];
      const auto azz_0 = current_data[63];
      const auto axxx_0 = current_data[90];
      const auto axxy_0 = current_data[91];
      const auto axyy_0 = current_data[92];
      const auto ayyy_0 = current_data[93];
      const auto axxz_0 = current_data[94];
      const auto axyz_0 = current_data[95];
      const auto ayyz_0 = current_data[96];
      const auto axzz_0 = current_data[97];
      const auto ayzz_0 = current_data[98];
      const auto azzz_0 = current_data[99];
      const auto axxxx_0 = current_data[130];
      const auto axxxy_0 = current_data[131];
      const auto axxyy_0 = current_data[132];
      const auto axyyy_0 = current_data[133];
      const auto ayyyy_0 = current_data[134];
      const auto axxxz_0 = current_data[135];
      const auto axxyz_0 = current_data[136];
      const auto axyyz_0 = current_data[137];
      const auto ayyyz_0 = current_data[138];
      const auto axxzz_0 = current_data[139];
      const auto axyzz_0 = current_data[140];
      const auto ayyzz_0 = current_data[141];
      const auto axzzz_0 = current_data[142];
      const auto ayzzz_0 = current_data[143];
      const auto azzzz_0 = current_data[144];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[210] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[211] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[212] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[213] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[214] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[215] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[216] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[217] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[218] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[219] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[220] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[221] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[222] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[223] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[224] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
  }
}


void CHRRList::perform_HRR_80_44(const int nloop, const complex<double>* data_start, const array<double,3>& AB, complex<double>* data_out) {
  for (int c = 0; c != nloop; ++c) {
    auto current_data = &data_start[c * 145];
    auto current_out = &data_out[c * 225];
   {
     //current index a: xxxx
      const auto a0_0 = current_data[0];
      const auto ax_0 = current_data[15];
      const auto ay_0 = current_data[16];
      const auto az_0 = current_data[21];
      const auto axx_0 = current_data[36];
      const auto axy_0 = current_data[37];
      const auto ayy_0 = current_data[38];
      const auto axz_0 = current_data[43];
      const auto ayz_0 = current_data[44];
      const auto azz_0 = current_data[49];
      const auto axxx_0 = current_data[64];
      const auto axxy_0 = current_data[65];
      const auto axyy_0 = current_data[66];
      const auto ayyy_0 = current_data[67];
      const auto axxz_0 = current_data[72];
      const auto axyz_0 = current_data[73];
      const auto ayyz_0 = current_data[74];
      const auto axzz_0 = current_data[79];
      const auto ayzz_0 = current_data[80];
      const auto azzz_0 = current_data[85];
      const auto axxxx_0 = current_data[100];
      const auto axxxy_0 = current_data[101];
      const auto axxyy_0 = current_data[102];
      const auto axyyy_0 = current_data[103];
      const auto ayyyy_0 = current_data[104];
      const auto axxxz_0 = current_data[109];
      const auto axxyz_0 = current_data[110];
      const auto axyyz_0 = current_data[111];
      const auto ayyyz_0 = current_data[112];
      const auto axxzz_0 = current_data[117];
      const auto axyzz_0 = current_data[118];
      const auto ayyzz_0 = current_data[119];
      const auto axzzz_0 = current_data[124];
      const auto ayzzz_0 = current_data[125];
      const auto azzzz_0 = current_data[130];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[0] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[1] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[2] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[3] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[4] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[5] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[6] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[7] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[8] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[9] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[10] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[11] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[12] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[13] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[14] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxy
      const auto a0_0 = current_data[1];
      const auto ax_0 = current_data[16];
      const auto ay_0 = current_data[17];
      const auto az_0 = current_data[22];
      const auto axx_0 = current_data[37];
      const auto axy_0 = current_data[38];
      const auto ayy_0 = current_data[39];
      const auto axz_0 = current_data[44];
      const auto ayz_0 = current_data[45];
      const auto azz_0 = current_data[50];
      const auto axxx_0 = current_data[65];
      const auto axxy_0 = current_data[66];
      const auto axyy_0 = current_data[67];
      const auto ayyy_0 = current_data[68];
      const auto axxz_0 = current_data[73];
      const auto axyz_0 = current_data[74];
      const auto ayyz_0 = current_data[75];
      const auto axzz_0 = current_data[80];
      const auto ayzz_0 = current_data[81];
      const auto azzz_0 = current_data[86];
      const auto axxxx_0 = current_data[101];
      const auto axxxy_0 = current_data[102];
      const auto axxyy_0 = current_data[103];
      const auto axyyy_0 = current_data[104];
      const auto ayyyy_0 = current_data[105];
      const auto axxxz_0 = current_data[110];
      const auto axxyz_0 = current_data[111];
      const auto axyyz_0 = current_data[112];
      const auto ayyyz_0 = current_data[113];
      const auto axxzz_0 = current_data[118];
      const auto axyzz_0 = current_data[119];
      const auto ayyzz_0 = current_data[120];
      const auto axzzz_0 = current_data[125];
      const auto ayzzz_0 = current_data[126];
      const auto azzzz_0 = current_data[131];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[15] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[16] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[17] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[18] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[19] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[20] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[21] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[22] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[23] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[24] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[25] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[26] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[27] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[28] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[29] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxyy
      const auto a0_0 = current_data[2];
      const auto ax_0 = current_data[17];
      const auto ay_0 = current_data[18];
      const auto az_0 = current_data[23];
      const auto axx_0 = current_data[38];
      const auto axy_0 = current_data[39];
      const auto ayy_0 = current_data[40];
      const auto axz_0 = current_data[45];
      const auto ayz_0 = current_data[46];
      const auto azz_0 = current_data[51];
      const auto axxx_0 = current_data[66];
      const auto axxy_0 = current_data[67];
      const auto axyy_0 = current_data[68];
      const auto ayyy_0 = current_data[69];
      const auto axxz_0 = current_data[74];
      const auto axyz_0 = current_data[75];
      const auto ayyz_0 = current_data[76];
      const auto axzz_0 = current_data[81];
      const auto ayzz_0 = current_data[82];
      const auto azzz_0 = current_data[87];
      const auto axxxx_0 = current_data[102];
      const auto axxxy_0 = current_data[103];
      const auto axxyy_0 = current_data[104];
      const auto axyyy_0 = current_data[105];
      const auto ayyyy_0 = current_data[106];
      const auto axxxz_0 = current_data[111];
      const auto axxyz_0 = current_data[112];
      const auto axyyz_0 = current_data[113];
      const auto ayyyz_0 = current_data[114];
      const auto axxzz_0 = current_data[119];
      const auto axyzz_0 = current_data[120];
      const auto ayyzz_0 = current_data[121];
      const auto axzzz_0 = current_data[126];
      const auto ayzzz_0 = current_data[127];
      const auto azzzz_0 = current_data[132];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[30] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[31] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[32] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[33] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[34] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[35] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[36] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[37] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[38] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[39] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[40] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[41] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[42] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[43] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[44] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyyy
      const auto a0_0 = current_data[3];
      const auto ax_0 = current_data[18];
      const auto ay_0 = current_data[19];
      const auto az_0 = current_data[24];
      const auto axx_0 = current_data[39];
      const auto axy_0 = current_data[40];
      const auto ayy_0 = current_data[41];
      const auto axz_0 = current_data[46];
      const auto ayz_0 = current_data[47];
      const auto azz_0 = current_data[52];
      const auto axxx_0 = current_data[67];
      const auto axxy_0 = current_data[68];
      const auto axyy_0 = current_data[69];
      const auto ayyy_0 = current_data[70];
      const auto axxz_0 = current_data[75];
      const auto axyz_0 = current_data[76];
      const auto ayyz_0 = current_data[77];
      const auto axzz_0 = current_data[82];
      const auto ayzz_0 = current_data[83];
      const auto azzz_0 = current_data[88];
      const auto axxxx_0 = current_data[103];
      const auto axxxy_0 = current_data[104];
      const auto axxyy_0 = current_data[105];
      const auto axyyy_0 = current_data[106];
      const auto ayyyy_0 = current_data[107];
      const auto axxxz_0 = current_data[112];
      const auto axxyz_0 = current_data[113];
      const auto axyyz_0 = current_data[114];
      const auto ayyyz_0 = current_data[115];
      const auto axxzz_0 = current_data[120];
      const auto axyzz_0 = current_data[121];
      const auto ayyzz_0 = current_data[122];
      const auto axzzz_0 = current_data[127];
      const auto ayzzz_0 = current_data[128];
      const auto azzzz_0 = current_data[133];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[45] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[46] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[47] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[48] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[49] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[50] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[51] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[52] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[53] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[54] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[55] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[56] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[57] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[58] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[59] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyyy
      const auto a0_0 = current_data[4];
      const auto ax_0 = current_data[19];
      const auto ay_0 = current_data[20];
      const auto az_0 = current_data[25];
      const auto axx_0 = current_data[40];
      const auto axy_0 = current_data[41];
      const auto ayy_0 = current_data[42];
      const auto axz_0 = current_data[47];
      const auto ayz_0 = current_data[48];
      const auto azz_0 = current_data[53];
      const auto axxx_0 = current_data[68];
      const auto axxy_0 = current_data[69];
      const auto axyy_0 = current_data[70];
      const auto ayyy_0 = current_data[71];
      const auto axxz_0 = current_data[76];
      const auto axyz_0 = current_data[77];
      const auto ayyz_0 = current_data[78];
      const auto axzz_0 = current_data[83];
      const auto ayzz_0 = current_data[84];
      const auto azzz_0 = current_data[89];
      const auto axxxx_0 = current_data[104];
      const auto axxxy_0 = current_data[105];
      const auto axxyy_0 = current_data[106];
      const auto axyyy_0 = current_data[107];
      const auto ayyyy_0 = current_data[108];
      const auto axxxz_0 = current_data[113];
      const auto axxyz_0 = current_data[114];
      const auto axyyz_0 = current_data[115];
      const auto ayyyz_0 = current_data[116];
      const auto axxzz_0 = current_data[121];
      const auto axyzz_0 = current_data[122];
      const auto ayyzz_0 = current_data[123];
      const auto axzzz_0 = current_data[128];
      const auto ayzzz_0 = current_data[129];
      const auto azzzz_0 = current_data[134];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[60] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[61] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[62] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[63] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[64] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[65] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[66] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[67] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[68] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[69] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[70] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[71] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[72] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[73] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[74] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxz
      const auto a0_0 = current_data[5];
      const auto ax_0 = current_data[21];
      const auto ay_0 = current_data[22];
      const auto az_0 = current_data[26];
      const auto axx_0 = current_data[43];
      const auto axy_0 = current_data[44];
      const auto ayy_0 = current_data[45];
      const auto axz_0 = current_data[49];
      const auto ayz_0 = current_data[50];
      const auto azz_0 = current_data[54];
      const auto axxx_0 = current_data[72];
      const auto axxy_0 = current_data[73];
      const auto axyy_0 = current_data[74];
      const auto ayyy_0 = current_data[75];
      const auto axxz_0 = current_data[79];
      const auto axyz_0 = current_data[80];
      const auto ayyz_0 = current_data[81];
      const auto axzz_0 = current_data[85];
      const auto ayzz_0 = current_data[86];
      const auto azzz_0 = current_data[90];
      const auto axxxx_0 = current_data[109];
      const auto axxxy_0 = current_data[110];
      const auto axxyy_0 = current_data[111];
      const auto axyyy_0 = current_data[112];
      const auto ayyyy_0 = current_data[113];
      const auto axxxz_0 = current_data[117];
      const auto axxyz_0 = current_data[118];
      const auto axyyz_0 = current_data[119];
      const auto ayyyz_0 = current_data[120];
      const auto axxzz_0 = current_data[124];
      const auto axyzz_0 = current_data[125];
      const auto ayyzz_0 = current_data[126];
      const auto axzzz_0 = current_data[130];
      const auto ayzzz_0 = current_data[131];
      const auto azzzz_0 = current_data[135];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[75] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[76] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[77] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[78] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[79] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[80] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[81] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[82] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[83] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[84] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[85] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[86] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[87] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[88] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[89] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxyz
      const auto a0_0 = current_data[6];
      const auto ax_0 = current_data[22];
      const auto ay_0 = current_data[23];
      const auto az_0 = current_data[27];
      const auto axx_0 = current_data[44];
      const auto axy_0 = current_data[45];
      const auto ayy_0 = current_data[46];
      const auto axz_0 = current_data[50];
      const auto ayz_0 = current_data[51];
      const auto azz_0 = current_data[55];
      const auto axxx_0 = current_data[73];
      const auto axxy_0 = current_data[74];
      const auto axyy_0 = current_data[75];
      const auto ayyy_0 = current_data[76];
      const auto axxz_0 = current_data[80];
      const auto axyz_0 = current_data[81];
      const auto ayyz_0 = current_data[82];
      const auto axzz_0 = current_data[86];
      const auto ayzz_0 = current_data[87];
      const auto azzz_0 = current_data[91];
      const auto axxxx_0 = current_data[110];
      const auto axxxy_0 = current_data[111];
      const auto axxyy_0 = current_data[112];
      const auto axyyy_0 = current_data[113];
      const auto ayyyy_0 = current_data[114];
      const auto axxxz_0 = current_data[118];
      const auto axxyz_0 = current_data[119];
      const auto axyyz_0 = current_data[120];
      const auto ayyyz_0 = current_data[121];
      const auto axxzz_0 = current_data[125];
      const auto axyzz_0 = current_data[126];
      const auto ayyzz_0 = current_data[127];
      const auto axzzz_0 = current_data[131];
      const auto ayzzz_0 = current_data[132];
      const auto azzzz_0 = current_data[136];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[90] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[91] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[92] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[93] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[94] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[95] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[96] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[97] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[98] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[99] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[100] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[101] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[102] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[103] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[104] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyyz
      const auto a0_0 = current_data[7];
      const auto ax_0 = current_data[23];
      const auto ay_0 = current_data[24];
      const auto az_0 = current_data[28];
      const auto axx_0 = current_data[45];
      const auto axy_0 = current_data[46];
      const auto ayy_0 = current_data[47];
      const auto axz_0 = current_data[51];
      const auto ayz_0 = current_data[52];
      const auto azz_0 = current_data[56];
      const auto axxx_0 = current_data[74];
      const auto axxy_0 = current_data[75];
      const auto axyy_0 = current_data[76];
      const auto ayyy_0 = current_data[77];
      const auto axxz_0 = current_data[81];
      const auto axyz_0 = current_data[82];
      const auto ayyz_0 = current_data[83];
      const auto axzz_0 = current_data[87];
      const auto ayzz_0 = current_data[88];
      const auto azzz_0 = current_data[92];
      const auto axxxx_0 = current_data[111];
      const auto axxxy_0 = current_data[112];
      const auto axxyy_0 = current_data[113];
      const auto axyyy_0 = current_data[114];
      const auto ayyyy_0 = current_data[115];
      const auto axxxz_0 = current_data[119];
      const auto axxyz_0 = current_data[120];
      const auto axyyz_0 = current_data[121];
      const auto ayyyz_0 = current_data[122];
      const auto axxzz_0 = current_data[126];
      const auto axyzz_0 = current_data[127];
      const auto ayyzz_0 = current_data[128];
      const auto axzzz_0 = current_data[132];
      const auto ayzzz_0 = current_data[133];
      const auto azzzz_0 = current_data[137];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[105] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[106] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[107] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[108] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[109] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[110] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[111] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[112] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[113] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[114] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[115] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[116] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[117] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[118] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[119] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyyz
      const auto a0_0 = current_data[8];
      const auto ax_0 = current_data[24];
      const auto ay_0 = current_data[25];
      const auto az_0 = current_data[29];
      const auto axx_0 = current_data[46];
      const auto axy_0 = current_data[47];
      const auto ayy_0 = current_data[48];
      const auto axz_0 = current_data[52];
      const auto ayz_0 = current_data[53];
      const auto azz_0 = current_data[57];
      const auto axxx_0 = current_data[75];
      const auto axxy_0 = current_data[76];
      const auto axyy_0 = current_data[77];
      const auto ayyy_0 = current_data[78];
      const auto axxz_0 = current_data[82];
      const auto axyz_0 = current_data[83];
      const auto ayyz_0 = current_data[84];
      const auto axzz_0 = current_data[88];
      const auto ayzz_0 = current_data[89];
      const auto azzz_0 = current_data[93];
      const auto axxxx_0 = current_data[112];
      const auto axxxy_0 = current_data[113];
      const auto axxyy_0 = current_data[114];
      const auto axyyy_0 = current_data[115];
      const auto ayyyy_0 = current_data[116];
      const auto axxxz_0 = current_data[120];
      const auto axxyz_0 = current_data[121];
      const auto axyyz_0 = current_data[122];
      const auto ayyyz_0 = current_data[123];
      const auto axxzz_0 = current_data[127];
      const auto axyzz_0 = current_data[128];
      const auto ayyzz_0 = current_data[129];
      const auto axzzz_0 = current_data[133];
      const auto ayzzz_0 = current_data[134];
      const auto azzzz_0 = current_data[138];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[120] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[121] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[122] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[123] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[124] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[125] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[126] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[127] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[128] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[129] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[130] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[131] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[132] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[133] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[134] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxzz
      const auto a0_0 = current_data[9];
      const auto ax_0 = current_data[26];
      const auto ay_0 = current_data[27];
      const auto az_0 = current_data[30];
      const auto axx_0 = current_data[49];
      const auto axy_0 = current_data[50];
      const auto ayy_0 = current_data[51];
      const auto axz_0 = current_data[54];
      const auto ayz_0 = current_data[55];
      const auto azz_0 = current_data[58];
      const auto axxx_0 = current_data[79];
      const auto axxy_0 = current_data[80];
      const auto axyy_0 = current_data[81];
      const auto ayyy_0 = current_data[82];
      const auto axxz_0 = current_data[85];
      const auto axyz_0 = current_data[86];
      const auto ayyz_0 = current_data[87];
      const auto axzz_0 = current_data[90];
      const auto ayzz_0 = current_data[91];
      const auto azzz_0 = current_data[94];
      const auto axxxx_0 = current_data[117];
      const auto axxxy_0 = current_data[118];
      const auto axxyy_0 = current_data[119];
      const auto axyyy_0 = current_data[120];
      const auto ayyyy_0 = current_data[121];
      const auto axxxz_0 = current_data[124];
      const auto axxyz_0 = current_data[125];
      const auto axyyz_0 = current_data[126];
      const auto ayyyz_0 = current_data[127];
      const auto axxzz_0 = current_data[130];
      const auto axyzz_0 = current_data[131];
      const auto ayyzz_0 = current_data[132];
      const auto axzzz_0 = current_data[135];
      const auto ayzzz_0 = current_data[136];
      const auto azzzz_0 = current_data[139];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[135] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[136] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[137] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[138] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[139] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[140] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[141] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[142] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[143] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[144] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[145] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[146] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[147] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[148] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[149] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyzz
      const auto a0_0 = current_data[10];
      const auto ax_0 = current_data[27];
      const auto ay_0 = current_data[28];
      const auto az_0 = current_data[31];
      const auto axx_0 = current_data[50];
      const auto axy_0 = current_data[51];
      const auto ayy_0 = current_data[52];
      const auto axz_0 = current_data[55];
      const auto ayz_0 = current_data[56];
      const auto azz_0 = current_data[59];
      const auto axxx_0 = current_data[80];
      const auto axxy_0 = current_data[81];
      const auto axyy_0 = current_data[82];
      const auto ayyy_0 = current_data[83];
      const auto axxz_0 = current_data[86];
      const auto axyz_0 = current_data[87];
      const auto ayyz_0 = current_data[88];
      const auto axzz_0 = current_data[91];
      const auto ayzz_0 = current_data[92];
      const auto azzz_0 = current_data[95];
      const auto axxxx_0 = current_data[118];
      const auto axxxy_0 = current_data[119];
      const auto axxyy_0 = current_data[120];
      const auto axyyy_0 = current_data[121];
      const auto ayyyy_0 = current_data[122];
      const auto axxxz_0 = current_data[125];
      const auto axxyz_0 = current_data[126];
      const auto axyyz_0 = current_data[127];
      const auto ayyyz_0 = current_data[128];
      const auto axxzz_0 = current_data[131];
      const auto axyzz_0 = current_data[132];
      const auto ayyzz_0 = current_data[133];
      const auto axzzz_0 = current_data[136];
      const auto ayzzz_0 = current_data[137];
      const auto azzzz_0 = current_data[140];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[150] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[151] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[152] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[153] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[154] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[155] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[156] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[157] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[158] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[159] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[160] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[161] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[162] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[163] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[164] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyzz
      const auto a0_0 = current_data[11];
      const auto ax_0 = current_data[28];
      const auto ay_0 = current_data[29];
      const auto az_0 = current_data[32];
      const auto axx_0 = current_data[51];
      const auto axy_0 = current_data[52];
      const auto ayy_0 = current_data[53];
      const auto axz_0 = current_data[56];
      const auto ayz_0 = current_data[57];
      const auto azz_0 = current_data[60];
      const auto axxx_0 = current_data[81];
      const auto axxy_0 = current_data[82];
      const auto axyy_0 = current_data[83];
      const auto ayyy_0 = current_data[84];
      const auto axxz_0 = current_data[87];
      const auto axyz_0 = current_data[88];
      const auto ayyz_0 = current_data[89];
      const auto axzz_0 = current_data[92];
      const auto ayzz_0 = current_data[93];
      const auto azzz_0 = current_data[96];
      const auto axxxx_0 = current_data[119];
      const auto axxxy_0 = current_data[120];
      const auto axxyy_0 = current_data[121];
      const auto axyyy_0 = current_data[122];
      const auto ayyyy_0 = current_data[123];
      const auto axxxz_0 = current_data[126];
      const auto axxyz_0 = current_data[127];
      const auto axyyz_0 = current_data[128];
      const auto ayyyz_0 = current_data[129];
      const auto axxzz_0 = current_data[132];
      const auto axyzz_0 = current_data[133];
      const auto ayyzz_0 = current_data[134];
      const auto axzzz_0 = current_data[137];
      const auto ayzzz_0 = current_data[138];
      const auto azzzz_0 = current_data[141];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[165] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[166] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[167] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[168] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[169] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[170] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[171] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[172] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[173] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[174] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[175] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[176] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[177] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[178] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[179] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xzzz
      const auto a0_0 = current_data[12];
      const auto ax_0 = current_data[30];
      const auto ay_0 = current_data[31];
      const auto az_0 = current_data[33];
      const auto axx_0 = current_data[54];
      const auto axy_0 = current_data[55];
      const auto ayy_0 = current_data[56];
      const auto axz_0 = current_data[58];
      const auto ayz_0 = current_data[59];
      const auto azz_0 = current_data[61];
      const auto axxx_0 = current_data[85];
      const auto axxy_0 = current_data[86];
      const auto axyy_0 = current_data[87];
      const auto ayyy_0 = current_data[88];
      const auto axxz_0 = current_data[90];
      const auto axyz_0 = current_data[91];
      const auto ayyz_0 = current_data[92];
      const auto axzz_0 = current_data[94];
      const auto ayzz_0 = current_data[95];
      const auto azzz_0 = current_data[97];
      const auto axxxx_0 = current_data[124];
      const auto axxxy_0 = current_data[125];
      const auto axxyy_0 = current_data[126];
      const auto axyyy_0 = current_data[127];
      const auto ayyyy_0 = current_data[128];
      const auto axxxz_0 = current_data[130];
      const auto axxyz_0 = current_data[131];
      const auto axyyz_0 = current_data[132];
      const auto ayyyz_0 = current_data[133];
      const auto axxzz_0 = current_data[135];
      const auto axyzz_0 = current_data[136];
      const auto ayyzz_0 = current_data[137];
      const auto axzzz_0 = current_data[139];
      const auto ayzzz_0 = current_data[140];
      const auto azzzz_0 = current_data[142];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[180] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[181] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[182] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[183] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[184] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[185] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[186] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[187] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[188] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[189] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[190] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[191] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[192] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[193] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[194] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yzzz
      const auto a0_0 = current_data[13];
      const auto ax_0 = current_data[31];
      const auto ay_0 = current_data[32];
      const auto az_0 = current_data[34];
      const auto axx_0 = current_data[55];
      const auto axy_0 = current_data[56];
      const auto ayy_0 = current_data[57];
      const auto axz_0 = current_data[59];
      const auto ayz_0 = current_data[60];
      const auto azz_0 = current_data[62];
      const auto axxx_0 = current_data[86];
      const auto axxy_0 = current_data[87];
      const auto axyy_0 = current_data[88];
      const auto ayyy_0 = current_data[89];
      const auto axxz_0 = current_data[91];
      const auto axyz_0 = current_data[92];
      const auto ayyz_0 = current_data[93];
      const auto axzz_0 = current_data[95];
      const auto ayzz_0 = current_data[96];
      const auto azzz_0 = current_data[98];
      const auto axxxx_0 = current_data[125];
      const auto axxxy_0 = current_data[126];
      const auto axxyy_0 = current_data[127];
      const auto axyyy_0 = current_data[128];
      const auto ayyyy_0 = current_data[129];
      const auto axxxz_0 = current_data[131];
      const auto axxyz_0 = current_data[132];
      const auto axyyz_0 = current_data[133];
      const auto ayyyz_0 = current_data[134];
      const auto axxzz_0 = current_data[136];
      const auto axyzz_0 = current_data[137];
      const auto ayyzz_0 = current_data[138];
      const auto axzzz_0 = current_data[140];
      const auto ayzzz_0 = current_data[141];
      const auto azzzz_0 = current_data[143];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[195] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[196] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[197] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[198] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[199] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[200] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[201] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[202] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[203] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[204] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[205] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[206] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[207] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[208] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[209] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: zzzz
      const auto a0_0 = current_data[14];
      const auto ax_0 = current_data[33];
      const auto ay_0 = current_data[34];
      const auto az_0 = current_data[35];
      const auto axx_0 = current_data[58];
      const auto axy_0 = current_data[59];
      const auto ayy_0 = current_data[60];
      const auto axz_0 = current_data[61];
      const auto ayz_0 = current_data[62];
      const auto azz_0 = current_data[63];
      const auto axxx_0 = current_data[90];
      const auto axxy_0 = current_data[91];
      const auto axyy_0 = current_data[92];
      const auto ayyy_0 = current_data[93];
      const auto axxz_0 = current_data[94];
      const auto axyz_0 = current_data[95];
      const auto ayyz_0 = current_data[96];
      const auto axzz_0 = current_data[97];
      const auto ayzz_0 = current_data[98];
      const auto azzz_0 = current_data[99];
      const auto axxxx_0 = current_data[130];
      const auto axxxy_0 = current_data[131];
      const auto axxyy_0 = current_data[132];
      const auto axyyy_0 = current_data[133];
      const auto ayyyy_0 = current_data[134];
      const auto axxxz_0 = current_data[135];
      const auto axxyz_0 = current_data[136];
      const auto axyyz_0 = current_data[137];
      const auto ayyyz_0 = current_data[138];
      const auto axxzz_0 = current_data[139];
      const auto axyzz_0 = current_data[140];
      const auto ayyzz_0 = current_data[141];
      const auto axzzz_0 = current_data[142];
      const auto ayzzz_0 = current_data[143];
      const auto azzzz_0 = current_data[144];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[210] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[211] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[212] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[213] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[214] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[215] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[216] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[217] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[218] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[219] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[220] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[221] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[222] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[223] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[224] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
  }
}

