// ChannelList.C  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD
// Copyright (C) 2002 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "ChannelList.H"
#ifdef USESCRIPTS
#include "Interp.H"
#endif

ChannelList::ChannelList()
{
#ifdef HAVE_STL_CLEAR
  channel_list.clear();
#endif
}

ChannelList::~ChannelList()
{
  Channel *c;
  std::map<String, Channel *, std::less<String> >::iterator it;

  while (channel_list.size()!=0) {
    it = channel_list.begin();
    c = (*it).second;
    channel_list.erase(it);
    delete c;
  }
}

void
ChannelList::addChannel(ServerConnection *cnx, String name, String wantedModes)
{
  name = name.toLower();
  channel_list[name] = new Channel(cnx, name, wantedModes);
}

void
ChannelList::delChannel(String name)
{
  name = name.toLower();
  Channel *c = channel_list[name];
  if (c != 0) {
    channel_list.erase(name);
    delete c;
  }
}

Channel *
ChannelList::getChannel(String name)
{
  name = name.toLower();
  Channel *c = channel_list[name];

  if (c)
    return c;

  channel_list.erase(name);
  return 0;
}

void
ChannelList::clear()
{
  Channel *c;
  std::map<String, Channel *, std::less<String> >::iterator it;

  while (channel_list.size() != 0) {
    it = channel_list.begin();
    c = (*it).second;
    channel_list.erase(it);
    delete c;
  }
}
