//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/MaskContainerView.cpp
//! @brief     Implements MaskContainerView class
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Mask/MaskContainerView.h"
#include "GUI/Model/Data/MaskItems.h"
#include "GUI/Model/Data/ProjectionItems.h"
#include "GUI/View/Mask/ISceneAdaptor.h"
#include <QBrush>
#include <QPainter>
#include <QStyleOptionGraphicsItem>

MaskContainerView::MaskContainerView(MaskContainerItem* item)
    : IShape2DView(item)
    , m_item(item)
{
    // the key flag to not to draw children going outside ot given shape
    setFlag(QGraphicsItem::ItemClipsChildrenToShape, true);
}

MaskContainerView::MaskContainerView(ProjectionContainerItem* item)
    : IShape2DView(item)
    , m_item(item)
{
    setFlag(QGraphicsItem::ItemClipsChildrenToShape, true);
}

MaskItemObject* MaskContainerView::parameterizedItem() const
{
    return m_item;
}

void MaskContainerView::update_view()
{
    m_bounding_rect = m_adaptor->viewportRectangle();
    update();
}

void MaskContainerView::paint(QPainter* painter, const QStyleOptionGraphicsItem*, QWidget*)
{
    Q_UNUSED(painter);
}
