/*
 * Entagged Audio Tag library
 * Copyright (c) 2003-2005 Raphal Slinckx <raphael@slinckx.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *  
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package entagged.audioformats.wav.util;

import entagged.audioformats.EncodingInfo;
import entagged.audioformats.exceptions.*;

import java.io.*;

public class WavInfoReader {
	public EncodingInfo read(RandomAccessFile raf) throws CannotReadException,
			IOException {
		// Reads wav header----------------------------------------
		EncodingInfo info = new EncodingInfo();

		if (raf.length() < 12) {
			throw new CannotReadException("This is not a WAV File (<12 bytes)");
		}
		byte[] b = new byte[12];
		raf.read(b);

		WavRIFFHeader wh = new WavRIFFHeader(b);
		if (wh.isValid()) {
			b = new byte[24];
			raf.read(b);

			WavFormatHeader wfh = new WavFormatHeader(b);
			if (wfh.isValid()) {
				// Populates
				// encodingInfo----------------------------------------------------
				info.setPreciseLength(((float) raf.length() - (float) 36)
						/ wfh.getBytesPerSecond());
				info.setChannelNumber(wfh.getChannelNumber());
				info.setSamplingRate(wfh.getSamplingRate());
				info.setEncodingType("WAV-RIFF " + wfh.getBitrate() + " bits");
				info.setExtraEncodingInfos("");
				info.setBitrate(wfh.getBytesPerSecond() * 8 / 1000);
				info.setVbr(false);
			} else {
				throw new CannotReadException("Wav Format Header not valid");
			}
		} else {
			throw new CannotReadException("Wav RIFF Header not valid");
		}

		return info;
	}
}
