/* $Id: ProcCallStat.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __PROC_CALL_STAT_HPP_INCLUDED
#define __PROC_CALL_STAT_HPP_INCLUDED

#include "frontend/ast/SeqStat.hpp"
#include "frontend/ast/AssociationElement.hpp"
#include "frontend/ast/Name.hpp"
#include "frontend/ast/ProcedureDeclaration.hpp"

namespace ast {

/** a VHDL procedure call statement. */
class ProcCallStat : public SeqStat {
public:
	//! c'tor 
	/** @param pName name of the called procedure
	 *  @param args List of arguments (List of AssociationElement).
	 *  @param loc location of the procedure call.
	 */
	ProcCallStat(
		Name *pName, 
		std::list<AssociationElement*> *args,
		Location loc
		) : 	SeqStat(loc),
			subprog(pName), 
			definition(NULL),
			arguments(args) {}
	
	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << subprog << '(';
		if (this->arguments != NULL) {
			util::MiscUtil::listPut(this->arguments, stream, ", ");
		} else {
			stream << "open";
		}

		stream << ");";
	}


	/** name referring to the procedure */
	Name *subprog;

	/** definition as resolved by ResolveTypes. */
	ProcedureDeclaration *definition;
	
	/** arguments of the procedure call (optional) */
	std::list<AssociationElement*> *arguments;

protected:
	/** Destructor */
	virtual ~ProcCallStat() {
		util::MiscUtil::terminate(subprog);
		util::MiscUtil::lterminate(arguments);
	}
};

}; /* namespace ast */

#endif /* __PROC_CALL_STAT_HPP_INCLUDED */
