/* $Id: ResolveSymbols.hpp 4392 2009-03-25 17:01:06Z potyra $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __RESOLVE_SYMBOLS_HPP_INCLUDED
#define __RESOLVE_SYMBOLS_HPP_INCLUDED

#include "frontend/visitor/TopDownVisitor.hpp"
#include "frontend/misc/SymbolTable.hpp"

namespace ast {

//! class used to late resolve symbols
/** This class can be used to set the symbol candidates for name based nodes,
 *  in case these couldn't get looked up yet during scanning.
 *  The most prominent example is any association list.
 */
class ResolveSymbols : public TopDownVisitor {
public:
	//! c'tor
	/** @param symbolTable symbol table instance. */
	ResolveSymbols(
		SymbolTable &symbolTable
		) : 	symTab(symbolTable),
			prefixCands(NULL) {}

private:
	/** visit a SimpleName
         *  @param node node that get's visited.
         */
	virtual void visit(SimpleName &node);

	/** visit a TemporaryName
         *  @param node node that get's visited.
         */
	virtual void visit(TemporaryName &node);

	/** visit a SelectedName
         *  @param node node that get's visited.
         */
	virtual void visit(SelectedName &node);

	/** visit a AttributeName
         *  @param node node that get's visited.
         */
	virtual void visit(AttributeName &node);

	/** visit a Slice
         *  @param node node that get's visited.
         */
	virtual void visit(Slice &node);

	/** visit a Subscript
         *  @param node node that get's visited.
         */
	virtual void visit(Subscript &node);

	/** visit a FunctionCall
         *  @param node node that get's visited.
         */
	virtual void visit(FunctionCall &node);

	/** visit an AssociationElement
         *  @param node node that get's visited.
         */
	virtual void visit(AssociationElement &node);

	/** visit a ElementAssociation
         *  @param node node that get's visited.
         */
	virtual void visit(ElementAssociation &node);

	/** visit an CompInstStat
         *  @param node node that get's visited.
         */
	virtual void visit(CompInstStat &node);

	//! process a generic expression
	/** @param node node to process.
	 */
	virtual void process(Expression &node);

	//! process a generic AstNode (must not happen).
	/** @param node node to process.
	 */
	virtual void process(AstNode &node);

	//! SymbolTable instance.
	SymbolTable &symTab;

	//! typedef for symbol lists.
	// FIXME should probably go to DeclarativeRegion or SymbolTable
	typedef std::list<Symbol*> symListT;

	//! prefix candidate symbols.
	symListT *prefixCands;
};


}; /* namespace ast */

#endif /* __RESOLVE_SYMBOLS_HPP_INCLUDED */
