-- $Id: array_param2.vhdl 4327 2009-01-27 14:41:18Z potyra $ 

-- array parameters 2

-- Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


package t is 
	type byte is array(0 to 7) of bit;
	procedure foo(variable a : inout byte);
end package t;

package body t is
	procedure foo(variable a : inout byte) is
	begin
		a(0) := '0';
	end;
end t;

entity test_bench is
end entity test_bench;

use t.all;
architecture test_bench_impl of test_bench is
begin
	x : process
		variable x : bit;
		variable b : byte;
	begin
		b := "11100011";
		foo(b);
		assert(x = '0') 
			report "foo(b) should set b(0) to '0'."
			severity failure;
		assert false report "simulation finished" severity note;
		wait;
	end process;
end test_bench_impl;
