/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __TEMPORARY_NAME_HPP_INCLUDED
#define __TEMPORARY_NAME_HPP_INCLUDED

#include "frontend/ast/PrefixedName.hpp"

namespace ast {

//! An indexed name or slice name, resulting in a temporary.
/** This class represents a VHDL indexed name or slice name. The index or 
 *  slice expression is stored as prefix, while the actual name is NULL, 
 *  because the VHDL grammar doesn't really represent a named object at this
 *  point, but rather a temporary one.
 *  In particular, a temporary name cannot be used for a procedure call or a 
 *  function call (as there would be no indication of what procedure or 
 *  function to call).
 */
class TemporaryName : public PrefixedName {
public:
	//! c'tor
	/** @param pre prefix of the name
	 *  @param loc corresponding location
	 */
	TemporaryName(
		Expression *pre,
		Location loc
		) :	PrefixedName(NULL, pre, std::list<Symbol*>(), loc) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor &visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << this->prefix;
	}

protected:
	//! d'tor
	virtual ~TemporaryName() {}
};

}; /* namespace ast */

#endif /* __TEMPORARY_NAME_HPP_INCLUDED */
