/* $Id: sig_ide.h,v 1.5 2009-01-27 17:44:20 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_IDE_H_INCLUDED
#define __SIG_IDE_H_INCLUDED

#define __LITTLE_ENDIAN_BITFIELD

/* from <linux/cdrom.h> kernel 2.4.18 */
#define GPMODE_R_W_ERROR_PAGE    0x01
#define GPMODE_AUDIO_CTL_PAGE    0x0e
#define GPMODE_CAPABILITIES_PAGE 0x2a
#define GPMODE_CDROM_PAGE		 0x0d
#define GPMODE_WRITE_PARMS_PAGE  0x05

/* from <linux/hdreg.h> kernel 2.4.18 --tg 14:21 2002-05-22 */
#define WIN_SRST                0x08    /* ATAPI soft reset command */
#define WIN_RESTORE             0x10
#define WIN_READ                0x20
#define WIN_WRITE               0x30
#define WIN_SPECIFY             0x91	/* set drive geometry translation */
#define WIN_READDMA             0xC8    /* read sectors using DMA transfers */
#define WIN_WRITEDMA            0xCA    /* write sectors using DMA transfers */

#define WIN_NOP			0x00
#define WIN_EXECUTE_DEVICE_DIAGNOSTIC	0x90
#define WIN_IDENTIFY            0xEC	/* ask drive to identify itself */
#define WIN_SETFEATURES         0xEF    /* set special drive features */
#define WIN_SMART               0xb0	/* self monitoring and reporting */

/* power stuff */
#define WIN_STANDBYNOW1         0xE0
#define WIN_STANDBYNOW2         0x94
#define WIN_SLEEPNOW1           0xE6
#define WIN_SLEEPNOW2           0x99
#define WIN_CHECKPOWERMODE1     0xE5
#define WIN_CHECKPOWERMODE2     0x98
#define WIN_IDLEIMMEDIATE       0xE1	/* force drive to become "ready" */
#define WIN_FLUSH_CACHE         0xE7
#define WIN_READ_NATIVE_MAX     0xF8    /* return the native maximum address */

#define WIN_MULTREAD            0xC4    /* read sectors using multiple mode */
#define WIN_MULTWRITE           0xC5    /* write sectors using multiple mode */
#define WIN_SETMULT             0xC6    /* enable/disable multiple mode */

/* stats */
#define ERR_STAT                0x01
#define INDEX_STAT              0x02
#define ECC_STAT                0x04	/* Corrected error */
#define DRQ_STAT                0x08
#define SEEK_STAT               0x10
#define WRERR_STAT              0x20
#define READY_STAT              0x40
#define BUSY_STAT               0x80

/* ATAPI stuff */
#define WIN_PIDENTIFY           0xA1	/* identify ATAPI device */
#define WIN_SRST                0x08	/* ATAPI soft reset command */
#define WIN_PACKETCMD           0xA0	/* Send a packet command. */

/* structure returned by HDIO_GET_IDENTITY, as per ANSI ATA2 rev.2f spec */
struct hd_driveid {
	unsigned short config;	/* lots of obsolete bit flags */
	unsigned short cyls;	/* "physical" cyls */
	unsigned short reserved2;	/* reserved (word 2) */
	unsigned short heads;	/* "physical" heads */
	unsigned short track_bytes;	/* unformatted bytes per track */
	unsigned short sector_bytes;	/* unformatted bytes per sector */
	unsigned short sectors;	/* "physical" sectors per track */
	unsigned short vendor0;	/* vendor unique */
	unsigned short vendor1;	/* vendor unique */
	unsigned short vendor2;	/* vendor unique */
	unsigned char serial_no[20];	/* 0 = not_specified */
	unsigned short buf_type;
	unsigned short buf_size;    /* 512 byte increments; 0 = not_specified */
	unsigned short ecc_bytes;   /* for r/w long cmds; 0 = not_specified */
	unsigned char fw_rev[8];	/* 0 = not_specified */
	unsigned char model[40];	/* 0 = not_specified */
	unsigned char max_multsect;	/* 0=not_implemented */
	unsigned char vendor3;	/* vendor unique */
	unsigned short dword_io;	/* 0=not_implemented; 1=implemented */
	unsigned char vendor4;	/* vendor unique */
	unsigned char capability;    /* bits 0:DMA 1:LBA 2:IORDYsw 3:IORDYsup */
	unsigned short reserved50;	/* reserved (word 50) */
	unsigned char vendor5;	/* vendor unique */
	unsigned char tPIO;	/* 0=slow, 1=medium, 2=fast */
	unsigned char vendor6;	/* vendor unique */
	unsigned char tDMA;	/* 0=slow, 1=medium, 2=fast */
	unsigned short field_valid;	/* bits 0:cur_ok 1:eide_ok */
	unsigned short cur_cyls;	/* logical cylinders */
	unsigned short cur_heads;	/* logical heads */
	unsigned short cur_sectors;	/* logical sectors per track */
	unsigned short cur_capacity0;	/* logical total sectors on drive */
	unsigned short cur_capacity1;	/*  (2 words, misaligned int)     */
	unsigned char multsect;	/* current multiple sector count */
	unsigned char multsect_valid;	/* when (bit0==1) multsect is ok */
	unsigned int lba_capacity;	/* total number of sectors */
	unsigned short dma_1word;	/* single-word dma info */
	unsigned short dma_mword;	/* multiple-word dma info */
	unsigned short eide_pio_modes;	/* bits 0:mode3 1:mode4 */
	unsigned short eide_dma_min;	/* min mword dma cycle time (ns) */
	unsigned short eide_dma_time;/* recommended mword dma cycle time (ns) */
	unsigned short eide_pio;	/* min cycle time (ns), no IORDY  */
	unsigned short eide_pio_iordy;	/* min cycle time (ns), with IORDY */
	unsigned short words69_70[2];	/* reserved words 69-70 */
	/* HDIO_GET_IDENTITY currently returns only words 0 through 70 */
	unsigned short words71_74[4];	/* reserved words 71-74 */
	unsigned short queue_depth;	/*  */
	unsigned short words76_79[4];	/* reserved words 76-79 */
	unsigned short major_rev_num;	/*  */
	unsigned short minor_rev_num;	/*  */
	/* bits 0:Smart 1:Security 2:Removable 3:PM */
	unsigned short command_set_1;
	unsigned short command_set_2;	/* bits 14:Smart Enabled 13:0 zero */
	unsigned short cfsse;	/* command set-feature supported extensions */
	unsigned short cfs_enable_1;	/* command set-feature enabled */
	unsigned short cfs_enable_2;	/* command set-feature enabled */
	unsigned short csf_default;	/* command set-feature default */
	unsigned short dma_ultra;	/*  */
	unsigned short word89;	/* reserved (word 89) */
	unsigned short word90;	/* reserved (word 90) */
	unsigned short CurAPMvalues;	/* current APM values */
	unsigned short word92;	/* reserved (word 92) */
	unsigned short hw_config;	/* hardware config */
	unsigned short words94_125[32];	/* reserved words 94-125 */
	unsigned short last_lun;	/* reserved (word 126) */
	unsigned short word127;	/* reserved (word 127) */
	unsigned short dlf;	/* device lock function
				 * 15:9        reserved
				 * 8   security level 1:max 0:high
				 * 7:6 reserved
				 * 5   enhanced erase
				 * 4   expire
				 * 3   frozen
				 * 2   locked
				 * 1   en/disabled
				 * 0   capability
				 */
	unsigned short csfo;	/* current set features options
				 * 15:4        reserved
				 * 3   auto reassign
				 * 2   reverting
				 * 1   read-look-ahead
				 * 0   write cache
				 */
	unsigned short words130_155[26]; /* reserved vendor words 130-155 */
	unsigned short word156;
	unsigned short words157_159[3];	 /* reserved vendor words 157-159 */
	unsigned short words160_255[95]; /* reserved words 160-255 */
};

/* from <linux/ide.h> kernel 2.4.18 --tg 19:39 2002-05-20 */
#define ide_scsi        0x21
#define ide_disk        0x20
#define ide_optical     0x7
#define ide_cdrom       0x5
#define ide_tape        0x1
#define ide_floppy      0x0

#define HDX (nr * 2 + unit + 'a')

typedef enum {
	mechtype_caddy = 0,
	mechtype_tray = 1,
	mechtype_popup = 2,
	mechtype_individual_changer = 4,
	mechtype_cartridge_changer = 5
} mechtype_t;

struct mode_page_header {
	unsigned short mode_data_length;
	unsigned char medium_type;
	unsigned char reserved1;
	unsigned char reserved2;
	unsigned char reserved3;
	unsigned short desc_length;
};

struct atapi_capabilities_page {
	struct mode_page_header header;
#if defined(__BIG_ENDIAN_BITFIELD)
	unsigned char parameters_saveable:1;
	unsigned char reserved1:1;
	unsigned char page_code:6;
#elif defined(__LITTLE_ENDIAN_BITFIELD)
	unsigned char page_code:6;
	unsigned char reserved1:1;
	unsigned char parameters_saveable:1;
#else
#error "Please fix <asm/byteorder.h>"
#endif

	unsigned char page_length;

#if defined(__BIG_ENDIAN_BITFIELD)
	unsigned char reserved2:2;
	/* Drive supports reading of DVD-RAM discs */
	unsigned char dvd_ram_read:1;
	/* Drive supports reading of DVD-R discs */
	unsigned char dvd_r_read:1;
	/* Drive supports reading of DVD-ROM discs */
	unsigned char dvd_rom:1;
	/* Drive supports reading CD-R discs with addressing method 2 */
	unsigned char method2:1;		/* reserved in 1.2 */
	/* Drive can read from CD-R/W (CD-E) discs (orange book, part III) */
	unsigned char cd_rw_read:1;	/* reserved in 1.2 */
	/* Drive supports read from CD-R discs (orange book, part II) */
	unsigned char cd_r_read:1;	/* reserved in 1.2 */
#elif defined(__LITTLE_ENDIAN_BITFIELD)
	/* Drive supports read from CD-R discs (orange book, part II) */
	unsigned char cd_r_read:1;	/* reserved in 1.2 */
	/* Drive can read from CD-R/W (CD-E) discs (orange book, part III) */
	unsigned char cd_rw_read:1;	/* reserved in 1.2 */
	/* Drive supports reading CD-R discs with addressing method 2 */
	unsigned char method2:1;
	/* Drive supports reading of DVD-ROM discs */
	unsigned char dvd_rom:1;
	/* Drive supports reading of DVD-R discs */
	unsigned char dvd_r_read:1;
	/* Drive supports reading of DVD-RAM discs */
	unsigned char dvd_ram_read:1;
	unsigned char reserved2:2;
#else
#error "Please fix <asm/byteorder.h>"
#endif

#if defined(__BIG_ENDIAN_BITFIELD)
	unsigned char reserved3:2;
	/* Drive can write DVD-RAM discs */
	unsigned char dvd_ram_write:1;
	/* Drive can write DVD-R discs */
	unsigned char dvd_r_write:1;
	unsigned char reserved3a:1;
	/* Drive can fake writes */
	unsigned char test_write:1;
	/* Drive can write to CD-R/W (CD-E) discs (orange book, part III) */
	unsigned char cd_rw_write:1;	/* reserved in 1.2 */
	/* Drive supports write to CD-R discs (orange book, part II) */
	unsigned char cd_r_write:1;	/* reserved in 1.2 */
#elif defined(__LITTLE_ENDIAN_BITFIELD)
	/* Drive can write to CD-R discs (orange book, part II) */
	unsigned char cd_r_write:1;	/* reserved in 1.2 */
	/* Drive can write to CD-R/W (CD-E) discs (orange book, part III) */
	unsigned char cd_rw_write:1;	/* reserved in 1.2 */
	/* Drive can fake writes */
	unsigned char test_write:1;
	unsigned char reserved3a:1;
	/* Drive can write DVD-R discs */
	unsigned char dvd_r_write:1;
	/* Drive can write DVD-RAM discs */
	unsigned char dvd_ram_write:1;
	unsigned char reserved3:2;
#else
#error "Please fix <asm/byteorder.h>"
#endif

#if defined(__BIG_ENDIAN_BITFIELD)
	unsigned char reserved4:1;
	/* Drive can read multisession discs. */
	unsigned char multisession:1;
	/* Drive can read mode 2, form 2 data. */
	unsigned char mode2_form2:1;
	/* Drive can read mode 2, form 1 (XA) data. */
	unsigned char mode2_form1:1;
	/* Drive supports digital output on port 2. */
	unsigned char digport2:1;
	/* Drive supports digital output on port 1. */
	unsigned char digport1:1;
	/* Drive can deliver a composite audio/video data stream. */
	unsigned char composite:1;
	/* Drive supports audio play operations. */
	unsigned char audio_play:1;
#elif defined(__LITTLE_ENDIAN_BITFIELD)
	/* Drive supports audio play operations. */
	unsigned char audio_play:1;
	/* Drive can deliver a composite audio/video data stream. */
	unsigned char composite:1;
	/* Drive supports digital output on port 1. */
	unsigned char digport1:1;
	/* Drive supports digital output on port 2. */
	unsigned char digport2:1;
	/* Drive can read mode 2, form 1 (XA) data. */
	unsigned char mode2_form1:1;
	/* Drive can read mode 2, form 2 data. */
	unsigned char mode2_form2:1;
	/* Drive can read multisession discs. */
	unsigned char multisession:1;
	unsigned char reserved4:1;
#else
#error "Please fix <asm/byteorder.h>"
#endif

#if defined(__BIG_ENDIAN_BITFIELD)
	unsigned char reserved5:1;
	/* Drive can return Media Catalog Number (UPC) info. */
	unsigned char upc:1;
	/* Drive can return International Standard Recording Code info. */
	unsigned char isrc:1;
	/* Drive supports C2 error pointers. */
	unsigned char c2_pointers:1;
	/* R-W data will be returned deinterleaved and error corrected. */
	unsigned char rw_corr:1;
	/* Subchannel reads can return combined R-W information. */
	unsigned char rw_supported:1;
	/* Drive can continue a read cdda operation from a loss of streaming. */
	unsigned char cdda_accurate:1;
	/* Drive can read Red Book audio data. */
	unsigned char cdda:1;
#elif defined(__LITTLE_ENDIAN_BITFIELD)
	/* Drive can read Red Book audio data. */
	unsigned char cdda:1;
	/* Drive can continue a read cdda operation from a loss of streaming. */
	unsigned char cdda_accurate:1;
	/* Subchannel reads can return combined R-W information. */
	unsigned char rw_supported:1;
	/* R-W data will be returned deinterleaved and error corrected. */
	unsigned char rw_corr:1;
	/* Drive supports C2 error pointers. */
	unsigned char c2_pointers:1;
	/* Drive can return International Standard Recording Code info. */
	unsigned char isrc:1;
	/* Drive can return Media Catalog Number (UPC) info. */
	unsigned char upc:1;
	unsigned char reserved5:1;
#else
#error "Please fix <asm/byteorder.h>"
#endif

#if defined(__BIG_ENDIAN_BITFIELD)
	/* Drive mechanism types. */
	mechtype_t mechtype:3;
	unsigned char reserved6:1;
	/* Drive can eject a disc or changer cartridge. */
	unsigned char eject:1;
	/* State of prevent/allow jumper. */
	unsigned char prevent_jumper:1;
	/* Present state of door lock. */
	unsigned char lock_state:1;
	/* Drive can lock the door. */
	unsigned char lock:1;
#elif defined(__LITTLE_ENDIAN_BITFIELD)

	/* Drive can lock the door. */
	unsigned char lock:1;
	/* Present state of door lock. */
	unsigned char lock_state:1;
	/* State of prevent/allow jumper. */
	unsigned char prevent_jumper:1;
	/* Drive can eject a disc or changer cartridge. */
	unsigned char eject:1;
	unsigned char reserved6:1;
	/* Drive mechanism types. */
	mechtype_t mechtype:3;
#else
#error "Please fix <asm/byteorder.h>"
#endif

#if defined(__BIG_ENDIAN_BITFIELD)
	unsigned char reserved7:4;
	/* Drive supports software slot selection. */
	unsigned char sss:1;		/* reserved in 1.2 */
	/* Changer can report exact contents of slots. */
	unsigned char disc_present:1;	/* reserved in 1.2 */
	/* Audio for each channel can be muted independently. */
	unsigned char separate_mute:1;
	/* Audio level for each channel can be controlled independently. */
	unsigned char separate_volume:1;
#elif defined(__LITTLE_ENDIAN_BITFIELD)

	/* Audio level for each channel can be controlled independently. */
	unsigned char separate_volume:1;
	/* Audio for each channel can be muted independently. */
	unsigned char separate_mute:1;
	/* Changer can report exact contents of slots. */
	unsigned char disc_present:1;	/* reserved in 1.2 */
	/* Drive supports software slot selection. */
	unsigned char sss:1;		/* reserved in 1.2 */
	unsigned char reserved7:4;
#else
#error "Please fix <asm/byteorder.h>"
#endif

	/* Note: the following four fields are returned in big-endian form. */
	/* Maximum speed (in kB/s). */
	unsigned short maxspeed;
	/* Number of discrete volume levels. */
	unsigned short n_vol_levels;
	/* Size of cache in drive, in kB. */
	unsigned short buffer_size;
	/* Current speed (in kB/s). */
	unsigned short curspeed;
	char pad[4];
};

/* Structure of a MSF cdrom address. */
struct atapi_msf {
	unsigned char reserved;
	unsigned char minute;
	unsigned char second;
	unsigned char frame;
};

/* Space to hold the disk TOC. */
#define MAX_TRACKS 99
struct atapi_toc_header {
	unsigned short toc_length;
	unsigned char first_track;
	unsigned char last_track;
};

struct atapi_toc_entry {
	unsigned char reserved1;
#if defined(__BIG_ENDIAN_BITFIELD)
	unsigned char adr:4;
	unsigned char control:4;
#elif defined(__LITTLE_ENDIAN_BITFIELD)
	unsigned char control:4;
	unsigned char adr:4;
#else
#error "Please fix <asm/byteorder.h>"
#endif
	unsigned char track;
	unsigned char reserved2;
	union {
		unsigned lba;
		struct atapi_msf msf;
	} addr;
};

struct atapi_toc_q_entry {
	unsigned char session;
#if defined(__BIG_ENDIAN_BITFIELD)
	unsigned char adr:4;
	unsigned char control:4;
#elif defined(__LITTLE_ENDIAN_BITFIELD)
	unsigned char control:4;
	unsigned char adr:4;
#else
#error "Please fix <asm/byteorder.h>"
#endif
	unsigned char tno;
	unsigned char point;
	unsigned char min;
	unsigned char sec;
	unsigned char frame;
	unsigned char zero;
	unsigned char pmin;
	unsigned char psec;
	unsigned char pframe;
};

struct atapi_toc {
	int last_session_lba;
	int xa_flag;
	unsigned long capacity;
	struct atapi_toc_header hdr;
	struct atapi_toc_entry ent[MAX_TRACKS + 1];
	/* One extra for the leadout. */
};

struct request_sense {
#if defined(__BIG_ENDIAN_BITFIELD)
        unsigned char valid              : 1;
        unsigned char error_code         : 7;
#elif defined(__LITTLE_ENDIAN_BITFIELD)
        unsigned char error_code         : 7;
        unsigned char valid              : 1;
#endif
        unsigned char segment_number;
#if defined(__BIG_ENDIAN_BITFIELD)
        unsigned char reserved1          : 2;
        unsigned char ili                : 1;
        unsigned char reserved2          : 1;
        unsigned char sense_key          : 4;
#elif defined(__LITTLE_ENDIAN_BITFIELD)
        unsigned char sense_key          : 4;
        unsigned char reserved2          : 1;
        unsigned char ili                : 1;
        unsigned char reserved1          : 2;
#endif
        unsigned char information[4];
        unsigned char add_sense_len;
        unsigned char command_info[4];
        unsigned char asc;
        unsigned char ascq;
        unsigned char fruc;
        unsigned char sks[3];
        unsigned char asb[46];
};

#define CD_SECS              60	/* seconds per minute */
#define CD_FRAMES            75	/* frames per second */
#define CD_MSF_OFFSET       150	/* MSF numbering offset of first frame */

#define ARY_LEN(a) ((sizeof(a) / sizeof(a[0])))

/*********************************************************************
  Generic Packet commands, MMC commands, and such
 *********************************************************************/

/* The generic packet command opcodes for CD/DVD Logical Units,
 * From Table 57 of the SFF8090 Ver. 3 (Mt. Fuji) draft standard. */
#define GPCMD_BLANK                         0xa1
#define GPCMD_CLOSE_TRACK                   0x5b
#define GPCMD_SYNCHRONIZE_CACHE             0x35
#define GPCMD_FORMAT_UNIT                   0x04
#define GPCMD_GET_CONFIGURATION             0x46
#define GPCMD_GET_EVENT_STATUS_NOTIFICATION 0x4a
#define GPCMD_GET_PERFORMANCE               0xac
#define GPCMD_INQUIRY                       0x12
#define GPCMD_LOAD_UNLOAD                   0xa6
#define GPCMD_MECHANISM_STATUS              0xbd
#define GPCMD_MODE_SELECT_6                 0x15
#define GPCMD_MODE_SELECT_10                0x55
#define GPCMD_MODE_SENSE_6                  0x1a
#define GPCMD_MODE_SENSE_10                 0x5a
#define GPCMD_PAUSE_RESUME                  0x4b
#define GPCMD_PLAY_AUDIO_10                 0x45
#define GPCMD_PLAY_AUDIO_MSF                0x47
#define GPCMD_PLAY_AUDIO_TI                 0x48
#define GPCMD_PLAY_CD                       0xbc
#define GPCMD_PREVENT_ALLOW_MEDIUM_REMOVAL  0x1e
#define GPCMD_READ_6                        0x08
#define GPCMD_READ_10                       0x28
#define GPCMD_READ_12                       0xa8
#define GPCMD_REPORT_LUNS                   0xa0
#define GPCMD_RESERVE_10                    0x56
#define GPCMD_RESERVE_TRACK                 0x53
#define GPCMD_RELEASE_10                    0x57
#define GPCMD_READ_CD_RECORDED_CAPACITY     0x25
#define GPCMD_READ_CD                       0xbe
#define GPCMD_READ_CD_MSF                   0xb9
#define GPCMD_READ_DISC_INFO                0x51
#define GPCMD_READ_DVD_STRUCTURE            0xad
#define GPCMD_READ_FORMAT_CAPACITIES        0x23
#define GPCMD_READ_HEADER                   0x44
#define GPCMD_READ_TRACK_INFORMATION        0x52
#define GPCMD_READ_SUBCHANNEL               0x42
#define GPCMD_READ_TOC_PMA_ATIP             0x43
#define GPCMD_REPAIR_RZONE_TRACK            0x58
#define GPCMD_REPORT_KEY                    0xa4
#define GPCMD_REQUEST_SENSE                 0x03
#define GPCMD_RESERVE_RZONE_TRACK           0x53
#define GPCMD_SCAN                          0xba
#define GPCMD_SEEK_6                        0x0b
#define GPCMD_SEEK_10                       0x2b
#define GPCMD_SEND_CUE_SHEET                0x5d
#define GPCMD_SEND_DIAGNOSTIC               0x1d
#define GPCMD_SEND_DVD_STRUCTURE            0xad
#define GPCMD_SEND_EVENT                    0xa2
#define GPCMD_SEND_KEY                      0xa3
#define GPCMD_SEND_OPC                      0x54
#define GPCMD_SET_READ_AHEAD                0xa7
#define GPCMD_SET_STREAMING                 0xb6
#define GPCMD_START_STOP_UNIT               0x1b
#define GPCMD_STOP_PLAY_SCAN                0x4e
#define GPCMD_TEST_UNIT_READY               0x00
#define GPCMD_VERIFY_10                     0x2f
#define GPCMD_WRITE_10                      0x2a
#define GPCMD_WRITE_AND_VERIFY_10           0x2e
/* This is listed as optional in ATAPI 2.6, but is (curiously) 
   missing from Mt. Fuji, Table 57.  It _is_ mentioned in Mt. Fuji
 * Table 377 as an MMC command for SCSi devices though...  Most ATAPI
 * drives support it. */
#define GPCMD_SET_CD_SPEED                  0xbb
/* This seems to be a SCSI specific CD-ROM opcode 
 * to play data at track/index */
#define GPCMD_PLAYAUDIO_TI                  0x48
/*
 * From MS Media Status Notification Support Specification. For
 * older drives only.
 */
#define GPCMD_GET_MEDIA_STATUS              0xda

/* ATAPI sense keys (from table 140 of ATAPI 2.6) */
/* from 2.4.20:drivers/ide/ide-cd.h */

#define NO_SENSE                0x00
#define RECOVERED_ERROR         0x01
#define NOT_READY               0x02
#define MEDIUM_ERROR            0x03
#define HARDWARE_ERROR          0x04
#define ILLEGAL_REQUEST         0x05
#define UNIT_ATTENTION          0x06
#define DATA_PROTECT            0x07
#define ABORTED_COMMAND         0x0b
#define MISCOMPARE              0x0e

#endif /* __SIG_IDE_H_INCLUDED */
