/*******************************************************************
 * libfaxophone                                                    *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file fax.h
 * \brief Fax structures
 */

#ifndef FAX_H
#define FAX_H

#include <spandsp.h>

#define SPANDSP_VERSION			6
/* Service indicator (0x04=speech, 0x11=fax/g3) */
#define SPEECH_CIP			0x04
#define FAX_CIP				0x11

enum eFaxPhase {
	IDLE			= -1,
	CONNECT			= 1,
	PHASE_B			= 2,
	PHASE_D			= 3,
	PHASE_E			= 4,
	FAX_OK			= 5,
	FAX_FAILED		= 6,
	FAX_REJECTED	= 7,
};

struct sFaxStatus {
	char anTiffFile[ 256 ];
	char anSrcNo[ 64 ];
	char anTrgNo[ 64 ];
	char anIdent[ 64 ];
	char anHeader[ 64 ];
	char anRemoteIdent[ 64 ];

	enum eFaxPhase ePhase;
	int nErrorCode;
	int nSending;
	int nEcm;
	int nModem;
	int nBitrate;
	int nEncoding;
	int nBadRows;
	int nPageCurrent;
	int nPageTotal;
	int nBytesReceived;
	int nBytesSent;
	int nBytesTotal;
	int nManualHookup;
	int nDone;

	fax_state_t *psFaxState;
};

struct sCapiConnection *faxSend( const char *pnTiffFile, int nModem, int nEcm, int nController, const char *pnSrcNo, const char *pnTrgNo, const char *pnLsi, const char *pnLocalHeaderInfo, int nCallAnonymous );
int faxRecv( const char *pnTiffFile, int nModem, int nEcm, const char *pnSrcNo, char *pnTrgNo, const char *pnLsi, const char *pnLocalHeaderInfo, int nManualHookup );

void faxTransfer( struct sCapiConnection *psConnection, _cmsg sMessage );
void faxClean( struct sCapiConnection *psConnection );

#endif
