/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file profiles.h
 * \brief Profiles header
 */

#ifndef PROFILES_H
#define PROFILES_H

struct sPref {
	int nType;
	char *pnName;
	union {
		gpointer pGeneric;
		gboolean bBoolean;
		int nInteger;
		char *pnString;
		GList *psStringList;
	} uValue;
	struct sPref *psParent;
	struct sPref *psSibling;
	struct sPref *psFirstChild;
};

enum {
	PREF_NONE =	0,
	PREF_STRING,
	PREF_PATH,
	PREF_INT,
	PREF_BOOLEAN
};

struct sRouterInfo {
	char *pnInternationalPrefix;
	char *pnCountryCode;
	char *pnNationalPrefix;
	char *pnAreaCode;
	char *pnLanguage;
	char *pnFirmware;
	int nType;
	int nSubType;
	gboolean bUseSsl;
	gchar *pnSessionId;
};

struct sProfile {
	gchar *pnName;
	gchar *pnFile;
	gboolean bLocked;
	GList *psPrefsStack;
	GHashTable *psPrefsHash;
	struct sPref sPrefs;
	struct sAddressBook *psDefaultBook;
	struct sLookup *psDefaultLookup;
	struct sFax *psDefaultFax;
	struct sPassword *psDefaultPassword;
	struct sAudio *psDefaultAudio;
	struct sRouterInfo sRouterInfo;
};

const gchar *getHomeDir( void );
const gchar *getUserDir( void );
const gchar *getPluginSettingsDir( void );
struct sProfile *createProfile( const gchar *pnName, const gchar *pnFile );
struct sProfile *findProfile( const gchar *pnName );
GList *getProfiles( void );
void setActiveProfile( struct sProfile *psProfile );
struct sProfile *getActiveProfile( void );
void ProfilesManage( void );

#endif
