'''OpenGL extension EXT.occlusion_query_boolean

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.occlusion_query_boolean to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/occlusion_query_boolean.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.occlusion_query_boolean import *
from OpenGL.raw.GLES2.EXT.occlusion_query_boolean import _EXTENSION_NAME

def glInitOcclusionQueryBooleanEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glGenQueriesEXT.ids size not checked against n
glGenQueriesEXT=wrapper.wrapper(glGenQueriesEXT).setInputArraySize(
    'ids', None
)
# INPUT glDeleteQueriesEXT.ids size not checked against n
glDeleteQueriesEXT=wrapper.wrapper(glDeleteQueriesEXT).setInputArraySize(
    'ids', None
)
### END AUTOGENERATED SECTION