/* plugin.c generated by valac 0.16.1, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsobasics.h>
#include <freesmartphone.h>
#include <fsoframework.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <linux/input.h>
#include <unistd.h>
#include <gio/gio.h>
#include <gee.h>
#include <fsodevice.h>
#include <time.h>
#include <gobject/gvaluecollector.h>


#define KERNEL_TYPE_INPUT_DEVICE (kernel_input_device_get_type ())
#define KERNEL_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KERNEL_TYPE_INPUT_DEVICE, KernelInputDevice))
#define KERNEL_INPUT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KERNEL_TYPE_INPUT_DEVICE, KernelInputDeviceClass))
#define KERNEL_IS_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KERNEL_TYPE_INPUT_DEVICE))
#define KERNEL_IS_INPUT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KERNEL_TYPE_INPUT_DEVICE))
#define KERNEL_INPUT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KERNEL_TYPE_INPUT_DEVICE, KernelInputDeviceClass))

typedef struct _KernelInputDevice KernelInputDevice;
typedef struct _KernelInputDeviceClass KernelInputDeviceClass;
typedef struct _KernelInputDevicePrivate KernelInputDevicePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _KernelInputDeviceGetNameData KernelInputDeviceGetNameData;
typedef struct _KernelInputDeviceGetIdData KernelInputDeviceGetIdData;
typedef struct _KernelInputDeviceGetPhysData KernelInputDeviceGetPhysData;
typedef struct _KernelInputDeviceGetCapabilitiesData KernelInputDeviceGetCapabilitiesData;

#define KERNEL_TYPE_EVENT_STATUS (kernel_event_status_get_type ())
#define KERNEL_EVENT_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KERNEL_TYPE_EVENT_STATUS, KernelEventStatus))
#define KERNEL_EVENT_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KERNEL_TYPE_EVENT_STATUS, KernelEventStatusClass))
#define KERNEL_IS_EVENT_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KERNEL_TYPE_EVENT_STATUS))
#define KERNEL_IS_EVENT_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KERNEL_TYPE_EVENT_STATUS))
#define KERNEL_EVENT_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KERNEL_TYPE_EVENT_STATUS, KernelEventStatusClass))

typedef struct _KernelEventStatus KernelEventStatus;
typedef struct _KernelEventStatusClass KernelEventStatusClass;
typedef struct _KernelEventStatusPrivate KernelEventStatusPrivate;

#define KERNEL_TYPE_AGGREGATE_INPUT_DEVICE (kernel_aggregate_input_device_get_type ())
#define KERNEL_AGGREGATE_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KERNEL_TYPE_AGGREGATE_INPUT_DEVICE, KernelAggregateInputDevice))
#define KERNEL_AGGREGATE_INPUT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KERNEL_TYPE_AGGREGATE_INPUT_DEVICE, KernelAggregateInputDeviceClass))
#define KERNEL_IS_AGGREGATE_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KERNEL_TYPE_AGGREGATE_INPUT_DEVICE))
#define KERNEL_IS_AGGREGATE_INPUT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KERNEL_TYPE_AGGREGATE_INPUT_DEVICE))
#define KERNEL_AGGREGATE_INPUT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KERNEL_TYPE_AGGREGATE_INPUT_DEVICE, KernelAggregateInputDeviceClass))

typedef struct _KernelAggregateInputDevice KernelAggregateInputDevice;
typedef struct _KernelAggregateInputDeviceClass KernelAggregateInputDeviceClass;
typedef struct _KernelParamSpecEventStatus KernelParamSpecEventStatus;
typedef struct _KernelAggregateInputDevicePrivate KernelAggregateInputDevicePrivate;
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _kernel_event_status_unref0(var) ((var == NULL) ? NULL : (var = (kernel_event_status_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _KernelAggregateInputDeviceGetNameData KernelAggregateInputDeviceGetNameData;
typedef struct _KernelAggregateInputDeviceGetIdData KernelAggregateInputDeviceGetIdData;
typedef struct _KernelAggregateInputDeviceGetPhysData KernelAggregateInputDeviceGetPhysData;
typedef struct _KernelAggregateInputDeviceGetCapabilitiesData KernelAggregateInputDeviceGetCapabilitiesData;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

struct _KernelInputDevice {
	FsoFrameworkAbstractObject parent_instance;
	KernelInputDevicePrivate * priv;
	gchar* name;
	gchar* product;
	gchar* phys;
	gchar* caps;
	gint fd;
	guint8* keystate;
	gint keystate_length1;
	gint _keystate_size_;
};

struct _KernelInputDeviceClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _KernelInputDevicePrivate {
	FsoFrameworkSubsystem* subsystem;
	gchar* sysfsnode;
};

struct _KernelInputDeviceGetNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelInputDevice* self;
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
};

struct _KernelInputDeviceGetIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelInputDevice* self;
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
};

struct _KernelInputDeviceGetPhysData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelInputDevice* self;
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
};

struct _KernelInputDeviceGetCapabilitiesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelInputDevice* self;
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
};

struct _KernelEventStatus {
	GTypeInstance parent_instance;
	volatile int ref_count;
	KernelEventStatusPrivate * priv;
};

struct _KernelEventStatusClass {
	GTypeClass parent_class;
	void (*finalize) (KernelEventStatus *self);
};

struct _KernelEventStatusPrivate {
	gboolean pressed;
	gboolean reportheld;
	GTimeVal timestamp;
	guint timeout;
	gchar* name;
};

struct _KernelParamSpecEventStatus {
	GParamSpec parent_instance;
};

struct _KernelAggregateInputDevice {
	FsoFrameworkAbstractObject parent_instance;
	KernelAggregateInputDevicePrivate * priv;
};

struct _KernelAggregateInputDeviceClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _KernelAggregateInputDevicePrivate {
	FsoFrameworkSubsystem* subsystem;
	gchar* sysfsnode;
	GIOChannel** channels;
	gint channels_length1;
	gint _channels_size_;
	GeeHashMap* keys;
	GeeHashMap* switches;
	GeeHashMap* relatives;
};

struct _KernelAggregateInputDeviceGetNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelAggregateInputDevice* self;
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
};

struct _KernelAggregateInputDeviceGetIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelAggregateInputDevice* self;
	gchar* result;
	gchar* _tmp0_;
};

struct _KernelAggregateInputDeviceGetPhysData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelAggregateInputDevice* self;
	gchar* result;
	gchar* _tmp0_;
};

struct _KernelAggregateInputDeviceGetCapabilitiesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelAggregateInputDevice* self;
	gchar* result;
	gchar* _tmp0_;
};


extern gchar* kernel_buffer;
extern gint kernel_buffer_length1;
gchar* kernel_buffer = NULL;
gint kernel_buffer_length1 = 0;
static gint _kernel_buffer_size_ = 0;
static gpointer kernel_input_device_parent_class = NULL;
static guint kernel_input_device_typelength;
static guint kernel_input_device_typelength = 0U;
extern gchar** ignoreById;
extern gint ignoreById_length1;
extern gchar** ignoreByPhys;
extern gint ignoreByPhys_length1;
static FreeSmartphoneDeviceInputIface* kernel_input_device_free_smartphone_device_input_parent_iface = NULL;
static GType kernel_input_device_type_id = 0;
static gpointer kernel_event_status_parent_class = NULL;
extern KernelAggregateInputDevice* aggregate;
static GType kernel_event_status_type_id = 0;
static gpointer kernel_aggregate_input_device_parent_class = NULL;
extern GList* instances;
extern gchar* dev_input;
static FreeSmartphoneDeviceInputIface* kernel_aggregate_input_device_free_smartphone_device_input_parent_iface = NULL;
static GType kernel_aggregate_input_device_type_id = 0;
extern gchar* dev_root;
gchar* dev_root = NULL;
gchar* dev_input = NULL;
GList* instances = NULL;
KernelAggregateInputDevice* aggregate = NULL;
gchar** ignoreById = NULL;
gint ignoreById_length1 = 0;
static gint _ignoreById_size_ = 0;
gchar** ignoreByPhys = NULL;
gint ignoreByPhys_length1 = 0;
static gint _ignoreByPhys_size_ = 0;

#define KERNEL_BUFFER_SIZE ((guint) 512)
#define KERNEL_KERNEL_INPUT_PLUGIN_NAME "fsodevice.kernel_input"
#define KERNEL_KEY_RELEASE 0
#define KERNEL_KEY_PRESS 1
#define KERNEL_KEY_REPEAT 2
GType kernel_input_device_get_type (void) G_GNUC_CONST;
GType kernel_input_device_register_type (GTypeModule * module);
#define KERNEL_INPUT_DEVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KERNEL_TYPE_INPUT_DEVICE, KernelInputDevicePrivate))
enum  {
	KERNEL_INPUT_DEVICE_DUMMY_PROPERTY
};
KernelInputDevice* kernel_input_device_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
KernelInputDevice* kernel_input_device_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
static gboolean _kernel_input_device_inquireAndCheckForIgnore (KernelInputDevice* self);
static gchar* kernel_input_device_real_repr (FsoFrameworkAbstractObject* base);
static gchar* _kernel_input_device_cleanBuffer (KernelInputDevice* self, gint length);
gboolean kernel_input_device_onIdle (KernelInputDevice* self);
static void kernel_input_device_get_name_data_free (gpointer _data);
void kernel_input_device_get_name (KernelInputDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* kernel_input_device_get_name_finish (KernelInputDevice* self, GAsyncResult* _res_, GError** error);
static gboolean kernel_input_device_get_name_co (KernelInputDeviceGetNameData* _data_);
static void kernel_input_device_real_get_id_data_free (gpointer _data);
static void kernel_input_device_real_get_id (FreeSmartphoneDeviceInput* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_input_device_real_get_id_co (KernelInputDeviceGetIdData* _data_);
static void kernel_input_device_get_phys_data_free (gpointer _data);
void kernel_input_device_get_phys (KernelInputDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* kernel_input_device_get_phys_finish (KernelInputDevice* self, GAsyncResult* _res_, GError** error);
static gboolean kernel_input_device_get_phys_co (KernelInputDeviceGetPhysData* _data_);
static void kernel_input_device_real_get_capabilities_data_free (gpointer _data);
static void kernel_input_device_real_get_capabilities (FreeSmartphoneDeviceInput* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_input_device_real_get_capabilities_co (KernelInputDeviceGetCapabilitiesData* _data_);
static GObject * kernel_input_device_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void kernel_input_device_finalize (GObject* obj);
gpointer kernel_event_status_ref (gpointer instance);
void kernel_event_status_unref (gpointer instance);
GParamSpec* kernel_param_spec_event_status (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void kernel_value_set_event_status (GValue* value, gpointer v_object);
void kernel_value_take_event_status (GValue* value, gpointer v_object);
gpointer kernel_value_get_event_status (const GValue* value);
GType kernel_event_status_get_type (void) G_GNUC_CONST;
GType kernel_event_status_register_type (GTypeModule * module);
#define KERNEL_EVENT_STATUS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KERNEL_TYPE_EVENT_STATUS, KernelEventStatusPrivate))
enum  {
	KERNEL_EVENT_STATUS_DUMMY_PROPERTY
};
static guint kernel_event_status_age (KernelEventStatus* self);
static gboolean kernel_event_status_onTimeout (KernelEventStatus* self);
GType kernel_aggregate_input_device_get_type (void) G_GNUC_CONST;
GType kernel_aggregate_input_device_register_type (GTypeModule * module);
KernelEventStatus* kernel_event_status_new (const gchar* name, gboolean reportheld);
KernelEventStatus* kernel_event_status_construct (GType object_type, const gchar* name, gboolean reportheld);
void kernel_event_status_handleRelative (KernelEventStatus* self, struct input_event* ev);
void kernel_event_status_handle (KernelEventStatus* self, struct input_event* ev);
static gboolean _kernel_event_status_onTimeout_gsource_func (gpointer self);
static void kernel_event_status_finalize (KernelEventStatus* obj);
#define KERNEL_AGGREGATE_INPUT_DEVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KERNEL_TYPE_AGGREGATE_INPUT_DEVICE, KernelAggregateInputDevicePrivate))
enum  {
	KERNEL_AGGREGATE_INPUT_DEVICE_DUMMY_PROPERTY
};
KernelAggregateInputDevice* kernel_aggregate_input_device_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
KernelAggregateInputDevice* kernel_aggregate_input_device_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
static void _kernel_aggregate_input_device_registerInputWatches (KernelAggregateInputDevice* self);
static void _kernel_aggregate_input_device_hookToExternalModules (KernelAggregateInputDevice* self);
static void _kernel_aggregate_input_device_parseConfig (KernelAggregateInputDevice* self);
static gboolean kernel_aggregate_input_device_onIdle (KernelAggregateInputDevice* self);
static gboolean _kernel_aggregate_input_device_onIdle_gsource_func (gpointer self);
gboolean kernel_aggregate_input_device_onInputEvent (KernelAggregateInputDevice* self, GIOChannel* source, GIOCondition condition);
static gboolean _kernel_aggregate_input_device_onInputEvent_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void _vala_array_add1 (GIOChannel*** array, int* length, int* size, GIOChannel* value);
static void _kernel_aggregate_input_device_handleInputEvent (KernelAggregateInputDevice* self, struct input_event* ev);
static void __kernel_aggregate_input_device_handleInputEvent_fso_device_signalling_input_device_received_event (FsoDeviceSignallingInputDevice* _sender, struct input_event* ev, gpointer self);
static gboolean _kernel_aggregate_input_device_testbit (KernelAggregateInputDevice* self, guint bit, guint8* field, int field_length1);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static gchar* kernel_aggregate_input_device_real_repr (FsoFrameworkAbstractObject* base);
static void kernel_aggregate_input_device_get_name_data_free (gpointer _data);
void kernel_aggregate_input_device_get_name (KernelAggregateInputDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* kernel_aggregate_input_device_get_name_finish (KernelAggregateInputDevice* self, GAsyncResult* _res_, GError** error);
static gboolean kernel_aggregate_input_device_get_name_co (KernelAggregateInputDeviceGetNameData* _data_);
static void kernel_aggregate_input_device_real_get_id_data_free (gpointer _data);
static void kernel_aggregate_input_device_real_get_id (FreeSmartphoneDeviceInput* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_aggregate_input_device_real_get_id_co (KernelAggregateInputDeviceGetIdData* _data_);
static void kernel_aggregate_input_device_get_phys_data_free (gpointer _data);
void kernel_aggregate_input_device_get_phys (KernelAggregateInputDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* kernel_aggregate_input_device_get_phys_finish (KernelAggregateInputDevice* self, GAsyncResult* _res_, GError** error);
static gboolean kernel_aggregate_input_device_get_phys_co (KernelAggregateInputDeviceGetPhysData* _data_);
static void kernel_aggregate_input_device_real_get_capabilities_data_free (gpointer _data);
static void kernel_aggregate_input_device_real_get_capabilities (FreeSmartphoneDeviceInput* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_aggregate_input_device_real_get_capabilities_co (KernelAggregateInputDeviceGetCapabilitiesData* _data_);
static void kernel_aggregate_input_device_finalize (GObject* obj);
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error);
void fso_register_function (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


KernelInputDevice* kernel_input_device_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	KernelInputDevice * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	FsoFrameworkSubsystem* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (sysfsnode != NULL, NULL);
	self = (KernelInputDevice*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = subsystem;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->subsystem);
	self->priv->subsystem = _tmp1_;
	_tmp2_ = sysfsnode;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->sysfsnode);
	self->priv->sysfsnode = _tmp3_;
	_tmp4_ = sysfsnode;
	_tmp5_ = g_path_get_basename (_tmp4_);
	_g_free0 (self->name);
	self->name = _tmp5_;
	_tmp6_ = _kernel_input_device_inquireAndCheckForIgnore (self);
	if (!_tmp6_) {
		FsoFrameworkSubsystem* _tmp7_;
		FsoFrameworkLogger* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		_tmp7_ = subsystem;
		fso_framework_subsystem_registerObjectForServiceWithPrefix (_tmp7_, FREE_SMARTPHONE_DEVICE_TYPE_INPUT, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_DEVICE_ServiceDBusName, FSO_FRAMEWORK_DEVICE_InputServicePath, (FreeSmartphoneDeviceInput*) self);
		_tmp8_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp9_ = self->product;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = self->phys;
		_tmp12_ = string_to_string (_tmp11_);
		_tmp13_ = self->caps;
		_tmp14_ = string_to_string (_tmp13_);
		_tmp15_ = g_strconcat ("Created new InputDevice object: ", _tmp10_, " @ ", _tmp12_, " w/ ", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		fso_framework_logger_info (_tmp8_, _tmp16_);
		_g_free0 (_tmp16_);
	}
	return self;
}


KernelInputDevice* kernel_input_device_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	return kernel_input_device_construct (KERNEL_TYPE_INPUT_DEVICE, subsystem, sysfsnode);
}


static gchar* kernel_input_device_real_repr (FsoFrameworkAbstractObject* base) {
	KernelInputDevice * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (KernelInputDevice*) base;
	_tmp0_ = self->priv->sysfsnode;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("<", _tmp1_, ">", NULL);
	result = _tmp2_;
	return result;
}


static gchar* _kernel_input_device_cleanBuffer (KernelInputDevice* self, gint length) {
	gchar* result = NULL;
	gchar* _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				gchar* _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				gchar _tmp7_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = length;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				_tmp5_ = kernel_buffer;
				_tmp5__length1 = kernel_buffer_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				if (((gint) _tmp7_) < 0) {
					gchar* _tmp8_;
					gint _tmp8__length1;
					gint _tmp9_;
					gchar _tmp10_;
					_tmp8_ = kernel_buffer;
					_tmp8__length1 = kernel_buffer_length1;
					_tmp9_ = i;
					_tmp8_[_tmp9_] = '?';
					_tmp10_ = _tmp8_[_tmp9_];
				}
			}
		}
	}
	_tmp11_ = kernel_buffer;
	_tmp11__length1 = kernel_buffer_length1;
	_tmp12_ = g_strdup ((const gchar*) _tmp11_);
	result = _tmp12_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean _kernel_input_device_inquireAndCheckForIgnore (KernelInputDevice* self) {
	gboolean result = FALSE;
	gboolean ignore;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	gboolean _tmp94_ = FALSE;
	gboolean _tmp95_;
	gboolean _tmp97_;
	g_return_val_if_fail (self != NULL, FALSE);
	ignore = FALSE;
	_tmp0_ = self->priv->sysfsnode;
	_tmp1_ = open (_tmp0_, O_RDONLY, (mode_t) 0);
	self->fd = _tmp1_;
	_tmp2_ = self->fd;
	if (_tmp2_ == (-1)) {
		FsoFrameworkLogger* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp3_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp4_ = self->priv->sysfsnode;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = errno;
		_tmp7_ = g_strerror (_tmp6_);
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = g_strconcat ("Can't open ", _tmp5_, " ", _tmp8_, ". Input device will not available.", NULL);
		_tmp10_ = _tmp9_;
		fso_framework_logger_warning (_tmp3_, _tmp10_);
		_g_free0 (_tmp10_);
		ignore = TRUE;
	} else {
		gint _tmp11_;
		gint _tmp12_ = 0;
		gchar* _tmp13_;
		gint _tmp13__length1;
		gint _tmp14_ = 0;
		gint length;
		gint _tmp15_;
		gint _tmp23_;
		gint _tmp24_ = 0;
		gchar* _tmp25_;
		gint _tmp25__length1;
		gint _tmp26_ = 0;
		gint _tmp27_;
		gushort b;
		gint _tmp35_;
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
		const gchar* _tmp81_;
		gchar* _tmp82_ = NULL;
		gint _tmp83_;
		guint _tmp84_;
		gint _tmp85_ = 0;
		guint8* _tmp86_;
		gint _tmp86__length1;
		gint _tmp87_ = 0;
		_tmp11_ = self->fd;
		_tmp12_ = EVIOCGNAME (KERNEL_BUFFER_SIZE);
		_tmp13_ = kernel_buffer;
		_tmp13__length1 = kernel_buffer_length1;
		_tmp14_ = ioctl (_tmp11_, _tmp12_, _tmp13_);
		length = _tmp14_;
		_tmp15_ = length;
		if (_tmp15_ > 0) {
			gint _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar** _tmp18_;
			gint _tmp18__length1;
			_tmp16_ = length;
			_tmp17_ = _kernel_input_device_cleanBuffer (self, _tmp16_);
			_g_free0 (self->product);
			self->product = _tmp17_;
			_tmp18_ = ignoreById;
			_tmp18__length1 = ignoreById_length1;
			{
				gchar** i_collection = NULL;
				gint i_collection_length1 = 0;
				gint _i_collection_size_ = 0;
				gint i_it = 0;
				i_collection = _tmp18_;
				i_collection_length1 = _tmp18__length1;
				for (i_it = 0; i_it < _tmp18__length1; i_it = i_it + 1) {
					gchar* _tmp19_;
					gchar* i = NULL;
					_tmp19_ = g_strdup (i_collection[i_it]);
					i = _tmp19_;
					{
						const gchar* _tmp20_;
						const gchar* _tmp21_;
						gboolean _tmp22_ = FALSE;
						_tmp20_ = self->product;
						_tmp21_ = i;
						_tmp22_ = string_contains (_tmp20_, _tmp21_);
						if (_tmp22_) {
							ignore = TRUE;
						}
						_g_free0 (i);
					}
				}
			}
		}
		_tmp23_ = self->fd;
		_tmp24_ = EVIOCGPHYS (KERNEL_BUFFER_SIZE);
		_tmp25_ = kernel_buffer;
		_tmp25__length1 = kernel_buffer_length1;
		_tmp26_ = ioctl (_tmp23_, _tmp24_, _tmp25_);
		length = _tmp26_;
		_tmp27_ = length;
		if (_tmp27_ > 0) {
			gint _tmp28_;
			gchar* _tmp29_ = NULL;
			gchar** _tmp30_;
			gint _tmp30__length1;
			_tmp28_ = length;
			_tmp29_ = _kernel_input_device_cleanBuffer (self, _tmp28_);
			_g_free0 (self->phys);
			self->phys = _tmp29_;
			_tmp30_ = ignoreByPhys;
			_tmp30__length1 = ignoreByPhys_length1;
			{
				gchar** p_collection = NULL;
				gint p_collection_length1 = 0;
				gint _p_collection_size_ = 0;
				gint p_it = 0;
				p_collection = _tmp30_;
				p_collection_length1 = _tmp30__length1;
				for (p_it = 0; p_it < _tmp30__length1; p_it = p_it + 1) {
					gchar* _tmp31_;
					gchar* p = NULL;
					_tmp31_ = g_strdup (p_collection[p_it]);
					p = _tmp31_;
					{
						const gchar* _tmp32_;
						const gchar* _tmp33_;
						gboolean _tmp34_ = FALSE;
						_tmp32_ = self->phys;
						_tmp33_ = p;
						_tmp34_ = string_contains (_tmp32_, _tmp33_);
						if (_tmp34_) {
							ignore = TRUE;
						}
						_g_free0 (p);
					}
				}
			}
		}
		b = (gushort) 0;
		_tmp35_ = self->fd;
		_tmp36_ = EVIOCGBIT ((guint) 0, (guint) EV_MAX);
		_tmp37_ = ioctl (_tmp35_, _tmp36_, &b);
		if (_tmp37_ < 0) {
			FsoFrameworkLogger* _tmp38_;
			gint _tmp39_;
			const gchar* _tmp40_ = NULL;
			const gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_;
			_tmp38_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp39_ = errno;
			_tmp40_ = g_strerror (_tmp39_);
			_tmp41_ = string_to_string (_tmp40_);
			_tmp42_ = g_strconcat ("Can't inquire input device capabilities: ", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			fso_framework_logger_error (_tmp38_, _tmp43_);
			_g_free0 (_tmp43_);
		} else {
			gchar* _tmp44_;
			gushort _tmp45_;
			gushort _tmp48_;
			gushort _tmp51_;
			gushort _tmp54_;
			gushort _tmp57_;
			gushort _tmp60_;
			gushort _tmp63_;
			gushort _tmp66_;
			gushort _tmp69_;
			gushort _tmp72_;
			gushort _tmp75_;
			gushort _tmp78_;
			_tmp44_ = g_strdup ("");
			_g_free0 (self->caps);
			self->caps = _tmp44_;
			_tmp45_ = b;
			if (((gint) (_tmp45_ & (1 << EV_SYN))) > 0) {
				const gchar* _tmp46_;
				gchar* _tmp47_;
				_tmp46_ = self->caps;
				_tmp47_ = g_strconcat (_tmp46_, " SYN", NULL);
				_g_free0 (self->caps);
				self->caps = _tmp47_;
			}
			_tmp48_ = b;
			if (((gint) (_tmp48_ & (1 << EV_KEY))) > 0) {
				const gchar* _tmp49_;
				gchar* _tmp50_;
				_tmp49_ = self->caps;
				_tmp50_ = g_strconcat (_tmp49_, " KEY", NULL);
				_g_free0 (self->caps);
				self->caps = _tmp50_;
			}
			_tmp51_ = b;
			if (((gint) (_tmp51_ & (1 << EV_REL))) > 0) {
				const gchar* _tmp52_;
				gchar* _tmp53_;
				_tmp52_ = self->caps;
				_tmp53_ = g_strconcat (_tmp52_, " REL", NULL);
				_g_free0 (self->caps);
				self->caps = _tmp53_;
			}
			_tmp54_ = b;
			if (((gint) (_tmp54_ & (1 << EV_ABS))) > 0) {
				const gchar* _tmp55_;
				gchar* _tmp56_;
				_tmp55_ = self->caps;
				_tmp56_ = g_strconcat (_tmp55_, " ABS", NULL);
				_g_free0 (self->caps);
				self->caps = _tmp56_;
			}
			_tmp57_ = b;
			if (((gint) (_tmp57_ & (1 << EV_MSC))) > 0) {
				const gchar* _tmp58_;
				gchar* _tmp59_;
				_tmp58_ = self->caps;
				_tmp59_ = g_strconcat (_tmp58_, " MSC", NULL);
				_g_free0 (self->caps);
				self->caps = _tmp59_;
			}
			_tmp60_ = b;
			if (((gint) (_tmp60_ & (1 << EV_SW))) > 0) {
				const gchar* _tmp61_;
				gchar* _tmp62_;
				_tmp61_ = self->caps;
				_tmp62_ = g_strconcat (_tmp61_, " SW", NULL);
				_g_free0 (self->caps);
				self->caps = _tmp62_;
			}
			_tmp63_ = b;
			if (((gint) (_tmp63_ & (1 << EV_LED))) > 0) {
				const gchar* _tmp64_;
				gchar* _tmp65_;
				_tmp64_ = self->caps;
				_tmp65_ = g_strconcat (_tmp64_, " LED", NULL);
				_g_free0 (self->caps);
				self->caps = _tmp65_;
			}
			_tmp66_ = b;
			if (((gint) (_tmp66_ & (1 << EV_SND))) > 0) {
				const gchar* _tmp67_;
				gchar* _tmp68_;
				_tmp67_ = self->caps;
				_tmp68_ = g_strconcat (_tmp67_, " SND", NULL);
				_g_free0 (self->caps);
				self->caps = _tmp68_;
			}
			_tmp69_ = b;
			if (((gint) (_tmp69_ & (1 << EV_REP))) > 0) {
				const gchar* _tmp70_;
				gchar* _tmp71_;
				_tmp70_ = self->caps;
				_tmp71_ = g_strconcat (_tmp70_, " REP", NULL);
				_g_free0 (self->caps);
				self->caps = _tmp71_;
			}
			_tmp72_ = b;
			if (((gint) (_tmp72_ & (1 << EV_FF))) > 0) {
				const gchar* _tmp73_;
				gchar* _tmp74_;
				_tmp73_ = self->caps;
				_tmp74_ = g_strconcat (_tmp73_, " FF", NULL);
				_g_free0 (self->caps);
				self->caps = _tmp74_;
			}
			_tmp75_ = b;
			if (((gint) (_tmp75_ & (1 << EV_PWR))) > 0) {
				const gchar* _tmp76_;
				gchar* _tmp77_;
				_tmp76_ = self->caps;
				_tmp77_ = g_strconcat (_tmp76_, " PWR", NULL);
				_g_free0 (self->caps);
				self->caps = _tmp77_;
			}
			_tmp78_ = b;
			if (((gint) (_tmp78_ & (1 << EV_FF_STATUS))) > 0) {
				const gchar* _tmp79_;
				gchar* _tmp80_;
				_tmp79_ = self->caps;
				_tmp80_ = g_strconcat (_tmp79_, " FF_STATUS", NULL);
				_g_free0 (self->caps);
				self->caps = _tmp80_;
			}
		}
		_tmp81_ = self->caps;
		_tmp82_ = string_strip (_tmp81_);
		_g_free0 (self->caps);
		self->caps = _tmp82_;
		_tmp83_ = self->fd;
		_tmp84_ = kernel_input_device_typelength;
		_tmp85_ = EVIOCGKEY (_tmp84_);
		_tmp86_ = self->keystate;
		_tmp86__length1 = self->keystate_length1;
		_tmp87_ = ioctl (_tmp83_, _tmp85_, _tmp86_);
		if (_tmp87_ < 0) {
			FsoFrameworkLogger* _tmp88_;
			gint _tmp89_;
			const gchar* _tmp90_ = NULL;
			const gchar* _tmp91_ = NULL;
			gchar* _tmp92_ = NULL;
			gchar* _tmp93_;
			_tmp88_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp89_ = errno;
			_tmp90_ = g_strerror (_tmp89_);
			_tmp91_ = string_to_string (_tmp90_);
			_tmp92_ = g_strconcat ("Can't inquire input device key status: ", _tmp91_, NULL);
			_tmp93_ = _tmp92_;
			fso_framework_logger_error (_tmp88_, _tmp93_);
			_g_free0 (_tmp93_);
		}
	}
	_tmp95_ = ignore;
	if (_tmp95_) {
		gint _tmp96_;
		_tmp96_ = self->fd;
		_tmp94_ = _tmp96_ != (-1);
	} else {
		_tmp94_ = FALSE;
	}
	_tmp97_ = _tmp94_;
	if (_tmp97_) {
		gint _tmp98_;
		_tmp98_ = self->fd;
		close (_tmp98_);
		self->fd = -1;
	}
	result = ignore;
	return result;
}


gboolean kernel_input_device_onIdle (KernelInputDevice* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->sysfsnode;
	_tmp1_ = g_strdup_printf ("%s/uevent", _tmp0_);
	_tmp2_ = _tmp1_;
	fso_framework_file_handling_write ("change", _tmp2_, FALSE);
	_g_free0 (_tmp2_);
	result = FALSE;
	return result;
}


static void kernel_input_device_get_name_data_free (gpointer _data) {
	KernelInputDeviceGetNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (KernelInputDeviceGetNameData, _data_);
}


void kernel_input_device_get_name (KernelInputDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelInputDeviceGetNameData* _data_;
	KernelInputDevice* _tmp0_;
	_data_ = g_slice_new0 (KernelInputDeviceGetNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_input_device_get_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_input_device_get_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_input_device_get_name_co (_data_);
}


gchar* kernel_input_device_get_name_finish (KernelInputDevice* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	KernelInputDeviceGetNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean kernel_input_device_get_name_co (KernelInputDeviceGetNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->name;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->result = _data_->_tmp1_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_input_device_real_get_id_data_free (gpointer _data) {
	KernelInputDeviceGetIdData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (KernelInputDeviceGetIdData, _data_);
}


static void kernel_input_device_real_get_id (FreeSmartphoneDeviceInput* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelInputDevice * self;
	KernelInputDeviceGetIdData* _data_;
	KernelInputDevice* _tmp0_;
	self = (KernelInputDevice*) base;
	_data_ = g_slice_new0 (KernelInputDeviceGetIdData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_input_device_real_get_id);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_input_device_real_get_id_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_input_device_real_get_id_co (_data_);
}


static gchar* kernel_input_device_real_get_id_finish (FreeSmartphoneDeviceInput* base, GAsyncResult* _res_, GError** error) {
	gchar* result;
	KernelInputDeviceGetIdData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean kernel_input_device_real_get_id_co (KernelInputDeviceGetIdData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->product;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->result = _data_->_tmp1_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_input_device_get_phys_data_free (gpointer _data) {
	KernelInputDeviceGetPhysData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (KernelInputDeviceGetPhysData, _data_);
}


void kernel_input_device_get_phys (KernelInputDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelInputDeviceGetPhysData* _data_;
	KernelInputDevice* _tmp0_;
	_data_ = g_slice_new0 (KernelInputDeviceGetPhysData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_input_device_get_phys);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_input_device_get_phys_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_input_device_get_phys_co (_data_);
}


gchar* kernel_input_device_get_phys_finish (KernelInputDevice* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	KernelInputDeviceGetPhysData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean kernel_input_device_get_phys_co (KernelInputDeviceGetPhysData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->phys;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->result = _data_->_tmp1_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_input_device_real_get_capabilities_data_free (gpointer _data) {
	KernelInputDeviceGetCapabilitiesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (KernelInputDeviceGetCapabilitiesData, _data_);
}


static void kernel_input_device_real_get_capabilities (FreeSmartphoneDeviceInput* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelInputDevice * self;
	KernelInputDeviceGetCapabilitiesData* _data_;
	KernelInputDevice* _tmp0_;
	self = (KernelInputDevice*) base;
	_data_ = g_slice_new0 (KernelInputDeviceGetCapabilitiesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_input_device_real_get_capabilities);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_input_device_real_get_capabilities_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_input_device_real_get_capabilities_co (_data_);
}


static gchar* kernel_input_device_real_get_capabilities_finish (FreeSmartphoneDeviceInput* base, GAsyncResult* _res_, GError** error) {
	gchar* result;
	KernelInputDeviceGetCapabilitiesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean kernel_input_device_real_get_capabilities_co (KernelInputDeviceGetCapabilitiesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->caps;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->result = _data_->_tmp1_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static GObject * kernel_input_device_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	KernelInputDevice * self;
	guint _tmp0_;
	guint8* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (kernel_input_device_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = KERNEL_INPUT_DEVICE (obj);
	_tmp0_ = kernel_input_device_typelength;
	_tmp1_ = g_new0 (guint8, _tmp0_);
	self->keystate = (g_free (self->keystate), NULL);
	self->keystate = _tmp1_;
	self->keystate_length1 = _tmp0_;
	self->_keystate_size_ = self->keystate_length1;
	return obj;
}


static void kernel_input_device_class_init (KernelInputDeviceClass * klass) {
	gchar* _tmp0_ = NULL;
	kernel_input_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KernelInputDevicePrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = kernel_input_device_real_repr;
	G_OBJECT_CLASS (klass)->constructor = kernel_input_device_constructor;
	G_OBJECT_CLASS (klass)->finalize = kernel_input_device_finalize;
	_tmp0_ = g_new0 (gchar, KERNEL_BUFFER_SIZE);
	kernel_buffer = (g_free (kernel_buffer), NULL);
	kernel_buffer = _tmp0_;
	kernel_buffer_length1 = KERNEL_BUFFER_SIZE;
	_kernel_buffer_size_ = kernel_buffer_length1;
	kernel_input_device_typelength = (guint) ((KEY_MAX / 8) + 1);
}


static void kernel_input_device_free_smartphone_device_input_interface_init (FreeSmartphoneDeviceInputIface * iface) {
	kernel_input_device_free_smartphone_device_input_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_id = (gchar* (*)(FreeSmartphoneDeviceInput*, GError**)) kernel_input_device_real_get_id;
	iface->get_id_finish = kernel_input_device_real_get_id_finish;
	iface->get_capabilities = (gchar* (*)(FreeSmartphoneDeviceInput*, GError**)) kernel_input_device_real_get_capabilities;
	iface->get_capabilities_finish = kernel_input_device_real_get_capabilities_finish;
}


static void kernel_input_device_instance_init (KernelInputDevice * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self->priv = KERNEL_INPUT_DEVICE_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("<Unknown Product>");
	self->product = _tmp0_;
	_tmp1_ = g_strdup ("<Unknown Path>");
	self->phys = _tmp1_;
	_tmp2_ = g_strdup ("<Unknown Caps>");
	self->caps = _tmp2_;
	self->fd = -1;
}


static void kernel_input_device_finalize (GObject* obj) {
	KernelInputDevice * self;
	self = KERNEL_INPUT_DEVICE (obj);
	_g_object_unref0 (self->priv->subsystem);
	_g_free0 (self->priv->sysfsnode);
	_g_free0 (self->name);
	_g_free0 (self->product);
	_g_free0 (self->phys);
	_g_free0 (self->caps);
	self->keystate = (g_free (self->keystate), NULL);
	G_OBJECT_CLASS (kernel_input_device_parent_class)->finalize (obj);
}


/**
 * Implementation of org.freesmartphone.Device.Input for the Kernel Input Device
 **/
GType kernel_input_device_get_type (void) {
	return kernel_input_device_type_id;
}


GType kernel_input_device_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (KernelInputDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kernel_input_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KernelInputDevice), 0, (GInstanceInitFunc) kernel_input_device_instance_init, NULL };
	static const GInterfaceInfo free_smartphone_device_input_info = { (GInterfaceInitFunc) kernel_input_device_free_smartphone_device_input_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	kernel_input_device_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "KernelInputDevice", &g_define_type_info, 0);
	g_type_module_add_interface (module, kernel_input_device_type_id, FREE_SMARTPHONE_DEVICE_TYPE_INPUT, &free_smartphone_device_input_info);
	return kernel_input_device_type_id;
}


static guint kernel_event_status_age (KernelEventStatus* self) {
	guint result = 0U;
	GTimeVal now = {0};
	GTimeVal _tmp0_;
	glong _tmp1_;
	GTimeVal _tmp2_;
	glong _tmp3_;
	GTimeVal _tmp4_;
	glong _tmp5_;
	GTimeVal _tmp6_;
	glong _tmp7_;
	glong diff;
	g_return_val_if_fail (self != NULL, 0U);
	g_get_current_time (&now);
	_tmp0_ = now;
	_tmp1_ = _tmp0_.tv_sec;
	_tmp2_ = self->priv->timestamp;
	_tmp3_ = _tmp2_.tv_sec;
	_tmp4_ = now;
	_tmp5_ = _tmp4_.tv_usec;
	_tmp6_ = self->priv->timestamp;
	_tmp7_ = _tmp6_.tv_usec;
	diff = ((_tmp1_ - _tmp3_) * 1000000) + (_tmp5_ - _tmp7_);
	result = ((guint) diff) / 1000000;
	return result;
}


static gboolean kernel_event_status_onTimeout (KernelEventStatus* self) {
	gboolean result = FALSE;
	KernelAggregateInputDevice* _tmp0_;
	const gchar* _tmp1_;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = aggregate;
	_tmp1_ = self->priv->name;
	_tmp2_ = kernel_event_status_age (self);
	g_signal_emit_by_name ((FreeSmartphoneDeviceInput*) _tmp0_, "event", _tmp1_, FREE_SMARTPHONE_DEVICE_INPUT_STATE_HELD, (gint) _tmp2_);
	result = TRUE;
	return result;
}


KernelEventStatus* kernel_event_status_construct (GType object_type, const gchar* name, gboolean reportheld) {
	KernelEventStatus* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (KernelEventStatus*) g_type_create_instance (object_type);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp1_;
	_tmp2_ = reportheld;
	self->priv->reportheld = _tmp2_;
	self->priv->pressed = FALSE;
	self->priv->timeout = (guint) 0;
	return self;
}


KernelEventStatus* kernel_event_status_new (const gchar* name, gboolean reportheld) {
	return kernel_event_status_construct (KERNEL_TYPE_EVENT_STATUS, name, reportheld);
}


void kernel_event_status_handleRelative (KernelEventStatus* self, struct input_event* ev) {
	struct input_event _tmp0_;
	guint16 _tmp1_;
	guint16 axis;
	struct input_event _tmp2_;
	gint32 _tmp3_;
	gint32 offset;
	KernelAggregateInputDevice* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = *ev;
	_tmp1_ = _tmp0_.code;
	axis = _tmp1_;
	_tmp2_ = *ev;
	_tmp3_ = _tmp2_.value;
	offset = _tmp3_;
	_tmp4_ = aggregate;
	_tmp5_ = self->priv->name;
	g_signal_emit_by_name ((FreeSmartphoneDeviceInput*) _tmp4_, "directional-event", _tmp5_, (gint) axis, (gint) offset);
}


static gboolean _kernel_event_status_onTimeout_gsource_func (gpointer self) {
	gboolean result;
	result = kernel_event_status_onTimeout (self);
	return result;
}


void kernel_event_status_handle (KernelEventStatus* self, struct input_event* ev) {
	struct input_event _tmp0_;
	guint16 _tmp1_;
	struct input_event _tmp3_;
	gint32 _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = *ev;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ == EV_REL) {
		struct input_event _tmp2_;
		_tmp2_ = *ev;
		kernel_event_status_handleRelative (self, &_tmp2_);
		return;
	}
	_tmp3_ = *ev;
	_tmp4_ = _tmp3_.value;
	switch (_tmp4_) {
		case KERNEL_KEY_PRESS:
		{
			gboolean _tmp5_;
			KernelAggregateInputDevice* _tmp7_;
			const gchar* _tmp8_;
			g_get_current_time (&self->priv->timestamp);
			self->priv->pressed = TRUE;
			_tmp5_ = self->priv->reportheld;
			if (_tmp5_) {
				guint _tmp6_ = 0U;
				_tmp6_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1050, _kernel_event_status_onTimeout_gsource_func, kernel_event_status_ref (self), kernel_event_status_unref);
				self->priv->timeout = _tmp6_;
			}
			_tmp7_ = aggregate;
			_tmp8_ = self->priv->name;
			g_signal_emit_by_name ((FreeSmartphoneDeviceInput*) _tmp7_, "event", _tmp8_, FREE_SMARTPHONE_DEVICE_INPUT_STATE_PRESSED, 0);
			break;
		}
		case KERNEL_KEY_RELEASE:
		{
			gboolean _tmp9_;
			_tmp9_ = self->priv->pressed;
			if (!_tmp9_) {
				KernelAggregateInputDevice* _tmp10_;
				FsoFrameworkLogger* _tmp11_;
				KernelAggregateInputDevice* _tmp12_;
				const gchar* _tmp13_;
				_tmp10_ = aggregate;
				_tmp11_ = ((FsoFrameworkAbstractObject*) _tmp10_)->logger;
				fso_framework_logger_warning (_tmp11_, "Received release event before pressed event!?");
				_tmp12_ = aggregate;
				_tmp13_ = self->priv->name;
				g_signal_emit_by_name ((FreeSmartphoneDeviceInput*) _tmp12_, "event", _tmp13_, FREE_SMARTPHONE_DEVICE_INPUT_STATE_RELEASED, 0);
			} else {
				guint _tmp14_;
				KernelAggregateInputDevice* _tmp16_;
				const gchar* _tmp17_;
				guint _tmp18_ = 0U;
				self->priv->pressed = FALSE;
				_tmp14_ = self->priv->timeout;
				if (_tmp14_ > ((guint) 0)) {
					guint _tmp15_;
					_tmp15_ = self->priv->timeout;
					g_source_remove (_tmp15_);
				}
				_tmp16_ = aggregate;
				_tmp17_ = self->priv->name;
				_tmp18_ = kernel_event_status_age (self);
				g_signal_emit_by_name ((FreeSmartphoneDeviceInput*) _tmp16_, "event", _tmp17_, FREE_SMARTPHONE_DEVICE_INPUT_STATE_RELEASED, (gint) _tmp18_);
			}
			break;
		}
		case KERNEL_KEY_REPEAT:
		{
			break;
		}
		default:
		{
			break;
		}
	}
}


static void kernel_value_event_status_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void kernel_value_event_status_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		kernel_event_status_unref (value->data[0].v_pointer);
	}
}


static void kernel_value_event_status_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = kernel_event_status_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer kernel_value_event_status_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* kernel_value_event_status_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		KernelEventStatus* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = kernel_event_status_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* kernel_value_event_status_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	KernelEventStatus** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = kernel_event_status_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* kernel_param_spec_event_status (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	KernelParamSpecEventStatus* spec;
	g_return_val_if_fail (g_type_is_a (object_type, KERNEL_TYPE_EVENT_STATUS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer kernel_value_get_event_status (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, KERNEL_TYPE_EVENT_STATUS), NULL);
	return value->data[0].v_pointer;
}


void kernel_value_set_event_status (GValue* value, gpointer v_object) {
	KernelEventStatus* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, KERNEL_TYPE_EVENT_STATUS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, KERNEL_TYPE_EVENT_STATUS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		kernel_event_status_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		kernel_event_status_unref (old);
	}
}


void kernel_value_take_event_status (GValue* value, gpointer v_object) {
	KernelEventStatus* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, KERNEL_TYPE_EVENT_STATUS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, KERNEL_TYPE_EVENT_STATUS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		kernel_event_status_unref (old);
	}
}


static void kernel_event_status_class_init (KernelEventStatusClass * klass) {
	kernel_event_status_parent_class = g_type_class_peek_parent (klass);
	KERNEL_EVENT_STATUS_CLASS (klass)->finalize = kernel_event_status_finalize;
	g_type_class_add_private (klass, sizeof (KernelEventStatusPrivate));
}


static void kernel_event_status_instance_init (KernelEventStatus * self) {
	self->priv = KERNEL_EVENT_STATUS_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void kernel_event_status_finalize (KernelEventStatus* obj) {
	KernelEventStatus * self;
	self = KERNEL_EVENT_STATUS (obj);
	_g_free0 (self->priv->name);
}


/**
 * Helper class
 **/
GType kernel_event_status_get_type (void) {
	return kernel_event_status_type_id;
}


GType kernel_event_status_register_type (GTypeModule * module) {
	static const GTypeValueTable g_define_type_value_table = { kernel_value_event_status_init, kernel_value_event_status_free_value, kernel_value_event_status_copy_value, kernel_value_event_status_peek_pointer, "p", kernel_value_event_status_collect_value, "p", kernel_value_event_status_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (KernelEventStatusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kernel_event_status_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KernelEventStatus), 0, (GInstanceInitFunc) kernel_event_status_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	kernel_event_status_type_id = g_type_register_fundamental (g_type_fundamental_next (), "KernelEventStatus", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return kernel_event_status_type_id;
}


gpointer kernel_event_status_ref (gpointer instance) {
	KernelEventStatus* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void kernel_event_status_unref (gpointer instance) {
	KernelEventStatus* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		KERNEL_EVENT_STATUS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gboolean _kernel_aggregate_input_device_onIdle_gsource_func (gpointer self) {
	gboolean result;
	result = kernel_aggregate_input_device_onIdle (self);
	return result;
}


KernelAggregateInputDevice* kernel_aggregate_input_device_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	KernelAggregateInputDevice * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	FsoFrameworkSubsystem* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* _tmp6_;
	FsoFrameworkSubsystem* _tmp7_;
	FsoFrameworkLogger* _tmp8_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (sysfsnode != NULL, NULL);
	self = (KernelAggregateInputDevice*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = subsystem;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->subsystem);
	self->priv->subsystem = _tmp1_;
	_tmp2_ = sysfsnode;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->sysfsnode);
	self->priv->sysfsnode = _tmp3_;
	_kernel_aggregate_input_device_registerInputWatches (self);
	_kernel_aggregate_input_device_hookToExternalModules (self);
	_tmp4_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, KERNEL_TYPE_EVENT_STATUS, (GBoxedCopyFunc) kernel_event_status_ref, kernel_event_status_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->keys);
	self->priv->keys = _tmp4_;
	_tmp5_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, KERNEL_TYPE_EVENT_STATUS, (GBoxedCopyFunc) kernel_event_status_ref, kernel_event_status_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->switches);
	self->priv->switches = _tmp5_;
	_tmp6_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, KERNEL_TYPE_EVENT_STATUS, (GBoxedCopyFunc) kernel_event_status_ref, kernel_event_status_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->relatives);
	self->priv->relatives = _tmp6_;
	_kernel_aggregate_input_device_parseConfig (self);
	_tmp7_ = subsystem;
	fso_framework_subsystem_registerObjectForService (_tmp7_, FREE_SMARTPHONE_DEVICE_TYPE_INPUT, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_DEVICE_ServiceDBusName, FSO_FRAMEWORK_DEVICE_InputServicePath, (FreeSmartphoneDeviceInput*) self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _kernel_aggregate_input_device_onIdle_gsource_func, g_object_ref (self), g_object_unref);
	_tmp8_ = ((FsoFrameworkAbstractObject*) self)->logger;
	fso_framework_logger_info (_tmp8_, "Created");
	return self;
}


KernelAggregateInputDevice* kernel_aggregate_input_device_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	return kernel_aggregate_input_device_construct (KERNEL_TYPE_AGGREGATE_INPUT_DEVICE, subsystem, sysfsnode);
}


static gboolean _kernel_aggregate_input_device_onInputEvent_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = kernel_aggregate_input_device_onInputEvent (self, source, condition);
	return result;
}


static gpointer _g_io_channel_ref0 (gpointer self) {
	return self ? g_io_channel_ref (self) : NULL;
}


static void _vala_array_add1 (GIOChannel*** array, int* length, int* size, GIOChannel* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GIOChannel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _kernel_aggregate_input_device_registerInputWatches (KernelAggregateInputDevice* self) {
	GIOChannel** _tmp0_ = NULL;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (GIOChannel*, 0 + 1);
	self->priv->channels = (_vala_array_free (self->priv->channels, self->priv->channels_length1, (GDestroyNotify) g_io_channel_unref), NULL);
	self->priv->channels = _tmp0_;
	self->priv->channels_length1 = 0;
	self->priv->_channels_size_ = self->priv->channels_length1;
	_tmp1_ = instances;
	{
		GList* input_collection = NULL;
		GList* input_it = NULL;
		input_collection = _tmp1_;
		for (input_it = input_collection; input_it != NULL; input_it = input_it->next) {
			KernelInputDevice* _tmp2_;
			KernelInputDevice* input = NULL;
			_tmp2_ = _g_object_ref0 ((KernelInputDevice*) input_it->data);
			input = _tmp2_;
			{
				KernelInputDevice* _tmp3_;
				gint _tmp4_;
				_tmp3_ = input;
				_tmp4_ = _tmp3_->fd;
				if (_tmp4_ != (-1)) {
					KernelInputDevice* _tmp5_;
					gint _tmp6_;
					GIOChannel* _tmp7_;
					GIOChannel* channel;
					GIOChannel* _tmp8_;
					GIOChannel** _tmp9_;
					gint _tmp9__length1;
					GIOChannel* _tmp10_;
					GIOChannel* _tmp11_;
					_tmp5_ = input;
					_tmp6_ = _tmp5_->fd;
					_tmp7_ = g_io_channel_unix_new (_tmp6_);
					channel = _tmp7_;
					_tmp8_ = channel;
					g_io_add_watch (_tmp8_, G_IO_IN, _kernel_aggregate_input_device_onInputEvent_gio_func, self);
					_tmp9_ = self->priv->channels;
					_tmp9__length1 = self->priv->channels_length1;
					_tmp10_ = channel;
					_tmp11_ = _g_io_channel_ref0 (_tmp10_);
					_vala_array_add1 (&self->priv->channels, &self->priv->channels_length1, &self->priv->_channels_size_, _tmp11_);
					_g_io_channel_unref0 (channel);
				}
				_g_object_unref0 (input);
			}
		}
	}
}


static void __kernel_aggregate_input_device_handleInputEvent_fso_device_signalling_input_device_received_event (FsoDeviceSignallingInputDevice* _sender, struct input_event* ev, gpointer self) {
	_kernel_aggregate_input_device_handleInputEvent (self, ev);
}


static void _kernel_aggregate_input_device_hookToExternalModules (KernelAggregateInputDevice* self) {
	FsoFrameworkSubsystem* _tmp0_;
	gint _tmp1_ = 0;
	GObject** _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->subsystem;
	_tmp2_ = fso_framework_subsystem_allObjectsWithPrefix (_tmp0_, "/org/freesmartphone/Device/Input/", &_tmp1_);
	{
		GObject** object_collection = NULL;
		gint object_collection_length1 = 0;
		gint _object_collection_size_ = 0;
		gint object_it = 0;
		object_collection = _tmp2_;
		object_collection_length1 = _tmp1_;
		for (object_it = 0; object_it < _tmp1_; object_it = object_it + 1) {
			GObject* _tmp3_;
			GObject* object = NULL;
			_tmp3_ = _g_object_ref0 (object_collection[object_it]);
			object = _tmp3_;
			{
				GObject* _tmp4_;
				_tmp4_ = object;
				if (FSO_DEVICE_IS_SIGNALLING_INPUT_DEVICE (_tmp4_)) {
					FsoFrameworkLogger* _tmp5_;
					GObject* _tmp6_;
					_tmp5_ = ((FsoFrameworkAbstractObject*) self)->logger;
					fso_framework_logger_debug (_tmp5_, "Found an auxilliary input object, connecting to signal");
					_tmp6_ = object;
					g_signal_connect_object (FSO_DEVICE_SIGNALLING_INPUT_DEVICE (_tmp6_), "received-event", (GCallback) __kernel_aggregate_input_device_handleInputEvent_fso_device_signalling_input_device_received_event, self, 0);
				}
				_g_object_unref0 (object);
			}
		}
		object_collection = (_vala_array_free (object_collection, object_collection_length1, (GDestroyNotify) g_object_unref), NULL);
	}
}


static gboolean _kernel_aggregate_input_device_testbit (KernelAggregateInputDevice* self, guint bit, guint8* field, int field_length1) {
	gboolean result = FALSE;
	guint _tmp0_;
	guint boffset;
	guint _tmp1_;
	guint bmodulo;
	guint mask;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8 _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bit;
	boffset = _tmp0_ / 8;
	_tmp1_ = bit;
	bmodulo = _tmp1_ % 8;
	mask = 1 << bmodulo;
	_tmp2_ = field;
	_tmp2__length1 = field_length1;
	_tmp3_ = _tmp2_[boffset];
	result = ((guint) (_tmp3_ & mask)) == mask;
	return result;
}


static gboolean kernel_aggregate_input_device_onIdle (KernelAggregateInputDevice* self) {
	gboolean result = FALSE;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = instances;
	{
		GList* input_collection = NULL;
		GList* input_it = NULL;
		input_collection = _tmp0_;
		for (input_it = input_collection; input_it != NULL; input_it = input_it->next) {
			KernelInputDevice* _tmp1_;
			KernelInputDevice* input = NULL;
			_tmp1_ = _g_object_ref0 ((KernelInputDevice*) input_it->data);
			input = _tmp1_;
			{
				KernelInputDevice* _tmp2_;
				gint _tmp3_;
				_tmp2_ = input;
				_tmp3_ = _tmp2_->fd;
				if (_tmp3_ != 1) {
					{
						gint i;
						i = 0;
						{
							gboolean _tmp4_;
							_tmp4_ = TRUE;
							while (TRUE) {
								gboolean _tmp5_;
								gint _tmp7_;
								gint _tmp8_;
								KernelInputDevice* _tmp9_;
								guint8* _tmp10_;
								gint _tmp10__length1;
								gboolean _tmp11_ = FALSE;
								_tmp5_ = _tmp4_;
								if (!_tmp5_) {
									gint _tmp6_;
									_tmp6_ = i;
									i = _tmp6_ + 1;
								}
								_tmp4_ = FALSE;
								_tmp7_ = i;
								if (!(_tmp7_ < KEY_MAX)) {
									break;
								}
								_tmp8_ = i;
								_tmp9_ = input;
								_tmp10_ = _tmp9_->keystate;
								_tmp10__length1 = _tmp9_->keystate_length1;
								_tmp11_ = _kernel_aggregate_input_device_testbit (self, (guint) _tmp8_, _tmp10_, _tmp10__length1);
								if (_tmp11_) {
									FsoFrameworkLogger* _tmp12_;
									KernelInputDevice* _tmp13_;
									const gchar* _tmp14_;
									const gchar* _tmp15_ = NULL;
									gint _tmp16_;
									gchar* _tmp17_ = NULL;
									gchar* _tmp18_;
									gchar* _tmp19_ = NULL;
									gchar* _tmp20_;
									struct timeval _tmp21_ = {0};
									gint _tmp22_;
									struct input_event _tmp23_ = {0};
									struct input_event ev1;
									struct timeval _tmp24_ = {0};
									gint _tmp25_;
									struct input_event _tmp26_ = {0};
									struct input_event ev2;
									_tmp12_ = ((FsoFrameworkAbstractObject*) self)->logger;
									_tmp13_ = input;
									_tmp14_ = _tmp13_->name;
									_tmp15_ = string_to_string (_tmp14_);
									_tmp16_ = i;
									_tmp17_ = g_strdup_printf ("%i", _tmp16_);
									_tmp18_ = _tmp17_;
									_tmp19_ = g_strconcat ("Sending coldplug input notification for bit ", _tmp15_, ":", _tmp18_, NULL);
									_tmp20_ = _tmp19_;
									fso_framework_logger_info (_tmp12_, _tmp20_);
									_g_free0 (_tmp20_);
									_g_free0 (_tmp18_);
									memset (&_tmp21_, 0, sizeof (struct timeval));
									_tmp21_.tv_sec = (time_t) 0;
									_tmp21_.tv_usec = (glong) 0;
									_tmp22_ = i;
									memset (&_tmp23_, 0, sizeof (struct input_event));
									_tmp23_.time = _tmp21_;
									_tmp23_.type = (guint16) EV_KEY;
									_tmp23_.code = (guint16) _tmp22_;
									_tmp23_.value = (gint32) KERNEL_KEY_PRESS;
									ev1 = _tmp23_;
									_kernel_aggregate_input_device_handleInputEvent (self, &ev1);
									memset (&_tmp24_, 0, sizeof (struct timeval));
									_tmp24_.tv_sec = (time_t) 0;
									_tmp24_.tv_usec = (glong) 0;
									_tmp25_ = i;
									memset (&_tmp26_, 0, sizeof (struct input_event));
									_tmp26_.time = _tmp24_;
									_tmp26_.type = (guint16) EV_SW;
									_tmp26_.code = (guint16) _tmp25_;
									_tmp26_.value = (gint32) KERNEL_KEY_PRESS;
									ev2 = _tmp26_;
									_kernel_aggregate_input_device_handleInputEvent (self, &ev2);
								}
							}
						}
					}
				}
				_g_object_unref0 (input);
			}
		}
	}
	result = FALSE;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void _kernel_aggregate_input_device_parseConfig (KernelAggregateInputDevice* self) {
	FsoFrameworkSmartKeyFile* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* entries;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->config;
	_tmp1_ = fso_framework_smart_key_file_keysWithPrefix (_tmp0_, KERNEL_KERNEL_INPUT_PLUGIN_NAME, "report");
	entries = _tmp1_;
	_tmp2_ = entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp2_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			gchar* _tmp3_;
			gchar* entry = NULL;
			_tmp3_ = g_strdup ((const gchar*) entry_it->data);
			entry = _tmp3_;
			{
				FsoFrameworkSmartKeyFile* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_ = NULL;
				gchar* value;
				const gchar* _tmp7_;
				gchar** _tmp8_;
				gchar** _tmp9_ = NULL;
				gchar** values;
				gint values_length1;
				gint _values_size_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* name;
				gchar** _tmp19_;
				gint _tmp19__length1;
				const gchar* _tmp20_;
				gchar* _tmp21_ = NULL;
				gchar* type;
				gchar** _tmp22_;
				gint _tmp22__length1;
				const gchar* _tmp23_;
				gint _tmp24_ = 0;
				gint code;
				gchar** _tmp25_;
				gint _tmp25__length1;
				const gchar* _tmp26_;
				gboolean reportheld;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				GQuark _tmp30_ = 0U;
				static GQuark _tmp29_label0 = 0;
				static GQuark _tmp29_label1 = 0;
				static GQuark _tmp29_label2 = 0;
				_tmp4_ = ((FsoFrameworkAbstractObject*) self)->config;
				_tmp5_ = entry;
				_tmp6_ = fso_framework_smart_key_file_stringValue (_tmp4_, KERNEL_KERNEL_INPUT_PLUGIN_NAME, _tmp5_, "");
				value = _tmp6_;
				_tmp7_ = value;
				_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, ",", 0);
				values = _tmp9_;
				values_length1 = _vala_array_length (_tmp8_);
				_values_size_ = values_length1;
				_tmp10_ = values;
				_tmp10__length1 = values_length1;
				if (_tmp10__length1 != 4) {
					FsoFrameworkLogger* _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_;
					_tmp11_ = ((FsoFrameworkAbstractObject*) self)->logger;
					_tmp12_ = entry;
					_tmp13_ = string_to_string (_tmp12_);
					_tmp14_ = g_strconcat ("Config option ", _tmp13_, " has not 4 elements. Ignoring.", NULL);
					_tmp15_ = _tmp14_;
					fso_framework_logger_warning (_tmp11_, _tmp15_);
					_g_free0 (_tmp15_);
					values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (value);
					_g_free0 (entry);
					continue;
				}
				_tmp16_ = values;
				_tmp16__length1 = values_length1;
				_tmp17_ = _tmp16_[0];
				_tmp18_ = g_strdup (_tmp17_);
				name = _tmp18_;
				_tmp19_ = values;
				_tmp19__length1 = values_length1;
				_tmp20_ = _tmp19_[1];
				_tmp21_ = g_utf8_strdown (_tmp20_, (gssize) (-1));
				type = _tmp21_;
				_tmp22_ = values;
				_tmp22__length1 = values_length1;
				_tmp23_ = _tmp22_[2];
				_tmp24_ = atoi (_tmp23_);
				code = _tmp24_;
				_tmp25_ = values;
				_tmp25__length1 = values_length1;
				_tmp26_ = _tmp25_[3];
				reportheld = g_strcmp0 (_tmp26_, "1") == 0;
				_tmp27_ = type;
				_tmp28_ = _tmp27_;
				_tmp30_ = (NULL == _tmp28_) ? 0 : g_quark_from_string (_tmp28_);
				if (_tmp30_ == ((0 != _tmp29_label0) ? _tmp29_label0 : (_tmp29_label0 = g_quark_from_static_string ("key")))) {
					switch (0) {
						default:
						{
							GeeHashMap* _tmp31_;
							gint _tmp32_;
							const gchar* _tmp33_;
							gboolean _tmp34_;
							KernelEventStatus* _tmp35_;
							KernelEventStatus* _tmp36_;
							_tmp31_ = self->priv->keys;
							_tmp32_ = code;
							_tmp33_ = name;
							_tmp34_ = reportheld;
							_tmp35_ = kernel_event_status_new (_tmp33_, _tmp34_);
							_tmp36_ = _tmp35_;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, GINT_TO_POINTER (_tmp32_), _tmp36_);
							_kernel_event_status_unref0 (_tmp36_);
							break;
						}
					}
				} else if (_tmp30_ == ((0 != _tmp29_label1) ? _tmp29_label1 : (_tmp29_label1 = g_quark_from_static_string ("switch")))) {
					switch (0) {
						default:
						{
							GeeHashMap* _tmp37_;
							gint _tmp38_;
							const gchar* _tmp39_;
							gboolean _tmp40_;
							KernelEventStatus* _tmp41_;
							KernelEventStatus* _tmp42_;
							_tmp37_ = self->priv->switches;
							_tmp38_ = code;
							_tmp39_ = name;
							_tmp40_ = reportheld;
							_tmp41_ = kernel_event_status_new (_tmp39_, _tmp40_);
							_tmp42_ = _tmp41_;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp37_, GINT_TO_POINTER (_tmp38_), _tmp42_);
							_kernel_event_status_unref0 (_tmp42_);
							break;
						}
					}
				} else if (_tmp30_ == ((0 != _tmp29_label2) ? _tmp29_label2 : (_tmp29_label2 = g_quark_from_static_string ("relative")))) {
					switch (0) {
						default:
						{
							GeeHashMap* _tmp43_;
							gint _tmp44_;
							const gchar* _tmp45_;
							gboolean _tmp46_;
							KernelEventStatus* _tmp47_;
							KernelEventStatus* _tmp48_;
							_tmp43_ = self->priv->relatives;
							_tmp44_ = code;
							_tmp45_ = name;
							_tmp46_ = reportheld;
							_tmp47_ = kernel_event_status_new (_tmp45_, _tmp46_);
							_tmp48_ = _tmp47_;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp43_, GINT_TO_POINTER (_tmp44_), _tmp48_);
							_kernel_event_status_unref0 (_tmp48_);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							FsoFrameworkLogger* _tmp49_;
							const gchar* _tmp50_;
							const gchar* _tmp51_ = NULL;
							const gchar* _tmp52_;
							const gchar* _tmp53_ = NULL;
							gchar* _tmp54_ = NULL;
							gchar* _tmp55_;
							_tmp49_ = ((FsoFrameworkAbstractObject*) self)->logger;
							_tmp50_ = entry;
							_tmp51_ = string_to_string (_tmp50_);
							_tmp52_ = type;
							_tmp53_ = string_to_string (_tmp52_);
							_tmp54_ = g_strconcat ("Config option ", _tmp51_, " has unknown type element ", _tmp53_, ". Ignoring", NULL);
							_tmp55_ = _tmp54_;
							fso_framework_logger_warning (_tmp49_, _tmp55_);
							_g_free0 (_tmp55_);
							continue;
						}
					}
				}
				_g_free0 (type);
				_g_free0 (name);
				values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (value);
				_g_free0 (entry);
			}
		}
	}
	__g_list_free__g_free0_0 (entries);
}


static void _kernel_aggregate_input_device_handleInputEvent (KernelAggregateInputDevice* self, struct input_event* ev) {
	GeeHashMap* table;
	struct input_event _tmp0_;
	guint16 _tmp1_;
	GeeHashMap* _tmp8_;
	GeeHashMap* _tmp9_;
	struct input_event _tmp10_;
	guint16 _tmp11_;
	gpointer _tmp12_ = NULL;
	KernelEventStatus* es;
	KernelEventStatus* _tmp13_;
	KernelEventStatus* _tmp14_;
	struct input_event _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ev != NULL);
	table = NULL;
	_tmp0_ = *ev;
	_tmp1_ = _tmp0_.type;
	switch (_tmp1_) {
		case EV_KEY:
		{
			GeeHashMap* _tmp2_;
			GeeHashMap* _tmp3_;
			_tmp2_ = self->priv->keys;
			_tmp3_ = _g_object_ref0 (_tmp2_);
			_g_object_unref0 (table);
			table = _tmp3_;
			break;
		}
		case EV_SW:
		{
			GeeHashMap* _tmp4_;
			GeeHashMap* _tmp5_;
			_tmp4_ = self->priv->switches;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_g_object_unref0 (table);
			table = _tmp5_;
			break;
		}
		case EV_REL:
		{
			GeeHashMap* _tmp6_;
			GeeHashMap* _tmp7_;
			_tmp6_ = self->priv->relatives;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			_g_object_unref0 (table);
			table = _tmp7_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp8_ = table;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (table);
		return;
	}
	_tmp9_ = table;
	_tmp10_ = *ev;
	_tmp11_ = _tmp10_.code;
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, GINT_TO_POINTER ((gint) _tmp11_));
	es = (KernelEventStatus*) _tmp12_;
	_tmp13_ = es;
	if (_tmp13_ == NULL) {
		_kernel_event_status_unref0 (es);
		_g_object_unref0 (table);
		return;
	}
	_tmp14_ = es;
	_tmp15_ = *ev;
	kernel_event_status_handle (_tmp14_, &_tmp15_);
	_kernel_event_status_unref0 (es);
	_g_object_unref0 (table);
}


static gchar* kernel_aggregate_input_device_real_repr (FsoFrameworkAbstractObject* base) {
	KernelAggregateInputDevice * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (KernelAggregateInputDevice*) base;
	_tmp0_ = self->priv->sysfsnode;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("<", _tmp1_, ">", NULL);
	result = _tmp2_;
	return result;
}


gboolean kernel_aggregate_input_device_onInputEvent (KernelAggregateInputDevice* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	struct input_event _tmp0_ = {0};
	struct input_event ev;
	GIOChannel* _tmp1_;
	gint _tmp2_ = 0;
	gssize _tmp3_ = 0L;
	gssize bytesread;
	gssize _tmp4_;
	struct input_event _tmp12_;
	guint16 _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	ev = _tmp0_;
	_tmp1_ = source;
	_tmp2_ = g_io_channel_unix_get_fd (_tmp1_);
	_tmp3_ = read (_tmp2_, &ev, (gsize) sizeof (struct input_event));
	bytesread = _tmp3_;
	_tmp4_ = bytesread;
	if (_tmp4_ == ((gssize) 0)) {
		FsoFrameworkLogger* _tmp5_;
		GIOChannel* _tmp6_;
		gint _tmp7_ = 0;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp5_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp6_ = source;
		_tmp7_ = g_io_channel_unix_get_fd (_tmp6_);
		_tmp8_ = g_strdup_printf ("%i", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("Could not read from input device fd ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		fso_framework_logger_warning (_tmp5_, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		result = FALSE;
		return result;
	}
	_tmp12_ = ev;
	_tmp13_ = _tmp12_.type;
	if (_tmp13_ != EV_SYN) {
		_kernel_aggregate_input_device_handleInputEvent (self, &ev);
	}
	result = TRUE;
	return result;
}


static void kernel_aggregate_input_device_get_name_data_free (gpointer _data) {
	KernelAggregateInputDeviceGetNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (KernelAggregateInputDeviceGetNameData, _data_);
}


void kernel_aggregate_input_device_get_name (KernelAggregateInputDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelAggregateInputDeviceGetNameData* _data_;
	KernelAggregateInputDevice* _tmp0_;
	_data_ = g_slice_new0 (KernelAggregateInputDeviceGetNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_aggregate_input_device_get_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_aggregate_input_device_get_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_aggregate_input_device_get_name_co (_data_);
}


gchar* kernel_aggregate_input_device_get_name_finish (KernelAggregateInputDevice* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	KernelAggregateInputDeviceGetNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean kernel_aggregate_input_device_get_name_co (KernelAggregateInputDeviceGetNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = dev_input;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->result = _data_->_tmp1_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_aggregate_input_device_real_get_id_data_free (gpointer _data) {
	KernelAggregateInputDeviceGetIdData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (KernelAggregateInputDeviceGetIdData, _data_);
}


static void kernel_aggregate_input_device_real_get_id (FreeSmartphoneDeviceInput* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelAggregateInputDevice * self;
	KernelAggregateInputDeviceGetIdData* _data_;
	KernelAggregateInputDevice* _tmp0_;
	self = (KernelAggregateInputDevice*) base;
	_data_ = g_slice_new0 (KernelAggregateInputDeviceGetIdData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_aggregate_input_device_real_get_id);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_aggregate_input_device_real_get_id_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_aggregate_input_device_real_get_id_co (_data_);
}


static gchar* kernel_aggregate_input_device_real_get_id_finish (FreeSmartphoneDeviceInput* base, GAsyncResult* _res_, GError** error) {
	gchar* result;
	KernelAggregateInputDeviceGetIdData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean kernel_aggregate_input_device_real_get_id_co (KernelAggregateInputDeviceGetIdData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("aggregate");
	_data_->result = _data_->_tmp0_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_aggregate_input_device_get_phys_data_free (gpointer _data) {
	KernelAggregateInputDeviceGetPhysData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (KernelAggregateInputDeviceGetPhysData, _data_);
}


void kernel_aggregate_input_device_get_phys (KernelAggregateInputDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelAggregateInputDeviceGetPhysData* _data_;
	KernelAggregateInputDevice* _tmp0_;
	_data_ = g_slice_new0 (KernelAggregateInputDeviceGetPhysData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_aggregate_input_device_get_phys);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_aggregate_input_device_get_phys_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_aggregate_input_device_get_phys_co (_data_);
}


gchar* kernel_aggregate_input_device_get_phys_finish (KernelAggregateInputDevice* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	KernelAggregateInputDeviceGetPhysData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean kernel_aggregate_input_device_get_phys_co (KernelAggregateInputDeviceGetPhysData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("");
	_data_->result = _data_->_tmp0_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_aggregate_input_device_real_get_capabilities_data_free (gpointer _data) {
	KernelAggregateInputDeviceGetCapabilitiesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (KernelAggregateInputDeviceGetCapabilitiesData, _data_);
}


static void kernel_aggregate_input_device_real_get_capabilities (FreeSmartphoneDeviceInput* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelAggregateInputDevice * self;
	KernelAggregateInputDeviceGetCapabilitiesData* _data_;
	KernelAggregateInputDevice* _tmp0_;
	self = (KernelAggregateInputDevice*) base;
	_data_ = g_slice_new0 (KernelAggregateInputDeviceGetCapabilitiesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_aggregate_input_device_real_get_capabilities);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_aggregate_input_device_real_get_capabilities_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_aggregate_input_device_real_get_capabilities_co (_data_);
}


static gchar* kernel_aggregate_input_device_real_get_capabilities_finish (FreeSmartphoneDeviceInput* base, GAsyncResult* _res_, GError** error) {
	gchar* result;
	KernelAggregateInputDeviceGetCapabilitiesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean kernel_aggregate_input_device_real_get_capabilities_co (KernelAggregateInputDeviceGetCapabilitiesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("none");
	_data_->result = _data_->_tmp0_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_aggregate_input_device_class_init (KernelAggregateInputDeviceClass * klass) {
	kernel_aggregate_input_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KernelAggregateInputDevicePrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = kernel_aggregate_input_device_real_repr;
	G_OBJECT_CLASS (klass)->finalize = kernel_aggregate_input_device_finalize;
}


static void kernel_aggregate_input_device_free_smartphone_device_input_interface_init (FreeSmartphoneDeviceInputIface * iface) {
	kernel_aggregate_input_device_free_smartphone_device_input_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_id = (gchar* (*)(FreeSmartphoneDeviceInput*, GError**)) kernel_aggregate_input_device_real_get_id;
	iface->get_id_finish = kernel_aggregate_input_device_real_get_id_finish;
	iface->get_capabilities = (gchar* (*)(FreeSmartphoneDeviceInput*, GError**)) kernel_aggregate_input_device_real_get_capabilities;
	iface->get_capabilities_finish = kernel_aggregate_input_device_real_get_capabilities_finish;
}


static void kernel_aggregate_input_device_instance_init (KernelAggregateInputDevice * self) {
	self->priv = KERNEL_AGGREGATE_INPUT_DEVICE_GET_PRIVATE (self);
}


static void kernel_aggregate_input_device_finalize (GObject* obj) {
	KernelAggregateInputDevice * self;
	self = KERNEL_AGGREGATE_INPUT_DEVICE (obj);
	_g_object_unref0 (self->priv->subsystem);
	_g_free0 (self->priv->sysfsnode);
	self->priv->channels = (_vala_array_free (self->priv->channels, self->priv->channels_length1, (GDestroyNotify) g_io_channel_unref), NULL);
	_g_object_unref0 (self->priv->keys);
	_g_object_unref0 (self->priv->switches);
	_g_object_unref0 (self->priv->relatives);
	G_OBJECT_CLASS (kernel_aggregate_input_device_parent_class)->finalize (obj);
}


/**
 * Implementation of org.freesmartphone.Device.InputDevice as aggregated Kernel Input Device
 **/
GType kernel_aggregate_input_device_get_type (void) {
	return kernel_aggregate_input_device_type_id;
}


GType kernel_aggregate_input_device_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (KernelAggregateInputDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kernel_aggregate_input_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KernelAggregateInputDevice), 0, (GInstanceInitFunc) kernel_aggregate_input_device_instance_init, NULL };
	static const GInterfaceInfo free_smartphone_device_input_info = { (GInterfaceInitFunc) kernel_aggregate_input_device_free_smartphone_device_input_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	kernel_aggregate_input_device_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "KernelAggregateInputDevice", &g_define_type_info, 0);
	g_type_module_add_interface (module, kernel_aggregate_input_device_type_id, FREE_SMARTPHONE_DEVICE_TYPE_INPUT, &free_smartphone_device_input_info);
	return kernel_aggregate_input_device_type_id;
}


/**
 * This function gets called on plugin initialization time.
 * @return the name of your plugin here
 * @note that it needs to be a name in the format <subsystem>.<plugin>
 * else your module will be unloaded immediately.
 **/
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error) {
	gchar* result = NULL;
	FsoFrameworkSmartKeyFile* _tmp0_;
	FsoFrameworkSmartKeyFile* _tmp1_;
	FsoFrameworkSmartKeyFile* config;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	gchar** _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_ = 0;
	gchar** _tmp12_ = NULL;
	const gchar* _tmp13_;
	GDir* _tmp14_ = NULL;
	GDir* dir;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gchar* entry;
	FsoFrameworkSubsystem* _tmp28_;
	const gchar* _tmp29_;
	KernelAggregateInputDevice* _tmp30_;
	gchar* _tmp31_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (subsystem != NULL, NULL);
	_tmp0_ = fso_framework_theConfig;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	config = _tmp1_;
	_tmp2_ = fso_framework_smart_key_file_stringValue (config, "cornucopia", "dev_root", "/dev");
	_g_free0 (dev_root);
	dev_root = _tmp2_;
	_tmp3_ = dev_root;
	_tmp4_ = g_strdup_printf ("%s/input", _tmp3_);
	_g_free0 (dev_input);
	dev_input = _tmp4_;
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 0;
	_tmp8_ = fso_framework_smart_key_file_stringListValue (config, KERNEL_KERNEL_INPUT_PLUGIN_NAME, "ignore_by_id", _tmp6_, 0, &_tmp7_);
	ignoreById = (_vala_array_free (ignoreById, ignoreById_length1, (GDestroyNotify) g_free), NULL);
	ignoreById = _tmp8_;
	ignoreById_length1 = _tmp7_;
	_ignoreById_size_ = ignoreById_length1;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = g_new0 (gchar*, 0 + 1);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 0;
	_tmp12_ = fso_framework_smart_key_file_stringListValue (config, KERNEL_KERNEL_INPUT_PLUGIN_NAME, "ignore_by_path", _tmp10_, 0, &_tmp11_);
	ignoreByPhys = (_vala_array_free (ignoreByPhys, ignoreByPhys_length1, (GDestroyNotify) g_free), NULL);
	ignoreByPhys = _tmp12_;
	ignoreByPhys_length1 = _tmp11_;
	_ignoreByPhys_size_ = ignoreByPhys_length1;
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_tmp13_ = dev_input;
	_tmp14_ = g_dir_open (_tmp13_, (guint) 0, &_inner_error_);
	dir = _tmp14_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (config);
		return NULL;
	}
	_tmp15_ = g_dir_read_name (dir);
	_tmp16_ = g_strdup (_tmp15_);
	entry = _tmp16_;
	while (TRUE) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gboolean _tmp19_ = FALSE;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		_tmp17_ = entry;
		if (!(_tmp17_ != NULL)) {
			break;
		}
		_tmp18_ = entry;
		_tmp19_ = g_str_has_prefix (_tmp18_, "event");
		if (_tmp19_) {
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_ = NULL;
			gchar* filename;
			FsoFrameworkSubsystem* _tmp23_;
			const gchar* _tmp24_;
			KernelInputDevice* _tmp25_;
			_tmp20_ = dev_input;
			_tmp21_ = entry;
			_tmp22_ = g_build_filename (_tmp20_, _tmp21_, NULL);
			filename = _tmp22_;
			_tmp23_ = subsystem;
			_tmp24_ = filename;
			_tmp25_ = kernel_input_device_new (_tmp23_, _tmp24_);
			instances = g_list_append (instances, _tmp25_);
			_g_free0 (filename);
		}
		_tmp26_ = g_dir_read_name (dir);
		_tmp27_ = g_strdup (_tmp26_);
		_g_free0 (entry);
		entry = _tmp27_;
	}
	_tmp28_ = subsystem;
	_tmp29_ = dev_input;
	_tmp30_ = kernel_aggregate_input_device_new (_tmp28_, _tmp29_);
	_g_object_unref0 (aggregate);
	aggregate = _tmp30_;
	_tmp31_ = g_strdup (KERNEL_KERNEL_INPUT_PLUGIN_NAME);
	result = _tmp31_;
	_g_free0 (entry);
	_g_dir_close0 (dir);
	_g_object_unref0 (config);
	return result;
}


void fso_register_function (GTypeModule* module) {
	FsoFrameworkLogger* _tmp0_;
	g_return_if_fail (module != NULL);
	kernel_input_device_register_type (module);
	kernel_event_status_register_type (module);
	kernel_aggregate_input_device_register_type (module);
	_tmp0_ = fso_framework_theLogger;
	fso_framework_logger_debug (_tmp0_, "fsodevice.kernel_input fso_register_function()");
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



