/*
 * Decompiled with CFR 0.152.
 */
package com.metaparadigm.jsonrpc;

import com.metaparadigm.jsonrpc.AbstractSerializer;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.UnmarshallException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONObject;

public class BeanSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(BeanSerializer.class.getName());
    private static HashMap beanCache = new HashMap();
    private static Class[] _serializableClasses = new Class[0];
    private static Class[] _JSONClasses = new Class[0];

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return !clazz.isArray() && !clazz.isPrimitive() && !clazz.isInterface() && (jsonClazz == null || jsonClazz == JSONObject.class);
    }

    public static BeanData analyzeBean(Class clazz) throws IntrospectionException {
        log.info("analyzing " + clazz.getName());
        BeanData bd = new BeanData();
        bd.beanInfo = Introspector.getBeanInfo(clazz, Object.class);
        PropertyDescriptor[] props = bd.beanInfo.getPropertyDescriptors();
        bd.readableProps = new HashMap();
        bd.writableProps = new HashMap();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].getWriteMethod() != null) {
                bd.writableProps.put(props[i].getName(), props[i].getWriteMethod());
            }
            if (props[i].getReadMethod() == null) continue;
            bd.readableProps.put(props[i].getName(), props[i].getReadMethod());
        }
        return bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanData getBeanData(Class clazz) throws IntrospectionException {
        BeanData bd;
        HashMap hashMap = beanCache;
        synchronized (hashMap) {
            bd = (BeanData)beanCache.get(clazz);
            if (bd == null) {
                bd = BeanSerializer.analyzeBean(clazz);
                beanCache.put(clazz, bd);
            }
        }
        return bd;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jso = (JSONObject)o;
        BeanData bd = null;
        try {
            bd = BeanSerializer.getBeanData(clazz);
        }
        catch (IntrospectionException e) {
            throw new UnmarshallException(clazz.getName() + " is not a bean");
        }
        int match = 0;
        int mismatch = 0;
        Iterator i = bd.writableProps.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry ent = i.next();
            String prop = (String)ent.getKey();
            Method method = (Method)ent.getValue();
            if (jso.has(prop)) {
                ++match;
                continue;
            }
            ++mismatch;
        }
        if (match == 0) {
            throw new UnmarshallException("bean has no matches");
        }
        ObjectMatch m = null;
        ObjectMatch tmp = null;
        i = jso.keys();
        while (i.hasNext()) {
            String field = (String)i.next();
            Method setMethod = (Method)bd.writableProps.get(field);
            if (setMethod != null) {
                try {
                    Class<?>[] param = setMethod.getParameterTypes();
                    if (param.length != 1) {
                        throw new UnmarshallException("bean " + clazz.getName() + " method " + setMethod.getName() + " does not have one arg");
                    }
                    tmp = this.ser.tryUnmarshall(state, param[0], jso.get(field));
                    if (m == null) {
                        m = tmp;
                        continue;
                    }
                    m = m.max(tmp);
                    continue;
                }
                catch (UnmarshallException e) {
                    throw new UnmarshallException("bean " + clazz.getName() + " " + e.getMessage());
                }
            }
            ++mismatch;
        }
        return m.max(new ObjectMatch(mismatch));
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jso = (JSONObject)o;
        BeanData bd = null;
        try {
            bd = BeanSerializer.getBeanData(clazz);
        }
        catch (IntrospectionException e) {
            throw new UnmarshallException(clazz.getName() + " is not a bean");
        }
        if (this.ser.isDebug()) {
            log.fine("instantiating " + clazz.getName());
        }
        Object instance = null;
        try {
            instance = clazz.newInstance();
        }
        catch (Exception e) {
            throw new UnmarshallException("can't instantiate bean " + clazz.getName() + ": " + e.getMessage());
        }
        Object[] invokeArgs = new Object[1];
        Iterator i = jso.keys();
        while (i.hasNext()) {
            Object fieldVal;
            String field = (String)i.next();
            Method setMethod = (Method)bd.writableProps.get(field);
            if (setMethod == null) continue;
            try {
                Class<?>[] param = setMethod.getParameterTypes();
                fieldVal = this.ser.unmarshall(state, param[0], jso.get(field));
            }
            catch (UnmarshallException e) {
                throw new UnmarshallException("bean " + clazz.getName() + " " + e.getMessage());
            }
            if (this.ser.isDebug()) {
                log.fine("invoking " + setMethod.getName() + "(" + fieldVal + ")");
            }
            invokeArgs[0] = fieldVal;
            try {
                setMethod.invoke(instance, invokeArgs);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                throw new UnmarshallException("bean " + clazz.getName() + "can't invoke " + setMethod.getName() + ": " + e.getMessage());
            }
        }
        return instance;
    }

    public Object marshall(SerializerState state, Object o) throws MarshallException {
        BeanSerializerState beanState;
        try {
            beanState = (BeanSerializerState)state.get(BeanSerializerState.class);
        }
        catch (Exception e) {
            throw new MarshallException("bean serializer internal error");
        }
        Integer identity = new Integer(System.identityHashCode(o));
        if (beanState.beanSet.contains(identity)) {
            throw new MarshallException("circular reference");
        }
        beanState.beanSet.add(identity);
        BeanData bd = null;
        try {
            bd = BeanSerializer.getBeanData(o.getClass());
        }
        catch (IntrospectionException e) {
            throw new MarshallException(o.getClass().getName() + " is not a bean");
        }
        JSONObject val = new JSONObject();
        if (this.ser.getMarshallClassHints()) {
            val.put("javaClass", o.getClass().getName());
        }
        Iterator i = bd.readableProps.entrySet().iterator();
        Object[] args = new Object[]{};
        Object result = null;
        while (i.hasNext()) {
            Map.Entry ent = i.next();
            String prop = (String)ent.getKey();
            Method getMethod = (Method)ent.getValue();
            if (this.ser.isDebug()) {
                log.fine("invoking " + getMethod.getName() + "()");
            }
            try {
                result = getMethod.invoke(o, args);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                throw new MarshallException("bean " + o.getClass().getName() + " can't invoke " + getMethod.getName() + ": " + e.getMessage());
            }
            try {
                if (result == null && !this.ser.getMarshallNullAttributes()) continue;
                val.put(prop, this.ser.marshall(state, result));
            }
            catch (MarshallException e) {
                throw new MarshallException("bean " + o.getClass().getName() + " " + e.getMessage());
            }
        }
        beanState.beanSet.remove(identity);
        return val;
    }

    protected static class BeanSerializerState {
        public HashSet beanSet = new HashSet();

        protected BeanSerializerState() {
        }
    }

    protected static class BeanData {
        public BeanInfo beanInfo;
        public HashMap readableProps;
        public HashMap writableProps;

        protected BeanData() {
        }
    }
}

