
/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2021 KiCad Developers, see AUTHORS.txt for contributors.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * This file is auto-generated by CMake when MAINTAIN_PNGS is on. Do not edit by hand!
 */

#ifndef KICAD_BITMAP_INFO_H
#define KICAD_BITMAP_INFO_H

#include <vector>
#include <bitmaps/bitmaps_list.h>

#include <wx/string.h> // wxT

struct BITMAP_INFO
{
    BITMAPS  id;
    wxString filename;
    int      height;
    wxString theme;
};


const std::vector<BITMAP_INFO> g_BitmapInfo = {
    { BITMAPS::icon_bitmap2component_16, wxT( "icon_bitmap2component_16_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::icon_eeschema_16, wxT( "icon_eeschema_16_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::icon_gerbview_16, wxT( "icon_gerbview_16_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::icon_kicad_16, wxT( "icon_kicad_16_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::icon_libedit_16, wxT( "icon_libedit_16_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::icon_modedit_16, wxT( "icon_modedit_16_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::icon_pagelayout_editor_16, wxT( "icon_pagelayout_editor_16_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::icon_pcbcalculator_16, wxT( "icon_pcbcalculator_16_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::icon_pcbnew_16, wxT( "icon_pcbnew_16_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::list_nets_16, wxT( "list_nets_16_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::options_generic_16, wxT( "options_generic_16_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pinorient_right, wxT( "pinorient_right_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pinorient_left, wxT( "pinorient_left_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pinorient_up, wxT( "pinorient_up_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pinorient_down, wxT( "pinorient_down_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pinshape_normal, wxT( "pinshape_normal_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pinshape_invert, wxT( "pinshape_invert_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pinshape_clock_normal, wxT( "pinshape_clock_normal_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pinshape_clock_invert, wxT( "pinshape_clock_invert_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pinshape_active_low_input, wxT( "pinshape_active_low_input_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pinshape_clock_active_low, wxT( "pinshape_clock_active_low_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pinshape_active_low_output, wxT( "pinshape_active_low_output_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pinshape_clock_fall, wxT( "pinshape_clock_fall_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pinshape_nonlogic, wxT( "pinshape_nonlogic_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pintype_input, wxT( "pintype_input_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pintype_output, wxT( "pintype_output_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pintype_bidi, wxT( "pintype_bidi_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pintype_3states, wxT( "pintype_3states_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pintype_passive, wxT( "pintype_passive_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pintype_notspecif, wxT( "pintype_notspecif_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pintype_powerinput, wxT( "pintype_powerinput_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pintype_poweroutput, wxT( "pintype_poweroutput_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pintype_opencoll, wxT( "pintype_opencoll_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pintype_openemit, wxT( "pintype_openemit_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pintype_nic, wxT( "pintype_nic_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::pintype_noconnect, wxT( "pintype_noconnect_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::small_down, wxT( "small_down_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::small_edit, wxT( "small_edit_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::small_folder, wxT( "small_folder_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::small_library, wxT( "small_library_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::small_plus, wxT( "small_plus_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::small_refresh, wxT( "small_refresh_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::small_trash, wxT( "small_trash_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::small_up, wxT( "small_up_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::small_warning, wxT( "small_warning_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::tree_nosel, wxT( "tree_nosel_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::tree_sel, wxT( "tree_sel_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::visibility, wxT( "visibility_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::visibility_off, wxT( "visibility_off_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::www, wxT( "www_16.png" ), 16, wxT( "light" ) },
    { BITMAPS::icon_bitmap2component_16, wxT( "icon_bitmap2component_16_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::icon_eeschema_16, wxT( "icon_eeschema_16_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::icon_gerbview_16, wxT( "icon_gerbview_16_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::icon_kicad_16, wxT( "icon_kicad_16_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::icon_libedit_16, wxT( "icon_libedit_16_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::icon_modedit_16, wxT( "icon_modedit_16_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::icon_pagelayout_editor_16, wxT( "icon_pagelayout_editor_16_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::icon_pcbcalculator_16, wxT( "icon_pcbcalculator_16_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::icon_pcbnew_16, wxT( "icon_pcbnew_16_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::list_nets_16, wxT( "list_nets_16_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::options_generic_16, wxT( "options_generic_16_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pinorient_right, wxT( "pinorient_right_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pinorient_left, wxT( "pinorient_left_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pinorient_up, wxT( "pinorient_up_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pinorient_down, wxT( "pinorient_down_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pinshape_normal, wxT( "pinshape_normal_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pinshape_invert, wxT( "pinshape_invert_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pinshape_clock_normal, wxT( "pinshape_clock_normal_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pinshape_clock_invert, wxT( "pinshape_clock_invert_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pinshape_active_low_input, wxT( "pinshape_active_low_input_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pinshape_clock_active_low, wxT( "pinshape_clock_active_low_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pinshape_active_low_output, wxT( "pinshape_active_low_output_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pinshape_clock_fall, wxT( "pinshape_clock_fall_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pinshape_nonlogic, wxT( "pinshape_nonlogic_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pintype_input, wxT( "pintype_input_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pintype_output, wxT( "pintype_output_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pintype_bidi, wxT( "pintype_bidi_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pintype_3states, wxT( "pintype_3states_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pintype_passive, wxT( "pintype_passive_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pintype_notspecif, wxT( "pintype_notspecif_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pintype_powerinput, wxT( "pintype_powerinput_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pintype_poweroutput, wxT( "pintype_poweroutput_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pintype_opencoll, wxT( "pintype_opencoll_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pintype_openemit, wxT( "pintype_openemit_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pintype_nic, wxT( "pintype_nic_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::pintype_noconnect, wxT( "pintype_noconnect_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::small_down, wxT( "small_down_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::small_edit, wxT( "small_edit_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::small_folder, wxT( "small_folder_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::small_library, wxT( "small_library_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::small_plus, wxT( "small_plus_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::small_refresh, wxT( "small_refresh_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::small_trash, wxT( "small_trash_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::small_up, wxT( "small_up_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::small_warning, wxT( "small_warning_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::tree_nosel, wxT( "tree_nosel_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::tree_sel, wxT( "tree_sel_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::visibility, wxT( "visibility_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::visibility_off, wxT( "visibility_off_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::www, wxT( "www_dark_16.png" ), 16, wxT( "dark" ) },
    { BITMAPS::about, wxT( "about_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_aligned_dimension, wxT( "add_aligned_dimension_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_arc, wxT( "add_arc_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_board, wxT( "add_board_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_bus2bus, wxT( "add_bus2bus_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_bus, wxT( "add_bus_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_center_dimension, wxT( "add_center_dimension_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_circle, wxT( "add_circle_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_component, wxT( "add_component_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_corner, wxT( "add_corner_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_dashed_line, wxT( "add_dashed_line_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_document, wxT( "add_document_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_glabel, wxT( "add_glabel_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_graphical_segments, wxT( "add_graphical_segments_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_graphical_polygon, wxT( "add_graphical_polygon_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_hierarchical_label, wxT( "add_hierarchical_label_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_hierar_pin, wxT( "add_hierar_pin_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_hierarchical_subsheet, wxT( "add_hierarchical_subsheet_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_junction, wxT( "add_junction_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_keepout_area, wxT( "add_keepout_area_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_label, wxT( "add_label_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_leader, wxT( "add_leader_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_library, wxT( "add_library_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_line2bus, wxT( "add_line2bus_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_line_label, wxT( "add_line_label_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_line, wxT( "add_line_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_orthogonal_dimension, wxT( "add_orthogonal_dimension_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_pcb_target, wxT( "add_pcb_target_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_power, wxT( "add_power_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_rectangle, wxT( "add_rectangle_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_symbol_to_schematic, wxT( "add_symbol_to_schematic_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_tracks, wxT( "add_tracks_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_via, wxT( "add_via_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_zone_cutout, wxT( "add_zone_cutout_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::add_zone, wxT( "add_zone_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::align_items, wxT( "align_items_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::align_items_left, wxT( "align_items_left_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::align_items_right, wxT( "align_items_right_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::align_items_top, wxT( "align_items_top_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::align_items_bottom, wxT( "align_items_bottom_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::align_items_center, wxT( "align_items_center_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::align_items_middle, wxT( "align_items_middle_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::anchor, wxT( "anchor_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::annotate_down_right, wxT( "annotate_down_right_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::annotate_right_down, wxT( "annotate_right_down_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::annotate, wxT( "annotate_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::apply_pad_settings, wxT( "apply_pad_settings_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::array, wxT( "array_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::auto_associate, wxT( "auto_associate_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::auto_track_width, wxT( "auto_track_width_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::autoplace_fields, wxT( "autoplace_fields_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::axis3d_back, wxT( "axis3d_back_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::axis3d_bottom, wxT( "axis3d_bottom_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::axis3d_front, wxT( "axis3d_front_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::axis3d_left, wxT( "axis3d_left_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::axis3d_right, wxT( "axis3d_right_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::axis3d_top, wxT( "axis3d_top_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::axis3d, wxT( "axis3d_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::break_line, wxT( "break_line_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::bug, wxT( "bug_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::bus_definition_tool, wxT( "bus_definition_tool_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::cancel, wxT( "cancel_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::change_entry_orient, wxT( "change_entry_orient_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::contrast_mode, wxT( "contrast_mode_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::curved_ratsnest, wxT( "curved_ratsnest_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::checked_ok, wxT( "checked_ok_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::color_materials, wxT( "color_materials_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::component_select_unit, wxT( "component_select_unit_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::config, wxT( "config_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::convert, wxT( "convert_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::copy, wxT( "copy_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::copy_pad_settings, wxT( "copy_pad_settings_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::cursor_shape, wxT( "cursor_shape_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::cursor, wxT( "cursor_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::custom_pad_to_primitives, wxT( "custom_pad_to_primitives_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::cut, wxT( "cut_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::datasheet, wxT( "datasheet_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::delete_association, wxT( "delete_association_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::delete_cursor, wxT( "delete_cursor_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::delete_gerber, wxT( "delete_gerber_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::delete_sheet, wxT( "delete_sheet_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::directory, wxT( "directory_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::directory_browser, wxT( "directory_browser_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::directory_open, wxT( "directory_open_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::distribute_horizontal, wxT( "distribute_horizontal_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::distribute_vertical, wxT( "distribute_vertical_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::down, wxT( "down_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::drag, wxT( "drag_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::drag_segment_withslope, wxT( "drag_segment_withslope_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::drc, wxT( "drc_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::duplicate, wxT( "duplicate_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::edit_comp_footprint, wxT( "edit_comp_footprint_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::edit_comp_ref, wxT( "edit_comp_ref_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::edit_comp_value, wxT( "edit_comp_value_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::editor, wxT( "editor_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::edit_cmp_symb_links, wxT( "edit_cmp_symb_links_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::edit, wxT( "edit_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::edge_to_copper_clearance, wxT( "edge_to_copper_clearance_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::enter_sheet, wxT( "enter_sheet_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::ercerr, wxT( "ercerr_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::erc_green, wxT( "erc_green_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::ercwarn, wxT( "ercwarn_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::erc, wxT( "erc_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::exit, wxT( "exit_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::exchange, wxT( "exchange_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::export3d, wxT( "export3d_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::export_cmp, wxT( "export_cmp_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::export_dsn, wxT( "export_dsn_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::export_idf, wxT( "export_idf_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::export_file, wxT( "export_file_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::export_footprint_names, wxT( "export_footprint_names_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::export_module, wxT( "export_module_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::export_part, wxT( "export_part_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::export_png, wxT( "export_png_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::export_step, wxT( "export_step_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::export_svg, wxT( "export_svg_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::export_to_pcbnew, wxT( "export_to_pcbnew_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::fabrication, wxT( "fabrication_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::file_bom, wxT( "file_bom_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::file_drl, wxT( "file_drl_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::file_dsn, wxT( "file_dsn_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::file_gbr, wxT( "file_gbr_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::file_gerber_job, wxT( "file_gerber_job_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::file_html, wxT( "file_html_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::file_idf, wxT( "file_idf_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::file_pdf, wxT( "file_pdf_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::file_pos, wxT( "file_pos_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::file_svg, wxT( "file_svg_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::fill_zone, wxT( "fill_zone_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::filter, wxT( "filter_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::find, wxT( "find_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::find_replace, wxT( "find_replace_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::flag, wxT( "flag_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::flip_board, wxT( "flip_board_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::gbr_select_mode2, wxT( "gbr_select_mode2_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::gerbview_show_negative_objects, wxT( "gerbview_show_negative_objects_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::general_deletions, wxT( "general_deletions_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::general_ratsnest, wxT( "general_ratsnest_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::grid_select, wxT( "grid_select_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::grid_select_axis, wxT( "grid_select_axis_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::grid, wxT( "grid_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::group, wxT( "group_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::group_enter, wxT( "group_enter_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::group_leave, wxT( "group_leave_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::group_remove, wxT( "group_remove_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::group_ungroup, wxT( "group_ungroup_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::help, wxT( "help_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::help_online, wxT( "help_online_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::hidden_pin, wxT( "hidden_pin_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::hide_ratsnest, wxT( "hide_ratsnest_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::hierarchy_nav, wxT( "hierarchy_nav_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::hotkeys, wxT( "hotkeys_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::hole_to_hole_clearance, wxT( "hole_to_hole_clearance_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::hole_to_copper_clearance, wxT( "hole_to_copper_clearance_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::icon_cvpcb_24, wxT( "icon_cvpcb_24_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::icon_footprint_browser, wxT( "icon_footprint_browser_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::icon_gerbview_24, wxT( "icon_gerbview_24_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::icon_pcm_24, wxT( "icon_pcm_24_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::import3d, wxT( "import3d_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::image, wxT( "image_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::import_brd_file, wxT( "import_brd_file_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::import_document, wxT( "import_document_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::import_footprint_names, wxT( "import_footprint_names_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::import_hierarchical_label, wxT( "import_hierarchical_label_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::import_module, wxT( "import_module_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::import_part, wxT( "import_part_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::import_project, wxT( "import_project_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::import_vector, wxT( "import_vector_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::import, wxT( "import_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::info, wxT( "info_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::insert_module_board, wxT( "insert_module_board_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::language, wxT( "language_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::layers_manager, wxT( "layers_manager_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::leave_sheet, wxT( "leave_sheet_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::left, wxT( "left_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::libedit, wxT( "libedit_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::lib_next, wxT( "lib_next_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::lib_previous, wxT( "lib_previous_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::library_browser, wxT( "library_browser_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::library_archive, wxT( "library_archive_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::library_archive_as, wxT( "library_archive_as_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::library, wxT( "library_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::library_table, wxT( "library_table_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::lines90, wxT( "lines90_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::list_nets, wxT( "list_nets_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::load_drill, wxT( "load_drill_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::load_gerber, wxT( "load_gerber_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::load_module_board, wxT( "load_module_board_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::lock_unlock, wxT( "lock_unlock_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::locked, wxT( "locked_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::measurement, wxT( "measurement_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::pcb_target, wxT( "pcb_target_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::mirror_h, wxT( "mirror_h_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::mirror_v, wxT( "mirror_v_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::mode_module, wxT( "mode_module_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::module_editor, wxT( "module_editor_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::module_wizard, wxT( "module_wizard_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::module_filtered_list, wxT( "module_filtered_list_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::module_options, wxT( "module_options_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::module_pin_filtered_list, wxT( "module_pin_filtered_list_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::module_library_list, wxT( "module_library_list_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::module, wxT( "module_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::morgan1, wxT( "morgan1_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::morgan2, wxT( "morgan2_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::move_exactly, wxT( "move_exactly_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::move, wxT( "move_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::move_relative, wxT( "move_relative_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::mw_add_gap, wxT( "mw_add_gap_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::mw_add_line, wxT( "mw_add_line_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::mw_add_shape, wxT( "mw_add_shape_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::mw_add_stub_arc, wxT( "mw_add_stub_arc_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::mw_add_stub, wxT( "mw_add_stub_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::net_highlight, wxT( "net_highlight_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::net_highlight_schematic, wxT( "net_highlight_schematic_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::netlist, wxT( "netlist_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::new_component, wxT( "new_component_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::new_footprint, wxT( "new_footprint_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::new_generic, wxT( "new_generic_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::new_library, wxT( "new_library_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::new_project, wxT( "new_project_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::noconn, wxT( "noconn_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::normal, wxT( "normal_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::open_project, wxT( "open_project_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::options_3drender, wxT( "options_3drender_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::options_board, wxT( "options_board_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::options_generic, wxT( "options_generic_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::options_pad, wxT( "options_pad_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::options_schematic, wxT( "options_schematic_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::opt_show_polygon, wxT( "opt_show_polygon_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::ortho, wxT( "ortho_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::pad_sketch, wxT( "pad_sketch_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::pad, wxT( "pad_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::pad_enumerate, wxT( "pad_enumerate_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::pad_number, wxT( "pad_number_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::pads_mask_layers, wxT( "pads_mask_layers_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::pads_remove, wxT( "pads_remove_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::path, wxT( "path_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::pagelayout_normal_view_mode, wxT( "pagelayout_normal_view_mode_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::pagelayout_special_view_mode, wxT( "pagelayout_special_view_mode_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::part_properties, wxT( "part_properties_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::paste, wxT( "paste_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::pin2pin, wxT( "pin2pin_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::pin_size_to, wxT( "pin_size_to_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::pin_show_etype, wxT( "pin_show_etype_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::pin_table, wxT( "pin_table_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::pin, wxT( "pin_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::plot, wxT( "plot_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::polar_coord, wxT( "polar_coord_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::post_bom, wxT( "post_bom_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::post_compo, wxT( "post_compo_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::post_d356, wxT( "post_d356_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::post_drill, wxT( "post_drill_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::post_gencad, wxT( "post_gencad_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::post_gerber, wxT( "post_gerber_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::post_rpt, wxT( "post_rpt_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::preference, wxT( "preference_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::print_button, wxT( "print_button_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::project, wxT( "project_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::project_close, wxT( "project_close_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::project_kicad, wxT( "project_kicad_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::ps_diff_pair, wxT( "ps_diff_pair_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::ps_diff_pair_gap, wxT( "ps_diff_pair_gap_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::ps_diff_pair_tune_length, wxT( "ps_diff_pair_tune_length_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::ps_diff_pair_tune_phase, wxT( "ps_diff_pair_tune_phase_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::ps_tune_length, wxT( "ps_tune_length_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::push_pad_settings, wxT( "push_pad_settings_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::puzzle_piece, wxT( "puzzle_piece_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::py_script, wxT( "py_script_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::recent, wxT( "recent_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::redo, wxT( "redo_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::refresh, wxT( "refresh_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::reload, wxT( "reload_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::render_mode, wxT( "render_mode_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::rescue, wxT( "rescue_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::right, wxT( "right_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::router_len_tuner, wxT( "router_len_tuner_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::router_len_tuner_setup, wxT( "router_len_tuner_setup_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::router_len_tuner_amplitude_decr, wxT( "router_len_tuner_amplitude_decr_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::router_len_tuner_amplitude_incr, wxT( "router_len_tuner_amplitude_incr_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::router_len_tuner_dist_decr, wxT( "router_len_tuner_dist_decr_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::router_len_tuner_dist_incr, wxT( "router_len_tuner_dist_incr_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::rotate_ccw, wxT( "rotate_ccw_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::rotate_cw, wxT( "rotate_cw_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::rotate_ccw_x, wxT( "rotate_ccw_x_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::rotate_cw_x, wxT( "rotate_cw_x_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::rotate_ccw_y, wxT( "rotate_ccw_y_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::rotate_cw_y, wxT( "rotate_cw_y_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::rotate_ccw_z, wxT( "rotate_ccw_z_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::rotate_cw_z, wxT( "rotate_cw_z_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::save_as, wxT( "save_as_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::save, wxT( "save_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::select_layer_pair, wxT( "select_layer_pair_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::select_w_layer, wxT( "select_w_layer_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::select_same_sheet, wxT( "select_same_sheet_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::shape_3d, wxT( "shape_3d_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::shape_3d_back, wxT( "shape_3d_back_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::sheetset, wxT( "sheetset_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::simulator, wxT( "simulator_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::sim_run, wxT( "sim_run_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::sim_stop, wxT( "sim_stop_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::sim_tune, wxT( "sim_tune_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::sim_probe, wxT( "sim_probe_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::sim_add_signal, wxT( "sim_add_signal_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::search_tree, wxT( "search_tree_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::set_origin, wxT( "set_origin_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_dcodenumber, wxT( "show_dcodenumber_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_footprint, wxT( "show_footprint_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_mod_edge, wxT( "show_mod_edge_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_ratsnest, wxT( "show_ratsnest_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::showtrack, wxT( "showtrack_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_other, wxT( "show_other_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_tht, wxT( "show_tht_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_smt, wxT( "show_smt_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_zone, wxT( "show_zone_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_zone_disable, wxT( "show_zone_disable_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_zone_outline_only, wxT( "show_zone_outline_only_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_zone_triangulation, wxT( "show_zone_triangulation_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_all_layers, wxT( "show_all_layers_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_no_layers, wxT( "show_no_layers_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_no_copper_layers, wxT( "show_no_copper_layers_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_all_copper_layers, wxT( "show_all_copper_layers_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_all_front_layers, wxT( "show_all_front_layers_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_all_back_layers, wxT( "show_all_back_layers_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_front_assembly_layers, wxT( "show_front_assembly_layers_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::show_back_assembly_layers, wxT( "show_back_assembly_layers_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::special_tools, wxT( "special_tools_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::spreadsheet, wxT( "spreadsheet_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::swap_layer, wxT( "swap_layer_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::switch_corner_rounding_shape, wxT( "switch_corner_rounding_shape_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::text, wxT( "text_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::text_sketch, wxT( "text_sketch_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::three_d, wxT( "three_d_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::tool_ratsnest, wxT( "tool_ratsnest_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::tools, wxT( "tools_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::trash, wxT( "trash_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::undo, wxT( "undo_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::unit_inch, wxT( "unit_inch_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::unit_mil, wxT( "unit_mil_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::unit_mm, wxT( "unit_mm_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::unknown, wxT( "unknown_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::unlocked, wxT( "unlocked_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::unzip, wxT( "unzip_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::up, wxT( "up_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::update_pcb_from_sch, wxT( "update_pcb_from_sch_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::update_sch_from_pcb, wxT( "update_sch_from_pcb_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::via, wxT( "via_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::via_annulus, wxT( "via_annulus_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::via_buried, wxT( "via_buried_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::via_microvia, wxT( "via_microvia_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::via_sketch, wxT( "via_sketch_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::via_diameter, wxT( "via_diameter_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::via_hole_diameter, wxT( "via_hole_diameter_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::width_track_via, wxT( "width_track_via_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::width_track, wxT( "width_track_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::zip, wxT( "zip_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::zone_duplicate, wxT( "zone_duplicate_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::zone_fillet, wxT( "zone_fillet_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::zone_unfill, wxT( "zone_unfill_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::zoom_area, wxT( "zoom_area_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::zoom_auto_fit_in_page, wxT( "zoom_auto_fit_in_page_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::zoom_fit_in_page, wxT( "zoom_fit_in_page_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::zoom_fit_to_objects, wxT( "zoom_fit_to_objects_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::zoom_center_on_screen, wxT( "zoom_center_on_screen_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::zoom_in, wxT( "zoom_in_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::zoom_out, wxT( "zoom_out_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::zoom_selection, wxT( "zoom_selection_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::about, wxT( "about_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_aligned_dimension, wxT( "add_aligned_dimension_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_arc, wxT( "add_arc_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_board, wxT( "add_board_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_bus2bus, wxT( "add_bus2bus_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_bus, wxT( "add_bus_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_center_dimension, wxT( "add_center_dimension_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_circle, wxT( "add_circle_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_component, wxT( "add_component_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_corner, wxT( "add_corner_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_dashed_line, wxT( "add_dashed_line_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_document, wxT( "add_document_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_glabel, wxT( "add_glabel_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_graphical_segments, wxT( "add_graphical_segments_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_graphical_polygon, wxT( "add_graphical_polygon_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_hierarchical_label, wxT( "add_hierarchical_label_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_hierar_pin, wxT( "add_hierar_pin_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_hierarchical_subsheet, wxT( "add_hierarchical_subsheet_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_junction, wxT( "add_junction_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_keepout_area, wxT( "add_keepout_area_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_label, wxT( "add_label_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_leader, wxT( "add_leader_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_library, wxT( "add_library_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_line2bus, wxT( "add_line2bus_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_line_label, wxT( "add_line_label_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_line, wxT( "add_line_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_orthogonal_dimension, wxT( "add_orthogonal_dimension_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_pcb_target, wxT( "add_pcb_target_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_power, wxT( "add_power_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_rectangle, wxT( "add_rectangle_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_symbol_to_schematic, wxT( "add_symbol_to_schematic_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_tracks, wxT( "add_tracks_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_via, wxT( "add_via_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_zone_cutout, wxT( "add_zone_cutout_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::add_zone, wxT( "add_zone_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::align_items, wxT( "align_items_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::align_items_left, wxT( "align_items_left_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::align_items_right, wxT( "align_items_right_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::align_items_top, wxT( "align_items_top_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::align_items_bottom, wxT( "align_items_bottom_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::align_items_center, wxT( "align_items_center_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::align_items_middle, wxT( "align_items_middle_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::anchor, wxT( "anchor_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::annotate_down_right, wxT( "annotate_down_right_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::annotate_right_down, wxT( "annotate_right_down_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::annotate, wxT( "annotate_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::apply_pad_settings, wxT( "apply_pad_settings_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::array, wxT( "array_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::auto_associate, wxT( "auto_associate_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::auto_track_width, wxT( "auto_track_width_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::autoplace_fields, wxT( "autoplace_fields_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::axis3d_back, wxT( "axis3d_back_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::axis3d_bottom, wxT( "axis3d_bottom_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::axis3d_front, wxT( "axis3d_front_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::axis3d_left, wxT( "axis3d_left_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::axis3d_right, wxT( "axis3d_right_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::axis3d_top, wxT( "axis3d_top_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::axis3d, wxT( "axis3d_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::break_line, wxT( "break_line_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::bug, wxT( "bug_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::bus_definition_tool, wxT( "bus_definition_tool_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::cancel, wxT( "cancel_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::change_entry_orient, wxT( "change_entry_orient_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::contrast_mode, wxT( "contrast_mode_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::curved_ratsnest, wxT( "curved_ratsnest_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::checked_ok, wxT( "checked_ok_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::color_materials, wxT( "color_materials_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::component_select_unit, wxT( "component_select_unit_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::config, wxT( "config_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::convert, wxT( "convert_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::copy, wxT( "copy_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::copy_pad_settings, wxT( "copy_pad_settings_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::cursor_shape, wxT( "cursor_shape_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::cursor, wxT( "cursor_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::custom_pad_to_primitives, wxT( "custom_pad_to_primitives_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::cut, wxT( "cut_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::datasheet, wxT( "datasheet_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::delete_association, wxT( "delete_association_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::delete_cursor, wxT( "delete_cursor_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::delete_gerber, wxT( "delete_gerber_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::delete_sheet, wxT( "delete_sheet_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::directory, wxT( "directory_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::directory_browser, wxT( "directory_browser_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::directory_open, wxT( "directory_open_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::distribute_horizontal, wxT( "distribute_horizontal_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::distribute_vertical, wxT( "distribute_vertical_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::down, wxT( "down_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::drag, wxT( "drag_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::drag_segment_withslope, wxT( "drag_segment_withslope_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::drc, wxT( "drc_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::duplicate, wxT( "duplicate_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::edit_comp_footprint, wxT( "edit_comp_footprint_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::edit_comp_ref, wxT( "edit_comp_ref_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::edit_comp_value, wxT( "edit_comp_value_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::editor, wxT( "editor_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::edit_cmp_symb_links, wxT( "edit_cmp_symb_links_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::edit, wxT( "edit_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::edge_to_copper_clearance, wxT( "edge_to_copper_clearance_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::enter_sheet, wxT( "enter_sheet_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::ercerr, wxT( "ercerr_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::erc_green, wxT( "erc_green_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::ercwarn, wxT( "ercwarn_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::erc, wxT( "erc_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::exit, wxT( "exit_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::exchange, wxT( "exchange_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::export3d, wxT( "export3d_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::export_cmp, wxT( "export_cmp_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::export_dsn, wxT( "export_dsn_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::export_idf, wxT( "export_idf_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::export_file, wxT( "export_file_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::export_footprint_names, wxT( "export_footprint_names_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::export_module, wxT( "export_module_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::export_part, wxT( "export_part_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::export_png, wxT( "export_png_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::export_step, wxT( "export_step_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::export_svg, wxT( "export_svg_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::export_to_pcbnew, wxT( "export_to_pcbnew_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::fabrication, wxT( "fabrication_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::file_bom, wxT( "file_bom_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::file_drl, wxT( "file_drl_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::file_dsn, wxT( "file_dsn_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::file_gbr, wxT( "file_gbr_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::file_gerber_job, wxT( "file_gerber_job_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::file_html, wxT( "file_html_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::file_idf, wxT( "file_idf_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::file_pdf, wxT( "file_pdf_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::file_pos, wxT( "file_pos_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::file_svg, wxT( "file_svg_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::fill_zone, wxT( "fill_zone_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::filter, wxT( "filter_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::find, wxT( "find_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::find_replace, wxT( "find_replace_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::flag, wxT( "flag_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::flip_board, wxT( "flip_board_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::gbr_select_mode2, wxT( "gbr_select_mode2_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::gerbview_show_negative_objects, wxT( "gerbview_show_negative_objects_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::general_deletions, wxT( "general_deletions_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::general_ratsnest, wxT( "general_ratsnest_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::grid_select, wxT( "grid_select_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::grid_select_axis, wxT( "grid_select_axis_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::grid, wxT( "grid_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::group, wxT( "group_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::group_enter, wxT( "group_enter_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::group_leave, wxT( "group_leave_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::group_remove, wxT( "group_remove_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::group_ungroup, wxT( "group_ungroup_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::help, wxT( "help_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::help_online, wxT( "help_online_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::hidden_pin, wxT( "hidden_pin_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::hide_ratsnest, wxT( "hide_ratsnest_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::hierarchy_nav, wxT( "hierarchy_nav_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::hotkeys, wxT( "hotkeys_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::hole_to_hole_clearance, wxT( "hole_to_hole_clearance_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::hole_to_copper_clearance, wxT( "hole_to_copper_clearance_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::icon_cvpcb_24, wxT( "icon_cvpcb_24_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::icon_footprint_browser, wxT( "icon_footprint_browser_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::icon_gerbview_24, wxT( "icon_gerbview_24_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::icon_pcm_24, wxT( "icon_pcm_24_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::import3d, wxT( "import3d_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::image, wxT( "image_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::import_brd_file, wxT( "import_brd_file_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::import_document, wxT( "import_document_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::import_footprint_names, wxT( "import_footprint_names_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::import_hierarchical_label, wxT( "import_hierarchical_label_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::import_module, wxT( "import_module_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::import_part, wxT( "import_part_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::import_project, wxT( "import_project_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::import_vector, wxT( "import_vector_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::import, wxT( "import_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::info, wxT( "info_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::insert_module_board, wxT( "insert_module_board_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::language, wxT( "language_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::layers_manager, wxT( "layers_manager_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::leave_sheet, wxT( "leave_sheet_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::left, wxT( "left_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::libedit, wxT( "libedit_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::lib_next, wxT( "lib_next_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::lib_previous, wxT( "lib_previous_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::library_browser, wxT( "library_browser_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::library_archive, wxT( "library_archive_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::library_archive_as, wxT( "library_archive_as_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::library, wxT( "library_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::library_table, wxT( "library_table_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::lines90, wxT( "lines90_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::list_nets, wxT( "list_nets_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::load_drill, wxT( "load_drill_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::load_gerber, wxT( "load_gerber_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::load_module_board, wxT( "load_module_board_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::lock_unlock, wxT( "lock_unlock_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::locked, wxT( "locked_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::measurement, wxT( "measurement_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::pcb_target, wxT( "pcb_target_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::mirror_h, wxT( "mirror_h_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::mirror_v, wxT( "mirror_v_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::mode_module, wxT( "mode_module_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::module_editor, wxT( "module_editor_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::module_wizard, wxT( "module_wizard_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::module_filtered_list, wxT( "module_filtered_list_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::module_options, wxT( "module_options_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::module_pin_filtered_list, wxT( "module_pin_filtered_list_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::module_library_list, wxT( "module_library_list_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::module, wxT( "module_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::morgan1, wxT( "morgan1_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::morgan2, wxT( "morgan2_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::move_exactly, wxT( "move_exactly_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::move, wxT( "move_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::move_relative, wxT( "move_relative_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::mw_add_gap, wxT( "mw_add_gap_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::mw_add_line, wxT( "mw_add_line_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::mw_add_shape, wxT( "mw_add_shape_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::mw_add_stub_arc, wxT( "mw_add_stub_arc_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::mw_add_stub, wxT( "mw_add_stub_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::net_highlight, wxT( "net_highlight_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::net_highlight_schematic, wxT( "net_highlight_schematic_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::netlist, wxT( "netlist_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::new_component, wxT( "new_component_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::new_footprint, wxT( "new_footprint_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::new_generic, wxT( "new_generic_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::new_library, wxT( "new_library_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::new_project, wxT( "new_project_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::noconn, wxT( "noconn_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::normal, wxT( "normal_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::open_project, wxT( "open_project_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::options_3drender, wxT( "options_3drender_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::options_board, wxT( "options_board_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::options_generic, wxT( "options_generic_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::options_pad, wxT( "options_pad_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::options_schematic, wxT( "options_schematic_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::opt_show_polygon, wxT( "opt_show_polygon_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::ortho, wxT( "ortho_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::pad_sketch, wxT( "pad_sketch_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::pad, wxT( "pad_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::pad_enumerate, wxT( "pad_enumerate_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::pad_number, wxT( "pad_number_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::pads_mask_layers, wxT( "pads_mask_layers_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::pads_remove, wxT( "pads_remove_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::path, wxT( "path_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::pagelayout_normal_view_mode, wxT( "pagelayout_normal_view_mode_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::pagelayout_special_view_mode, wxT( "pagelayout_special_view_mode_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::part_properties, wxT( "part_properties_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::paste, wxT( "paste_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::pin2pin, wxT( "pin2pin_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::pin_size_to, wxT( "pin_size_to_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::pin_show_etype, wxT( "pin_show_etype_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::pin_table, wxT( "pin_table_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::pin, wxT( "pin_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::plot, wxT( "plot_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::polar_coord, wxT( "polar_coord_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::post_bom, wxT( "post_bom_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::post_compo, wxT( "post_compo_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::post_d356, wxT( "post_d356_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::post_drill, wxT( "post_drill_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::post_gencad, wxT( "post_gencad_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::post_gerber, wxT( "post_gerber_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::post_rpt, wxT( "post_rpt_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::preference, wxT( "preference_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::print_button, wxT( "print_button_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::project, wxT( "project_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::project_close, wxT( "project_close_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::project_kicad, wxT( "project_kicad_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::ps_diff_pair, wxT( "ps_diff_pair_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::ps_diff_pair_gap, wxT( "ps_diff_pair_gap_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::ps_diff_pair_tune_length, wxT( "ps_diff_pair_tune_length_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::ps_diff_pair_tune_phase, wxT( "ps_diff_pair_tune_phase_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::ps_tune_length, wxT( "ps_tune_length_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::push_pad_settings, wxT( "push_pad_settings_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::puzzle_piece, wxT( "puzzle_piece_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::py_script, wxT( "py_script_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::recent, wxT( "recent_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::redo, wxT( "redo_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::refresh, wxT( "refresh_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::reload, wxT( "reload_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::render_mode, wxT( "render_mode_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::rescue, wxT( "rescue_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::right, wxT( "right_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::router_len_tuner, wxT( "router_len_tuner_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::router_len_tuner_setup, wxT( "router_len_tuner_setup_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::router_len_tuner_amplitude_decr, wxT( "router_len_tuner_amplitude_decr_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::router_len_tuner_amplitude_incr, wxT( "router_len_tuner_amplitude_incr_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::router_len_tuner_dist_decr, wxT( "router_len_tuner_dist_decr_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::router_len_tuner_dist_incr, wxT( "router_len_tuner_dist_incr_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::rotate_ccw, wxT( "rotate_ccw_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::rotate_cw, wxT( "rotate_cw_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::rotate_ccw_x, wxT( "rotate_ccw_x_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::rotate_cw_x, wxT( "rotate_cw_x_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::rotate_ccw_y, wxT( "rotate_ccw_y_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::rotate_cw_y, wxT( "rotate_cw_y_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::rotate_ccw_z, wxT( "rotate_ccw_z_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::rotate_cw_z, wxT( "rotate_cw_z_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::save_as, wxT( "save_as_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::save, wxT( "save_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::select_layer_pair, wxT( "select_layer_pair_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::select_w_layer, wxT( "select_w_layer_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::select_same_sheet, wxT( "select_same_sheet_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::shape_3d, wxT( "shape_3d_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::shape_3d_back, wxT( "shape_3d_back_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::sheetset, wxT( "sheetset_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::simulator, wxT( "simulator_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::sim_run, wxT( "sim_run_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::sim_stop, wxT( "sim_stop_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::sim_tune, wxT( "sim_tune_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::sim_probe, wxT( "sim_probe_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::sim_add_signal, wxT( "sim_add_signal_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::search_tree, wxT( "search_tree_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::set_origin, wxT( "set_origin_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_dcodenumber, wxT( "show_dcodenumber_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_footprint, wxT( "show_footprint_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_mod_edge, wxT( "show_mod_edge_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_ratsnest, wxT( "show_ratsnest_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::showtrack, wxT( "showtrack_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_other, wxT( "show_other_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_tht, wxT( "show_tht_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_smt, wxT( "show_smt_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_zone, wxT( "show_zone_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_zone_disable, wxT( "show_zone_disable_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_zone_outline_only, wxT( "show_zone_outline_only_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_zone_triangulation, wxT( "show_zone_triangulation_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_all_layers, wxT( "show_all_layers_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_no_layers, wxT( "show_no_layers_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_no_copper_layers, wxT( "show_no_copper_layers_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_all_copper_layers, wxT( "show_all_copper_layers_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_all_front_layers, wxT( "show_all_front_layers_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_all_back_layers, wxT( "show_all_back_layers_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_front_assembly_layers, wxT( "show_front_assembly_layers_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::show_back_assembly_layers, wxT( "show_back_assembly_layers_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::special_tools, wxT( "special_tools_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::spreadsheet, wxT( "spreadsheet_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::swap_layer, wxT( "swap_layer_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::switch_corner_rounding_shape, wxT( "switch_corner_rounding_shape_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::text, wxT( "text_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::text_sketch, wxT( "text_sketch_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::three_d, wxT( "three_d_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::tool_ratsnest, wxT( "tool_ratsnest_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::tools, wxT( "tools_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::trash, wxT( "trash_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::undo, wxT( "undo_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::unit_inch, wxT( "unit_inch_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::unit_mil, wxT( "unit_mil_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::unit_mm, wxT( "unit_mm_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::unknown, wxT( "unknown_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::unlocked, wxT( "unlocked_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::unzip, wxT( "unzip_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::up, wxT( "up_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::update_pcb_from_sch, wxT( "update_pcb_from_sch_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::update_sch_from_pcb, wxT( "update_sch_from_pcb_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::via, wxT( "via_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::via_annulus, wxT( "via_annulus_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::via_buried, wxT( "via_buried_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::via_microvia, wxT( "via_microvia_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::via_sketch, wxT( "via_sketch_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::via_diameter, wxT( "via_diameter_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::via_hole_diameter, wxT( "via_hole_diameter_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::width_track_via, wxT( "width_track_via_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::width_track, wxT( "width_track_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::zip, wxT( "zip_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::zone_duplicate, wxT( "zone_duplicate_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::zone_fillet, wxT( "zone_fillet_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::zone_unfill, wxT( "zone_unfill_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::zoom_area, wxT( "zoom_area_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::zoom_auto_fit_in_page, wxT( "zoom_auto_fit_in_page_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::zoom_fit_in_page, wxT( "zoom_fit_in_page_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::zoom_fit_to_objects, wxT( "zoom_fit_to_objects_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::zoom_center_on_screen, wxT( "zoom_center_on_screen_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::zoom_in, wxT( "zoom_in_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::zoom_out, wxT( "zoom_out_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::zoom_selection, wxT( "zoom_selection_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::icon_bitmap2component_32, wxT( "icon_bitmap2component_32_32.png" ), 32, wxT( "light" ) },
    { BITMAPS::icon_eeschema_32, wxT( "icon_eeschema_32_32.png" ), 32, wxT( "light" ) },
    { BITMAPS::icon_gerbview_32, wxT( "icon_gerbview_32_32.png" ), 32, wxT( "light" ) },
    { BITMAPS::icon_kicad_32, wxT( "icon_kicad_32_32.png" ), 32, wxT( "light" ) },
    { BITMAPS::icon_libedit_32, wxT( "icon_libedit_32_32.png" ), 32, wxT( "light" ) },
    { BITMAPS::icon_modedit_32, wxT( "icon_modedit_32_32.png" ), 32, wxT( "light" ) },
    { BITMAPS::icon_pagelayout_editor_32, wxT( "icon_pagelayout_editor_32_32.png" ), 32, wxT( "light" ) },
    { BITMAPS::icon_pcbcalculator_32, wxT( "icon_pcbcalculator_32_32.png" ), 32, wxT( "light" ) },
    { BITMAPS::icon_pcbnew_32, wxT( "icon_pcbnew_32_32.png" ), 32, wxT( "light" ) },
    { BITMAPS::icon_bitmap2component_32, wxT( "icon_bitmap2component_32_dark_32.png" ), 32, wxT( "dark" ) },
    { BITMAPS::icon_eeschema_32, wxT( "icon_eeschema_32_dark_32.png" ), 32, wxT( "dark" ) },
    { BITMAPS::icon_gerbview_32, wxT( "icon_gerbview_32_dark_32.png" ), 32, wxT( "dark" ) },
    { BITMAPS::icon_kicad_32, wxT( "icon_kicad_32_dark_32.png" ), 32, wxT( "dark" ) },
    { BITMAPS::icon_libedit_32, wxT( "icon_libedit_32_dark_32.png" ), 32, wxT( "dark" ) },
    { BITMAPS::icon_modedit_32, wxT( "icon_modedit_32_dark_32.png" ), 32, wxT( "dark" ) },
    { BITMAPS::icon_pagelayout_editor_32, wxT( "icon_pagelayout_editor_32_dark_32.png" ), 32, wxT( "dark" ) },
    { BITMAPS::icon_pcbcalculator_32, wxT( "icon_pcbcalculator_32_dark_32.png" ), 32, wxT( "dark" ) },
    { BITMAPS::icon_pcbnew_32, wxT( "icon_pcbnew_32_dark_32.png" ), 32, wxT( "dark" ) },
    { BITMAPS::icon_bitmap2component_24, wxT( "icon_bitmap2component_24_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::icon_eeschema_24, wxT( "icon_eeschema_24_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::icon_gerbview_24, wxT( "icon_gerbview_24_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::icon_libedit_24, wxT( "icon_libedit_24_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::icon_modedit_24, wxT( "icon_modedit_24_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::icon_pagelayout_editor_24, wxT( "icon_pagelayout_editor_24_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::icon_pcbcalculator_24, wxT( "icon_pcbcalculator_24_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::icon_pcbnew_24, wxT( "icon_pcbnew_24_24.png" ), 24, wxT( "light" ) },
    { BITMAPS::icon_bitmap2component_24, wxT( "icon_bitmap2component_24_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::icon_eeschema_24, wxT( "icon_eeschema_24_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::icon_gerbview_24, wxT( "icon_gerbview_24_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::icon_libedit_24, wxT( "icon_libedit_24_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::icon_modedit_24, wxT( "icon_modedit_24_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::icon_pagelayout_editor_24, wxT( "icon_pagelayout_editor_24_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::icon_pcbcalculator_24, wxT( "icon_pcbcalculator_24_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::icon_pcbnew_24, wxT( "icon_pcbnew_24_dark_24.png" ), 24, wxT( "dark" ) },
    { BITMAPS::icon_cvpcb, wxT( "icon_cvpcb_64.png" ), 64, wxT( "light" ) },
    { BITMAPS::icon_eeschema, wxT( "icon_eeschema_64.png" ), 64, wxT( "light" ) },
    { BITMAPS::icon_gerbview, wxT( "icon_gerbview_64.png" ), 64, wxT( "light" ) },
    { BITMAPS::icon_kicad, wxT( "icon_kicad_64.png" ), 64, wxT( "light" ) },
    { BITMAPS::icon_libedit, wxT( "icon_libedit_64.png" ), 64, wxT( "light" ) },
    { BITMAPS::icon_modedit, wxT( "icon_modedit_64.png" ), 64, wxT( "light" ) },
    { BITMAPS::icon_pcbnew, wxT( "icon_pcbnew_64.png" ), 64, wxT( "light" ) },
    { BITMAPS::icon_pagelayout_editor, wxT( "icon_pagelayout_editor_64.png" ), 64, wxT( "light" ) },
    { BITMAPS::icon_bitmap2component, wxT( "icon_bitmap2component_64.png" ), 64, wxT( "light" ) },
    { BITMAPS::icon_pcbcalculator, wxT( "icon_pcbcalculator_64.png" ), 64, wxT( "light" ) },
    { BITMAPS::icon_cvpcb, wxT( "icon_cvpcb_dark_64.png" ), 64, wxT( "dark" ) },
    { BITMAPS::icon_eeschema, wxT( "icon_eeschema_dark_64.png" ), 64, wxT( "dark" ) },
    { BITMAPS::icon_gerbview, wxT( "icon_gerbview_dark_64.png" ), 64, wxT( "dark" ) },
    { BITMAPS::icon_kicad, wxT( "icon_kicad_dark_64.png" ), 64, wxT( "dark" ) },
    { BITMAPS::icon_libedit, wxT( "icon_libedit_dark_64.png" ), 64, wxT( "dark" ) },
    { BITMAPS::icon_modedit, wxT( "icon_modedit_dark_64.png" ), 64, wxT( "dark" ) },
    { BITMAPS::icon_pcbnew, wxT( "icon_pcbnew_dark_64.png" ), 64, wxT( "dark" ) },
    { BITMAPS::icon_pagelayout_editor, wxT( "icon_pagelayout_editor_dark_64.png" ), 64, wxT( "dark" ) },
    { BITMAPS::icon_bitmap2component, wxT( "icon_bitmap2component_dark_64.png" ), 64, wxT( "dark" ) },
    { BITMAPS::icon_pcbcalculator, wxT( "icon_pcbcalculator_dark_64.png" ), 64, wxT( "dark" ) },
    { BITMAPS::icon_cvpcb, wxT( "icon_cvpcb_128.png" ), 128, wxT( "light" ) },
    { BITMAPS::icon_eeschema, wxT( "icon_eeschema_128.png" ), 128, wxT( "light" ) },
    { BITMAPS::icon_gerbview, wxT( "icon_gerbview_128.png" ), 128, wxT( "light" ) },
    { BITMAPS::icon_kicad, wxT( "icon_kicad_128.png" ), 128, wxT( "light" ) },
    { BITMAPS::icon_libedit, wxT( "icon_libedit_128.png" ), 128, wxT( "light" ) },
    { BITMAPS::icon_modedit, wxT( "icon_modedit_128.png" ), 128, wxT( "light" ) },
    { BITMAPS::icon_pcbnew, wxT( "icon_pcbnew_128.png" ), 128, wxT( "light" ) },
    { BITMAPS::icon_pagelayout_editor, wxT( "icon_pagelayout_editor_128.png" ), 128, wxT( "light" ) },
    { BITMAPS::icon_bitmap2component, wxT( "icon_bitmap2component_128.png" ), 128, wxT( "light" ) },
    { BITMAPS::icon_pcbcalculator, wxT( "icon_pcbcalculator_128.png" ), 128, wxT( "light" ) },
    { BITMAPS::icon_cvpcb, wxT( "icon_cvpcb_dark_128.png" ), 128, wxT( "dark" ) },
    { BITMAPS::icon_eeschema, wxT( "icon_eeschema_dark_128.png" ), 128, wxT( "dark" ) },
    { BITMAPS::icon_gerbview, wxT( "icon_gerbview_dark_128.png" ), 128, wxT( "dark" ) },
    { BITMAPS::icon_kicad, wxT( "icon_kicad_dark_128.png" ), 128, wxT( "dark" ) },
    { BITMAPS::icon_libedit, wxT( "icon_libedit_dark_128.png" ), 128, wxT( "dark" ) },
    { BITMAPS::icon_modedit, wxT( "icon_modedit_dark_128.png" ), 128, wxT( "dark" ) },
    { BITMAPS::icon_pcbnew, wxT( "icon_pcbnew_dark_128.png" ), 128, wxT( "dark" ) },
    { BITMAPS::icon_pagelayout_editor, wxT( "icon_pagelayout_editor_dark_128.png" ), 128, wxT( "dark" ) },
    { BITMAPS::icon_bitmap2component, wxT( "icon_bitmap2component_dark_128.png" ), 128, wxT( "dark" ) },
    { BITMAPS::icon_pcbcalculator, wxT( "icon_pcbcalculator_dark_128.png" ), 128, wxT( "dark" ) },
    { BITMAPS::dialog_warning, wxT( "dialog_warning_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::icon_3d, wxT( "icon_3d_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::icon_cvpcb, wxT( "icon_cvpcb_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::icon_eeschema, wxT( "icon_eeschema_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::icon_gerbview, wxT( "icon_gerbview_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::icon_kicad, wxT( "icon_kicad_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::icon_libedit, wxT( "icon_libedit_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::icon_modedit, wxT( "icon_modedit_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::icon_pcbnew, wxT( "icon_pcbnew_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::icon_bitmap2component, wxT( "icon_bitmap2component_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::icon_pagelayout_editor, wxT( "icon_pagelayout_editor_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::icon_pcbcalculator, wxT( "icon_pcbcalculator_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::icon_pcm, wxT( "icon_pcm_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::reannotate_down_left, wxT( "reannotate_down_left_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::reannotate_down_right, wxT( "reannotate_down_right_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::reannotate_left_down, wxT( "reannotate_left_down_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::reannotate_left_up, wxT( "reannotate_left_up_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::reannotate_right_down, wxT( "reannotate_right_down_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::reannotate_right_up, wxT( "reannotate_right_up_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::reannotate_up_left, wxT( "reannotate_up_left_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::reannotate_up_right, wxT( "reannotate_up_right_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::icon_pagelayout_editor, wxT( "icon_pagelayout_editor_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::wizard_add_fplib_icon, wxT( "wizard_add_fplib_icon_48.png" ), 48, wxT( "light" ) },
    { BITMAPS::dialog_warning, wxT( "dialog_warning_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::icon_3d, wxT( "icon_3d_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::icon_cvpcb, wxT( "icon_cvpcb_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::icon_eeschema, wxT( "icon_eeschema_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::icon_gerbview, wxT( "icon_gerbview_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::icon_kicad, wxT( "icon_kicad_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::icon_libedit, wxT( "icon_libedit_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::icon_modedit, wxT( "icon_modedit_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::icon_pcbnew, wxT( "icon_pcbnew_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::icon_bitmap2component, wxT( "icon_bitmap2component_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::icon_pagelayout_editor, wxT( "icon_pagelayout_editor_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::icon_pcbcalculator, wxT( "icon_pcbcalculator_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::icon_pcm, wxT( "icon_pcm_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::reannotate_down_left, wxT( "reannotate_down_left_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::reannotate_down_right, wxT( "reannotate_down_right_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::reannotate_left_down, wxT( "reannotate_left_down_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::reannotate_left_up, wxT( "reannotate_left_up_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::reannotate_right_down, wxT( "reannotate_right_down_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::reannotate_right_up, wxT( "reannotate_right_up_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::reannotate_up_left, wxT( "reannotate_up_left_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::reannotate_up_right, wxT( "reannotate_up_right_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::icon_pagelayout_editor, wxT( "icon_pagelayout_editor_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::wizard_add_fplib_icon, wxT( "wizard_add_fplib_icon_dark_48.png" ), 48, wxT( "dark" ) },
    { BITMAPS::att_bridge, wxT( "att_bridge.png" ), -1, wxT( "light" ) },
    { BITMAPS::att_pi, wxT( "att_pi.png" ), -1, wxT( "light" ) },
    { BITMAPS::att_splitter, wxT( "att_splitter.png" ), -1, wxT( "light" ) },
    { BITMAPS::att_tee, wxT( "att_tee.png" ), -1, wxT( "light" ) },
    { BITMAPS::c_microstrip, wxT( "c_microstrip.png" ), -1, wxT( "light" ) },
    { BITMAPS::coax, wxT( "coax.png" ), -1, wxT( "light" ) },
    { BITMAPS::color_code_multiplier, wxT( "color_code_multiplier.png" ), -1, wxT( "light" ) },
    { BITMAPS::color_code_tolerance, wxT( "color_code_tolerance.png" ), -1, wxT( "light" ) },
    { BITMAPS::color_code_value, wxT( "color_code_value.png" ), -1, wxT( "light" ) },
    { BITMAPS::color_code_value_and_name, wxT( "color_code_value_and_name.png" ), -1, wxT( "light" ) },
    { BITMAPS::cpw, wxT( "cpw.png" ), -1, wxT( "light" ) },
    { BITMAPS::cpw_back, wxT( "cpw_back.png" ), -1, wxT( "light" ) },
    { BITMAPS::microstrip, wxT( "microstrip.png" ), -1, wxT( "light" ) },
    { BITMAPS::microstrip_zodd_zeven, wxT( "microstrip_zodd_zeven.png" ), -1, wxT( "light" ) },
    { BITMAPS::pads_npth, wxT( "pads_npth.png" ), -1, wxT( "light" ) },
    { BITMAPS::pads_npth_bottom, wxT( "pads_npth_bottom.png" ), -1, wxT( "light" ) },
    { BITMAPS::pads_npth_top, wxT( "pads_npth_top.png" ), -1, wxT( "light" ) },
    { BITMAPS::pads_npth_top_bottom, wxT( "pads_npth_top_bottom.png" ), -1, wxT( "light" ) },
    { BITMAPS::pads_remove_unused, wxT( "pads_remove_unused.png" ), -1, wxT( "light" ) },
    { BITMAPS::pads_remove_unused_keep_bottom, wxT( "pads_remove_unused_keep_bottom.png" ), -1, wxT( "light" ) },
    { BITMAPS::pads_reset_unused, wxT( "pads_reset_unused.png" ), -1, wxT( "light" ) },
    { BITMAPS::rectwaveguide, wxT( "rectwaveguide.png" ), -1, wxT( "light" ) },
    { BITMAPS::regul, wxT( "regul.png" ), -1, wxT( "light" ) },
    { BITMAPS::regul_3pins, wxT( "regul_3pins.png" ), -1, wxT( "light" ) },
    { BITMAPS::stripline, wxT( "stripline.png" ), -1, wxT( "light" ) },
    { BITMAPS::stroke_dash, wxT( "stroke_dash.png" ), -1, wxT( "light" ) },
    { BITMAPS::stroke_dashdot, wxT( "stroke_dashdot.png" ), -1, wxT( "light" ) },
    { BITMAPS::stroke_dot, wxT( "stroke_dot.png" ), -1, wxT( "light" ) },
    { BITMAPS::stroke_solid, wxT( "stroke_solid.png" ), -1, wxT( "light" ) },
    { BITMAPS::tune_diff_pair_length_legend, wxT( "tune_diff_pair_length_legend.png" ), -1, wxT( "light" ) },
    { BITMAPS::tune_diff_pair_skew_legend, wxT( "tune_diff_pair_skew_legend.png" ), -1, wxT( "light" ) },
    { BITMAPS::tune_single_track_length_legend, wxT( "tune_single_track_length_legend.png" ), -1, wxT( "light" ) },
    { BITMAPS::twistedpair, wxT( "twistedpair.png" ), -1, wxT( "light" ) },
    { BITMAPS::viacalc, wxT( "viacalc.png" ), -1, wxT( "light" ) },
    { BITMAPS::att_bridge, wxT( "att_bridge_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::att_pi, wxT( "att_pi_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::att_splitter, wxT( "att_splitter_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::att_tee, wxT( "att_tee_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::c_microstrip, wxT( "c_microstrip_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::coax, wxT( "coax_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::color_code_multiplier, wxT( "color_code_multiplier_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::color_code_tolerance, wxT( "color_code_tolerance_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::color_code_value, wxT( "color_code_value_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::color_code_value_and_name, wxT( "color_code_value_and_name_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::cpw, wxT( "cpw_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::cpw_back, wxT( "cpw_back_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::microstrip, wxT( "microstrip_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::microstrip_zodd_zeven, wxT( "microstrip_zodd_zeven_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::pads_npth, wxT( "pads_npth_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::pads_npth_bottom, wxT( "pads_npth_bottom_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::pads_npth_top, wxT( "pads_npth_top_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::pads_npth_top_bottom, wxT( "pads_npth_top_bottom_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::pads_remove_unused, wxT( "pads_remove_unused_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::pads_remove_unused_keep_bottom, wxT( "pads_remove_unused_keep_bottom_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::pads_reset_unused, wxT( "pads_reset_unused_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::rectwaveguide, wxT( "rectwaveguide_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::regul, wxT( "regul_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::regul_3pins, wxT( "regul_3pins_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::stripline, wxT( "stripline_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::stroke_dash, wxT( "stroke_dash_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::stroke_dashdot, wxT( "stroke_dashdot_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::stroke_dot, wxT( "stroke_dot_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::stroke_solid, wxT( "stroke_solid_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::tune_diff_pair_length_legend, wxT( "tune_diff_pair_length_legend_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::tune_diff_pair_skew_legend, wxT( "tune_diff_pair_skew_legend_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::tune_single_track_length_legend, wxT( "tune_single_track_length_legend_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::twistedpair, wxT( "twistedpair_dark.png" ), -1, wxT( "dark" ) },
    { BITMAPS::viacalc, wxT( "viacalc_dark.png" ), -1, wxT( "dark" ) },

};

#endif // KICAD_BITMAP_INFO_H
