/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#ifndef CISCOCERTIFICATEENROLLMENT_H
#define CISCOCERTIFICATEENROLLMENT_H

//#define QWIZARD_QT4_PORT

#if defined(QWIZARD_QT4_PORT)
#include <QtGui/QWizard>
#else
#include <Qt3Support/Q3Wizard>
#endif

#include <QtCore/QProcess>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QTimer>

#include <kdialog.h>
#include <kprogressdialog.h>

#include "ciscocertificateenrollmentwidget.h"
#include "ciscocertificateenrollmentfinishwidget.h"
#include "ciscocertificateenrollmentdatadialog.h"
#include "kvpncconfig.h"

class QRadioButton;
class QLabel;
class KComboBox;
class KLineEdit;
class KUrlRequester;

#if defined(QWIZARD_QT4_PORT)
class CiscoCertificateEnrollment : public QWizard
{
    Q_OBJECT

public:
    enum CiscoCertificateEnrollmentPages {
        Page_Intro,
        Page_OnlineMethod,
        Page_FileMethod,
        Page_CertificateDetails,
        Page_Conclusion
    };

    CiscoCertificateEnrollment(const QString &text,
                               KVpncConfig *GlobalConfig = 0,
                               QWidget *parent = 0);
    ~CiscoCertificateEnrollment();

    void accept();
    void processStdOut();
    void processStdErr();

public slots:
    void slotReadyReadStdout();
    void slotReadyReadStderr();

private:
    KVpncConfig *globalConfiguration;
    int debugLevel;
    QString ciscoCertMgr;
    QProcess *ciscoCertMgrProcess;
    QByteArray stdoutbuf;
    QByteArray stderrbuf;
};

class IntroductionPage : public QWizardPage
{
    Q_OBJECT

public:
    IntroductionPage(KVpncConfig *GlobalConfig = 0, QWidget *parent = 0);

    int nextId() const;

private:
    KVpncConfig *globalConfiguration;
    int debugLevel;
    QLabel *topLabel;
    QRadioButton *onlineRadioButton;
    QRadioButton *fileRadioButton;
};

class OnlineMethodPage : public QWizardPage
{
    Q_OBJECT

public:
    OnlineMethodPage(KVpncConfig *GlobalConfig = 0, QWidget *parent = 0);

    int nextId() const;

private:
    KVpncConfig *globalConfiguration;
    int debugLevel;
    QLabel *caLabel;
    KComboBox *caComboBox;
    QLabel *caUrlLabel;
    KLineEdit *caUrlLineEdit;
    QLabel *caDomainLabel;
    KLineEdit *caDomainLineEdit;
    QLabel *caChallengePhraseLabel;
    KLineEdit *caChallengePhraseLineEdit;
};

class FileMethodPage : public QWizardPage
{
    Q_OBJECT

public:
    FileMethodPage(KVpncConfig *GlobalConfig = 0, QWidget *parent = 0);

    int nextId() const;

private:
    KVpncConfig *globalConfiguration;
    int debugLevel;
    QLabel *fileEncodingLabel;
    KComboBox *fileEncodingComboBox;
    QLabel *fileNameLabel;
    KUrlRequester *fileNameUrlRequester;
    QLabel *newPasswordLabel;
    KLineEdit *newPasswordLineEdit;
};

class CertificateDetailsPage : public QWizardPage
{
    Q_OBJECT

public:
    CertificateDetailsPage(KVpncConfig *GlobalConfig = 0, QWidget *parent = 0);

    int nextId() const;

private:
    KVpncConfig *globalConfiguration;
    int debugLevel;
    QLabel *commonNameLabel;
    KLineEdit *commonNameLineEdit;
    QLabel *organizationalUnitLabel;
    KLineEdit *organizationalUnitLineEdit;
    QLabel *organizationLabel;
    KLineEdit *organizationLineEdit;
    QLabel *stateLabel;
    KLineEdit *stateLineEdit;
    QLabel *countryLabel;
    KLineEdit *countryLineEdit;
    QLabel *emailLabel;
    KLineEdit *emailLineEdit;
    QLabel *ipAddressLabel;
    KLineEdit *ipAddressLineEdit;
    QLabel *domainNameLabel;
    KLineEdit *domainNameLineEdit;
};

class ConclusionPage : public QWizardPage
{
    Q_OBJECT

public:
    ConclusionPage(KVpncConfig *GlobalConfig = 0, QWidget *parent = 0);

    void initializePage();

private:
    KVpncConfig *globalConfiguration;
    int debugLevel;
    QLabel *label;
};
#else
class CiscoCertificateEnrollment : public Q3Wizard
{
    Q_OBJECT

public:
    CiscoCertificateEnrollment(const QString &text, KVpncConfig *GlobalConfig = 0, QWidget *parent = 0);
    ~CiscoCertificateEnrollment();

    QProcess *EnrollmentProcess;
    QProcess *DeleteProcess;
    KVpncConfig *GlobalConfig;
    bool done;
    bool finished;
    bool valuesOk;
    QStringList *env;

public slots:
    void accept();
    void canAccept();
    void enrollmentToggled(bool);
    void setupPages();
    void showPage(QWidget *page);
    void next();
    void back();
    void reject();
    void readFromStdout();
    void readFromStderr();
    void readFromStdout_cancel();
    void readFromStderr_cancel();
    void checkProgress();
    void enrollmentProcessFinished(int, QProcess::ExitStatus);
    void cancelProcessFinished(int, QProcess::ExitStatus);

public:
    CiscoCertificateEnrollmentWidget *selectionpage;
    CiscoCertificateEnrollmentDataDialog *datapage;
    CiscoCertificateEnrollmentFinishWidget *finishpage;
    QWidget* currentpage; // pointer to current page
    QWidget* previouspage; //< pointer to previous page
    KProgressDialog *ProgressDlg;

public:
    QString type;
    QString successmsg;
    int success;
    QString CA;
    QString CaUrl;
    QString ChallengePassword;
    QString CaDomain;
    QString FileEncoding;
    QString FilenameURL;
    QString Ip;
    QString State;
    QString Department;
    QString Company;
    QString Domain;
    QString Name;
    QString Email;
    QString Country;

private:
    QTimer CheckEnrollmentTimer;
};
#endif

#endif
