package latexDraw.generators.svg;

import latexDraw.figures.*;
import latexDraw.parsers.svg.SVGDocument;
import latexDraw.parsers.svg.elements.SVGElement;

/**
 * Creates SVG elements based on latexdraw.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 09/21/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 0.1<br>
 */
public class SVGShapesFactory
{
	public static SVGElement createSVGElement(Figure f, SVGDocument doc)
	{
		SVGElement elt = null;
		
		if(f!=null && doc!=null)
			try
			{
				if(f instanceof Square)
					elt = new LSquareSVGGenerator((Square)f).toSVG(doc);
				else if(f instanceof LaTeXDrawRectangle)
					elt = new LRectangleSVGGenerator((LaTeXDrawRectangle)f).toSVG(doc);
				else if(f instanceof Line)
					elt = new LLineSVGGenerator((Line)f).toSVG(doc);
				else if(f instanceof BezierCurve)
					elt = new LBezierCurveSVGGenerator((BezierCurve)f).toSVG(doc);
				else if(f instanceof Grid)
					elt = new LGridSVGGenerator((Grid)f).toSVG(doc);
				else if(f instanceof Axe)
					elt = new LAxeSVGGenerator((Axe)f).toSVG(doc);
				else if(f instanceof Rhombus)
					elt = new LRhombusSVGGenerator((Rhombus)f).toSVG(doc);
				else if(f instanceof Triangle)
					elt = new LTriangleSVGGenerator((Triangle)f).toSVG(doc);
				else if(f instanceof JoinedLines)
					elt = new LLinesSVGGenerator((JoinedLines)f).toSVG(doc);
				else if(f instanceof Dot)
					elt = new LDotSVGGenerator((Dot)f).toSVG(doc);
				else if(f instanceof AkinPoints)
					elt = new LFreeHandSVGGenerator((AkinPoints)f).toSVG(doc);
				else if(f instanceof Arc)
					elt = new LArcSVGGenerator((Arc)f).toSVG(doc);
				else if(f instanceof Circle)
					elt = new LCircleSVGGenerator((Circle)f).toSVG(doc);
				else if(f instanceof Ellipse)
					elt = new LEllipseSVGGenerator((Ellipse)f).toSVG(doc);
				else if(f instanceof Draw)
					elt = new LDrawingSVGGenerator((Draw)f).toSVG(doc);
				else if(f instanceof Picture)
					elt = new LPictureSVGGenerator((Picture)f).toSVG(doc);
				else if(f instanceof Text)
					elt = new LTextSVGGenerator((Text)f).toSVG(doc);
				else if(f instanceof LaTeXDrawPolygon)
					elt = new LPolygonSVGGenerator((LaTeXDrawPolygon)f).toSVG(doc);
			}
			catch(Exception e) { e.printStackTrace(); }
			
		return elt;
	}
}
